<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

require dirname(__FILE__) . '/define.php';

function my_autoloader($class_name): void
{
    $class_path = ROOT . 'boot/sub_classes/' . mb_strtolower($class_name) . '.class.php';
    $class_path = str_replace("\\", "/", $class_path);
    if (file_exists($class_path)) require_once($class_path);
}

spl_autoload_register('my_autoloader');

global $config, $core, $url;
require ROOT . 'etc/global.config.php';
require ROOT . 'etc/admin.config.php';
require ROOT . 'etc/security.config.php';
require ROOT . 'etc/files.config.php';
require ROOT . 'etc/smiles.config.php';
require ROOT . 'etc/user.config.php';
require ROOT . 'lib/php_funcs.php';
require ROOT . 'lib/global.php';
require ROOT . 'root/ajax_funcs.php';
require ROOT . 'lib/for_ajax.php';
require ROOT . 'boot/db/' . $config['dbType'] . '.db.php';
require ROOT . 'boot/db' . (($config['dbCache'] == 1) ? '_cache' : '') . '.class.php';
require ROOT . 'boot/auth.class.php';
require ROOT . 'boot/template.class.php';
$cache = new cache;
require ROOT . 'boot/core.class.php';
$core->initCore();
$core->LoadLang(false, true);
header('Content-type: text/plain; charset=utf-8');
$do = $_GET['do'] ?? '';
$GLOBALS['url'][0] = 'ajax';
$tempLink = explode('/', $do);
for ($i = 0, $max = count($tempLink); $i < $max; $i++) {
    if ($tempLink[$i] == '') {
        continue;
    } else {
        $GLOBALS['url'][] = filter($tempLink[$i], 'url');
    }
}
$op = $url[2] ?? 0;
$do = $url[3] ?? 0;
$allowFuncs = array('draw_rating', 'boardDraw_rating', 'set_rating', 'fast_edit', 'fast_save', 'add_comment', 'show_comments', 'show_user_wall', 'checkCommentGuest', 'commentDeleteAjax', 'commentPage', 'wallPage', 'comment_savea', 'commentEditAjax', 'commentEditAjaxSave', 'check_login', 'check_email', 'smile_icon', 'board_icon', 'alt_title', 'alt_btitle', 'alt_redir', 'alt_cats', 'alt_tagcode', 'alt_rssinform', 'alt_domen', 'cal', 'online', 'searchList', 'searchNewsList', 'ajaxPoll', 'addCarma', 'editTitle', 'fileList', 'loginList', 'getTranslit', 'getCatByModule', 'blockStatus', 'userDeleteBlock', 'fullAjax', 'blockList', 'catsUp', 'catsDown', 'catsList', 'setBlockStatus', 'setCommentStatus', 'deleteBlock', 'moveUp', 'moveDown', 'captcha', 'carmaHistory', 'genRating', 'commentSubscribe', 'wallSubscribe', 'friendsAjax', 'vote', 'inputTags', 'getPreview', 'getContentPreview', 'carma_vote', 'board_carma_vote');
switch ($url[1] ?? null) {
    default:
        return in_array($url[1], $allowFuncs) ? $url[1]() : $url[1];
    case 'calendar':
        cal($op);
        break;
    case 'version':
        version_check();
        break;
    case 'captcha_reload':
        echo captcha_image(false);
        break;
    case 'poll':
        ajaxPoll();
        break;
        if (is_array($core->tpl->headerIncludes)) {
            foreach ($core->tpl->headerIncludes as $metas) {
                if ($metas) echo $metas;
            }
        }
}