<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

require dirname(__FILE__) . '/define.php';
session_start();
require ROOT . 'boot/sub_classes/socialauther/autoload.php';
require ROOT . 'etc/social.config.php';
require ROOT . 'etc/global.config.php';
global $config, $social;
header("Content-Type: text/html; charset=utf-8");
$adapterConfigs = array(
    'vk' => array(
        'client_id' => $social['vk_client_id'],
        'client_secret' => $social['vk_client_secret'],
        'redirect_uri' => $config['url'] . '/auth.php?provider=vk'
    ),
    'odnoklassniki' => array(
        'client_id' => $social['ok_client_id'],
        'client_secret' => $social['ok_client_secret'],
        'redirect_uri' => $config['url'] . '/auth?provider=odnoklassniki',
        'public_key' => $social['ok_public_key']
    ),
    'mailru' => array(
        'client_id' => $social['mm_client_id'],
        'client_secret' => $social['mm_client_secret'],
        'redirect_uri' => $config['url'] . '/auth.php?provider=mailru'
    ),
    'yandex' => array(
        'client_id' => $social['ya_client_id'],
        'client_secret' => $social['ya_client_secret'],
        'redirect_uri' => $config['url'] . '/auth.php?provider=yandex'
    ),
    'google' => array(
        'client_id' => $social['gg_client_id'],
        'client_secret' => $social['gg_client_secret'],
        'redirect_uri' => $config['url'] . '/auth.php?provider=google'
    ),
    'facebook' => array(
        'client_id' => $social['fb_client_id'],
        'client_secret' => $social['fb_client_secret'],
        'redirect_uri' => $config['url'] . '/auth.php?provider=facebook'
    ),
);
function redicret($url = 'news'): void
{
    $full_url = $url;
    include(ROOT . 'usr/tpl/redirect.tpl');
}

$adapters = array();
foreach ($adapterConfigs as $adapter => $settings) {
    $class = 'SocialAuther\Adapter\\' . ucfirst($adapter);
    $adapters[$adapter] = new $class($settings);
}
if (isset($_GET['provider']) && array_key_exists($_GET['provider'], $adapters) && !isset($_SESSION['user_auth'])) {
    $auther = new SocialAuther\SocialAuther($adapters[$_GET['provider']]);
    if ($auther->authenticate()) {
        $values = array(
            $auther->getProvider(),
            $auther->getSocialId(),
            $auther->getName(),
            $auther->getfName(),
            $auther->getlName(),
            $auther->getCity(),
            $auther->getCountry(),
            $auther->getWebsite(),
            $auther->getAbout(),
            $auther->getEmail(),
            $auther->getNick(),
            $auther->getSocialPage(),
            $auther->getSex(),
            $auther->getBirthday(),
            $auther->getBday(),
            $auther->getBmonth(),
            $auther->getByear(),
            $auther->getAvatar(),
            $auther->getPhone(),
        );
        $user = new stdClass();
        $user->provider = $auther->getProvider();
        $user->socialId = $auther->getSocialId();
        $user->name = $auther->getName();
        $user->first_name = $auther->getfName();
        $user->last_name = $auther->getlName();
        $user->city = $auther->getCity();
        $user->country = $auther->getCountry();
        $user->website = $auther->getWebsite();
        $user->about = $auther->getAbout();
        $user->email = $auther->getEmail();
        $user->nick = $auther->getNick();
        $user->socialPage = $auther->getSocialPage();
        $user->sex = $auther->getSex();
        $user->birthday = $auther->getBirthday();
        $user->bday = $auther->getBday();
        $user->bmonth = $auther->getBmonth();
        $user->byear = $auther->getByear();
        $user->avatar = $auther->getAvatar();
        $user->phone = $auther->getPhone();
        $_SESSION['user_auth'] = $user;
        if ($config['redicret'] == 0) {
            header("refresh: 0; url=" . $config['url'] . "/profile/social_auth");
        } else {
            redicret('/profile/social_auth');
        }
    } else {
        if ($config['redicret'] == 0) {
            header("refresh: 0; url=" . $config['url']);
        } else {
            redicret('/index.php');
        }
    }
} elseif (isset($_GET['url']) && array_key_exists($_GET['url'], $adapters) && !isset($_SESSION['user_auth'])) {
    $url = ucfirst($_GET['url']);
    foreach ($adapters as $title => $adapter) {
        if (ucfirst($title) == $url) header('Location: ' . $adapter->getAuthUrl());
    }
} else {
    if (isset($_SESSION['user_auth'])) {
        header('Location: /profile/social_auth');
    } else {
        header('Location: /index.php');
    }
    session_start();
    $_SESSION = array();
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    session_destroy();
}