<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */
class cache_lib
{
    var mixed $identifier;

    function cache_lib($identifier = '')
    {
        $this->identifier = (!$identifier) ? md5(uniqid(rand(), TRUE)) : $identifier;
        unset($identifier);
    }

    function disconnect(): true
    {
        return TRUE;
    }

    function do_put($key, $value, $ttl = 0): void
    {
        $ttl = $ttl > 0 ? intval($ttl) : 0;
        apc_store($this->identifier . md5($key), $value, $ttl);
    }

    function do_get($key)
    {
        return apc_fetch($this->identifier . md5($key));
    }

    function do_remove($key): void
    {
        apc_delete($this->identifier . md5($key));
    }
}
