<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */
class cache_lib
{
    var mixed $identifier;

    function cache_lib($identifier = '')
    {
        $this->identifier = (!$identifier) ? md5(uniqid(rand(), TRUE)) : $identifier;
        unset($identifier);
    }

    function disconnect(): true
    {
        return TRUE;
    }

    function do_put($key, $value, $ttl = 0): void
    {
        mmcache_lock($this->identifier . md5($key));
        mmcache_put($this->identifier . md5($key), $value, intval($ttl));
        mmcache_unlock($this->identifier . md5($key));
    }

    function do_get($key)
    {
        return mmcache_get($this->identifier . md5($key));
    }

    function do_remove($key): void
    {
        mmcache_rm($this->identifier . md5($key));
    }
}

