<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}

class dateBase extends controlDB
{
    var string $prefix = '';

    public function __construct()
    {
        global $config;
        require_once ROOT . 'etc/db.config.php';
        parent::connect($dbhost, $dbuser, $dbpass, $dbname);
        define("DB_PREFIX", $prefix);
        define("USER_PREFIX", $user_prefix);
        define("USER_DB", $user_db);
        define("CHARSET", $config['charset']);
        unset($dbhost, $dbuser, $dbpass, $prefix, $user_prefix, $user_db, $config['charset']);
    }

    public function query($str, $ignoreError = false)
    {
        return parent::doQuery($str, $ignoreError, $this->prefix);
    }

    function safesql($str): string
    {
        return parent::safesql($str);
    }

    public function freeResult($resource): string|bool
    {
        return parent::freeResult($resource);
    }

    public function getRow($resource): false|array|null
    {
        return parent::getRow($resource);
    }

    public function fetchRow($resource): false|array|null
    {
        return parent::fetchRow($resource);
    }

    public function numRows($resource): false|int|string
    {
        return parent::numRows($resource);
    }
}

$db = new dateBase();