<?php
/*
 * @name        JMY CMS
 * @link        http://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

use PHPMailer\PHPMailer\PHPMailer;
if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
global $config;
require ROOT . 'boot/mail/class.phpmailer.php';
require ROOT . 'boot/mail/class.smtp.php';
require ROOT . 'boot/mail/class.exception.php';
require ROOT . 'etc/global.config.php';
class jmy_mail
{
    public $mail = false;
    public $send_error = false;
    public $smtp_msg = "";
    public $from = false;
    public $html_mail = false;
    public $bcc = array();
    public $keepalive = false;
    function __construct($config, $is_html = false)
    {
        $this->mail = new PHPMailer(true);
        $this->mail->CharSet = $config['charset'];
        $this->mail->Encoding = "base64";
        $config['name'] = str_replace('&amp;', '&', $config['name']);
        if ($config['name']) {
            try {
                $this->mail->setFrom($config['support_mail'], $config['name']);
            } catch (\PHPMailer\PHPMailer\Exception $e) {
            }
        } else {
            try {
                $this->mail->setFrom($config['support_mail']);
            } catch (\PHPMailer\PHPMailer\Exception $e) {
            }
        }
        if ($config['smtp_php'] == "smtp") {
            $this->mail->isSMTP();
            $this->mail->Timeout = 10;
            $this->mail->SMTPAutoTLS = false;
            $this->mail->Host = $config['smtp_host'];
            $this->mail->Port = intval($config['smtp_port']);
            $this->mail->SMTPSecure = $config['smtp_secure'];
            if ($this->mail->SMTPSecure == 'ssl') $this->mail->SMTPOptions = str_replace(array("ssl"), array("verify_peer" => false, "verify_peer_name" => false));
            if ($this->mail->SMTPSecure == 'tls') $this->mail->SMTPOptions = str_replace(array("ssl"), array("verify_peer" => false, "verify_peer_name" => false));
            if ($config['smtp_user']) {
                $this->mail->SMTPAuth = true;
                $this->mail->Username = $config['smtp_user'];
                $this->mail->Password = $config['smtp_pass'];
            }
            if ($config['support_mail']) {
                $this->mail->From = $config['support_mail'];
                $this->mail->Sender = $config['support_mail'];
            }
        }
        $this->mail->XMailer = "JMY CMS";
        if ($is_html) {
            $this->mail->isHTML();
            $this->html_mail = true;
        }
    }
    function send($mailTo, $subject, $message): void
    {
        if ($this->from) $this->mail->addReplyTo($this->from, $this->from);
        $this->mail->addAddress($mailTo);
        $this->mail->Subject = $subject;
        if ($this->mail->Mailer == 'smtp' and $this->keepalive) $this->mail->SMTPKeepAlive = true;
        if ($this->html_mail) {
            $this->mail->msgHTML($message);
        } else {
            $this->mail->Body = $message;
        }
        if (count($this->bcc)) {
            foreach ($this->bcc as $bcc) {
                $this->mail->addBCC($bcc);
            }
        }
        try {
            try {
                if (!$this->mail->send()) {
                    $this->smtp_msg = $this->mail->ErrorInfo;
                    $this->send_error = true;
                }
            } catch (\PHPMailer\PHPMailer\Exception $e) {
            }
        } catch (phpmailerException $e) {
        }
        $this->mail->clearAllRecipients();
        $this->mail->clearAttachments();
    }
    function addAttachment($path, $name = '', $encoding = 'base64', $type = '', $disposition = 'attachment'): void
    {
        try {
            try {
                $this->mail->addAttachment($path, $name, $encoding, $type, $disposition);
            } catch (\PHPMailer\PHPMailer\Exception $e) {
            }
        } catch (phpmailerException $e) {
        }
    }
}