<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}


class Counter
{
    var $origin_arr;
    var $modif_arr;
    var $min_word_length = 3;

    function get_keywords($text)
    {
        $this->explode_str_on_words($text);
        $this->count_words();
        $arr = array_slice($this->modif_arr, 0, 30);
        $str = "";
        foreach ($arr as $key => $val) {
            $str .= $key . ", ";
        }
        return trim(mb_substr($str, 0, mb_strlen($str) - 2));
    }

    function explode_str_on_words($text)
    {
        global $lang;
        $search = array("'ё'",
            "'<script[^>]*?>.*?</script>'si",
            "'<[\/\!]*?[^<>]*?>'si",
            "'([\r\n])[\s]+'",
            "'&(quot|#34);'i",
            "'&(amp|#38);'i",
            "'&(lt|#60);'i",
            "'&(gt|#62);'i",
            "'&(nbsp|#160);'i",
            "'&(iexcl|#161);'i",
            "'&(cent|#162);'i",
            "'&(pound|#163);'i",
            "'&(copy|#169);'i");
        $replace = array("е",
            " ",
            " ",
            "\\1 ",
            "\" ",
            " ",
            " ",
            " ",
            " ",
            chr(161),
            chr(162),
            chr(163),
            chr(169),
            "");
        $text = preg_replace($search, $replace, $text);
        $text = preg_replace_callback("'&#(\d+);'", function ($match) {
            return chr($match[1]);
        }, $text);
        $del_symbols = array(",", ".", ";", ":", "\"", "#", "\$", "%", "^",
            "!", "@", "`", "~", "*", "-", "=", "+", "\\",
            "|", "/", ">", "<", "(", ")", "&", "?", "?", "\t",
            "\r", "\n", "{", "}", "[", "]", "'", "“", "”", "•",
            "" . $lang['c_1'] . "", "" . $lang['c_2'] . "", "" . $lang['c_3'] . "", "" . $lang['c_4'] . "", "" . $lang['c_5'] . "", "" . $lang['c_6'] . "",
            "" . $lang['c_7'] . "", "" . $lang['c_8'] . "", "" . $lang['c_9'] . "", "" . $lang['c_10'] . "", "" . $lang['c_11'] . "", "" . $lang['c_12'] . "",
            "" . $lang['c_13'] . "", "" . $lang['c_14'] . "", "" . $lang['c_15'] . "", "" . $lang['c_16'] . "", "" . $lang['c_17'] . "", "" . $lang['c_18'] . "",
            "" . $lang['c_19'] . "", "" . $lang['c_20'] . "", "" . $lang['c_21'] . "", "" . $lang['c_22'] . "", "" . $lang['c_23'] . "", "" . $lang['c_24'] . "",
            "" . $lang['c_25'] . "", "" . $lang['c_26'] . "", "" . $lang['c_27'] . "", "" . $lang['c_28'] . "", "" . $lang['c_29'] . "", "" . $lang['c_30'] . "",
            "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
        );
        $text = str_replace($del_symbols, array(" "), $text);
        $this->origin_arr = explode(" ", trim($text));
        return $this->origin_arr;
    }

    function count_words()
    {
        $tmp_arr = array();
        foreach ($this->origin_arr as $val) {
            if (mb_strlen($val) >= $this->min_word_length) {
                $val = mb_strtolower($val);
                if (array_key_exists($val, $tmp_arr)) {
                    $tmp_arr[$val]++;
                } else {
                    $tmp_arr[$val] = 1;
                }
            }
        }
        arsort($tmp_arr);
        $this->modif_arr = $tmp_arr;
    }
}