<?php

namespace SocialAuther\Adapter;
class Vk extends AbstractAdapter
{
    public function __construct($config)
    {
        parent::__construct($config);
        $this->socialFieldsMap = array(
            'socialId' => 'id',
            'email' => 'email',
            'avatar' => 'photo_big',
            'birthday' => 'bdate'
        );
        $this->provider = 'vk';
    }

    /*
     * Get user name or null if it is not set
     *
     * @return string|null
     */
    public function getName()
    {
        $result = null;
        if (isset($this->userInfo['first_name']) && isset($this->userInfo['last_name'])) {
            $result = $this->userInfo['first_name'] . ' ' . $this->userInfo['last_name'];
        } elseif (isset($this->userInfo['first_name']) && !isset($this->userInfo['last_name'])) {
            $result = $this->userInfo['first_name'];
        } elseif (!isset($this->userInfo['first_name']) && isset($this->userInfo['last_name'])) {
            $result = $this->userInfo['last_name'];
        }
        return $result;
    }

    /*
     * Get user first_name or null if it is not set
     *
     * @return string|null
     */
    public function getfName()
    {
        $result = null;
        if (isset($this->userInfo['first_name'])) {
            $result = $this->userInfo['first_name'];
        }
        return $result;
    }

    /*
     * Get user nickname or null if it is not set
     *
     * @return string|null
     */
    public function getNick()
    {
        $result = null;
        if (isset($this->userInfo['nickname'])) $result = $this->userInfo['nickname'];
        return $result;
    }

    /*
     * Get user last_name or null if it is not set
     *
     * @return string|null
     */
    public function getlName()
    {
        $result = null;
        if (isset($this->userInfo['last_name'])) $result = $this->userInfo['last_name'];
        return $result;
    }

    /*
     * Get user skype or null if it is not set
     *
     * @return string|null
     */
    public function getConnections()
    {
        $result = null;
        if (isset($this->userInfo['connections']['skype'])) $result = $this->userInfo['connections']['skype'];
        return $result;
    }

    /*
     * Get user website or null if it is not set
     *
     * @return string|null
     */
    public function getWebsite()
    {
        $result = null;
        if (isset($this->userInfo['site'])) $result = $this->userInfo['site'];
        return $result;
    }

    /*
     * Get user about or null if it is not set
     *
     * @return string|null
     */
    public function getAbout()
    {
        $result = null;
        if (isset($this->userInfo['about'])) $result = $this->userInfo['about'];
        return $result;
    }

    /*
     * Get user city or null if it is not set
     *
     * @return string|null
     */
    public function getCity()
    {
        $result = null;
        if (isset($this->userInfo['city']['title'])) $result = $this->userInfo['city']['title'];
        return $result;
    }

    /*
     * Get user country or null if it is not set
     *
     * @return string|null
     */
    public function getСountry(): ?string
    {
        $result = null;
        if (isset($this->userInfo['сountry']['title'])) $result = $this->userInfo['сountry']['title'];
        return $result;
    }

    /*
     * Get user social id or null if it is not set
     *
     * @return string|null
     */
    public function getSocialPage(): ?string
    {
        $result = null;
        if (isset($this->userInfo['screen_name'])) $result = 'https://vk.com/' . $this->userInfo['screen_name'];
        return $result;
    }

    /*
     * Get user email or null if it is not set
     *
     * @return string|null
     */
    public function getEmail()
    {
        $result = null;
        if (isset($this->userInfo['email'])) $result = $this->userInfo['email'];
        return $result;
    }

    /*
     * Get user phone or null if it is not set
     *
     * @return string|null
     */
    public function getPhone()
    {
        $result = null;
        if (isset($this->userInfo['phone'])) $result = $this->userInfo['phone'];
        return $result;
    }

    /*
     * Get user birthday or null if it is not set
     *
     * @return string|null
     */
    public function getBirthday()
    {
        $result = null;
        if (isset($this->userInfo['bdate'])) $result = $this->userInfo['bdate'];
        return $result;
    }

    public function getBdate()
    {
        $result = null;
        if (isset($this->userInfo['bdate'])) $result = $this->userInfo['bdate'];
        return $result;
    }

    public function getBday(): ?string
    {
        $result = null;
        if (isset($this->userInfo['bdate'])) $result = date('d', strtotime($this->userInfo['bdate']));
        return $result;
    }

    public function getBmonth(): ?string
    {
        $result = null;
        if (isset($this->userInfo['bdate'])) $result = date('m', strtotime($this->userInfo['bdate']));
        return $result;
    }

    public function getByear(): ?string
    {
        $result = null;
        if (isset($this->userInfo['bdate'])) $result = date('Y', strtotime($this->userInfo['bdate']));
        return $result;
    }

    /*
     * Get user sex or null if it is not set
     *
     * @return string|null
     */
    public function getSex(): ?string
    {
        $result = null;
        if (isset($this->userInfo['sex'])) $result = $this->userInfo['sex'] == 1 ? 'female' : 'male';
        return $result;
    }

    /*
     * Authenticate and return bool result of authentication
     *
     * @return bool
     */
    public function authenticate(): bool
    {
        $result = false;
        if (isset($_GET['code'])) {
            $params = array(
                'client_id' => $this->clientId,
                'client_secret' => $this->clientSecret,
                'code' => $_GET['code'],
                'redirect_uri' => $this->redirectUri
            );
            $tokenInfo = $this->get('https://oauth.vk.com/access_token', $params);
            if (isset($tokenInfo['access_token'])) {
                $params = array(
                    'user_ids' => $tokenInfo['user_id'],
                    'v' => '5.95',
                    'scope' => 'notify,email',
                    'fields' => 'uid,first_name,last_name,screen_name,sex,bdate,photo_big,city,site,about,nickname,email,skype,phone',
                    'access_token' => $tokenInfo['access_token']
                );
                $userInfo = $this->get('https://api.vk.com/method/users.get', $params);
                if (isset($userInfo['response'][0]['id'])) {
                    $userInfo['response'][0]['email'] = $tokenInfo['email'];
                    $this->userInfo = $userInfo['response'][0];
                    $result = true;
                }
            }
        }
        return $result;
    }

    /*
     * Prepare params for authentication url
     *
     * @return array
     */
    public function prepareAuthParams(): array
    {
        return array(
            'auth_url' => 'https://oauth.vk.com/authorize',
            'auth_params' => array(
                'client_id' => $this->clientId,
                'scope' => 'notify,email',
                'redirect_uri' => $this->redirectUri,
                'response_type' => 'code',
                'v' => '5.80',
            )
        );
    }
}