<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

require dirname(__FILE__) . '/define.php';
require_once ROOT . 'lib/php_funcs.php';
require_once ROOT . 'lib/global.php';
require_once ROOT . 'root/functions.php';
$lang = array();
$langs = !empty($_COOKIE['jmy_lang']) ? $_COOKIE['jmy_lang'] : 'ru';
require_once ROOT . 'langs/' . $langs . '/' . $langs . '.admin.lng';
if (file_exists(ROOT . 'install/langs/' . $langs . '/' . $langs . '.install.lng')) include(ROOT . 'install/langs/' . $langs . '/' . $langs . '.install.lng');
function head(): void
{
    ob_start();
}

function foot($n_p = null, $header = true): void
{
    global $information, $title, $lang;
    $content = ob_get_contents();
    ob_end_clean();
    $meta = '';
    $img_bar = '';
    $nav_bar = '';
    $step_bar_0 = '';
    $step_bar_1 = '';
    $step_bar_2 = '';
    $step_bar_3 = '';
    $step_bar_4 = '';
    switch ($_GET['step'] ?? null) {
        default:
            $step = $lang['step_1'];
            break;
        case 'language_set_ru':
            $step = $lang['step_1_1'];
            $step_bar_0 = '1';
            $meta = '<meta http-equiv="refresh" content="0; URL=\'/install.php?step=license_set\'"/>';
            break;
        case 'language_set_en':
            $step = $lang['step_1_2'];
            $step_bar_0 = '1';
            $meta = '<meta http-equiv="refresh" content="0; URL=\'/install.php?step=license_set\'"/>';
            break;
        case 'license_set':
            $step = $lang['step_0_agreement'];
            $step_bar_0 = '1';
            $step_bar_1 = '2';
            break;
        case 'php_set':
            $step = $lang['step_1_php'];
            $step_bar_0 = '1';
            $step_bar_1 = '1';
            $step_bar_2 = '2';
            break;
        case '1':
            $step = $lang['step_1_title'];
            $step_bar_0 = '1';
            $step_bar_1 = '1';
            $step_bar_2 = '2';
            break;
        case '2':
            $step = $lang['step_2_title'];
            $step_bar_0 = '1';
            $step_bar_1 = '1';
            $step_bar_2 = '1';
            $step_bar_3 = '2';
            break;
        case 'chmod':
            $step = $lang['chmod_title'];
            $step_bar_0 = '1';
            $step_bar_1 = '1';
            $step_bar_2 = '1';
            $step_bar_3 = '1';
            $step_bar_4 = '2';
            break;
        case '3':
            $step = $lang['step_3_title'];
            $step_bar_0 = '1';
            $step_bar_1 = '1';
            $step_bar_2 = '1';
            $step_bar_3 = '1';
            $step_bar_4 = '1';
            break;
        case '4':
            $step = $lang['step_4_title'];
            $step_bar_0 = '1';
            $step_bar_1 = '1';
            $step_bar_2 = '1';
            $step_bar_3 = '1';
            $step_bar_4 = '1';
            break;
        case '5':
            $step = $lang['step_5_title'];
            $step_bar_0 = '1';
            $step_bar_1 = '1';
            $step_bar_2 = '1';
            $step_bar_3 = '1';
            $step_bar_4 = '1';
            break;
    }
    function step_bar($step_bar): string
    {
        $bar_done = 'circle';
        if (isset($step_bar)) {
            switch ($step_bar) {
                case '1':
                    $bar_done = 'circle done';
                    break;
                case '2':
                    $bar_done = 'circle active';
                    break;
                case '3':
                    $bar_done = 'circle warning';
                    break;
            }
        }
        return $bar_done;
    }

    $bars = '<div class="progresses">
   <div class="' . step_bar($step_bar_0) . '">
      <span class="label label-numb">1</span>
      <span class="title">' . $lang['step_bar_language'] . '</span>
   </div>
   <span class="bar done"></span>
   <div class="' . step_bar($step_bar_1) . '">
      <span class="label label-numb">2</span>
      <span class="title">' . $lang['step_bar_consent'] . '</span>
   </div>
   <span class="bar half"></span>
   <div class="' . step_bar($step_bar_2) . '">
      <span class="label label-numb">3</span>
      <span class="title">' . $lang['step_bar_mysql'] . '</span>
   </div>
   <span class="bar"></span>
   <div class="' . step_bar($step_bar_3) . '">
      <span class="label label-numb">4</span>
      <span class="title">' . $lang['step_bar_files'] . '</span>
   </div>
   <span class="bar"></span>
   <div class="' . step_bar($step_bar_4) . '">
      <span class="label label-numb">5</span>
      <span class="title">' . $lang['step_bar_finish'] . '</span>
   </div>
</div>';
    $html = file_get_contents('install/tpl/install.html');
    $html = str_replace('{%META%}', $meta, $html);
    $html = str_replace('{%CONTENT%}', $content, $html);
    $html = str_replace('{%THEME%}', '/install/tpl', $html);
    $html = str_replace('{%URL%}', $_SERVER['HTTP_HOST'], $html);
    $html = str_replace('{%VERSION%}', VERSION_ID, $html);
    $html = str_replace('{%JVERSION%}', str_replace('{%VERSION%}', VERSION_ID, $lang['jversion']), $html);
    $html = str_replace('{%D_YEAR%}', date("Y"), $html);
    $html = str_replace('{%LICENSE%}', $lang['licence'], $html);
    $html = str_replace('{%INFORMATION%}', $information ?? '', $html);
    $html = str_replace('{%STEP%}', $step, $html);
    $html = str_replace('{%BARS%}', $bars, $html);
    $html = str_replace('{%IMG_BAR%}', $img_bar, $html);
    $html = str_replace('{%TITLE%}', $title . $lang['install_jmy'], $html);
    $html = str_replace('{%NAV_BAR%}', '<b>' . $nav_bar . '</b>', $html);
    $html = str_replace('{%NO_PADDING%}', $n_p ?? '', $html);
    $html = str_replace('{%HEAD_VIEW%}', ($header) ? 'block' : 'none', $html);
    $html = str_replace('{%Copyright%}', str_replace('{%VERSION%}', VERSION_ID, (str_replace('{%D_YEAR%}', date("Y"), (str_replace('{%LICENSE%}', $lang['licence'], $lang['Copyright']))))), $html);
    echo $html;
}

function language(): void
{
    global $title, $lang;
    $title = $lang['language_choose'] . ' | ';
    head();
    alert_install_info('info', $lang['language_continue']);
    echo '<div class="col-xs-12 pln p15">
   <div class="plan-price text-center">
      <div class="col-sm-6">
         <section class="panel no-border profile-panel overflow-hidden">
            <div class="panel-body bg-ccc">
               <div class="watermark fa fa-globe"></div>
               <div class="mg-b-sm text-center text-white">
                  <div class="mg-b-md">
                     <img src="install/tpl/images/ru.png" class="avatar bordered-avatar img-circle pic" alt="' . $lang['language_ru'] . '" title="' . $lang['language_ru'] . '">
                  </div>
                  <p class="mb5 mt5">' . $lang['language_ru'] . '</P>
                  <small>' . $lang['language_ru_author'] . '</small>
               </div>
            </div>
         </section>
         <div class="text-center bg-white no-border">
            <button type="button"  ' . btn_class('system', 'block', true, '385') . ' onclick="window.location=\'install.php?step=language_set_ru\';" />' . $lang['install_resume'] . '</button>
         </div>
      </div>
      <div class="col-sm-6">
         <section class="panel no-border profile-panel overflow-hidden">
            <div class="panel-body bg-ccc">
               <div class="watermark fa fa-globe"></div>
               <div class="mg-b-sm text-center text-white">
                  <div class="mg-b-md">
                     <img src="install/tpl/images/en.png" class="avatar bordered-avatar img-circle pic" alt="' . $lang['language_en'] . '" title="' . $lang['language_en'] . '">
                  </div>
                  <p class="mb5 mt5">' . $lang['language_en'] . '</p>
                  <small>' . $lang['language_en_author'] . '</small>
               </div>
            </div>
         </section>
         <div class="text-center bg-white no-border">
            <button type="button"  ' . btn_class('system', 'block', true, '385') . ' onclick="window.location=\'install.php?step=language_set_en\';" />' . $lang['install_continue'] . '</button>
         </div>
         <div class="p5"></div>
      </div>
   </div>
</div>
</div>';
    foot(null, false);
}

function language_set($ll = 'ru'): void
{
    global $title, $lang;
    setcookie("jmy_lang", $ll, time() + 3600);
    $title = $lang['install_language'] . ' | ';
    head();
    echo $lang['install_language_preferences'] . '<br/><br/>';
    echo '<div style="text-align:center">
   <button type="button" ' . btn_class('system', 'block', true, '385') . ' onclick="window.location=\'install.php?step=license_set\';" />' . $lang['install_tap_continue'] . '</button>
</div>';
    foot();
}

function license(): void
{
    global $title, $lang, $langs;
    $title = $lang['step_0_agreement'] . ' | ';
    head();
    alert_install_info('info', $lang['step_0_welcome_text']);
    echo '<script type="text/javascript">
   var Textarea=document.getElementById("Editor1");
   var Container=document.createElement("DIV");
   Textarea.parentNode.insertBefore(Container, Textarea);
   Container.appendChild(Textarea);
   Textarea.style.display=\'none\';
   var iframe="<iframe src=\'javascript: document.open(); document.domain=\'" + document.domain + "\'; document.close();\" frameborder=\'0\' align=\'center\' scrolling=\'auto\' marginwidth=\'15\' marginheight=\'15\'></iframe>";
   Container.innerHTML=iframe + Container.innerHTML;
   var Frame=Container.childNodes[0];
   var isIE=/*@cc_on!@*/false;
   var FrameDoc=isIE ? Frame.contentWindow.document : Frame.contentDocument;
   FrameDoc.open();
   FrameDoc.write(\'<html><head></head><body>\' + Textarea.value + \'&nbsp;</body></html>\');
   FrameDoc.close();
   FrameDoc.designMode="on";
   Frame.contentWindow.focus();
</script>
<div class="panel-body table-responsive">
   <div class="col-xs-12">
      <div id="Div">
         <iframe class="iframeAdaptive" style="border: 1px solid #76774C; background-color: #FDFDD3; padding: 5px; overflow: auto; width: 750px; min-width: 50%; max-width: 100%; height : 345px; min-height : 50%; max-height : 100%;  margin:0 auto;" src="' . $lang['jmycmsck'] . 'license.php?langs=_' . $langs . '"  allowtransparency="true" allowFullScreen="true"></iframe>
      </div>
      <div class="col-xs-10">
         <label class="field option mt15">
         <input type="checkbox" name="step_0_agreement_check" value="1" onchange="document.getElementById(\'submit\').disabled=!this.checked;" /> <span class="checkbox mr10"></span>' . $lang['step_0_agreement_check'] . '</label>
         <hr class="alt short mv15">
      </div>
   </div>
</div>
<div class="panel-footer">
   <button name="submit" type="button" ' . btn_class('danger', 'block', true, '385') . ' onclick="window.location=\'install.php\';" />' . $lang['install_to_back'] . '</button>
   <button name="submit" id="submit" type="button" ' . btn_class('system', 'block', true, '385') . ' disabled="disabled"  onclick="window.location=\'install.php?step=php_set\';"/>' . $lang['step_0_agreement_ok'] . '</button>
</div>
</div>';
    foot();
}

function php_set(): void
{
    global $title, $lang;
    $title = $lang['step_1_php'] . ' | ';
    head();
    alert_install_info('info', $lang['сheck_php']);
    echo '<table class="table table-striped table-xs">
   <thead>
      <th style="width:300px">' . $lang['min_requirements'] . '</th>
      <th colspan="2">' . $lang['current_value'] . '</th>
   </thead>';
    $errors = false;
    if (version_compare(phpversion(), '7.0', '>')) {
        $status = spanText(true);
    } else {
        $status = spanText(false);
        $errors = true;
    }
    echo '<tr>
      <td>' . $lang['version_php'] . '</td>
      <td colspan=2>' . $status . '</td>
   </tr>';
    if (function_exists('mysqli_connect')) {
        $status = spanText(true);
    } else {
        $status = spanText(false);
        $errors = true;
    }
    echo '<tr>
      <td> ' . $lang['support_MySQLi'] . ' </td>
      <td colspan=2> ' . $status . '</td>
   </tr>';
    if (class_exists('ZipArchive')) {
        $status = spanText(true);
    } else {
        $status = spanText(false);
        $errors = true;
    }
    echo '<tr>
      <td> ' . $lang['support_ZipArchive'] . ' </td>
      <td colspan=2> ' . $status . '</td>
   </tr>';
    if (function_exists('mb_convert_encoding')) {
        $status = spanText(true);
    } else {
        $status = spanText(false);
        $errors = true;
    }
    echo '<tr>
      <td> ' . $lang['support_multibyte_strings'] . ' </td>
      <td colspan=2> ' . $status . '</td>
   </tr>
</table>';
    if ($errors) {
        alert_install_info('danger', $lang['server_error_requirements'], 'button', '<button onclick="location.reload(true); return false;" ' . btn_class('danger', 'block', true, '385') . '> ' . $lang['сheck_reboot'] . ' </button>');
    } else {
        alert_install_info('warning', $lang['server_install_requirements'], 'button', '<button name="submit" type="submit" ' . btn_class('danger', 'block', true, '385') . ' onclick="window.location=\'install.php?step=license_set\';"/>' . $lang['install_back'] . ' </button>
<button name="submit" type="submit" ' . btn_class('system', 'block', true, '385') . ' onclick="window.location=\'install.php?step=1\';"/>' . $lang['install_resume'] . '</button>');
    }
    foot();
}

function step1(): void
{
    global $title, $lang;
    $title = $lang['step_1_title'] . ' | ';
    head();
    if (!is_writable('./etc/db.config.php')) {
        alert_install_info('warning', $lang['step_1_error'], '1', $lang['install_refresh']);
    } else {
        alert_install_info('info', $lang['step_1_desc']);
        echo '<form class="form-horizontal parsley-form" style="margin:0; padding:0"  role="form" action="install.php?step=2" method="post" data-parsley-validate>
   <div class="panel-body pn table-responsive">
      <div class="col-xs-12 ml30">
         <div class="form-group">
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_1_mysql_server'] . ':</label>
            <div class="col-sm-7">
               <label for="dbhost" class="field prepend-icon">
               <input type="text" name="dbhost" class="form-control" data-parsley-required="true" data-parsley-trigger="change" value="localhost" data-parsley-id="5887">
               <label for="dbhost" class="field-icon"><i class="fa1 fa-server"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_1_mysql_user'] . ':</label>
            <div class="col-sm-7">
               <label for="dbuser" class="field prepend-icon">
               <input type="text" name="dbuser" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['step_1_mysql_user_pre'] . '" data-parsley-id="5887" required>
               <label for="dbuser" class="field-icon"><i class="fa1 fa-user"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_1_mysql_name'] . ':</label>
            <div class="col-sm-7">
               <label for="dbname" class="field prepend-icon">
               <input type="text" name="dbname" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['step_1_mysql_name_pre'] . '" data-parsley-id="5887" required>
               <label for="dbname" class="field-icon"><label for="dbname" class="field-icon"><i class="fa1 fa-database"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_1_mysql_pass'] . ':</label>
            <div class="col-sm-7">
               <label for="dbpass" class="field prepend-icon">
               <input type="text" name="dbpass" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['step_1_mysql_pass_pre'] . '" data-parsley-id="5887" required>
               <label for="dbpass" class="field-icon"><i class="fa1 fa-key"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_1_mysql_prefix'] . ':</label>
            <div class="col-sm-7">
               <label for="prefix" class="field prepend-icon">
               <input type="text" name="prefix" class="form-control" data-parsley-required="true" data-parsley-trigger="change" value="JMY_" data-parsley-id="5887" required>
               <label for="prefix" class="field-icon"><i class="fa1 fa-shield"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
 </div>
         </div>
      </div>
   </div>
   <div class="p0"></div>
   <div class="panel-footer">
      <button name="submit" type="submit" ' . btn_class('danger', 'block', true, '385') . ' onclick="window.location=\'install.php?step=license_set\';" />' . $lang['install_back'] . ' </button>
      <button name="submit" type="submit" ' . btn_class('system', 'block', true, '385') . '/>' . ((isset($_COOKIE['jmy_lang']) && $_COOKIE['jmy_lang'] == 'en') ? $lang['install_continue'] : $lang['install_resume']) . ' </button>
   </div>
</form>';
    }
    foot();
}

function step2(): void
{
    global $title, $lang, $langs;
    ajax_script();
    $title = $lang['step_2_title'] . ' | ';
    head();
    $content = '';
    $name = array();
    $url_site = isset($_SERVER['HTTPS']) ? 'https://' . $_SERVER['HTTP_HOST'] : 'http://' . $_SERVER['HTTP_HOST'];
    $dbhost = $_POST['dbhost'] ?? ($_GET['dbhost'] ?? '');
    $dbuser = $_POST['dbuser'] ?? ($_GET['dbuser'] ?? '');
    $dbpass = $_POST['dbpass'] ?? ($_GET['dbpass'] ?? '');
    $dbname = $_POST['dbname'] ?? ($_GET['dbname'] ?? '');
    $prefix = $_POST['prefix'] ?? ($_GET['prefix'] ?? 'JMY_');
    $goCreate = $_POST['goCreate'] ?? ($_GET['goCreate'] ?? '');
    $do = $_POST['do'] ?? ($_GET['do'] ?? '');
    $test_content = $_POST['test_content'] ?? ($_GET['test_content'] ?? '');
    if ($dbhost) $resource = new mysqli($dbhost, $dbuser, $dbpass, $dbname);
    mysqli_report(MYSQLI_REPORT_OFF);
    $i = 0;
    if (isset($resource)) {
        if (!mysqli_select_db($resource, $dbname)) {
            alert_install_info('warning', $lang['step_2_error_2'] . ' <i>' . $dbname . '</i>', '1', $lang['install_back']);
        } else {
            if ($goCreate && $do) {
                @mysqli_set_charset($resource, 'utf8');
                if ($do == 'install') {
                    $sql_create = file_get_contents('install/sql/sql_create.sql');
                    $sql_create_massiv = explode(";", $sql_create);
                    alert_install_info('info', $lang['step_0_welcome_text'] . $lang['step_2_desc']);
                    echo '<div id="container">
   <div class="table-responsive pre-scrollable">
      <table class="table table-striped table-xs table-framed">
         <thead>           
            <th><span class="pd-l-sm"></span>#</th>
            <th class="text-left">' . $lang['step_2_table'] . '</th>
            <th class="text-center">' . $lang['install_status'] . '</th>
         </thead>
         <tbody>';
                    foreach ($sql_create_massiv as $query) {
                        if (preg_match('#CREATE#i', $query)) {
                            preg_match('#`\[prefix](.*)`#i', $query, $name);
                            if (@mysqli_query($resource, str_replace('[prefix]', $prefix, $query) . ";")) {
                                $status = 'success';
                                $i++;
                                echo '<tr>
               <td><b>' . $i . '</b></td>
               <td><b>' . str_replace('[prefix]', $prefix, $name[0]) . '</b></td>
               <td style="width:300px" class="text-center">
                  <div id="status_' . $name[0] . '">
                     <div class="panel-heading">' . $lang['step_2_create'] . '<img src="usr/tpl/admin/images/loading.gif" style="border: 0; width: 75px; height: 50px;" alt=""/></div>
                     <script type="text/javascript">ajaxGet(\'' . $url_site . '/install.php?step=ajax&status=' . $status . '\', \'status_' . $name[0] . '\');</script>
                  </div>
               </td>
            </tr>';
                            } else {
                                $error = 1;
                                $status = 'error';
                                $i++;
                                echo '<tr>
               <td><b>' . $i . '</b></td>
               <td><b>' . str_replace('[prefix]', $prefix, $name[0]) . '</b></td>
                <td style="width:300px" class="text-center">
                  <div id="status_' . $name[0] . '">
                     <div class="text">' . $lang['step_2_create'] . '<img src="usr/tpl/admin/images/loading.gif" style="border: 0; width: 75px; height: 50px;" alt=""/></div>
                     <script type="text/javascript">ajaxGet(\'' . $url_site . '/install.php?step=ajax&status=' . $status . '\', \'status_' . $name[0] . '\');</script>
                  </div>
               </td>
            </tr>';
                            }
                        }
                    }
                    echo '</tbody>
      </table>
   </div>
</div>
<div class="panel-footer">';
                    if (!empty($error)) {
                        echo '<button name="submit" type="submit" ' . btn_class('danger', 'block', true, '385') . ' onclick="window.location=\'install.php?step=1\';" />' . $lang['install_back'] . '</button>
                              <button name="submit" type="submit" ' . btn_class('warning', 'block', true, '385') . ' onclick="window.location=\'install.php?step=truncate&table=' . str_replace('[prefix]', $prefix, $name[0]) . '&dbhost=' . $dbhost . '&dbuser=' . $dbuser . '&dbpass=' . $dbpass . '&dbname=' . $dbname . '\';" />' . $lang['clear_database'] . '</button>';
                    } else {
                        echo '<div class="text-center"><button name="submit" type="submit" ' . btn_class('system', 'block', true) . ' onclick="window.location=\'install.php?step=chmod\';" />' . $lang['install_resume'] . '</button>';
                        echo '</div></div>';
                    }
                    echo '</div>';
                    $sql_insert = file_get_contents('install/sql/' . $langs . '/sql_insert.sql');
                    $sql_insert_massiv = explode(";", $sql_insert);
                    foreach ($sql_insert_massiv as $query) {
                        if (preg_match('#INSERT#i', $query)) @mysqli_query($resource, str_replace(array('[prefix]', '[times]'), array($prefix, time()), $query));
                    }
                    if ($test_content == 1) {
                        $sql_content = file_get_contents('install/sql/sql_content.sql');
                        $sql_content_massiv = explode(";", $sql_content);
                        foreach ($sql_content_massiv as $query) {
                            if (preg_match('#INSERT#i', $query)) @mysqli_query($resource, str_replace('[prefix]', $prefix, $query));
                        }
                    }
                    $all_count = count($sql_insert_massiv) + count($sql_create_massiv);
                }
                $content .= '$dbhost = "' . $dbhost . '";' . "\n";
                $content .= '$dbuser = "' . $dbuser . '";' . "\n";
                $content .= '$dbpass = "' . $dbpass . '";' . "\n";
                $content .= '$dbname = "' . $dbname . '";' . "\n" . "\n";
                $content .= '$prefix = "' . (mb_substr($prefix, -1) == '_' ? mb_substr($prefix, 0, -1) : $prefix) . '";' . "\n";
                $content .= '$user_prefix = "' . (mb_substr($prefix, -1) == '_' ? mb_substr($prefix, 0, -1) : $prefix) . '";' . "\n";
                $content .= '$user_db = "' . $dbname . '";' . "\n";
                save_conf('etc/db.config.php', $content);
            } else {
                $result = mysqli_query($resource, "SELECT VERSION() AS `version`;");
                $row = $result->fetch_assoc();
                if (version_compare($row['version'], '5.5.3', '>')) {
                    alert_install_info('success', $lang['step_2_ok'], 'button', '<form action="install.php?step=2" method="post">
   <input type="hidden" name="dbhost" value="' . $dbhost . '"/>
   <input type="hidden" name="dbuser" value="' . $dbuser . '"/>
   <input type="hidden" name="dbpass" value="' . $dbpass . '"/>
   <input type="hidden" name="prefix" value="' . $prefix . '"/>
   <input type="hidden" name="dbname" value="' . $dbname . '"/>
   <input type="hidden" name="goCreate" value="1" />
   <input type="hidden" name="do" value="install" />
   <input type="hidden" name="test_content" value="0" />
   <div class="text-center">
   <button name="submit" type="submit" ' . btn_class('system', 'block', true, '385') . '/>' . $lang['install_resume'] . '</button>
   </div>
</form>');
                } else {
                    alert_install_info('warning', $lang['MySQL_error_requirements'], '2', $lang['install_back']);
                }
            }
        }
    } else {
        alert_install_info('warning', $lang['step_2_error_1'], '1', $lang['install_back']);
    }
    foot();
}

function checkChmod(): void
{
    global $title, $lang;
    ajax_script();
    $count = '';
    $dir = array();
    $dirs = DirsList();
    $title = $lang['chmod_title'] . ' | ';
    $url_site = isset($_SERVER['HTTPS']) ? 'https://' . $_SERVER['HTTP_HOST'] : 'http://' . $_SERVER['HTTP_HOST'];
    $i = 0;
    head();
    alert_install_info('info', $lang['chmod_desc']);
    echo '<div id="container">
   <div class="table-responsive pre-scrollable">
      <table class="table table-striped table-xs table-framed">
         <thead>
            <th><span class="pd-l-sm"></span>#</th>
            <th class="text-left">' . $lang['chmod_folder'] . '</th>
            <th class="text-center">' . $lang['chmod_rights'] . '</th>
            <th class="text-center">' . $lang['install_status'] . '</th>
         </thead>
         <tbody>';
    foreach ($dirs as $dir) {
        @chmod($dir, 0777);
        $chm = @decoct(@fileperms($dir)) % 1000;
        $chmr = $chm == 0 ? $lang['path_not_found'] : '[' . $chm . ']';
        $status = is_writable($dir) ? 'success' : 'error';
        $count .= is_writable($dir) ? '' : $count++;
        $i++;
        echo '<tr>
               <td><b>' . $i . '</b></td>
               <td><b>' . $dir . '</b></td>
               <td class="text-center"><b>' . $chmr . '</b></td>
               <td style="width:300px" class="text-center">
                  <div id="status_' . $dir . '">
                     <div class="panel-heading">' . $lang['check_path'] . '<img src="usr/tpl/admin/images/loading.gif" style="border: 0; width: 75px; height: 50px;" alt=""/></div>
                     <script type="text/javascript">ajaxGet(\'' . $url_site . '/install.php?step=ajax&status=' . $status . '\', \'status_' . $dir . '\');</script>
                  </div>
               </td>
            </tr>';
    }
    foreach (scandir('./etc/') as $file) {
        if (preg_match('#.config.php#i', $file)) {
            $file = './etc/' . $file;
            @chmod($file, 0666);
            $chm = @decoct(@fileperms($file)) % 1000;
            $chmr = $chm == 0 ? $lang['path_not_found'] : '[' . $chm . ']';
            $status = is_writable($file) ? 'success' : 'error';
            $count .= is_writable($file) ? '' : $count++;
            $i++;
            echo '<tr>
               <td><b>' . $i . '</b></td>
               <td><b>' . $dir . '</b></td>
               <td class="text-center"><b>' . $chmr . '</b></td>
               <td style="width:300px" class="text-center">
                  <div id="status_' . $file . '">
                     <div class="panel-heading">' . $lang['check_path'] . '<img src="usr/tpl/admin/images/loading.gif" style="border: 0; width: 75px; height: 50px;" alt=""/></div>
                     <script type="text/javascript">ajaxGet(\'' . $url_site . '/install.php?step=ajax&status=' . $status . '\', \'status_' . $file . '\');</script>
                  </div>
               </td>
            </tr>';
        }
    }
    echo '</tbody>
      </table>
   </div>
</div>
<div class="panel-footer text-center">';
    if ($count) {
        echo '<button name="submit" type="submit" ' . btn_class('warning', 'block', true) . ' onclick="window.location=\'install.php?step=create_path\';" />' . $lang['create_path'] . '</button> ';
    } else {
        echo '<button name="submit" type="submit" ' . btn_class('system', 'block', true) . ' onclick="window.location=\'install.php?step=3\';" />' . $lang['install_resume'] . '</button>';
    }
    echo '</div>
</div>';
    foot();
}

function step3(): void
{
    global $config, $title, $lang;
    $title = $lang['step_3_title'] . ' | ';
    $url_site = '';
    head();
    require ROOT . 'boot/db/mysqli.db.php';
    require_once ROOT . 'etc/global.config.php';
    $url_site = isset($_SERVER['HTTPS']) ? 'https://' . $_SERVER['HTTP_HOST'] : 'http://' . $_SERVER['HTTP_HOST'];
    echo '<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.13/css/all.css" integrity="sha384-DNOHZ68U8hZfKXOrtjWvjxusGo9WQnrNx2sqG0tfsghAvtVlRW3tvkXWZh58N9jp" crossorigin="anonymous">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" />
<script type="text/javascript">
   function checkPasswordMatch() {
       var password=$("#password").val();
       var confirmPassword=$("#repassword").val();
      if (confirmPassword== 0) {
          $("#checkPassword").html(\'\');
        } else if (password != confirmPassword){
           $("#checkPassword").html(\'' . colorSpan('red', $lang['install_error_password']) . '\');
       } else {
           $("#checkPassword").html(\'' . colorSpan('green', $lang['install_success_password']) . '\');
       }
   }
    function passwordChanged() {
        var strength=document.getElementById(\'strength\');
        var strongRegex=new RegExp("^(?=.{14,})(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9])(?=.*\\W).*$", "g");
        var mediumRegex=new RegExp("^(?=.{10,})(((?=.*[A-Z])(?=.*[a-z]))|((?=.*[A-Z])(?=.*[0-9]))|((?=.*[a-z])(?=.*[0-9]))).*$", "g");
        var enoughRegex=new RegExp("(?=.{6,}).*", "g");
        var pwd=document.getElementById("password");
      if (pwd.value.length == 0) {
            strength.innerHTML=\'\';
        } else if (false == enoughRegex.test(pwd.value)) {
            strength.innerHTML= \'' . $lang['too_short'] . '\';
        } else if (strongRegex.test(pwd.value)) {
            strength.innerHTML=\'' . $lang['hard'] . '\';
        } else if (mediumRegex.test(pwd.value)) {
            strength.innerHTML=\'' . $lang['medium'] . '\';
        } else {
            strength.innerHTML=\'' . $lang['easy'] . '\';
        }
    }
   $(document).ready(function () {
      $("#txtConfirmPassword").keyup(checkPasswordMatch);
   });
   $(document).on(\'click\', \'.toggle-password\', function() {
       $(this).toggleClass("fa-unlock");
           var input=$("#password");
       input.attr(\'type\') === \'password\' ? input.attr(\'type\',\'text\') : input.attr(\'type\',\'password\')
   });
      $(document).on(\'click\', \'.toggle-repassword\', function() {
       $(this).toggleClass("fa-unlock");
           var input=$("#repassword");
       input.attr(\'type\') === \'password\' ? input.attr(\'type\',\'text\') : input.attr(\'type\',\'password\')
   });
   function ValidateEmail() {
        var strength=document.getElementById(\'email_strength\');
   var mailformat=/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
        var pwd=document.getElementById("email");
   if (pwd.value.length == 0) {
            strength.innerHTML=\'\';
        } else if (pwd.value.match(mailformat)) {
            strength.innerHTML=(\'' . colorSpan('green', $lang['install_success_email']) . '\');
        }  else {
            strength.innerHTML=(\'' . colorSpan('red', $lang['install_error_email']) . '\');
        }
    }
</script>';
    alert_install_info('info', $lang['step_3_desc']);
    echo '<form class="form-horizontal parsley-form" style="margin:0; padding:0"  role="form" action="install.php?step=4" method="post" data-parsley-validate>
   <div class="panel-body pn table-responsive">
      <div class="col-xs-12 ml30">
         <div class="form-group">
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_3_url'] . ':</label>
            <div class="col-sm-7">
               <label for="url" class="field prepend-icon">
               <input type="text" name="url" id="url" class="form-control" value="' . $url_site . '" required>
               <label for="url" class="field-icon"><i class="fa1 fa-link"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_3_name'] . ':</label>
            <div class="col-sm-7">
               <label for="name" class="field prepend-icon">
               <input type="text" name="name" class="form-control" data-parsley-required="true" data-parsley-trigger="change" value="JMY CMS" data-parsley-id="5887" required>
               <label for="name" class="field-icon"><i class="fa1 fa-pencil"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_3_charset'] . ':</label>
            <div class="col-sm-7">
               <label for="charset" class="field prepend-icon">
               <input type="text" name="charset" class="form-control" data-parsley-required="true" data-parsley-trigger="change" value="' . $config['charset'] . '"  data-parsley-id="5887" required>
               <label for="charset" class="field-icon"><i class="fa1 fa-shield"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_3_gzip'] . '</label>
            <div class="col-sm-7">
               ' . radio("gzip", 1) . '
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_3_rewrite'] . '</label>
            <div class="col-sm-7">
               ' . radio("mod_rewrite", 1) . '
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_3_admin_email'] . ':</label>
            <div class="col-sm-7">
               <label for="email" class="field prepend-icon">
               <input type="text" name="email" id="email" class="form-control" onblur="ValidateEmail(this.value,\'email\');" data-parsley-required="true" data-parsley-trigger="change" value="" data-parsley-id="5887" placeholder="' . $lang['pre_email'] . '"  required>
               <label for="email" class="field-icon"><i class="fa1 fa-envelope-o"></i></label>
                </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
               <div class="col-sm-10 passwordChanged">
                  <div id="email_strength"></div>
                  <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
               </div>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> ' . $lang['step_3_admin_login'] . ':</label>
            <div class="col-sm-7">
               <label for="nick" class="field prepend-icon">
               <input type="text" name="nick" class="form-control" data-parsley-required="true" data-parsley-trigger="change" value="admin" data-parsley-id="5887" placeholder="' . $lang['pre_username'] . '" required>
               <label for="nick" class="field-icon"><i class="fa1 fa-user"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"> <span toggle="#password-field" title="Показать" class="fa fa-fw fa-lock toggle-password field-icon"></span>
            ' . $lang['step_3_admin_pass'] . ':</label>
            <div class="col-sm-7">
               <label for="password" class="field prepend-icon">
               <input type="password" name="password" id="password" class="form-control" onblur="checkPasswordMatch(this.value,\'repassword\');" onkeyup="passwordChanged();" data-parsley-required="true" data-parsley-trigger="change" data-parsley-id="5887" placeholder="' . $lang['pre_password'] . '" required>
               <label for="password" class="field-icon"><i class="fa1 fa-lock"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
               <div class="col-sm-10 passwordChanged">
                  <div id="strength"></div>
                  <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
               </div>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"><span toggle="#repassword-field" title="Показать" class="fa fa-fw fa-lock toggle-repassword field-icon"></span>
            ' . $lang['step_3_admin_repass'] . ':</label>
            <div class="col-sm-7">
               <label for="repassword" class="field prepend-icon">
               <input type="password" name="password" id="repassword" class="form-control" onblur="checkPasswordMatch(this.value,\'password\');" data-parsley-required="true" data-parsley-trigger="change" data-parsley-id="5887" placeholder="' . $lang['pre_password_still'] . '" required>
               <label for="repassword" class="field-icon"><i class="fa1 fa-lock"></i></label>
               </label>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
            <label class="col-lg-4 col-sm-4 control-label p15"></label>
            <div class="col-sm-7">
               <div id="checkPassword"></div>
               <ul class="parsley-errors-list" id="parsley-id-5887"></ul>
            </div>
         </div>
      </div>
   </div>
   <div class="p0"></div>
   <div class="panel-footer">
      <button name="submit" type="submit" ' . btn_class('danger', 'block', true, '385') . ' onclick="window.location=\'install.php?step=1\';" />' . $lang['install_back'] . ' </button>
      <button name="submit" type="submit" ' . btn_class('system', 'block', true, '385') . '/>' . $lang['install_resume'] . '</button>
   </div>
</form>';
    foot();
}

function genmycode($lenght): string
{
    $code = array();
    $symbols = array('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '2', '3', '4', '5', '6', '7', '8', '9');
    for ($i = 0; $i < $lenght; $i++) {
        $code[] = $symbols[rand(0, sizeof($symbols) - 1)];
    }
    $code = array_unique($code);
    return implode('', $code);
}

function step4(): void
{
    global $config, $dbhost, $dbuser, $dbpass, $dbname, $prefix, $title, $lang, $langs;
    $title = $lang['step_4_title'] . ' | ';
    head();
    $url = !empty($_POST['url']) ? $_POST['url'] : '';
    $name = !empty($_POST['name']) ? filter($_POST['name'], 'a') : '';
    $nick = !empty($_POST['nick']) ? filter($_POST['nick'], 'a') : '';
    $password = !empty($_POST['password']) ? $_POST['password'] : '';
    $charset = !empty($_POST['charset']) ? filter($_POST['charset'], 'a') : '';
    $gzip = !empty($_POST['gzip']) ? intval($_POST['gzip']) : '';
    $mod_rewrite = !empty($_POST['mod_rewrite']) ? intval($_POST['mod_rewrite']) : '';
    $email = !empty($_POST['email']) ? filter($_POST['email'], 'mail') : '';
    if (!empty($name) && !empty($charset) && !empty($gzip) && !empty($nick) && !empty($password)) {
        require_once ROOT . 'etc/global.config.php';
        $content = "\$config=array();\n";
        foreach ($config as $k => $val) {
            if ($k !== 'name' && $k !== 'lang' && $k !== 'charset' && $k !== 'gzip' && $k !== 'support_mail' && $k !== 'url' && $k !== 'uniqKey' && $k !== 'mod_rewrite') {
                if (!is_array($val)) {
                    $content .= "\$config['" . $k . "']=\"" . $val . "\";\n";
                } else {
                    foreach ($val as $karr => $varr) {
                        $content .= "\$config['" . $k . "']['" . $karr . "']=\"" . $varr . "\";\n";
                    }
                }
            }
        }
        $content .= "\$config['name']=\"" . $name . "\";\n";
        $content .= "\$config['charset']=\"" . $charset . "\";\n";
        $content .= "\$config['gzip']=\"" . $gzip . "\";\n";
        $content .= "\$config['mod_rewrite']=\"" . $mod_rewrite . "\";\n";
        $content .= "\$config['url']=\"" . $url . "\";\n";
        $content .= "\$config['uniqKey']=\"" . genmycode(10) . "\";\n";
        $content .= "\$config['support_mail']=\"" . $email . "\";\n";
        $content .= "\$config['lang']=\"" . $langs . "\";\n";
        $content .= "\$config['description']=\"" . $lang['install_description'] . "\";\n";
        $content .= "\$config['slogan']=\"" . $lang['install_slogan'] . "\";\n";
        $content .= "\$config['off_text']=\"" . $lang['install_off_text'] . "\";\n";
        $content .= "\$config['keywords']=\"" . $lang['install_keywords'] . "\";\n";
        save_conf('etc/global.config.php', $content);
        require_once ROOT . 'etc/db.config.php';
        $resource = new mysqli($dbhost, $dbuser, $dbpass, $dbname);
        mysqli_report(MYSQLI_REPORT_OFF);
        if (@mysqli_select_db($resource, $dbname)) {
            @mysqli_set_charset($resource, 'utf8');
            $tail = gencode(10);
            @mysqli_query($resource, "INSERT INTO `" . $prefix . "_users` (`id`, `nick`, `password`, `tail`, `email`, `timezones`, `provider`, `social_id`, `status`, `icq`, `phone`, `skype`, `surname`, `name`, `ochestvo`, `place`, `age`, `sex`, `birthday`, `hobby`, `signature`, `points`, `carma`, `user_comments`, `user_news`, `group`, `exgroup`, `last_visit`, `regdate`, `active`, `mailsend`, `distsend`, `no_mail`, `audio_alert`, `dist_id`, `ip`, `fields`, `avatar_auth`, `bday_visibility`, `twofactor`, `key_pin`, `attempt`, `banned_time`) VALUES(NULL, '" . $_POST['nick'] . "', '" . md5(mb_substr(md5(md5($password)), 0, -mb_strlen($tail)) . $tail) . "', '" . $tail . "', '" . $_POST['email'] . "', '', '', '', 0, '', '', '', '', '', '', '', 0, 0, '', '', '', 0, 0, 0, 0, 1, 0, '" . time() . "', '" . time() . "', 1, 0, 0, 0, 0, 0, '0', '', '', 0, 0, 0, 0, 0)");
            list($uid) = mysqli_fetch_array(mysqli_query($resource, "SELECT id FROM `" . $prefix . "_users` WHERE nick='" . $_POST['nick'] . "' LIMIT 1"));
            @mysqli_query($resource, "INSERT INTO `" . $prefix . "_board_users` (`uid`, `thanks`, `messages`, `specStatus`, `lastUpdate`) VALUES ('" . $uid . "',0,0,'',0);");
            @mysqli_query($resource, "UPDATE `" . $prefix . "_news` SET `author` = '" . $_POST['nick'] . "' WHERE `author` = 'admin'");
            @mysqli_query($resource, "UPDATE `" . $prefix . "_content` SET `author` = '" . $_POST['nick'] . "' WHERE `author` = 'admin'");
            @mysqli_query($resource, "UPDATE `" . $prefix . "_notepad` SET `nick` = '" . $_POST['nick'] . "' WHERE `nick` = 'admin'");
        }
        $install_infoTXT = NULL;
        $install_infoTXT .= "\r\n " . $lang['step_5_desc'];
        $install_infoTXT .= "\r\n " . $lang['install_info'];
        $install_infoTXT .= "\r\n " . $lang['install_info1'];
        $install_infoTXT .= "\r\n";
        $install_infoTXT .= "\r\n " . $lang['site_host'] . $url;
        $install_infoTXT .= "\r\n " . $lang['admin_login'] . $nick;
        $install_infoTXT .= "\r\n " . $lang['admin_email'] . $email;
        $install_infoTXT .= "\r\n " . $lang['admin_pass'] . $password;
        $fp = fopen(ROOT . 'tmp/user.admin.txt', 'w+');
        if (fwrite($fp, $install_infoTXT)) alert_install_info('success', '<strong>' . $lang['step_4_ok'] . '</strong>
<br/>' . $lang['step_4_login'] . ': <strong>' . $_POST['nick'] . '</strong>
<br/>' . $lang['step_4_pass'] . ': <strong>' . $_POST['password'] . '</strong>
<br/>
<br/><strong>' . $lang['install_info2'] . '</strong>', '5', $lang['install_resume']);
    } else {
        alert_install_info('warning', $lang['step_4_error'], '3', $lang['install_back']);
    }
    echo '</div>';
    foot();
}

function step5(): void
{
    global $title, $config, $lang;
    $title = $lang['step_5_title'] . ' | ';
    require_once ROOT . 'etc/global.config.php';
    head();
    alert_install_info('warning', $lang['step_5_install'], 'button', '<div class="btn-group">
   <button type="button" ' . btn_class('system', true, true) . ' onclick="location.href=\'/\'">' . $lang['step_5_site'] . '</button>
   <button type="button" data-toggle="dropdown" ' . btn_class('system', true, true) . 'class="dropdown-toggle"><span class="caret"></span><span class="sr-only">Toggle Dropdown</span></button>
   <ul role="menu" class="dropdown-menu">
      <li><a href="administration/">' . $lang['step_5_panel'] . '</a></li>
      <li><a href="https://jmy.su">' . $lang['step_5_jmy'] . '</a></li>
   </ul>
</div>');
    delcache('plugins');
    jmycmsck('statd', false, '&mail=' . $config['support_mail']);
    @fopen(ROOT . 'install/lock.install', 'w');
    foot();
}

function truncate(): void
{
    $dbhost = !empty($_GET['dbhost']) ? $_GET['dbhost'] : '';
    $dbuser = !empty($_GET['dbuser']) ? $_GET['dbuser'] : '';
    $dbpass = !empty($_GET['dbpass']) ? $_GET['dbpass'] : '';
    $dbname = !empty($_GET['dbname']) ? $_GET['dbname'] : '';
    if (isset($dbhost) && isset($dbuser) && isset($dbname)) {
        $connection = new mysqli($dbhost, $dbuser, $dbpass, $dbname);
        $sql = "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA LIKE '" . $dbname . "'";
        $result = $connection->query($sql);
        $tables = $result->fetch_all(MYSQLI_ASSOC);
        foreach ($tables as $table) {
            $sql = "DROP TABLE `" . $table['TABLE_NAME'] . "`";
            $connection->query($sql);
        }
    }
    Header('Location: /install.php?step=2&dbhost=' . $dbhost . '&dbuser=' . $dbuser . '&dbpass=' . $dbpass . '&dbname=' . $dbname . '&do=install&goCreate=1&test_content=0');
}

function DirsList(): array
{
    return array('./boot/', './etc/', './files/', './files/avatars/', './files/avatars/users/', './files/avatars/profile_image/', './files/board/', './files/content/', './files/distribution/', './files/messages/', './files/news/', './files/templates/', './files/thumbs/', './langs/', './lib/', './media/', './root/', './tmp/', './tmp/archives/', './tmp/cache/', './tmp/mysql/', './usr/blocks/', './usr/plugins/', './usr/tpl/', './usr/modules/');
}

function create_path(): void
{
    $dirs = DirsList();
    foreach ($dirs as $dir) {
        $path = is_writable($dir) ? $dir : false;
        if (!file_exists($path)) {
            @mkdir($dir, 0777, true);
            @chmod($dir, 0777);
        }
    }
    foreach (scandir('./etc/') as $file) {
        if (preg_match('#.config.php#i', $file)) {
            $file = './etc/' . $file;
            $path = is_writable($file) ? $file : false;
            if (!file_exists($path)) {
                @mkdir($path, '0666');
                @chmod($file, 0666);
            }
        }
        header('Location: /install.php?step=chmod');
    }
}

function ajax_script(): void
{
    echo '<script>
   function ajaxEngine(replaceID, type, js) {
       var xmlhttp=false;
       try {
           xmlhttp=new XMLHttpRequest();
       }
       catch (e) {
           try {
               xmlhttp=new ActiveXObject(\'Microsoft.XMLHTTP\');
   		}
   		catch (e) {
   		xmlhttp=new ActiveXObject(\'Msxml2.XMLHTTP\');
   		}
   	}
   	xmlhttp.onreadystatechange=function()	{
   		if (xmlhttp.readyState == 4) {
   			if (xmlhttp.status == 200) {
   				if(type == 2)
   				{
   					document.getElementById(replaceID).value=xmlhttp.responseText;
   					eval(js);
   				}
   				else
   				{
   					document.getElementById(replaceID).innerHTML=xmlhttp.responseText;
   					eval(js);
   				}
   			} else {
   				//alert(\'AJAX: ошибка выполнения!\');
   				return;
   			}
   		}
   	}
   	return xmlhttp;
   }
   function ajaxGet(uri, id) {
   	var xmlhttp=ajaxEngine(id);
   	var link=uri;
   	xmlhttp.open(\'GET\', link, true);
   	xmlhttp.setRequestHeader(\'X_REQUESTED_WITH\', \'XMLHttpRequest\');
   	xmlhttp.send(null);
   }
</script>';
}

if (!file_exists('install/lock.install')) {
    global $adminTpl, $db, $lang;
    ajaxInit();
    switch (isset($_GET['step']) ? ($_GET['step']) : null) {
        default:
            language();
            break;
        case 'language_set_en':
            language_set('en');
            break;
        case 'language_set_ru':
            language_set();
            break;
        case 'license_set':
            license();
            break;
        case 'php_set':
            php_set();
            break;
        case '1':
            step1();
            break;
        case "2":
            step2();
            break;
        case "3":
            step3();
            break;
        case "chmod":
            checkChmod();
            break;
        case "4":
            step4();
            break;
        case "5":
            step5();
            break;
        case "truncate":
            truncate();
            break;
        case "create_path":
            create_path();
            break;
        case "ajax":
            if (isset($_GET['status'])) labelText($_GET['status']);
            break;
    }
} else {
    Header('Location: /');
}
function labelText($stat): void
{
    global $lang;
    if ($stat == 'success') {
        $status = '<span class="label label-block label-success p5 ml5">' . $lang['step_2_success'] . '</span>';
    } elseif ($stat == 'error') {
        $status = '<span class="label label-block label-danger p5 ml5">' . $lang['install_error'] . '</span>';
    } else {
        $status = '';
    }
    echo $status;
}

function spanText($stat): string
{
    global $lang;
    return $stat ? '<span class="text-success"><b>' . $lang['yes'] . '</b></span>' : '<span class="text-danger"><b>' . $lang['no'] . '</b></span>';
}

function alert_install_info($type, $message, $step = false, $step_button = false): void
{
    global $lang;
    $alert = '<div class="alert alert-' . $type . ' alert-styled-left alert-arrow-left alert-dismissible show">
   <button type="button" class="close" data-dismiss="alert" aria-label="Close">
   <span aria-hidden="true">&times;</span>
   </button>';
    if (!$step && !$step_button) {
        $alert .= $type == 'info' ? '<strong>' . $lang['info'] . '</strong><br/>' . $message : $alert . '<strong>' . $message . '</strong>';
    } else {
        $alert .= '<strong>' . $lang['install_attention'] . '</strong><br/>' . $message . '
</div>
<div class="panel-footer">';
        $newstep = $step;
        $step = array($step);
        foreach ($step as $element) {
            $numeric = is_numeric($element);
        }
        if (isset($newstep) && $newstep <> 'button' && !$numeric) {
            $alert .= '<button name="submit" type="submit" ' . btn_class('danger', 'block', true, '385') . ' onclick="window.location=\'install.php?step=' . $newstep . '\';" />' . $step_button . '</button>';
        } elseif (isset($newstep) && $newstep <> 'button' && $numeric) {
            $alert .= '<div class="text-center"><button name="submit" type="submit" ' . btn_class('system', 'block', true, '385') . ' onclick="window.location=\'install.php?step=' . $newstep . '\';" />' . $step_button . '</button></div>';
        } elseif ($newstep == 'button') {
            $alert .= $step_button;
        } else {
            $alert .= '<button name="submit" type="submit" ' . btn_class('system', 'block', true, '385') . '/>' . $lang['install_resume'] . '</button>';
        }
        $alert .= '</div>';
    }
    $alert .= '</div>';
    echo $alert;
}