DROP TABLE IF EXISTS `[prefix]attach`;
CREATE TABLE `[prefix]attach` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) NOT NULL,
  `url` varchar(255) NOT NULL,
  `pub_id` varchar(255) DEFAULT NULL,
  `mod` varchar(55) NOT NULL,
  `downloads` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pub_id` (`pub_id`),
  KEY `url` (`url`),
  KEY `pub_id_2` (`pub_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]banners`;
CREATE TABLE `[prefix]banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `desc` varchar(255) NOT NULL,
  `urltitle` varchar(255) NOT NULL,
  `urlsb` varchar(255) NOT NULL,
  `urlimg` varchar(255) NOT NULL,
  `code` mediumtext NOT NULL,
  `allow_views` tinyint(1) NOT NULL,
  `views` int(11) NOT NULL,
  `max_views` int(11) NOT NULL,
  `allow_clicks` tinyint(1) NOT NULL,
  `clicks` int(11) NOT NULL,
  `max_clicks` int(11) NOT NULL,
  `main` tinyint(1) NOT NULL,
  `startdate` varchar(15) NOT NULL,
  `enddate` varchar(15) NOT NULL,
  `inprofile` tinyint(1) NOT NULL,
  `innews` tinyint(1) NOT NULL,
  `active` int(1) NOT NULL,
  `tag` varchar(255) NOT NULL,
  `random` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]banners_ips`;
CREATE TABLE `[prefix]banners_ips` (
  `time` int(5) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `redir` varchar(255) NOT NULL,
  `uid` int(5) NOT NULL,
  `bid` int(10) NOT NULL,
  `clicks` int(11) NOT NULL,
  PRIMARY KEY (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]blocks_types`;
CREATE TABLE `[prefix]blocks_types` (
  `title` varchar(55) DEFAULT NULL,
  `type` varchar(55) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]board_forums`;
CREATE TABLE `[prefix]board_forums` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(55) NOT NULL,
  `description` varchar(255) NOT NULL,
  `pid` int(11) NOT NULL,
  `type` varchar(10) NOT NULL,
  `active` smallint(1) NOT NULL,
  `open` smallint(1) NOT NULL,
  `threads` int(11) NOT NULL,
  `posts` int(11) NOT NULL,
  `lastPost` varchar(55) NOT NULL,
  `lastPoster` varchar(255) NOT NULL,
  `lastTid` int(11) NOT NULL,
  `lastSubject` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `rulestitle` varchar(255) NOT NULL,
  `rules` mediumtext NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]board_permissions`;
CREATE TABLE `[prefix]board_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fid` int(11) NOT NULL,
  `gid` int(11) NOT NULL,
  `allowView` int(1) NOT NULL,
  `allowRead` int(1) NOT NULL,
  `allowCreate` int(1) NOT NULL,
  `allowReply` int(1) NOT NULL,
  `allowEdit` int(1) NOT NULL,
  `allowModer` int(1) NOT NULL,
  `allowAttach` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]board_posts`;
CREATE TABLE `[prefix]board_posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tid` int(11) NOT NULL,
  `message` mediumtext NOT NULL,
  `uid` int(11) NOT NULL,
  `username` varchar(255) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `time` varchar(255) NOT NULL,
  `files` mediumtext NOT NULL,
  `visible` varchar(1) NOT NULL,
  `editUser` varchar(55) NOT NULL,
  `editReason` varchar(255) NOT NULL,
  `parent_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]board_threads`;
CREATE TABLE `[prefix]board_threads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `forum` int(11) NOT NULL,
  `title` varchar(55) NOT NULL,
  `poster` int(11) NOT NULL,
  `startTime` varchar(55) NOT NULL,
  `lastTime` varchar(55) NOT NULL,
  `lastPoster` varchar(55) NOT NULL,
  `views` int(11) NOT NULL,
  `replies` int(11) NOT NULL,
  `important` int(1) NOT NULL DEFAULT '0',
  `closed` int(1) NOT NULL DEFAULT '0',
  `score` float(6,3) NOT NULL,
  `votes` int(11) NOT NULL,
  `icon` varchar(44) NOT NULL,
  `closetime` varchar(55) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]board_users`;
CREATE TABLE `[prefix]board_users` (
  `uid` int(11) NOT NULL,
  `thanks` int(11) NOT NULL,
  `messages` int(11) NOT NULL,
  `specStatus` varchar(255) NOT NULL,
  `lastUpdate` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]bookmarks`;
CREATE TABLE `[prefix]bookmarks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nid` varchar(255) DEFAULT NULL,
  `uid` varchar(255) NOT NULL,
  `url` mediumtext NOT NULL,
  `title` mediumtext NOT NULL,
  `module` varchar(255) NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]categories`;
CREATE TABLE `[prefix]categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) NOT NULL,
  `altname` varchar(55) NOT NULL,
  `fulltitle` varchar(255) NOT NULL,
  `description` varchar(200) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `module` varchar(55) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `position` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  PRIMARY KEY (`id`,`altname`),
  KEY `altname` (`altname`),
  KEY `parent_id` (`parent_id`),
  KEY `module` (`module`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]com_subscribe`;
CREATE TABLE `[prefix]com_subscribe` (
  `id` int(11) NOT NULL,
  `module` varchar(55) NOT NULL,
  `uid` int(11) NOT NULL,
  UNIQUE KEY `id` (`id`,`module`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]comments`;
CREATE TABLE `[prefix]comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `post_id` int(11) NOT NULL,
  `module` varchar(55) NOT NULL,
  `text` mediumtext,
  `date` varchar(44) NOT NULL,
  `editdate` varchar(255) NOT NULL,
  `gemail` varchar(55) NOT NULL,
  `gname` varchar(55) NOT NULL,
  `gurl` varchar(55) NOT NULL,
  `parent` int(11) NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `post_id` (`post_id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]complaint`;
CREATE TABLE `[prefix]complaint` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `name` varchar(55) NOT NULL,
  `message` mediumtext,
  `date` int(11) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `nick` varchar(255) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`name`),
  KEY `post_id` (`email`),
  KEY `uid` (`title`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]content`;
CREATE TABLE `[prefix]content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `translate` varchar(255) NOT NULL,
  `cat` varchar(200) NOT NULL,
  `keywords` varchar(55) NOT NULL,
  `description` varchar(255) NOT NULL,
  `preview` varchar(255) NOT NULL,
  `active` int(1) NOT NULL,
  `date` varchar(55) DEFAULT NULL,
  `comments` int(11) NOT NULL,
  `views` int(11) NOT NULL,
  `theme` varchar(255) NOT NULL,
  `author` varchar(55) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]counter_ip`;
CREATE TABLE `[prefix]counter_ip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `redir` varchar(255) NOT NULL,
  `clicks` int(11) NOT NULL,
  `time` varchar(255) NOT NULL,
  `error` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]counter_stat`;
CREATE TABLE `[prefix]counter_stat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(10) NOT NULL,
  `del_date` varchar(10) NOT NULL,
  `user` varchar(255) NOT NULL,
  `views` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]distribution`;
CREATE TABLE `[prefix]distribution` (
  `id` int(7) NOT NULL AUTO_INCREMENT,
  `method` varchar(255) NOT NULL,
  `fromregdate` int(11) NOT NULL,
  `toregdate` int(11) NOT NULL,
  `fromlastdate` int(11) NOT NULL,
  `tolastdate` int(11) NOT NULL,
  `limit` varchar(255) NOT NULL,
  `interval` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `no_mail` int(1) NOT NULL,
  `date` int(11) NOT NULL,
  `users` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]email`;
CREATE TABLE `[prefix]email` (
  `id` int NOT NULL,
  `hacking_attempt_text` mediumtext NOT NULL,
  `access_mail_text` mediumtext NOT NULL,
  `comp_mail_text` mediumtext NOT NULL,
  `feed_mail_text` mediumtext NOT NULL,
  `lost_mail_text` mediumtext NOT NULL,
  `new_comments_text` mediumtext NOT NULL,
  `new_news_text` mediumtext NOT NULL,
  `new_password_mail_text` mediumtext NOT NULL,
  `new_pm_text` mediumtext NOT NULL,
  `reg_mail_text` mediumtext NOT NULL,
  `subscribe_mail_text` mediumtext NOT NULL,
  `newsletter_mail_text` mediumtext NOT NULL,
  `twofactor_mail_text` mediumtext NOT NULL,
  `html_hacking_attempt` tinyint NOT NULL,
  `html_access_mail` tinyint NOT NULL,
  `html_comp_mail` tinyint NOT NULL,
  `html_feed_mail` tinyint NOT NULL,
  `html_lost_mail` tinyint NOT NULL,
  `html_new_comments` tinyint NOT NULL,
  `html_new_password_mail` tinyint NOT NULL,
  `html_new_news` tinyint NOT NULL,
  `html_new_pm` tinyint NOT NULL,
  `html_reg_mail` tinyint NOT NULL,
  `html_subscribe_mail` tinyint NOT NULL,
  `html_newsletter_mail` tinyint NOT NULL,
  `html_twofactor_mail` tinyint NOT NULL,
  `lang` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `[prefix]feed`;
CREATE TABLE `[prefix]feed` (
  `title` varchar(255) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tags` varchar(40) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `cat` varchar(200) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `templ` varchar(40) NOT NULL DEFAULT '',
  `nmax` int(11) NOT NULL DEFAULT '0',
  `tmax` int(11) NOT NULL DEFAULT '0',
  `dmax` int(11) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `date` int(11) NOT NULL,
  `date_format` varchar(20) NOT NULL DEFAULT '',
  `sourse` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]feedback`;
CREATE TABLE `[prefix]feedback` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `name` varchar(55) NOT NULL,
  `message` mediumtext,
  `date` int(11) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `nick` varchar(255) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`name`),
  KEY `post_id` (`email`),
  KEY `uid` (`title`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]groups`;
CREATE TABLE `[prefix]groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guest` int(1) NOT NULL,
  `user` int(1) NOT NULL,
  `moderator` int(1) NOT NULL,
  `admin` int(1) NOT NULL,
  `banned` int(1) NOT NULL,
  `showHide` int(1) NOT NULL,
  `showAttach` int(1) NOT NULL,
  `loadAttach` int(1) NOT NULL,
  `addPost` int(1) NOT NULL,
  `addComment` int(1) NOT NULL,
  `allowRating` int(1) NOT NULL,
  `maxWidth` int(11) NOT NULL,
  `maxPms` int(11) NOT NULL,
  `control` mediumtext NOT NULL,
  `icon` varchar(255) NOT NULL,
  `color` varchar(55) NOT NULL,
  `points` int(11) NOT NULL,
  `protect` int(1) NOT NULL,
  `special` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]guestbook`;
CREATE TABLE `[prefix]guestbook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `date` varchar(55) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `website` varchar(75) NOT NULL,
  `gender` varchar(10) NOT NULL,
  `comment` mediumtext NOT NULL,
  `reply` mediumtext NOT NULL,
  `active` int(1) NOT NULL,
  `del_time` varchar(55) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]help`;
CREATE TABLE `[prefix]help` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `question` mediumtext NOT NULL,
  `uid` int(11) NOT NULL,
  `time` varchar(255) NOT NULL,
  `replies` int(11) NOT NULL,
  `lock` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]help_replies`;
CREATE TABLE `[prefix]help_replies` (
  `rid` int(11) NOT NULL AUTO_INCREMENT,
  `to` int(11) NOT NULL,
  `text` mediumtext NOT NULL,
  `time` varchar(255) NOT NULL,
  `uid` int(11) NOT NULL,
  PRIMARY KEY (`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]langs`;
CREATE TABLE `[prefix]langs` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `postId` varchar(255) DEFAULT NULL,
  `module` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `fulltitle` varchar(255) NOT NULL,
  `short` mediumtext,
  `full` mediumtext,
  `lang` varchar(255) NOT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8; 

DROP TABLE IF EXISTS `[prefix]logs`;
CREATE TABLE `[prefix]logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(5) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `uid` int(5) NOT NULL,
  `counter` varchar(255) NOT NULL,
  `history` varchar(255) NOT NULL,
  `level` smallint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `level` (`level`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]news`;
CREATE TABLE `[prefix]news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `author` varchar(55) NOT NULL,
  `date` int(11) DEFAULT NULL,
  `tags` varchar(255) NOT NULL,
  `cat` varchar(200) DEFAULT NULL,
  `altname` varchar(55) NOT NULL,
  `source` varchar(255) NOT NULL,
  `preview` varchar(255) DEFAULT NULL,
  `keywords` mediumtext,
  `description` mediumtext,
  `allow_comments` int(1) NOT NULL,
  `allow_rating` int(1) NOT NULL,
  `allow_index` int(1) NOT NULL,
  `score` float(6,3) DEFAULT NULL,
  `votes` int(11) NOT NULL,
  `views` int(11) NOT NULL,
  `comments` int(11) NOT NULL,
  `fields` mediumtext NOT NULL,
  `groups` varchar(55) NOT NULL,
  `fixed` int(1) NOT NULL,
  `active` int(1) NOT NULL,
  `users_delete` varchar(255) NOT NULL,
  `users_del_data` int(11) DEFAULT NULL,
  `fulltitle` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `altname` (`altname`),
  KEY `active` (`active`),
  KEY `date` (`date`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]notepad`;
CREATE TABLE `[prefix]notepad` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` mediumtext,
  `nick` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]online`;
CREATE TABLE `[prefix]online` (
  `uid` int(11) NOT NULL,
  `time` int(10) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `group` int(11) NOT NULL,
  `url` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]ping`;
CREATE TABLE `[prefix]ping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dir` mediumtext NOT NULL,
  `port` mediumtext NOT NULL,
  `desc` mediumtext NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]plugins`;
CREATE TABLE `[prefix]plugins` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(55) NOT NULL,
  `content` mediumtext NOT NULL,
  `file` varchar(55) NOT NULL,
  `priority` tinyint(2) unsigned NOT NULL,
  `type` varchar(55) DEFAULT NULL,
  `service` varchar(44) NOT NULL,
  `showin` varchar(255) NOT NULL,
  `unshow` varchar(255) NOT NULL,
  `groups` varchar(255) NOT NULL,
  `free` tinyint(1) unsigned NOT NULL,
  `template` mediumtext,
  `categories` int(1) NOT NULL,
  `xfields` int(1) NOT NULL,
  `menu` int(11) NOT NULL,
  `active` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `active` (`active`),
  KEY `priority` (`priority`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]pm`;
CREATE TABLE `[prefix]pm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `toid` int(11) NOT NULL,
  `fromid` int(11) NOT NULL,
  `topic` mediumtext NOT NULL,
  `message` mediumtext,
  `time` varchar(55) NOT NULL,
  `users_delete` varchar(255) NOT NULL,
  `users_del_data` int(11) NOT NULL,
  `status` smallint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]poll_questions`;
CREATE TABLE `[prefix]poll_questions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `variant` varchar(55) NOT NULL,
  `position` int(11) NOT NULL,
  `vote` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]poll_voting`;
CREATE TABLE `[prefix]poll_voting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `ip` varchar(55) NOT NULL,
  `time` varchar(55) NOT NULL,
  `qid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]polls`;
CREATE TABLE `[prefix]polls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `votes` int(5) NOT NULL,
  `max` int(2) NOT NULL,
  `active` int(2) NOT NULL,
  `date` int(11) NOT NULL,
  `startdate` int(11) NOT NULL,
  `enddate` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]ratings`;
CREATE TABLE `[prefix]ratings` (
  `_` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `mod` varchar(55) NOT NULL,
  `time` int(11) NOT NULL,
  `ip` varchar(55) NOT NULL,
  PRIMARY KEY (`_`),
  KEY `mod` (`mod`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]redirects`;
CREATE TABLE `[prefix]redirects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oldurl` mediumtext NOT NULL,
  `newurl` mediumtext NOT NULL,
  `desc` mediumtext NOT NULL,
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]sitemap`;
CREATE TABLE `[prefix]sitemap` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `url` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]support`;
CREATE TABLE `[prefix]support` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dir` mediumtext NOT NULL,
  `version` mediumtext NOT NULL,
  `place` varchar(255) NOT NULL,
  `title` mediumtext NOT NULL,
  `message` mediumtext NOT NULL,
  `answer` mediumtext NOT NULL,
  `status` int(1) NOT NULL,
  `date` int(11) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `sid` int(11) NOT NULL,
  `user_delete` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]support_num`;
CREATE TABLE `[prefix]support_num` (
  `id` int(11) NOT NULL,
  `num` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]tagcode`;
CREATE TABLE `[prefix]tagcode` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `desc` mediumtext NOT NULL,
  `title` varchar(255) NOT NULL,
  `active` int(1) NOT NULL,
  `tag` varchar(255) NOT NULL,
  `date` varchar(44) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]tags`;
CREATE TABLE `[prefix]tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag` varchar(55) NOT NULL,
  `module` varchar(55) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]user_carma`;
CREATE TABLE `[prefix]user_carma` (
  `_id` int(11) NOT NULL AUTO_INCREMENT,
  `from` int(11) NOT NULL,
  `to` int(11) NOT NULL,
  `text` varchar(255) NOT NULL,
  `do` varchar(5) DEFAULT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]user_friends`;
CREATE TABLE `[prefix]user_friends` (
  `who_invite` int(9) NOT NULL,
  `whom_invite` int(9) NOT NULL,
  `confirmed` int(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `[prefix]user_visitors`;
CREATE TABLE `[prefix]user_visitors` (
  `id` int(9) NOT NULL,
  `visitor` int(9) NOT NULL,
  `time` int(10) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]users`;
CREATE TABLE `[prefix]users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nick` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `tail` varchar(55) NOT NULL,
  `email` varchar(255) NOT NULL,
  `timezones` varchar(255) NOT NULL,
  `provider` varchar(255) NOT NULL,
  `social_id` varchar(255) NOT NULL,
  `status` varchar(255) DEFAULT NULL,
  `icq` varchar(55) NOT NULL,
  `phone` varchar(55) NOT NULL,
  `skype` varchar(55) NOT NULL,
  `surname` varchar(55) NOT NULL,
  `name` varchar(55) NOT NULL,
  `ochestvo` varchar(55) NOT NULL,
  `place` varchar(255) NOT NULL,
  `age` int(3) NOT NULL,
  `sex` int(1) NOT NULL,
  `birthday` varchar(55) NOT NULL,
  `hobby` varchar(255) NOT NULL,
  `signature` mediumtext,
  `points` int(11) DEFAULT '0',
  `carma` int(11) NOT NULL,
  `user_comments` int(11) NOT NULL,
  `user_news` int(11) NOT NULL,
  `group` int(3) NOT NULL,
  `exgroup` int(3) NOT NULL,
  `last_visit` int(11) NOT NULL,
  `regdate` int(11) NOT NULL,
  `active` int(1) NOT NULL,
  `mailsend` int(1) NOT NULL,
  `distsend` int(1) NOT NULL,
  `no_mail` int(1) NOT NULL,
  `audio_alert` int(11) NOT NULL,
  `dist_id` int(11) NOT NULL,
  `ip` varchar(55) NOT NULL,
  `fields` mediumtext NOT NULL,
  `avatar_auth` varchar(255) NOT NULL,
  `bday_visibility` int(11) NOT NULL,
  `twofactor` tinyint(1) NOT NULL,
  `key_pin` int(11) NOT NULL,
  `attempt` tinyint(4) NOT NULL,
  `banned_time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nick_2` (`nick`),
  KEY `nick` (`nick`),
  KEY `ip` (`ip`),
  KEY `active` (`active`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `[prefix]xfields`;
CREATE TABLE `[prefix]xfields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `type` smallint(1) NOT NULL,
  `content` mediumtext NOT NULL,
  `to_user` int(1) NOT NULL,
  `module` varchar(55) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;