<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('AJAX')) {
    header('Location: /');
    exit;
}
global $lang;
function vote(): void
{
    global $core;
    if ($core->auth->group_info['allowRating'] == 0) return;
    $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
    $module = isset($_REQUEST['module']) ? filter($_REQUEST['module'], 'module') : '';
    $num = isset($_REQUEST['num']) ? intval($_REQUEST['num']) : false;
    list($check) = $core->fetch_data('ratings', '(uid="' . $core->auth->user_id . '" OR ip="' . getRealIpAddr() . '") AND id="' . $id . '"', 'time');
    if (!empty($module) && !$check && $num <= 10 && $id > 0) {
        $uid = 0;
        $core->upd_data($module, 'score = score+"' . $num . '", votes = votes+1', 'id = "' . $id . '"');
        $data = $core->row_data($module, 'id = "' . $id . '"', false, 'score, votes');
        if ($core->auth->isUser) $uid = $core->auth->user_id;
        $core->ins_data('ratings', false, 'NULL, "' . $id . '", "' . $uid . '", "' . $module . '", "' . time() . '", "' . getRealIpAddr() . '"');
        echo draw_rating($id, $module, $data['score'], $data['votes'], 1);
    } else {
        echo draw_rating($id, $module, 0, 0, 0);
    }
}

function carma_vote(): void
{
    global $core, $user, $lang;
    $result = '';
    if ($core->auth->group_info['allowRating'] == 0) return;
    $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
    $type = isset($_REQUEST['type']) ? intval($_REQUEST['type']) : false;
    list($check) = $core->fetch_data('ratings', '(uid="' . $core->auth->user_id . '" OR ip="' . getRealIpAddr() . '") AND `mod` = "news" AND id="' . $id . '"', 'time');
    if (!empty($type) && !$check && !empty($id)) {
        switch ($type) {
            case 1:
                $core->upd_data('news', 'score = score+1', 'id = "' . $id . '"');
                break;
            case 2:
                $core->upd_data('news', 'votes = votes+1', 'id = "' . $id . '"');
                break;
        }
        $data = $core->row_data('news', 'id = "' . $id . '"', false, 'score, votes');
        $core->ins_data('ratings', false, 'NULL, "' . $id . '", "' . $core->auth->user_id . '", "news", "' . time() . '", "' . getRealIpAddr() . '"');
        $result .= $lang['rrating'] . draw_rating($id, 'news', $data['score'], $data['votes']);
        $score = $data['score'];
        $votes = $data['votes'];
        $result .= $lang['rrating'] . !$core->auth->isUser ? ($user['carma_summ'] ? ((intval($score) - $votes) > 0 ? '<span class="rating_plus">+' . (intval($score) - $votes) . '</span>' : ((intval($score) - $votes) == 0 ? '<span class="rating_zero">0</span>' : '<span class="rating_minus">' . (intval($score) - $votes) . '</span>')) : ((intval($score) - $votes) > 0 ? '<span class="rating_plus">+' . (intval($score) - $votes) . '</span>' : ((intval($score) - $votes) == 0 ? '<span class="rating_zero">0</span>' : '<span class="rating_minus">' . (intval($score) - $votes) . '</span>'))) : ($user['carma_summ'] ? ((intval($score) - $votes) > 0 ? '<span class="rating_plus">+' . (intval($score) - $votes) . '</span>' : ((intval($score) - $votes) == 0 ? '<span class="rating_zero">0</span>' : '<span class="rating_minus">' . (intval($score) - $votes) . '</span>')) : (($score + $votes) > 0 ? '<span class="rating_plus">' . ($score > 0 ? '+' . intval($score) : intval($score)) . '</span> <span class="rating_minus">' . ($votes > 0 ? '-' . $votes : $votes) . '</span>' : '<span class="rating_zero">0</span>'));
    } else {
        $result .= $lang['already_voted'];
    }
    echo $result;

}

function board_carma_vote(): void
{
    global $core, $user, $lang;
    $result = '';
    if ($core->auth->group_info['allowRating'] == 0) return;
    $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
    $type = isset($_REQUEST['type']) ? intval($_REQUEST['type']) : false;
    list($check) = $core->fetch_data('ratings', '(uid="' . $core->auth->user_id . '" OR ip="' . getRealIpAddr() . '") AND `mod` = "board" AND id="' . $id . '"', 'time');
    if (!empty($type) && !$check && !empty($id)) {
        switch ($type) {
            case 1:
                $core->upd_data('board_threads', 'score = score+1', 'id = "' . $id . '"');
                break;
            case 2:
                $core->upd_data('board_threads', 'votes = votes+1', 'id = "' . $id . '"');
                break;
        }
        $data = $core->row_data('board_threads', 'id = "' . $id . '"', false, 'score, votes');
        $core->ins_data('ratings', false, 'NULL, "' . $id . '", "' . $core->auth->user_id . '", "board", "' . time() . '", "' . getRealIpAddr() . '"');
        $result .= $lang['rrating'] . draw_rating($id, 'board', $data['score'], $data['votes']);
        $score = $data['score'];
        $votes = $data['votes'];
        $result .= $lang['rrating'] . !$core->auth->isUser ? ($user['carma_summ'] ? ((intval($score) - $votes) > 0 ? '<span class="rating_plus">+' . (intval($score) - $votes) . '</span>' : ((intval($score) - $votes) == 0 ? '<span class="rating_zero">0</span>' : '<span class="rating_minus">' . (intval($score) - $votes) . '</span>')) : ((intval($score) - $votes) > 0 ? '<span class="rating_plus">+' . (intval($score) - $votes) . '</span>' : ((intval($score) - $votes) == 0 ? '<span class="rating_zero">0</span>' : '<span class="rating_minus">' . (intval($score) - $votes) . '</span>'))) : ($user['carma_summ'] ? ((intval($score) - $votes) > 0 ? '<span class="rating_plus">+' . (intval($score) - $votes) . '</span>' : ((intval($score) - $votes) == 0 ? '<span class="rating_zero">0</span>' : '<span class="rating_minus">' . (intval($score) - $votes) . '</span>')) : (($score + $votes) > 0 ? '<span class="rating_plus">' . ($score > 0 ? '+' . intval($score) : intval($score)) . '</span> <span class="rating_minus">' . ($votes > 0 ? '-' . $votes : $votes) . '</span>' : '<span class="rating_zero">0</span>'));
    } else {
        $result .= $lang['already_voted'];
    }
    echo $result;
}

function fast_edit(): void
{
    global $core, $user, $lang;
    $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
    $module = isset($_REQUEST['module']) ? filter($_REQUEST['module'], 'module') : '';
    $type = isset($_REQUEST['type']) ? explode('/', $_REQUEST['type']) : false;
    $type = filter($type[0], 'a');
    switch ($module) {
        default:
            return;
            break;
        case "news":
            $data = $core->row_data('langs', 'postId = "' . $id . '" AND `module`="news"', false, $type);
            break;
    }
    if ($core->auth->isAdmin && !isset($_REQUEST['blocked'])) {
        echo "<form action=\"javascript:fast_post('" . $type . '-' . $id . "');\" name=\"fast\" id=\"fast\">";
        $bb_area = $user['editor'] == "htmlEditor" ? 'bb_area' : 'edit_area';
        echo $bb_area('edit', stripslashes($core->bbDecode(html2bb(parseBB($data[$type])))), 6, 'textarea', false, true);
        echo "<input type=\"hidden\" id=\"id\" value=\"$id\"/>";
        echo "<input type=\"hidden\" id=\"module\" value=\"$module\"/>";
        echo "<input type=\"hidden\" id=\"type\" value=\"$type\"/>";
        echo "<div style=\"text-align:right;\"> <br/><input type=\"submit\" name=\"button\" value=\"" . $lang['apply'] . "\" class=\"b\"/> <input type=\"submit\" name=\"button\" value=\"" . $lang['cancel'] . "\" onclick=\"fastCancel(" . $id . ", '$module', '$type', '" . $type . "-" . $id . "');\" class=\"b\"/></div>";
        echo "</form>";
    } else {
        echo $core->bbDecode($data[$type], $id);
    }
}

function fast_save(): void
{
    global $db, $core, $lang;
    $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
    $module = isset($_REQUEST['module']) ? filter($_REQUEST['module'], 'module') : '';
    $type = isset($_REQUEST['type']) ? filter($_REQUEST['type'], 'a') : '';
    $text = filter(utf_decode($_REQUEST['text']), 'html');
    if ($text && $id && $module && $type) {
        $core->upd_data('langs', '"' . $type . '=' . $db->safesql(parseBB(processText($text), $id, true)) . '"', 'postId= "' . $id . '" AND module="news"');
        echo $core->bbDecode(parseBB($text, $id, true), $id);
    } else {
        echo $lang['impossible_empty'] . '<a href="javascript:void(0);" onclick="fast_edit(\'' . $id . '\', \'' . $type . '\', \'news\')">' . $lang['back'] . '</a>';
    }
}

function commentDeleteAjax(): void
{
    global $core, $db, $lang;
    $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
    $mod = isset($_REQUEST['mod']) ? filter($_REQUEST['mod'], 'module') : '';
    $nid = isset($_REQUEST['nid']) ? intval($_REQUEST['nid']) : false;
    $data = $core->row_data('comments', 'id = "' . $id . '" AND module="' . $db->safesql($mod) . '" AND post_id="' . $nid . '"', false, 'uid, text');
    if ($data && ($core->auth->isAdmin or $core->auth->isUser && $core->auth->user_id == $data['uid']) && !isset($_REQUEST['blocked'])) {
        deleteComments($id, $mod, $nid, $core->auth->user_id);
        echo '<div style="text-align: center;">' . colorSpan('green', $lang['message_deleted']) . '</div>';
    } else {
        echo colorSpan('red', $lang['message_notdeleted']);
    }
}

function commentSubscribe(): void
{
    global $core, $user, $lang;
    if ($core->auth->isUser && $user['commentSubscribe'] == 1) {
        $id = isset($_REQUEST['nid']) ? intval($_REQUEST['nid']) : false;
        $do = isset($_REQUEST['do']) ? intval($_REQUEST['do']) : false;
        $mod = isset($_REQUEST['mod']) ? filter($_REQUEST['mod'], 'module') : '';
        if ($do == 1) {
            $core->ins_data('com_subscribe', 'id,module,uid', '"' . $id . '", "' . $mod . '", "' . $core->auth->user_id . '"');
            $info = $lang['commsubscribe'];
        } else {
            $core->del_data('com_subscribe', 'id = "' . $id . '" AND module = "' . $mod . '" AND uid = "' . $core->auth->user_id . '"');
            $info = $lang['communsubscribe'];
        }
        echo $info;
    }
}

function wallSubscribe(): void
{
    global $core, $user, $lang;
    if ($core->auth->isUser && $user['commentSubscribe'] == 1) {
        $id = isset($_REQUEST['nid']) ? intval($_REQUEST['nid']) : false;
        $do = isset($_REQUEST['do']) ? intval($_REQUEST['do']) : false;
        $mod = isset($_REQUEST['mod']) ? filter($_REQUEST['mod'], 'module') : '';
        if ($do == 1) {
            $core->ins_data('com_subscribe', 'id,module,uid', '"' . $id . '", "' . $mod . '", "' . $core->auth->user_id . '"');
            $info = $lang['wallsubscribe'];
        } else {
            $core->del_data('com_subscribe', 'id = "' . $id . '" AND module = "' . $mod . '" AND uid = "' . $core->auth->user_id . '"');
            $info = $lang['wallunsubscribe'];
        }
        echo $info;
    }
}

function commentPage(): void
{
    global $lang;
    $mod = isset($_REQUEST['mod']) ? filter($_REQUEST['mod'], 'module') : '';
    $pid = isset($_REQUEST['pid']) ? intval($_REQUEST['pid']) : '';
    $page = isset($_REQUEST['page']) ? intval($_REQUEST['page']) : '';
    $commNum = isset($_REQUEST['commNum']) ? intval($_REQUEST['commNum']) : '';
    $info = '';
    if ($mod && $pid && $page && $commNum) {
        show_comments($mod, $pid, $commNum, true, $page);
    } else {
        $info = $lang['error'];
    }
    echo $info;
}

function wallPage(): void
{
    global $lang;
    $info = '';
    $pid = isset($_REQUEST['pid']) ? intval($_REQUEST['pid']) : false;
    $mod = isset($_REQUEST['mod']) ? filter($_REQUEST['mod'], 'module') : '';
    $page = isset($_REQUEST['page']) ? intval($_REQUEST['page']) : false;
    $commNum = isset($_REQUEST['commNum']) ? intval($_REQUEST['commNum']) : '';
    if ($mod && $pid && $page && $commNum) {
        show_user_wall($mod, $pid, $commNum, true, $page);
    } else {
        $info = $lang['error'];
    }
    echo $info;
}

function captcha(): void
{
    if (!isset($_SESSION)) session_start();
    $captcha = new KCAPTCHA;
    $_SESSION['securityCode'] = $captcha->getKeyString();
}

function comment_savea()
{
    global $db, $core, $user, $config, $email_conf, $lang;
    $bb = new bb;
    $subscribe = '';
    if ($config['comments'] == 0 || $core->auth->group_info['addComment'] == 0) return;
    $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
    $reply_to = isset($_REQUEST['reply_to']) ? intval($_REQUEST['reply_to']) : false;
    $text = $_REQUEST['text'] ?? false;
    $gauthor = isset($_REQUEST['author']) ? filter($_REQUEST['author'], 'a') : '';
    $email = $core->auth->isUser ? '' : filter($_REQUEST['email'], 'mail');
    $mod = isset($_REQUEST['mod']) ? filter($_REQUEST['mod'], 'a') : '';
    $commNum = isset($_REQUEST['commNum']) ? intval($_REQUEST['commNum']) : false;
    $time = time();
    $uid = $core->auth->isUser ? $core->auth->user_id : 0;
    $author = $core->auth->isUser ? '' : $lang['guest'] . $gauthor;
    $guest = !$core->auth->isUser;
    if (!$core->auth->isUser) if (!captcha_check('securityCode')) $core->tpl->info($lang['captcha_notvalid']);
    if ($guest) {
        if (empty($gauthor) || empty($email)) {
            $info = empty($email) ? $lang['email_badformat'] : $lang['not_filled'];
            $core->tpl->info($info);
        } else {
            if (!isset($_COOKIE)) {
                setcookie('commentator', $gauthor, time() + 86400, '/');
                setcookie('email', $email, time() + 86400, '/');
            }
        }
    }
    if ($user['commentSubscribe'] == 1) $subscribe = isset($_REQUEST['subscribe']) ? intval($_REQUEST['subscribe']) : false;
    if (!isset($_SESSION)) session_start();
    if (isset($_SESSION['lastComment']) && (time() - $_SESSION['lastComment'] < $user['commentOften'])) $warning[] = str_replace('{time}', $user['commentOften'], $lang['often_query']);
    if (!isset($warning)) {
        if ($text && eregStrt($_SERVER['HTTP_HOST'], $_SERVER['HTTP_REFERER'])) {
            $text = $bb->parse(processText(filter($text, 'html')), '', true);
            $parent = ($core->auth->isUser && $reply_to > 0 && $user['commentTree'] == 1 ? $reply_to : 0);
            $core->ins_data('comments', 'id,uid,post_id,module,text,date,editdate,gemail,gname,gurl,parent,status', 'NULL,"' . $uid . '","' . $id . '","' . $mod . '","' . $db->safesql($text) . '","' . $time . '",0,"' . $email . '","' . $author . '", "","' . $parent . '",1');
            delcache('userInfo_' . $uid);
            if ($user['commentSubscribe'] == 1 && $core->auth->isUser && $subscribe == 1 ? $lang['yes1'] : '' && $uid != $core->auth->user_id) {
                require_once ROOT . '/etc/email.config.php';
                if ($email_conf['subscribe_mail'] == 1) {
                    require_once ROOT . '/boot/mail.class.php';
                    $query = $core->select_data('email', false, 'id ASC');
                    $row = $core->row_data('com_subscribe', 'id = "' . $id . '"');
                    $from = $core->row_data('users', 'id = "' . $row['uid'] . '"');
                    while ($result = $db->getRow($query)) {
                        $message = $result['html_subscribe_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%date%}', '{%text%}', '{%url%}'), array('<', '>', $from['nick'], formatDate(time(), true), $text, $config['url']), $result['subscribe_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%date%}', '{%text%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $from['nick'], formatDate(time(), true), $text, $config['url']), $result['subscribe_mail_text']);
                        mailSMTP($from['email'], $result['subscribe_mail_text'], $lang['com_subscribe'], $message);
                    }
                }
            }
            if ($core->auth->isUser && $mod != 'profile') user_points($uid, 'add_comment');
            if ($mod != 'profile') add_point($mod, $id);
        } else {
            $core->tpl->info($lang['empty_text']);
            exit;
        }
    }
    if (isset($warning)) {
        show_comments($mod, $id, $commNum, true, false, $warning);
    } else {
        $_SESSION['lastComment'] = time();
        show_comments($mod, $id, $commNum, true, false, true);
    }
    return true;
}

function commentEditAjax(): void
{
    global $core, $user, $lang;
    $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
    $data = $core->row_data('comments', 'id = "' . $id . '"', false, 'uid, text');
    if ($data && ($core->auth->isAdmin or $core->auth->isUser && $core->auth->user_id == $data['uid']) && !isset($_REQUEST['blocked'])) {
        $text = preg_replace("#\n---\n<\!--edit-->(.*)<\!--edit-end-->#i", '', $data['text']);
        $bb_area = $user['editor'] == "htmlEditor" ? 'bb_area' : 'edit_area';
        echo "<form action=\"javascript:commentEditSave('comment_" . $id . "');\" name=\"fast\" id=\"fast\">";
        echo $bb_area('text', stripslashes($core->bbDecode(html2bb($text))), 6, 'textarea', false, true);
        echo "<input type=\"hidden\" id=\"id\" value=\"$id\"/>";
        echo "<div style=\"text-align:right;\"> <br/><input type=\"submit\" name=\"button\" value=\"" . $lang['apply'] . "\" class=\"hbutton\"/> <input type=\"button\" name=\"button\" value=" . $lang['cancel'] . " onclick=\"commentCancel(" . $id . ");\" class=\"hbutton\"/></div>";
        echo "</form>";
    }
}

function commentEditAjaxSave(): void
{
    global $db, $core, $user, $lang;
    $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
    $text = isset($_REQUEST['text']) ? filter(utf_decode(htmlspecialchars_decode($_REQUEST['text'])), 'text') : '';
    $time = time();
    $data = $core->row_data('comments', 'id = "' . $id . '"', false, 'uid, text');
    if ($text && $id && $data && ($core->auth->isAdmin or $core->auth->isUser && $core->auth->user_id == $data['uid'])) {
        if (!empty($user['commentEditText'])) {
            $arrayReplace = array('{user}' => $core->auth->user_info['nick'], '{date}' => formatDate(time()));
            $text .= "\n---\n<!--edit-->" . str_replace(array_keys($arrayReplace), array_values($arrayReplace), $user['commentEditText']) . "<!--edit-end-->";
        }
        $core->upd_data('comments', 'text= "' . $db->safesql($text) . '",editdate= "' . $time . '"', 'id= "' . $id . '"');
        $info = stripslashes($core->bbDecode(parseBB($text)));
    } else {
        $info = $lang['impossible_empty'] . '<a href="javascript:void(0);" onclick="commentEdit(\'' . $id . '\', \'comment_' . $id . '\')">' . $lang['back'] . '</a>';
    }
    echo $info;
}

function findrelated($info): void
{
    echo '<div class="findrelated">' . $info . ' </div>';

}


function alt_title(): void
{
    global $core, $db, $lang;
    $title = isset($_REQUEST['title']) ? filter(utf_decode(urldecode($_REQUEST['title'])), 'title') : '';
    list($check) = $core->fetch_data('langs', 'title="' . $db->safesql($title) . '"', '_id');
    $info = $check > 0 ? colorSpan('red', $lang['error_alt_title']) : colorSpan('green', str_replace('{title}', $title, $lang['alt_title']));
    findrelated($info);
}

function alt_btitle(): void
{
    global $core, $db, $lang;
    $title = isset($_REQUEST['title']) ? filter(utf_decode(urldecode($_REQUEST['title'])), 'title') : '';
    list($check) = $core->fetch_data('board_threads', 'title="' . $db->safesql($title) . '"', 'id');
    $info = $check > 0 ? colorSpan('red', $lang['forum_error_alt_title']) : colorSpan('green', str_replace('{title}', $title, $lang['forum_alt_title']));
    findrelated($info);
}

function alt_cats(): void
{
    global $core, $db, $lang;
    $name = isset($_REQUEST['name']) ? filter(utf_decode(urldecode($_REQUEST['name'])), 'name') : '';
    list($check) = $core->fetch_data('categories', 'name="' . $db->safesql($name) . '"');
    $info = $check > 0 ? colorSpan('red', $lang['error_alt_cats']) : colorSpan('green', str_replace('{name}', $name, $lang['alt_cats']));
    findrelated($info);
}

function alt_tagcode(): void
{
    global $core, $lang;
    $title = isset($_REQUEST['title']) ? filter(utf_decode(urldecode($_REQUEST['title'])), 'title') : '';
    list($check) = $core->fetch_data('tagcode', 'tag="' . translit($title) . '"', 'id');
    $info = $check > 0 ? colorSpan('red', $lang['tagcode_alt_error']) : colorSpan('green', str_replace('{title}', $title, $lang['tagcode_alt_ok']));
    findrelated($info);
}

function alt_redir(): void
{
    global $core, $db, $lang;
    $oldurl = isset($_REQUEST['oldurl']) ? filter(utf_decode(urldecode($_REQUEST['oldurl'])), 'oldurl') : '';
    list($check) = $core->fetch_data('redirects', 'oldurl="' . $db->safesql($oldurl) . '"');
    $info = $check > 0 ? colorSpan('red', $lang['redirects_alt_error']) : colorSpan('green', str_replace('{oldurl}', $oldurl, $lang['redirects_alt_ok']));
    findrelated($info);
}

function alt_rssinform(): void
{
    global $core, $lang;
    $title = isset($_REQUEST['title']) ? filter(utf_decode(urldecode($_REQUEST['title'])), 'title') : '';
    list($check) = $core->fetch_data('feed', 'tags="' . translit($title) . '"');
    $info = $check > 0 ? colorSpan('red', $lang['feed_alt_error']) : colorSpan('green', str_replace('{title}', $title, $lang['feed_alt_ok']));
    findrelated($info);
}

function smile_icon(): void
{
    $cat = isset($_REQUEST['cat']) ? filter(utf_decode(urldecode($_REQUEST['cat'])), 'cat') : '';
    $dir = 'media/smiles/';
    if ($cat == 'smile') {
        $smile_dir = $dir . 'smile';
    } elseif ($cat == 'people') {
        $smile_dir = $dir . 'people';
    } elseif ($cat == 'animals') {
        $smile_dir = $dir . 'animals';
    } elseif ($cat == 'food') {
        $smile_dir = $dir . 'food';
    } elseif ($cat == 'activities') {
        $smile_dir = $dir . 'activities';
    } elseif ($cat == 'travel') {
        $smile_dir = $dir . 'travel';
    } elseif ($cat == 'objects') {
        $smile_dir = $dir . 'objects';
    } elseif ($cat == 'symbols') {
        $smile_dir = $dir . 'symbols';
    } elseif ($cat == 'flags') {
        $smile_dir = $dir . 'flags';
    } else {
        $smile_dir = '';
    }
    echo $smile_dir;
}

function board_icon(): void
{
    $icon = isset($_REQUEST['icon']) ? filter(utf_decode(urldecode($_REQUEST['icon'])), 'icon') : '';
    foreach (glob(ROOT . 'media/board/theme_icon/*.gif') as $file) {
        $selected = ($icon == basename($file)) ? "selected" : "";
        $icon .= '<option value="' . basename($file) . '" ' . $selected . '>&nbsp;' . Bicon(basename($file), 't', false, true) . '</option>';
    }
    echo $icon;
}

function alt_domen(): void
{
    global $core, $db, $lang;
    $search = isset($_REQUEST['search']) ? filter(utf_decode(urldecode($_REQUEST['search'])), 'search') : '';
    $domen = $core->select_data('key_domen', 'dir LIKE "%' . $db->safesql($search) . '%" LIMIT 5 ;');
    $result = '';
    echo '<div id="quicksearch">';
    if ($db->numRows($domen) > 0 && $search) {
        while ($rows = $db->getRow($domen)) {
            $descript = $rows['dir'] > 150 ? $rows['dir'] : internoetics_mb_strimwidth($rows['dir']);
            $description = str_replace(array('""', '""'), array('&amp;', '&'), $descript);
            $result .= '<a href="' . ADMIN . '/module/key_domen/view/' . $rows['id'] . '\"><span>' . $description . '</span></a><br class="break"/>';
        }
    } else {
        $result .= colorSpan('red', $lang['nothing_found']);
    }
    echo $result . '</div>';
}

function check_login(): void
{
    global $core, $db, $lang;
    $nick = isset($_REQUEST['nick']) ? filter(utf_decode(urldecode($_REQUEST['nick'])), 'nick') : '';
    list($check) = $core->fetch_data('users', 'nick="' . $db->safesql($nick) . '"');
    $info = preg_match("/[\||\'|\<|\>|\"|\!|\]|\?|\$|\@|\/|\\\|\&\~\*\+]/", $nick) ? colorSpan('red', $lang['error_characters_login']) : ($check > 0 ? colorSpan('red', $lang['user_exists']) : colorSpan('green', str_replace('{uname}', $nick, $lang['user_free'])));
    echo $info;
}

function validate_text(): void
{
    global $lang;
    $text = isset($_REQUEST['text']) ? filter(utf_decode(urldecode($_REQUEST['text'])), 'text') : '';
    $info = preg_match("/[^(\w)|(\x7F-\xFF)|(\s)]/", $text) ? colorSpan('red', $lang['error_characters_text']) : '';
    echo $info;
}

function validate_name($data): int|string
{
    $err = ""; /* присваиваем переменной $err пустую строку */
    if (strlen($data) < 2 || strlen($data) > 50) /* если длина переменной $data меньше 2 или больше 50 символов*/
        $err = "Длина имени должна быть от 2 до 50 символов";
    if (preg_match("/[^(\w)|(\x7F-\xFF)|(\s)]/", $data)) /* если в имени содержатся недопустимые символы */
        $err = $err . "<p>В написании имени допустимы только буквы латинского и русского алфавита,цифры, символ подчеркивания и пробел</p>";
    if (!empty($err))
        return ($err);
    else
        return 0;
}

function validate_email($data): int|string
{
    $err = "";
    if (strlen($data) < 3 || strlen($data) > 50) /* если длина email меньше 3 и больше 50 */
        $err = "Email должен быть от 3 до 50 символов"; /*записываем в переменную $err сообщение об ошибке */
    if (!preg_match('#^([\w]+\.?)+(?<!\.)@(?!\.)[a-zа-я0-9ё\.-]+\.?[a-zа-яё]{2,}$#ui', $data)) /* если введенный адрес недопустимого формата */
        $err = $err . "<p>Недопустимый формат email-адреса</p>";  /*записываем в переменную $err сообщение об ошибке */
    if (!empty($err))
        return ($err);
    else
        return 0;
}

function validate_inputs($data_name, $data_email): int|string
{
    $err = "";
    $err_name = validate_name($data_name); /* вызываем функцию валидации имени пользователя */
    $error_email = validate_email($data_email); /* вызываем функцию валидации email-адреса пользователя */
    if (!empty($err_name))
        $err = $err_name;
    if (!empty($error_email))
        $err = $err . $error_email;
    return $err;
}

/**
 *
 */
function check_email(): void
{
    global $core, $db, $lang;
    $request = $_REQUEST['email'] ?? $_REQUEST['mail'];
    $email = isset($request) ? filter(utf_decode(urldecode($request)), 'email') : '';
    list($check) = $core->fetch_data('users', 'email="' . $db->safesql($email) . '"');
    echo !preg_match("/^(?:[a-z0-9]+(?:[-_.]?[a-z0-9]+)?@[a-z0-9_.-]+(?:\.?[a-z0-9]+)?\.[a-z]{2,5})$/i", $email) ? colorSpan('red', $lang['error_characters_email']) : ($check > 0 ? colorSpan('red', $lang['email_exists']) : colorSpan('green', str_replace('{email}', $email, $lang['email_free'])));
}

function cal($op): void
{
    require ROOT . 'usr/plugins/calendar.plugin.php';
    calendar($op);
}

function internoetics_mb_strimwidth($string, $start = 0, $width = 150, $trimmarker = '...')
{
    $len = strlen(trim($string));
    return ($len > 150) ? rtrim(mb_strimwidth($string, $start, $width - strlen($trimmarker))) . $trimmarker : $string;
}

function searchList(): void
{
    global $core, $db, $lang;
    $query = isset($_REQUEST['query']) ? filter(utf_decode(urldecode($_REQUEST['query'])), 'query') : '';
    $limit = 'LIMIT 3';
    $where = 'title LIKE "%' . $db->safesql($query) . '%" AND active=1 ' . $limit;
    $news = $core->select_data('news', $where, false, 'n.*, c.*', 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="news")');
    $content = $core->select_data('content', $where, false, 'c.*, l.*', 'as c LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=c.id and l.module="content")');
    $result = NULL;
    $all = 0;
    $link = 'search/' . $query . '/';
    $as = '';
    $select = '';
    echo '<div id="quicksearch">';
    if ($db->numRows($news) > 0 && $query) {
        while ($rows = $db->getRow($news)) {
            $module = 'news';
            $select = 'count(n.id)';
            $as = 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="news")';
            $news_link = $rows['cat'] !== ',0,' ? 'news/' . $core->getCat('news', $rows['cat'], 'development') . '/' : 'news/';
            $descript = $rows['short'] > 150 ? $rows['short'] : internoetics_mb_strimwidth($rows['short'], 0, 150, $trimmarker = '...');
            $description = str_replace(array('""', '""'), array('&amp;', '&'), $descript);
            $result .= '<a href="' . $news_link . $rows['altname'] . '.html"><span class="searchhead">' . $rows['title'] . '</span><span>' . $description . '</span></a><br class="break"/>';
        }
    } elseif ($db->numRows($content) > 0 && $query) {
        while ($rows = $db->getRow($content)) {
            $module = 'content';
            $select = 'count(c.id)';
            $as = ' as c LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=c.id and l.module="content")';
            $content_link = $rows['cat'] !== ',0,' ? 'content/' . $core->getCat('content', $rows['cat'], 'development') . '/' : 'content/';
            $descript = $rows['description'] > 150 ? $rows['description'] : internoetics_mb_strimwidth($rows['description'], 0, 150, $trimmarker = '...');
            $description = str_replace(array('""', '""'), array('&amp;', '&'), $descript);
            $result .= '<a href="' . $content_link . $rows['translate'] . '.html"><span class="searchhead">' . $rows['keywords'] . '</span><span>' . $description . '</span></a><br class="break"/>';
        }
    }
    if (isset($module)) list($all) = $core->fetch_data($module, $where, $select, $as);
    $result = !isset($result) ? $result . '<a href="/"><span class="searchhead">' . $lang['nothing_found'] . '</span></a><br class="break"/>' : $result . '
   <a href="' . $link . '" style="text-align:center"><span class="searchhead">Всего найдено ' . $all . '</span></a></center>
   <br class="break"/>';
    echo $result . '</div>';
}

function carmaHistory(): void
{
    global $core, $db, $lang;
    $uid = isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : false;
    $q = $core->select_data('user_carma ', 'c.to="' . $uid . '"', 'c.time DESC', 'c.*, d.nick as fromnick', 'as c LEFT JOIN ' . DB_PREFIX . '_users as d on(c.from=d.id)');
    $show = '';
    if ($db->numRows($q) > 0) {
        echo '<div style="max-height:250px; overflow:auto;"><hr/>';
        while ($rows = $db->getRow($q)) {
            switch ($rows['do']) {
                case 'p':
                    $show = '<img src="media/edit/plus.png" style="vertical-align:middle; border: 0;" alt=""/>';
                    break;
                case 'm':
                    $show = '<img src="media/edit/minus.png" style="vertical-align:middle; border: 0;" alt=""/>';
                    break;
                case 'n':
                    $show = '<img src="media/edit/ok.png" style="vertical-align:middle; border: 0;" alt=""/>';
                    break;
            }
            echo $show . '<i>от: <a href="profile/' . $rows['fromnick'] . '">' . $rows['fromnick'] . '</a> [' . formatDate($rows['time'], true) . ']</i><br/><b>' . $rows['text'] . '</b><hr/>';
        }
        echo '</div>';
    } else {
        echo '<div class="mbmest">' . $lang['carmanochanges'] . '</div>';
    }
}

function addCarma(): void
{
    global $core;
    $do = '';
    $uid = isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : false;
    $does = isset($_REQUEST['does']) ? filter($_REQUEST['does'], 'a') : '';
    $text = isset($_REQUEST['text']) ? utf_decode(filter($_REQUEST['text'])) : '';
    switch ($does) {
        case 'p':
            $do = '+1';
            break;
        case 'm':
            $do = '-1';
            break;
        case 'n':
            $do = 0;
            break;
    }
    if (!isset($_COOKIE['carma-' . $uid]) && $core->auth->isUser && $core->auth->user_info['id'] != $uid) {
        if ($do != 0) $core->upd_data('users', 'carma = carma' . $do, 'id= "' . $uid . '"');
        setcookie('carma-' . $uid, time(), time() + 86400, '/');
        $core->ins_data('user_carma', '_id,from,to,text,do,time', 'NULL, "' . intval($core->auth->user_info['id']) . '", "' . intval($uid) . '", "' . $text . '", "' . $does . '", "' . time() . '"');
        if ($does == 'p') user_points($uid, 'carma');
        list($points) = $core->fetch_data('users', 'id = "' . $uid . '"', 'carma');
        $info = ($points > 0) ? '+' . $points : $points;
    } else {
        $info = '0';
    }
    echo $info;
}

function editTitle(): void
{
    global $db, $core, $lang, $config;
    if ($core->auth->isAdmin) {
        $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
        $text = isset($_REQUEST['text']) ? trim(filter(utf_decode($_REQUEST['text']))) : '';
        $module = isset($_REQUEST['module']) ? filter($_REQUEST['module'], 'module') : '';
        switch ($module) {
            case 'blocks':
                $core->upd_data('plugins', 'title = "' . $db->safesql(processText($text)) . '"', 'id = "' . $id . '"');
                break;
            case 'news':
                $core->upd_data('langs', 'title = "' . $db->safesql(processText($text)) . '"', 'postId = "' . $id . '" AND module="news" AND lang="' . $config['lang'] . '"');
                break;
            case 'content':
                $core->upd_data('langs', 'title = "' . $db->safesql(processText($text)) . '"', 'postId = "' . $id . '" AND module="content" AND lang="' . $config['lang'] . '"');
                break;
            case 'forum':
                $core->upd_data('board_forums', 'title = "' . $db->safesql(processText($text)) . '"', 'id = "' . $id . '"');
                break;
            case 'modules':
                $core->upd_data('plugins', 'content = "' . $db->safesql(processText($text)) . '"', 'id = "' . $id . '"');
                break;
            case 'blockTypes':
                $core->upd_data('block_types', 'title = "' . $db->safesql(processText($text)) . '"', 'type = "' . $id . '"');
                break;
            case 'poll':
                $core->upd_data('polls', 'title = "' . $db->safesql(processText($text)) . '"', 'id = "' . $id . '"');
                break;
            case 'group':
                $core->upd_data('groups', 'name = "' . $db->safesql(processText($text)) . '"', 'id = "' . $id . '"');
                break;
        }
        echo $text . ' - ' . colorSpan('green', $lang['title_update']);
    }
}

function _fileFf($format): string
{
    switch ($format) {
        default:
            $icon = 'blank.png';
            break;
        case 'doc':
            $icon = 'doc.png';
            break;
        case 'bmp':
            $icon = 'bmp.png';
            break;
        case 'jpg':
            $icon = 'jpg.png';
            break;
        case 'jpeg':
            $icon = 'jpeg.png';
            break;
        case 'png':
            $icon = 'png.png';
            break;
        case 'gif':
            $icon = 'gif.png';
            break;
        case 'psd':
            $icon = 'photoshop.png';
            break;
        case 'mp3':
        case 'wav':
        case 'wmv':
        case 'flv':
        case 'avi':
        case 'ogg':
            $icon = 'music.png';
            break;
        case 'pdf':
            $icon = 'finerider.png';
            break;
        case 'exe':
            $icon = 'exe.png';
            break;
        case 'txt':
            $icon = 'txt.png';
            break;
        case 'phps':
            $icon = 'php.png';
            break;
        case 'html':
        case 'htm':
            $icon = 'code.png';
            break;
        case 'rar':
        case 'zip':
        case '7z':
            $icon = 'rar.png';
            break;
    }
    return $icon;
}

function fileList(): void
{
    global $core, $db, $admin_conf, $lang;
    $id = isset($_REQUEST['id']) ? filter($_REQUEST['id'], 'a') : '';
    $module = isset($_REQUEST['module']) ? filter($_REQUEST['module'], 'module') : '';
    $delete = isset($_REQUEST['delete']) ? filter($_REQUEST['delete'], 'url') : '';
    $truncate = isset($_REQUEST['truncate']);
    $modDir = ROOT . 'files/' . $module . '/';
    $isHTML = $id == 'temp' && $admin_conf['htmlEditor'] == 1;
    if ($id && $module) {
        $pid = $id == 'temp' ? '0' : $id;
        $q = $core->select_data('attach', 'pub_id = "' . $pid . '"');
        while ($rows = $db->getRow($q)) {
            $dbArray[$rows['url']] = array($rows['id'], $rows['name']);
        }
        if (!is_dir($modDir)) {
            mkdir($modDir);
            @chmod_R($modDir, 0777);
            mkdir($modDir . 'temp');
            @chmod_R($modDir . 'temp', 0777);
        }
        $dir = ROOT . 'files/' . $module . '/' . $id . '/';
        $fileDir = 'files/' . $module . '/' . $id . '/';
        if (!is_dir($dir)) {
            mkdir($dir);
            @chmod_R($dir, 0777);
            mkdir($dir . 'thumb');
            @chmod_R($dir . 'thumb', 0777);
        } else {
            if (!is_dir($dir . 'thumb')) {
                mkdir($dir . 'thumb');
                @chmod_R($dir . 'thumb', 0777);
            }
        }
        if ($delete && file_exists($dir . $delete)) {
            unlink($dir . $delete);
            $core->del_data('attach', 'url = "' . $fileDir . $delete . '"');
            if (file_exists($dir . 'thumb/thumb-' . $delete)) unlink($dir . 'thumb/thumb-' . $delete);
            echo colorSpan('green', $lang['file_deleted'] . ' [' . $fileDir . $delete . ']');
        } elseif ($truncate) {
            unlinkRecursive($dir);
            unlinkRecursive($dir . 'thumb/');
        }
        echo '<table style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate;" class="upload">
   <tr>
      <th style=\"width=:75%;\">' . $lang['file'] . '</th>
      <th style=\"width=:10%;\">' . $lang['size'] . '</th>
      <th  style=\"width=:100px;text-align:center;\">' . $lang['actions'] . '</th>
   </tr>
   <tr>
      <th colspan="2" style="text-align:left"><img src="media/uploader/folder.png" class="icon" style="border:0; width:16px; height:16px;"/>' . $fileDir . '</th>
      <th style="text-align:right">
         <img src="media/uploader/trash.png" class="_pointer icon" style="border:0;" alt="' . $lang['clear_path'] . '" title="' . $lang['clear_path'] . '" onclick="fileList(\'' . $id . '\', \'' . $module . '\', \'truncate\', \'\');"/>
         <img src="media/uploader/reload.png" class="_pointer icon" style="border:0;" alt="' . $lang['updatefilelist'] . '" title="' . $lang['updatefilelist'] . '" onclick="fileList(\'' . $id . '\', \'' . $module . '\', \'ok\', \'\');"/>
      </th>
   </tr>';
        $dh = opendir($dir);
        $c = 0;
        $insertImages = '';
        $insertObject = '';
        while ($file = readdir($dh)) {
            if (is_file($dir . $file) && $file != '.' && $file != '..' && $file != 'Thumbs.db') {
                $yesFile = true;
                $fileInfo = explode('.', $file);
                $fileFormat = end($fileInfo);
                $deistv = '';
                $insertObjectS = isset($dbArray[$fileDir . $file]) ? '[attach=' . $dbArray[$fileDir . $file][0] . ']' : '';
                $icon = _fileFf($fileFormat);
                switch ($fileFormat) {
                    case 'bmp':
                    case 'jpg':
                    case 'jpeg':
                    case 'png':
                    case 'gif':
                        if ($isHTML) {
                            $iI = htmlspecialchars(parseBB((file_exists($dir . 'thumb/thumb-' . $file) ? '[thumb]' . $fileDir . 'thumb/thumb-' . $file . '[/thumb]' : '[img]' . $fileDir . $file . '[/img]')), ENT_QUOTES);
                            $insertObjectS = htmlspecialchars(parseBB((file_exists($dir . 'thumb/thumb-' . $file) ? '[thumb]' . $fileDir . 'thumb/thumb-' . $file . '[/thumb]' : '[img]' . $fileDir . $file . '[/img]')), ENT_QUOTES);
                            $insertJS = 'tinyMCE.execCommand(\'mceInsertContent\', false, \'' . $iI . '\');return false;';
                            $insertImages .= $iI;
                        } else {
                            $insertJS = 'insertCode(\'' . (file_exists($dir . 'thumb/thumb-' . $file) ? 'thumb' : 'img') . '\', \'center\', \'' . (file_exists($dir . 'thumb/thumb-' . $file) ? $fileDir . 'thumb/thumb-' . $file : $fileDir . $file) . '\');';
                            $insertImages .= file_exists($dir . 'thumb/thumb-' . $file) ? '[thumb]' . $fileDir . 'thumb/thumb-' . $file . '[/thumb]' : '[img]' . $fileDir . $file . '[/img]';
                            $insertObjectS = file_exists($dir . 'thumb/thumb-' . $file) ? '[thumb]' . $fileDir . 'thumb/thumb-' . $file . '[/thumb]' : '[img]' . $fileDir . $file . '[/img]';
                        }
                        $deistv .= '<img src="media/uploader/view.png" border="0" class="_pointer icon" alt="' . $lang['view'] . '" title="' . $lang['view'] . '" onclick="CaricaFoto(\'' . $fileDir . $file . '\');"/>';
                        $deistv .= '<img src="media/uploader/paste.png" border="0" class="_pointer icon" alt="' . $lang['image_past'] . '" title="' . $lang['image_past'] . '" onclick="' . $insertJS . '"/>';
                        break;
                    case 'exe':
                    case 'rar':
                    case 'zip':
                    case '7z':
                        $deistv .= '<a href="' . $fileDir . $file . '"><img src="media/uploader/save.png" class="_pointer icon" style="border:0;" alt="' . $lang['download_file'] . '"/></a>';
                        break;
                    case 'mp3':
                    case 'wav':
                    case 'ogg':
                        $insertJS = $isHTML ? 'tinyMCE.execCommand(\'mceInsertContent\', false, \'[audio]' . $fileDir . $file . '[/audio]\');return false;' : 'insertCode(\'audio\', \'\', \'' . $fileDir . $file . '\');';
                        $deistv .= '<img src="media/filetypes/music.png" border="0" class="_pointer icon" alt="Вставить аудиофайл" title="' . $lang['insertall_audio'] . '" onclick="' . $insertJS . '"/>';
                        $deistv .= '<a href="' . $fileDir . $file . '"><img src="media/uploader/save.png" class="_pointer icon" style="border:0;" alt="' . $lang['download_file'] . '"/></a>';
                        break;
                    case 'avi':
                    case 'flv':
                    case 'wmv':
                        $insertJS = $isHTML ? 'tinyMCE.execCommand(\'mceInsertContent\', false, \'[video]' . $fileDir . $file . '[/video]\');return false;' : 'insertCode(\'video\', \'\', \'' . $fileDir . $file . '\');';
                        $deistv .= '<img src="media/filetypes/video.png" border="0" class="_pointer icon" alt="Вставить видео" title="' . $lang['insertall_video'] . '" onclick="' . $insertJS . '"/>';
                        $deistv .= '<a href="' . $fileDir . $file . '"><img src="media/uploader/save.png" class="_pointer icon" style="border:0;" alt="' . $lang['download_file'] . '"/></a>';
                        break;
                }
                $insertObject .= $insertObjectS;
                $insertJS = $isHTML ? 'tinyMCE.execCommand(\'mceInsertContent\', false, \'' . $insertObjectS . '\');return false;' : 'insertIN(\'' . $insertObjectS . '\', \'' . $module . '\')';
                $deistv .= '<img src="media/uploader/insertall.png" border="0" class="_pointer icon" alt="' . $lang['attach_past'] . '" title="' . $lang['attach_past'] . '" onclick="' . $insertJS . '"/>';
                $deistv .= '<img src="/media/edit/cross.png" border="0" class="_pointer icon" alt="' . $lang['delete_file'] . '" title="' . $lang['delete_file'] . '" onclick="fileList(\'' . $id . '\', \'' . $module . '\', \'delete\', \'' . $file . '\');"/>';
                echo '<tr>
      <td><img src="/media/filetypes/' . $icon . '" style="border:0;" class="icon" width="16" height="16" alt="' . $file . '"/>' . $file . '&nbsp;' . (isset($dbArray[$fileDir . $file]) ? colorSpan('green', '<b>[db]</b>') : '') . '</td>
      <td style=\"text-align:center\">' . formatfilesize(filesize($dir . $file), true) . '</td>
      <td style=\"text-align:right\">' . $deistv . '</td>
   </tr>';
            }
        }
        closedir($dh);
        if (!isset($yesFile)) {
            echo '<tr>
      <td colspan="3">' . $lang['files_notfound'] . '</td>
   </tr>';
        }
        $insertJS1 = $isHTML ? 'tinyMCE.execCommand(\'mceInsertContent\', false, \'' . $insertObject . '\');return false;' : 'insertIN(\'' . $insertObject . '\', \'' . $module . '\')';
        $insertJS2 = $isHTML ? 'tinyMCE.execCommand(\'mceInsertContent\', false, \'' . $insertImages . '\');return false;' : 'insertIN(\'' . $insertImages . '\', \'' . $module . '\')';
        echo '<tr>
      <th colspan="2">
         <div style=\"text-align:left;\">' . $lang['fast_actions'] . '</div>
      </th>
      <th>
         <div  style=\"text-align:right\">
            <img src="media/uploader/insertall.png" class="_pointer icon" style="border:0;" alt="' . $lang['insertall_attach'] . '" title="' . $lang['insertall_attach'] . '" onclick="' . $insertJS1 . '"/>
            <img src="media/uploader/insertimages.png" class="_pointer icon" style="border:0;" alt="' . $lang['insertall_image'] . '" title="' . $lang['insertall_image'] . '" onclick="' . $insertJS2 . '"/>
            <img src="media/uploader/trash.png" class="_pointer icon" style="border:0;" alt="' . $lang['clear_path'] . '" title="' . $lang['clear_path'] . '" onclick="fileList(\'' . $id . '\', \'' . $module . '\', \'truncate\', \'\');"/>
            <img src="media/uploader/reload.png" class="_pointer icon" style="border:0;" alt="' . $lang['updatefilelist'] . '" title="' . $lang['updatefilelist'] . '" onclick="fileList(\'' . $id . '\', \'' . $module . '\', \'ok\', \'\');"/>
         </div>
      </th>
   </tr>
</table>';
    }
}

/*
case 'doc':
break;
case 'psd':
break;
case 'pdf':
break;
case 'txt':
break;
case 'phps':
break;
case 'html':
case 'htm':
break;
*/
function loginList(): void
{
    global $core, $db, $lang;
    $query = isset($_REQUEST['query']) ? filter(utf_decode($_REQUEST['query']), 'nick') : '';
    $input = isset($_REQUEST['input']) ? filter($_REQUEST['input'], 'a') : '';
    $user = $core->select_data('users', 'nick LIKE "%' . $db->safesql($query) . '%"');
    if ($db->numRows($user) > 0 && $query) {
        echo '<ul>';
        while ($rows = $db->getRow($user)) {
            echo '<li><a href="javascript:void(0)" onclick="gid(\'' . $input . '\').value = \'' . $rows['nick'] . '\'; showhide(\'' . $input . '\');">' . $rows['nick'] . '</a>';
        }
        echo '</ul>';
    } else {
        echo '<ul>
   <li>' . $lang['no_results'] . '</li></ul>';
    }
}

function getTranslit(): void
{
    echo translit($_REQUEST['query']);
}

function getCatByModule(): void
{
    global $core, $lang;
    $module = isset($_REQUEST['mod']) ? filter($_POST['mod'], 'module') : '';
    $cats_arr = $core->aCatList($module);
    echo '<option value="">' . $lang['cats_incat_no'] . '</option>';
    foreach ($cats_arr as $cid => $name) {
        echo '<option value="' . $cid . '">' . $name . '</option>';
    }
}

function blockStatus(): void
{
    global $core, $lang;
    if ($core->auth->isAdmin) {
        $id = isset($_REQUEST['id']) ? intval($_REQUEST['id'], 'a') : false;
        $to = isset($_REQUEST['to']) ? intval($_REQUEST['to'], 'a') : false;
        delcache('plugins');
        $core->upd_data('plugins', 'active = "' . $to . '"', 'id = "' . $id . '"');
        delcache('plugins');
        echo $lang['ok'];
    }
}

function userDeleteBlock(): void
{
    global $core, $lang;
    if ($core->auth->isAdmin) {
        $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : false;
        $core->del_data('plugins', 'id = "' . $id . '"');
        delcache('plugins');
        echo $lang['ok'];
    }
}

function friendsAjax(): void
{
    global $core, $db, $op, $lang;
    $uid = isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : false;
    if ($core->auth->isUser && $uid != 0 && $uid != $core->auth->user_id) {
        switch ($op) {
            case 'add':
                $addQ = $core->select_data('user_friends', '(who_invite="' . $core->auth->user_id . '" and whom_invite="' . $uid . '") OR (whom_invite="' . $core->auth->user_id . '" and who_invite="' . $uid . '")');
                if ($db->numRows($addQ) > 0) {
                    $addR = $db->getRow($addQ);
                    $info = $addR['who_invite'] == $core->auth->user_id ? $lang['fr_err1'] : $lang['fr_err2'];
                } else {
                    $core->ins_data('user_friends', 'who_invite,whom_invite,confirmed', '"' . $core->auth->user_id . '", "' . $uid . '", 0');
                    $info = $lang['fr_inf1'];
                }
                echo $info;
                break;
            case 'delete':
                $core->del_data('user_friends', '(who_invite="' . $core->auth->user_id . '" and whom_invite="' . $uid . '") OR (whom_invite="' . $core->auth->user_id . '" and who_invite="' . $uid . '")');
                echo $lang['fr_inf2'];
                break;
            case 'accept':
                $core->upd_data('user_friends', 'confirmed = 1', 'who_invite = "' . $uid . '" AND whom_invite = "' . $core->auth->user_id . '"AND confirmed = 0 ');
                user_points($uid, 'add_friend');
                user_points($core->auth->user_id, 'add_friend');
                echo $lang['fr_inf3'];
                break;
        }
    }
}

function fullAjax(): void
{
    global $fullajax;
    header('Content-type: application/x-javascript; charset=utf-8');
    require ROOT . 'etc/fullajax.config.php';
    $blockLinks = '';
    if (trim($fullajax['blockLinks']) != '') $blockLinks = ", '" . implode("', '", explode(',', $fullajax['blockLinks'])) . "'";
    $full = "SRAX.Default.loader = '" . $fullajax['loader'] . "';\n";
    $full .= "SRAX.showLoading = function(show, obj){
    var s = obj ? obj.style : 0;
    if (s)
    {\n";
    if ($fullajax['loaderStatic'] == 0) {
        $full .= "var scrollTop = document.documentElement.scrollTop;
        if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight))
        {
        clHeight = document.documentElement.clientHeight;
        }
        else if (document.body && (document.body.clientWidth || document.body.clientHeight))
        {
        clHeight = document.body.clientHeight;
        }
        topOffset = (scrollTop + (clHeight/3))+'px';
        s.top = topOffset;\n";
    }
    $full .= "if (show)
    {
    if (s.visibility) s.visibility = 'visible'; else s.display = 'block';
    }
    else
    {
    if (s.visibility) s.visibility = 'hidden'; else s.display = 'none';
    }
    }
    };\n
    SRAX.Filter.on('beforewrap', function(ops){
    return !SRAX.isXss(ops.el.href || ops.el.action);
    });
    SRAX.Filter.add ({id:'fullAjax', url:'/', method:'post', params:'fullajax=yes'}).add({url:['/profile/login', '/ajax', 'ajax.php', '/forum', '/profile/logout', '" . ADMIN . "', 'files'" . $blockLinks . "], type:'nowrap'});
    SRAX.linkEqual[':ax:fullAjax:'] = '" . $fullajax['replace'] . "';
    SRAX.linkEqual['anchor:fullAjax:'] = '@';
    SRAX.onReady(SRAX.directLink);
    SRAX.Default.ANCHOR.RECURSIVE = 1;
    SRAX.Default.SCRIPT_SRC_REPEAT_APPLY = 0;
    SRAX.Html.onall('beforerequest', function(ops) {
    var p = ops.options.params;
    ops.options.params = (p ? p + '&': '') + 'fullajax=yes';
    });";
    if ($fullajax['storage'] == 1) $full .= "SRAX.Default.STORAGE_SWF = 'usr/js/Storage.swf';\n";
    echo $full . "\n" . htmlspecialchars_decode($fullajax['freeCode'], ENT_QUOTES);
}