<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

class admin extends template
{
    var string $page_nav = '';

    public function __construct()
    {
        $this->adminTheme = true;
        $this->file_dir = 'usr/tpl/admin/';
        $this->toConf = '';
    }

    public function admin_head($title = null): void
    {
        $this->admin_title = $title;
        $this->sep = '';
        ob_start();
    }

    public function sources(): void
    {
        global $adminTpl;
        $adminTpl->sources = $this->sources;
    }

    public function admin_foot(): void
    {
        global $config, $admin_conf, $url, $db, $core, $lang;
        $content = ob_get_contents();
        ob_end_clean();
        $array = explode(separator: ' | ', string: $this->admin_title);
        $title_massiv = array_reverse($array);
        $admtitle = null;
        foreach ($title_massiv as $title) {
            if ($title) $admtitle .= filter($title) . $config['divider'];
        }
        $module_array = array();
        require ROOT . 'root/list.php';
        require ROOT . 'etc/global.config.php';
        foreach (glob(ROOT . 'usr/modules/*/admin/list.php') as $listed) {
            include($listed);
        }
        if (isset($toconfig)) $this->toConf = $toconfig;
        $subNav = '';
        $noSub = '';
        $topbar = '';
        $meta = '<title>' . (!empty($admtitle) && !empty($_REQUEST['url']) ? $admtitle : $config['slogan']) . $lang['apanel'] . '</title>' . "\n";
        $meta .= '<meta http-equiv="content-type" content="text/html" charset="' . $config['charset'] . '">' . "\n";
        $meta .= '<base href="' . $config['url'] . "/\">" . "\n";
        $meta .= '<script src="usr/plugins/js/ajax_admin.js" type="text/javascript"></script>' . "\n";
        $meta .= '<script src="usr/plugins/js/JMY_Ajax.js" type="text/javascript"></script>' . "\n";
        $meta .= '<script src="usr/plugins/js/engine.js" type="text/javascript"></script>' . "\n";
        $meta .= '<script src="usr/plugins/js/bb_editor.js" type="text/javascript"></script>' . "\n";
        $meta .= '<script src="langs/' . $core->InitLang() . '/js/system.js" type="text/javascript"></script>' . "\n";
        if (isset($this->headerIncludes)) $meta .= ArrayToStr($this->headerIncludes);
        if (isset($url[1])) {
            if (isset($component_array[$url[1]])) {
                $subNav .= admin_subNav_icon($component_array, $url[1], true);
                $array = $component_array;
                $url1 = $url[1];
                $url2 = $url[2] ?? '';
                $mod = false;
                $noSub .= admin_subNav_icon($component_array, $url[1]);
            } elseif (isset($url[2]) && isset($module_array[$url[2]])) {
                $subNav .= admin_subNav_icon($module_array, $url[2], true);
                $array = $module_array;
                $url1 = $url[2];
                $url2 = $url[3] ?? '';
                $mod = true;
                $noSub .= admin_subNav_icon($module_array, $url[2], false, true);
            } elseif (isset($services_array[$url[1]])) {
                $subNav .= admin_subNav_icon($services_array, $url[1], true);
                $array = $services_array;
                $url1 = $url[1];
                $url2 = $url[2] ?? '';
                $mod = false;
                $noSub .= admin_subNav_icon($services_array, $url[1]);
            } else {
                $array = false;
                $url1 = '';
                $url2 = '';
                $mod = false;
            }
            $subNav .= admin_subNav($array, $url1, $url2, 'subAct', false, $mod);
            $subNav .= admin_subNav($array, $url1, $url2, 'lsubAct', 'list', $mod);
            $subNav .= admin_subNav($array, $url1, $url2, 'dsubAct', 'module_ap', $mod);
            $subNav .= admin_subNav($array, $url1, $url2, 'dropAct', 'add', $mod);
            $subNav .= admin_subNav($array, $url1, $url2, 'editAct', 'ap_editor', $mod);
            $subNav .= admin_subNav($array, $url1, $url2, 'viewAct', 'panel_menu_other_statistic', $mod);
            $subNav .= admin_subNav($array, $url1, $url2, 'confAct', false, $mod);
            $subNav .= '</p>';
            $topbar_url = isset($topbar_array[$url[1]]) ? $url[1] : (isset($url[2]) && isset($topbar_array[$url[2]]) ? $url[2] : '');
            if (!empty($topbar_url)) {
                if (isset($topbar_array[$topbar_url]['subAct'])) {
                    $topbar .= '<div class="mt-30 hidden-xs">';
                    foreach ($topbar_array[$topbar_url]['subAct'] as $comAct => $comActLink) {
                        $topbar .= is_array($comActLink) ? ($comActLink[2] == 'ajax' ? '<a onclick="ajaxGetJS(\'' . ADMIN . '/ajax/server_stats\', \'demoHighCharts.init(); ' . $comActLink[3] . '\',);" class="btn btn-default btn-sm fw600 ml10">' . faSpan($comActLink[1] . ' pr5', true, $comAct) . '</a>' : '<a href="' . $comActLink[2] . '" class="btn btn-default btn-sm fw600 ml10">' . faSpan($comActLink[1] . ' pr5', true, $comAct) . '</a>') : '<a href="' . $comActLink . '" class="btn btn-default btn-sm fw600 ml10">' . faSpan('pr5', true, $comAct) . '</a>';
                    }
                    echo '</div>';
                }
            }
        }
        $menu = '';
        $menu_array = array();
        $query = $core->select_data('plugins', 'menu = 1 AND active=1');
        if ($db->numRows($query) > 0) {
            while ($module_menu = $db->getRow($query)) {
                $menu_url = $module_menu['title'];
                if (!empty($menu_url)) {
                    if (isset($menu_array[$menu_url]['subAct'])) {
                        $menu .= '<li><a href="#" class="accordion-toggle ' . openMenu($menu_url) . '">' . faSpan($module_array[$menu_url]['icon'], true, $module_array[$menu_url]['name']) . '<span class="caret"></span></a><ul class="nav sub-nav">';
                        foreach ($menu_array[$menu_url]['subAct'] as $comAct => $comActLink) {
                            $menu .= is_array($comActLink) ? '<li ' . chooseModuleMenu($comActLink[0], $menu_url) . '><a href="/{ADMIN}/module/' . $menu_url . '/' . $comActLink[0] . '">' . faSpan($comActLink[1], true, $comAct) . '</a></li>' : '<li ' . chooseModuleMenu($comActLink, $menu_url) . '><a href="/{ADMIN}/module/' . $menu_url . '/' . $comActLink . '">' . faSpan('fa-square-o', true, $comAct) . '</a></li>';
                        }
                        $menu .= '</ul></li>';
                    } else {
                        $menu .= '<li ' . chooseMenu($menu_url) . '><a href="' . ADMIN . '/module/' . $menu_url . '">' . faSpan($module_array[$menu_url]['icon'], true, $module_array[$menu_url]['name']) . '</a></li>';
                    }
                }
            }
        }
        $notifications = '';
        $count = $core->sum_data('news', 'active = 2');
        $static = $core->sum_data('content', 'active = 2');
        $comments = $core->sum_data('comments', 'status = 2');
        $newFeedback = $core->sum_data('feedback', 'status = 0 AND status <> 3');
        $newComplaint = $core->sum_data('complaint', 'status = 0 AND status <> 3');
        $newSupport = $core->sum_data('support', 'status = 0 AND status <> 3');
        $newMessages = $core->sum_data('pm', 'toid = ' . $core->auth->user_info['id'] . ' AND status = 0');
        $newGuestbook = $core->sum_data('guestbook', 'active = 2');
        $allFriends = $core->select_data('users', 'f.whom_invite ="' . $core->auth->user_info['id'] . '" AND u.id !="' . $core->auth->user_info['id'] . '" AND f.confirmed = 0', false, 'u.id as uuid, u.nick, u.last_visit, u.regdate, f.*', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on(u.id = f.who_invite OR u.id = f.whom_invite)');
        $newFriends = 0;
        if ($db->numRows($allFriends) > 0) {
            $nF = '<div class="container">';
            while ($newFr = $db->getRow($allFriends)) {
                if ($newFr['who_invite'] == $core->auth->user_info['id']) {
                    $newFriends = '0';
                    $nF .= '';
                } else {
                    $newFriends = $db->numRows($allFriends);
                    $nF .= ' <div class="container__item"><span class="_userfriends" id="friendDo' . $newFr['uuid'] . '"><a href="profile/' . $newFr['nick'] . '" title="' . $lang['guest_page'] . '"><img  src="' . avatar($newFr['uuid']) . '" class="img-responsive mw40 ib br4" alt=""> ' . $newFr['nick'] . '</a></span></div>';
                }
            }
            $nF .= '</div>';
        }
        $version = VERSION_ID;
        $status = ping_dir(getHost($lang['jmycms']), $lang['p80']);
        $nextversion = $status ? file_get_contents_utf8($lang['jmycmsck'] . 'nextversion.php?dir=' . $_SERVER['HTTP_HOST'] . '&lang=' . $config['lang'] . '&key=' . $config['key'] . '&version=' . $version) : '';
        $nowversion = $status ? file_get_contents_utf8($lang['jmycmsck'] . 'version.php?dir=' . $_SERVER['HTTP_HOST'] . '&lang=' . $config['lang'] . '&key=' . $config['key'] . '&version=' . $version . '">"') : '';
        $nnext = $nowversion ? $nextversion : '';
        $i_n = 0;
        if (file_exists(ROOT . 'install.php')) $i_n++;
        if (file_exists(ROOT . '/tmp/update/lock.update')) $i_n++;
        if ($count) $i_n++;
        if ($static) $i_n++;
        if ($comments) $i_n++;
        if ($newFeedback) $i_n++;
        if ($newComplaint) $i_n++;
        if ($newGuestbook) $i_n++;
        if ($newFriends) $i_n++;
        if ($newSupport) $i_n++;
        $notifications .= count_notif(file_exists(ROOT . 'install.php'), ADMIN . '/update/d_install', 'install.png', 'installex');
        $notifications .= count_notif(file_exists(ROOT . '/tmp/update/lock.update'), ADMIN . '/update', 'update.png', 'update_jmy');
        $notifications .= count_notif($count, ADMIN . '/moderation/mod/news', 'nn.png', 'onmoder');
        $notifications .= count_notif($static, ADMIN . '/moderation/mod/content', 'nn.png', 'notif_static_moder');
        $notifications .= count_notif($comments, ADMIN . '/moderation/com/comments', 'nn.png', 'notif_com_moder');
        $notifications .= count_notif($newFeedback, ADMIN . '/feedback', 'feedsend.png', 'feedsend');
        $notifications .= count_notif($newComplaint, ADMIN . '/complaint', 'complaint.png', 'complsend');
        $notifications .= count_notif($newGuestbook, ADMIN . '/moderation/mod/guestbook', 'book.png', 'notif_guestbook_moder');
        $notifications .= count_notif($newFriends, '/profile', false, 'notif_newfriends');
        $notifications .= count_notif($newSupport, ADMIN . '/support', 'support.png', 'support');
        $notifications .= $i_n == 0 ? '<div  style="width: 367px; margin-bottom: 0; margin-top: 0;" class="panel-footer no-border">' . $lang['not_notif'] . '</div>' : '';
        $color = $admin_conf['colorPanel'] == "" ? '#337AB7' : $admin_conf['colorPanel'];
        $i_n = $i_n == 0 ? '<span class="badge badge-default">' . $i_n . '</span>' : '<span class="badge badge-danger">' . $i_n . '</span>';
        $upbtn = '<style>
.upbtn {
    opacity: 0.8;
    z-index: 9999;
    width: 60px;
    height: 60px;
    position: fixed;
    bottom: -80px;
    right: 20px;
    cursor: pointer;
    border: 3px solid #BFE2FF;
    transition: all .7s ease-in-out;
    background-position: center center;
    background-repeat: no-repeat;
    background-color: ' . $color . ';
    background-image: url(data:image/svg+xml;utf8;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iaXNvLTg4NTktMSI/Pgo8IS0tIEdlbmVyYXRvcjogQWRvYmUgSWxsdXN0cmF0b3IgMTYuMC4wLCBTVkcgRXhwb3J0IFBsdWctSW4gLiBTVkcgVmVyc2lvbjogNi4wMCBCdWlsZCAwKSAgLS0+CjwhRE9DVFlQRSBzdmcgUFVCTElDICItLy9XM0MvL0RURCBTVkcgMS4xLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL0dyYXBoaWNzL1NWRy8xLjEvRFREL3N2ZzExLmR0ZCI+CjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgdmVyc2lvbj0iMS4xIiBpZD0iQ2FwYV8xIiB4PSIwcHgiIHk9IjBweCIgd2lkdGg9IjMycHgiIGhlaWdodD0iMzJweCIgdmlld0JveD0iMCAwIDQ0NC44MTkgNDQ0LjgxOSIgc3R5bGU9ImVuYWJsZS1iYWNrZ3JvdW5kOm5ldyAwIDAgNDQ0LjgxOSA0NDQuODE5OyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+CjxnPgoJPHBhdGggZD0iTTQzMy45NjgsMjc4LjY1N0wyNDguMzg3LDkyLjc5Yy03LjQxOS03LjA0NC0xNi4wOC0xMC41NjYtMjUuOTc3LTEwLjU2NmMtMTAuMDg4LDAtMTguNjUyLDMuNTIxLTI1LjY5NywxMC41NjYgICBMMTAuODQ4LDI3OC42NTdDMy42MTUsMjg1Ljg4NywwLDI5NC41NDksMCwzMDQuNjM3YzAsMTAuMjgsMy42MTksMTguODQzLDEwLjg0OCwyNS42OTNsMjEuNDExLDIxLjQxMyAgIGM2Ljg1NCw3LjIzLDE1LjQyLDEwLjg1MiwyNS42OTcsMTAuODUyYzEwLjI3OCwwLDE4Ljg0Mi0zLjYyMSwyNS42OTctMTAuODUyTDIyMi40MSwyMTMuMjcxTDM2MS4xNjgsMzUxLjc0ICAgYzYuODQ4LDcuMjI4LDE1LjQxMywxMC44NTIsMjUuNywxMC44NTJjMTAuMDgyLDAsMTguNzQ3LTMuNjI0LDI1Ljk3NS0xMC44NTJsMjEuNDA5LTIxLjQxMiAgIGM3LjA0My03LjA0MywxMC41NjctMTUuNjA4LDEwLjU2Ny0yNS42OTNDNDQ0LjgxOSwyOTQuNTQ1LDQ0MS4yMDUsMjg1Ljg4NCw0MzMuOTY4LDI3OC42NTd6IiBmaWxsPSIjRkZGRkZGIi8+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPC9zdmc+Cg==)
}
.upbtn:hover {
    opacity: 1;
    background-color: ' . $color . ';
}</style><script>
    $(\'body\').append(\'<div class="upbtn"></div>\');
    $(window).scroll(function () {
        if ($(this).scrollTop() > 100) {
            $(\'.upbtn\').css({
                bottom: \'15px\'
            });
        } else {
            $(\'.upbtn\').css({
                bottom: \'-80px\'
            });
        }
    });
    $(\'.upbtn\').on(\'click\', function () {
        $(\'html, body\').animate({
            scrollTop: 0
        }, 500);
        return false;
    });
</script>';
        $this->loadFile('main');
        $this->setVar('META', $meta);
        $this->setVar('FOOT', isset($this->footIncludes) ? ArrayToStr($this->footIncludes) : '');
        $this->setVar('BODY_CLASS', isset($this->body_class) ? ArrayToStr($this->body_class) : '');
        $this->setVar('LANG', $core->InitLang());
        $this->setVar('AVATAR', avatar($core->auth->user_info['id']));
        $this->setVar('NICK', $core->auth->user_info['nick']);
        $this->setVar('GROUPS', Glang($core->auth->group_info['gname']));
        $this->setVar('ADM_THEME', 'usr/tpl/admin');
        $this->setVar('COLOR', $color);
        $this->setVar('CSS', UniClass() . dop_bg());
        $this->setVar('NOTIF', $notifications);
        $this->setVar('NOTIF_NUMB', $i_n);
        $this->setVar('MESSAGE_NUMB', $i_n);
        $this->setVar('FRIENDS_NUMB', $i_n);
        $this->setVar('FEEDBACK_NUMB', $i_n);
        $this->setVar('COMPLAINT_NUMB', $i_n);
        $this->setVar('SUPPORT_NUMB', $i_n);
        $this->setVar('GUESTBOOK_NUMB', $i_n);
        $this->setVar('URL', $config['url']);
        $this->setVar('URL_FULL', $core->fullURL());
        $this->setVar('MODULE', $content);
        $this->setVar('MENU_MODULES', $menu);
        $this->setVar('VERSION', VERSION_ID);
        $this->setVar('D_YEAR', date("Y"));
        $this->setVar('NAME', $core->auth->user_info['nick']);
        $this->setVar('IP', getRealIpAddr());
        $this->setVar('ADMIN', ADMIN);
        $this->setVar('ADMIN_LINK', (isset($url[0]) && $url[0] == 'administration') ? ADMIN . ((isset($url[1])) ? '/' . $url[1] : false) : false);
        $this->setVar('MOD_LINK', (isset($url[2]) && $url[1] == 'module') ? ADMIN . '/module/' . $url[2] : ((isset($url[2]) && $url[1] == 'moderation') ? ADMIN . '/moderation/' . $url[2] . '/' . $url[3] : false));
        $this->setVar('MODER_LINK', (isset($url[2]) && $url[1] == 'moderation') ? ADMIN . '/' . $url[1] . (($url[2] == 'mod') ? '/' . $url[2] . '/' . $url[3] : (($url[2] == 'com') ? '/' . $url[2] . '/' . $url[3] : false)) : false);
        $this->setVar('ACT_MODER_LINK', (isset($url[2]) && $url[1] == 'moderation') ? ADMIN . '/module/' . $url[3] . '/action&moderate' : false);
        $this->setVar('LI_MODER_LINK', (isset($url[2]) && $url[1] == 'moderation') ? ADMIN . '/module/' . ($url[3] ?? '') : ADMIN . '/module/' . ($url[2] ?? ''));
        $this->setVar('LICENSE', $lang['license_powered']);
        $this->setVar('SUBNAV', $subNav);
        $this->setVar('GENERATE', mb_substr(microtime(1) - TIMER, 0, 5));
        $this->setVar('GZIP', $config['gzip'] ? $lang['gzip_on'] : '');
        $this->setVar('TIMEQUERIES', mb_substr($db->timeQueries, 0, 5));
        $this->setVar('QUERIES', $db->numQueries);
        $this->setVar('JS_CODE', isset($this->js_code) ? ArrayToStr($this->js_code) : '');
        $this->setVar('PAGES', $this->page_nav);
        $this->setVar('HIDE_STATUS', hide_status());
        $this->setVar('MESSAGES_NUMB', $newMessages);
        $this->setVar('FRIENDS_NUMB', $newFriends);
        $this->setVar('FEEDBACK_NUMB', $newFeedback);
        $this->setVar('COMPLAINT_NUMB', $newComplaint);
        $this->setVar('SUPPORT_NUMB', $newSupport);
        $this->setVar('TOPBAR', $topbar);
        $this->setVar('LANG_CHANGE', lang_change());
        $this->setVar('UPBTN', $admin_conf['upbtn'] ? $upbtn : '');
        if (file_exists(ROOT . 'root/other/other.templates.php')) include(ROOT . 'root/other/other.templates.php');
        $this->sources = preg_replace_callback("#\\{MENU_OPEN:(.*?)}#is", "openMenu", $this->sources);
        $this->sources = preg_replace_callback("#\\{MENU_CHOOSE:(.*?)}#is", "chooseMenu", $this->sources);
        $this->sources = preg_replace_callback("#\\[CHECK_ACTIVE](.*?)\\[/CHECK_ACTIVE]#is", "checkActive", $this->sources);
        $this->sources = preg_replace_callback("#\\[ACTIVE_MODULE:(.+?)](.*?)\\[/ACTIVE_MODULE]#is", "activeModule", $this->sources);
        $this->end();
    }

    public
    function loadFile($file, $check = false): void
    {
        $this->sources = file_get_contents(ROOT . $this->file_dir . $file . '.tpl');
    }

    public
    function blockCookie($block, $type = 'block')
    {
        if ($type == 'block') {
            if (isset($_COOKIE['block_' . $block]) && $_COOKIE['block_' . $block]) return 'style="display:none"';
        } else {
            if (isset($_COOKIE['block_' . $block]) && $_COOKIE['block_' . $block]) return 'close'; else return 'open';
        }
    }

    public
    function a_pages($page, $num, $all, $link, $onClick = false): void
    {
        global $lang;
        if (!eregStrt('{page}', $link)) $link = $link . '/{page}';
        $numpages = ceil($all / $num);
        $nums = '';
        $predel = 4;
        $prevpage = $page - 1;
        if ($prevpage <> 0) $nums .= '<li><a href="' . str_replace('{page}', 'page/' . $prevpage, $link) . '" title="' . $prevpage . '"' . ($onClick ? str_replace('{num}', $prevpage, $onClick) : '') . '>&lt; ' . $lang['back'] . '</a></li>';
        for ($var = 1; $var < $numpages + 1; $var++) {
            if ($var == $page) {
                $nums .= '<li><a href="' . str_replace('{page}', 'page/' . $var, $link) . '" title="' . $var . '"' . ($onClick ? str_replace('{num}', $var, $onClick) : '') . ' class="current">' . $var . '</a></li>';
            } else {
                if ((($var > ($page - $predel)) && ($var < ($page + $predel))) or ($var == $numpages) || ($var == 1)) $nums .= '<li><a href="' . str_replace('{page}', 'page/' . $var, $link) . '" title="' . $var . '"' . ($onClick ? str_replace('{num}', $var, $onClick) : '') . '>' . $var . '</a></li>';
                if ($var < $numpages) {
                    if (($var > ($page - $predel - 2)) && ($var < ($page + $predel))) $nums .= "";
                    if (($page > $predel + 2) && ($var == 1)) $nums .= '<li class="dots">...</li>';
                    if (($page < ($numpages - $predel)) && ($var == ($numpages - 2))) $nums .= '<li class="dots">...</li>';
                }
            }
        }
        $nextpage = $page + 1;
        if ($numpages <> $page) $nums .= '<li><a href="' . str_replace('{page}', 'page/' . $nextpage, $link) . '" title="' . $nextpage . '"' . ($onClick ? str_replace('{num}', $nextpage, $onClick) : '') . '>' . $lang['forward'] . ' &gt;</a></li>';
        if ($numpages <> 1 && $numpages <> 0) {
            $nums .= '</ul>';
            $this->page_nav = $nums;
        }
    }
}

$adminTpl = new admin;