<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
function blockList(): void
{
    global $db, $core, $url, $lang;
    $where = 'service="blocks"';
    $order = '';
    echo '<thead>
   <tr>
      <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
      <th class="col-md-7 text-center">' . $lang['title'] . '</th>
      <th></th>
         <th class="text-center">' . $lang['status'] . '</th>';
    init_checkbox('th', false, false, true);
    echo '</tr>
                  </thead>
                  <tbody>';
    $_type = $core->row_data('blocks_types', false, 'title ASC');
    $_types[$_type['type']] = $_type['title'];
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_title = $_POST['s_title'] ?? '';
    $s_desc = $_POST['s_desc'] ?? '';
    $s_active = isset($_POST['s_active']);
    if ($s_active) {
        if ($_POST['s_active'] == 1) {
            $where = 'WHERE `active` = 1 ';
        } else {
            $s_active = false;
            $where = 'WHERE `active` = 0 ';
        }
    } else {
        $s_active = true;
    }
    if ($s_id) {
        $where .= "AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
    } else {
    }
    if ($s_title) $where .= "AND `title` LIKE '%" . $db->safesql($s_title) . "%'";
    if ($s_desc) $where .= "AND `content` LIKE '%" . $db->safesql($s_desc) . "%'";
    if (isset($url[2]) && $url[2] == 'order') {
        switch ($url[3]) {
            case 'abc':
                $order .= 'title ASC';
                break;
            case 'type':
                $order .= 'type DESC';
                break;
            case 'id':
                $order .= 'id ASC';
                break;
        }
    } else {
        $order .= 'type ASC, priority ASC';
    }
    $query = $core->select_data('plugins', $where, $order . ' LIMIT ' . limit_page());
    if ($db->numRows($query) > 0) {
        while ($result = $db->getRow($query)) {
            $blocks[$result['type']][] = $result;
            $countType[$result['type']] = true;
        }
        foreach ($blocks as $type => $inf) {
            $count[$type] = count($inf);
            foreach ($inf as $number => $result) {
                $up = $number > 0 ? '<a href="javascript:void(0)" onclick="adminBlock(\'moveUp\', \'' . $result['id'] . '\',	\'' . $inf[$number - 1]['id'] . '\', \'' . $result['priority'] . '\', \'' . $inf[$number - 1]['priority'] . '\');">
   <button type="button" class="btn btn-info btn-sm">' . faSpan('fa-angle-up', true, false, false, $lang['pos_up']) . '</button>
   </a>' : '';
                $down = $count[$type] && $number != $count[$type] - 1 ? '<a href="javascript:void(0)" onclick="adminBlock(\'moveDown\', \'' . $result['id'] . '\',	\'' . $inf[$number + 1]['id'] . '\', \'' . $result['priority'] . '\', \'' . $inf[$number + 1]['priority'] . '\');">
   <button type="button" class="btn btn-info btn-sm">' . faSpan('fa-angle-down', true, false, false, $lang['pos_down']) . '</button>
   </a>' : '';
                $active = ($result['active'] == 1) ? '<a href="javascript:void(0)" onclick="adminBlockStatus(\'' . $result['id'] . '\', 0);">' . faSpan('fa-cogs', false, $lang['deactivate']) . '</a>' : '<a href="javascript:void(0)" onclick="adminBlockStatus(\'' . $result['id'] . '\', 1);">' . faSpan('fa-cogs', false, $lang['activate']) . '</a>';
                echo '<tr>
      <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $result['id'] . '</td>
      <td>
         <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . trimtitle($result['title'], 50) . '</ol>
         <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['block_type'] . ': ' . ($_types[$result['type']] ?? faSpan('fa-window-minimize', true, false, false, $lang['block_type_empty'])) . '</ol>
         <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['template'] . ': ' . ($result['template'] ?: $lang['no']) . '</ol>
         <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['block_file'] . ': ' . ($result['file'] ?: $lang['no']) . '</ol>
         <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['description'] . ': ' . trimtitle($result['content'], 50) . '</ol>
          <td class="text-center">' . $up . $down . '</td>
      <td class="text-center">' . status_icon('plugins', $result['id'], 'plugins') . '</td>';
                init_checkbox('td', $result['id'], false, '<li><a href="' . ADMIN . '/blocks/add/' . $result['id'] . '">' . faSpan('fa-external-link', false, $lang['edit']) . '</a></li>
               <li>' . $active . '</li>
               <li class="divider"></li>
               <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $result['id'] . '\')">' . faSpan('fa-trash-o', false, $lang['delete']) . '</a></li>');
                echo '</tr>';
            }
        }
        echo '</tbody>';
        init_tfoot('<option value="activate">' . $lang['do_activation'] . '</option>
               <option value="deActivate">' . $lang['do_deactivation'] . '</option>
               <option value="reActivate">' . $lang['do_reactivation'] . '</option>
               <option value="Delete">' . $lang['delete'] . '</option>');
    }
}

function setBlockStatus(): void
{
    global $core;
    if ($core->auth->isAdmin) {
        $id = intval($_REQUEST['id']);
        $to = intval($_REQUEST['to']);
        $core->upd_data('plugins', 'active ="' . $to . '"', 'id ="' . $id . '"');
        delcache('plugins');
        blockList();
    }
}

function version_check(): void
{
    echo VERSION_ID;
}

function setCommentStatus(): void
{
    global $core, $lang;
    if ($core->auth->isAdmin) {
        $id = intval($_REQUEST['id']);
        $to = intval($_REQUEST['to']);
        $core->upd_data('comments', 'status ="' . $to . '"', 'id ="' . $id . '"');
        $text = $to == 1 ? $lang['off'] : $lang['on'];
        echo $text;
    }
}

function deleteBlock(): void
{
    global $core;
    if ($core->auth->isAdmin) {
        $id = intval($_REQUEST['id']);
        $core->del_data('plugins', 'id ="' . $id . '"');
        delcache('plugins');
        blockList();
    }
}

function inputTags(): void
{
    global $core, $db, $lang;
    $query = filter(utf_decode($_REQUEST['query']), 'a');
    $input = filter($_REQUEST['input'], 'a');
    $array = explode(',', $query);
    $query = trim(end($array));
    $tags = $core->select_data('categories', 'tag LIKE"%' . $db->safesql($query) . '%" and module="news"', false, 'tag');
    if ($db->numRows($tags) > 0 && $query) {
        echo '<ul>';
        while ($rows = $db->getRow($tags)) $tag_s[$rows['tag']] = $rows['tag'];
        $tagg = array_unique($tag_s);
        foreach ($tagg as $tagme) {
            echo '<li><a href="javascript:void(0)" onclick="gid(\'' . $input . '\').value = tagSplit(gid(\'' . $input . '\').value, \'' . $tagme . '\'); showhide(\'check_result2\');">' . $tagme . '</a></li>';
        }
        echo '</ul>';
    } else {
        echo '<ul>
        <li>' . $lang['tags_empty'] . '</li>
        </ul>';
    }
}

function moveUp(): void
{
    global $core;
    if ($core->auth->isAdmin) {
        $id = intval($_REQUEST['id']);
        $to = intval($_REQUEST['to']);
        $from = intval($_REQUEST['from']);
        $topos = intval($_REQUEST['topos']);
        if ($from == $topos) $topos = $from + 1;
        if ($topos < $from) $topos = $from + 1;
        $core->upd_data('plugins', 'priority ="' . $topos . '"', 'id ="' . $to . '"');
        $core->upd_data('plugins', 'priority ="' . $from . '"', 'id ="' . $id . '"');
        delcache('plugins');
        blockList();
    }
}

function moveDown(): void
{
    global $core;
    if ($core->auth->isAdmin) {
        $id = intval($_REQUEST['id']);
        $to = intval($_REQUEST['to']);
        $from = intval($_REQUEST['from']);
        $topos = intval($_REQUEST['topos']);
        if ($from == $topos) $topos = $from - 1;
        if ($topos < $from) $topos = $from - 1;
        $core->upd_data('plugins', 'priority ="' . $from . '"', 'id ="' . $to . '"');
        $core->upd_data('plugins', 'priority ="' . $topos . '"', 'id ="' . $id . '"');
        delcache('plugins');
        blockList();
    }
}

function catsList($where = false): void
{
    global $core, $db, $lang;
    $query = $core->select_data('categories', $where, 'position DESC, parent_id DESC LIMIT ' . limit_page());
    echo '<thead>
   <tr>
      <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
      <th></th>
      <th class="col-md-6">' . $lang['titles'] . '</th>
      <th class="text-center">' . $lang['posts_num'] . '</th>';
    init_checkbox('th', false, false, true);
    echo '</tr>
</thead>
<tbody>';
    $cats = array();
    while ($result = $db->getRow($query)) {
        $cats[$result['position']][] = $result;
        $countType[$result['position']] = true;
    }
    foreach ($cats as $position => $inf) {
        $count[$position] = count($inf);
        foreach ($inf as $result) {
            $contentLink = $result['altname'] !== ',0,' ? 'news/' . $core->getCat('news', $result['altname'], 'development') : '';
            $admhead = $result['module'] == 'news' ? $lang['add_news'] : ($result['module'] == 'content' ? $lang['static_add'] : $lang['add_content']);
            echo '<tr>
     <td class="text-center hidden-xs"><span class="pd-l-sm"></span>' . $result['id'] . '</td>
      <td>
         <div class="media media-list"><img  src="' . catsicon($result['icon']) . '" style="width:56px; height:56px;" alt=""></div>
      </td>
      <td>
         <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . ($core->getCat($result['module'], "'" . $result['id'] . "'", 'short', 1) ? $core->getCat($result['module'], "'" . $result['id'] . "'", 'short', 1) : '<a href="' . $contentLink . $result['altname'] . '" target="_blank">' . faSpan(false, true, false, false, $result['name']) . $result['name'] . '</a>') . '</ol>
         <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['description'] . ': ' . (empty($result['description']) ? $lang['no'] : str($result['description'], 17)) . '</ol>
         <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['module'] . ': ' . _mName($result['module']) . '</ol>
      </td>
      <td class="text-center">' . $core->sum_data($result['module'], '`cat` =",' . $result['id'] . ',"') . '</td>';
            init_checkbox('td', $result['id'], false, '<li><a href="' . ADMIN . '/module/' . $result['module'] . '/cat/' . $result['id'] . '">' . faSpan('fa-television', false, $lang['cats_view_content']) . '</a></li>
               <li><a href="' . ADMIN . '/module/' . $result['module'] . '/add/' . $result['id'] . '">' . faSpan('fa-plus', false, $admhead) . '</a></li>
               <li><a href="' . ADMIN . '/cats/edit/' . $result['id'] . '">' . faSpan('fa-external-link', false, $lang['edit']) . '</a></li>
               <li><a href="' . $core->getCat($result['module'], $result['id'], 'url', 1) . '" target="_blank">' . faSpan('fa-tasks', false, $lang['cats_view']) . '</a></li>
               <li class="divider"></li>
               <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $result['id'] . '\')">' . faSpan('fa-trash-o', false, $lang['delete']) . '</a></li>');
            echo '</tr>';
        }
    }
    echo '</tbody>
<tfoot class="footer-menu">
   <tr>
      <td colspan="9">
         <nav class="text-right">
            <button name="submit" type="submit" id="sub" value="Delete" class="btn bg-danger btn-sm btn-raised legitRipple">' . faSpan('fa-trash-o', true, $lang['delete']) . '</button>
         </nav>
      </td>
   </tr>
</tfoot>';
}


function ContentPreview($header, $title, $date, $category, $content): void
{
    global $core;
    echo '<style>
.story > .meta {
    font-size: .9em;
    background-color: #f7f7f7;
    padding: 2% 8%;
    border-radius: 0 0 2px 2px;
}
.box {
    background-color: #fff;
    margin-bottom: 25px;
    border-radius: 2px;
    position: relative;
    box-shadow: 0 1px 3px 0 rgba(0,0,0,0.2);
    -webkit-box-shadow: 0 1px 3px 0 rgba(0,0,0,0.2);
}
.box_in {
    padding: 4% 8%;
}</style>
<fieldset style="border-style:solid; border-color:black;">
	<legend> <span style="font-size: 10px; font-family: Verdana,serif">' . $header . ':</span> </legend>
	<article class="box story">
		<div class="box_in">
			<h1 class="title">' . $title . '</h1>
			<div class="text"> ' . $core->bbDecode($content, false) . ' </div>
			<div style="text-align:right" class="text-right">
				<div class="category"> <a href="#">' . $category . '</a> </div>
			</div>
		</div>
		<div class="meta">
			<ul class="left">
				<li class="grey"><time datetime="' . $date . '"><a href="#">' . $date . '</a></time></li>
			</ul>
		</div>
	</article>
</fieldset>';
}

function getPreview(): void
{
    global $core, $lang;
    $title = utf_decode($_REQUEST['title']);
    $date = utf_decode($_REQUEST['date']);
    $category = $core->getCat('news', utf_decode($_REQUEST['category']), 'short', 3);
    $short = htmlspecialchars_decode(utf_decode($_REQUEST['shortNews']));
    $full = htmlspecialchars_decode(utf_decode($_REQUEST['fullNews']));
    echo '<div class="genPreview">';
    if (!empty($title) && !empty($short)) {
        ContentPreview($lang['short_text'], $title, $date, $category, $short);
        if (!empty($full)) ContentPreview($lang['full_text'], $title, $date, $category, $full);
    } else {
        echo $lang['error_10_sec'];
    }
    echo '</div>';
    $core->tpl->headerIncludes = array();
}

function getContentPreview(): void
{
    global $core, $lang;
    $title = utf_decode($_REQUEST['title']);
    $date = utf_decode($_REQUEST['date']);
    $category = $core->getCat('content', utf_decode($_REQUEST['category']), 'short', 3);
    $short = htmlspecialchars_decode(utf_decode($_REQUEST['shortNews']));
    echo '<div class="genPreview">';
    if (!empty($title) && !empty($short)) {
        ContentPreview($lang['content_text'], $title, $date, $category, $short);
    } else {
        echo $lang['error_10_sec'];
    }
    echo '</div>';
    $core->tpl->headerIncludes = array();
}

function limit_page($not_one = true, $num = false)
{
    global $admin_conf;
    $page = init_page();
    $cut = $num ? ($page - 1) * $num : ($page - 1) * $admin_conf['num'];
    $num = $num ?: $admin_conf['num'];
    if ($not_one && $admin_conf['num']) {
        $limit = $cut . ', ' . $num;
    } elseif (!$not_one) {
        $cut = $page - 1;
        $limit = $cut . ', 1';
    } else {
        return;
    }
    return $limit;
}

function init_checkbox($type = false, $id = false, $val = false, $dropdown = false): void
{
    $value = isset($val) && $val ? $val : $id;
    $checkbox = '';
    if ($dropdown) $checkbox .= '<th style="width: 60px">&nbsp;</th>';
    if (!$type) {
        $checkbox .= '<th style="padding-bottom: 25px;" class="checkbox-custom mb15 text-right">&nbsp;</th>';
    } elseif ($type == 'th') {
        $checkbox .= '<th style="padding-bottom: 25px;" class="checkbox-custom mb15 text-right">
   <input id="all" type="checkbox" name="all" onclick="setCheckboxes(\'tablesForm\', true); return true;">
   <label for="all"></label>
</th>';
    } elseif ($type == 'td') {
        $checkbox = '<div>';
        if ($dropdown) $checkbox .= '<td style="text-align:right" class="text-right">
                           <div class="btn-group">
                              <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">' . faSpan('fa-caret-down', false, 'right', true) . '</a>
                              <ul class="dropdown-menu text-left dropdown-menu-right">
                                   ' . $dropdown . '
                              </ul>
                           </div>
                        </td>';
        $checkbox .= '<td style="padding-bottom: 25px;" class="checkbox-custom mb15 text-right">';
        if ($val) {
            $checkbox .= '<input id="checkbox' . $id . '" type="checkbox" name="checks[' . $id . ']" value="' . $value . '">';
        } else {
            $checkbox .= '<input id="checkbox' . $id . '" type="checkbox" name="checks[]" value="' . $value . '">';
        }
        $checkbox .= '<label for="checkbox' . $id . '"></label>
   </td>
</div>';
    } elseif (!$type) {
        $checkbox = '<div>';
        if ($dropdown) $checkbox .= '<td style="text-align:right" class="text-right">
                                   ' . $dropdown . '

                        </td>';
    } else {
        return;
    }
    echo $checkbox;
}

function init_sfoot($option = false, $hr = false, $redir = false, $urls = '{ADMIN_LINK}')
{
    global $lang;
    $sfoot = '';
    $redir = !$redir ? '' : $redir;
    $hr = $hr ? '<hr class="short mb10">' : '';
    if (isset($option)) {
        $sfoot .= '<input type="hidden" name="s_search" value="1">
               <button type ="submit" ' . btn_class('system', true, '2') . '> ' . $lang['search'] . ' </button>
               <button type ="button" ' . btn_class('danger', true, '2') . 'onclick="javascript:clearform(document.search); return false;">' . $lang['clear'] . '</button>
               <button type ="button" ' . btn_class('dark', true, '2') . ' onclick ="window.location.href = \'' . $urls . '/' . $redir . '\'">' . $lang['base_s_back'] . '</button>';
    } else {
        return;
    }
    return $hr . '<div style="text-align:center" class="section mb10 pl5">' . $sfoot . '</div>      
 <script>
function checkIdKey(key) {
  return (key >= \'0\' && key <= \'9\') || key === \'+\' || key === \'(\' || key === \')\' || key === \'-\';
}
</script>';
}


/*
 * $type - включение (true), выключение (false)
 * $fa - иконка типа 'fa-keyboard-o'
 * $value - задает значение для элемента
 * $btn - цвет кнопки
 * $class - класс кнопки
 * $position - позиция справа или слева

*/
function init_dfoot($type = false, $fa = false, $value = false, $btn = 'danger', $class = false, $position = false): string
{
    global $lang;
    $dfoot = '';
    $position = $position ? ($position == 'l' ? 'text-left' : ($position == 'r' ? 'text-right' : '')) : '';
    $lines = $class ? 'panel-footer-lines ' . $position : 'panel-footer ' . $position;
    $class = $class == 'not' ? '' : $lines;
    if (isset($type)) {
        $dfoot .= '<button name="submit" type="submit" id="sub" ' . btn_class($btn, true) . ' value="' . $value . '">' . faSpan($fa, true, $lang[$value]) . '</button>          ';
    }
    return '<div class="' . $class . ' admin-form">' . $dfoot . '</div>';
}

function init_tfoot($option = false, $fa = false, $type = false, $btn = 'danger'): void
{
    global $lang;
    $tfoot = '';
    if (isset($option)) {
        $tfoot .= '<tfoot class="footer-menu admin-form">
                     <tr style="text-align:right">
                        <td style="text-align:right" colspan="10">
                           <nav style="text-align:right" class="text-right">';
        if ($type) {
            $tfoot .= '<button name="submit" type="submit" id="sub" ' . btn_class($btn, true) . ' value="' . $type . '">' . faSpan($fa, true, $lang[$type]) . '</button>';
        } else {
            $tfoot .= '<select style="display: inline-block;" class="form-select form-control" name="act">
                              ' . $option . '
                              </select>
                              <input name="submit" type="submit" id="sub" ' . btn_class('system', true, true) . ' value="' . $lang['doit'] . '"><span class="pd-l-sm"></span>';
        }
        $tfoot .= '</nav>
                       </td>
                     </tr>
                  </tfoot>';
    } else {
        return;
    }
    echo $tfoot;
}

function init_Ajax_count($admin, $module = false, $id = false, $choice = false, $where = false, $folder = false, $date = false, $num = 'get'): void
{
    global $admin_conf, $lang;
    $where = $where ? '/' . $where : '/';
    $admin_link = $admin == 'root' ? ADMIN . '/' : ADMIN . '/module/';
    $folder = $folder ? '/' . $folder : '/count';
    $date = $date ? '/' . $date : '';
    $num = $num ? '/get' : '/num';
    $data_refresh = $admin_conf['uploading_data'] == 1 ? '5000' : '86400';
    $div = intval($id) ? 'td' : 'div';
    $divs = $div == 'div' ? '<div class="panel-heading">' . $lang['ajax_load'] . '<img src="usr/tpl/admin/images/loading.gif" style="border:0" width="75" height="50" alt=""/></div>' : '';
    if (!$module) {
        echo '<script type="text/javascript">setInterval(function(){
   $("#count' . $id . '").load(\'' . ADMIN . '/ajax/' . $id . '\', \'count' . $id . '\');
   }, ' . $data_refresh . ')
</script>
<' . $div . ' id="count' . $id . '" class="text-center">
' . $divs . '
<script type="text/javascript">ajaxGet(\'' . ADMIN . '/ajax/' . $id . '\', \'count' . $id . '\');</script>
</' . $div . '>';
    } elseif ($module == 'demoHighCharts') {
        echo '<div id="' . $id . '" class="mt50 row text-center">
   <div class="panel-heading">' . $lang['ajax_load'] . '<img src="usr/tpl/admin/images/loading.gif" style="border:0" width="75" height="50" alt=""/></div>
   <script type="text/javascript">ajaxGetJS(\'' . ADMIN . '/ajax/' . $id . '\', \'demoHighCharts.init();\', \'server_stats\');</script>
</div>';
    } else {
        echo '<script type="text/javascript">setInterval(function(){
   $("#' . $choice . $id . '").load(\'' . $admin_link . $module . '/ajax' . $folder . '/' . $choice . '/' . $id . $where . $date . $num . '\', \'' . $choice . $id . '\');
   }, ' . $data_refresh . ')
</script>
<' . $div . ' id="' . $choice . $id . '" class="text-center">
' . $divs . '
<script type="text/javascript">ajaxGet(\'' . $admin_link . $module . '/ajax' . $folder . '/' . $choice . '/' . $id . $where . $date . $num . '\', \'' . $choice . $id . '\');</script>
</' . $div . '>';
    }
}

function case_ajax($baza = false, $swhere = false): void
{
    global $core, $url;
    ajaxInit();
    $status = $url[1] == 'module';
    $module = $status ? $url[2] : $url[1];
    $module = $baza ?: $module;
    $type = $status ? $url[4] : $url[3];
    $count = $status ? $url[5] : $url[4];
    $id = $status ? $url[6] : $url[5];
    $u7 = $url[7] ?? '';
    $where = $status ? ' WHERE ' . $u7 : ' WHERE ' . $url[6];
    $swhere = $swhere ?: $where;
    $swhere = str_replace(array('WHERE'), array(''), $where);
    $rows = $core->row_data($module, $where);
    $counter = $count == 'core' ? $core->sum_data($module, $swhere) : $rows[$count];
    switch ($type) {
        case 'date':
            echo formatDate($counter, true);
            break;
        case 'count':
            echo formatCounter($counter);
            break;
    }
}