<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $url, $lang;
if (empty($url[2])) {
    onmoder('comments', 'status', 'comments_moder');
} else {
    comments_list();
}
function comments_list()
{
    global $adminTpl, $db, $core, $lang;
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    UniClass('selectList');
    datetimepickerInit('s_startdate', 'date');
    datetimepickerInit('s_enddate', 'date');
    $where = '';
    $order = '';
    $whereC = 'WHERE status = 2 ';
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_author = isset($_POST['s_author']) ? filter($_POST['s_author'], 'a') : '';
    $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
    $s_desc = $_POST['s_desc'] ?? '';
    $s_module = $_POST['s_module'] ?? '';
    $s_startdate = isset($_POST['s_startdate']) ? strtotime($_POST['s_startdate']) : '';
    $s_enddate = isset($_POST['s_enddate']) ? strtotime($_POST['s_enddate']) : '';
    $s_active = isset($_POST['s_active']);
    $s_search = isset($_POST['s_search']);
    if ($s_search) $s_search = $_POST['s_search'] == 1;
    if ($s_active) {
        if ($_POST['s_active'] == 1) {
            $where = 'WHERE c.status = 1  ';
        } else {
            $s_active = false;
            $where = 'WHERE c.status = 0 ';
        }
    } else {
        $s_active = true;
        $where = 'WHERE c.status = 2 ';
    }
    if ($s_id) {
        $where .= 'AND c.id LIKE"%' . $db->safesql($s_id) . '%"';
    } else {
        $s_id = '';
    }
    if ($s_author) $where .= 'AND c.uid LIKE "%' . $db->safesql($s_author) . '%"';
    if ($s_desc) $where .= 'AND c.text LIKE "%' . $db->safesql($s_desc) . '%"';
    if ($s_module) $where .= 'AND c.module LIKE "%' . $db->safesql($s_module) . '%"';
    if ($s_startdate) $where .= 'AND c.date >="' . intval($s_startdate) . '"';
    if ($s_enddate) $where .= 'AND c.date <="' . intval($s_enddate) . '"';
    if (isset($url[4]) && $url[4] == 'order') {
        switch ($url[5]) {
            case 'abc':
                $order .= 'c.text ASC';
                break;
            case 'last':
                $order .= 'c.date DESC';
                break;
            case 'id':
                $order .= 'c.id ASC';
                break;
        }
    } else {
        $order .= 'c.date DESC';
    }
    $query = $core->select_data('comments', $where, $order . ' LIMIT ' . limit_page(), 'c.*, u.nick, u.group, u.last_visit', 'as c LEFT JOIN ' . DB_PREFIX . '_users as u on (c.uid=u.id)');
    $adminTpl->admin_head($lang['comments_onmoder']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('comments');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['comments_list'] . ':</span>
            ' . sort_head('moder', 5, 'last') . '          
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" method="POST" action="{ADMIN}/comments/action&moderate" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-7">' . $lang['titles'] . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo '</tr>
                  </thead>
                  <tbody>';
        while ($comment = $db->getRow($query)) {
            $tt = str(htmlspecialchars(strip_tags($comment['text'])), 20);
            $row = $core->row_data($comment['module'], 'id ="' . $comment['post_id'] . '"');
            $catInfo = $row['cat'] !== ',0,' ? $comment['module'] . '/' . $core->getCat($comment['module'], $row['cat'], 'development') : $comment['module'];
            $altname = isset($catInfo) ? ($row['altname'] ?? $row['translate']) : '';
            $url_link = $catInfo ? $catInfo . '/' . $altname : $altname . '.html';
            $patch = 'files/' . $comment['module'] . '/' . $comment['post_id'] . '/';
            $images = array();
            $all_files = scandir(news_image($patch));
            for ($i = 0; $i < count($all_files); $i++) {
                if (!str_contains($all_files[$i], ".png") && !str_contains($all_files[$i], ".jpg") && !str_contains($all_files[$i], ".gif")) continue;
                $images[] = $all_files[$i];
            }
            $dir = news_image($patch);
            $img_random = $images ? $images[rand(0, sizeof($images) - 1)] : 'media/cats/no_image.png';
            $img_src = $images ? $dir . $img_random : $img_random;
            echo '<tr>
                        <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $comment['id'] . '</td>
                        <td>
                           <div class="media media-list"><a href="' . $url_link . '.html"><img src="' . $img_src . '" style="width:76px; height:76px;" alt=""></a></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . _nTitle($comment['module'], $comment['post_id']) . '</a></ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['com_text'] . ': ' . (($tt != '') ? '<a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-text_' . $comment['id'] . '\')"">' . $tt . '</a> ' : colorSpan('red', $lang['no_text'])) . '</a></ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['date'] . ': ' . formatDate($comment['date'], true) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['links'] . ': ' . (eregStrt('href', $comment['text']) ? colorSpan('red', $lang['yes']) : colorSpan('green', $lang['no'])) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['module'] . ': ' . commentLink($comment['module'], $comment['post_id']) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['author'] . ': ' . (($comment['uid'] != 0) ? '<a href="profile/' . $comment['nick'] . '" title="' . $comment['nick'] . '">' . $comment['nick'] . '</a>' : $comment['gname']) . ' </a ></ol >
                        </td>
                        <td class="text-center" > ' . status_icon('comments', $comment['id']) . ' </td>';
            init_checkbox('td', $comment['id'], false, '<li><a href = \'{ADMIN}/comments/edit/' . $comment['id'] . '\'" target="_blank">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a href="{ADMIN}/comments/retivate/' . $comment['id'] . '">' . faSpan('fa-power-off', true, (($comment['status'] != 1) ? $lang['do_activation'] : $lang['do_deactivation'])) . '</a></li>
                                 <li><a href="{ADMIN}/l/pm/' . $comment['uid'] . '\">' . faSpan('fa-user-o', true, $lang['pm']) . '</a></li>
                                 <li><a href="{ADMIN}/user/mail/' . $comment['uid'] . '\">' . faSpan('fa-envelope-o', true, $lang['mail']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $comment['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            echo '</tr>';
            modal_form_text('text_' . $comment['id'], $lang['info'], 'fa-info-circle', $lang['com_text'], $comment['text']);
            modal_form_delete($comment['id'], $tt, $lang['comments_delete_title'], 'comments', $lang['comments_delete_text'], '{ADMIN}/comments/delete/' . $comment['id']);
        }
        echo '</tbody>';
        init_tfoot('<option value="activate">' . $lang['do_activation'] . '</option>
                        <option value="deActivate">' . $lang['do_deactivation'] . '</option>
                        <option value="reActivate">' . $lang['do_reactivation'] . '</option>
                        <option value="doReactivate">' . $lang['do_moderation'] . '</option>
                        <option value="delete">' . $lang['delete'] . '</option>');
        echo '</table>
            </form>
         </div>
      </div>';
        page_list('root', 'comments', 'comments', str_replace('c.', '', $where), 2);
        echo '</div>
<aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
               <label for="s_author" class="field prepend-icon">
                  <select name="s_author" id="s_author" class="form-control select2-single">
                     <option value="0">' . $lang['choose_users'] . '</option>';
        $query_users_list = $core->select_data('users');
        if ($db->numRows($query_users_list) > 0) {
            while ($users_list = $db->getRow($query_users_list)) {
                $selected = ($users_list['nick'] == $comment['author']) ? "selected" : "";
                echo '<option value="' . $users_list['id'] . '"' . $selected . '>' . $users_list['nick'] . '</option>';
            }
        }
        echo '</select>
                  ' . faI('arrow double') . '
               </label>
            </div>
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['comments_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_module" class="field prepend-icon">
                  <select class="form-control" name="s_module" id="s_module">
                     <option value="0">' . $lang['choose_module'] . '</option>';
        foreach ($core->getModList() as $module) {
            if (in_array($module, exceMods('categories'))) {
                $selected = ($module == $comment['module']) ? "selected" : "";
                echo '<option value="' . $module . '"' . $selected . '>' . _mName($module) . '</option>';
            }
        }
        echo '</select>
                  ' . faI('arrow double') . '
               </label>
            </div>
            <div class="section mb10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['comments_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5 pl10">
               <h5><small>' . $lang['news_search_date'] . '</small></h5>
               <div class="section row">
                  <div class="col-md-6">
                     <label for="s_startdate" class="field prepend-icon">
                     <input id="s_startdate" type="text" name="s_startdate" placeholder="' . $lang['from'] . '" class="form-control">
                     <label for="s_startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
                  <div class="col-md-6">
                     <label for="s_enddate" class="field prepend-icon">
                     <input id="s_enddate" type="text" name="s_enddate" placeholder="' . $lang['to'] . '" class="form-control">
                     <label for="s_enddate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active"' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['comments_active'] . '</label>
            </div>
            ' . init_sfoot(true, true) . '
         </div>
      </form>
   </aside>
</div>';
    } else {
        if (isset($_POST['search'])) {
            $adminTpl->info($lang['comments_onmoder_empty'], 'empty', null, $lang['comments_onmoder_list']);
            header("refresh: 5; url={MODER_LINK}/moderation/com/comments");
        } else {
            $adminTpl->info($lang['comments_onmoder_empty'], 'empty', null, $lang['comments_onmoder_list'], $lang['comments_list'], ADMIN . '/comments');
        }
    }
    $adminTpl->admin_foot();
}