<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
if (file_exists(ROOT . 'root/table/db_insert.php')) include(ROOT . 'root/table/db_insert.php');
if (file_exists(ROOT . 'root/other/other.functions.php')) include(ROOT . 'root/other/other.functions.php');
function adminError($err, $back = false): void
{
    global $adminTpl, $lang;
    $adminTpl->admin_head($lang['base_error']);
    $adminTpl->info($err . ($back ? '<a href="#" onclick="/' . ADMIN . '/' . $back . '/" >' . $lang['base_back'] . '</a>' : ''));
    $adminTpl->admin_foot();
}

function openMenu($matches)
{
    global $url;
    $type = $matches[1];
    $typeArray = explode(',', $type);
    $ccount = 1;
    if (!empty($url[1])) {
        if ($url[1] == 'module') $ccount = 2;
        if (in_array($url[$ccount], $typeArray)) return 'menu-open';
    }
}

function context($text)
{
    global $admin_conf;
    if ($text) {
        preg_match('/<img.*width="(.*)".*height="(.*)".*>/is', $text, $matches);
        preg_match('/<img.*height="(.*)".*>/is', $text, $matchess);
        if ($matches && $matchess) {
            $width = $matches[1];
            $height = $matchess[1];
        } else {
            $width = '';
            $height = '';
        }
        if ($admin_conf['lastcom_news_img_height'] && $admin_conf['lastcom_news_img_widtht']) {
            $context = str_replace(array($width, $height), array($admin_conf['lastcom_news_img_widtht'], $admin_conf['lastcom_news_img_height']), $text);
        } elseif ($admin_conf['lastcom_news_img_height'] == 0 && $admin_conf['lastcom_news_img_widtht']) {
            $context = str_replace(array($width, $height), array($admin_conf['lastcom_news_img_widtht'], $height), $text);
        } elseif ($admin_conf['lastcom_news_img_height'] && $admin_conf['lastcom_news_img_widtht'] == 0) {
            $context = str_replace(array($width, $height), array($width, $admin_conf['lastcom_news_img_height']), $text);
        } else {
            $context = str_replace(array($width, $height), array($width, $height), $text);
        }
        return $context;
    }
}

function conColor($condition, $type): string
{
    $result = $condition ? '#FF0000' : '#009900';
    return colorSpan($result, $type);
}

function info_modal($form): string
{
    global $core, $lang;
    return '<a href="' . $core->fullURL() . '#" class="active media pl5" onclick="modal_o(\'#modal-form-' . $form . '\')">' . faI('fa-question-circle fc-button-help visible-lg-inline-block text-primary-600 pl5', false, false, false, $lang['all_info'], false, 'data-rel="popover" data-trigger="hover" data-placement="right" data-content="1"') . '</a><br/>';
}

function chooseMenu($matches)
{
    global $url;
    $type = $matches[1];
    $typeArray = explode(',', $type);
    $ccount = 1;
    if (!empty($url[1])) {
        if ($url[1] == 'module') $ccount = 2;
    } else {
        $ccount = 0;
    }
    if ((in_array($url[$ccount], $typeArray)) || (($type == 'main') && (empty($url[1])))) return 'class="active"';
}

function getServerCheck(): bool|array|string
{
    global $lang;
    $str = '';
    $time = jmycmsck('counter');
    $counterstat = jmycmsck('counterstat');
    $date = $time ? $time : '';
    if ($date) {
        echo '<script type="text/javascript">
   datecountdowndate("' . date("m/d/y g:i A", (int)$date) . '");
   function datecountdowndate($intdate){
   countdown($intdate);
   }
   function declOfNum(n, text_forms) {
   n = Math.abs(n) % 100; var n1 = n % 10;
   if (n > 10 && n < 20) { return text_forms[2]; }
   if (n1 > 1 && n1 < 5) { return text_forms[1]; }
   if (n1 === 1) { return text_forms[0]; }
   return text_forms[2];
   }
   function countdown(dateEnd) {
   var timer, days, hours, minutes, seconds;
   dateEnd = new Date(dateEnd);
   dateEnd = dateEnd.getTime();
   if ( isNaN(dateEnd) ) {
   return;
   }
   timer = setInterval(calculate, 1000);
   function calculate() {
   var dateStart = new Date();
   var dateStart = new Date(dateStart.getUTCFullYear(),
                            dateStart.getUTCMonth(),
                            dateStart.getUTCDate(),
                            dateStart.getUTCHours(),
                            dateStart.getUTCMinutes(),
                            dateStart.getUTCSeconds());
   var timeRemaining = parseInt((dateEnd - dateStart.getTime()) / 1000)
   if ( timeRemaining >= 0 ) {
     days    = parseInt(timeRemaining / 86400);
     timeRemaining   = (timeRemaining % 86400);
     hours   = parseInt(timeRemaining / 3600);
     timeRemaining   = (timeRemaining % 3600);
     minutes = parseInt(timeRemaining / 60);
     timeRemaining   = (timeRemaining % 60);
     seconds = parseInt(timeRemaining);
   if(days > 0)  document.getElementById("days").innerHTML    = parseInt(days, 10) + declOfNum(parseInt(days, 10), [\'' . $lang['days1'] . '\', \'' . $lang['days2'] . '\', \'' . $lang['days3'] . '\']);
   if(hours > 0)  document.getElementById("hours").innerHTML   = ("0" + hours).slice(-2) + declOfNum(("0" + hours).slice(-2), [\'' . $lang['hours1'] . '\', \'' . $lang['hours2'] . '\', \'' . $lang['hours3'] . '\']);
   if(minutes > 0) document.getElementById("minutes").innerHTML = ("0" + minutes).slice(-2) + declOfNum(("0" + minutes).slice(-2), [\'' . $lang['minutes1'] . '\', \'' . $lang['minutes2'] . '\', \'' . $lang['minutes3'] . '\']);
   if(seconds > 0)  document.getElementById("seconds").innerHTML = ("0" + seconds).slice(-2) + declOfNum(("0" + seconds).slice(-2), [\'' . $lang['seconds1'] . '\', \'' . $lang['seconds2'] . '\', \'' . $lang['seconds3'] . '\']);
        } else {
     return;
   }
   }
   function display(days, hours, minutes, seconds) {}
   }
</script>';
        $str .= '<span id="days"></span>&nbsp;';
        $str .= '<span id="hours"></span>&nbsp;';
        $str .= '<span id="minutes"></span>&nbsp;';
        $str .= '<span id="seconds"></span>';
        echo '<div class="countdown">
   <p class="timer">';
        return '&nbsp;' . $counterstat . $str;
        echo '</p>
</div>';
    } else {
        return $counterstat;
    }
}

function sound_alert(): void
{
    global $admin_conf;
    echo $admin_conf['audio_alert'] == 1 ? '<audio src="media/sound/notifications.mp3" volume="1" autoplay></audio>' : '';
}

function checkActive($matches)
{
    $content = $matches[1];
    global $core, $url, $lang;
    $status = ping_dir(getHost($lang['jmycms']), $lang['p80']);
    $saversion = $status ? getServerCheck() : $lang['server_not_available'];
    $sversion = ($saversion !== false) ? '<hr class="alt short mv15">' . $saversion : '';
    if (!empty($url[1])) {
        if ($url[1] == 'update') return false;
        if ($url[1] == 'module') {
            if ($core->checkModule($url[2]) == '1') return stripslashes($content);
        } else {
            return stripslashes($content);
        }
    } else {
        return '<header id="topbar" class="panel">
   <div class="panel-body">
      <div class="topbar-left pull-left">
         <h4 class="mn">' . $lang['main_main'] . '</h4>
      </div>
      <div class="topbar-right">
         <div class="btn-group">
            <div class="col-lg-5 col-md-5 col-sm-8">
               <a href="administration/module/news/add" type="button" class="btn btn-system btn-raised legitRipple">' . faSpan('fa-newspaper-o', true, $lang['add_news']) . '</a>
            </div>
         </div>
         <div class="btn-group">
            <div class="col-lg-5 col-md-5 col-sm-8">
               <a href="administration/module/news/" type="button" class="btn btn-system btn-raised legitRipple">' . faSpan('fa-external-link', true, $lang['edit_news']) . '</a>
            </div>
         </div>
      </div>
   </div>
   <span class="text-shady-lady fs15">' . $lang['version'] . VERSION_ID . '<p>' . $sversion . '</p></span>
</header>';
    }
}

function adminArea($name, $val = null, $rows = 10, $class = 'textarea', $onclick = null, $return = false): false|string|null
{
    global $adminTpl, $core, $config, $lang;
    if ($core->html_editor == 1) {
        $id = $name;
        $adminTpl->headerIncludes['bb'] = '<script type="text/javascript" src="usr/plugins/js/bb_editor.js"></script><script type="text/javascript">var textareaName = \'' . $name . '\';</script>';
        $adminTpl->headerIncludes['htmleditor'] = '<script type="text/javascript" src="/usr/plugins/tinymce/tinymce.min.js"></script>
<script>
   tinymce.init({
   	theme: \'modern\',
   	skin: \'custom\',
   	selector: \'textarea\',
   	language:"' . $config['lang'] . '",
   	height: 300,
   	menubar:false,
   	statusbar: false,
   	convert_urls: false,
   	relative_urls: false,
    plugins: [
   \'advlist autolink lists link codesample hr image charmap print preview anchor\',
   \'searchreplace visualblocks code fullscreen imagetools textcolor colorpicker textpattern\',
   \'insertdatetime media table contextmenu paste spellchecker responsivefilemanager code youtube jmybutton emoticons\'
   ],
   toolbar1: \'undo redo | styleselect | fontsizeselect | fontselect | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | forecolor backcolor | subscript superscript\',
   toolbar2: \'bullist numlist outdent indent table hr | link image jmythumb responsivefilemanager | jmymusic media youtube jmyflash jmyemo | paste jmymail jmyquote jmyhide codesample jmyspoiler | spellchecker removeformat searchreplace code \',
   	image_advtab: true,
   	imagetools_cors_hosts: [\'www.tinymce.com\', \'codepen.io\'],
   	spellchecker_language :"' . $config['lang'] . '",
   	spellchecker_languages :"Russian=ru,Ukrainian=uk,English=en",
   	spellchecker_rpc_url :"//speller.yandex.net/services/tinyspell",
   	external_filemanager_path:"/usr/plugins/filemanager/",
   	external_plugins: {"filemanager" :"/usr/plugins/filemanager/plugin.min.js"},
   	filemanager_title:"' . $lang['files_config'] . '",
   	extended_valid_elements :"iframe[src|width|height|name|align]",
   });
</script>';
        return '<textarea id="' . $id . '" name="' . $name . '" rows="' . $rows . '" cols="90" class="' . $class . '" onclick="mainArea(\'' . $name . '\')">' . $val . '</textarea>';
    } else {
        return bb_areaADM($name, $val, $rows, $class, $onclick, $return, true);
    }
}

function countPub()
{
//	return ' (+20)';
}

function checkAdmControl($mod = 'index'): bool
{
    global $core;
    if (!empty($core->auth->user_info['control'])) {
        $access = is_array(int_Serialize('uns', $core->auth->user_info['control'])) ? array_map('trim', int_Serialize('uns', $core->auth->user_info['control'])) : '';
        return !in_array($mod, $access);
    } else {
        return true;
    }
}

function noadmAccess(): void
{
    global $adminTpl, $lang;
    $adminTpl->admin_head($lang['no_access']);
    $adminTpl->info($lang['access_denied']);
    $adminTpl->admin_foot();
}

function nomodActive(): void
{
    global $adminTpl, $lang;
    $adminTpl->admin_head($lang['no_access']);
    $adminTpl->info($lang['module_install_no_active']);
    $adminTpl->admin_foot();
}

function fancyboxInit($id = 'fbox', $maxWidth = '880', $maxHeight = '600'): void
{
    global $adminTpl;
    $adminTpl->footIncludes[] = '<script type="text/javascript" src="/usr/plugins/fancybox/jquery.fancybox.pack.js"></script>
				<link rel="stylesheet" type="text/css" href="/usr/plugins/fancybox/jquery.fancybox.css" media="screen">
				<script type="text/javascript">
					$(document).ready(function() {
						$("#' . $id . '").fancybox({
							maxWidth	: ' . $maxWidth . ',
							maxHeight	: ' . $maxHeight . ',
							fitToView	: false,
							width		: \'70%\',
							height		: \'70%\',
							autoSize	: false,
							closeClick	: false,
							openEffect	: \'none\',
							closeEffect	: \'none\'
						});
					});
				</script>';
}

/*
* Выделяюем строку
*/
function InitCheck()
{
    echo '<script type="text/javascript">
   function getSource(e) {
       return (e.target) ? e.target : e.srcElement;
   }
   function lihtTable(e){
       if(e.type===\'checkbox\') {
       e.parentNode.parentNode.className = e.checked ?"warning" :"table-striped";
     }
   }
</script>';
}

function UniClass($selectList = false): void
{
    global $adminTpl, $admin_conf;
    if ($selectList == 'selectList') {
        $adminTpl->js_code[] = 'var selectList = $(\'.admin-form select\');
selectList.each(function (i, e) {
$(e).on(\'change\', function () {
if ($(e).val() =="0") $(e).addClass("empty");
else $(e).removeClass("empty")
});
});
selectList.each(function (i, e) {
$(e).change();
});
$("input#tagsinput").tagsinput({
tagClass: function (item) {
return \'label label-default\';
}
});
$(".select2-single").select2();';
    } else {
        if ($admin_conf['inline'] == 1) {
            $adminTpl->js_code[] = 'let elemElement = document.querySelectorAll(\'.select\');
for (let i = 0; i < elemElement.length; i++) {
    elemElement[i].className -=" select";
}
for (let i = 0; i < elemElement.length; i++) {
    elemElement[i].className +=" col-lg-12";
}';
        } else {
            $adminTpl->js_code[] = 'let elemElement = document.querySelectorAll(\'.form-control\');
for (let i = 0; i < elemElement.length; i++) {
    elemElement[i].className +="form-control form-controls gui-input";
}';
        }
    }
}

function colorpickerInit($id = 'color_p', $color = '#02c385'): void
{
    global $adminTpl;
    $adminTpl->js_code[] = "$('#" . $id . "').colorpicker({color: '" . $color . "'});";
}

function datetimepickerInit($id = 'date', $type = 'all'): void
{
    global $adminTpl, $core;
    switch ($type) {
        case 'all':
            $adminTpl->js_code[] = '$("#' . $id . '").datetimepicker({
            prevText: \'' . faI('fa-chevron-left', false, false, false, false, 'padding:7px') . '\',
            nextText: \'' . faI('fa-chevron-right', false, false, false, false, 'padding:7px') . '\',
			beforeShow: function (input, inst) {
			var newclass = \'admin-form\';
			var themeClass = $(this).parents(\'.admin-form\').attr(\'class\');
			var smartpikr = inst.dpDiv.parent();
			if (!smartpikr.hasClass(themeClass)) {
				inst.dpDiv.wrap(\'<div class="admin-form mw1000 center-block theme-primary" style="top: 100px !important;"></div>\');
			}
			var offset = $(input).offset();
			var height = $(input).height();
			window.setTimeout(function () {
				inst.dpDiv.css({ top: (offset.top + height +19) + \'px\', left: (offset.left - 50) + \'px\' })
			}, 1);
			}
		});';
            break;
        case 'date':
            $adminTpl->js_code[] = '$("#' . $id . '").datepicker({
            prevText: \'' . faI('fa-chevron-left', false, false, false, false, 'padding:7px') . '\',
            nextText: \'' . faI('fa-chevron-right', false, false, false, false, 'padding:7px') . '\',
			beforeShow: function (input, inst) {
			var newclass = \'admin-form\';
			var themeClass = $(this).parents(\'.admin-form\').attr(\'class\');
			var smartpikr = inst.dpDiv.parent();
			if (!smartpikr.hasClass(themeClass)) {
				inst.dpDiv.wrap(\'<div class="admin-form mw1000 center-block theme-primary"></div>\');
			}
			}
		});
		';
            break;
    }
    $adminTpl->footIncludes[''] = '<script src="' . ADMIN_TPL . 'assets/js/jquery-ui-monthpicker.min.js"></script>
									<script src="' . ADMIN_TPL . 'assets/js/jquery-ui-datepicker.min.js"></script>
									<script src="/langs/' . $core->InitLang() . '/js/datepicker.js"></script>
									<script src="/langs/' . $core->InitLang() . '/js/timepicker.js"></script>';
}

function mhColor($text, $icon = false, $bg = false)
{
    global $admin_conf;
    if (isset($text)) {
        $lg = !empty($bg) ? ' fa-lg ' : false;
        $icon = !empty($icon) ? $icon : false;
        echo '<style type="text/css">
   .mfp-close-btn-in .mfp-close {
   color: #fff;
   }
</style>
<div class="panel-heading ui-dialog-titlebar" style="background:' . $admin_conf['colorPanel'] . '">
   <span class="panel-icon">' . faSpan($icon . $lg) . '</span>
   <span class="panel-title">' . $text . '</span>
</div>';
    }
    return $text;
}

function Scroll($id)
{
    global $adminTpl;
    if (isset($id)) {
        $adminTpl->js_code[] = ' jQuery(function($) {
$(window).scroll(function() {
var top = $(document).scrollTop();
if (top < 100) $(\'#' . $id . '\').css({top: \'0\', position: \'relative\'});
else $(\'#' . $id . '\').css({top: \'80px\', position: \'fixed\'});
});
});';
    }
    return $id;
}

function Clearform($id)
{
    if (isset($id)) {
        echo '<script>
    function clearform(frm){
        for (var i=0;i<frm.length;i++) {
            var el=frm.elements[i];
      if (el.type==="checkbox" || el.type==="radio") { el.checked=0; continue; }
      if ((el.type==="text") || (el.type==="textarea") || (el.type === "password")) { el.value=""; continue; }
      if ((el.type==="select-one") || (el.type==="select-multiple")) { el.selectedIndex=0; }
    }
    document.search.start_from.value="";
    }
    </script>';
    }
    return $id;
}

function dirsize($dir, $buf = 2)
{
    static $buffer;
    if (isset($buffer[$dir])) return $buffer[$dir];
    if (is_file($dir)) return filesize($dir);
    if ($dh = opendir($dir)) {
        $size = 0;
        while (($file = readdir($dh)) !== false) {
            if ($file == '.' || $file == '..') continue;
            $size += dirsize($dir . '/' . $file, $buf - 1);
        }
        closedir($dh);
        if ($buf > 0) $buffer[$dir] = $size;
        return $size;
    }
    return false;
}

/*
* Получаем категории из массива ЭКСПЕРЕМЕНТАЛЬНАЯ ФУНКЦИЯ :D
* $fp - файл
* $content - то что запишем
*/
function save_conf($fp, $content): void
{
    $file_name = basename($fp);
    if (!file_exists($fp)) {
        file_put_contents($fp, '');
        @chmod(ROOT . $fp, 0666);
    }
    if (file_exists($fp) && $content) {
        $fp = fopen($fp, "wb");
        $content = "<?php
if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
\n" . $content . "\n";
        fwrite($fp, $content);
        fclose($fp);
    }
}

function exceMods($type = NULL)
{
    global $core, $db;
    if (!empty($type)) {
        $query = $core->select_data('plugins', $db->safesql($type) . ' = 1');
        if ($db->numRows($query) > 0) {
            while ($mod = $db->getRow($query)) {
                $modules[] = $mod['title'];
            }
        }
        return $modules;
    }
}

function ArrayToStr($array = NULL): false|string|null
{
    if (is_array($array)) {
        $strs = null;
        foreach ($array as $str) {
            if ($str) $strs .= $str . "\n";
        }
        return $strs;
    } else {
        return false;
    }
}

/*
* Выводим чекбоксы :D
* $name - имя инпута чек бокса
* $val - условие параметра
* $text - вывод текста
*/
function checkbox($name, $val, $text = null): string
{
    $checked = !empty($val) ? 'checked ' : false;
    return '<div class="checkbox-custom">
   <input id="cb_' . $name . '" type="checkbox" name="' . $name . '"' . $checked . '>
   <label for="cb_' . $name . '">' . $text . '</label>
</div>';
}

/*
* Выводим жирные чекбоксы :D
* $name - имя инпута чек бокса
* $val - условие параметра
* $text - вывод текста
* $hr - отчеркнуть текст
* $br - следующая строка текста
* $value - запись данных value
*/
function scheckbox($name, $val, $text = null, $hr = true, $br = false, $value = false, $default_checked = false): string
{
    $checkbox = '';
    $checked = !empty($val) ? 'checked ' : '';
    $default_checked = !empty($default_checked) ? 'checked ' : '';
    if ($value) $value = ' value ="' . $value . '"';
    $checkbox .= '<label class="field option">
                 <input id="cb_' . $name . '" type="checkbox" name="' . $name . '"' . $checked . $value . $default_checked . '>
                 <span for="cb_' . $name . '" class="checkbox mr10"></span>' . $text . '</label>';
    $checkbox .= $hr ? ($hr == 'short' && $hr <> 1 ? '<hr class="short">' : '<hr class="alt short mv15">') : '';
    $checkbox .= $br ? '<p class="alt short mv15">' : '';
    return $checkbox;
}

function checked($val): string
{
    return !empty($val) ? 'checked ' : '';
}

/*
* Выводим радио выбор Да Нет
* $name - имя инпута радио
* $val - условие параметра
*/
function radio($name, $val): string
{
    $but_1 = ($val) ? 'checked=""' : '';
    return '<div class="switch switch-info round switch-inline">
               <input type="hidden" name="' . $name . '" value="0">
               <input id="radio_' . $name . '" name="' . $name . '" type="checkbox"' . $but_1 . ' value="1">
               <label for="radio_' . $name . '"></label>
            </div>';
}

/*
*
*/
function input_data($type, $name = false, $value = false, $num = false, $text = false, $placeholder = false, $icon = false, $info = false): string
{
    $content = '<div class="form-group admin-form">
               <label for="' . $name . '" class="col-lg-3 col-sm-3 control-label">' . $text . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="' . $name . '" class="field prepend-icon">';
    if ($type == 'input') {
        $content = '<input id="' . $name . '" type="text" name="' . $name . '" onkeyup="count_down(this, \'' . $name . '\', \'' . $num . '\')" maxlength="' . $num . '" value="' . $value . '" placeholder="' . $placeholder . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">';
    } elseif ($type == 'textarea') {
        $content = '<textarea name="' . $name . '" id="' . $name . '"  onkeyup="count_down(this, \'' . $name . '\', \'' . $num . '\')" maxlength="' . $num . '" placeholder="' . $placeholder . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto" data-parsley-required="true" data-parsley-trigger="change">' . $value . '</textarea>';
    }
    $content .= '<label for="' . $name . '" class="field-icon">' . faI($icon, false, false, true) . '</label>
                  </label>';
    if ($num) {
        $content .= '<div style="text-align:right;" class="text-right">
                     <span id="char_' . $name . '"></span>
                 </div>';
    }
    if ($info) $content .= '<span class="input-footer">' . $info . '</span>';
    $content .= '</div>
            </div>';
    return $content;
}

/*
* Функция рекурсивного сканирования дерикторий шаба
* $rootDir - директория
*/
function scanDirectories($rootDir, $allData = array())
{
    $invisibleFileNames = array(".", "..", ".htaccess", ".htpasswd");
    $dirContent = scandir($rootDir);
    foreach ($dirContent as $key => $content) {
        $path = $rootDir . '/' . $content;
        if (!in_array($content, $invisibleFileNames)) {
            if (is_file($path) && is_readable($path) && eregStrt('.tpl', $content)) {
                $allData[] = $path;
            } elseif (is_dir($path) && is_readable($path)) {
                $allData = scanDirectories($path, $allData);
            }
        }
    }
    return $allData;
}

function dircopy($srcdir, $dstdir, $offset = 0, $verbose = false): string
{
    if (!isset($offset)) $offset = 0;
    $num = 0;
    $fail = 0;
    $sizetotal = 0;
    $fifail = '';
    $ret = '';
    if (!is_dir($dstdir)) {
        mkdir($dstdir, 0777);
        @chmod_R($dstdir, 0777);
    }
    if ($curdir = opendir($srcdir)) {
        while ($file = readdir($curdir)) {
            if ($file != '.' && $file != '..') {
                $srcfile = $srcdir . '\\' . $file;
                $dstfile = $dstdir . '\\' . $file;
                if (is_file($srcfile)) {
                    if (is_file($dstfile)) $ow = filemtime($srcfile) - filemtime($dstfile); else $ow = 1;
                    if ($ow > 0) {
                        if ($verbose) echo "Copying '$srcfile' to '$dstfile'...";
                        if (copy($srcfile, $dstfile)) {
                            touch($dstfile, filemtime($srcfile));
                            $num++;
                            $sizetotal = ($sizetotal + filesize($dstfile));
                            if ($verbose) echo "OK\n";
                        } else {
                            echo "Error: File '$srcfile' could not be copied!\n";
                            $fail++;
                            $fifail = $fifail . $srcfile . "|";
                        }
                    }
                } else if (is_dir($srcfile)) {
                    $res = explode(",", $ret);
                    $ret = dircopy($srcfile, $dstfile, $verbose);
                    $mod = explode(",", $ret);
                    $imp = array($res[0] + $mod[0], $mod[1] + $res[1], $mod[2] + $res[2], $mod[3] . $res[3]);
                    $ret = implode(",", $imp);
                }
            }
        }
        closedir($curdir);
    }
    $red = explode(",", $ret);
    return ($num + $red[0]) . "," . (($fail - $offset) + $red[1]) . "," . ($sizetotal + $red[2]) . "," . $fifail . $red[3];
}

function copydir($source, $dest): bool
{
    if (is_file($source)) return copy($source, $dest);
    if (!is_dir($dest)) mkdir($dest);
    $dir = dir($source);
    while (false !== $entry = $dir->read()) {
        if ($entry == '.' || $entry == '..') continue;
        if ($dest !== "$source/$entry") copyr("$source/$entry", "$dest/$entry");
    }
    $dir->close();
    return true;
}

function rmdir_rf($dirname): void
{
    if ($dirHandle = opendir($dirname)) {
        chdir($dirname);
        while ($file = readdir($dirHandle)) {
            if ($file == '.' || $file == '..') continue;
            if (is_dir($file)) rmdir_rf($file);
            else unlink($file);
        }
        chdir('..');
        rmdir($dirname);
        closedir($dirHandle);
    }
}

function getServerSpace(): float|int
{
    $free = @disk_free_space("/");
    $total = @disk_total_space("/");
    return (($total * 100 / $free) - 100);
}

function getServerMemoryUsage($getPercentage = true): ?int
{
    $memoryTotal = null;
    $memoryFree = null;
    if (stristr(PHP_OS, "win")) {
// Get total physical memory (this is in bytes)
        $cmd = "wmic ComputerSystem get TotalPhysicalMemory";
        @exec($cmd, $outputTotalPhysicalMemory);
// Get free physical memory (this is in kibibytes!)
        $cmd = "wmic OS get FreePhysicalMemory";
        @exec($cmd, $outputFreePhysicalMemory);
        if ($outputTotalPhysicalMemory && $outputFreePhysicalMemory) {
// Find total value
            foreach ($outputTotalPhysicalMemory as $line) {
                if ($line && preg_match("/^[0-9]+\$/", $line)) {
                    $memoryTotal = $line;
                    break;
                }
            }
// Find free value
            foreach ($outputFreePhysicalMemory as $line) {
                if ($line && preg_match("/^[0-9]+\$/", $line)) {
                    $memoryFree = $line;
                    $memoryFree *= 1024;    // convert from kibibytes to bytes
                    break;
                }
            }
        }
    } else {
        if (is_readable("/proc/meminfo")) {
            $stats = @file_get_contents("/proc/meminfo");
            if ($stats !== false) {
// Separate lines
                $stats = str_replace(array("\r\n", "\n\r", "\r"), "\n", $stats);
                $stats = explode("\n", $stats);
// Separate values and find correct lines for total and free mem
                foreach ($stats as $statLine) {
                    $statLineData = explode(":", trim($statLine));
//
// Extract size (TODO: It seems that (at least) the two values for total and free memory have the unit"kB" always. Is this correct?
//
// Total memory
                    if (count($statLineData) == 2 && trim($statLineData[0]) == "MemTotal") {
                        $memoryTotal = trim($statLineData[1]);
                        $memoryTotal = explode("", $memoryTotal);
                        $memoryTotal = $memoryTotal[0];
                        $memoryTotal *= 1024;    // convert from kibibytes to bytes
                    }
// Free memory
                    if (count($statLineData) == 2 && trim($statLineData[0]) == "MemFree") {
                        $memoryFree = trim($statLineData[1]);
                        $memoryFree = explode("", $memoryFree);
                        $memoryFree = $memoryFree[0];
                        $memoryFree *= 1024;    // convert from kibibytes to bytes
                    }
                }
            }
        }
    }
    if (is_null($memoryTotal) || is_null($memoryFree)) {
        return null;
    } else {
        if ($getPercentage) {
            return (int)(100 - ($memoryFree * 100 / $memoryTotal));
        } else {
            return (int)array(
                "total" => $memoryTotal,
                "free" => $memoryFree,
            );
        }
    }
}

function getServerCPULoad(): int
{
    $result = shell_exec('uptime') ? shell_exec('uptime') : false;
    $str = substr(strrchr($result, ":"), 1);
    $avs = array_map("trim", explode(",", $str));
    return (int)$avs + rand(1, 10);
}

function jsCalendar($id, $format = 'd.m.Y'): string
{
    if (is_array($id)) {
        $i = 0;
        foreach ($id as $k => $subId) {
            $i++;
            $subJs = "<script type=\"text/javascript\">
   window.addEvent('domready', function() {
   	myCal" . $i . " = new Calendar({" . $subId . ": '" . $format . "' }, { classes: ['dashboard'], direction: 0 });
   });
</script>";
        }
    } else {
        $subJs = "<script type=\"text/javascript\">
   window.addEvent('domready', function() {
   	myCal2 = new Calendar({" . $id . ": '" . $format . "' }, { classes: ['dashboard'], direction: 0 });
   });
</script>";
    }
    return '<script type="text/javascript" src="usr/plugins/calendar/mootools.js"></script><script type="text/javascript" src="usr/plugins/calendar/calendar.js"></script>' . $subJs . '
<link rel="stylesheet" type="text/css" href="usr/plugins/calendar/dashboard.css" media="screen">';
}

/*
* the part of this by zhilinsky (zhilinsky.ru) [sps] :D
*/
function nooverflow($a): int
{
    while ($a < -2147483648) $a += 2147483648 + 2147483648;
    while ($a > 2147483647) $a -= 2147483648 + 2147483648;
    return $a;
}

function zeroFill($x, $bits)
{
    if ($bits == 0) return $x;
    if ($bits == 32) return 0;
    $y = ($x & 0x7FFFFFFF) >> $bits;
    if (0x80000000 & $x) $y |= (1 << (31 - $bits));
    return $y;
}

function mix($a, $b, $c): array
{
    $a = (int)$a;
    $b = (int)$b;
    $c = (int)$c;
    $a -= $b;
    $a -= $c;
    $a = nooverflow($a);
    $a ^= (zeroFill($c, 13));
    $b -= $c;
    $b -= $a;
    $b = nooverflow($b);
    $b ^= ($a << 8);
    $c -= $a;
    $c -= $b;
    $c = nooverflow($c);
    $c ^= (zeroFill($b, 13));
    $a -= $b;
    $a -= $c;
    $a = nooverflow($a);
    $a ^= (zeroFill($c, 12));
    $b -= $c;
    $b -= $a;
    $b = nooverflow($b);
    $b ^= ($a << 16);
    $c -= $a;
    $c -= $b;
    $c = nooverflow($c);
    $c ^= (zeroFill($b, 5));
    $a -= $b;
    $a -= $c;
    $a = nooverflow($a);
    $a ^= (zeroFill($c, 3));
    $b -= $c;
    $b -= $a;
    $b = nooverflow($b);
    $b ^= ($a << 10);
    $c -= $a;
    $c -= $b;
    $c = nooverflow($c);
    $c ^= (zeroFill($b, 15));
    return array($a, $b, $c);
}

function GCH($url, $length = null, $init = 0xE6359A60): int
{
    if (is_null($length)) $length = sizeof($url);
    $a = $b = 0x9E3779B9;
    $c = $init;
    $k = 0;
    $len = $length;
    while ($len >= 12) {
        $a += ($url[$k] + ($url[$k + 1] << 8) + ($url[$k + 2] << 16) + ($url[$k + 3] << 24));
        $b += ($url[$k + 4] + ($url[$k + 5] << 8) + ($url[$k + 6] << 16) + ($url[$k + 7] << 24));
        $c += ($url[$k + 8] + ($url[$k + 9] << 8) + ($url[$k + 10] << 16) + ($url[$k + 11] << 24));
        $mix = mix($a, $b, $c);
        $a = $mix[0];
        $b = $mix[1];
        $c = $mix[2];
        $k += 12;
        $len -= 12;
    }
    $c += $length;
    switch ($len) {
        case 11:
            $c += ($url[$k + 10] << 24);
            break;
        case 10:
            $c += ($url[$k + 9] << 16);
            break;
        case 9 :
            $c += ($url[$k + 8] << 8);
            break;
        case 8 :
            $b += ($url[$k + 7] << 24);
            break;
        case 7 :
            $b += ($url[$k + 6] << 16);
            break;
        case 6 :
            $b += ($url[$k + 5] << 8);
            break;
        case 5 :
            $b += ($url[$k + 4]);
            break;
        case 4 :
            $a += ($url[$k + 3] << 24);
            break;
        case 3 :
            $a += ($url[$k + 2] << 16);
            break;
        case 2 :
            $a += ($url[$k + 1] << 8);
            break;
        case 1 :
            $a += ($url[$k]);
    }
    $mix = mix($a, $b, $c);
    return $mix[2];
}

function strord($string): array
{
    $result = array();
    for ($i = 0; $i < mb_strlen($string); $i++) {
        $result[$i] = ord($string[$i]);
    }
    return $result;
}

/*
* Определение ИКС сайта по урл
* $url - урл сайта которого определяем
*/
function yandex_sqi($url): void
{
    global $lang;
    $external = isset($_SERVER['REMOTE_ADDR']) ? getenv('HTTP_X_FORWARDED_FOR') : false;
    if ($external == '127.0.0.1') {
        echo 'Local ИКС 0';
    } else {
        echo '<a href="https://webmaster.yandex.ru/sqi?host=' . $url . '"><img width="88" height="31" title="' . $lang['go_webmaster'] . '" alt="" style="border:0;" src="https://yandex.ru/cycounter?' . $url . '&theme=light&lang=ru"/></a>';
    }
}

/*
* Определение Rang сайта по урл
* $url - урл сайта которого определяем
*/
function alex_rang($url): void
{
    global $lang;
    $source = file_get_contents_utf8('http://data.alexa.com/data?cli=10&dat=snbamz&url=' . $url);
//Alexa Rank
    preg_match('/<popularity url="(.*?)" text="([0-9]+)" source="panel"\/>/si', $source, $matches);
    $aresult = $matches ? $matches[2] : 0;
//Alexa Sites Linking in
    preg_match('/<linksin num="([0-9]+)"\/>/si', $source, $asli);
    $alinksin = $asli ? $asli[1] : 0;
//Alexa RU Rank
    preg_match('/<country code="RU" name="Russian Federation" rank="([0-9]+)"\/>/i', $source, $rankus);
    $usrank = $rankus ? $rankus[1] : 0;
//Alexa Reach Rank
    preg_match('/<reach rank="([0-9]+)"\/>/i', $source, $reachr);
    $areach = $reachr ? $reachr[1] : 0;
    $r = $aresult ? ($areach / $aresult - 1) * 100 : 0;
    if ($r > 0) {
        $percent = round($r, 2) . '%';
        $style = 'delta rank up pull-right';
        $icon = faSpan('fa-level-up', true);
    } elseif ($r == 0) {
        $percent = '';
        $style = '';
        $icon = '';
    } else {
        $percent = round($r, 2) . '%';
        $style = 'delta rank down pull-right';
        $icon = faSpan('fa-level-down', true);
    }
    echo '<div class="pull-right">
   <span class="' . $style . '">' . $icon . ' &emsp;' . $percent . '</span>
</div>
<p class="panel-title"><span class="pn mt30">#</span> ' . number_format($aresult) . '</p>
<p class="information">' . $lang['alexa_info'] . '</p>';
}

/*
 * Очистка таблиц по ajax
 */
function clear_tab($table): void
{
    global $core;
    if ($table == '' || !$table) {
        echo 'Не указана таблица';
    } else {
        $core->truncate_data($table);
        echo 'Очистка завершена';
    }
}

function int_cong($type, $name = false, $value = false, $id = false, $style = false): string
{
    $id = isset($id) ? 'id="' . $id . '"' : '';
    $style = $style ?: 'style="height: 124px; margin: 0 auto"';
    if ($type == 'input') {
        $content = '<input type="text" size="20" name="' . $name . '" ' . $id . ' class="form-control" value="' . $value . '">';
    } elseif ($type == 'textarea') {
        $content = '<textarea  name="' . $name . '" ' . $id . ' class="form-control" ' . $style . '  cols="30" rows="3">' . $value . '</textarea>';
    }
    return $content ?? '';
}

/*
 * $type - тип (checkbox, input, textarea, select)
 * $name - задаёт имя для элемента
 * $value - задает значение для элемента
 * $icon - иконка ('fa-user')
 * $title - заголовок
 * $placeholder - короткая подсказка, описывающая ожидаемое значение поля ввода или текстовой области
 * $limin - лимит знаков
 * $bell - доп. пояснение
 ' . input_text('checkbox', $name, $value, false, false, $placeholder) . '
 ' . input_text('input', $name, $value, $icon, $title, $placeholder, 100) . '
 ' . input_text('textarea', $name, $value, $icon, $title, $placeholder, 200, $bell) . '
 ' . input_text('select', $name, $value, false, $title) . '
 ' . input_text('fileupload', $name, $value, false, $title, $placeholder) . '
*/
function input_text($type, $name = false, $value = false, $icon = false, $title = false, $placeholder = false, $limin = 50, $bell = false): string
{
    global $core, $db, $lang;
    $title = !$title ? '' : $lang[$title];
    $placeholder = !$placeholder ? '' : $lang[$placeholder];
    $disabled = '';
    $content = '<div class="form-group mt15 mb15">';
    $content .= !$limin ? '' : '<label for="' . $name . '" class="col-lg-3 col-sm-3 control-label">' . $title . '</label>';
    $contents = $type == 'checkbox' ? '<div class="col-xs-6">' : '<div class="col-lg-7 col-md-7 col-sm-9">';
    $content .= $type == 'select' && $icon == '2' ? '<div class="col-xs-2">' : $contents;
    $content .= $type == 'select' ? '<label for="' . $name . '" class="field select ">' : '<label for="' . $name . '" class="field prepend-icon">';
    if ($type == 'input') {
        $content .= '<input value="' . $value . '" type="text"  name="' . $name . '" id="' . $name . '" dir="auto" onkeyup="count_down(this, \'' . $name . '\', ' . $limin . ')" maxlength="' . $limin . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $placeholder . '">';
    } elseif ($type == 'textarea') {
        $content .= '<textarea name="' . $name . '" id="' . $name . '" dir="auto" placeholder="' . $placeholder . '" onkeyup="count_down(this, \'' . $name . '\', ' . $limin . ')" maxlength="' . $limin . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto" data-parsley-required="true" data-parsley-trigger="change">' . $value . '</textarea>';
    } elseif ($type == 'checkbox') {
        $content .= scheckbox($name, '', $placeholder);
    } elseif ($type == 'select') {
        if ($name == 'exgroup') {
            $_groups = array();
            $query = $core->select_data('groups', false, 'admin DESC,moderator DESC,user DESC,guest DESC,banned DESC');
            while ($rows = $db->getRow($query)) {
                $_groups[$rows['special']][] = $rows;
            }
            $_groups[1] = $_groups[1] ?? false;
            $disabled = empty($_groups[1]) ? 'disabled' : '';
            $value = empty($_groups[1]) ? '<option value>' . $lang['users_edit_exgroup_empty'] . '</option>' : '<option value="0">' . $lang['no'] . '</option>';
        }
        if ($type === 'select' && !$name) {
            $value = explode('.', $value);
            $content .= '<div class="section row mbn">
                        <div class="col-xs-4">
						<label class="field select">
                            <select class="form-control" style="max-width:20.75rem;" required name="birthDay">' . Bday($value[0]) . '</select>
                            ' . faI('arrow double') . '
                        </label>
                             </div>
						<div class="col-xs-4">
						 <label class="field select">
                            <select class="form-control"  style="max-width:20.75rem;" required name="birthMonth">' . Bmonth($value[1]) . '</select>
                            ' . faI('arrow double') . '
                        </label>
                        </div>
						<div class="col-xs-4">
						<label class="field select">
                            <select class="form-control"  style="max-width:20.75rem;" required name="birthYear">' . Byear($value[2]) . '</select>
                            ' . faI('arrow double') . '
                        </label>
                        </div>
                         </div>';
        } else {
            $content .= '<select class="form-control" name="' . $name . '" id="' . $name . '" dir="auto" placeholder="' . $placeholder . '" ' . $disabled . '>' . $value . '</select>' . faI('arrow double');
        }
    } elseif ($type == 'fileupload') {
        $vname = $name == 'avatar' ? avatar($value) : pimage($value);
        $content .= '<div data-provides="fileupload" class="img-responsive ib mw400 fileupload fileupload-new admin-form">
								<div class="media media-list fileupload-preview thumbnail mb15">
								<img src="' . $vname . '" class="br4" alt="holder">
								</div>
								<span class="button btn-system btn-file btn-block ph5 btn-sm btn-raised legitRipple">
                                  <span class="fileupload-new">' . $title . '</span>
                                <span class="fileupload-exists">' . $placeholder . '</span>
                                <input type="file" name="' . $name . '"></span>
							</div>';
    }
    if ($bell) $content .= ' <span class="input-footer text-left">' . faI('fa-bell') . $lang[$bell] . '</span>';
    if ($icon) $content .= '<label for="' . $name . '" class="field-icon">' . faI($icon, false, false, true) . '</label>';
    $content .= !$limin ? '' : '</label>';
    if ($name <> 'phone') $content .= ' <div style="text-align:right;" class="text-right">
                            <span id="char_' . $name . '"></span>
                         </div>';
    $content .= '</div>
					</div>';
    return $content ?? '';
}

//настроки в модулях
function generateConfig($configBox, $type, $link, $ok = false): void
{
    global $adminTpl, $config, $lang;
    require(ROOT . 'etc/' . $type . '.config.php');
    $parseConf = $configBox[$type];
    $varName = $configBox[$type]['varName'];
    $confArr = $$varName;
    $adminTpl->admin_head($lang['config_module'] . ' | ' . $parseConf['title']);
    $adminTpl->footIncludes[''] = '<script src="' . PLUGINS . 'js/anchor.js"></script>
<script>
     $(document).ready(function() {
    // Click event for any anchor tag that\'s href starts with #
    $(\'a[href*=#].anchored\').click(function(event) {
        let id = $(this).attr("href");
        let offset = 100;
        let target = $(id).offset().top - offset;
        $(\'html, body\').animate({scrollTop:target}, 500);
        event.preventDefault();
    });
});
</script>';
    if ($ok) {
        $file = 'etc/' . $_POST['conf_file'] . '.config.php';
        $conf_arr_name = $_POST['conf_arr_name'];
        $content = "global $$conf_arr_name;\n";
        $content .= "\$$conf_arr_name = array();\n";
        foreach ($_POST as $k => $val) {
            if ($k != 'conf_arr_name' && $k != 'conf_file') {
                if (!is_array($val)) {
                    $content .= $k != 'illFormat' ? "\$" . $conf_arr_name . "['" . $k . "'] = \"" . htmlspecialchars(str_replace('"', '\"', stripslashes($val)), ENT_QUOTES) . "\";\n" : "\$" . $conf_arr_name . "['" . $k . "'] = \"" . str_replace('"', '\"', stripslashes($val)) . "\";\n";
                } else {
                    foreach ($val as $karr => $varr) {
                        $content .= "\$" . $conf_arr_name . "['" . $k . "']['" . $karr . "'] = \"" . htmlspecialchars(stripslashes($varr), ENT_QUOTES) . "\";\n";
                    }
                }
            }
        }
        save_conf($file, $content);
    }
    $adminTpl->open();
    echo '<section id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center" style="height: 763px;">';
    if ($ok) $adminTpl->alert('success', $lang['info'], $lang['success_save']);
    echo '<form id="admin-form" action="' . $link . '"" method="post" role="form" class="form-horizontal parsley-form" data-parsley-validate>';
    foreach ($parseConf['groups'] as $group) {
        echo '<div id="' . translit($group['title']) . '" class="panel panel-info panel-border top mb35">
            <div class="panel-heading">
               <span class="panel-title">' . $group['title'] . '</span>
            </div>
           <div class="heading-hr"></div>
				<div class="bg-white">';
        foreach ($group['vars'] as $var => $varArr) {
            echo '<table class="table table-xs table-striped">
						<tbody>			
        	                 <tr>
								<td class="col-xs-5 col-sm-5 col-md-6 pl20">
									<h6 class="media-heading text-semibold mb5">' . $varArr['title'] . ':</h6>
									<span class="text-muted text-size-small hidden-xs">' . $varArr['description'] . '</span>
								</td>
								<td class="col-xs-7 col-sm-7 col-md-6 pl20">
							<div class="mb-lg-0 w300 mnw430">
                     ' . (isset($confArr[$var]) ? str_replace(array('{varName}', '{var}'), array($var, Glang($confArr[$var]), $config['lang']), $varArr['content']) : $varArr['content']) . '
                            </div>
                                </td>
							</tr>
						</tbody>
					</table>';
        }
        echo '</div>
            <div class="panel-footer text-right">
               <button	type="submit" id="sub"	value="' . $lang['save'] . '" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
            </div>
         </div>';
    }
    echo '<input type="hidden" size="20" name="conf_file" class="textinput" value="' . $type . '" maxlength="100" maxsize="100">
         <input type="hidden" size="20" name="conf_arr_name" class="textinput" value="' . $varName . '" maxlength="100" maxsize="100">
      </form>
   </div>
         <aside data-tray-height="match" class="panel tray-right tray-rescale tray320" style="height: 568px;">
	<div style="padding-right: 1px !important; margin-bottom: 20px; border-width: 0;" class="form-group admin-form">
       <div id="nav-spy">
         <ul data-smoothscroll="-125" data-spy="affix" data-offset-top="200" class="nav tray-nav tray-nav-border affix-top pl15">
   <h4 class="pl20">' . $lang['cats'] . ' </h4>';
    foreach ($parseConf['groups'] as $group) {
        echo '<li class="nav-primary tray320">
               <a class="anchored" href="#' . translit($group['title']) . '"> ' . $group['title'] . '</a>
            </li>';
    }
    echo '<div class="heading-hr"></div>
         </ul>
      </div>
   </aside>
</section>';
    $adminTpl->close();
    $adminTpl->admin_foot();
}


function CheckGroups($grroups): string
{
    global $db, $core, $lang;
    $content = '<div class="panel-body admin-form">';
    $query = $core->select_data('groups', false, 'admin DESC,moderator DESC,user DESC,guest DESC,banned DESC');
    while ($rows = $db->getRow($query)) {
        $name = in_array('0', $grroups) ? $lang['news_add_accsess_all'] : _mName($rows['name']);
        $id = in_array($rows['id'], $grroups) ? $rows['id'] : (in_array('0', $grroups) ? 0 : "");
        $check = in_array($rows['id'], $grroups) ? "checked" : "";
        $content .= '<div class="col-xs-6">
      <label class="field option">
      <input id="checkbox' . $id . '" type="checkbox" name="groups[]"' . $check . ' value="' . $id . '">
      <span class="checkbox mr10"></span>' . $name . '</label><br>
      <div class="alt short mv15"></div>
   </div>';
    }
    $content .= '<br/>
</div>';
    return $content;
}

function hide_status()
{
    global $admin_conf, $lang;
    $langs = array($lang['panel_hide_not_status'], $lang['panel_sunmenu_always'], $lang['online'], $lang['offline']);
    $status = '';
    for ($i = 0; $i < 4; $i++) {
        if ($admin_conf['hide'] == $i) $status = $langs[$i];
    }
    return $status;
}

function smile_id($s_id, $s_title)
{
    global $smiles;
    if ($s_id && $s_title) {
        foreach ($smiles as $key => $value) {
            if ($s_id == $value['id']) return $value['id'];
            if ($s_title == $value['title']) $smiles[$key] = array('id' => $s_id, 'cat' => $value['cat'], 'title' => $value['title'], 'abridged' => $value['abridged'], 'url' => $value['url']);
        }
        unset($key);
        $content = "global\$smiles;\n";
        $content .= '$smiles = ' . arr2str($smiles) . ';';
        save_conf(ROOT . 'etc/smiles.config.php', $content);
    }
}

function sort_head($module, $choice, $type = 'date', $id = true, $dop_link = false): string
{
    global $lang;
    $module = $module == 'root' ? 'ADMIN' : ($module == 'moder' ? 'MODER' : ($module == 'urs' ? 'MOD' : ''));
    $dop_link = $dop_link ? $dop_link . '/' : '';
    $llang = $type == 'date' ? 'last' : $type;
    $id = $id ? 'id' : ($id == 'uid' ? 'uid' : '');
    $sort_head = '<div class="widget-menu pull-right section-divider">
               <select style="width: 200px; display: inline-block;" class="form-control bootstrap-select" onchange="top.location=this.value">
               <option value="{' . $module . '_LINK}/' . $dop_link . '"' . choice_selected($choice) . '>' . $lang['choose_sort'] . '</option>
               <option value="{' . $module . '_LINK}/' . $dop_link . 'order/abc"' . choice_selected($choice, 'abc') . '>' . $lang['sort_abc'] . '</option>';//$lang['sort_abc']
    if ($type) $sort_head .= '<option value="{' . $module . '_LINK}/' . $dop_link . 'order/' . $type . '"' . choice_selected($choice, $type) . '>' . $lang['sort_' . $llang] . ' </option>';
    if ($id) $sort_head .= '<option value="{' . $module . '_LINK}/' . $dop_link . 'order/' . $id . '"' . choice_selected($choice, $id) . '>' . $lang['sort_id'] . '</option>'; //$lang['sort_desc']
    $sort_head .= ' </select>
            </div>';
    return $sort_head;
}

function admin_subNav_icon($array, $url_mod, $sub = false, $module = false): string
{
    $module = $module ? 'module/' : '';
    if ($sub) {
        $subNav = '<p class="lead"><span class="' . $array[$url_mod]['icon'] . ' text-muted position-left">&nbsp;' . $array[$url_mod]['name'] . '</span></p><br/>';
    } else {
        $subNav = '<span class="navMainActive"><a href="' . ADMIN . '/' . $module . '">' . $array[$url_mod]['name'] . '</a></span>';
    }
    return $subNav;
}

function admin_subNav($array, $url1, $url2, $conf, $title = false, $module = false): string
{
    global $core, $lang;
    $module = $module ? 'module/' : '';
    $subNav = '';
    if (isset($array[$url1][$conf])) {
        $subNav .= $conf == 'subAct' ? '<ul id="navbar" class="mvn15 nav navbar-nav nav-list-topbar text-bold monserrat">' : '';
        $subNav .= $title ? '<li><a href="' . $core->fullURL() . '#">' . $lang[$title] . '</a><ul>' : '';
        foreach ($array[$url1][$conf] as $comAct => $comActLink) {
            $subNav .= '<li class="' . ((isset($url2) && $url2 == $comActLink or !isset($url2) && $comActLink == '') ? 'active' : '') . '"><a href="' . ADMIN . '/' . $module . $url1 . '/' . $comActLink . '">' . $comAct . '</a> </li>';
        }
        $subNav .= $conf == 'subAct' ? '' : '</ul>';
        $subNav .= '</li>';
    }
    return $subNav;
}

function modal_form_delete($id, $name, $title, $shift, $text, $location = false, $button = false, $action = false, $icon = false, $confirm = false): void
{
    global $lang;
    $actions = $action ? faSpan('fa-eraser', true, $lang['clear']) : faSpan('fa-trash-o', true, $lang['delete']);
    echo '<div id="modal-form-' . $id . '" class="popup-basic bg-none mfp-with-anim mfp-hide">
   <div class="panel">';
    $icon = $icon ?: 'fa-check-square-o';
    $confirm = $confirm ?: $lang['confirm'];
    mhColor($confirm, $icon);
    echo '<div class="panel-body">
         <h3 class="mt5">' . str_replace('[' . $shift . ']', $name, $title) . '</h3>
         <hr class="short alt">
         <p>' . str_replace('[' . $shift . ']', $name, $text) . '</p>
      </div>';
    if ($location) {
        echo '<div class="panel-footer text-right">
         <button type="button" onclick="location.href = \'' . $location . '\'" class="btn bg-danger btn-sm btn-raised legitRipple">' . $actions . '</button>
      </div>';
    } else {
        echo(($button) ? '<div class="panel-footer text-right">' . $button . '</div>' : '<div class="panel-footer-lines"></div>');
    }
    echo '</div>
</div>';
}

function modal_form_text($id, $confirm, $icon, $title, $text, $descr = false, $button = false, $help = false): void
{
    global $lang;
    echo '<div class="widget-menu pull-right">
   ' . (($help) ? '<div class="btn-group"><button onclick="modal_o(\'#modal-form-' . $id . '\')" type="button" class="btn btn-alert btn-sm btn-raised legitRipple">' . $lang['help'] . '</button></div>' : '') . '
   <div id="modal-form-' . $id . '" class="popup-basic bg-none mfp-with-anim mfp-hide">
      <div class="panel">';
    mhColor('' . $confirm, $icon);
    echo '<div class="admin-form">
            <div class="panel-body">
               ' . (($title) ? '<h3 class="mt5">' . $title . '</h3>' : '') . '
               ' . (($text) ? '<hr class="short alt"><p>' . $text . '</p>' : '') . '
               ' . (($descr) ? '<hr class="short alt"><p>' . $descr . '</p>' : '') . '
            </div>
         </div>
         ' . (($button && !$help) ? '<div class="panel-footer text-right">' . $button . '</div>' : '<div class="panel-footer-lines"></div>') . '
      </div>
   </div>
</div>';
}

function modal_form_add($id, $confirm, $icon, $for, $placeholder, $location): void
{
    global $lang;
    echo '<div id="modal-form-' . $id . '" class="popup-basic bg-none mfp-with-anim mfp-hide">
   <div class="panel">';
    mhColor($confirm, $icon);
    echo '<div class="admin-form">
         <div class="panel-body">
            <form id="comment" method="post" action="' . $location . '">
               <div class="form-group">
                  <label for="' . $for . '" class="field prepend-icon">
                  <input id="' . $for . '" type="text" name="' . $for . '" placeholder="' . $placeholder . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                  <label for="' . $for . '" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                  </label>
               </div>
         </div>
         <div class="panel-footer">
         <button type="submit" class="btn btn-system btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
         </div>
      </div>
      </form>
   </div>
</div>';
}

function ping_dir($dir, $port): int
{
    if (!$socket = @fsockopen($dir, $port, $errno, $errstr, 4)) {
        $active = 0;
    } else {
        $active = 1;
        fclose($socket);
    }
    return $active;
}

function host_ports($host, $numbers = '25', $smtp = 'smtp')
{
    global $lang;
    $ports = array();
    if ($host) {
        if ($smtp == 'smtp') {
            $ports[] = array('host' => $host, 'number' => $numbers);
            foreach ($ports as $port) {
                $connection = @fsockopen($port['host'], $port['number'], $errno, $errstr, 5);
                // 5 second timeout for each port.
                if (is_resource($connection)) {
                    return colorSpan('green', '<br/> Соединение с сервером SMTP установлено');
                    fclose($connection);
                } else {
                    return colorSpan('red', '<br/> Соединение с сервером SMTP  по порту - ' . $port['number'] . ' не установлено') . '<br/> Проверьте настройки подключения к серверу';
                }
            }
        }
    } else {
        return $lang['panel_addreee_server_is_missing'];
    }
}

function onmoder($mod, $status, $info = false): void
{
    global $adminTpl, $core, $lang;
    $moderation = $core->sum_data($mod, $status . ' = 2');
    if ($moderation > 0) {
        $adminTpl->alert('warning', $lang['warning'], $lang[$info]);
        sound_alert();
    }
}

function count_notif($new, $link, $image, $name)
{
    global $lang;
    if ($new <> 0) return notifications($new, notif_link($link, $image, $lang[$name] . '&ensp;(' . $new . ')'));
}

/*
* Обертывание кнопки
*/
function btn_class($type, $file = false, $style = false, $width = false): string
{
    $ph = $style == 2 ? 'ph10' : $style;
    $styles = $style == 1 ? 'style="display: inline-block; height: 38px;' . ($width ? 'width:' . $width . 'px"' : '') . '"' : '';
    $btn = isset($file) && $file == 'file' ? 'btn-file' : ($file == 'block' ? 'btn-block' : '');
    return 'class="popup-basic mfp-with-anim btn btn-' . $type . ' ' . $ph . ' ' . $btn . ' btn-sm btn-raised legitRipple" ' . $styles;
}

function action_alert($admin, $type, $module = false, $folder = false, $text = false, $str_text = false): void
{
    $mod = $admin == 'root' ? 'com' : 'mod';
    $folder = $folder ? '/' . $folder : '';
    $admin_link = $admin == 'root' ? $module . $folder : 'module/' . $module . $folder;
    $link = isset($_GET['moderate']) ? '/moderation/' . $mod . '/' . $module : '/' . $admin_link;
    if (isset($type)) {
        switch ($type) {
            case 'danger':
                $folders = 'base_error_1';
                break;
            case 'warning':
                $folders = 'warning';
                break;
            case 'success':
                $folders = 'base_info_0';
                break;
            case 'info':
                $folders = 'info';
                break;
            case 'system':
                $folders = 'system';
                break;
            case 'alert':
                $folders = 'alert';
                break;
            case 'primary':
                $folders = 'primary';
                break;
            case 'default':
                $folders = 'default';
                break;
            case 'dark':
                $folders = 'dark';
                break;
        }
    } else {
        $folders = '';
    }
    $folders = $text ?: $folders;
    $location = $text ?: $folders;
    $str_text = $str_text ? '/' . $str_text : '';
    location(ADMIN . $link . '/' . $type . '/' . $location . $str_text);
}

function alert_info($module = false): void
{
    global $adminTpl, $url, $lang;
    $exceAlert = array('danger', 'success', 'info', 'system', 'alert', 'primary', 'default', 'dark');
    $numb = (isset($url[0]) && in_array($url[0], $exceAlert) ? 0 : '') . (isset($url[1]) && in_array($url[1], $exceAlert) ? 1 : '') . (isset($url[2]) && in_array($url[2], $exceAlert) ? 2 : '') . (isset($url[3]) && in_array($url[3], $exceAlert) ? 3 : '') . (isset($url[4]) && in_array($url[4], $exceAlert) ? 4 : '') . (isset($url[5]) && in_array($url[5], $exceAlert) ? 5 : '') . (isset($url[6]) && in_array($url[6], $exceAlert) ? 6 : '') . (isset($url[7]) && in_array($url[7], $exceAlert) ? 7 : '') . (isset($url[8]) && in_array($url[8], $exceAlert) ? 8 : '') . (isset($url[9]) && in_array($url[9], $exceAlert) ? 9 : '') . (isset($url[10]) && in_array($url[10], $exceAlert) ? 10 : '');
    $text = (int)$numb + 1;
    $str_replace = isset($text) ? $text + 1 : false;
    $url_t = (!empty($url[$text]) ? $url[$text] : '');
    $url_replace = (!empty($url[$str_replace]) ? $url[$str_replace] : '');
    $text_info = !$url_replace ? ($module ? ($lang[$module . '_' . $url_t] ?? ($lang[$url_t] ?? '')) : ($lang[$url_t] ?? '')) : $url_t;
    if (isset($url[$numb])) {
        switch ($url[$numb]) {
            case 'danger':
                $adminTpl->alert('danger', $lang['error'], $text_info);
                break;
            case 'warning':
                $adminTpl->alert('warning ', $lang['error'], $text_info);
                break;
            case 'success':
                $adminTpl->alert('success', $lang['info'], $text_info);
                break;
            case 'info':
                $adminTpl->alert('info', $lang['info'], $text_info);
                break;
            case 'system':
                $adminTpl->alert('system', $lang['system'], $text_info);
                break;
            case 'alert':
                $adminTpl->alert('alert', $lang['info'], $text_info);
                break;
            case 'primary':
                $adminTpl->alert('primary', $lang['info'], $text_info);
                break;
            case 'default':
                $adminTpl->alert('default', $lang['info'], $text_info);
                break;
            case 'dark':
                $adminTpl->alert('dark', $lang['info'], $text_info);
                break;
        }
    }
}

function img_type($type = false, $text = false)
{
    if ($type = 'width') {
        preg_match('/<img.*width="(.*)".*>/is', $text, $matches);
    } elseif ($type = 'height') {
        preg_match('/<img.*height="(.*)".*>/is', $text, $matches);
    } elseif (!$matches) {
        preg_match_all('/(<img)\s (src="([a-zA-Z0-9\.;:\/\?&=_|\r|\n]+)")/ixmU', $text, $matches);
    } else {
        return;
    }
    return $matches[1] ?? '';
}

/*
* Вывод навигации страниц
* $admin - папка с размещением админки модуля (root либо urs)
* $module - название модуль, усли нужно вевести на главной странице админки подставить $admin_conf['num']
* $dbaze - название таблицы базы данных
* $where - то что запишем в кэш
* $order - Какой порядковый номер order относительно /administration(0)/module(1)/news(2)/order(3)/, если вместо order в адресной строке /administration/module/news/(order)tags/ то выводиться будет tags
*/
function page_list($admin, $module, $dbaze, $where = false, $order = false, $numbs = false): void
{
    global $adminTpl, $admin_conf, $core;
    $admin_link = $admin == 'root' ? ADMIN . '/' : ($admin == 'rmoder' ? ADMIN . '/moderation/com/' : ($admin == 'umoder' ? ADMIN . '/moderation/mod/' : ADMIN . '/module/'));
    $num = $module == $admin_conf['num'] ? 1 : $admin_conf['num'];
    $num = $numbs ?: $num;
    $module_link = $module ? $module . '/' : '';
    $mod_link = $module == $admin_conf['num'] ? '' : $module_link;
    $page = init_page();
    echo '<div class="widget-menu pull-left mr5">';
    $all = $core->sum_data($dbaze, $where);
    $adminTpl->pages($page, $num, $all, $admin_link . $mod_link . order_link($order) . '{page}');
    echo '</div>';
}

function order_link($order): string
{
    global $url;
    $exceOrder = array('order');
    $numb = (isset($url[0]) && in_array($url[0], $exceOrder) ? 0 : '') . (isset($url[1]) && in_array($url[1], $exceOrder) ? 1 : '') . (isset($url[2]) && in_array($url[2], $exceOrder) ? 2 : '') . (isset($url[3]) && in_array($url[3], $exceOrder) ? 3 : '') . (isset($url[4]) && in_array($url[4], $exceOrder) ? 4 : '') . (isset($url[5]) && in_array($url[5], $exceOrder) ? 5 : '') . (isset($url[6]) && in_array($url[6], $exceOrder) ? 6 : '') . (isset($url[7]) && in_array($url[7], $exceOrder) ? 7 : '') . (isset($url[8]) && in_array($url[8], $exceOrder) ? 8 : '') . (isset($url[9]) && in_array($url[9], $exceOrder) ? 9 : '') . (isset($url[10]) && in_array($url[10], $exceOrder) ? 10 : '');
    $urls = (int)$numb + 1;
    return $order ? $order . '/' : (isset($url[$numb]) && $url[$numb] == 'order' ? $url[$numb] . '/' . $url[$urls] . '/' : '');
}

function list_empty($admin, $module, $order, $s_search, $mod = false, $help = false, $refresh = false, $links = false): void
{
    global $adminTpl, $lang;
    $text = $module == 'content' ? 'static' : $module;
    $link = $admin == 'root' ? $module : 'module/' . $module . '/';
    $info = $mod ? '_onmoder' : '';
    $link = $mod ? '/moderation/' . $mod . '/' . $module . '/' : $link;
    $link = str_replace(array('_'), array('/'), $link);
    $order_empty = $lang[$text . $info . '_order_empty'] ?? $lang[$text . $info . '_empty'];
    $empty = $lang[$text . $info . '_empty'] ?? $lang['phrase_not_found'] . $lang[$text . $info . '_empty'];
    $tlist = $lang[$text . '_list'] ?? $lang['phrase_not_found'] . $lang[$text . '_list'];
    $tadd = $module == 'support' ? ($lang[$text . '_exp'] ?? $lang['phrase_not_found'] . $lang[$text . '_exp']) : ($lang[$text . '_add'] ?? ($help && $order == 'moder' ? '' : $lang['phrase_not_found'] . $lang[$text . '_add']));
    $thelp = $lang[$module . '_help'] ?? $lang['phrase_not_found'] . $lang[$module . '_help'];
    $thelp_desc = $lang[$module . '_help_desc'] ?? $lang['phrase_not_found'] . $lang[$module . '_help_desc'];
    $url_link = $links ? ADMIN . '/' . $link : ($module == 'guestbook' ? '' : ADMIN . '/' . $link . '/add');
    if (order_link($order) && $order == 'url' || $s_search == 1 && $order == 'url') {
        if ($help) {
            $adminTpl->info($empty, 'empty', null, $tlist, $tadd, $url_link, 'url', $thelp, null, null, $thelp_desc, true);
        } else {
            $adminTpl->info($order_empty, 'empty', null, $tlist, $tadd, $url_link);
        }
    } elseif ($help && $order == 'empty') {
        $adminTpl->info($empty, 'empty', null, $tlist, $tlist, $url_link, 'url', $thelp, null, null, $thelp_desc, true);
    } elseif ($help && $order == 'moder') {
        $adminTpl->info($empty, 'empty', null, $tlist, null, null, 'url', $thelp, null, null, $thelp_desc, true);
    } elseif ($order == 'empty') {
        $adminTpl->info($empty, 'empty', null, $tlist, $tlist, $link);
    } else {
        if ($help && $order == 'url') {
            $adminTpl->info($empty, 'empty', null, $tlist, $tadd, $url_link, 'url', $thelp, null, null, $thelp_desc, true);
        } elseif ($order == 'modal') {
            $adminTpl->info($empty, 'empty', null, $tlist, $tadd, 'add', 'modal', $thelp, null, null, $thelp_desc, true);
        } else {
            $adminTpl->info($empty, 'empty', null, $tlist, $tadd, $url_link);
        }
    }
    if ($refresh) header('refresh: 5; url="/' . ADMIN . '/' . $link . '"');
}

function method_letter($admin, $dbaze, $module, $method): void
{
    global $adminTpl, $url, $core, $lang;
    init_count_text();
    $head_title = ($method == 'mail') ? 'mails' : 'pms';
    $id = isset($url[5]) ? intval($url[5]) : '';
    $order_id = is_numeric($id) ? $id : (isset($url[4]) ? intval($url[4]) : '');
    $admin_link = $admin == 'root' ? ADMIN . '/' : ADMIN . '/module/';
    $rows = $core->row_data($dbaze, 'id ="' . $order_id . '"');
    $nick = $rows['nick'] ?? ($rows['name'] ?? ($rows['owner'] ?? ''));
    $title = $rows['title'] ?? '';
    $mail = $rows['email'] ?? '';
    $messages = $rows['message'] ?? ($rows['comment'] ?? '');
    $messages = decoder('d', $messages);
    $adminTpl->admin_head($lang[$head_title]);
    echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $head_title . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body admin-form">
            <form class="form-horizontal parsley-form" role="form" action="' . $admin_link . $module . '/send_letter/' . $method . '" method="post" data-parsley-validate>
               <div class="form-group">
                  <label for="nick" class="col-sm-3 control-label">' . $lang['user'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="nick" class="field prepend-icon">
                     <input value="' . $nick . '" type="text" name="nick" id="nick" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['users_edit_name_pre'] . '">
                     <label for="nick" class="field-icon">' . faI('fa-user', false, false, true) . '</label>
                     </label>
                  </div>
               </div>';
    if ($method == 'mail') {
        echo '<div class="form-group">
                  <label for="mail"	class="col-sm-3 control-label">' . $lang['emails'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="mail" class="field prepend-icon">
                     <input value="' . $mail . '" type="text" name="mail" id="mail" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['input_email_mail'] . '">
                     <label for="mail" class="field-icon">' . faI('fa-envelope-o', false, false, true) . '</label>
                     </label>
                  </div>
               </div>';
    }
    echo '<div class="form-group">
                  <label for="title"	class="col-sm-3 control-label">' . $lang['title_mail'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="title" class="field prepend-icon">
                     <input value="' . $title . '" type="text" name="title" id="title" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['input_title_mail'] . '">
                     <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                     </label>
                  </div>
                 <div class="col-xs-12">
             <div class="tab-block mb25">
             <div class="form-group admin-form">
                     <div class="tab-content_editor">
                  <p class="short alt text-left"></br>&emsp;
                  <pre><code>' . $messages . '</code></pre>
                  </p>
                  <hr class="short alt">
                     </div>
                 </div>
              </div>
           </div>';
    initDir('messages', date('d-m-y', time()), $order_id);
    echo '<div class="col-xs-12">
             <div class="tab-block mb25">
             <div class="form-group admin-form">
                     <div class="tab-content_editor">
                        <div id="message" class="tab-pane active">
                           ' . adminArea('message', ($_POST['message'] ?? ''), 10, 'textarea', 'onchange="caa(this);"', true) . '
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
          </div>
         <div class="panel-footer">
         <input type="hidden" name="id" value="' . $order_id . '">
         <button name="submit" type="submit" id="sub" value="' . $lang['sendingmess'] . '" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-share-square-o', true, $lang['sendingmess']) . '</button>
         <button type="button" onclick="history.go(-1)" class="btn bg-info btn-sm btn-raised legitRipple">' . faSpan('fa-undo', true, $lang['go_back']) . '</button>
         </div>
      </div>
      </form>
   </div>
</div>';
    $adminTpl->admin_foot();
}

function mail_send($admin, $module, $module_mail, $nick, $mail, $title, $messages, $html_mail, $mail_text = false, $ip = false, $nickf = false, $category = false, $link = false, $lostlink = false, $unsubscribe = false): void
{
    global $db, $config, $core, $lang;
    $ip = $ip ?? '';
    $nickf = $nickf ?? '';
    $category = $category ?? '';
    $link = $link ?? '';
    $lostlink = $lostlink ?? '';
    $unsubscribe = $unsubscribe ?? '';
    $s_group = $core->auth->user_info['group'] ?? '';
    $rows = $core->row_data('groups', 'id ="' . $s_group . '"');
    $groups = $rows['name'] ?? $lang['user_no_register'];
    if ($module_mail == 1) {
        if ($html_mail <> 2) {
            $query = $core->select_data('email', false, 'id ASC');
            while ($result = $db->getRow($query)) {
                $mod_mail_text = !$ip ? str_replace(array('IP адрес отправителя:'), array(''), $result[$mail_text]) : $result[$mail_text];
                $message = $result[$html_mail] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%title%}', '{%category%}', '{%username_to%}', '{%username_from%}', '{%link%}', '{%lostlink%}', '{%ip%}', '{%unsubscribe%}', '{%date%}', '{%group%}', '{%email%}', '{%text%}', '{%sitename%}', '{%url%}'), array('<', '>', $nick, $title, $category, $nick, $nickf, $link, $lostlink, $ip, $unsubscribe, formatDate(time(), true), $groups, $mail, $messages, $config['name'], $config['url']), $mod_mail_text) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%title%}', '{%category%}', '{%username_to%}', '{%username_from%}', '{%link%}', '{%lostlink%}', '{%ip%}', '{%unsubscribe%}', '{%date%}', '{%group%}', '{%email%}', '{%text%}', '{%sitename%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $nick, $title, $category, $nick, $nickf, $link, $lostlink, $ip, $unsubscribe, formatDate(time(), true), $groups, $mail, $messages, $config['name'], $config['url']), $mod_mail_text);
                if (!empty($mail)) mailSMTP($mail, $result[$mail_text], $title, $message);
            }
        } elseif ($html_mail == 2) {
            if (!empty($mail)) mailSMTP($mail, $messages, $title, $messages);
        } else {
            action_alert($admin, 'danger', $module, false, 'send_mail_off');
        }
    } else {
        action_alert($admin, 'danger', $module, false, 'send_mail_off');
    }
}

function method_send($admin, $dbaze, $method, $module, $module_mail, $html_mail, $mail_text, $ip = false, $nickf = false, $category = false, $link = false, $lostlink = false, $unsubscribe = false): void
{
    global $adminTpl, $db, $core, $lang;
    $head_title = ($method == 'mail') ? 'mails' : 'pms';
    $adminTpl->admin_head($lang[$head_title]);
    $id = isset($_POST['id']) ? filter($_POST['id'], '') : '';
    $nick = isset($_POST['nick']) ? filter($_POST['nick'], 'nick') : '';
    $title = isset($_POST['title']) ? filter($_POST['title'], 'title') : '';
    $mail = isset($_POST['mail']) ? filter($_POST['mail'], 'mail') : '';
    $messages = isset($_POST['message']) ? filter($_POST['message'], 'html') : '';
    $rows = $core->row_data($dbaze, 'id ="' . $id . '"');
    if (isset($_POST['title']) && !empty($_POST['message'])) {
        if (!empty($mail) && $method == 'mail') {
            mail_send($admin, $module, $module_mail, $nick, $mail, $title, $messages, $html_mail, $mail_text, $ip, $nickf, $category, $link, $lostlink, $unsubscribe);
            action_alert($admin, 'success', $module, false, 'sendok');
        }
        if ($method == 'pm') {
            $result = $core->row_data('users', 'nick ="' . $db->safesql($nick) . '"');
            $core->ins_data('pm', 'id,toid,fromid,topic,message,time,users_delete,users_del_data,status', 'NULL,"' . $result['id'] . '","' . $core->auth->user_id . '","' . $title . '","' . $messages . '","' . time() . '", 0, 0, 0');
            action_alert($admin, 'success', $module, false, 'sendok');
        }
        if ($module == 'feedback' || $module == 'complaint') $core->upd_data($dbaze, 'status = 3', 'id ="' . $rows['id'] . '"');
    } else {
        if ($module == 'feedback' || $module == 'complaint') $core->upd_data($dbaze, 'status = 2', 'id ="' . $rows['id'] . '"');
        action_alert($admin, 'danger', $module, false, 'sendfalse');
    }
    $adminTpl->admin_foot();
}

function poolHighCharts($id, $urltitle, $value, $name, $numb): void
{
    global $adminTpl;
    $adminTpl->footIncludes[] = '<script type="text/javascript">
   const chartHighCharts = function ()
   {
   const highColors = [bgWarning, bgPrimary, bgInfo, bgAlert, bgDanger, bgSuccess, bgSystem, bgDark];
   const sparkColors = {
          "primary": [bgPrimary, bgPrimaryLr, bgPrimaryDr],
   		"info": [bgInfo, bgInfoLr, bgInfoDr],
   		"warning": [bgWarning, bgWarningLr, bgWarningDr],
   		"success": [bgSuccess, bgSuccessLr, bgSuccessDr],
   		"alert": [bgAlert, bgAlertLr, bgAlertDr]
   	};
   	const chartHighCharts = function()
   {
   const chartHighBars = function()
   {
   const bars1 = $("#' . $id . '");
   if (bars1.length)
   {
   $("#result").highcharts({
   					colors: highColors,
   					credits: false,
   					legend: {
   enabled: false,
   						y: -5,
   						verticalAlign:"top",
   						useHTML: true
   					},
   					chart: {
   spacingLeft: 30,
   						type:"bar",
   						marginBottom: 0,
   						marginTop: 0
   					},
   					title: {
   text: null
   					},
   					xAxis: {
   showEmpty: false,
   						tickLength: 80,
   						lineColor:"#fff",
   						tickColor:"#eee",
   						offset: 1,
   						categories: [' . $urltitle . '],
   						title: {
       text: null
   						},
   						labels: {
       align:"right",
   						}
   					},
   					yAxis: {
   min: 0,
   						gridLineWidth: 0,
   						showEmpty: false,
   						title: {
       text: null
   						},
   						labels: {
       enabled: false,
   						}
   					},
   					tooltip: {
   valueSuffix:"' . $value . '"
   					},
   					plotOptions: {
   bar: {},
   column: {
       colorByPoint: true,
   								}
   },
   					series: [{
   id: 0,
   						name:"' . $name . '",
   						data: [' . $numb . ']
   						}]
   				});
   			}
   };	chartHighBars();
   }
   	return {
   init: function () {
   chartHighCharts();
   }
   }
   }();
</script>';
    $adminTpl->js_code[] = 'chartHighCharts.init(); ';
}

function UserCardInfo($uid, $edit = false, $footer = false): void
{
    global $smiles, $config, $core, $user, $lang;
    $url_flags = '';
    $CardInfo = '';
    $user_row = $core->row_data('users', 'u.id ="' . $uid . '" AND u.active=1 OR  u.active=0', false, 'u.*, g.name as gname, g.user as isUser, g.moderator as isModer, g.admin as isAdmin, g.showAttach, g.showHide, g.loadAttach, g.addPost, g.addComment, g.allowRating, g.maxWidth, g.maxPms, g.control, g.color, g.icon', 'as u LEFT JOIN ' . DB_PREFIX . '_groups as g ON(u.group = g.id)');
    $geoip = geo_ip::getInstance(ROOT . 'media/geo_ip.dat');
    $flag = $geoip->lookupCountryCode(!empty($user_row['ip']) ? $user_row['ip'] : '127.0.0.1');
    $rows = $core->row_data('users', 'id ="' . $user_row['id'] . '"');
    $icon = $core->row_data('groups', 'name ="' . $user_row['name'] . '"');
    foreach ($smiles as $param) {
        if ($param['cat'] == 'flags') {
            $saurl = str_replace($config['url'] . '/', '', $param['url']);
            $surl = $param['url'] > 30 ? $param['url'] : internoetics_mb_strimwidthd($saurl, 0, 36);
            $abridged = isset($param['abridged']) ? ' ( ' . $param['abridged'] . ' )' : '';
            if ($flag == $param['abridged'])
                $url_flags = '<img src="' . $param['url'] . '" title="' . $param['title'] . $abridged . '" class="img-responsive mw30 ib br4" border="0" alt=""/>';
        } else {
            $url_flags = '';
        }
    }
    $uflag = ($flag != 'UN') ? $url_flags : '<img src="media/smiles/flags/UN.png" border="0" class="img-responsive mw30 ib br4"  title="' . $lang['undefined'] . '" alt="">';
    $banned = ($user_row['group'] == 5 ? $lang['users_unlock'] : $lang['users_ban']);
    $sname = !$rows['surname'] && !$rows['name'] && !$rows['ochestvo'] ? $lang['unspecif'] : ($rows['surname'] ?: '') . ' ' . ($rows['name'] ?: '') . ' ' . ($rows['ochestvo'] ?: '');
    $fullname = ($rows['surname'] ?: '') . ' ' . ($rows['name'] ?: '') . ' ' . ($rows['ochestvo'] ?: '');
    $CardInfo .= '<div class="tab-content" style="padding-right: 1px !important;  margin-bottom: 20px; border-width: 0;">
<div class="tab-pane fade active in">
   <table class="table table-th-block">
      <tr>
         <td class="col-md-3 text-left pl20 pt10">
            <div class="profile-icon">
               <div class="profile-icon-image">
                  <img src="' . avatar($user_row['id']) . '" style="border:0;" alt=""/>
                  ' . ($core->isOnline($user_row['id']) ? '<div class="round-online" title="' . $lang['online'] . '"></div>' : '<div class="round-offline" title="' . $lang['offline'] . '"></div>') . '
               </div>
               <div class="profile-icon-title">
                  ' . faSpan(false, true, false, false, $fullname) . '
                   ' . $user_row['nick'] . '
               </div>
               <div class="profile-icon-title2">
               ' . colorSpan($user_row['color'], Glang($user_row['gname'])) . '
               </div>
            </div>
         </td>
         <td class="col-md-3 text-left pl20 pt10">
            <div class="text-mischka text-uppercase text-bold monserrat fs12 d-sm-flex flex-direction-column mla min-w145">
               <div class="btn-group btn-group-xs mt15 d-sm-flex">
                  <a href="/profile/' . $user_row['id'] . '" class="popup-basic mfp-with-anim btn btn-system btn-sm btn-raised legitRipple" title="' . $lang['view'] . '">' . faSpan('fa-desktop', true) . '</a>
                  ' . (($edit) ? '<a href="' . ADMIN . '/user/edit/' . $user_row['id'] . '" class="popup-basic mfp-with-anim btn btn-info btn-sm btn-raised legitRipple" title="' . $lang['edit_short'] . '">' . faSpan('fa-external-link', true) . '</a>' : '') . '
                  <a href="' . ADMIN . '/user/letter/mail/' . $user_row['id'] . '" class="popup-basic mfp-with-anim btn btn-yellow btn-sm btn-raised legitRipple" title="' . $lang['mail_write'] . '">' . faSpan('fa-envelope-o', true) . '</a>
                  <a href="' . ADMIN . '/user/letter/pm/' . $user_row['id'] . '" class="popup-basic mfp-with-anim btn btn-alert btn-sm btn-raised legitRipple" title="' . $lang['pm_write'] . '">' . faSpan('fa-user', true) . '</a>
                  <a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $user_row['id'] . '\')" class="popup-basic mfp-with-anim btn btn-danger btn-sm btn-raised legitRipple" title="' . $lang['delete'] . '">' . faSpan('fa-trash', true) . '</a>
               </div>
            </div>';
    modal_form_delete($user_row['id'], $user_row['nick'], $lang['users_del_title'], 'user', $lang['users_del_text'], '{ADMIN}/user/delete/' . $user_row['id']);
    $CardInfo .= '</div>
<br/>
<a href="{ADMIN}/module/news/user_news/' . $user_row['nick'] . '" class="popup-basic mfp-with-anim btn btn-info btn-sm btn-raised legitRipple">' . $lang['news_num'] . ': ' . ($user_row['user_news'] ?: 0) . '</a>
' . (($edit) ? '' : '<br/>') . '
<a href="{ADMIN}/comments/user_comments/' . $user_row['id'] . '" class="popup-basic mfp-with-anim btn btn-info btn-sm btn-raised legitRipple">' . $lang['comments_num'] . ': ' . ($user_row['user_comments'] ?: 0) . '</a>
         </td>
      </tr>
      <tr>
         <td class="col-md-3 text-left pl20 pt10">' . $lang['full_name'] . '</td>
         <td class="col-md-3 text-left pl20 pt10">' . $sname . '</td>
      </tr>
      <tr>
         <td class="col-md-3 text-left pl20">' . $lang['registered'] . '</td>
         <td class="col-md-3 text-left pl20">' . formatDate($user_row['regdate'], true) . '</td>
      </tr>';
    if (!$core->isOnline($user_row['id'])) {
        $CardInfo .= '<tr>
         <td class="col-md-3 text-left pl20">' . $lang['last_activity'] . '</td>
         <td class="col-md-3 text-left pl20">' . ($core->isOnline($user_row['id']) ? '<span class="bull bg-' . ($core->isOnline($user_row['id']) ? 'success' : 'default') . '"></span>' . $lang['online'] : formatDate($user_row['last_visit'], true)) . '</td>
      </tr>';
    }
    $CardInfo .= '<tr>
         <td class="col-md-3 text-left pl20">' . $lang['country'] . '</td>
         <td class="col-md-3 text-left pl20">' . $uflag . '</td>
      </tr>
      <tr>
         <td class="col-md-3 text-left pl20">' . $lang['city'] . '</td>
         <td class="col-md-3 text-left pl20">' . ($user_row['place'] ?: $lang['unspecified']) . '</td>
      </tr>
      <tr>
         <td class="col-md-3 text-left pl20">' . $lang['genders'] . '</td>
         <td class="col-md-3 text-left pl20">' . Gender_stat($user_row['sex']) . '</td>
      </tr>
      <tr>
         <td class="col-md-3 text-left pl20">' . $lang['full_years'] . '</td>
         <td class="col-md-3 text-left pl20">' . ($user_row['age'] ?: $lang['unspecif']) . '</td>
      </tr>
      <tr>
         <td class="col-md-3 text-left pl20">' . $lang['rating_s_users'] . '</td>
         <td class="col-md-3 text-left pl20">
 <div class="rating-result">';
    $numbs = numb_star($user_row['carma']);
    $prlim = intval($user_row['carma'] / limit_status() * 100);
    $prlim = ($prlim > 100) ? 100 : $prlim;
    limit_star($user_row['carma'], $numbs);
    $CardInfo .= '<div class="rating-result_numb"><span class="ractive">' . $numbs . '/' . $user['limitStar'] . ' (' . $prlim . '%)</span></div>
         </td>
      </tr>
</table>
 </div>';
    if ($footer) $CardInfo .= '<div class="n-panel-footer-lines"></div>';
    $CardInfo .= '</div>';
    echo $CardInfo;
}

function limit_status()
{
    global $user;
    $limit = array(null, $user['limitStar_1'], $user['limitStar_2'], $user['limitStar_3'], $user['limitStar_4'], $user['limitStar_5'], $user['limitStar_6'], $user['limitStar_7'], $user['limitStar_8'], $user['limitStar_9'], $user['limitStar_10']);
    $maxlimit = '';
    for ($i = 0; $i < 11; $i++) {
        if ($user['limitStar'] == $i) $maxlimit = $limit[$i];
    }
    return $maxlimit;
}

function limit_star($user_row, $numbs): void
{
    global $user;
    $fsize = 33 - $user['limitStar'] - ($user['limitStar'] > 6 ? $numbs : false);
    $style = 'style ="font-size: ' . $fsize . 'px;"';
    $limit = array(null, $user['limitStar_1'], $user['limitStar_2'], $user['limitStar_3'], $user['limitStar_4'], $user['limitStar_5'], $user['limitStar_6'], $user['limitStar_7'], $user['limitStar_8'], $user['limitStar_9'], $user['limitStar_10']);
    for ($i = 1; $i < 11; $i++) {
        if ($user['limitStar'] >= $i) {
            echo '<span ' . $style . ' class="' . (($user_row >= $limit[$i]) ? 'active' : 'ractive') . '"></span>';
        }
    }
}

function numb_star($user_row)
{
    global $user;
    $limit = array(null, $user['limitStar_1'], $user['limitStar_2'], $user['limitStar_3'], $user['limitStar_4'], $user['limitStar_5'], $user['limitStar_6'], $user['limitStar_7'], $user['limitStar_8'], $user['limitStar_9'], $user['limitStar_10']);
    for ($i = 0; $i < 11; $i++) {
        if ($user_row <= $limit[$i]) {
            $limitStar = round(($user_row / $i * 100) / (($user['limitStar'] == $i) ? limit_status() : $limit[$i]));
            $numbs = $user_row == ($user_row <= $limit[$i]) ? ($limitStar > $user['limitStar']) ? $user['limitStar'] : $limitStar : 0;
        } else {
            $numbs = '0';
        }
    }
    return $numbs;
}

function jmycmsck($php, $link = false, $sub = false): bool|array|string
{
    global $config, $lang;
    $version = VERSION_ID;
    $subs = $sub ?: '';
    $status = ping_dir(getHost($lang['jmycms']), $lang['p80']);
    $request_host = 'dir=' . $_SERVER['HTTP_HOST'] . '&lang=' . $config['lang'] . '&key=' . $config['key'] . '&version=' . $version . $subs;
    $rezult = $status ? file_get_contents_utf8($lang['jmycmsck'] . $php . '.php?' . $request_host) : '';
    return $link ? '<a href="' . $lang['jmycmsck'] . $php . '.php?' . $request_host . '>' . $lang['download_last_source'] . '</a>' : $rezult;
}

function time_dat(): void
{
    $version = VERSION_ID;
    $nextversion = jmycmsck('nextversion');
    $file_dat = ROOT . 'tmp/update/time.dat';
    $file_loc = ROOT . 'tmp/update/lock.update';
    if (file_exists($file_dat)) {
        $file_array = file($file_dat);
        if ($version <> $nextversion) unlink($file_dat);
        if (date('Y - m - d', time()) <> is_array($file_array[0])) {
            $file = fopen($file_dat, 'w + ');
            fwrite($file, date('Y - m - d', time()));
            fclose($file);
            if ($version <> $nextversion) fopen($file_loc, 'w');
        }
    } else {
        fopen($file_dat, 'w');
    }
    if (file_exists($file_loc) && ($version == $nextversion)) unlink($file_loc);
}

function notifications($numb, $link)
{
    return $numb <> 0 ? $link : '';
}

function Glang($text)
{
    global $core, $config;
    $text = stripslashes($core->bbDecode(parseBB($text)));
    return ($config['lang'] == 'ru') ? $text : Gtranslate($text, ($config['lang'] == 'ru' ? 'en' : 'ru'), $config['lang']);

}

function notif_link($link, $image, $text, $dop = false): string
{
    $image = $dop ?: '<img src ="usr/tpl/admin/assets/images/notifications/' . $image . '" class="avatar avatar-sm img-circle" alt ="" > ';
    return '<li style ="cursor:pointer" onclick ="location.href=\'/' . $link . '\';" class="list-group-item" >
   <span class="pull-left mg-t-xs mg-r-md" > ' . $image . '</span >
   <div class="m-body show pd-t-xs position-left"><span > ' . $text . '</span ><br/><br/></div >
</li>';
}

function choice_selected($choice, $selected = false): string
{
    global $url;
    return ((isset($url[$choice]) ? $url[$choice] == $selected : "") ? "selected" : "");
}

function init_pdo(): PDO
{
    $dbname = array();
    $dbhost = array();
    $dbuser = array();
    $dbpass = array();
    require ROOT . 'etc/db.config.php';
    return new PDO('mysql:dbname=' . $dbname . ';host=' . $dbhost, $dbuser, $dbpass);
}

function init_refresh($ref_on, $ref_stat, $start = false): void
{
    $time = ($ref_stat * 1000);
    if ($start) {
        $refresh = InitRefresh($time);
    } elseif ($ref_on) {
        $refresh = InitRefresh($time);
    } else {
        return;
    }
    echo $refresh;
}

function dop_bg(): string
{
    global $admin_conf;
    $color = $admin_conf['colorPanel'] == "" ? '#337AB7' : $admin_conf['colorPanel'];
    return '<style>
        .bg-colorPanel {
            background-color: ' . $color . ' !important;
            color: #93fedc;
        }
        a.bg-colorPanel:hover {
            background-color: #019163 !important;
        }
        .bg-colorPanel .text-muted {
            color: #5fffcc;
        }
        .bg-colorPanel .text-darken {
            color: #019163;
        }
        .bg-colorPanel.light {
            background-color: #02e19a !important;
        }
        .bg-colorPanel.lighter {
            background-color: #03f5a7 !important;
        }
        .bg-colorPanel.dark {
            background-color: ' . $color . '  !important;
        }
        .bg-colorPanel.darker {
            background-color: #019163 !important;
        }
        .bg-colorPanel .open > a,
        .bg-colorPanel .open > a:hover,
        .bg-colorPanel .open > a:focus {
            color: #fff;
        }
        .bg-colorPanel {
            margin: 0;
            background-color: #f3f3f3;
            float: left;
            font-size: .9rem;
            line-height: 1.25rem;
        }
        .bg-colorPanel .nav > li.open > a,
        .bg-colorPanel .nav > li:hover > a,
        .bg-colorPanel .nav > li:focus > a,
        .bg-colorPanel .nav > li.active > a,
        .bg-colorPanel .nav > li > a:hover,
        .bg-colorPanel .nav > li > a:focus {
            color: #FFF;
            background-color: {color};
        }
        .bg-colorPanel .nav > li.dropdown.open .dropdown-menu,
        .bg-colorPanel .nav > li.dropdown .open .dropdown-menu {
            border-top-color: #f3f3f3;
        }
        .bg-colorPanel .nav > li.dropdown.open .dropdown-menu:after,
        .bg-colorPanel .nav > li.dropdown .open .dropdown-menu:after {
            border-bottom-color: #f3f3f3;
        }
        .bg-colorPanel .nav > li.dropdown.open .dropdown-menu:after,
        .bg-colorPanel .nav > li.dropdown .open .dropdown-menu:after {
            border-bottom-color: #f3f3f3;
        }
        .bg-colorPanel .nav > li .dropdown-toggle + .dropdown-menu > .active > a,
        .bg-colorPanel .nav > li .dropdown-toggle + .dropdown-menu > .active > a:hover,
        .bg-colorPanel .nav > li .dropdown-toggle + .dropdown-menu > .active > a:focus {
            color: #FFF;
            background-color: #f3f3f3;
        }
        .btn-toolbar > .btn-group.note-fontname {
            display: none;
        }
    </style>';
}

/*
* Перезагружаем страницу по времени
* $time - если $time = 0, то цикличная перезагрузка
*/
function InitRefresh($time): void
{
    if (isset($time)) {
        echo '<head>
   <script>
      <!--
      function timedRefresh(timeoutPeriod) {
      	setTimeout("location.reload(true);",timeoutPeriod);
      }
      window.onload = timedRefresh(' . $time . ');
      //	-->
   </script>
</head>';
    }
}

function generateConfigBLOCK($configBox, $type, $link, $ok = false): void
{
    global $adminTpl, $config, $lang;
    require(ROOT . 'etc/blocks/' . $type . '.config.php');
    $parseConf = $configBox[$type];
    $varName = $configBox[$type]['varName'];
    $confArr = $$varName;
    $adminTpl->admin_head($lang['configuration_blocks'] . ' | ' . $parseConf['title']);
    $adminTpl->footIncludes[''] = '<script src="' . PLUGINS . 'js/anchor.js"></script>
<script>
     $(document).ready(function() {
    // Click event for any anchor tag that\'s href starts with #
    $(\'a[href*=#].anchored\').click(function(event) {
        var id = $(this).attr("href");
        var offset = 100;
        var target = $(id).offset().top - offset;
        $(\'html, body\').animate({scrollTop:target}, 500);
        event.preventDefault();
    });
});
</script>';
    if ($ok) {
        action_alert('root', 'success', 'blocks', 'standard');
        $file = 'etc/blocks/' . $type . '.config.php';
        $conf_arr_name = $_POST['conf_arr_name'];
        $content = "global $$conf_arr_name;\n";
        $content .= "\$$conf_arr_name = array();\n";
        foreach ($_POST as $k => $val) {
            if ($k != 'conf_arr_name' && $k != 'conf_file') {
                if (!is_array($val)) {
                    $content .= $k != 'illFormat' ? "\$" . $conf_arr_name . "['" . $k . "'] = \"" . htmlspecialchars(str_replace('"', '\"', stripslashes($val)), ENT_QUOTES) . "\";\n" : "\$" . $conf_arr_name . "['" . $k . "'] = \"" . str_replace('"', '\"', stripslashes($val)) . "\";\n";
                } else {
                    foreach ($val as $karr => $varr) {
                        $content .= "\$" . $conf_arr_name . "['" . $k . "']['" . $karr . "'] = \"" . htmlspecialchars(stripslashes($varr), ENT_QUOTES) . "\";\n";
                    }
                }
            }
        }
        save_conf($file, $content);
        echo '<br/>';
        require(ROOT . 'etc/blocks/' . $type . '.config.php');
    } else {
        echo '<section id="content" class="table-layout animated fadeIn">
	<div class="tray tray-center" style="height: 763px;">
        <form action="' . $link . '" method="post"	role="form" class="form-horizontal parsley-form" data-parsley-validate>';
        foreach ($parseConf['groups'] as $group) {
            echo '<div id="' . translit($group['title']) . '" class="panel panel-info panel-border top mb35">
				<div class="panel-heading">
					<span class="panel-title">' . $group['title'] . '</span>
				</div>
				<div class="heading-hr"></div>
				<div class="bg-white">';
            foreach ($group['vars'] as $var => $varArr) {
                echo '<table class="table table-xs table-striped">
						<tbody>			
        	                 <tr>
								<td class="col-xs-5 col-sm-5 col-md-6 pl20">
									<h6 class="media-heading text-semibold mb5">' . $varArr['title'] . ':</h6>
									<span class="text-muted text-size-small hidden-xs">' . $varArr['description'] . '</span>
								</td>
								<td class="col-xs-7 col-sm-7 col-md-6 pl20">
							<div class="mb-lg-0 w300 mnw430">
                     ' . (isset($confArr[$var]) ? str_replace(array('{varName}', '{var}'), array($var, Glang($confArr[$var]), $config['lang']), $varArr['content']) : $varArr['content']) . '
                            </div>
                                </td>
							</tr>
						</tbody>
					</table>';
            }
            echo '</div>';
        }
        echo '<input type="hidden" size="20" name="conf_file" class="textinput" value="' . $type . '" maxlength="100" maxsize="100">
      <input type="hidden" size="20" name="conf_arr_name" class="textinput" value="' . $varName . '" maxlength="100" maxsize="100">
      <div class="panel-footer text-right">
      <button type="submit" id="sub" value="' . $lang['save'] . '" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
      </div>
       </form>
   </div></div>
           <aside data-tray-height="match" class="panel tray-right tray-rescale tray320" style="height: 568px;">
	<div style="padding-right: 1px !important; margin-bottom: 20px; border-width: 0;" class="form-group admin-form">
       <div id="nav-spy">
         <ul data-smoothscroll="-125" data-spy="affix" data-offset-top="200" class="nav tray-nav tray-nav-border affix-top pl15">
   <h4 class="pl20">' . $lang['cats'] . ' </h4>';
        foreach ($parseConf['groups'] as $group) {
            echo '<li class="nav-primary tray320">
               <a class="anchored" href="#' . translit($group['title']) . '"> ' . $group['title'] . '</a>
            </li>';
        }
        echo '</ul>
      </div>
   </aside>
</section>';
    }
}