<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

global $adminTpl, $db, $url, $core, $config, $admin_conf, $user, $smiles, $page, $lang;
if (!defined('ACCESS') && !$core->auth->isAdmin && $url[0] !== ADMIN) {
    header('Location: /');
    exit;
}
if (MODE != 'default' && file_exists(ROOT . 'root/index.' . MODE . '.php')) {
    include(ROOT . 'root/index.' . MODE . '.php');
} else {
    define('ADMIN_ACCESS', true);
    define('COOKIE_VISIT', md5(getenv("REMOTE_ADDR")) . '-admin_visit');
    define('SESS_AUTH', md5(getenv("REMOTE_ADDR")) . '-auth');
    define('SESS_COUNT', md5(getenv("REMOTE_ADDR")) . '-counter');
    if (!isset($_SESSION)) session_start();
    require ROOT . 'etc/admin.config.php';
    require ROOT . 'root/functions.php';
    require ROOT . 'root/ajax_funcs.php';
    require ROOT . 'root/admin_tpl.class.php';
    if (!empty($admin_conf['ipaccess'])) {
        $IPs_arr = explode("\n", $admin_conf['ipaccess']);
        $parse_ip = @ip2long(getRealIpAddr());
        foreach ($IPs_arr as $IPs) {
            $IPs = explode('|', $IPs);
            if (count($IPs) == 2) {
                if ($parse_ip <= @ip2long($IPs[0]) && $parse_ip <= @ip2long($IPs[1])) {
                    $_SESSION[SESS_AUTH] = null;
                    $_SESSION[SESS_COUNT] = 0;
                    setcookie(COOKIE_AUTH, '', time(), '/');
                    setcookie(COOKIE_PAUSE, '', time(), '/');
                    location();
                }
            }
        }
    }
    if (init_login()) {
        login();
    } else {
        require ROOT . 'root/list.php';
        switch ($url[1] ?? null) {
            default:
                if (isset($url[1]) && (isset($component_array[$url[1]]) || isset($services_array[$url[1]]))) {
                    if (checkAdmControl($url[1])) {
                        require ROOT . 'root/modules/' . $url[1] . '.admin.php';
                    } else {
                        noadmAccess();
                    }
                } else {
                    if (checkAdmControl()) {
                        admin_main();
                    } else {
                        noadmAccess();
                    }
                }
                break;
            case 'do':
                $switch = filter($url[2]);
                switch ($switch) {
                    case 'logout':
                        $_SESSION[SESS_AUTH] = null;
                        $_SESSION[SESS_COUNT] = 0;
                        $core->auth->logout();
                        header('Location: /');
                        break;
                    case 'sqi':
                        return yandex_sqi($_SERVER['HTTP_HOST']);
                    case 'alexrang':
                        return alex_rang($config['url']);
                    case 'pr':
                        return getPageRank($config['url']);
                    case 'clearlogs':
                        return clear_tab('logs');
                    case 'clearCache':
                        return clearcache();
                }
                break;
            case 'module':
                define('ADMIN_SWITCH', true);
                $mod = $url[2] ?? $url[1];
                if (file_exists(ROOT . 'usr/modules/' . $mod . '/admin/index.php')) {
                    if ($core->checkModule($mod) == '1') {
                        if (checkAdmControl($mod)) {
                            require ROOT . 'usr/modules/' . $mod . '/admin/index.php';
                        } else {
                            noadmAccess();
                        }
                    } else {
                        nomodActive();
                    }
                } else {
                    header('Location: /' . ADMIN);
                }
                break;
            case 'logs':
                ajaxInit();
                $type = $url[2];
                $num = isset($url[3]) ? intval($url[3]) : '';
                if ($type == 'clear') {
                    $core->truncate_data('logs');
                    header('Location: /' . ADMIN);
                }
                break;
            case 'ajax':
                ajaxInit();
                $type = $url[2];
                $num = isset($url[3]) ? intval($url[3]) : '';
                switch ($type) {
                    case 'stats':
                        echo '<div class="col-sm-6 col-md-3 br-lg-r">
		<a href="' . ADMIN . '/module/news/">
			<h2 class="text-uppercase fs12 mn fs47 ib pr20 monserrat" title="' . $lang['panel_menu_news'] . '" style="color:' . $admin_conf['colorPanel'] . '">' . $core->sum_data('news') . '</h2>
		</a>
		<div class="reveal-xlg-inline-block text-center text-xlg-left">
			<p class="fs15 text-shady-lady mb5">' . $lang['stats_news'] . '</p>
		</div>
	</div>
	<div class="col-sm-6 col-md-3 br-lg-r mt-30 mt-sm-0">
		<a href="' . ADMIN . '/user/user_activated">
			<h2 class="text-uppercase fs12 mn fs47 ib pr20 monserrat" title="' . $lang['panel_menu_user'] . '" style="color:' . $admin_conf['colorPanel'] . '">' . $core->sum_data('users') . '</h2>
		</a>
		<div class="reveal-xlg-inline-block text-center text-xlg-left">
			<p class="fs15 text-shady-lady mb5">' . $lang['stats_user'] . '</p>
		</div>
	</div>
	<div class="clearfix visible-sm-block"></div>
	<div class="col-sm-6 col-md-3 br-lg-r mt-30 mt-md-0">
		<a href="' . ADMIN . '/module/content/">
			<h2 class="text-uppercase fs12 mn fs47 ib pr20 monserrat" title="' . $lang['panel_menu_com_static'] . '" style="color:' . $admin_conf['colorPanel'] . '">' . $core->sum_data('content') . '</h2>
		</a>
		<div class="reveal-xlg-inline-block text-center text-xlg-left">
			<p class="fs15 text-shady-lady mb5">' . $lang['stats_page'] . '</p>
		</div>
	</div>
	<div class="col-sm-6 col-md-3 mt-30 mt-md-0">
		<a href="' . ADMIN . '/module/board/">
			<h2 class="text-uppercase fs12 mn fs47 ib pr20 monserrat" title="' . $lang['panel_menu_com_forum'] . '" style="color:' . $admin_conf['colorPanel'] . '">' . $core->sum_data('board_threads') . '</h2>
		</a>
		<div class="reveal-xlg-inline-block text-center text-xlg-left">
			<p class="fs15 text-shady-lady mb5">' . $lang['stats_forum'] . '</p>
		</div>
	</div>
<div style="text-align:right;">
<button onclick="location.href = \'' . ADMIN . '/statistic/\'" name="submit" type="submit" id="sub" value="' . $lang['more'] . '" ' . btn_class('info') . '>' . $lang['more'] . '</button>
</div>';
                        break;
                    case 'Comdelete':
                        $commId = $num;
                        list($mod) = $core->fetch_data('comments', 'id ="' . $commId . '"', 'module');
                        if ($commId != 0 && $mod) {
                            $query = $core->select_data('comments', 'id ="' . $commId . '"');
                            if ($db->numRows($query) == 1) {
                                $post = $db->getRow($query);
                                deleteComments($commId, $post['module'], $post['id'], $post['uid']);
                            }
                        }
                        location(ADMIN);
                        break;
                    case 'server_stats':
                        echo '<div class="col-sm-4 mt-30 mt-sm-0">
   <div id="c1" value="' . getServerSpace() . '" data-circle-color="system" class="info-circle info-circle-percent"></div>
   <p class="fs15 text-shady-lady mt10">' . $lang['main_space'] . '</p>
</div>
<div class="col-sm-4 mt-30 mt-sm-0">
   <div id="c2" value="' . getServerCPULoad() . '" data-circle-color="success" class="info-circle info-circle-percent"></div>
   <p class="fs15 text-shady-lady mt10">' . $lang['main_cpu'] . '</p>
</div>
<div class="col-sm-4 mt-30 mt-sm-0">
   <div id="c3" value="' . getServerMemoryUsage() . '" data-circle-color="danger" class="info-circle info-circle-percent"></div>
   <p class="fs15 text-shady-lady mt10">' . $lang['main_ram'] . '</p>
</div>';
                        break;
                    case 'check':
                        echo '<div  id="check" class="pl30 pr50">' . getServerCheck() . '</div>';
                        break;
                    case 'last_user':
                        if ($core->auth->isAdmin) {
                            $query = $core->select_data('users', false, 'regdate DESC LIMIT ' . $admin_conf['numlastuser'], 'u.*, g.name', 'as u LEFT JOIN ' . DB_PREFIX . '_groups as g on(u.group = g.id)');
                            if ($db->numRows($query) > 0) {
                                while ($user = $db->getRow($query)) {
                                    echo '<div class="mt-60 mt-sm-30 d-sm-flex">
   <div class="pl30 pr30 col-sm-7">
      <div class="fs18 ib text-black">' . $user['nick'] . '</div>
      <p class="mt7">' . (empty($user['signature']) ? $lang['users_sign_empty'] : $user['signature']) . '</p>
   </div>
   <div class="text-mischka text-uppercase text-bold monserrat fs12 d-sm-flex flex-direction-column mla min-w145">
      <span class="bull bg-' . ($core->isOnline($user['id']) ? 'success' : 'info') . '"></span>
      <span>' . ($core->isOnline($user['id']) ? $lang['online'] : formatDate($user['last_visit'], true)) . '</span>
      <div class="btn-group btn-group-xs mt15 d-sm-flex">
         <a href="/profile/' . $user['id'] . '" ' . btn_class('system') . '>' . faSpan('fa-desktop', true, false, false, $lang['view']) . '</a>
         <a href="' . ADMIN . '/user/edit/' . $user['id'] . '" ' . btn_class('info', true, 2) . '>' . faSpan('fa-external-link', true, false, false, $lang['edit_short']) . '</a>
         <a href="' . ADMIN . '/user/letter/mail/' . $user['id'] . '" ' . btn_class('yellow', true, 2) . '>' . faSpan('fa-envelope-o', true, false, false, $lang['mail']) . '</a>
         <a href="' . ADMIN . '/user/letter/pm/' . $user['id'] . '" ' . btn_class('alert', true, 2) . '>' . faSpan('fa-user', true, false, false, $lang['pm']) . '</a>
         <a href="' . ADMIN . '/user/delete/' . $user['id'] . '" ' . btn_class('danger', true, 2) . '>' . faSpan('fa-trash', true, false, false, $lang['delete']) . '</a>
      </div>
   </div>
</div>';
                                }
                            } else {
                                echo '';
                            }
                        } else {
                            header('Location: /' . ADMIN);
                        }
                        break;
                    case 'add_notepad':
                        if (isset($core->auth->user_info['nick'])) {
                            $core->ins_data('notepad', 'id,text,nick', 'NULL,"","' . $core->auth->user_info['nick'] . '"');
                            header('Location: /' . ADMIN);
                        } else {
                            echo $lang['error'];
                        }
                        break;
                    case 'save_notepad':
                        $bb = new bb;
                        $id = isset($_POST['id']) ? intval($_POST['id']) : (isset($url[3]) ? intval($url[3]) : '');
                        $delete = isset($_POST['delete']) || isset($url[4]) && $url[4] == 'delete';
                        $text = fileInit('notepad', $id, 'content', $bb->parse(processText(filter($_POST['text'], 'html')), $id, true));
                        if (isset($core->auth->user_info['nick'])) {
                            if ($delete) {
                                $core->del_data('notepad', 'id ="' . $id . '"');
                                if (isset($url[3]) && $url[3] == 'all') $core->del_data('notepad');
                                removeDirectory($id, 'notepad');
                            } else {
                                if (!isset($_POST['submit'])) {
                                    $core->ins_data('notepad', 'id,text,nick', 'NULL,"' . $db->safesql($text) . '","' . $core->auth->user_info['nick'] . '"');
                                } else {
                                    $core->upd_data('notepad', '`text` ="' . $db->safesql($text) . '"', 'id ="' . $id . '"');
                                }
                            }
                            fileInit('notepad', $id);
                            clearcache();
                            header('Location: /' . ADMIN);
                        } else {
                            echo $lang['error'];
                        }
                        break;
                    case 'last_action':
                        if ($core->auth->isAdmin) {
                            $query = $core->select_data('logs', false, 'time DESC');
                            if ($db->numRows($query) > 0) {
                                echo '<table class="table list-table">
                                         <tbody>';
                                while ($log = $db->getRow($query)) {
                                    echo '<tr>
                                             <td><span class="icon ' . (($log['level'] == 2) ? 'text-warning fa fa-bell' : 'text-info fa fa-bullhorn') . '"></span>' . Glang($log['history']) . '</td>
                                             <td class="text-right">' . formatDate($log['time'], true) . '</td>
                                          </tr>';
                                }
                                echo '</tbody>
                                      </table>';
                            } else {
                                echo '<div class="box__body bg-white-lilac pl20 pr10 pt15 pb10 br4 w100p">' . $lang['main_last_action_empty'] . '</div>';
                            }
                        } else {
                            header('Location: /' . ADMIN);
                        }
                        break;
                    case 'hide_admin':
                        ajaxInit();
                        if ($core->auth->isAdmin) {
                            $type = $url[2];
                            echo $type;
                        } else {
                            header('Location: /' . ADMIN);
                        }
                        break;
                    case 'save_comm':
                        $cid = isset($_POST['cid']) ? intval($_POST['cid']) : '';
                        $text = isset($_POST['text']) ? filter($_POST['text']) : '';
                        ajaxInit();
                        if ($core->auth->isAdmin) {
                            $bb = new bb;
                            $core->upd_data('comments', '`text` ="' . $db->safesql(parseBB(processText(filter($_POST['text'], 'html')))) . '"', 'id ="' . $cid . '"');
                            $langs = $core->row_data('langs', 'postId ="' . $cid . '" AND module="news"');
                            $db->query("INSERT INTO" . DB_PREFIX . "_logs VALUES (NULL,'" . time() . "', '" . getRealIpAddr() . "', '" . $core->auth->user_id . "', '" . sess_count() . "','" . str_replace(array('[nick]', '[module]', '[post_id]'), array('' . $core->auth->user_info['nick'], '' . $langs['module'], '' . $cid), $lang['logs_edit_comments']) . "', '1')");
                        }
                        header('Location: /' . ADMIN);
                        break;
                    case 'addition':
                        $type = $url[2] ?? '';
                        if ($type == 'sqi') echo yandex_sqi($config['url']);
                        break;
                }
                break;
        }
    }
}
function admin_main(): void
{
    global $adminTpl, $db, $core, $config, $admin_conf, $user, $page, $lang;
    $last_visit = time();
    $query = '';
    if (!isset($_COOKIE[COOKIE_VISIT]) && !isset($_SESSION[SESS_AUTH])) {
        if ($core->ins_log($core->auth->user_info['nick'], $lang['logs_good_login'])) setcookie(COOKIE_VISIT, time(), time() + 86400, '/');
        $last_visit = time();
    }
    $adminTpl->admin_head($config['name']);
    foreach (glob(ROOT . 'root/components/moderation/comments.moderation.php') as $listed) require_once($listed);
    foreach (glob(ROOT . 'usr/modules/*/admin/moderation.php') as $listed) require_once($listed);
    echo '<div id="content" class="table-layout animated fadeIn">
           <div class="tray tray-center">
    <div class="panel tray-inner panel-system panel-border top">
         <div class="panel-heading">
             <span class="panel-title"> <h5 class="mtn">' . $lang['stats'] . ':</h5></span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body table-responsive">
    <div class="col-lg-12 admin-grid">
    <div class="form-group">';
    init_Ajax_count('root', false, 'stats');
    echo '</div>
</div>';
    if ($admin_conf['lastcom'] == 1) {
        echo '<div class="col-lg-6 col-sm-6 admin-grid">
<div class="form-group">
               <h3 class="mtn">' . $lang['main_last_comment'] . ':</h3>
   <div class="section mb5">';
        $query = $core->select_data('comments', 'c.status = 1', 'date DESC LIMIT ' . $admin_conf['numlastcom'], 'c.*, u.nick, u.group, u.last_visit', 'as c LEFT JOIN ' . DB_PREFIX . '_users as u on (c.uid=u.id)');
        if ($db->numRows($query) > 0) {
            while ($comment = $db->getRow($query)) {
                $tt = str(context($comment['text']), 300);
                $nick = $comment['nick'] ?? '';
                initDir('comments', $comment['id']);
                echo '<div class="panel-body pn box-sm box-offset-20 mt-30">
                  <div class="box__left"><a href="profile/' . $nick . '"><img height="60" width="60" src="' . avatar($comment['uid']) . '" class="img-responsive ib br4" alt="" ></a></div>
                  <div class="box__body bg-white-lilac pl20 pr10 pt15 pb10 br4 w100p">
                     <div class="fs18 ib text-black"><a href="profile/' . $comment['nick'] . '" title="' . $comment['nick'] . '">' . $comment['nick'] . '</a></div>
                     <div class="float-sm-right text-mischka text-bold monserrat fs12 mt7">' . status_icon('comments', $comment['id'], 'comments', $comment['date']) . ' ' . formatDate($comment['date'], true) . '</div>
                     <p class="mt7">' . (($tt != '') ? $tt : '<span style="color: red;">' . $lang['no_text'] . '</span>') . '</p>
                  </div>
               </div>
               <div class="float-sm-right text-mischka text-bold monserrat fs12 mt7">
                  <div class="btn-group btn-group-xs mt15 d-sm-flex">
                     <button type="button" ' . btn_class('system') . ' data-toggle="collapse" href="#modal-form-comment-' . $comment['id'] . '">' . $lang['edit_fast'] . '</button>
                     <button name="submit" type="submit" id="sub" ' . btn_class('info') . ' onclick="location.href = \'' . commentLink($comment['module'], $comment['post_id'], false) . '\'">' . $lang['view'] . '</button>
                     <button name="submit" type="submit" id="sub" ' . btn_class('danger') . ' href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $comment['id'] . '\')">' . $lang['delete'] . '</button>
                  </div>
                  </div>
               <div class="mt15 clearfix">
                  <form id="text" method="post" action="' . ADMIN . '/ajax/save_comm">
                     <div id="modal-form-comment-' . $comment['id'] . '" class="collapse fade opup-basic mfp-with-anim" tabindex="-1" role="dialog" aria-labelledby="gridModalLabel" aria-hidden="true">
                        <div class="col-lg-13 admin-grid" role="document">
                           <div class="modal-content">
                              <div class="modal-header ui-dialog-titlebar" style="background:' . $admin_conf['colorPanel'] . '">
                                 <button type="button" class="close" data-toggle="collapse" data-parent="#accordion" href="#modal-form-comment-' . $comment['id'] . '" title="' . $lang['base_close'] . '" aria-label="' . $lang['base_close'] . '"><span aria-hidden="true">x</span></button>
                                 <h4 class="modal-title" style="font-size: 14px;" id="modal-form-comment-' . $comment['id'] . '">
                                    <ul>' . $lang['main_com_edit'] . '..</ul>
                                 </h4>
                              </div>
                              <div class="modal-body">
                                 <div class="container-fluid">
                                    <div class="row">
                                       <div class="col-md-12">' . adminArea('text', context($comment['text']), 5, 'textarea', 'onchange="caa(this);"', true) . '</div>
                                    </div>
                                 </div>
                              </div>
                              <div class="panel-footer">
                                 <input type="hidden" name="cid" value="' . $comment['id'] . '">
                                 <button name="submit" type="submit" id="sub" ' . btn_class('success') . ' value="' . $lang['save'] . '">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
                                 <button name="submit" type="submit" id="sub" ' . btn_class('danger') . ' onclick="commentDelete(\'' . $comment['id'] . '\', \'commentBox_' . $comment['id'] . '\', \'' . $comment['module'] . '\', \'' . $comment['post_id'] . '\', \'' . $page . '\')">' . faSpan('fa-trash-o', true, $lang['delete']) . '</button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </form>
               </div>
               <div class="widget-menu pull-left mr5"></div>';
                modal_form_delete($comment['id'], $tt, $lang['comments_delete_title'], 'comments', $lang['comments_delete_text'], '{ADMIN}/ajax/Comdelete/' . $comment['id']);
            }
        } else {
            echo '<div class="box__body bg-white-lilac pl20 pr10 pt15 pb10 br4 w100p">' . $lang['main_last_comment_empty'] . '</div>';
        }
        echo '</div>
		</div>
		</div>';
    }
    if ($admin_conf['lastuser'] == 1) {
        echo '<div class="col-lg-6 col-sm-6 admin-grid">
<div class="form-group">
               <h3 class="mtn">' . $lang['main_last_users'] . ':</h3>
   <div class="section mb5">';
        $query = $core->select_data('users', false, 'regdate DESC LIMIT ' . $admin_conf['numlastuser'], 'u.*, g.name', 'as u LEFT JOIN ' . DB_PREFIX . '_groups as g on(u.group = g.id)');
        if ($db->numRows($query) > 0) {
            while ($user = $db->getRow($query)) {
                echo '<div class="panel-body pn mt-60 mt-sm-30 d-sm-flex">
                  <div class="col-sm-6">
                     <div class="fs18 ib text-black">' . $user['nick'] . '</div>
                     <p class="mt7">' . (empty($user['signature']) ? $lang['users_sign_empty'] : $user['signature']) . '</p>
                  </div>
                  <div class="text-mischka text-uppercase text-bold monserrat fs12 d-sm-flex flex-direction-column mla min-w145">
                     <span class="bull bg-' . ($core->isOnline($user['id']) ? 'success' : 'info') . '"></span>
                     <span>' . ($core->isOnline($user['id']) ? $lang['online'] : formatDate($user['last_visit'], true)) . '</span>
                     <div class="btn-group btn-group-xs mt-60 mt-sm-30">
                        <a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-formu-' . $user['id'] . '\')" ' . btn_class('system') . '>' . faSpan('fa-desktop', true, false, false, $lang['view']) . '</a>
                        <a href="' . ADMIN . '/user/edit/' . $user['id'] . '" ' . btn_class('info') . '>' . faSpan('fa-external-link', true, false, false, $lang['edit_short']) . '</a>
                        <a href="' . ADMIN . '/user/letter/mail/' . $user['id'] . '" ' . btn_class('yellow') . '>' . faSpan('fa-envelope-o', true, false, false, $lang['mail_write']) . '</a>
                        <a href="' . ADMIN . '/user/letter/pm/' . $user['id'] . '" ' . btn_class('alert') . '>' . faSpan('fa-user', true, false, false, $lang['pm_write']) . '</a>
                        <a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $user['id'] . '\')" ' . btn_class('danger') . '>' . faSpan('fa-trash', true, false, false, $lang['delete']) . '</a>
                     </div>
                  </div>
               </div>';
                modal_form_delete($user['id'], $user['nick'], $lang['users_del_title'], 'user', $lang['users_del_text'], ADMIN . '/user/delete/' . $user['id']);
                echo '<div id="modal-formu-' . $user['id'] . '" class="popup-basic bg-none mfp-with-anim mfp-hide">
                  <div class="panel">';
                mhColor($lang['profile_history'] . $user['nick']);
                UserCardInfo($user['id'], true, true);
                echo '</div>
               </div>';
            }
        } else {
            echo '';
        }
        echo '</div>
          </div>
      </div>';
    }
    if ($admin_conf['server_stats'] == 1) {
        echo '<div class="col-lg-6 col-sm-6 admin-grid">
<div class="form-group">
               <h3 class="mtn">' . $lang['main_server'] . ':</h3>
               <div class="panel-body pn pl30 pt10 pb10">
                  <div class="btn-group">';
        $notif = "notif(\'primary\', \'" . $lang['info'] . "\', \'" . $lang['ajax_update_compl'] . "\');";
        echo '</div>
               </div>
               <button onclick="ajaxGetJS(\'' . ADMIN . '/ajax/server_stats\', \'demoHighCharts.init(); ' . $notif . '\', \'server_stats\');"  type="button" ' . btn_class('system') . '>' . faSpan('fa-refresh mr10 icon', true, $lang['refresh']) . '</button>';
        init_Ajax_count('root', 'demoHighCharts', 'server_stats');
        echo '</div>
</div>';
    }
    if ($admin_conf['last_action'] == 1) {
        echo '<div class="col-lg-6 col-sm-6 admin-grid">
          <div class="form-group">
              <h3 class="mtn">' . $lang['main_last_action'] . ':</h3>
          <div class="section mb5">
              <div class="panel-body pn scroll panel-scroller scroller-sm scroller-thick scroller-blue scroller-pn mt30">';
        init_Ajax_count('root', false, 'last_action');
        echo '</div>
         </div>
     </div>
    </div>';
    }

    echo '</div>';
    if ($admin_conf['notepad'] == 1) {
        $where = 'nick ="' . $core->auth->user_info['nick'] . '"';
        $nout_page = $core->sum_data('notepad', $where);
        echo '<div class="form-group">
                    <ul class="nav nav-tabs nav-tabs-solid">
					    <li><a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#collapse0"><i class="fa fa-pencil-square-o position-left"></i> ' . $lang['main_notepad'] . '&nbsp;(' . $nout_page . '&nbsp;' . $lang['pages'] . ')</a>
                      </li>
				    </ul>
                <div id="collapse0" class="panel accordion-body collapse">
                    <div class="pl30 pt10">
                        <button name="submit" type="submit" id="sub" ' . btn_class('primary') . ' onclick="location.href = \'' . ADMIN . '/ajax/add_notepad/\'"> ' . $lang['main_create_separately'] . ' </button></h3>
					</div>
						<div class="panel-body pn pl30 pt10 pb10">
						<div class="notepad_list">';
        $query = $core->select_data('notepad', $where);
        $i = 0;
        if ($db->numRows($query) > 0) {
            while ($notepad = $db->getRow($query)) {
                $i++;
                $lastcom = isset($notepad['text']) ? context($notepad['text']) : '';
                initDir('notepad', $notepad['id']);
                echo '<div class="notepad_list-row pl10">				
				<div style="width:100%; height:auto; margin-bottom: 1px; margin-right: 1px;" class="col-sm-4 col-md-4 pl10 br-b-ddd">
                 <a href="#modal-form-notepad-' . $notepad['id'] . '" data-toggle="collapse" class="text-muted text-size-small">' . $lang['page'] . '&nbsp;' . $i . '</a>
                 <div class="widget-menu pull-right pt3">
                  <a href="' . ADMIN . '/ajax/save_notepad/' . $notepad['id'] . '/delete">' . faSpan('fa-trash-o', false, true, false, $lang['delete']) . '</a>
              </div>
                </div>
               <form method="post" action="' . ADMIN . '/ajax/save_notepad">
                     <div id="modal-form-notepad-' . $notepad['id'] . '" class="collapse fade opup-basic mfp-with-anim active" tabindex="-1" role="dialog" aria-labelledby="gridModalLabel" aria-hidden="true">
                        <div class="col-lg-12 col-md-12 col-sm-6 admin-grid" role="document">
                           <div class="modal-content">
                              <div class="modal-header ui-dialog-titlebar" style="background:' . $admin_conf['colorPanel'] . '">
                                 <button type="button" class="close" data-toggle="collapse" data-parent="#accordion" href="#modal-form-notepad-' . $notepad['id'] . '" title="' . $lang['base_close'] . '" aria-label="' . $lang['base_close'] . '"><span aria-hidden="true">x</span></button>
                                 <h4 class="modal-title text-size-base" id="modal-form-notepad-' . $notepad['id'] . '">
                                    <ul>' . faSpan('fa-info', true, $lang['main_notepad_desc']) . '..</ul>
                                 </h4>
                              </div>
                              <div class="modal-body">
                                 <div class="container-fluid">
                                    <div class="row">
                                       <div class="col-md-12">' . adminArea('text', $lastcom, 5, 'textarea', 'onchange="caa(this);"', true) . '</div>
                                    </div>
                                 </div>
                              </div>
                              <div class="panel-footer">
                                 <input type="hidden" name="id" value="' . $notepad['id'] . '">
                                 <button name="submit" type="submit" id="sub" value="' . $lang['save'] . '" ' . btn_class('success') . '>' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
                                 <button name="delete" type="submit" id="sub" ' . btn_class('danger') . '>' . faSpan('fa-trash-o', true, $lang['delete']) . '</button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </form>
				  </div>';
            }
        } else {
            $core->ins_data('notepad', 'id,text,nick', 'NULL,"","' . $core->auth->user_info['nick'] . '"');
        }
        echo '</div></div>';
        if ($nout_page > 1) echo '<div style="text-align:right;" class="panel-footer"><button name="delete" type="submit" id="sub" ' . btn_class('danger') . ' onclick="location.href = \'' . ADMIN . '/ajax/save_notepad/all/delete/\'"> ' . faSpan('fa-trash-o', true, $lang['delete'] . '&nbsp;' . $lang['pages']) . ' </button></h3></div>';
        echo '</div>
</div>';
    }
    echo '</div>
</div>
</div>';
    $adminTpl->admin_foot();
}

function init_login(): bool
{
    global $core, $admin_conf;
    if ($core->auth->isUser && $core->auth->isAdmin) {
        if (isset($_SESSION[SESS_AUTH]) && $_SESSION[SESS_AUTH] == 'ok' || $admin_conf['sessions'] == 0) {
            return false;
        } else {
            return true;
        }
    } else {
        return true;
    }
}

function ADlogin($access_auth, $password)
{
    global $core, $config;
    $_SESSION[SESS_AUTH] = 'ok';
    if (!$core->auth->isUser || !$core->auth->isAdmin) {
        $time = isset($_POST['remember']) ? COOKIE_TIME : '3600';
        $newHash = md5(@$_SERVER['HTTP_USER_AGENT'] . $config['uniqKey']);
        if (is_array($access_auth)) {
            setcookie(COOKIE_AUTH, engine_encode(serialize(array('id' => $access_auth['id'], 'nick' => $access_auth['nick'], 'password' => md5(mb_substr($password, 0, -mb_strlen($access_auth['tail'])) . $access_auth['tail']), 'hash' => $newHash))), time() + $time, '/');
        } else {
            return $_SESSION[SESS_AUTH];
        }
    }
}

function login(): void
{
    global $adminTpl, $db, $core, $config, $log_conf, $url, $email_conf, $social, $security, $lang;
    require ROOT . 'etc/social.config.php';
    require ROOT . 'etc/email.config.php';
    $s_list = $social['admin'] != '0' ? social_list_admin() : '';
    $adminTpl->sep = '';
    $attempt = '';
    $at_tur = '';
    $counter = sess_count();
    $no_head = true;
    $turns = $security['auth_max_num'] - $counter;
    $login = $_POST['nick'] ?? '';
    $where = $security['auth_metod'] == 'nick' ? 'nick ="' . filter($login, 'nick') . '"' : 'email ="' . filter($login, 'email') . '"';
    $access_auth = $core->row_data('users', $where . ' AND `group` = 1');
    $password = $_POST['password'] ?? '';
    $md_password = isset($_POST['password']) ? md5(md5($_POST['password'])) : '';
    $ip = getRealIpAddr();
    $ua = getBrowser();
    $browser = $lang['browser'] . $ua['name'] . ' ' . $ua['version'] . $lang['in'] . $ua['platform'] . $lang['reports'] . $ua['userAgent'];
    $link = $config['url'] . '/profile/login';
    $ch = curl_init('https://ip-api.com/json/?lang=ru');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HEADER, false);
    $res = curl_exec($ch);
    curl_close($ch);
    $geo = json_decode($res, true);
    $country = $geo['country'] ?? '';
    $regionName = $geo['regionName'] ?? '';
    $title = str_replace(array('[device]', '[browser]', '[geo]'), array(detect_device(), false, $country . ', ' . $regionName), $lang['email_admin_title_text']);
    $month_list = array(null, $lang['januarys'], $lang['februarys'], $lang['marchs'], $lang['aprils'], $lang['mays'], $lang['junes'], $lang['julys'], $lang['augusts'], $lang['septembers'], $lang['octobers'], $lang['novembers'], $lang['decembers']);
    $geo = $country . ', ' . $regionName;
    $dates = date('d') . '&nbsp;' . $month_list[date('n')] . '&nbsp;' . date('Y H:i');
    if (isset($url[1]) && !$core->auth->isUser && !$core->auth->isAdmin) header('Location: /' . ADMIN);
    if (!empty($login)) {
        if ($security['auth_metod'] == 'nick') {
            if (preg_match('/[\||\'|\<|\>|"|\!|\?|\$|\/|\\\|\&\~\*\+]/', $login)) ;
            $nick = filter($login, 'nick');
        } else {
            if (!preg_match("/^(?:[a-z0-9]+(?:[-_.]?[a-z0-9]+)?@[a-z0-9_.-]+(?:\.?[a-z0-9]+)?\.[a-z]{2,5})$/i", $login)) ;
            $nick = is_array($access_auth) && $login == $access_auth['email'] ? $access_auth['nick'] : '/';
        }
        if (!empty($nick) && !empty($password)) {
            $adminTpl->loadFile('login');
            if (is_array($access_auth) && (md5(mb_substr($md_password, 0, -mb_strlen($access_auth['tail'])) . $access_auth['tail']) == $access_auth['password'])) {
                ADlogin($access_auth, $md_password);
                if (eregStrt(ADMIN, $_SERVER['HTTP_REFERER'])) {
                    if ($email_conf['access_mail'] == 1) {
                        $query = $core->select_data('email', false, 'id ASC');
                        while ($result = $db->getRow($query)) {
                            $message = $result['html_access_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%sitename%}', '{%date%}', '{%browser%}', '{%geo%}', '{%link%}', '{%url%}'), array('<', '>', $access_auth['nick'], $config['name'], $dates, $browser, $geo, $link, $config['url']), $result['access_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%sitename%}', '{%date%}', '{%browser%}', '{%geo%}', '{%link%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $access_auth['nick'], $config['name'], $dates, $browser, $geo, $link, $config['url']), $result['access_mail_text']);
                            mailSMTP($config['support_mail'], $result['access_mail_text'], $title, $message);
                        }
                    }
                    location($_SERVER['HTTP_REFERER']);
                } else {
                    location(ADMIN);
                }
                $core->ins_log($nick, $lang['logs_good_login']);
                sess_clear();
            } elseif ($login !== $nick) {
                $ip = $core->row_data('logs', 'ip');
                if ($counter <= ($security['auth_max_num'] - 1)) {
                    $attempt = str_replace('{turns}', declension($turns, array($lang['attempt'], $lang['attempt_1'], $lang['attempt_2'])), $lang['err_login']);
                } elseif ($counter == 1) {
                    $attempt = str_replace('{turns}', declension($turns, array($lang['attempt'], $lang['attempt_1'], $lang['attempt_2'])), $lang['err_login']);
                } else {
                    $attempt = $lang['err_login_2'];
                    if (getRealIpAddr() !== $ip['ip']) $core->upd_data('logs', 'counter ="' . $counter . '"', 'WHERE `ip`');
                }
            } else {
                if ($turns == 1) {
                    $core->ins_log($login, $lang['logs_bad_login'], true, false, 'pass', $password);
                    $accesError = str_replace(array('[nick]', '[pass]'), array($login, $password), $lang['logs_bad_login']);
                    if ($log_conf['accesError'] == 1) writeInLog($accesError, 'accesError');
                } elseif ($turns < 0) {
                    if ($email_conf['hacking_mail'] == 1) {
                        $query = $core->select_data('email', false, 'id ASC');
                        while ($result = $db->getRow($query)) {
                            $message = $result['html_hacking_attempt'] > 0 ? str_replace(array('&lt;', '&gt;', '{%nick%}', '{%pass%}', '{%device%}', '{%browser%}', '{%geo%}', '{%ip%}', '{%url%}'), array('<', '>', $login, $password, detect_device(), $browser, $country . ', ' . $regionName, $ip, $config['url']), $result['hacking_attempt_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%nick%}', '{%pass%}', '{%device%}', '{%browser%}', '{%geo%}', '{%ip%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $login, $password, detect_device(), $browser, $country . ', ' . $regionName, $ip, $config['url']), $result['hacking_attempt_text']);
                            mailSMTP($config['support_mail'], $result['hacking_attempt_text'], $lang['admin_hacking'], $message);
                            $accesError = str_replace(array('[nick]', '[pass]', '[device]', '[browser]', '[geo]', '[ip]', '[url]'), array($login, $password, detect_device(), $browser, $country . ', ' . $regionName, $ip, $config['url']), $lang['admin_hacking_login']);
                            if ($log_conf['accesError'] == 1) writeInLog($accesError, 'accesError');
                        }
                    }
                    $file_name = 'etc/security.config.php';
                    $file_data = file($file_name);
                    $file_data[17] = "\r\n" . $ip . "\r\n";
                    file_put_contents($file_name, $file_data);
                }
                $attempt = $turns <= 0 ? $lang['no_turns'] : str_replace('{turns}', declension($turns, array($lang['attempt'], $lang['attempt_1'], $lang['attempt_2'])), $lang['false_turn']);
                $at_tur = $turns <= 1 ? '<a style="float:right;" href="profile/forgot_pass" title="' . $lang['recovery_pas'] . '">' . $lang['forgot_all'] . '</a>' : '';
            }
        } elseif (empty($password)) {
            $attempt = $turns <= 0 ? $lang['empty_password'] : str_replace('{turns}', declension($turns, array($lang['attempt'], $lang['attempt_1'], $lang['attempt_2'])), $lang['false_turn']);
        } else {
            $attempt = $security['auth_metod'] == 'nick' ? $lang['empty_login'] : $lang['empty_email'];
        }
    }
    $stop = $attempt ? '<div class="alert alert-danger alert-dismissable mb15"><button type="button" data-dismiss="alert" aria-hidden="true" class="close"></button>' . faSpan(false, true, '<strong>' . $lang['warning'] . '!</strong> ' . $attempt . $at_tur) . '</div>' : '';
    $adminTpl->loadFile('login');
    $adminTpl->setVar('STOP', $stop);
    $adminTpl->setVar('METOD', ($security['auth_metod'] == 'email') ? $lang['email_metod'] : $lang['login_metod']);
    $adminTpl->setVar('AUTH_ICON', ($security['auth_metod'] == 'email') ? faI('fa-envelope-o', false, false, true) : faI('fa-user', false, false, true));
    $adminTpl->setVar('AUTH_METOD', ($security['auth_metod'] == 'email') ? $lang['pre_email'] : $lang['pre_username']);
    $adminTpl->setVar('LANG', $core->InitLang());
    $adminTpl->setVar('URL', $config['url']);
    $adminTpl->setVar('ADMIN', $config['url'] . '/' . ADMIN);
    $adminTpl->setVar('ADM_THEME', 'usr/tpl/admin');
    $adminTpl->setVar('SOCIAL', $s_list);
    $adminTpl->setVar('LICENSE', $lang['license_powered']);
    $adminTpl->setVar('D_YEAR', date("Y"));
    $adminTpl->end();
}