<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
if (MODE != 'default' && file_exists(ROOT . 'root/list.' . MODE . '.php')) {
    include(ROOT . 'root/list.' . MODE . '.php');
} else {
    global $lang;
    $component_array = array(
        'config' => array(
            'name' => $lang['admin_conf'],
            'icon' => 'fa fa-gears',
            'desc' => $lang['admin_conf_desc'],
            'shown' => 1,
            'subAct' => array(
                $lang['system'] => '',
                $lang['modules'] => 'modules',
                $lang['admin_conf_copy'] => 'backup',
            ),
        ),
        'blocks' => array(
            'name' => $lang['blocks'],
            'icon' => 'fa fa-code',
            'desc' => $lang['block_desc'],
            'subAct' => array(
                $lang['ap_l_list'] => '',
            ),
            'dsubAct' => array(
                $lang['types'] => 'types',
                $lang['block_stand'] => 'standard',
                $lang['block_sort'] => 'resort',
            ),
            'dropAct' => array(
                $lang['bblock'] => 'add',
                $lang['type'] => 'typeAdd',
            ),
            'shown' => 1
        ),
        'cats' => array(
            'name' => $lang['ap_cats'],
            'icon' => 'glyphicon glyphicon-list',
            'desc' => $lang['ap_cats_desc'],
            'subAct' => array(
                $lang['ap_l_list'] => '',
                $lang['ap_cats_icon'] => 'cats_icon',
            ),
            'dropAct' => array(
                $lang['ap_cats1'] => 'add',
                $lang['cats'] => 'scan',
                $lang['ap_cats_icons'] => 'icon_add',
            ),
            'shown' => 1
        ),
        'comments' => array(
            'name' => $lang['ap_comments'],
            'icon' => 'glyphicon glyphicon-comment',
            'desc' => $lang['ap_com_desc'],
            'subAct' => array(
                $lang['ap_comments_main'] => '',
                $lang['ap_comments_moder'] => '../moderation/com/comments',
            ),
            'shown' => 1
        ),
        'user' => array(
            'name' => $lang['ap_users'],
            'icon' => 'glyphicon glyphicon-user text-muted',
            'subAct' => array(),
            'desc' => $lang['ap_users_desc'],
            'lsubAct' => array(
                $lang['users_sort_activated'] => 'user_activated',
                $lang['users_sort_not_activated'] => 'user_not_activated',
                $lang['ban_list'] => 'user_ban',
            ),
            'dsubAct' => array(
                $lang['groups'] => '../groups',
            ),
            'shown' => 1
        ),
        'groups' => array(
            'name' => $lang['ap_groups'],
            'icon' => 'glyphicon glyphicon-tag',
            'desc' => $lang['ap_groups_desc'],
            'subAct' => array(
                $lang['ap_l_list'] => '',
                $lang['ap_groups_add'] => 'add',
                $lang['ap_groups_points'] => 'points',
            ),
            'shown' => 1
        ),
        'xfields' => array(
            'name' => $lang['ap_xfields'],
            'icon' => 'glyphicon glyphicon-star',
            'desc' => $lang['ap_xfields_desc'],
            'subAct' => array(
                $lang['ap_l_list'] => '',
                $lang['ap_xfields_add'] => 'add',
            ),
            'shown' => 1
        ),
        'modules' => array(
            'name' => $lang['ap_mods'],
            'icon' => 'fa fa-cloud',
            'desc' => $lang['ap_mods_desc'],
            'shown' => 1,
            'subAct' => array(
                $lang['ap_mods_list'] => '',
                $lang['ap_mods_server'] => 'server',
                $lang['ap_mods_upload'] => 'upload',
            )
        ),
        'moderation' => array(
            'name' => $lang['moder'],
            'icon' => 'glyphicon glyphicon-edit',
            'desc' => $lang['ap_pub_desc'],
            'shown' => 1,
            'subAct' => array(
                $lang['comments'] => 'com/comments',
            )
        ),
    );
    $services_array = array(
        'db' => array(
            'name' => $lang['ap_db'],
            'icon' => 'glyphicon glyphicon-tasks',
            'desc' => $lang['ap_db_desc'],
            'subAct' => array(
                $lang['ap_db_tables'] => '',
                $lang['ap_db_backup'] => 'backup',
            ),
            'confAct' => array(
                $lang['config'] => 'config',
            ),
            'shown' => 1
        ),
        'smiles' => array(
            'name' => $lang['smiles_control'],
            'icon' => 'fa fa-smile-o',
            'desc' => $lang['smiles_control_desc'],
            'subAct' => array(
                $lang['smiles_list'] => '',
                $lang['smiles_add'] => 'add'
            ),
            'shown' => 1
        ),
        'voting' => array(
            'name' => $lang['ap_poll'],
            'icon' => 'glyphicon glyphicon-plus-sign',
            'desc' => $lang['ap_poll_desc'],
            'subAct' => array(
                $lang['ap_poll_list'] => '',
                $lang['ap_poll_add'] => 'add'
            ),
            'shown' => 1
        ),
        'statistic' => array(
            'name' => $lang['ap_stats'],
            'icon' => 'glyphicon glyphicon-stats',
            'desc' => $lang['ap_stats_desc'],
            'shown' => 1
        ),
        'feedback' => array(
            'name' => $lang['ap_feedback'],
            'icon' => 'fa fa-bullhorn',
            'desc' => $lang['ap_feedback_desc'],
            'subAct' => array(
                $lang['ap_l_list'] => '',
            ),
            'confAct' => array(
                $lang['config'] => 'config',
            ),
            'shown' => 1
        ),
        'complaint' => array(
            'name' => $lang['ap_complaint'],
            'icon' => 'fa fa-bullhorn',
            'desc' => $lang['ap_complaint_desc'],
            'subAct' => array(
                $lang['ap_l_list'] => '',
            ),
            'confAct' => array(
                $lang['config'] => 'config',
            ),
            'shown' => 1
        ),
        'distribution' => array(
            'name' => $lang['ap_distribution'],
            'icon' => 'glyphicon glyphicon-envelope',
            'desc' => $lang['ap_distribution_desc'],
            'subAct' => array(
                $lang['ap_l_list'] => '',
                $lang['ap_distribution_add'] => 'add',
            ),
            'confAct' => array(
                $lang['config'] => '../config/global/#nastroka-pochty',
            ),
            'shown' => 1
        ),
        'banners' => array(
            'name' => $lang['ap_banners'],
            'icon' => 'glyphicon glyphicon-shopping-cart',
            'desc' => $lang['ap_banners_desc'],
            'subAct' => array(
                $lang['ap_l_list'] => '',
                $lang['ap_banners_add'] => 'add',
                $lang['ap_banners_status_clicks'] => 'status_clicks',
            ),
            'viewAct' => array(
                $lang['panel_stats_views'] => 'stats_views',
                $lang['panel_stats_clicks'] => 'stats_clicks',
            ),
            'shown' => 1
        ),
        'tagcode' => array(
            'name' => $lang['ap_tagcode'],
            'icon' => 'fa fa-random',
            'desc' => $lang['ap_tagcode_desc'],
            'subAct' => array(
                $lang['ap_l_list'] => '',
                $lang['ap_tagcode_add'] => 'add',
            ),
            'shown' => 1
        ),
        'search' => array(
            'name' => $lang['module_server'],
            'icon' => 'fa fa-search',
            'desc' => $lang['ap_search_desc'],
            'shown' => 1
        ),
        'log' => array(
            'name' => $lang['ap_logs'],
            'icon' => 'glyphicon glyphicon-info-sign',
            'desc' => $lang['ap_logs_desc'],
            'subAct' => array(
                $lang['list'] => 'all',
            ),
            'viewAct' => array(
                $lang['phpError'] . ' (' . counts_error('phpError') . ')' => 'phpError',
                $lang['queryError'] . ' (' . counts_error('db_query') . ')' => 'db_query',
                $lang['dbError'] . ' (' . counts_error('dbError') . ')' => 'dbError',
                $lang['accesError'] . ' (' . counts_error('accesError') . ')' => 'accesError',
            ),
            'confAct' => array(
                $lang['config'] => '../config/log',
            ),
            'shown' => 1
        ),
        'update' => array(
            'name' => $lang['updates'],
            'icon' => 'glyphicon glyphicon-refresh',
            'desc' => $lang['updates_desc'],
            'shown' => 1
        ),
        'support' => array(
            'name' => $lang['supports'],
            'icon' => 'fa fa-life-ring',
            'desc' => $lang['support_desc'],
            'subAct' => array(
                $lang['support_history'] => '',
                $lang['support_send'] => 'question',
            ),
            'shown' => 1
        ),
        'templates' => array(
            'name' => $lang['ap_tpl'],
            'icon' => 'fa fa-pencil-square-o',
            'desc' => $lang['ap_tpl_desc'],
            'subAct' => array(
                $lang['ap_tpl_all'] => '',
            ),
            'editAct' => array(
                $lang['ap_tpl_tpl'] => 'edit_tpl',
                $lang['ap_tpl_css'] => 'edit_css',
                $lang['ap_tpl_js'] => 'edit_js',
            ),
            'shown' => 1
        ),
        'language' => array(
            'name' => $lang['ap_language'],
            'icon' => 'fa fa-language',
            'desc' => $lang['ap_language_desc'],
            'subAct' => array(
                $lang['ap_l_list'] => '',
            ),
            'editAct' => array(
                $lang['ap_edit_language'] => 'edit_lang',
            ),
            'shown' => 1
        )
    );
}
