<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $url, $smiles, $config, $admin_conf, $lang;
switch ($url[2] ?? null) {
    default:
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        datetimepickerInit('startdate', 'date');
        datetimepickerInit('enddate', 'date');
        $where = '';
        $order = '';
        $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
        $s_tags = (isset($url[3]) ? $url[3] == 'tag' : '') ? $url[4] : '';
        $s_desc = $_POST['s_desc'] ?? '';
        $startdate = isset($_POST['startdate']) ? strtotime($_POST['startdate']) : '';
        $enddate = isset($_POST['enddate']) ? strtotime($_POST['enddate']) : '';
        $s_active = isset($_POST['s_active']);
        $s_search = isset($_POST['s_search']);
        if ($s_search) $s_search = $_POST['s_search'] == 1;
        if ($s_active) {
            if ($_POST['s_active'] == 1) {
                $where = 'active = 1';
            } else {
                $s_active = false;
                $where = 'active = 0';
            }
        } else {
            $s_active = true;
        }
        if ($s_id) {
            $where .= 'AND `id` LIKE"%' . $db->safesql($s_id) . '%"';
        } else {
            $s_id = '';
        }
        if ($s_desc) $where .= 'AND `desc` LIKE"%' . $db->safesql($s_desc) . '%"';
        if ($startdate) $where .= 'AND `startdate` >="' . intval($startdate) . '"';
        if ($enddate) $where .= 'AND `enddate` <="' . intval($enddate) . '"';
        if (isset($url[2]) && $url[2] == 'order') {
            switch ($url[3]) {
                case 'abc':
                    $order .= 'urltitle ASC';
                    break;
                case 'last':
                    $order .= 'enddate DESC';
                    break;
                case 'id':
                    $order .= 'id ASC';
                    break;
            }
        } else {
            $order .= 'id DESC';
        }
        $query = $core->select_data('banners', $where, $order . ' LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['banners']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('banners');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['banners_list'] . ' (' . $core->sum_data('banners') . '):</span>
            ' . sort_head('root', 3, 'last') . '
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th>' . $lang['banners_desc'] . '</th>
                        <th class="text-center">' . faSpan('fa-eye', true, false, false, $lang['panel_stats_views']) . '</th>
                        <th class="text-center">' . faSpan('fa-hand-pointer-o', true, false, false, $lang['panel_stats_clicks']) . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($row = $db->getRow($query)) {
                start_end('banners', $row['id'], $row['startdate'], $row['enddate'], $row['active']);
                clicks_views('banners', $row['id'], $row['max_views'], $row['views'], $row['max_clicks'], $row['clicks']);
                $no_time_limit = faSpan('fa-window-minimize', false, false, false, $lang['no_time_limit'] . '"');
                $startdate = !$row['startdate'] ? $no_time_limit : date('d-m-y', $row['startdate']);
                $enddate = !$row['enddate'] ? $no_time_limit : date('d-m-y', $row['enddate']);
                $end_day = !$row['enddate'] ? $no_time_limit : downcounter($row['enddate']);
                $code = str_replace(array('<br>', '<br/>', '\p', '\n', '<', '>', '{%urlb%}', '{%urltitle%}', '{%urlimg%}'), array('\n', '\n', '""', '""', '&lt;', '&gt;', $row['urlsb'], $row['urltitle'], $row['urlimg']), $row['code']);
                $codeviews = str_replace(array('\n', '\n', '""', '""', '&lt;', '&gt;', '{%urlb%}', '{%urltitle%}', '{%urlimg%}'), array('<br>', '<br/>', '\p', '\n', '<', '>', $row['urlsb'], $row['urltitle'], $row['urlimg']), $row['code']);
                $command = 'document.querySelector(\'#copy_' . $row['id'] . '\').select(); document.execCommand(\'copy\'); notif(\'primary\', \'' . $lang['info'] . '\', \'' . $lang['copy_success'] . '\');';
                echo '<tr>
                        <td><span class="pd-l-sm"></span>' . $row['id'] . '</td>
                        <td><div class="media media-list text-right"><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-view' . $row['id'] . '\')"><img src="' . $row['urlimg'] . '" class="img-responsive mw60 ib br4"' . toggle(trimtitle($row['desc'], 50)) . ' style="border:0" alt=""/></a></div></td>
                        <td>
                           <ol class="timeline-list tline">' . trimtitle($row['desc'], 50) . '</ol>
                           <ol class="timeline-list tline"><p class="text-left" href="' . $row['id'] . '#copy" onclick="' . $command . '" title="' . $lang['tagcode_copy'] . '[' . $row['tag'] . '] {%' . $row['tag'] . '%} [/' . $row['tag'] . ']">
                           <textarea id="copy_' . $row['id'] . '" style="width: 390px; height: 40px; margin: 0; font-size: 12px;" class="form-control input-sm text-center" data-parsley-required="true" data-parsley-trigger="change">[' . $row['tag'] . '] {%' . $row['tag'] . '%} [/' . $row['tag'] . ']</textarea>
                           </p></ol>
                           <ol class="timeline-list tline">' . $lang['banners_list_start'] . ': ' . $startdate . '</ol>
                           <ol class="timeline-list tline">' . $lang['banners_list_end'] . ': ' . $enddate . '</ol>
                           <ol class="timeline-list tline">' . $lang['banners_day_end'] . ': ' . $end_day . ' </ol>
                        </td>';
                init_Ajax_count('root', 'banners', $row['id'], 'views', 'id=' . $row['id']);
                init_Ajax_count('root', 'banners', $row['id'], 'clicks', 'id=' . $row['id']);
                echo '<td class="text-center">' . status_icon('banners', $row['id'], 'banners') . '</td>';
                init_checkbox('td', $row['id'], false, '<li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-view' . $row['id'] . '\')">' . faSpan('fa-television', true, $lang['view']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/edit/' . $row['id'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/retivate/' . $row['id'] . '">' . faSpan('fa-power-off', true, (($row['active'] == 0) ? $lang['do_activation'] : $lang['do_deactivation'])) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/random/' . $row['id'] . '">' . faSpan('fa-random', true, (($row['random'] == 0) ? $lang['do_random'] : $lang['do_derandom'])) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#copy" onclick="' . $command . '">' . faSpan('fa-files-o', true, $lang['tagcode_copy']) . '</a></li>
            ' . (($row['enddate'] > 0) ? '<li><a href="{ADMIN_LINK}/restrictions/' . $row['id'] . '">' . faSpan('fa-stop-circle-o', true, $lang['do_restrictions'] . $lang['do_time']) . '</a></li>' : '') . '
                                 <li><a href="{ADMIN_LINK}/restviews/' . $row['id'] . '">' . faSpan('fa-eye', true, $lang['do_restrictions'] . $lang['do_views']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/restclicks/' . $row['id'] . '">' . faSpan('fa-hand-pointer-o', true, $lang['do_restrictions'] . $lang['do_clicks']) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-cviews' . $row['id'] . '\')">' . faSpan('fa-eraser', true, $lang['banners_clear_views']) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-cclicks' . $row['id'] . '\')">' . faSpan('fa-eraser', true, $lang['banners_clear_clicks']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $row['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                echo '</tr>';
                modal_form_delete('cviews' . $row['id'], $row['desc'], $lang['banners_cviews_title'], 'banners', $lang['banners_cviews_text'], '{ADMIN_LINK}/clearviews/' . $row['id'], false, true);
                modal_form_delete('cclicks' . $row['id'], $row['desc'], $lang['banners_cclicks_title'], 'banners', $lang['banners_cclicks_text'], '{ADMIN_LINK}/clearclicks/' . $row['id'], false, true);
                modal_form_delete($row['id'], $row['desc'], $lang['banners_del_desc'], 'banners', $lang['banners_del_text'], '{ADMIN_LINK}/delete/' . $row['id']);
                modal_form_text('view' . $row['id'], $lang['info'], 'fa-desktop', $lang['banners_code'] . '</br></br><pre><code>' . $code . '</code></pre>', '<fieldset style="border-style:solid; border-width:1px; border-color:#000000;">' . $codeviews . '</fieldset>');
            }
            echo '</tbody>';
            init_tfoot('<option value="Activate">' . $lang['do_activation'] . '</option>
                                 <option value="deActivate">' . $lang['do_deactivation'] . '</option>
                                 <option value="reActivate">' . $lang['do_reactivation'] . '</option>
                                 <option value="Random">' . $lang['do_derandom'] . '</option>
                                 <option value="reRestrictions">' . $lang['do_restrictions'] . $lang['do_time'] . '</option>
                                 <option value="reRestViews">' . $lang['do_restrictions'] . $lang['do_views'] . '</option>
                                 <option value="reRestClicks">' . $lang['do_restrictions'] . $lang['do_clicks'] . '</option>
                                 <option value="clearViews">' . $lang['banners_clear_views'] . '</option>
                                 <option value="clearClicks">' . $lang['banners_clear_clicks'] . '</option>
                                 <option value="Delete">' . $lang['delete'] . '</option>');
            echo '</table>
            </form>
         </div>
      </div>';
            page_list('root', 'banners', 'banners', $where);
            echo '</div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action="">
         <div style="top: 140px; position: fixed; margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb15">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['news_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb10 mbn10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['news_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5 mbn10 pl10">
               <h5><small>' . $lang['news_search_date'] . '</small></h5>
               <div class="section row">
                  <div class="col-md-6">
                     <label for="startdate" class="field prepend-icon">
                     <input id="startdate" type="text" name="startdate" placeholder="' . $lang['from'] . '" style="width:120px;" class="form-control">
                     <label for="startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
                  <div class="col-md-6">
                     <label for="enddate" class="field prepend-icon">
                     <input id="enddate" type="text" name="enddate" placeholder="' . $lang['to'] . '" style="width:120px;" class="form-control">
                     <label for="enddate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active"' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['banners_active'] . '</label>
            </div>
            ' . init_sfoot(true, true) . '
         </div>
      </form>
   </aside>
</div>';
        } else {
            list_empty('root', 'banners', 'url', $s_search, false, true, $s_search);
        }
        $adminTpl->admin_foot();
        break;
    case'add':
        add();
        break;
    case 'edit':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        add($id);
        break;
    case 'save':
        $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
        $tag = isset($_POST['tag']) ? filter($_POST['tag']) : '';
        $desc = isset($_POST['desc']) ? filter($_POST['desc']) : '';
        $max_views = isset($_POST['max_views']) ? intval($_POST['max_views']) : 0;
        $max_clicks = isset($_POST['max_clicks']) ? intval($_POST['max_clicks']) : 0;
        $urlsb = isset($_POST['urlsb']) ? filter($_POST['urlsb']) : '';
        $urlimg = isset($_POST['urlimg']) ? filter($_POST['urlimg']) : '';
        $urltitle = isset($_POST['urltitle']) ? filter($_POST['urltitle']) : '';
        $allow_views = isset($_POST['allow_views']) ? intval($_POST['allow_views']) : 0;
        $allow_clicks = isset($_POST['allow_clicks']) ? intval($_POST['allow_clicks']) : 0;
        $find = array("<", ">");
        $replace = array("&lt;", "&gt;");
        $code = $db->safesql(str_replace($find, $replace, $_POST['code']));
        $active = isset($_POST['active']) ? intval($_POST['active']) : 0;
        $random = isset($_POST['random']) ? intval($_POST['random']) : 0;
        $main = isset($_POST['main']) ? intval($_POST['main']) : 0;
        $inprofile = isset($_POST['inprofile']) ? intval($_POST['inprofile']) : 0;
        $innews = isset($_POST['innews']) ? intval($_POST['innews']) : 0;
        $ttime = 'UNIX_TIMESTAMP(NOW())';
        if ($_POST['startdate']) {
            $startdate = filter($_POST['startdate'], 'startdate');
            if ($startdate != $ttime) {
                $parseDate = explode(' ', $startdate);
                $subDate = explode('.', $parseDate[0]);
                if (isset($parseDate[1])) {
                    $subTime = explode(':', $parseDate[1]);
                } else {
                    $subTime[0] = 12;
                    $subTime[1] = 0;
                }
                $startdate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            }
        } else {
            $startdate = '';
        }
        if ($_POST['enddate']) {
            $enddate = filter($_POST['enddate'], 'enddate');
            if ($enddate != $ttime) {
                $parseDate = explode(' ', $enddate);
                $subDate = explode('.', $parseDate[0]);
                if (isset($parseDate[1])) {
                    $subTime = explode(':', $parseDate[1]);
                } else {
                    $subTime[0] = 12;
                    $subTime[1] = 0;
                }
                $enddate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            }
        } else {
            $enddate = '';
        }
        if ($tag && $desc) {
            if (isset($_POST['edit'])) {
                $core->upd_data('banners', '`tag` ="' . $tag . '",`desc` ="' . $desc . '",`urltitle` ="' . $urltitle . '",`urlsb` ="' . $urlsb . '",`urlimg` ="' . $urlimg . '", `code` ="' . $code . '", `allow_views` ="' . $allow_views . '", `max_views` ="' . $max_views . '", `allow_clicks` ="' . $allow_clicks . '", `max_clicks` ="' . $max_clicks . '", `active` ="' . $active . '",`random` ="' . $random . '", `main` ="' . $main . '", `inprofile` ="' . $inprofile . '", `innews` ="' . $innews . '", `startdate` ="' . $startdate . '", `enddate` ="' . $enddate . '"', 'id ="' . $id . '"');
                $core->ins_log(false, $lang['logs_edit_banners'], 1, false, false, $desc);
                action_alert('root', 'success', 'banners', false, 'banners_edit_ok');
            } else {
                $core->ins_data('banners', 'id,desc,urltitle,urlsb,urlimg,code,allow_views,views,max_views,allow_clicks,clicks,max_clicks,main,startdate,enddate,inprofile,innews,active,tag,random', 'NULL,"' . $db->safesql(processText($desc)) . '","' . $urltitle . '","' . $urlsb . '","' . $urlimg . '","' . $code . '","' . $allow_views . '",0,"' . $max_views . '","' . $allow_clicks . '",0,"' . $max_clicks . '","' . $main . '","' . $startdate . '","' . $enddate . '","' . $inprofile . '","' . $innews . '","' . $active . '","' . $db->safesql(processText($tag)) . '","' . $random . '"');
                $core->ins_log(false, $lang['logs_add_banners'], 1, false, false, $desc);
                action_alert('root', 'success', 'banners', false, 'banners_add_ok');
            }
        } else {
            action_alert('root', 'danger', 'banners', 'add', 'not_field');
        }
        break;
    case 'delete':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if ($id) {
            delBanners($id);
            action_alert('root', 'success', 'banners');
        } else {
            action_alert('root', 'danger', 'banners', false, 'unknown_error');
        }
        break;
    case 'clear':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if ($id) {
            clearBanners($id);
            action_alert('root', 'success', 'banners');
        } else {
            action_alert('root', 'danger', 'banners', false, 'unknown_error');
        }
        break;
    case 'retivate':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('banners', 'id ="' . $id . '"');
            $active = $rows['active'] == 0 ? 1 : 0;
            $core->upd_data('banners', 'active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_banners'], 1, false, false, $rows['urltitle']);
            action_alert('root', 'success', 'banners');
        } else {
            action_alert('root', 'danger', 'banners', false, 'unknown_error');
        }
        break;
    case 'random':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('banners', 'id = ' . $id);
            $random = $rows['random'] == 0 ? 1 : 0;
            $core->upd_data('banners', 'random ="' . $random . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_banners'], 1, false, false, $rows['urltitle']);
            action_alert('root', 'success', 'banners');
        } else {
            action_alert('root', 'danger', 'banners', false, 'unknown_error');
        }
        break;
    case 'restrictions':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('banners', 'id = ' . $id);
            $enddate = $rows['enddate'] ? 0 : $rows['enddate'];
            $active = $rows['enddate'] ? 1 : 0;
            $core->upd_data('banners', 'enddate ="' . $enddate . '", active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_banners'], 1, false, false, $rows['urltitle']);
            action_alert('root', 'success', 'banners');
        } else {
            action_alert('root', 'danger', 'banners', false, 'unknown_error');
        }
        break;
    case 'restviews':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('banners', 'id = ' . $id);
            $max_views = $rows['max_views'] ? 0 : $rows['max_views'];
            $active = $rows['max_views'] ? 1 : 0;
            $core->upd_data('banners', 'max_views ="' . $max_views . '", active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_banners'], 1, false, false, $rows['urltitle']);
            action_alert('root', 'success', 'banners');
        } else {
            action_alert('root', 'danger', 'banners', false, 'unknown_error');
        }
        break;
    case 'restclicks':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('banners', 'id = ' . $id);
            $max_clicks = isset($rows['max_clicks']) ? 0 : $rows['max_clicks'];
            $active = $rows['max_clicks'] ? 1 : 0;
            $core->upd_data('banners', 'max_clicks ="' . $max_clicks . '", active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_banners'], 1, false, false, $rows['urltitle']);
            action_alert('root', 'success', 'banners');
        } else {
            action_alert('root', 'danger', 'banners', false, 'unknown_error');
        }
        break;
    case 'clearviews':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        $rows = $core->row_data('banners', 'id = ' . $id);
        if (!empty($id)) {
            $core->upd_data('banners', 'views = 0', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_clearcounter_banners'], 1, false, false, $rows['urltitle']);
            action_alert('root', 'success', 'banners');
        } else {
            action_alert('root', 'danger', 'banners', false, 'unknown_error');
        }
        break;
    case 'clearclicks':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        $rows = $core->row_data('banners', 'id = ' . $id);
        if (!empty($id)) {
            $core->upd_data('banners', 'clicks = 0', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_clearcounter_clicks_banners'], 1, false, false, $rows['urltitle']);
            action_alert('root', 'success', 'banners');
        } else {
            action_alert('root', 'danger', 'banners', false, 'unknown_error');
        }
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'Activate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('banners', 'active = 1', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'banners');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('banners', 'active = 0', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'banners');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('banners', 'active = NOT `active`', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'banners');
                    }
                    break;
                case 'Random':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('banners', 'random = 1', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'banners');
                    }
                    break;
                case 'reRestrictions':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('banners', 'enddate = 0, active = 1', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'banners');
                    }
                    break;
                case 'reRestViews':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('banners', 'max_views = 0, active = 1', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'banners');
                    }
                    break;
                case 'reRestClicks':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('banners', 'max_ckicks = 0, active = 1', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'banners');
                    }
                    break;
                case 'clearViews':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('banners', 'views = 0', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'banners');
                    }
                    break;
                case 'clearClicks':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('banners', 'clicks = 0', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'banners');
                    }
                    break;
                case 'Delete':
                    foreach ($_POST['checks'] as $id) {
                        delBanners(intval($id));
                        action_alert('root', 'success', 'banners');
                    }
                    break;
                case 'Clear':
                    foreach ($_POST['checks'] as $id) {
                        clearBanners(intval($id));
                        action_alert('root', 'success', 'banners');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'banners');
        }
        break;
    case 'status_clicks':
        InitCheck();
        init_count_text();
        $url_flags = '';
        $order = 'time DESC';
        $query = $core->select_data('banners_ips', false, $order . ' LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['banners_status_clicks']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('banners');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $lang['banners_status_clicks_list'] . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th>' . $lang['date'] . '</th>
                        <th></th>
                        <th>' . $lang['url'] . '</th>
                        <th></th>
                        <th>' . $lang['banners_url'] . '</th>
                        <th class="text-center">' . faSpan('fa-hand-pointer-o', true, false, false, $lang['banners_clicks']) . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($row = $db->getRow($query)) {
                $startdate = $rows['startdate'] ?? '';
                $rows = $core->row_data('banners', 'id ="' . $row['bid'] . '"');
                $id = $rows['id'] ?? false;
                $qrows = $core->row_data('banners_ips', 'bid ="' . $row['bid'] . '" AND ip ="' . $row['ip'] . '"');
                $user = $core->row_data('users', 'id ="' . $row['uid'] . '"');
                $geoip = geo_ip::getInstance(ROOT . 'media/geo_ip.dat');
                $flag = $geoip->lookupCountryCode(!empty($row['ip']) ? $row['ip'] : '127.0.0.1');
                foreach ($smiles as $tag => $param) {
                    if ($param['cat'] == 'flags') {
                        $saurl = str_replace($config['url'] . '/', '', $param['url']);
                        $surl = trimtitle($param['url'], 30);
                        $abridged = isset($param['abridged']) ? ' ( ' . $param['abridged'] . ' )' : '';
                        if ($flag == $param['abridged']) $url_flags = '<img src="' . $param['url'] . '" title="' . $param['title'] . $abridged . '" class="img-responsive mw30 ib br4" style="border:0" alt=""/>';
                    } else {
                        $url_flags = '';
                    }
                }
                $uflag = ($flag != 'UN') ? $url_flags : '<img src="media/smiles/flags/UN.png" style="border:0" class="img-responsive mw30 ib br4"  title="' . $lang['undefined'] . '" alt="">';
                $no_time_limit = faSpan('fa-window-minimize', true, false, false, $lang['no_time_limit']);
                $startdate = $startdate ? date('d-m-y', $startdate) : $no_time_limit;
                $aut = $user['nick'] ?? $row['ip'];
                $desc = $rows['desc'] ?? '';
                $urlsb = $rows['urlsb'] ?? '';
                $urltitle = $rows['urltitle'] ?? '';
                $urlimg = $rows['urlimg'] ?? '';
                $clicks = $rows['clicks'] ?? '';
                $redir = $row['redir'] ?? '';
                $time = $row['time'] ?? null;
                $del_ip = $row['ip'] ?? '';
                $code = $rows['code'] ?? '';
                $codeviews = str_replace(array('\n', '\n', '""', '""', '&lt;', '&gt;', '{%urlb%}', '{%urltitle%}', '{%urlimg%}'), array('<br>', '<br/>', '\p', '\n', '<', '>', $urlsb, $urltitle, $urlimg), $code);
                if (!$del_ip) $core->del_data('banners_ips', 'redir =""');
                echo '<tr>
                        <td>' . formatDate($time, true) . '</td>
                        <td><span class="pd-l-sm">' . $uflag . '</span></td>
                        <td ' . toggle($redir) . '>' . $aut . '<br/>' . trimtitle($redir, 50) . '</td>
                        <td><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-view' . $id . '\')">' . faSpan('fa-arrow-right', true, false, false, $lang['do_transition']) . '</a></td>
                        <td ' . toggle($urlsb) . '>' . trimtitle($urlsb, 50) . '</td>
                        <td class="text-center">' . formatCounter($clicks) . '</td>
                        <td class="text-center">' . status_icon('banners', $id, 'banners') . '</td>';
                init_checkbox('td', $id, false, '<li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-view' . $id . '\')">' . faSpan('fa-television', true, $lang['view']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/clearviews/' . $id . '">' . faSpan('fa-eraser', true, $lang['banners_clear_views']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/clearclicks/' . $id . '">' . faSpan('fa-eraser', true, $lang['banners_clear_clicks']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $id . '\')">' . faSpan('fa-recycle text-danger', true, $lang['banners_clear']) . '</a></li>');
                echo '</tr>';
                modal_form_delete($id, $desc, $lang['banners_clear_desc'], 'banners', $lang['banners_clear_text'], '{ADMIN_LINK}/clear/' . $id, false, true);
                modal_form_text('view' . $id, $lang['info'], 'fa-desktop', false, '<fieldset style="border-style:solid; border-width:1px; border-color:#000000;">' . $codeviews . '</fieldset>');
            }
            echo '</tbody>';
            init_tfoot('<option value="clearViews">' . $lang['banners_clear_views'] . '</option>
                               <option value="clearClicks">' . $lang['banners_clear_clicks'] . '</option>
                               <option value="Clear">' . $lang['banners_clear'] . '</option>');
            echo '</table>
            </form>
         </div>
      </div>';
            page_list('root', 'banners', 'banners_ips', false, 'status_clicks');
        } else {
            $adminTpl->info($lang['banners_status_clicks_empty'], 'empty', null, $lang['banners_status_clicks_list']);
        }
        echo '</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'stats_views':
        init_count_text();
        $adminTpl->admin_head($lang['banners_stats'] . $lang['do_clicks']);
        stats_choice('views');
        $adminTpl->admin_foot();
        break;
    case 'stats_clicks':
        init_count_text();
        $adminTpl->admin_head($lang['banners_stats'] . $lang['do_clicks']);
        stats_choice('clicks');
        $adminTpl->admin_foot();
        break;
    case 'ajax':
        case_ajax('banners');
        break;
}
function stats_choice($choice): void
{
    global $core, $adminTpl, $lang, $db;
    $urltitle = '';
    $numb = '';
    $query = $core->select_data('banners', false, 'id ASC');
    while ($rows = $db->getRow($query)) {
        $text = rtrim($rows['urltitle'], "\n\r");
        $urltitle .= '"' . $text . '", ';
        $numb .= $rows[$choice] . ', ';
    }
    $urltitle = substr($urltitle, 0, -2);
    $numb = substr($numb, 0, -2);
    init_count_text();
    $adminTpl->admin_head($lang['banners_stats'] . $lang['do_' . $choice]);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
   <div class="panel panel-info panel-border top">
      <div class="panel-heading"><span class="panel-title">' . $lang['banners_stats'] . $lang['do_' . $choice] . '</span>
      </div>
      <div class="heading-hr"></div>
      <div class="panel-body">
         <p class="p2">
         <div id="result" style="min-width: 310px; max-width: 800px; height: 200px; margin: 0 auto"></div>';
        poolHighCharts('result', $urltitle, $lang['polls_people'], $lang['banners_' . $choice], $numb);
        echo '</p>
      </div>
      <div class="panel-footer-lines"></div>
   </div>
</div>
</div>';
    } else {
        $adminTpl->info($lang['banners_empty'], 'empty', null, $lang['banners_stats'] . $lang['do_' . $choice], $lang['banners_add'], ADMIN . '/banners/add', 'url', $lang['banners_help'], null, null, $lang['banners_help_desc'], true);
    }
}

function add($id = null): void
{
    global $adminTpl, $core, $lang;
    $rows = $core->row_data('banners', 'id ="' . $id . '"');
    if (isset($id)) {
        $startdate = !empty($rows['startdate']) ? gmdate('d.m.Y H:i', intval($rows['startdate'])) : '';
        $enddate = !empty($rows['enddate']) ? gmdate('d.m.Y H:i', intval($rows['enddate'])) : '';
        $tags = '<div class="form-group">
   <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_tag'] . '</label>
   <div class="col-md-5">
      <label for="vars" class="field prepend-icon">
         <pre><code>[' . $rows['tag'] . '] {%' . $rows['tag'] . '%} [/' . $rows['tag'] . ']</code></pre>
      </label>
   </div>
</div>';
        $tag = $rows['tag'];
        $desc = $rows['desc'];
        $max_views = $rows['max_views'];
        $max_clicks = $rows['max_clicks'];
        $urlsb = $rows['urlsb'];
        $urlimg = $rows['urlimg'];
        $urltitle = $rows['urltitle'];
        $allow_views = $rows['allow_views'];
        $allow_clicks = $rows['allow_clicks'];
        $active = $rows['active'];
        $random = $rows['random'];
        $main = $rows['main'];
        $inprofile = $rows['inprofile'];
        $innews = $rows['innews'];
        $code = $rows['code'];
        $admhead = $lang['banners_edit'];
    } else {
        $startdate = isset($_POST['startdate']) ? filter($_POST['startdate']) : '';
        $enddate = isset($_POST['enddate']) ? filter($_POST['enddate']) : '';
        $tags = '';
        $tag = '';
        $desc = '';
        $max_views = 0;
        $max_clicks = 0;
        $urlsb = '';
        $urlimg = '';
        $urltitle = '';
        $allow_views = '';
        $allow_clicks = '';
        $active = '';
        $random = '';
        $main = '';
        $inprofile = '';
        $innews = '';
        $code = '';
        $admhead = $lang['banners_add'];
    }
    $validation_array = array(
        'desc' => array(
            'required' => array('true', $lang['add_descr_err']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
    );
    validationInit($validation_array);
    init_count_text();
    datetimepickerInit('startdate', 'date');
    datetimepickerInit('enddate', 'date');
    $adminTpl->js_code[] = '$("#max_views").spinner();$("#max_clicks").spinner();';
    $adminTpl->admin_head($admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
         <div class="panel panel-dark panel-border top">
            <div class="panel-heading">
              <span class="panel-title">' . $admhead . '</span>
            </div>
   <div class="heading-hr"></div>
     <div class="panel-body admin-form">
      <form id="admin-form" class="form-horizontal parsley-form" role="form" action="{ADMIN_LINK}/save" method="post">
         <div class="form-group">
               <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_position'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label class="field select">
                  <select id="tag" name="tag" class="form-control">
                  <option value="banners_head"' . ($tag == 'banners_head' ? ' selected' : '') . '>' . $lang['banners_head'] . '</option>
                  <option value="banners_left"' . ($tag == 'banners_left' ? ' selected' : '') . '>' . $lang['banners_left'] . '</option>
                  <option value="banners_right"' . ($tag == 'banners_right' ? ' selected' : '') . '>' . $lang['banners_right'] . '</option>
                  <option value="banners_footer"' . ($tag == 'banners_footer' ? ' selected' : '') . '>' . $lang['banners_footer'] . '</option>
                  </select>
                  ' . faI('arrow double') . '
                  </label>
               </div>
            </div>
            <div class="form-group">
                  <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_desc_field'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="desc" class="field prepend-icon">
                     <textarea id="desc" name="desc" onkeyup="count_down(this, \'desc\', 200)" maxlength="200" placeholder="' . $lang['banners_desc_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $desc . '</textarea>
                     <label for="desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                     </label>
                  <div style="text-align:right" class="text-right">
                      <span id="char_desc"></span>
                  </div>
                  </div>
                  </div>
            ' . $tags . '
            <div class="form-group">
              <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_date_views'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="startdate" class="field prepend-icon">
                  <input id="startdate" name="startdate" type="text" placeholder="' . $lang['banners_list_start'] . '" class="form-control"  style="width:205.5px;" value="' . $startdate . '">
                  <input id="enddate" name="enddate" type="text" placeholder="' . $lang['banners_list_end'] . '" class="form-control" style="width:205.5px;"  value="' . $enddate . '">
                  <label for="startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                  </label>
                  <span class="input-footer text-left">' . faI('fa-bell') . $lang['banners_empty_date'] . '</span>
               </div>
            </div>
            <div class="form-group">
                <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_url'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="urlsb" class="field prepend-icon">
                  <input id="urlsb" type="text" name="urlsb" value="' . $urlsb . '" placeholder="' . $lang['banners_url_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                  <label for="urlsb" class="field-icon">' . faI('fa-globe', false, false, true) . '</label>
                  </label>
               </div>
            </div>
            <div class="form-group">
                <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_url_img'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="urlimg" class="field prepend-icon">
                  <input id="urlimg" type="text" name="urlimg" value="' . $urlimg . '" placeholder="' . $lang['banners_url_img_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                  <label for="urlimg" class="field-icon">' . faI('fa-link', false, false, true) . '</label>
                  </label>
               </div>
            </div>
            <div class="form-group">
                <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_url_title'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="urltitle" class="field prepend-icon">
                  <input id="urltitle" type="text" name="urltitle" value="' . $urltitle . '" placeholder="' . $lang['banners_url_title_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                  <label for="urltitle" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                  </label>
               </div>
            </div>
            <div class="form-group">
               <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_code'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="code" class="field prepend-icon">
                  <textarea name="code" id="code" placeholder="' . $lang['banners_code_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto" data-parsley-required="true" data-parsley-trigger="change">' . $code . '</textarea>
                  <label for="code" class="field-icon">' . faI('fa-code', false, false, true) . '</label>
                  </label>
              <span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['banners_info']) . '</span>
               </div>
                   <span class="col-sm-1 input-group-addon">  ' . info_modal('template') . '</span>
            </div>           
            <div class="form-group">
               <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_views'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label class="field select">
                  <select id="allow_views" name="allow_views" class="form-control">
                  <option value="0"' . ($allow_views == '0' ? ' selected' : '') . '>' . $lang['do_deactivation'] . '</option>
                  <option value="1"' . ($allow_views == '1' ? ' selected' : '') . '>' . $lang['banners_account_views'] . '</option>
                  <option value="2"' . ($allow_views == '2' ? ' selected' : '') . '>' . $lang['banners_account_views_x'] . '</option>
                  </select>
                  ' . faI('arrow double') . '
                  </label>
               </div>
            </div>
              <div class="form-group pt10">
                <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_mviews'] . '</label>
              <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="max_views" class="field prepend-icon">
                  <div class="input-group">
                  <input id="max_views" type="text" name="max_views" value="' . $max_views . '" class="form-control ui-spinner-input" data-parsley-required="true" data-parsley-trigger="change" style="width:137px;height: 45px;">
                 </div>
                  <label for="max_views" class="field-icon"></label>
                  </label>
                  <span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['banners_mviews_info']) . '</span>
               </div>
            </div>
            <div class="form-group">
               <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_clicks'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label class="field select">
                  <select id="allow_clicks" name="allow_clicks" class="form-control">
                  <option value="0"' . ($allow_clicks == '0' ? ' selected' : '') . '>' . $lang['do_deactivation'] . '</option>
                  <option value="1"' . ($allow_clicks == '1' ? ' selected' : '') . '>' . $lang['banners_account_clicks'] . '</option>
                  <option value="2"' . ($allow_clicks == '2' ? ' selected' : '') . '>' . $lang['banners_account_clicks_x'] . '</option>
                  </select>
                  ' . faI('arrow double') . '
                  </label>
               </div>
            </div>
              <div class="form-group">
                <label class="col-lg-3 col-sm-3 control-label">' . $lang['banners_mclicks'] . '</label>
              <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="max_clicks" class="field prepend-icon">
                  <div class="input-group">
                  <input id="max_clicks" type="text" name="max_clicks" value="' . $max_clicks . '" class="form-control ui-spinner-input" data-parsley-required="true" data-parsley-trigger="change" style="width:137px;height: 45px;">
                 </div>
                  <label for="max_clicks" class="field-icon"></label>
                  </label>
                  <span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['banners_mclicks_info']) . '</span>
               </div>
            </div>
               <div class="form-group">
                  <div class="col-xs-6 mbn15">
                  ' . scheckbox('active', $active, $lang['banners_on'], true, false, 1, true) . '
                  </div>
               </div>
                 <div class="form-group">
                  <div class="col-xs-6 mbn15">
                  ' . scheckbox('random', $random, $lang['banners_random'], true, false, 1, true) . '
                  </div>
               </div>
               <div class="form-group">
                  <div class="col-xs-6 mbn15">
                  ' . scheckbox('main', $main, $lang['banners_main'], true, false, 1) . '
                  </div>
               </div>            
               <div class="form-group">
                  <div class="col-xs-6 mbn15">
                  ' . scheckbox('inprofile', $inprofile, $lang['banners_inprofile'], true, false, 1) . '
                  </div>
               </div>               
                 <div class="form-group">
                  <div class="col-xs-6 mbn15">
                  ' . scheckbox('innews', $innews, $lang['banners_innews'], true, false, 1) . '
                  </div>
               </div>
        </div>
   ' . init_dfoot(true, 'fa-floppy-o', 'save', 'system');
    modal_form_text('template', $lang['info'], 'fa-info-circle', $lang['banners_templ'], false, $lang['banners_template']);
    if (isset($id)) {
        echo ' <input type = "hidden" name = "edit" value = "1">
      <input type = "hidden" name = "id" value = "' . $id . '"> ';
    }
    echo '</form>
   </div>
</div> ';
    $adminTpl->admin_foot();
}

function delBanners($id): void
{
    global $core, $lang;
    $banners = $core->row_data('banners', 'id = "' . $id . '"');
    $core->del_data('banners', 'id = "' . $id . '"');
    $core->del_data('banners_ips', 'bid = "' . $id . '"');
    $core->ins_log(false, $lang['logs_delete_banners'], 1, false, false, $banners['tag']);
}

function clearBanners($id): void
{
    global $core, $lang;
    $banners = $core->row_data('banners', 'id = "' . $id . '"');
    $core->del_data('banners_ips', 'bid = "' . $id . '"');
    $core->ins_log(false, $lang['logs_clear_banners'], 1, false, false, $banners['tag']);
    if (!$banners['urlsb']) $core->del_data('banners_ips');
}