<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

global $configBox;
if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $config, $page, $core, $url, $lang;
Langblocks();
switch ($url[2] ?? null) {
    default:
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        $where = '';
        $Cwhere = '';
        $order = '';
        $_type = $core->row_data('blocks_types', false, 'title ASC');
        $_types[$_type['type']] = $_type['title'];
        $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
        $s_title = $_POST['s_title'] ?? '';
        $s_desc = $_POST['s_desc'] ?? '';
        $s_active = isset($_POST['s_active']);
        $s_search = isset($_POST['s_search']);
        if ($s_search) {
            if ($_POST['s_search'] == 1) {
                location('{ADMIN_LINK}/');
            } else {
                $s_search = false;
            }
        } else {
            $s_search = true;
        }
        if ($s_active) {
            $Cwhere = 'service ="blocks" AND ';
            if ($_POST['s_active'] == 1) {
                $where = 'active = 1';
            } else {
                $s_active = false;
                $where = 'active = 0';
            }
        } else {
            $s_active = true;
            $Cwhere = 'service ="blocks" ';
        }
        if ($s_id) {
            $where .= "AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
        } else {
            $s_id = '';
        }
        if ($s_title) $where .= "AND `title` LIKE '%" . $db->safesql($s_title) . "%'";
        if ($s_desc) $where .= "AND `content` LIKE '%" . $db->safesql($s_desc) . "%'";
        if (isset($url[2]) && $url[2] == 'order') {
            switch ($url[3]) {
                case 'abc':
                    $order .= 'title ASC';
                    break;
                case 'type':
                    $order .= 'type DESC';
                    break;
                case 'id':
                    $order .= 'id ASC';
                    break;
            }
        } else {
            $order = 'type ASC, priority ASC';
        }
        $query = $core->select_data('plugins', $Cwhere . $where, $order . ' LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['blocks']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('blocks');
            if (!$s_search) {
                echo '<div class="panel panel-dark panel-border top">
            <div class="panel-heading"><span class="panel-title">' . $lang['blocks'] . ':</span>
            </div>
            <div class="heading-hr"></div>
            <div class="panel-body pn table-responsive">
               <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
                  <table class="table table-striped" id="blockBox">';
                blockList();
                while ($result = $db->getRow($query)) {
                    modal_form_delete($result['id'], $result['title'], $lang['block_delete_title'], 'block', $lang['block_delete_text'], '{ADMIN_LINK}/delete/' . $result['id']);
                }
                echo '</table>
               </form>
            </div>
         </div>';
            } else {
                echo '<div class="panel panel-dark panel-border top">
         <div class="heading-hr"></div>
         <div class="panel-heading">
            <span class="panel-title">' . $lang['blocks'] . ':</span>
           ' . sort_head('root', 3, 'type') . '
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
<table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="col-md-2 text-left"></th>
                        <th class="col-md-7 text-left">' . $lang['title'] . '</th>
                         <th class="text-center">' . $lang['status'] . '</th>
                        </tr>
                  </thead>
                  <tbody>
               </table>
               <div class="dc">
                  <ol class="dc-list">';
                echo ShowTree('blocks', $order);
                echo '</ol>
               </div>
            </div>
            <div class="panel-footer-lines">
            </div>
         </div>
         <script src ="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
         <script src ="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
         <script>
            $(\'.sortable-ul\').sortable({
            stop: function() {
                $.ajax({
                    url: \'/administration/blocks/save_priority\',
                    method: \'post\',
                    data: $(\'.sortable-ul input\').serialize()
                });
            }
            });
         </script>';
            }
            page_list('root', 'blocks', 'plugins', 'service="blocks"', 'type ASC, priority ASC');
            echo '</div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['blocks_pre_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['titles'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['tagcode_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
              <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active"' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['block_actives'] . '</label>
             </div>
            ' . init_sfoot(true, true) . '
         </div>
      </form>
   </aside>
</div>';
        } else {
            list_empty('root', 'blocks', 'url', $s_search, false, true, $s_search);
        }
        echo '</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'add':
        if (isset($url[3])) {
            $bid = intval($url[3]);
            $bl = $core->row_data('plugins', 'id ="' . $bid . '"');
            if (!$bl) location('/{ADMIN_LINK}');
            $bb = new bb;
            $title = prepareTitle($bl['title']);
            $bfile = $bl['file'];
            $type = $bl['type'];
            $content = $bb->htmltobb($bl['content']);
            $active = $bl['active'];
            $posit = $bl['priority'];
            $unshow = $bl['unshow'];
            $free = $unshow ? 0 : $bl['free'];
            $modArrDb = $unshow ? explode(',', $bl['unshow']) : explode(',', $bl['showin']);
            $grroups = explode(',', $bl['groups']);
            $admhead = $lang['block_edit'];
        } else {
            $title = '';
            $bfile = '';
            $type = '';
            $content = '';
            $modArrDb = array('_all');
            $active = true;
            $free = 0;
            $unshow = 0;
            $posit = 0;
            $grroups = array();
            $admhead = $lang['block_add'];
        }
        $validation_array = array(
            'name' => array(
                'required' => array('true', $lang['add_title_err']),
                'maxlength' => array(29, str_replace('[count]', '30', $lang['count_text_err_2']))
            ),
        );
        validationInit($validation_array);
        init_count_text();
        $adminTpl->js_code[] = '$("#posit").spinner();';
        $adminTpl->admin_head((isset($bid) ? $lang['edit'] : $lang['add']) . ' ' . $lang['bblock']);
        echo '<div id="content" class="table-layout animated fadeIn">
           <div class="tray tray-center">';
        alert_info('blocks');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
             <span class="panel-title">' . $admhead . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body admin-form">
          <form id="admin-form" action="{ADMIN_LINK}/save" method="post" role="form" class="form-horizontal parsley-form" data-parsley-validate>
            <div class="form-group">
               <label for="name" class="col-lg-3 col-sm-3 control-label">' . $lang['title'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="name" class="field prepend-icon">
                  <input id="name" type="text" name="name" value="' . $title . '" onkeyup="count_down(this, \'name\', 30)" maxlength="30" placeholder="' . $lang['block_title_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                  <label for="name" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                  </label>
                  <div style="text-align:right" class="text-right">
                      <span id="char_name"></span>
                  </div>
               </div>
            </div>
            <div class="form-group">
               <label class="col-sm-3 control-label">' . $lang['block_file'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8 mbn15">
                <label class="field select mb15">
                  <select class="form-control" name="file" id="file">
                  <option value=""' . ($bfile == '' ? 'selected' : '') . ">" . $lang['block_file_without'] . '</option>';
        $path = ROOT . 'usr/blocks/';
        $dh = opendir($path);
        $c = 0;
        while ($file = readdir($dh)) {
            if (is_file($path . $file) && $file != '.' && $file != '..' && $file != '.htaccess') {
                $select = ($bfile == $file) ? 'selected' : '';
                echo '<option value="' . $file . '"' . $select . '>' . $file . '</option>';
            }
        }
        closedir($dh);
        echo ' </select>
                  ' . faI('arrow double') . '
                  </label>
               </div>
            </div>
            <div class="form-group">
               <label class="col-sm-3 control-label">' . $lang['block_destanation'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8 mbn15">
               <label class="field select mb15">
                  <select class="form-control" name="type" id="type">
                  <option value="">' . $lang['absents'] . '</option>';
        $query = $core->select_data('blocks_types', false, 'type');
        while ($rows = $db->getRow($query)) {
            $select = ($type == $rows['type']) ? 'selected' : '';
            echo '<option value="' . $rows['type'] . '"' . $select . '>' . $rows['title'] . ' [' . $rows['type'] . ']</option>';
        }
        echo '</select>
                        ' . faI('arrow double') . '
                     </label>
               </div>
            </div>
            <div class="form-group">
               <label class="col-sm-3 control-label">' . $lang['block_groups'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8 mbn15">
               <label class="field select mb15">
                  <select class="form-control" name="groups[]" id="group" >
                  <option value=""' . (empty($grroups) ? 'selected' : '') . '>' . $lang['group_all'] . '</option>';
        $gquery = $core->select_data('groups', false, 'admin DESC,moderator DESC,user DESC,guest DESC,banned DESC');
        while ($rows = $db->getRow($gquery)) {
            $selected = in_array($rows['id'], $grroups) ? "selected" : "";
            echo '<option value="' . $rows['id'] . '"' . $selected . '>' . $rows['name'] . '</option>';
        }
        echo '</select>
                        ' . faI('arrow double') . '
                     </label>
               </div>
            </div>
            <div class="form-group">
               <label class="col-sm-3 control-label">' . $lang['modules'] . '</label>
               <div class="panel-body admin-form" style="padding:0;">
                  <div class="col-lg-9 col-md-9 col-sm-12">';
        foreach (glob(ROOT . 'usr/modules/*/index.php') as $dir) {
            $dir_a = explode('/', $dir);
            $fileArr[] = $dir_a[count($dir_a) - 2];
        }
        $limitCheck = ceil(count($fileArr) / 3);
        $i = 0;
        echo '<div style="float:left; width:280px;">';
        foreach ($fileArr as $file) {
            $i++;
            echo scheckbox('mod[]', (in_array($file, $modArrDb) == 1 ? 1 : ''), _mName($file), false, true, $file);
            if ($i == $limitCheck) {
                $i = 0;
                echo '</div>
                     <div style="float:left; width:280px;">';
            }
        }
        echo '</div>
                  </div>
                  </div>
            <div class="form-group">
                <label class="col-lg-3 col-sm-3 control-label">' . $lang['block_pos'] . '</label>
              <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="posit" class="field prepend-icon">
                  <div class="input-group">
                  <input id="posit" type="text" name="posit" value="' . $posit . '" class="form-control ui-spinner-input" data-parsley-required="true" data-parsley-trigger="change" style="width:137px;height: 45px;">
                 </div>
                 <span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['block_numb_info']) . '</span>
                </label>
               </div>
            </div>
               <div class="form-group">
                  <div class="col-xs-6 mbn25">
                  ' . scheckbox('mod[]', (in_array('_index', $modArrDb) == 1 ? 1 : ''), $lang['block_index'], true, false, '_index') . '
                  </div>
               </div>
               <div class="form-group">
                  <div class="col-xs-6 mbn25">
                  ' . scheckbox('mod[]', ($free == 1 ? 1 : ''), $lang['block_free'], true, false, '_free') . '
                  </div>
               </div>
               <div class="form-group">
                  <div class="col-xs-6 mbn25">
                  ' . scheckbox('mod[]', ($unshow != '' ? 1 : ''), $lang['block_unshow'], true, false, '_noChecked') . '
                  </div>
               </div>
               <div class="form-group">
                  <div class="col-xs-6 mbn25">
                  ' . scheckbox('active', $active, $lang['block_on']) . '
                  </div>
               </div>
            </div>
            <div class="row">
        <div class="col-xs-12">
             <div class="tab-block mb25">
                     <div class="tab-content_editor">
                        <div id="contents" class="tab-pane active">
            ' . adminArea('contents', $content, 10, 'textarea', '', true) . '
                        </div>
                     </div>
                  </div>
              </div>
           </div>
        </div>
         <div class="panel-footer admin-form">';
        if (isset($bid)) echo '<input name="bid" value="' . $bid . '" type="hidden">';
        echo '<button name="submit" type="submit" id="sub" ' . btn_class('system', true) . '>' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
         </div>
      </div>
   </div>
   </form>
   </section>';
        $adminTpl->admin_foot();
        break;
    case 'save':
        $allowArray = array('_all', '_index');
        $title = isset($_POST['name']) ? filter(htmlspecialchars_decode($_POST['name']), 'title') : '';
        $file = isset($_POST['file']) ? filter($_POST['file'], 'a') : '';
        $type = isset($_POST['type']) ? filter($_POST['type'], 'a') : '';
        $content = isset($_POST['contents']) ? filter($_POST['contents'], 'html') : '';
        $posit = isset($_POST['posit']) ? intval($_POST['posit']) : '';
        $mod = $_POST['mod'] ?? '';
        $active = isset($_POST['active']) ? 1 : 0;
        $groups = $_POST['groups'] ?? 0;
        $bid = isset($_POST['bid']) ? intval($_POST['bid']) : 0;
        $unList = '';
        $modList = '';
        $free = 0;
        if (!empty($title) && (!empty($file) || !empty($content))) {
            if (!empty($mod)) {
                $i = 0;
                if (array_search('_noChecked', $mod)) $unSearch = true;
                if (is_numeric(array_search('_free', $mod))) $free = 1;
                if (isset($unSearch)) {
                    foreach ($mod as $module) {
                        if (trim($module) !== '' && in_array($module, $allowArray)) {
                            $i++;
                            $modList = $i == 1 ? $module : $modList . ',' . $module;
                        }
                    }
                    $u = 0;
                    foreach ($mod as $module) {
                        if (trim($module) !== '' && !in_array($module, $allowArray) && $module != '_noChecked') {
                            $u++;
                            $unList = $u == 1 ? $module : $unList . ',' . $module;
                        }
                    }
                } else {
                    foreach ($mod as $module) {
                        if (trim($module) !== '') {
                            $i++;
                            $modList = $i == 1 ? $module : $modList . ',' . $module;
                        }
                    }
                }
            } else {
                $modList = '_all';
            }
            $g = 0;
            $groupList = '';
            if (!empty($groups)) {
                foreach ($groups as $group) {
                    if (trim($group) !== '') {
                        $g++;
                        $groupList = $g == 1 ? $group : $groupList . ',' . $group;
                    }
                }
            }
            if (!$posit) {
                $rows = $core->row_data('plugins', 'type ="' . $db->safesql($type) . '"', 'priority DESC');
                $posit = isset($rows['priority']) ? $rows['priority'] + 1 : 0;
            }
            $bb = new bb;
            if ($bid) {
                $core->upd_data('plugins', '`title` ="' . $db->safesql(processText($title)) . '", `content` ="' . $db->safesql($bb->parse(processText($content), false, true)) . '", `file` ="' . $file . '", `priority` ="' . $posit . '", `type` ="' . $type . '", `showin` ="' . $modList . '", `unshow` ="' . $unList . '", `groups` ="' . $groupList . '", `free` ="' . $free . '", `template` ="", `active` ="' . $active . '"', 'id ="' . $bid . '"');
                $core->ins_log(false, $lang['logs_edit_blocks'], 1, false, false, $title);
                action_alert('root', 'success', 'blocks', false, 'block_edit_save');
            } else {
                $core->ins_data('plugins', 'id,title,content,file,priority,type,service,showin,unshow,groups,free,template,categories,xfields,menu,active', 'NULL,"' . $db->safesql(processText($title)) . '","' . $db->safesql($bb->parse(processText($content), false, true)) . '","' . $file . '","' . $posit . '","' . $type . '","blocks","' . $modList . '","' . $unList . '","' . $groupList . '","' . $free . '","",0,0,0,"' . $active . '"');
                $core->ins_log(false, $lang['logs_add_blocks'], 1, false, false, $title);
                action_alert('root', 'success', 'blocks', false, 'block_add_save');
            }
            delcache('plugins');
        } else {
            action_alert('root', 'danger', 'blocks', false, 'not_field');
        }
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'activate':
                    foreach ($_POST['checks'] as $id) {
                        $plugins = $core->row_data('plugins', 'id ="' . $id . '"');
                        $core->upd_data('plugins', 'active = 1', 'id ="' . $id . '"');
                        $core->ins_log(false, $lang['logs_change_status_blocks'], 1, false, false, $plugins['title']);
                        action_alert('root', 'success', 'blocks');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $plugins = $core->row_data('plugins', 'id ="' . $id . '"');
                        $core->upd_data('plugins', 'active = 0', 'id ="' . $id . '"');
                        $core->ins_log(false, $lang['logs_change_status_blocks'], 1, false, false, $plugins['title']);
                        action_alert('root', 'success', 'blocks');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id) {
                        $plugins = $core->row_data('plugins', 'id ="' . $id . '"');
                        $core->upd_data('plugins', 'active = NOT `active`', 'id ="' . $id . '"');
                        $core->ins_log(false, $lang['logs_change_status_blocks'], 1, false, false, $plugins['title']);
                        action_alert('root', 'success', 'blocks');
                    }
                    break;
                case 'Delete':
                    foreach ($_POST['checks'] as $id) {
                        $plugins = $core->row_data('plugins', 'id ="' . $id . '"');
                        $core->del_data('plugins', 'id ="' . $id . '"');
                        $core->ins_log(false, $lang['logs_delete_blocks'], 1, false, false, $plugins['title']);
                        action_alert('root', 'success', 'blocks');
                    }
                    break;
                case 'deleteType':
                    foreach ($_POST['checks'] as $id) {
                        $types = $core->row_data('blocks_types', 'type ="' . $id . '"');
                        $core->del_data('blocks_types', 'type ="' . $id . '"');
                        $core->ins_log(false, $lang['logs_delete_blocks'], 1, false, false, $types['title']);
                        action_alert('root', 'success', 'blocks');
                    }
                    break;
                case 'deleteBlockType':
                    foreach ($_POST['checks'] as $id) {
                        $types = $core->row_data('blocks_types', 'type ="' . $id . '"');
                        $core->del_data('plugins', 'type ="' . $id . '"');
                        $core->del_data('blocks_types', 'type ="' . $id . '"');
                        $core->ins_log(false, $lang['logs_delete_blocks'], 1, false, false, $types['title']);
                        action_alert('root', 'success', 'blocks');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'blocks');
        }
        delcache('plugins');
        break;
    case 'resort':
        $blocks = array();
        $query = $core->select_data('plugins', false, 'type ASC, priority ASC', 'id, type');
        if ($db->numRows($query) > 0) {
            while ($result = $db->getRow($query)) {
                $blocks[$result['type']][] = $result;
            }
            foreach ($blocks as $type => $inf) {
                $count[$type] = count($blocks[$type]);
                foreach ($inf as $number => $result) {
                    $core->upd_data('plugins', 'priority ="' . $number . '"', 'id ="' . $result['id'] . '"');
                }
            }
        }
        delcache('plugins');
        location(ADMIN . '/blocks');
        break;
    case 'standard':
        global $lang;
        init_count_text();
        $adminTpl->admin_head($lang['blocks'] . ' | ' . $lang['block_standart']);
        echo '<div id="content" class="table-layout animated fadeIn">
      <div class="tray tray-center">';
        alert_info('blocks/standard');
        echo '<div class="panel panel-info panel-border top mb35">
            <div class="panel-heading">
               <span class="panel-title">' . $lang['block_standart'] . '</span>
            </div>
                <div class="heading-hr"></div>
            <div class="list-bordered">
            <div class="row box-section table-responsive">
            <div class="container">';
        $zeroDirs = glob(ROOT . 'usr/blocks/config/*.config.php');
        $media = 'media/cats/';
        $_icon['auth.config.php'] = $media . 'key.png';
        $_icon['board.config.php'] = $media . 'chat.png';
        $_icon['bookmarks.config.php'] = $media . 'favorite.png';
        $_icon['calendar.config.php'] = $media . 'calender.png';
        $_icon['cats.config.php'] = $media . 'cats.png';
        $_icon['friends.config.php'] = $media . 'frend.png';
        $_icon['onlinfriends.config.php'] = $media . 'frend_onl.png';
        $_icon['guest.config.php'] = $media . 'adress_book.png';
        $_icon['lastcom.config.php'] = $media . 'comments.png';
        $_icon['online.config.php'] = $media . 'stat_user.png';
        $_icon['poll.config.php'] = $media . 'poll.png';
        $_icon['question.config.php'] = $media . 'tutorial.png';
        $_icon['search.config.php'] = $media . 'search.png';
        $_icon['statistics.config.php'] = $media . 'stats.png';
        $_icon['system.config.php'] = $media . 'statistics.png';
        $_icon['tags.config.php'] = $media . 'tag.png';
        $_icon['themes.config.php'] = $media . 'templ.png';
        $_icon['topnews.config.php'] = $media . 'news.png';
        $_icon['rss.config.php'] = $media . 'announcement.png';
        if (!empty($zeroDirs)) {
            foreach ($zeroDirs as $file) {
                $core->loadblockLang($file);
                $name_config = explode('usr/blocks/config/', $file);
                $name = mb_strtolower(end($name_config));
                $absolute = str_replace(array('/', '.config.php'), array('=', ''), $name);
                $_names[$name] = $lang['block_' . $absolute] ?? $name;
                $_descrripton[$name] = $lang['block_' . $absolute . '_descr'] ?? $name;
                echo '<div class="col-sm-4 media-list media-list-linked">
		<a class="media-link" onclick="document.location.href = \'{ADMIN_LINK}/standard_edit/' . $absolute . '\';">
			<div class="media-left"><img src="' . ($_icon[$name] ?? $_icon) . '" class="img-ma section_icon" alt=""></div>
			<div class="media-body">
				<h6 class="media-heading text-semibold text-left">' . ($_names[$name] ?? $name) . '</h6>
				<span class="text-muted text-size-small text-left">' . ($_descrripton[$name] ?? $_descrripton) . '</span>
			</div>
		</a>
	  </div>';
            }
        } else {
            action_alert('root', 'danger', 'blocks', 'types', 'unknown_error');
        }
        echo '</div>
         <div class="panel-footer-lines"></div>
      </div>
      </div>
      </div>
   </div>
</div>';
        delcache('plugins');
        $adminTpl->admin_foot();
        break;
    case 'standard_edit':
        $core->loadblockLang($url[3]);
        $adminTpl->admin_head($lang['blocks'] . ' |' . $lang['block_standart']);
        require(ROOT . 'etc/blocks/' . $url[3] . '.config.php');
        require(ROOT . 'usr/blocks/config/' . $url[3] . '.config.php');
        $ok = isset($_POST['conf_file']);
        generateConfigBLOCK($configBox, $url[3], '{ADMIN_LINK}/standard_edit/' . $url[3], $ok);
        $adminTpl->admin_foot();
        break;
    case 'types':
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        $where = '';
        $order = '';
        $i = 0;
        $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
        $s_title = $_POST['s_title'] ?? '';
        $s_type = $_POST['s_type'] ?? '';
        $s_search = isset($_POST['s_search']);
        if ($s_search) $s_search = $_POST['s_search'] == 1;
        if ($s_title) $where .= " `title` LIKE '%" . $db->safesql($s_title) . "%'";
        if ($s_type) $where .= " `type` LIKE '%" . $db->safesql($s_type) . "%'";
        if (isset($url[3]) && $url[3] == 'order') {
            switch ($url[4]) {
                case 'abc':
                    $order .= 'title ASC';
                    break;
                case 'type':
                    $order .= 'type DESC';
                    break;
            }
        } else {
            $order .= 'title DESC';
        }
        $query = $core->select_data('blocks_types', $where, $order . ' LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['blocks'] . ' | ' . $lang['block_type']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
      <div class="tray tray-center">';
            alert_info('block_types');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $lang['block_type'] . ':</span>
          ' . sort_head('root', 3, 'type', false, 'types') . '                
         </div>
         <div class="heading-hr"></div>
           <div class="panel-body pn table-responsive">
               <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
                  <table class="table table-xs table-striped">
                     <thead>
                        <tr>
                           <th><span class="pd-l-sm"></span>#</th>                      
                           <th class="col-md-4">' . $lang['title'] . '</th>
                           <th class="col-md-4">' . $lang['block_type'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                     </thead>
                     <tbody>';
            while ($result = $db->getRow($query)) {
                $i++;
                $command = 'document.querySelector(\'#copy_' . $result['type'] . '\').select(); document.execCommand(\'copy\'); notif(\'primary\', \'' . $lang['info'] . '\', \'' . $lang['copy_success'] . '\');';
                echo '<tr>
                           <td><span class="pd-l-sm"></span>' . $i . '</td>
                           <td>' . $result['title'] . '</td>
                           <td><p class="text-left mbn5" href="' . $result['type'] . '#copy" onclick="' . $command . '" title="' . $lang['tagcode_copy'] . ' {%BLOCKS:TYPE:' . $result['type'] . '%}">
                           <textarea id="copy_' . $result['type'] . '" style="width: 370px;  height: 40px; margin: 0; font-size: 12px;" class="form-control input-sm text-center" data-parsley-required="true" data-parsley-trigger="change">{%BLOCKS:TYPE:' . $result['type'] . '%}</textarea>
                           </p></td>';
                modal_form_delete($result['type'], $result['title'], $lang['block_delete_title'], 'block', $lang['block_delete_text'], '{ADMIN_LINK}/delType/' . $result['type']);
                echo '</td>';
                init_checkbox('td', $result['type'], false, '<li><a href = \'{ADMIN_LINK}/typeAdd/' . $result['type'] . '\'" target="_blank">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                            <li><a href="' . $core->fullURL() . '#copy" onclick="' . $command . '">' . faSpan('fa-files-o', true, $lang['tagcode_copy']) . '</a></li>
                            <li class="divider"></li>
                            <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $result['type'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                echo '</tr>';
            }
            echo '</tbody>';
            init_tfoot('<option value="deleteType">' . $lang['delete'] . '</option>
                               <option value="deleteBlockType">' . $lang['block_deletefrom_type'] . '</option>');
            echo '</table>
               </form>
            </div>
         </div>';
            page_list('root', 'blocks', 'blocks_types', false, 'types');
            echo '</div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
            <div class="section mb10">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['titles'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb25">
               <label for="s_type" class="field prepend-icon">
               <input id="s_type" type="text" name="s_type" placeholder="' . $lang['tagcode_pre_desc'] . '" class="form-control" value="' . $s_type . '">
               <label for="s_type" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
           ' . init_sfoot(true, true, $url[2]) . '
         </div>
       </form>
   </aside>
</div>';
        } else {
            $adminTpl->info($lang['blocks_types_list_empty'], 'empty', null, $lang['block_type_list'], $lang['block_type_add'], ADMIN . '/blocks/typeAdd');
        }
        echo '</div>
</div>';
        delcache('plugins');
        $adminTpl->admin_foot();
        break;
    case 'typeAdd':
        if (isset($url[3])) {
            $types = filter($url[3]);
            $t = $core->row_data('blocks_types', 'type ="' . $types . '"');
            $tit = $lang['block_edit_type'];
            $title = $t['title'];
            $type = $t['type'];
        } else {
            $tit = $lang['block_add_type'];
            $title = '';
            $type = '';
        }
        $validation_array = array(
            'title' => array(
                'required' => array('true', $lang['add_title_err']),
                'maxlength' => array(49, str_replace('[count]', '50', $lang['count_text_err_2']))
            ),
            'type' => array(
                'required' => array('true', $lang['add_type_err']),
                'maxlength' => array(99, str_replace('[count]', '100', $lang['count_text_err_2']))
            )
        );
        validationInit($validation_array);
        init_count_text();
        $adminTpl->admin_head($lang['blocks'] . ' |	' . $tit);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('blocks');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $tit . '</span>
         </div>
         <div class="heading-hr"></div>
            <form id="admin-form" action="{ADMIN_LINK}/saveType" method="post" role="form" class="form-horizontal parsley-form" data-parsley-validate>
          <div class="panel-body pn table-responsive">
            <div class="panel-body admin-form">
        <div class="form-group">
                  <label for="title" class="col-lg-3 col-sm-3 control-label">' . $lang['title'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="title" class="field prepend-icon">
                     <input id="title" type="text" name="title" value="' . $title . '" onkeyup="count_down(this, \'title\', 50)" maxlength="50" placeholder="' . $lang['block_title_type'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                     <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                     </label>
                     <div style="text-align:right" class="text-right">
                        <span id="char_title"></span>
                     </div>
                  </div>
               </div>
               <div class="form-group">
                  <label for="type" class="col-lg-3 col-sm-3 control-label">' . $lang['block_type'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="type" class="field prepend-icon">
                     <textarea id="type" name="type" onkeyup="count_down(this, \'type\', 100)" maxlength="100" placeholder="' . $lang['block_type_type'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $type . '</textarea>
                     <label for="type" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                     </label>
                     <div style="text-align:right" class="text-right">
                        <span id="char_type"></span>
                     </div>
                  </div>
               </div>';
        if (isset($id)) echo '<input name ="tid" value ="' . $id . '" type ="hidden">';
        echo '</div >
         <div class="panel-footer admin-form">
      <button name="submit" type="submit" id="sub" ' . btn_class('system', true) . '>' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
         </div>
      </div>
   </div>
</div>
</form>';
        delcache('plugins');
        $adminTpl->admin_foot();
        break;
    case 'saveType':
        $tid = isset($_POST['tid']) ? intval($_POST['tid']) : '';
        $title = isset($_POST['title']) ? filter($_POST['title'], 'a') : '';
        $type = isset($_POST['type']) ? filter(translit($_POST['type']), 'a') : '';
        if ($title && $type) {
            if (!isset($_POST['tid'])) {
                $core->ins_data('blocks_types', 'title,type', '"' . $title . '","' . $type . '"');
                $core->ins_log(false, $lang['logs_add_block_types'], 1, false, false, $title);
                action_alert('root', 'success', 'blocks', 'types', 'block_type_add_save');
            } else {
                $core->upd_data('blocks_types', 'title ="' . $title . '", type ="' . $type . '"', 'type ="' . $tid . '"');
                $core->ins_log(false, $lang['logs_edit_block_types'], 1, false, false, $title);
                action_alert('root', 'success', 'blocks', 'types', 'block_type_edit_save');
            }
            delcache('plugins');
        } else {
            action_alert('root', 'danger', 'blocks', 'typeAdd', 'not_field');
        }
        break;
    case 'delType':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if ($id) {
            delblocks($id);
            action_alert('root', 'success', 'blocks', 'types');
        } else {
            action_alert('root', 'danger', 'blocks', 'types', 'unknown_error');
        }
        break;
    case 'save_priority':
        $dbh = init_pdo();
        if (!empty($_POST['priority'])) {
            foreach ($_POST['priority'] as $i => $row) {
                $sth = $dbh->prepare("UPDATE `" . DB_PREFIX . "_plugins` SET `priority` = :priority WHERE `id` = :id");
                $sth->execute(array('priority' => ++$i, 'id' => intval($row)));
            }
        }
        break;
    case 'retivate':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('plugins', 'id ="' . $id . '"');
            $active = $rows['active'] == 0 || $rows['active'] == 2 ? 1 : 0;
            $core->upd_data('plugins', 'active ="' . $active . '"', 'id ="' . $id . '"');
            action_alert('root', 'success', 'blocks');
        } else {
            action_alert('root', 'danger', 'blocks', false, 'unknown_error');
        }
        break;
    case 'delete':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if ($id) {
            delblocks($id);
            action_alert('root', 'success', 'blocks');
        } else {
            action_alert('root', 'danger', 'blocks', false, 'unknown_error');
        }
        break;
}
function deltypes($id): void
{
    global $core, $lang;
    $types = $core->row_data('blocks_types', 'type ="' . $id . '"');
    $core->del_data('blocks_types', 'type ="' . $id . '"');
    $core->ins_log(false, $lang['logs_delete_block_types'], 1, false, false, $types['title']);
}

function delblocks($id): void
{
    global $core, $lang;
    $plugins = $core->row_data('plugins', 'id ="' . $id . '"');
    $core->del_data('plugins', 'id ="' . $id . '"');
    $core->ins_log(false, $lang['logs_delete_blocks'], 1, false, false, $plugins['title']);
}

function ShowTree($parent_id = 'blocks', $order = 'priority', $sublevelmarker = false)
{
    global $db, $core, $lang;
    $count = array();
    $blocks = array();
    $countType = array();
    $query = $core->select_data('plugins', '`service` = "' . $parent_id . '"', $order);
    if ($db->numRows($query) > 0) {
        while ($result = $db->getRow($query)) {
            $blocks[$result['type']][] = $result;
            $countType[$result['type']] = true;
        }
        $cat_item = '<div class="dc">
<ul class="sortable-ul panel-body">';
        foreach ($blocks as $type => $inf) {
            $count[$type] = count($inf);
            foreach ($inf as $result) {
                $sub_num = $core->sum_data('plugins', '`priority` ="' . $result['id'] . '"');
                $item_icon = $sub_num > 0 ? faSpan('fa-list-ul', false, false, false, 'Развернуть,свернуть или переместить') : faSpan('fa-list-ul');
                $cat_item .= '<li class="dc-item accordion-toggle" data-id="' . $result['id'] . '" data-toggle="collapse" data-parent="#accordion" href="#collapse_' . $result['id'] . '">
      <input type ="hidden" name ="position[]" value ="' . $result['id'] . '">
      <div class="dc-handle dd-handle">' . $item_icon . '</div>
      <div class="dc-content">
         <b>ID: ' . $result['id'] . '</b> ' . trimtitle($result['title'], 50) . '</b>
         <b class="dc-rcontent mn text-center pl10" style="left: 85%; position: absolute; margin: 0; top: 1px;">' . status_icon('plugins', $result['id'], 'plugins', false, true) . '</b>
         <div style="text-align:right" class="dc-rmenu text-right">
            <div class="btn-group">
               <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">' . faSpan('fa-caret-down', true, 'right', true) . '</a>
               <ul class="dropdown-menu text-left dropdown-menu-right">
               <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-view' . $result['id'] . '\')">' . faSpan('fa-television', true, $lang['view']) . '</a></li>       
               <li><a href="' . ADMIN . '/blocks/add/' . $result['id'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
               <li><a href="' . ADMIN . '/blocks/retivate/' . $result['id'] . '">' . (($result['active'] == 1 ? faSpan('fa-cogs', true, $lang['deactivate']) : faSpan('fa-cogs', false, $lang['activate']))) . '</a></li>
                  <li class="divider"></li>
               <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $result['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>
               </ul>
            </div>
         </div>
   </li>';
                $cat_item .= '<div id="collapse_' . $result['id'] . '" class="accordion-body collapse">' . ShowTree($result['id'], $order, true) . '</div>';
                modal_form_delete($result['id'], $result['title'], $lang['block_delete_title'], 'block', $lang['block_delete_text'], '{ADMIN_LINK}/delete/' . $result['id']);
                modal_form_text('view' . $result['id'], $lang['info'], 'fa-desktop', false, '
                        <p class="text-left">' . $lang['id'] . ':&emsp; ' . $result['id'] . '</p>
                        <p class="text-left">' . $lang['title'] . ':&emsp; ' . $result['title'] . '</p>
                        <p class="text-left">' . $lang['block_type'] . ':&emsp; ' . ($_types[$result['type']] ?? faSpan('fa-window-minimize', true, false, false, $lang['block_type_empty'])) . '</p>
                        <p class="text-left">' . $lang['template'] . ':&emsp;' . ($result['template'] ?: $lang['no']) . '</p>
                        <p class="text-left">' . $lang['block_file'] . ':&emsp;' . ($result['file'] ?: $lang['no']) . '</p>
                        <p class="text-left">' . $lang['description'] . ':&emsp;' . $result['content'] . '</p>');
            }
        }
        $cat_item .= '</ul>
</div>';
        return $sublevelmarker ? '<ol class="dc-list pl10">' . $cat_item . '</ol>' : $cat_item;
    }
}