<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $config, $core, $admin_conf, $db, $url, $cats_icon, $lang;
switch ($url[2] ?? null) {
    default:
        main();
        break;
    case 'add':
        add();
        break;
    case 'save':
        cat_save();
        break;
    case 'icon_add':
        icon_add();
        break;
    case 'edit_icon':
        $sid = $url[3] ?? '';
        icon_add($sid);
        break;
    case 'save_icon':
        $desc = filter($_POST['desc'], 'a');
        $url = str_replace($config['url'] . '/', '', $_POST['url']);
        if (isset($_POST['edit']) == 1) {
            if ($url && $desc) {
                $cats_icon[$desc] = array('title' => $desc, 'url' => $url);
                $content = "global\$cats_icon;\n";
                $content .= '$cats_icon = ' . arr2str($cats_icon) . ';';
                save_conf(ROOT . 'etc/cats_icon.config.php', $content);
                action_alert('root', 'success', 'cats', 'cats_icon', 'icon_info_6');
            } else {
                action_alert('root', 'danger', 'cats', 'cats_icon', 'icon_info_7');
            }
        } else {
            if ($url && $desc) {
                $cats_icon[$desc] = array('title' => $desc, 'url' => $url);
                $content = "global\$cats_icon;\n";
                $content .= '$cats_icon = ' . arr2str($cats_icon) . ';';
                save_conf(ROOT . 'etc/cats_icon.config.php', $content);
                action_alert('root', 'success', 'cats', 'cats_icon', 'icon_info_2');
            } else {
                action_alert('root', 'danger', 'cats', 'cats_icon', 'icon_info_3');
            }
        }
        break;
    case 'save_position':
        $dbh = init_pdo();
        if (!empty($_POST['position'])) {
            foreach ($_POST['position'] as $i => $row) {
                $sth = $dbh->prepare("UPDATE `" . DB_PREFIX . "_categories` SET `position` = :position WHERE `id` = :id");
                $sth->execute(array('position' => ++$i, 'id' => intval($row)));
            }
        }
        break;
    case 'delete':
        $id = intval($url[3]);
        if ($id) {
            delete($id);
            action_alert('root', 'success', 'cats');
        } else {
            action_alert('root', 'danger', 'cats', false, 'unknown_error');
        }
        break;

    case 'delete_icon':
        $id = $url[3] ?? false;
        if ($id) {
            foreach ($cats_icon as $key => $value) {
                $cats_icon[$key] = array('title' => $value['title'], 'url' => $value['url']);
                if ($id == $key) unset($cats_icon[$key]);
            }
            $content = "global\$cats_icon;\n";
            $content .= '$cats_icon = ' . arr2str($cats_icon) . ';';
            save_conf(ROOT . 'etc/cats_icon.config.php', $content);
            action_alert('root', 'success', 'cats', 'cats_icon');
        } else {
            action_alert('root', 'danger', 'cats', 'cats_icon', 'unknown_error');
        }
        break;
    case 'edit':
        $id = intval($url[3]);
        add($id);
        break;
    case 'action':
        $type = $_POST['submit'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            if ($type == 'Delete') {
                foreach ($_POST['checks'] as $id) {
                    delete(intval($id));
                    action_alert('root', 'success', 'cats');
                }
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'cats');
        }
        break;
    case 'action_icon':
        $type = $_POST['submit'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            if ($type == 'delete') {
                foreach ($_POST['checks'] as $id) {
                    foreach ($cats_icon as $key => $value) {
                        $cats_icon[$key] = array('title' => $value['title'], 'url' => $value['url']);
                        if ($id == $key) unset($cats_icon[$key]);
                    }
                    $content = "global\$cats_icon;\n";
                    $content .= '$cats_icon = ' . arr2str($cats_icon) . ';';
                    save_conf(ROOT . 'etc/cats_icon.config.php', $content);
                    action_alert('root', 'success', 'cats', 'cats_icon');
                }
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'cats', 'cats_icon');
        }
        break;
    case 'scan':
        scan();
        break;
    case 'save_scan':
        save_scan();
        break;
    case 'cats_icon':
        global $adminTpl, $config, $cats_icon, $lang;
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        $s_desc = $_POST['s_desc'] ?? '';
        $i = 0;
        $k = 0;
        foreach ($cats_icon as $title => $param) {
            $k = $k + 1;
        }
        $adminTpl->admin_head($lang['icon_control']);
        if ($k <> 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
           <div class="tray tray-center">';
            alert_info('cats');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
             <span class="panel-title">' . $lang['icon_list'] . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action_icon" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th>' . $lang['icon'] . '</th>
                        <th>' . $lang['icon_url'] . '</th>
                        <th>' . $lang['icon_desc'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            foreach ($cats_icon as $title => $param) {
                $saurl = str_replace($config['url'] . '/', '', $param['url']);
                $surl = $param['url'] > 50 ? $param['url'] : internoetics_mb_strimwidthd($param['url'], 0, 50, $trimmarker = '...');
                $i++;
                if (!$s_desc) {
                    echo '<tr>
                           <td><span class="pd-l-sm"></span>' . smile_id($i, $param['title']) . '</td>
                           <td><div class="media media-list"><a href="' . $param['url'] . '" target="_blank"><img  src="' . $param['url'] . '" width="36" height="36"' . toggle(trimtitle($param['title'])) . ' style="border:0" alt="" onmouseover="this.width=50;this.height=50" onmouseout="this.width=36;this.height=36"/></a></div></td>                      
                           <td><input name="url[]" value="' . $param['url'] . '" class="form-control" type="hidden"/><a href="' . $param['url'] . '" target="_blank"' . toggle(trimtitle($saurl)) . '>' . $surl . '</a></td>
                           <td>' . $param['title'] . '</td>';
                    init_checkbox('td', $title, false, '<li><a href = \'{ADMIN_LINK}/edit_icon/' . $param['title'] . '\'" target="_blank">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $param['title'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                    echo '</tr>';
                    modal_form_delete($title, $param['title'], $lang['icon_delete_title'], 'title', $lang['icon_delete_text'], '{ADMIN_LINK}/delete_icon/' . $param['title']);
                } elseif ($param['title'] == $s_desc) {
                    echo '<tr>
                        <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $i . '</td>
                        <td class="text-center"><a href="' . $param['url'] . '" target="_blank"><img  src="' . $param['url'] . '" width="36" height="36"' . toggle(trimtitle($param['title'])) . ' style="border:0" alt="" onmouseover="this.width=50;this.height=50" onmouseout="this.width=36;this.height=36"/></a></td>
                        <td class="text-center hidden-xs hidden-sm text-nowrap"><input name="url[]" value="' . $param['url'] . '" class="form-control" type="hidden"/><a href="' . $param['url'] . '" target="_blank"' . toggle(trimtitle($saurl)) . '>' . $surl . '</a></td>
                      <td>' . $param['title'] . '</td>';
                    init_checkbox('td', $title, false, '<li><a href = \'{ADMIN_LINK}/edit_icon/' . $param['title'] . '\'" target="_blank">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $param['title'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                    echo '</tr>';
                    modal_form_delete($title, $param['title'], $lang['icon_delete_title'], 'title', $lang['icon_delete_text'], '{ADMIN_LINK}/delete_icon/' . $param['title']);
                }
            }
            echo '</tbody>';
            init_tfoot(true, 'fa-trash-o', 'delete');
            echo '</table>
            </form>
            </div>
         </div>
       </div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action="">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['text'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
         ' . init_sfoot(true, true, 'cats_icon') . '
         </div>
      </form>
   </aside>
</div>
         <div class="widget-menu pull-left mr5">';
        } else {
            $adminTpl->info($lang['list_empty'], 'empty', null, $lang['icon_list'], $lang['icon_add'], '{ADMIN_LINK}/icon_add');
        }
        echo '</div>';
        $adminTpl->admin_foot();
        break;
    case 'ajax':
        global $adminTpl, $db, $lang;
        ajaxInit();
        $type = $url[3];
        if ($type == 'iscat') {
            if (isset($_POST['altname'])) {
                if (!preg_match("/^[a-zA-Z0-9_-]+$/", $_POST['altname'])) {
                    echo(json_encode($lang['cats_url_err_3']));
                } else {
                    $cats = $core->sum_data('categories', 'altname ="' . $db->safesql($_POST['altname']) . '"');
                    $result = ($cats > 0) && ($url[4] != 'update') ? 'false' : 'true';
                    echo $result;
                }
            }
        }
        break;
}
function main(): void
{
    global $core, $adminTpl, $db, $lang;
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    $where = 'id != 0';
    $order = 'position DESC, parent_id DESC';
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
    $s_desc = $_POST['s_desc'] ?? '';
    $s_news = isset($_POST['s_news']) ? intval($_POST['s_news']) : '';
    $s_content = isset($_POST['s_content']) ? intval($_POST['s_content']) : '';
    $s_search = isset($_POST['s_search']);
    if ($s_search) $s_search = $_POST['s_search'] == 1;
    if ($s_id) {
        $where .= " AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
    } else {
        $s_id = '';
    }
    if ($s_title) $where .= "AND `name` LIKE '%" . $db->safesql($s_title) . "%'";
    if ($s_desc) $where .= "AND `description` LIKE '%" . $db->safesql($s_desc) . "%'";
    if ($s_news) $where .= "AND `module`= 'news'";
    if ($s_content) $where .= "AND `module`= 'content'";
    $query = $core->select_data('categories', $where, $order . ' LIMIT ' . limit_page());
    $adminTpl->admin_head($lang['cats']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
           <div class="tray tray-center">';
        alert_info('cats');
        if ($s_search) {
            echo '<div class="panel panel-dark panel-border top">
            <div class="panel-heading"><span class="panel-title">' . $lang['cats_list'] . ':</span>
            </div>
            <div class="heading-hr"></div>
            <div class="panel-body pn table-responsive">
               <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
                  <table class="table table-striped" id="blockBox">';
            catsList($where);
            while ($result = $db->getRow($query)) {
                modal_form_delete($result['id'], $result['name'], $lang['cats_delete_title'], 'cat', $lang['cats_delete_text'], '{ADMIN_LINK}/delete/' . $result['id']);
            }
            echo '</table>
               </form>
            </div>
         </div>';
        } else {
            echo '<div class="panel panel-dark panel-border top">
            <div class="panel-heading"><span class="panel-title">' . $lang['cats_list'] . ':</span>
            </div>
            <div class="heading-hr"></div>
             <div class="panel-body pn table-responsive">
                <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="col-md-2 text-left"></th>
                        <th class="col-md-6 text-left">' . $lang['title'] . '</th>
                        <th style="padding-left: 30px" class="text-center">' . faSpan('fa-newspaper-o', true, false, false, $lang['posts_num']) . '</th>
                     </tr>
                  </thead>
                  <tbody>
               </table>
               <div class="dc">
                  <ol class="dc-list">';
            echo ShowTree();
            echo '</ol>
               </div>
            </div>
            <div class="panel-footer-lines">
            </div>
         </div>
         <script src ="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
         <script src ="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
         <script>
            $(\'.sortable-ul\').sortable({
            stop: function() {
                $.ajax({
                    url: \'/administration/cats/save_position\',
                    method: \'post\',
                    data: $(\'.sortable-ul input\').serialize()
                });
            }
            });
         </script>';
        }
        echo '</div>
     <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action="">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
                  <label for="s_id" class="field prepend-icon">
                  <input id="s_id" type="text" name="s_id" placeholder="' . $lang['cats_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
                  <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
                  </label>
               </div>
               <div class="section mb5">
                  <label for="s_title" class="field prepend-icon">
                  <input id="s_title" type="text" name="s_title" placeholder="' . $lang['titles'] . '" class="form-control" value="' . $s_title . '">
                  <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                  </label>
               </div>
                <div class="section mb5">
                  <label for="s_desc" class="field prepend-icon">
                  <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['cats_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
                  <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                  </label>
               </div>
               <div class="section mb5">
                  <label class="field option">
                  <input type="hidden" name="s_news" value="0">
                  <input type="checkbox" name="s_news"' . ($s_news ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['news'] . '</label>
               </div>
               <div class="section mb5">
                  <label class="field option">
                  <input type="hidden" name="s_content" value="0">
                  <input type="checkbox" name="s_content"' . ($s_content ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['static'] . '</label>
               </div>
              ' . init_sfoot(true, true) . '
            </div>
         </form>
      </aside>
   </div>';
    } else {
        list_empty('root', 'cats', 'url', $s_search, false, true);
    }
    echo '</div>';
    $adminTpl->admin_foot();
}

function add($cat = null): void
{
    global $adminTpl, $core, $lang;
    if (isset($cat)) {
        $ccid = $cat;
        $cat = $core->row_data('categories', 'id ="' . $cat . '"');
        $name = prepareTitle($cat['name']);
        $altname = $cat['altname'];
        $description = $cat['description'];
        $keywords = $cat['keywords'];
        $fulltitle = $cat['fulltitle'];
        $icon = $cat['icon'] ?? 'no_image.png';
        $pid = $cat['parent_id'];
        $mod = $cat['module'];
        $admhead = $lang['cats_edit'];
        $remote = '{ADMIN_LINK}/ajax/iscat/update';
    } else {
        $name = isset($_POST['name']) ? filter(trim($_POST['name'])) : '';
        $altname = isset($_POST['altname']) ? ($_POST['altname'] == '') ? translit($name) : translit($_POST['altname']) : '';
        $description = isset($_POST['description']) ? filter($_POST['description']) : '';
        $fulltitle = isset($_POST['fulltitle']) ? filter($_POST['fulltitle']) : '';
        $keywords = isset($_POST['keywords']) ? filter($_POST['keywords'], 'a') : '';
        $icon = isset($_POST['icon']) ? filter($_POST['icon'], 'a') : 'no_image.png';
        $pid = false;
        $mod = 'news';
        $admhead = $lang['cats_add'];
        $remote = '{ADMIN_LINK}/ajax/iscat';
    }
    $cats_icon = '';
    $module = '';
    $validation_array = array(
        'name' => array(
            'required' => array('true', $lang['cats_name_err']),
            'maxlength' => array(49, str_replace('[count]', '50', $lang['count_text_err_2']))
        ),
        'altname' => array(
            'required' => array('true', $lang['cats_url_err_1'])/*,
            'remote' => array($remote, $lang['cats_url_err_2'])*/
        ),
        'description' => array(
            'maxlength' => array(199, $lang['cats_descr_err'])
        ),
        'keywords' => array(
            'maxlength' => array(255, $lang['cats_keys_err'])
        )
    );
    validationInit($validation_array);
    init_count_text();
    $adminTpl->admin_head($lang['cats'] . ' | ' . $admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
           <div class="tray tray-center">';
    alert_info('blocks');
    echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
             <span class="panel-title">' . $admhead . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body admin-form">
               <form id="admin-form" class="form-horizontal parsley-form" enctype="multipart/form-data" role="form" method="POST" action="{ADMIN_LINK}/save" data-parsley-validate>
                  <div class="form-group">
                     <label class="col-lg-3 col-sm-3 control-label">' . $lang['cats_name'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label for="name" class="field prepend-icon">
                        <input id="name" type="text" name="name" value="' . $name . '" maxlength="50" placeholder="' . $lang['cats_name_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change"' . (!isset($cat) ? 'onkeyup="getTranslit(gid(\'name\').value, \'altname\'),getCats(gid(\'name\').value, \'related_cat\'),count_down(this, \'name\', 50);"' : '') . '>
                        <label for="name" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                        </label>
                        <div style="text-align:right" class="text-right">
                           <span id="char_name"></span>
                        </div>
                        <span id="related_cat"></span>
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-lg-3 col-sm-3 control-label">' . $lang['cats_url'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label for="altname" class="field prepend-icon">
                        <input id="altname" type="text" name="altname" value="' . $altname . '" placeholder="' . $lang['cats_url_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                        <label for="altname" class="field-icon">' . faI('fa-link', false, false, true) . '</label>
                        </label>
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-lg-3 col-sm-3 control-label">' . $lang['cats_fulltitle'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label for="fulltitle" class="field prepend-icon">
                        <input id="fulltitle" type="text" name="fulltitle" value="' . $fulltitle . '" onkeyup="count_down(this, \'fulltitle\', 100)" maxlength="100" placeholder="' . $lang['cats_fulltitle_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                        <label for="fulltitle" class="field-icon">' . faI('fa-code', false, false, true) . '</label>
                        </label>
                        <div style="text-align:right" class="text-right">
                           <span id="char_fulltitle"></span>
                        </div>
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-lg-3 col-sm-3 control-label">' . $lang['cats_descr'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label for="description" class="field prepend-icon">
                        <textarea id="description" name="description" onkeyup="count_down(this, \'description\', 200)" maxlength="200" placeholder="' . $lang['cats_descr_pre'] . '" class="form-control br-light bg-light" style=" min-width: 240px; height: 124px; margin: 0 auto">' . $description . '</textarea>
                        <label for="description" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                        </label>
                         <div style="text-align:right" class="text-right">
                           <span id="char_description"></span>
                        </div>
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-lg-3 col-sm-3 control-label">' . $lang['cats_keys'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label for="keywords" class="field prepend-icon">
                        <input id="keywords" type="text" name="keywords" value="' . $keywords . '" placeholder="' . $lang['cats_keys_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                        <label for="keywords" class="field-icon">' . faI('fa-star-o', false, false, true) . '</label>
                        </label>
                     </div>
                  </div>
                  <div class="form-group">
                     <label for="icon" class="col-lg-3 col-sm-3 control-label">' . $lang['cats_icon'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label class="field select">';
    $path = 'media/cats/';
    $dh = opendir(ROOT . $path);
    echo '<select class="form-control" name="icon" id="icon" onchange="changeIcon(\'' . $path . '\' + this.value, \'iconImg\')">
          <option value="no_image.png">' . $lang['cats_icon_no'] . '</option>';
    while ($file = readdir($dh)) {
        if (is_file(ROOT . $path . $file) && $file != '.' && $file != '..' && $file != 'no_image.png') {
            $selected = ($icon == $file) ? "selected" : "";
            echo '<option value="' . $file . '"' . $selected . '>' . $file . '</option>';
            $cats_icon = str_replace(array('.png'), array(''), $icon);
        }
    }
    echo '</select>
                           ' . faI('arrow double') . '
                        </label>
                     </div>
                        <img src="' . $path . $icon . '" id="iconImg" width="36" height="36"' . toggle(trimtitle($cats_icon)) . '  style="border:0" alt="" onmouseover="this.width=50;this.height=50" onmouseout="this.width=36;this.height=36"/>
                  </div>
                  <div class="tab-block mb25">
                     <div class="form-group">
                        <label class="col-lg-3 col-sm-3 control-label">' . $lang['cats_module'] . '</label>
                        <div class="col-lg-5 col-md-5 col-sm-8">
                           <label class="field select">
                           <select class="form-control" name="module" id="module" onchange="updateCatList(this.value, \'category\');">';
    foreach ($core->getModList() as $module) {
        if (in_array($module, exceMods('categories'))) {
            $selected = ($module == $mod) ? "selected" : "";
            echo '<option value="' . $module . '"' . $selected . '>' . Glang(_mName($module)) . '</option>';
        }
    }
    echo '</select>
                           ' . faI('arrow double') . '
                           </label>
                        </div>
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-lg-3 col-sm-3 control-label">' . $lang['cats_incat'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label class="field select">
                          <select class="form-control" name="category" id="category">
                              <option value="">' . $lang['cats_incat_no'] . '</option>';
    $cats_arr = $core->aCatList();
    foreach ($cats_arr as $cid => $name) {
        $selected = ($pid == $cid && $module == $mod) ? "selected" : "";
        echo '<option value="' . $cid . '"' . $selected . '>' . Glang($name) . '</option>';
    }
    echo '</select>
                           ' . faI('arrow double') . '
                        </label>
                     </div>
                  </div>
            </div>
            ' . init_dfoot(true, 'fa-floppy-o', 'save', 'system');
    if (isset($ccid)) {
        echo '<script>
               $(\'#admin-form\').submit(function (e) {
               var form = this;
               e.preventDefault();
               setTimeout(function () {
               form.submit();
               }, 1000); // in milliseconds
               });
            </script>
            <input type="hidden" name="edit" value="1">
            <input type="hidden" name="cid" value="' . $ccid . '">';
    }
    echo '</form>
         </div>
      </div>
   </div>
</div>';
    $adminTpl->admin_foot();
}

function cat_save(): void
{
    global $db, $core, $lang;
    $cid = isset($_POST['cid']) ? intval($_POST['cid']) : 0;
    $name = filter($_POST['name'], 'a');
    $altname = ($_POST['altname'] == '') ? translit($name) : str_replace(array('-', ' '), array('_', '_'), $_POST['altname']);
    $description = filter($_POST['description']);
    $keywords = filter($_POST['keywords'], 'a');
    $fulltitle = filter($_POST['fulltitle']);
    $icon = filter($_POST['icon'], 'a');
    $module = filter($_POST['module'], 'module');
    $pid = intval($_POST['category']);
    if (!empty($name) && !empty($altname)) {
        if (isset($_POST['edit'])) {
            $core->upd_data('categories', 'name ="' . $db->safesql(processText($name)) . '", altname ="' . $altname . '", description ="' . $db->safesql(processText($description)) . '", fulltitle ="' . $db->safesql(processText($fulltitle)) . '", keywords ="' . $db->safesql(processText($keywords)) . '", module ="' . $module . '", icon ="' . $icon . '", parent_id ="' . $pid . '"', 'id ="' . $cid . '"');
            $core->ins_log(false, $lang['logs_edit_categories'], 1, false, false, $name);
            action_alert('root', 'success', 'cats', false, 'cats_edit_success');
        } else {
            $core->ins_data('categories', 'id,name,altname,fulltitle,description,keywords,module,icon,position,parent_id', 'NULL,"' . $db->safesql(processText($name)) . '","' . $altname . '","' . $db->safesql(processText($fulltitle)) . '","' . $db->safesql(processText($description)) . '","' . $keywords . '","' . $module . '","' . $icon . '","0","' . $pid . '"');
            $core->ins_log(false, $lang['logs_add_categories'], 1, false, false, $name);
            action_alert('root', 'success', 'cats', false, 'cats_add_success');
        }
        if (file_exists(ROOT . 'tmp/cache/categories.cache')) @unlink(ROOT . 'tmp/cache/categories.cache');
    } else {
        action_alert('root', 'danger', 'cats', 'add', 'not_field');
    }
}

function scan($cat = null): void
{
    global $adminTpl, $core, $config, $lang;
    if (isset($cat)) {
        $cat = $core->row_data('categories');
        $name = prepareTitle($cat['name']);
        $mod = $cat['module'];
    } else {
        $mod = 'news';
    }
    $validation_array = array(
        'full' => array(
            'required' => array('true', $lang['cats_fast_list_err'])
        )
    );
    validationInit($validation_array);
    init_count_text();
    $adminTpl->admin_head($lang['cats'] . ' | ' . $lang['cats_fast_add']);
    echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $lang['cats_fast_add'] . '</span></div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <div class="panel-body admin-form">
               <form id="admin-form" action="{ADMIN_LINK}/save_scan" method="post" name="news" role="form" class="form-horizontal parsley-form">
                    <div class="form-group">
               <label class="col-lg-3 col-sm-3 control-label">' . $lang['cats_module'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8 mbn15">
                  <label class="field select mb15">
                        <select name="module" id="module" onchange="updateCatList(this.value, \'category\');">';
    $exceMods = array('news', 'content');
    foreach ($core->getModList() as $module) {
        if (in_array($module, exceMods('categories'))) {
            $selected = ($module == $mod) ? "selected" : "";
            echo '<option value="' . $module . '"' . $selected . '>' . Glang(_mName($module)) . '</option>';
        }
    }
    echo '</select>
                  ' . faI('arrow double') . '
                  </label>
               </div>
            </div>
                  <div class="form-group">
                   <label class="col-lg-3 col-sm-3 control-label">' . $lang['cats_fast_list'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label for="comment" class="field prepend-icon">
                        <textarea name="full" id="full" placeholder="' . $lang['cats_fast_list_pre'] . '" class="form-control br-light bg-light" style="width: 415px; min-width: 240px; max-width: 420px; height: 124px; margin: 0 auto"></textarea>
                        <label for="comment" class="field-icon">' . faI('fa-comments', false, false, true) . '</label>
                        <span class="input-footer text-left">' . faSpan('fa-bell', false, $lang['cats_fast_list_tt']) . '</span>
                        </label>
                     </div>
                  </div>
            </div>
            ' . init_dfoot(true, 'fa-floppy-o', 'save', 'system');
    echo '</form>
         </div>
      </div>
   </div>
</div>';
    $adminTpl->admin_foot();
}

function save_scan(): void
{
    global $db, $core, $lang;
    $module = filter($_POST['module'], 'module');
    $full = explode("\n", $_POST['full']);
    $info = '';
    if (!empty($_POST['full'])) {
        foreach ($full as $cat) {
            if ($cat !== '' && !is_array($cat)) {
                $name = filter($cat);
                $altname = translit($name);
                $core->ins_data('categories', 'id,name,altname,fulltitle,description,keywords,module,icon,position,parent_id', 'NULL,"' . $db->safesql(processText($name)) . '","' . $altname . '","","","","' . $module . '","no_image.png",0, 0');
                $core->ins_log(false, $lang['logs_add_categories'], 1, false, false, $name);
                $info .= str_replace(array('[name]', '[altname]'), array($name, $altname), $lang['cats_fast_save']);
            }
        }
        action_alert('root', 'success', 'cats', false, 'cats__add_success');
    } else {
        action_alert('root', 'danger', 'cats', false, 'unknown_error');
    }
    @unlink(ROOT . 'tmp/cache/categories.cache');
}

function icon_add($сid = null): void
{
    global $adminTpl, $cats_icon, $lang;
    fancyboxInit();
    if (!isset($сid)) {
        $titles = '';
        $urls = '';
        $file = false;
        $tit = $lang['icon_add'];
    } else {
        foreach ($cats_icon as $param) {
            if ($сid == $param['title']) {
                $titles = $param['title'];
                $urls = $param['url'];
                $file = $param['url'];
            }
        }
        $tit = $lang['icon_edit'];
    }
    $_SESSION["RF"]["fff"] = 'media/cats/';
    $adminTpl->admin_head($tit);
    $validation_array = array(
        'desc' => array(
            'required' => array('true', $lang['add_title_err']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
    );
    validationInit($validation_array);
    init_count_text();
    $adminTpl->open();
    echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $tit . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body admin-form">
            <form id="admin-form" action="{ADMIN_LINK}/save_icon" method="post" role="form" class="form-horizontal parsley-form" data-parsley-validate>
              <div class="form-group">
                  <label for="desc" class="col-lg-3 col-sm-3 control-label">' . $lang['icon_desc'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="desc" class="field prepend-icon">
                     <textarea id="desc" name="desc" onkeyup="count_down(this, \'desc\', 200)" maxlength="200" placeholder="' . $lang['icon_descr_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $titles . '</textarea>
                     <label for="desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                     </label>
                     <div style="text-align:right" class="text-right">
                        <span id="char_desc"></span>
                     </div>
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-lg-3 col-sm-3 control-label">' . $lang['icon_url'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="url" class="field prepend-icon">
                     <input id="url" type="text" name="url" value="' . $urls . '" placeholder="' . $lang['icon_url_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                     <label for="url" class="field-icon">' . faI('fa-link', false, false, true) . '</label>
                     </label>
                  </div>
               </div>';
    $icon = !$file ? 'holder.js/160x45' : '' . $urls;
    echo '<div class="form-group">
                  <label class="col-lg-3 col-sm-3 control-label">' . $lang['icon_folder'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <div data-provides="fileupload" class="fileupload fileupload-new admin-form">
                        <div class="fileupload-preview thumbnail mb15">
                           <img src="' . $icon . '" class="br3" alt="holder" style="width:56px; height: 56px;" style="border:0" alt=""/>
                        </div>
                        <span ' . btn_class('system button btn-block ph5', true, true) . '>
                        <span class="fileupload-new">' . $lang['selected_file'] . '</span>
                        <input id="fbox" data-fancybox-type="iframe" href="usr/plugins/filemanager/dialog.php?type=images&field_id=url"></span>
                     </div>
                  </div>
               </div>
         </div>';
    if (isset($sid)) echo '<input type="hidden" name="edit" value="1"/>';
    echo init_dfoot(true, 'fa-floppy-o', 'save', 'system');
    echo '</section>
      </div>
   </div>
</div>
</form>';
    $adminTpl->admin_foot();
}

function delete($id): void
{
    global $core, $lang;
    $categories = $core->row_data('categories', 'id ="' . $id . '"');
    $core->del_data('categories', 'id ="' . $id . '"');
    $core->del_data('categories', 'parent_id ="' . $id . '"');
    $core->del_data('news', 'cat like"%,' . $id . ',%"');
    $core->ins_log(false, $lang['logs_delete_categories'], 1, false, false, $categories['name']);
    if (file_exists(ROOT . 'tmp/cache/categories.cache')) @unlink(ROOT . 'tmp/cache/categories.cache');
}

function ShowTree($parent_id = 0, $sublevelmarker = false)
{
    global $db, $core, $lang;
    $count = array();
    $blocks = array();
    $countType = array();
    $query = $core->select_data('categories', '`parent_id` = "' . $parent_id . '"', 'position');
    if ($db->numRows($query) > 0) {
        while ($result = $db->getRow($query)) {
            $blocks[$result['parent_id']][] = $result;
            $countType[$result['parent_id']] = true;
        }
        $cat_item = '<div class="dc">
<ul class="sortable-ul panel-body">';
        foreach ($blocks as $type => $inf) {
            $count[$type] = count($inf);
            foreach ($inf as $result) {
                $sub_num = $core->sum_data('categories', '`parent_id` ="' . $result['id'] . '"');
                $item_icon = faSpan('fa-list-ul', false, false, false, ($sub_num > 0 ? $lang['choose_action'] : $lang['choose_action1']));
                $contentLink = $result['altname'] !== ',0,' ? $result['module'] . '/' . $core->getCat($result['module'], $result['altname'], 'development') : '';
                $admhead = $result['module'] == 'news' ? $lang['add_news'] : ($result['module'] == 'content' ? $lang['static_add'] : $lang['add_content']);
                $cat_item .= '<li class="dc-item accordion-toggle" data-id="' . $result['id'] . '" data-toggle="collapse" data-parent="#accordion" href="#collapse_' . $result['id'] . '">
      <input type ="hidden" name ="position[]" value ="' . $result['id'] . '">
      <div class="dc-handle dd-handle">' . $item_icon . '</div>
      <div class="dc-content">
         <img src="' . catsicon($result['icon']) . '"class="pb10" ' . toggle($result['description']) . ' style="width:32px; height:32px;" alt="">
         <b>ID: ' . $result['id'] . '</b>  ' . ($core->getCat($result['module'], "'" . $result['id'] . "'", 'short', 1) ? $core->getCat($result['module'], "'" . $result['id'] . "'", 'short', 1) : '<a href="' . $contentLink . $result['altname'] . '" target="_blank">' . faSpan(false, true, false, false, $result['name']) . Glang($result['name']) . '</a>') . '
         <b class="dc-rcontent" style="left: 85%;">' . $core->sum_data($result['module'], '`cat` =",' . $result['id'] . ',"') . '</b>
         <div style="text-align:right" class="dc-rmenu text-right">
            <div class="btn-group">
               <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">' . faSpan('fa-caret-down', false, 'right', true) . '</a>
               <ul class="dropdown-menu text-left dropdown-menu-right">
                  <li><a href="' . ADMIN . '/module/' . $result['module'] . '/cat/' . $result['id'] . '">' . faSpan('fa-television', true, $lang['cats_view_content']) . '</a></li>
                  <li><a href="' . ADMIN . '/module/' . $result['module'] . '/add/' . $result['id'] . '">' . faSpan('fa-plus', true, $admhead) . '</a></li>
                  <li><a href="' . ADMIN . '/cats/edit/' . $result['id'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                  <li><a href="' . $core->getCat($result['module'], $result['id'], 'url', 1) . '" target="_blank">' . faSpan('fa-tasks', true, $lang['cats_view']) . '</a></li>
                  <li class="divider"></li>
                  <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $result['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>
               </ul>
            </div>
         </div>
   </li>';
                $cat_item .= '<div id="collapse_' . $result['id'] . '" class="accordion-body collapse">' . ShowTree($result['id'], true) . '</div>';
                modal_form_delete($result['id'], $result['name'], $lang['cats_delete_title'], 'cat', $lang['cats_delete_text'], '{ADMIN_LINK}/delete/' . $result['id']);
            }
        }
        $cat_item .= '</ul>
</div>';
        return $sublevelmarker ? '<ol class="dc-list pl10">' . $cat_item . '</ol>' : $cat_item;
    }
}