<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $lang;
switch ($url[2] ?? null) {
    default:
        comments_list();
        break;
    case 'edit':
        init_count_text();
        $id = isset($url[3]) ? intval($url[3]) : '';
        $comment = $core->row_data('comments', 'id ="' . $id . '"');
        $nick = false;
        if ($id != 0) {
            if ($comment['uid'] != 0) $nick = $core->row_data('users', 'id = ' . $comment['uid']);
        } else {
            location(ADMIN);
        }
        $bb = new bb;
        $row = $core->row_data($comment['module'], 'id ="' . $comment['post_id'] . '"');
        $catInfo = $row['cat'] !== ',0,' ? $comment['module'] . '/' . $core->getCat($comment['module'], $row['cat'], 'development') : $comment['module'];
        $altname = isset($catInfo) ? ($row['altname'] ?? $row['translate']) : '';
        $url_link = $catInfo ? $catInfo . '/' . $altname : $altname . '.html';
        $adminTpl->admin_head($lang['com_com'] . ' | ' . $lang['com_edit']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $lang['com_edit'] . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body admin-form">
            <form action="{ADMIN_LINK}/save" method="post" role="form" class="form-horizontal parsley-form" data-parsley-validate>';
        if ($comment['uid'] == 0) {
            echo '<div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['base_guest_name'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <input type="text" name="gname" value="' . $comment['gname'] . '" class="form-control" id="gname"	data-parsley-required="true" data-parsley-trigger="change">
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['base_guest_mail'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <input type="text" name="gemail" value="' . $comment['gemail'] . '" class="form-control" id="exampleInputEmail2"	data-parsley-required="true" data-parsley-trigger="change">
                  </div>
               </div>';
        } else {
            echo '<div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['base_user_name'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <a target="_blank" href="profile/' . $nick['nick'] . '">
                        <p class="form-control">' . $nick['nick'] . '</p>
                     </a>
                  </div>
               </div>';
        }
        echo '<div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['com_id'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
   <p class="form-control"><a href="' . $url_link . '.html" target="_blank">' . $comment['id'] . '</a></p>
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['module'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <select class="form-control" name="module" id="module" onchange="updateCatList(this.value, \'category\');">';
        foreach ($core->getModList() as $module) {
            $selected = ($module == $comment['module']) ? "selected" : "";
            echo '<option value="' . $module . '"' . $selected . '>' . _mName($module) . '</option>';
        }
        echo '</select>
                  </div>
               </div>
  <div class="col-xs-12">
             <div class="tab-block mb25">
               <div class="form-group">
                   <div class="tab-content_editor">
                   ' . adminArea('text', $bb->htmltobb($comment['text']), 10, 'textarea', false, true) . '
                  </div>
               </div>
               <div class="form-group">
                  <div class="col-xs-6">
                     <label class="field option">
                     <input type="checkbox" name="active"' . ($comment['status'] ? 'checked' : '') . ' value="1" checked><span class="checkbox mr10"></span>' . $lang['com_act'] . '</label><br>
                     <hr class="alt short mv15">
                  </div>
               </div>
            </div>
         </div>
     </div>
         <input type="hidden" name="cid" value="' . $id . '">
         <input type="hidden" name="userid" value="' . $comment['uid'] . '">
            ' . init_dfoot(true, 'fa-floppy-o', 'save', 'system');
        echo '</form>
      </div>
   </div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'save':
        $cid = isset($_POST['cid']) ? intval($_POST['cid']) : '';
        $userid = isset($_POST['userid']) ? intval($_POST['userid']) : '';
        $module = isset($_POST['module']) ? filter($_POST['module'], 'module') : '';
        $text = isset($_POST['text']) ? filter($_POST['text']) : '';
        $gname = isset($_POST['gname']) ? filter($_POST['gname']) : '';
        $gemail = isset($_POST['gemail']) ? filter($_POST['gemail']) : '';
        $active = isset($_POST['active']) ? 1 : false;
        if ($cid != 0) {
            if ((!empty($text) && $userid != 0) || (!empty($text) && !empty($gname) && !empty($gemail))) {
                $rows = $core->row_data('comments', 'id ="' . $cid . '"');
                $core->upd_data('comments', 'module ="' . $module . '", text ="' . strip_tags($db->safesql(parseBB(processText(filter($_POST['text'], 'html'))))) . '", gemail ="' . $gemail . '", gname ="' . $db->safesql(processText($gname)) . '", status ="' . $active . '"', 'id ="' . $cid . '"');
                $core->ins_log(false, $lang['logs_edit_comments'], 1, false, false, $rows['post_id']);
                action_alert('root', 'success', 'comments', false, 'com_update');
            } else {
                action_alert('root', 'danger', 'comments', false, 'unknown_error');
            }
        } else {
            action_alert('root', 'danger', 'comments', false, 'unknown_error');
        }
        break;
    case 'delete':
        $id = isset($url[3]) ? intval($url[3]) : '';
        $rows = $core->row_data('comments', 'id ="' . $id . '"');
        if ($id != 0 && $rows['module']) {
            deleteComments($id, $rows['module'], $rows['post_id'], $rows['uid']);
            action_alert('root', 'success', 'banners');
        } else {
            action_alert('root', 'danger', 'banners', false, 'unknown_error');
        }
        break;
    case 'user_comments':
        $id = isset($url[3]) ? intval($url[3]) : '';
        comments_list($id);
        break;
    case 'activate':
        $id = isset($url[3]) ? intval($url[3]) : '';
        $rows = $core->row_data('comments', 'id ="' . $id . '"');
        if (!empty($id)) {
            $core->upd_data('comments', 'status = 1', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_comments'], 1, false, false, $rows['post_id']);
            action_alert('root', 'success', 'comments');
        } else {
            action_alert('root', 'danger', 'comments', false, 'unknown_error');
        }
        break;
    case 'deactivate':
        $id = isset($url[3]) ? intval($url[3]) : '';
        $rows = $core->row_data('comments', 'id ="' . $id . '"');
        if (!empty($id)) {
            $core->upd_data('comments', 'status = 0', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_comments'], 1, false, false, $rows['post_id']);
            action_alert('root', 'success', 'comments');
        } else {
            action_alert('root', 'danger', 'comments', false, 'unknown_error');
        }
        break;
    case 'retivate':
        $id = isset($url[3]) ? intval($url[3]) : '';
        $rows = $core->row_data('comments', 'id ="' . $id . '"');
        $status = $rows['status'] == 0 || $rows['status'] == 2 ? 1 : 0;
        if (!empty($id)) {
            $core->upd_data('comments', 'status ="' . $status . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_comments'], 1, false, false, $rows['post_id']);
            action_alert('root', 'success', 'comments');
        } else {
            action_alert('root', 'danger', 'comments', false, 'unknown_error');
        }
        break;
    case 'reactivate':
        $id = isset($url[3]) ? intval($url[3]) : '';
        $rows = $core->row_data('comments', 'id ="' . $id . '"');
        $status = (($rows['status'] == 1) ? 0 : 1);
        if ($rows['status'] == 0 || $rows['status'] == 1) $status = 2;
        if (!empty($id)) {
            $core->upd_data('comments', 'status ="' . $status . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_comments'], 1, false, false, $rows['post_id']);
            action_alert('root', 'success', 'comments');
        } else {
            action_alert('root', 'danger', 'comments', false, 'unknown_error');
        }
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'activate':
                    foreach ($_POST['checks'] as $id) {
                        $rows = $core->row_data('comments', 'id ="' . $id . '"');
                        $core->upd_data('comments', 'status = 1', 'id ="' . $id . '"');
                        $core->ins_log(false, $lang['logs_change_status_comments'], 1, false, false, $rows['post_id']);
                        action_alert('root', 'success', 'comments');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $rows = $core->row_data('comments', 'id ="' . $id . '"');
                        $core->upd_data('comments', 'status = 0', 'id ="' . $id . '"');
                        $core->ins_log(false, $lang['logs_change_status_comments'], 1, false, false, $rows['post_id']);
                        action_alert('root', 'success', 'comments');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id) {
                        $rows = $core->row_data('comments', 'id ="' . $id . '"');
                        $core->upd_data('comments', 'status = NOT `status`', 'id ="' . $id . '"');
                        $core->ins_log(false, $lang['logs_change_status_comments'], 1, false, false, $rows['post_id']);
                        action_alert('root', 'success', 'comments');
                    }
                    break;
                case 'doReactivate':
                    foreach ($_POST['checks'] as $id) {
                        $rows = $core->row_data('comments', 'id ="' . $id . '"');
                        $status = (($rows['status'] == 1) ? 0 : 1);
                        if ($rows['status'] == 0 || $rows['status'] == 1) $status = 2;
                        $core->upd_data('comments', 'status ="' . $status . '"', 'id ="' . $id . '"');
                        $core->ins_log(false, $lang['logs_change_status_comments'], 1, false, false, $rows['post_id']);
                        action_alert('root', 'success', 'comments');
                    }
                    break;
                case 'delete':
                    foreach ($_POST['checks'] as $id) {
                        $rows = $core->row_data('comments', 'id ="' . $id . '"');
                        deleteComments($id, $rows['module'], $rows['post_id'], $rows['uid']);
                        action_alert('root', 'success', 'comments');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'comments');
        }
        break;
}
function comments_list($id = null): void
{
    global $adminTpl, $db, $core, $url, $lang;
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    UniClass('selectList');
    datetimepickerInit('s_startdate', 'date');
    datetimepickerInit('s_enddate', 'date');
    if (isset($id)) {
        $id = isset($url[3]) ? intval($url[3]) : '';
        $where = 'uid = ' . $id;
    } else {
        $where = 'c.status != 2 ';
    }
    $order = '';
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_author = isset($_POST['s_author']) ? filter($_POST['s_author'], 'a') : '';
    $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
    $s_desc = $_POST['s_desc'] ?? '';
    $s_module = $_POST['s_module'] ?? '';
    $s_startdate = isset($_POST['s_startdate']) ? strtotime($_POST['s_startdate']) : '';
    $s_enddate = isset($_POST['s_enddate']) ? strtotime($_POST['s_enddate']) : '';
    $s_active = isset($_POST['s_active']);
    $s_search = isset($_POST['s_search']);
    if ($s_active) {
        if ($_POST['s_active'] == 1) {
            $where .= ' AND c.status = 1 ';
        } else {
            $s_active = false;
            $where .= ' AND c.status = 0 ';
        }
    } else {
        $s_active = true;
        $where .= 'AND c.status != 2';
    }
    if ($s_id) {
        $where .= "AND c.id LIKE '%" . $db->safesql($s_id) . "%'";
    } else {
        $s_id = '';
    }
    if ($s_author) $where .= "AND c.uid LIKE '%" . $db->safesql($s_author) . "%'";
    if ($s_desc) $where .= "AND c.text LIKE '%" . $db->safesql($s_desc) . "%'";
    if ($s_module) $where .= "AND c.module LIKE '%" . $db->safesql($s_module) . "%'";
    if ($s_startdate) $where .= "AND c.date >= '" . intval($s_startdate) . "'";
    if ($s_enddate) $where .= "AND c.date <= '" . intval($s_enddate) . "'";
    if (isset($url[2]) && $url[2] == 'order') {
        switch ($url[3] ?? '') {
            case 'abc':
                $order .= 'c.text ASC';
                break;
            case 'last':
                $order .= 'c.date DESC';
                break;
            case 'id':
                $order .= 'c.id ASC';
                break;
        }
    } else {
        $order .= 'c.date DESC';
    }
    $query = $core->select_data('comments', $where, $order . ' LIMIT ' . limit_page(), 'c.*, u.nick, u.group, u.last_visit', 'as c LEFT JOIN ' . DB_PREFIX . '_users as u on (c.uid=u.id)');
    $adminTpl->admin_head($lang['comments']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        onmoder('comments', 'status', 'comments_moder');
        alert_info('comments');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['comments_list'] . ':</span>
             ' . sort_head('root', 3, 'last') . '           
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-7">' . $lang['titles'] . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo '</tr>
                  </thead>
                  <tbody>';
        while ($comment = $db->getRow($query)) {
            $tt = str(htmlspecialchars(strip_tags($comment['text'])), 20);
            $row = $core->row_data($comment['module'], 'id ="' . $comment['post_id'] . '"');
            $catInfo = $row['cat'] !== ',0,' ? $comment['module'] . '/' . $core->getCat($comment['module'], $row['cat'], 'development') : $comment['module'];
            $altname = isset($catInfo) ? ($row['altname'] ?? $row['translate']) : '';
            $url_link = $catInfo ? $catInfo . '/' . $altname : $altname . '.html';
            $patch = 'files/' . $comment['module'] . '/' . $comment['post_id'] . '/';
            $images = array();
            $all_files = scandir(news_image($patch));
            for ($i = 0; $i < count($all_files); $i++) {
                if (!str_contains($all_files[$i], ".png") and !str_contains($all_files[$i], ".jpg") and
                    !str_contains($all_files[$i], ".gif")
                ) continue;
                $images[] = $all_files[$i];
            }
            $dir = news_image($patch);
            $img_random = $images ? $images[rand(0, sizeof($images) - 1)] : 'media/cats/no_image.png';
            $img_src = $images ? $dir . $img_random : $img_random;
            echo '<tr>
                        <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $comment['id'] . '</td>
                        <td>
                           <div class="media media-list"><a href="' . $url_link . '.html"><img src="' . $img_src . '" style="width:76px; height:76px;" alt=""></a></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . _nTitle($comment['module'], $comment['post_id']) . '</a></ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['com_text'] . ': ' . (($tt != '') ? '<a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-text_' . $comment['id'] . '\')"' . toggle($lang['view']) . '>' . $tt . '</a> ' : colorSpan('red', $lang['no_text'])) . '</a></ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['date'] . ': ' . formatDate($comment['date'], true) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['links'] . ': ' . (eregStrt('href', $comment['text']) ? colorSpan('red', $lang['yes']) : colorSpan('green', $lang['no'])) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['module'] . ': ' . commentLink($comment['module'], $comment['post_id']) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['author'] . ': ' . (($comment['uid'] != 0) ? '<a href="profile/' . $comment['nick'] . '" title="' . $comment['nick'] . '">' . $comment['nick'] . '</a>' : $comment['gname']) . ' </a ></ol >
                        </td>
                        <td class="text-center" > ' . status_icon('comments', $comment['id']) . ' </td>';
            init_checkbox('td', $comment['id'], false, '<li><a href="' . $url_link . '.html" target="_blank">' . faSpan('fa-desktop', false, $lang['view']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/edit/' . $comment['id'] . '" target="_blank">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/retivate/' . $comment['id'] . '">' . faSpan('fa-power-off', true, (($comment['status'] != 1) ? $lang['do_activation'] : $lang['do_deactivation'])) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/reactivate/' . $comment['id'] . '">' . faSpan('fa-share-square-o', true, $lang['do_moderation']) . '</a></li>
                                 <li><a href="{ADMIN}/user/pm/' . $comment['uid'] . '\">' . faSpan('fa-user-o', true, $lang['pm']) . '</a></li>
                                 <li><a href="{ADMIN}/user/mail/' . $comment['uid'] . '\">' . faSpan('fa-envelope-o', true, $lang['mail']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $comment['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            echo '</tr>';
            modal_form_text('text_' . $comment['id'], $lang['info'], 'fa-info-circle', $lang['com_text'], $comment['text']);
            modal_form_delete($comment['id'], $tt, $lang['comments_delete_title'], 'comments', $lang['comments_delete_text'], '{ADMIN_LINK}/delete/' . $comment['id']);
        }
        echo '</tbody>';
        init_tfoot('<option value="activate">' . $lang['do_activation'] . '</option>
                           <option value="deActivate">' . $lang['do_deactivation'] . '</option>
                           <option value="reActivate">' . $lang['do_reactivation'] . '</option>
                           <option value="doReactivate">' . $lang['do_moderation'] . '</option>
                           <option value="delete">' . $lang['delete'] . '</option>');
        echo '</table>
            </form>
         </div>
      </div>';
        page_list('root', 'comments', 'comments', str_replace('c.', '', $where));
        echo '</div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action="">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
               <label for="s_author" class="field prepend-icon">
                  <select name="s_author" id="s_author" class="form-control select2-single">
                     <option value="0">' . $lang['choose_users'] . '</option>';
        $query_users_list = $core->select_data('users');
        if ($db->numRows($query_users_list) > 0) {
            while ($users_list = $db->getRow($query_users_list)) {
                $selected = ($users_list['nick'] == $comment['author']) ? "selected" : "";
                echo '<option value="' . $users_list['id'] . '"' . $selected . '>' . $users_list['nick'] . '</option>';
            }
        }
        echo '</select>
                  <label for="author" class="field-icon">' . faI('fa-user', false, false, true) . '</label>
               </label>
            </div>
             <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['comments_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mbn10">
               <label for="s_module" class="field prepend-icon">
                  <select class="form-control" name="s_module" id="s_module">
                     <option value="0">' . $lang['choose_module'] . '</option>';
        foreach ($core->getModList() as $module) {
            if (in_array($module, exceMods('categories'))) {
                $selected = ($module == $comment['module']) ? "selected" : "";
                echo '<option value="' . $module . '"' . $selected . '>' . _mName($module) . '</option>';
            }
        }
        echo '</select>
                  ' . faI('arrow double') . '
               </label>
            </div>
             <div class="section mbn10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['comments_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5 mbn10">
               <h5><small>' . $lang['news_search_date'] . '</small></h5>
               <div class="section row">
                  <div class="col-lg-6 col-md-6 col-sm-9">
                     <label for="s_startdate" class="field prepend-icon">
                     <input id="s_startdate" type="text" name="s_startdate" placeholder="' . $lang['from'] . '" class="form-control">
                     <label for="s_startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
                  <div class="col-lg-6 col-md-6 col-sm-9">
                     <label for="s_enddate" class="field prepend-icon">
                     <input id="s_enddate" type="text" name="s_enddate" placeholder="' . $lang['to'] . '" class="form-control">
                     <label for="s_enddate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active"' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['comments_active'] . '</label>
            </div>
            ' . init_sfoot(true, true) . '
         </div>
      </form>
   </aside>
</div>';
    } else {
        onmoder('comments', 'status', 'comments_moder');
        list_empty('root', 'comments', 'moder', $s_search, false, true, $s_search, true);
    }
    $adminTpl->admin_foot();
}