<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $core, $config, $url, $social, $allowCahce, $log_conf, $security, $lang;
$configs = array();
require ROOT . 'etc/configs.config.php';
$core->loadLangFile('langs/{lang}/{lang}.config.lng');
foreach ($configs as $file => $arr) {
    require_once(ROOT . 'etc/' . $file . '.config.php');
}
$configBox = array(
    'global' => array(
        'varName' => 'config',
        'title' => $lang['global'],
        'groups' => array(
            'metaTags' => array(
                'title' => $lang['global_metatags'],
                'vars' => array(
                    'name' => array(
                        'title' => $lang['global_metatags_namet'],
                        'description' => $lang['global_metatags_named'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                        'multilang' => true
                    ),
                    'url' => array(
                        'title' => $lang['global_metatags_urlt'],
                        'description' => $lang['global_metatags_urld'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'description' => array(
                        'title' => $lang['global_metatags_descriptiont'],
                        'description' => $lang['global_metatags_descriptiond'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'description'),
                        'multilang' => true
                    ),
                    'slogan' => array(
                        'title' => $lang['global_metatags_slogant'],
                        'description' => $lang['global_metatags_slogand'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                        'multilang' => true
                    ),
                    'keywords' => array(
                        'title' => $lang['global_metatags_keywordst'],
                        'description' => $lang['global_metatags_keywordsd'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'keywords'),
                        'multilang' => true
                    ),
                    'divider' => array(
                        'title' => $lang['global_metatags_dividert'],
                        'description' => $lang['global_metatags_dividerd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                        'multilang' => true
                    ),
                    'charset' => array(
                        'title' => $lang['global_metatags_charsett'],
                        'description' => $lang['global_metatags_charsetd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'mainModule' => array(
                        'title' => $lang['global_metatags_mainmodulet'],
                        'description' => $lang['global_metatags_mainmoduled'],
                        'content' => changeModule(),
                    ),
                    'lang' => array(
                        'title' => $lang['global_metatags_langt'],
                        'description' => $lang['global_metatags_langd'],
                        'content' => changeLang(),
                    )
                )
            ),
            'mail' => array(
                'title' => $lang['global_mail'],
                'vars' => array(
                    'support_mail' => array(
                        'title' => $lang['global_support_mailt'],
                        'description' => $lang['global_support_maild'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'smtp_php' => array(
                        'title' => $lang['global_smtp_mmdt'],
                        'description' => $lang['global_smtp_mmdd'],
                        'content' => conf_smtp_mmd(),
                    ),
                    'smtp_host' => array(
                        'title' => $lang['global_smtphost_mailt'],
                        'description' => $lang['global_smtphost_maild'],
                        'content' => int_cong('input', '{varName}', '{var}') . host_ports($config['smtp_host'], $config['smtp_port'], $config['smtp_php']),
                    ),
                    'smtp_port' => array(
                        'title' => $lang['global_smtpport_mailt'],
                        'description' => $lang['global_smtpport_maild'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'smtp_user' => array(
                        'title' => $lang['global_user_mailt'],
                        'description' => $lang['global_user_maild'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'smtp_pass' => array(
                        'title' => $lang['global_pass_mailt'],
                        'description' => $lang['global_pass_maild'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'smtp_secure' => array(
                        'title' => $lang['global_sslt'],
                        'description' => $lang['global_ssld'],
                        'content' => conf_smtp_secure(),
                    ),
                    'smtp_helo' => array(
                        'title' => $lang['global_smtphelo_mailt'],
                        'description' => $lang['global_smtphelo_maild'],
                        'content' => conf_smtp(),
                    ),
                    'smtp_mail' => array(
                        'title' => $lang['global_smtp_mailt'],
                        'description' => $lang['global_smtp_maild'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'smtp_fname' => array(
                        'title' => $lang['global_smtp_fnamet'],
                        'description' => $lang['global_smtp_fnamed'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'smtp_reading' => array(
                        'title' => $lang['global_smtp_readingt'],
                        'description' => $lang['global_smtp_readingd'],
                        'content' => conf_radio("smtp_reading", $config['smtp_reading']),
                    ),
                    'smtp_bcc' => array(
                        'title' => $lang['global_smtp_bcct'],
                        'description' => $lang['global_smtp_bccd'],
                        'content' => conf_radio("smtp_bcc", $config['smtp_bcc']),
                    ),
                    'clear_distrib' => array(
                        'title' => $lang['global_clear_distribt'],
                        'description' => $lang['global_clear_distribd'],
                        'content' => conf_radio("clear_distrib", $config['clear_distrib']),
                    ),
                )
            ),
            'other' => array(
                'title' => $lang['global_other'],
                'vars' => array(
                    'uniqKey' => array(
                        'title' => $lang['global_other_uniqkey'],
                        'description' => $lang['global_other_uniqkeyd'],
                        'content' => '<p class="form-control-static">' . colorSpan('red', $config['uniqKey']) . '</p><input type="hidden" size="20" name="' . $config['lang'] . '[uniqKey]"	value="' . $config['uniqKey'] . '" id="name"	maxlength="100" maxsize="100">',),
                    'key' => array(
                        'title' => $lang['global_other_key'],
                        'description' => $lang['global_other_keyd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'timezone' => array(
                        'title' => $lang['global_other_timezonet'],
                        'description' => $lang['global_other_timezoned'],
                        'content' => timeZone(),
                    ),
                    'tpl' => array(
                        'title' => $lang['global_other_tplt'],
                        'description' => $lang['global_other_tpld'],
                        'content' => changeTpl(),
                    ),
                    'tpl_change' => array(
                        'title' => $lang['global_other_tpl_change'],
                        'description' => $lang['global_other_tpl_change_desc'],
                        'content' => conf_radio("tpl_change", $config['tpl_change']),
                    ),
                    'smartphone' => array(
                        'title' => $lang['global_other_tpl_mobi'],
                        'description' => $lang['global_other_tpl_mobi_desc'],
                        'content' => conf_radio("smartphone", $config['smartphone']),
                    ),
                    'dbType' => array(
                        'title' => $lang['global_other_dbtypet'],
                        'description' => $lang['global_other_dbtyped'],
                        'content' => dbType(),
                    ),
                    'imageEffect' => array(
                        'title' => $lang['global_other_imageeffectt'],
                        'description' => $lang['global_other_imageeffectd'],
                        'content' => imageEffect(),
                    ),
                )
            ),
            'globalFunc' => array(
                'title' => $lang['global_globalfunc'],
                'vars' => array(
                    'gzip' => array(
                        'title' => $lang['global_globalfunc_gzipt'],
                        'description' => $lang['global_globalfunc_gzipd'],
                        'content' => conf_radio("gzip", $config['gzip']),
                    ),
                    'off' => array(
                        'title' => $lang['global_globalfunc_offt'],
                        'description' => $lang['global_globalfunc_offd'],
                        'content' => conf_radio("off", $config['off']),
                    ),
                    'off_text' => array(
                        'title' => $lang['global_globalfunc_off_textt'],
                        'description' => $lang['global_globalfunc_off_textd'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'off_text'),
                        'multilang' => true
                    ),
                    'cache' => array(
                        'title' => $lang['global_globalfunc_cachet'],
                        'description' => $lang['global_globalfunc_cached'],
                        'content' => conf_radio("cache", $config['cache']),
                    ),
                    'dbCache' => array(
                        'title' => $lang['global_globalfunc_dbcachet'],
                        'description' => $lang['global_globalfunc_dbcached'],
                        'content' => conf_radio("dbCache", $config['dbCache']),
                    ),
                    'mod_rewrite' => array(
                        'title' => $lang['global_globalfunc_mod_rewritet'],
                        'description' => $lang['global_globalfunc_mod_rewrited'],
                        'content' => conf_radio("mod_rewrite", $config['mod_rewrite']),
                    ),
                    'comments' => array(
                        'title' => $lang['global_globalfunc_commentst'],
                        'description' => $lang['global_globalfunc_commentsd'],
                        'content' => conf_radio("comments", $config['comments']),
                    ),
                    'plugin' => array(
                        'title' => $lang['global_globalfunc_plugint'],
                        'description' => $lang['global_globalfunc_plugind'],
                        'content' => conf_radio("plugin", $config['plugin']),
                    ),
                    'redicret' => array(
                        'title' => $lang['config_global_func_redicret'],
                        'description' => $lang['config_global_func_redicret_desc'],
                        'content' => conf_radio("redicret", $config['redicret']),
                    ),
                )
            )
        ),
    ),
    'security' => array(
        'varName' => 'security',
        'title' => $lang['security'],
        'info' => $lang['security_information'],
        'groups' => array(
            'auth_admin' => array(
                'title' => $lang['auth_admin'],
                'vars' => array(
                    'auth_metod' => array(
                        'title' => $lang['auth_adminh'],
                        'description' => $lang['auth_admind'],
                        'content' => auth_admin_metod(),
                    ),
                    'auth_max_num' => array(
                        'title' => $lang['auth_max_num'],
                        'description' => $lang['auth_max_numd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                )
            ),
            'ips' => array(
                'title' => $lang['security_ips'],
                'vars' => array(
                    'banIp' => array(
                        'title' => $lang['security_ips_banipt'],
                        'description' => $lang['security_ips_banipd'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'banIp'),
                    ),
                    'banIpMessage' => array(
                        'title' => $lang['security_ips_banipmessaget'],
                        'description' => $lang['security_ips_banipmessaged'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                        'multilang' => true
                    ),
                )
            ),
            'filter' => array(
                'title' => $lang['security_filter'],
                'vars' => array(
                    'xNums' => array(
                        'title' => $lang['security_filter_xnumst'],
                        'description' => $lang['security_filter_xnumsd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'stopNick' => array(
                        'title' => $lang['security_filter_stopnickt'],
                        'description' => $lang['security_filter_stopnickd'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'stopNick'),
                    ),
                    'stopMails' => array(
                        'title' => $lang['security_filter_stopmailst'],
                        'description' => $lang['security_filter_stopmailsd'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'stopMails'),
                    ),
                    'stopWords' => array(
                        'title' => $lang['security_filter_stopwordst'],
                        'description' => $lang['security_filter_stopwordsd'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'stopWords'),
                    ),
                    'stopReplace' => array(
                        'title' => $lang['security_filter_stopreplacet'],
                        'description' => $lang['security_filter_stopreplaced'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'allowHTML' => array(
                        'title' => $lang['security_filter_allowhtmlt'],
                        'description' => $lang['security_filter_allowhtmld'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                )
            ),

            'captcha' => array(
                'title' => $lang['security_captcha'],
                'vars' => array(
                    'switch_cp' => array(
                        'title' => $lang['security_switch'],
                        'description' => $lang['security_switch_desc'],
                        'content' => conf_radio("switch_cp", $security['switch_cp']),
                    ),
                    'captcha_width' => array(
                        'title' => $lang['security_captcha_captcha_widtht'],
                        'description' => $lang['security_captcha_captcha_widthd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'captcha_height' => array(
                        'title' => $lang['security_captcha_captcha_heightt'],
                        'description' => $lang['security_captcha_captcha_heightd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'captcha_lenght' => array(
                        'title' => $lang['security_captcha_captcha_lenghtt'],
                        'description' => $lang['security_captcha_captcha_lenghtd'],
                        'content' => captcha_lenght(),
                    ),
                    'recaptcha' => array(
                        'title' => $lang['security_recaptha'],
                        'description' => $lang['security_recaptha_desc'],
                        'content' => conf_radio("recaptcha", $security['recaptcha']),
                    ),
                    'recaptcha_public' => array(
                        'title' => $lang['security_recaptha_public'],
                        'description' => $lang['security_recaptha_public_desc'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'recaptcha_public'),
                    ),
                    'recaptcha_private' => array(
                        'title' => $lang['security_recaptha_private'],
                        'description' => $lang['security_recaptha_private_desc'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'recaptcha_private'),
                    ),
                    'recaptcha_style' => array(
                        'title' => $lang['security_recaptcha_style'],
                        'description' => $lang['security_recaptcha_style_desc'],
                        'content' => recaptcha_style(),
                    ),
                    'smart_captcha' => array(
                        'title' => $lang['smart_captcha'],
                        'description' => $lang['smart_captcha_desc'],
                        'content' => conf_radio("smart_captcha", $security['smart_captcha']),
                    ),
                    'smartcaptcha_server_key' => array(
                        'title' => $lang['smart_captcha_server_key'],
                        'description' => $lang['smart_captcha_server_key_desc'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'smartcaptcha_server_key'),
                    ),

                )
            ),
        )
    ),
    'social' => array(
        'varName' => 'social',
        'title' => $lang['social_config'],
        'groups' => array(
            'main' => array(
                'title' => $lang['social_sw'],
                'vars' => array(
                    'switch' => array(
                        'title' => $lang['social_switch'],
                        'description' => $lang['social_switch_desc'],
                        'content' => conf_radio("switch", $social['switch']),
                    ),
                    'pass' => array(
                        'title' => $lang['social_pass'],
                        'description' => $lang['social_pass_desc'],
                        'content' => conf_radio("pass", $social['pass']),
                    ),
                    'admin' => array(
                        'title' => $lang['social_admin'],
                        'description' => $lang['social_admin_desc'],
                        'content' => conf_radio("admin", $social['admin']),
                    ),
                )
            ),
            'social_vk' => array(
                'title' => $lang['social_config_vk'],
                'vars' => array(
                    'vk_is' => array(
                        'title' => $lang['social_is'],
                        'description' => $lang['social_is_desc'],
                        'content' => conf_radio("vk_is", $social['vk_is']),
                    ),
                    'vk_client_id' => array(
                        'title' => $lang['social_id'],
                        'description' => $lang['social_id_desc'] . ' : ' . $lang['social_config_vk_url'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'vk_client_secret' => array(
                        'title' => $lang['social_secret'],
                        'description' => $lang['social_secret_desc'] . ': ' . $lang['social_config_vk_url'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'vk_client_secret'),
                    ),
                )
            ),
            'social_ok' => array(
                'title' => $lang['social_config_ok'],
                'vars' => array(
                    'ok_is' => array(
                        'title' => $lang['social_is'],
                        'description' => $lang['social_is_desc'],
                        'content' => conf_radio("ok_is", $social['ok_is']),
                    ),
                    'ok_client_id' => array(
                        'title' => $lang['social_id'],
                        'description' => $lang['social_id_desc'] . ' : ' . $lang['social_config_ok_url'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'ok_client_secret' => array(
                        'title' => $lang['social_secret'],
                        'description' => $lang['social_secret_desc'] . ' : ' . $lang['social_config_ok_url'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'ok_client_secret'),
                    ),
                    'ok_public_key' => array(
                        'title' => $lang['social_public'],
                        'description' => $lang['social_public_desc'] . ' : ' . $lang['social_config_ok_url'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'ok_public_key'),
                    ),
                )
            ),
            'social_tw' => array(
                'title' => $lang['social_config_tw'],
                'vars' => array(
                    'tw_is' => array(
                        'title' => $lang['social_is'],
                        'description' => $lang['social_is_desc'],
                        'content' => conf_radio("fb_is", $social['tw_is']),
                    ),
                    'tw_client_id' => array(
                        'title' => $lang['social_id'],
                        'description' => $lang['social_id_desc'] . ' : ' . $lang['social_config_tw_url'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'tw_client_secret' => array(
                        'title' => $lang['social_secret'],
                        'description' => $lang['social_secret_desc'] . ' : ' . $lang['social_config_tw_url'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'tw_client_secret'),
                    ),
                )
            ),
            'social_fb' => array(
                'title' => $lang['social_config_fb'],
                'vars' => array(
                    'fb_is' => array(
                        'title' => $lang['social_is'],
                        'description' => $lang['social_is_desc'],
                        'content' => conf_radio("fb_is", $social['fb_is']),
                    ),
                    'fb_client_id' => array(
                        'title' => $lang['social_id'],
                        'description' => $lang['social_id_desc'] . ' : ' . $lang['social_config_fb_url'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'fb_client_secret' => array(
                        'title' => $lang['social_secret'],
                        'description' => $lang['social_secret_desc'] . ' : ' . $lang['social_config_fb_url'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'fb_client_secret'),
                    ),
                )
            ),
            'social_gg' => array(
                'title' => $lang['social_config_gg'],
                'vars' => array(
                    'gg_is' => array(
                        'title' => $lang['social_is'],
                        'description' => $lang['social_is_desc'],
                        'content' => conf_radio("gg_is", $social['gg_is']),
                    ),
                    'gg_client_id' => array(
                        'title' => $lang['social_id'],
                        'description' => $lang['social_id_desc'] . ' : ' . $lang['social_config_gg_url'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'gg_client_secret' => array(
                        'title' => $lang['social_secret'],
                        'description' => $lang['social_secret_desc'] . ' : ' . $lang['social_config_gg_url'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'gg_client_secret'),
                    ),
                )
            ),
            'social_ya' => array(
                'title' => $lang['social_config_ya'],
                'vars' => array(
                    'ya_is' => array(
                        'title' => $lang['social_is'],
                        'description' => $lang['social_is_desc'],
                        'content' => conf_radio("ya_is", $social['ya_is']),
                    ),
                    'ya_client_id' => array(
                        'title' => $lang['social_id'],
                        'description' => $lang['social_id_desc'] . ' : ' . $lang['social_config_ya_url'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'ya_client_secret' => array(
                        'title' => $lang['social_secret'],
                        'description' => $lang['social_secret_desc'] . ' : ' . $lang['social_config_ya_url'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'ya_client_secret'),
                    ),
                )
            ),
            'social_mm' => array(
                'title' => $lang['social_config_mm'],
                'vars' => array(
                    'mm_is' => array(
                        'title' => $lang['social_is'],
                        'description' => $lang['social_is_desc'],
                        'content' => conf_radio("mm_is", $social['mm_is']),
                    ),
                    'mm_client_id' => array(
                        'title' => $lang['social_id'],
                        'description' => $lang['social_id_desc'] . ' : ' . $lang['social_config_mm_url'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'mm_client_secret' => array(
                        'title' => $lang['social_secret'],
                        'description' => $lang['social_secret_desc'] . ' : ' . $lang['social_config_mm_url'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'mm_client_secret'),
                    ),
                )
            ),
            'social_sk' => array(
                'title' => $lang['social_config_sk'],
                'vars' => array(
                    'sk_is' => array(
                        'title' => $lang['social_is'],
                        'description' => $lang['social_is_desc'],
                        'content' => conf_radio("sk_is", $social['sk_is']),
                    ),
                    'sk_client_id' => array(
                        'title' => $lang['social_id'],
                        'description' => $lang['social_id_desc'] . ' : ' . $lang['social_config_sk_url'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'sk_client_secret' => array(
                        'title' => $lang['social_secret'],
                        'description' => $lang['social_secret_desc'] . ' : ' . $lang['social_config_sk_url'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'sk_client_secret'),
                    ),
                )
            ),
        )
    ),
    'files' => array(
        'varName' => 'files_conf',
        'title' => $lang['files'],
        'groups' => array(
            'file' => array(
                'title' => $lang['files_file'],
                'vars' => array(
                    'imgFormats' => array(
                        'title' => $lang['files_file_imgformatst'],
                        'description' => $lang['files_file_imgformatsd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'audioFormats' => array(
                        'title' => $lang['files_file_audioformatst'],
                        'description' => $lang['files_file_audiosformatsd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'videoFormats' => array(
                        'title' => $lang['files_file_videoformatst'],
                        'description' => $lang['files_file_videosformatsd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'textFormats' => array(
                        'title' => $lang['files_file_textformatst'],
                        'description' => $lang['files_file_textformatsd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'archiveFormats' => array(
                        'title' => $lang['files_file_archiveformatst'],
                        'description' => $lang['files_file_archivesformatsd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'filesFormats' => array(
                        'title' => $lang['files_file_filesformatst'],
                        'description' => $lang['files_file_filesformatsd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'attachFormats' => array(
                        'title' => $lang['files_file_attachformatst'],
                        'description' => $lang['files_file_attachformatsd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'max_size' => array(
                        'title' => $lang['files_file_max_sizet'],
                        'description' => $lang['files_file_max_sized'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'download_file' => array(
                        'title' => $lang['files_download_filet'],
                        'description' => $lang['files_download_filed'],
                        'content' => download_file(),
                    ),
                )
            ),
            'thumb' => array(
                'title' => $lang['files_thumb'],
                'vars' => array(
                    'thumb_width' => array(
                        'title' => $lang['files_thumb_thumb_widtht'],
                        'description' => $lang['files_thumb_thumb_widthd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'quality' => array(
                        'title' => $lang['files_thumb_qualityt'],
                        'description' => $lang['files_thumb_qualityd'],
                        'content' => waterMarkQuality(),
                    ),
                )
            ),
            'watermark' => array(
                'title' => $lang['files_watermark'],
                'vars' => array(
                    'watermark' => array(
                        'title' => $lang['files_watermark_watermarkt'],
                        'description' => $lang['files_watermark_watermarkd'],
                        'content' => yesNo('files', 'files_conf', 'watermark'),
                    ),
                    'watermark_text' => array(
                        'title' => $lang['files_watermark_watermark_textt'],
                        'description' => $lang['files_watermark_watermark_textd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'watermark_image' => array(
                        'title' => $lang['files_watermark_watermark_imaget'],
                        'description' => $lang['files_watermark_watermark_imaged'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'watermark_valign' => array(
                        'title' => $lang['files_watermark_watermark_valignt'],
                        'description' => $lang['files_watermark_watermark_valignd'],
                        'content' => waterMarkVertical(),
                    ),
                    'watermark_halign' => array(
                        'title' => $lang['files_watermark_watermark_halignt'],
                        'description' => $lang['files_watermark_watermark_halignd'],
                        'content' => waterMarkHorizonts(),
                    ),
                )
            ),
        )
    ),
    'cache' => array(
        'varName' => 'allowCahce',
        'title' => $lang['cache_config'],
        'groups' => array(
            'file' => array(
                'title' => $lang['cache_config'],
                'vars' => array(
                    'tplFiles' => array(
                        'title' => $lang['cache_tpl'],
                        'description' => $lang['cache_tpl_desc'],
                        'content' => conf_radio("tplFiles", $allowCahce['tplFiles']),
                    ),
                    'plugins' => array(
                        'title' => $lang['cache_block'],
                        'description' => $lang['cache_block_desc'],
                        'content' => conf_radio("plugins", $allowCahce['plugins']),
                    ),
                    'categories' => array(
                        'title' => $lang['cache_cat'],
                        'description' => $lang['cache_cat_desc'],
                        'content' => conf_radio("categories", $allowCahce['categories']),
                    ),
                    'userInfo' => array(
                        'title' => $lang['cache_user'],
                        'description' => $lang['cache_user_desc'],
                        'content' => conf_radio("userInfo", $allowCahce['userInfo']),
                    ),
                )
            ),
        )
    ),
    'admin' => array(
        'varName' => 'admin_conf',
        'title' => $lang['admin'],
        'groups' => array(
            'hide' => array(
                'title' => $lang['admin_main_status'],
                'vars' => array(
                    'hide' => array(
                        'title' => $lang['admin_statust'],
                        'description' => $lang['admin_statusd'],
                        'content' => hide_admin_status(),
                    ),
                )
            ),
            'designPanel' => array(
                'title' => $lang['admin_main_color'],
                'vars' => array(
                    'colorPanel' => array(
                        'title' => $lang['admin_colort'],
                        'description' => $lang['admin_colord'],
                        'content' => conf_color(),
                    ),
                    'inline' => array(
                        'title' => $lang['admin_fieldt'],
                        'description' => $lang['admin_fieldd'],
                        'content' => inline('admin_conf', 'inline'),
                    ),
                    'upbtn' => array(
                        'title' => $lang['admin_upbtnt'],
                        'description' => $lang['admin_upbtnd'],
                        'content' => yesNo('admin', 'admin_conf', 'upbtn'),
                    ),
                )
            ),
            'alert' => array(
                'title' => $lang['alert_message'],
                'vars' => array(
                    'alert_danger' => array(
                        'title' => $lang['apalert_main_danger'],
                        'description' => $lang['apalert_main_use'],
                        'content' => alertTimes('alert_danger'),
                    ),
                    'alert_warning' => array(
                        'title' => $lang['apalert_main_warning'],
                        'description' => $lang['apalert_main_use'],
                        'content' => alertTimes('alert_warning'),
                    ),
                    'alert_success' => array(
                        'title' => $lang['apalert_main_success'],
                        'description' => $lang['apalert_main_use'],
                        'content' => alertTimes('alert_success'),
                    ),
                    'alert_info' => array(
                        'title' => $lang['apalert_main_info'],
                        'description' => $lang['apalert_main_use'],
                        'content' => alertTimes('alert_info'),
                    ),
                    'alert_system' => array(
                        'title' => $lang['apalert_main_system'],
                        'description' => $lang['apalert_main_use'],
                        'content' => alertTimes('alert_system'),
                    ),
                    'alert_alert' => array(
                        'title' => $lang['apalert_main_alert'],
                        'description' => $lang['apalert_main_use'],
                        'content' => alertTimes('alert_alert'),
                    ),
                    'alert_primary' => array(
                        'title' => $lang['apalert_main_primary'],
                        'description' => $lang['apalert_main_use'],
                        'content' => alertTimes('alert_primary'),
                    ),
                    'alert_default' => array(
                        'title' => $lang['apalert_main_default'],
                        'description' => $lang['apalert_main_use'],
                        'content' => alertTimes('alert_default'),
                    ),
                    'alert_dark' => array(
                        'title' => $lang['apalert_main_dark'],
                        'description' => $lang['apalert_main_use'],
                        'content' => alertTimes('alert_dark'),
                    ),
                )
            ),
            'message' => array(
                'title' => $lang['user_message'],
                'vars' => array(
                    'user_pm' => array(
                        'title' => $lang['apsend_main_pm'],
                        'description' => $lang['apsend_main_pm_use'],
                        'content' => yesNo('admin', 'admin_conf', 'user_pm'),
                    ),
                    'user_mail' => array(
                        'title' => $lang['apsend_main_email'],
                        'description' => $lang['apsend_main_email_use'],
                        'content' => yesNo('admin', 'admin_conf', 'user_mail'),
                    ),
                    'html_user_mail' => array(
                        'title' => $lang['apsend_main_email_html'],
                        'description' => $lang['apsend_main_email_use_html'],
                        'content' => yesNo('admin', 'admin_conf', 'html_user_mail'),
                    ),
                )
            ),
            'main' => array(
                'title' => $lang['files_file'],
                'vars' => array(
                    'num' => array(
                        'title' => $lang['admin_main_numt'],
                        'description' => $lang['admin_main_numd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'uploading_data' => array(
                        'title' => $lang['admin_main_uploading_datat'],
                        'description' => $lang['admin_main_uploading_datad'],
                        'content' => yesNo('admin', 'admin_conf', 'uploading_data'),
                    ),
                    'audio_alert' => array(
                        'title' => $lang['admin_main_audio_alertt'],
                        'description' => $lang['admin_main_audio_alertd'],
                        'content' => yesNo('admin', 'admin_conf', 'audio_alert'),
                    ),
                    'ipaccess' => array(
                        'title' => $lang['admin_main_ipaccesst'],
                        'description' => $lang['admin_main_ipaccessd'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'ipaccess') . $lang['admin_main_ipaccess_help'],
                    ),
                    'sessions' => array(
                        'title' => $lang['admin_main_sessionst'],
                        'description' => $lang['admin_main_sessionsd'],
                        'content' => yesNo('admin', 'admin_conf', 'sessions'),
                    ),
                    'htmlEditor' => array(
                        'title' => $lang['admin_htmleditort'],
                        'description' => $lang['admin_htmleditord'],
                        'content' => yesNo('admin', 'admin_conf', 'htmlEditor'),
                    ),
                )
            ),
            'main_page' => array(
                'title' => $lang['main_page'],
                'vars' => array(
                    'lastcom' => array(
                        'title' => $lang['admin_main_lastcomt'],
                        'description' => $lang['admin_main_lastcomd'],
                        'content' => yesNo('admin', 'admin_conf', 'lastcom'),
                    ),
                    'lastcom_news_img_height' => array(
                        'title' => $lang['admin_main_lastcom_heightt'],
                        'description' => $lang['admin_main_lastcom_heightd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'lastcom_news_img_widtht' => array(
                        'title' => $lang['admin_main_lastcom_widthtt'],
                        'description' => $lang['admin_main_lastcom_widthtd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'numlastcom' => array(
                        'title' => $lang['admin_lastcom_numt'],
                        'description' => $lang['admin_lastcom_numd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'lastuser' => array(
                        'title' => $lang['admin_main_lastusert'],
                        'description' => $lang['admin_main_lastuserd'],
                        'content' => yesNo('admin', 'admin_conf', 'lastuser'),
                    ),
                    'numlastuser' => array(
                        'title' => $lang['admin_lastuser_numt'],
                        'description' => $lang['admin_lastuser_numd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'last_action' => array(
                        'title' => $lang['admin_main_last_actiont'],
                        'description' => $lang['admin_main_last_actiond'],
                        'content' => yesNo('admin', 'admin_conf', 'last_action'),
                    ),
                    'server_stats' => array(
                        'title' => $lang['admin_main_server_statst'],
                        'description' => $lang['admin_main_server_statsd'],
                        'content' => yesNo('admin', 'admin_conf', 'server_stats'),
                    ),
                    'notepad' => array(
                        'title' => $lang['admin_main_notepadt'],
                        'description' => $lang['admin_main_notepadd'],
                        'content' => yesNo('admin', 'admin_conf', 'notepad'),
                    ),
                )
            ),
        )
    ),
    'user' => array(
        'varName' => 'user',
        'title' => $lang['users'],
        'groups' => array(
            'authorization' => array(
                'title' => $lang['user_authorization'],
                'vars' => array(
                    'auth_open' => array(
                        'title' => $lang['auth_website'],
                        'description' => $lang['auth_webclose'],
                        'content' => conf_auth('user', 'auth_open'),
                    ),
                    'auth_metod' => array(
                        'title' => $lang['auth_mauth'],
                        'description' => $lang['auth_mauthd'],
                        'content' => auth_metod(),
                    ),
                )
            ),
            'register' => array(
                'title' => $lang['user_register'],
                'vars' => array(
                    'off_reg' => array(
                        'title' => $lang['off_reg'],
                        'description' => $lang['off_rege'],
                        'content' => yesNo('user', 'user', 'off_reg'),
                    ),
                    'with_activate' => array(
                        'title' => $lang['user_register_with_activatet'],
                        'description' => $lang['user_register_with_activated'],
                        'content' => yesNo('user', 'user', 'with_activate'),
                    ),
                )
            ),
            'main' => array(
                'title' => $lang['user_main'],
                'vars' => array(
                    'guestGroup' => array(
                        'title' => $lang['user_main_guestgroupt'],
                        'description' => $lang['user_main_guestgroupd'],
                        'content' => changeuGroup('guestGroup'),
                    ),
                    'botGroup' => array(
                        'title' => $lang['user_main_botgroupt'],
                        'description' => $lang['user_main_botgroupd'],
                        'content' => changeuGroup('botGroup'),
                    ),
                    'banGroup' => array(
                        'title' => $lang['user_main_bangroupt'],
                        'description' => $lang['user_main_bangroupd'],
                        'content' => changeuGroup('banGroup'),
                    ),
                    'count_points' => array(
                        'title' => $lang['user_count_pointst'],
                        'description' => $lang['user_count_pointsd'],
                        'content' => yesNo('user', 'user', 'count_points'),
                    ),
                )
            ),
            'avatar' => array(
                'title' => $lang['user_avatar'],
                'vars' => array(
                    'noAvatar' => array(
                        'title' => $lang['user_avatar_noavatart'],
                        'description' => $lang['user_avatar_noavatard'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'avatarGuest' => array(
                        'title' => $lang['avatarguest'],
                        'description' => $lang['avatarguestd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'avatar_load' => array(
                        'title' => $lang['user_avatar_loadt'],
                        'description' => $lang['user_avatar_loadd'],
                        'content' => yesNo('user', 'user', 'avatar_load'),
                    ),
                    'avatar_width' => array(
                        'title' => $lang['user_avatar_widtht'],
                        'description' => $lang['user_avatar_widthd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'avatar_height' => array(
                        'title' => $lang['user_avatar_heightt'],
                        'description' => $lang['user_avatar_heightd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'avatar_size' => array(
                        'title' => $lang['user_avatar_sizet'],
                        'description' => $lang['user_avatar_sized'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                )
            ),
            'pimage' => array(
                'title' => $lang['user_pimage'],
                'vars' => array(
                    'noPimage' => array(
                        'title' => $lang['user_pimage_nopimaget'],
                        'description' => $lang['user_pimage_nopimaged'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'pimage_load' => array(
                        'title' => $lang['user_pimage_loadt'],
                        'description' => $lang['user_pimage_loadd'],
                        'content' => yesNo('user', 'user', 'pimage_load'),
                    ),
                    'pimage_width' => array(
                        'title' => $lang['user_pimage_widtht'],
                        'description' => $lang['user_pimage_widthd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'pimage_height' => array(
                        'title' => $lang['user_pimage_heightt'],
                        'description' => $lang['user_pimage_heightd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'pimage_size' => array(
                        'title' => $lang['user_pimage_sizet'],
                        'description' => $lang['user_pimage_sized'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                )
            ),
            'bbEditor' => array(
                'title' => $lang['user_bbeditor'],
                'vars' => array(
                    'activeFlash' => array(
                        'title' => $lang['user_bbeditor_activeflasht'],
                        'description' => $lang['user_bbeditor_activeflashd'],
                        'content' => yesNo('user', 'user', 'activeFlash'),
                    ),
                    'activeVideo' => array(
                        'title' => $lang['user_bbeditor_activevideot'],
                        'description' => $lang['user_bbeditor_activevideod'],
                        'content' => yesNo('user', 'user', 'activeVideo'),
                    ),
                    'activeAudio' => array(
                        'title' => $lang['user_bbeditor_activeaudiot'],
                        'description' => $lang['user_bbeditor_activeaudiod'],
                        'content' => yesNo('user', 'user', 'activeAudio'),
                    ),
                    'activeAttach' => array(
                        'title' => $lang['user_bbeditor_activeattacht'],
                        'description' => $lang['user_bbeditor_activeattachd'],
                        'content' => yesNo('user', 'user', 'activeAttach'),
                    ),
                    'editor' => array(
                        'title' => $lang['user_bbeditor_editort'],
                        'description' => $lang['user_bbeditor_editord'],
                        'content' => conf_editor(),
                    ),
                    'bbViz' => array(
                        'title' => $lang['user_bbeditor_bbvizt'],
                        'description' => $lang['user_bbeditor_bbvizd'],
                        'content' => yesNo('user', 'user', 'bbViz'),
                    ),
                    'highlightCode' => array(
                        'title' => $lang['user_bbeditor_highlgihtt'],
                        'description' => $lang['user_bbeditor_highlgihtd'],
                        'content' => yesNo('user', 'user', 'highlightCode'),
                    ),
                )
            ),
            'comments' => array(
                'title' => $lang['user_comments'],
                'vars' => array(
                    'commentOften' => array(
                        'title' => $lang['user_comments_commentoftent'],
                        'description' => $lang['user_comments_commentoftend'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'commentEditText' => array(
                        'title' => $lang['user_comments_commedtext'],
                        'description' => $lang['user_comments_commedtextd'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'commentEditText'),
                        'html' => true
                    ),
                    'commentSignature' => array(
                        'title' => $lang['user_comments_signaturet'],
                        'description' => $lang['user_comments_signatured'],
                        'content' => int_cong('textarea', '{varName}', '{var}', 'commentSignature'),
                        'html' => true
                    ),
                    'commentSubscribe' => array(
                        'title' => $lang['user_comments_subscribet'],
                        'description' => $lang['user_comments_subscribed'],
                        'content' => yesNo('user', 'user', 'commentSubscribe'),
                    ),
                    'commentModeration' => array(
                        'title' => $lang['user_comments_commmoderate'],
                        'description' => $lang['user_comments_commmoderated'],
                        'content' => yesNo('user', 'user', 'commentModeration'),
                    ),
                    'commentTree' => array(
                        'title' => $lang['user_comments_commtreet'],
                        'description' => $lang['user_comments_commtreed'],
                        'content' => yesNo('user', 'user', 'commentTree'),
                    ),
                )
            ),
            'message' => array(
                'title' => $lang['user_message'],
                'vars' => array(
                    'pm_limit' => array(
                        'title' => $lang['user_message_pmlimitt'],
                        'description' => $lang['user_message_pmlimitd'],
                        'content' => yesNo('user', 'user', 'pm_limit'),
                    ),
                    'max_pm' => array(
                        'title' => $lang['user_message_pmwallnumt'],
                        'description' => $lang['user_message_pmwallnumd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'pmShown' => array(
                        'title' => $lang['user_message_pmshownt'],
                        'description' => $lang['user_message_pmshownd'],
                        'content' => yesNo('user', 'user', 'pmShown'),
                    ),
                )
            ),
            'ratings' => array(
                'title' => $lang['user_ratings'],
                'vars' => array(
                    'limitStar' => array(
                        'title' => $lang['user_ratings_limitstart'],
                        'description' => $lang['user_ratings_limitstard'],
                        'content' => limitStar(),
                    ),
                    'limitStar_1' => array(
                        'title' => $lang['user_limitstart1'],
                        'description' => $lang['user_limitstard'],
                        'content' => limitNumStar('limitStar_1'),
                    ),
                    'limitStar_2' => array(
                        'title' => $lang['user_limitstart2'],
                        'description' => $lang['user_limitstard'],
                        'content' => limitNumStar('limitStar_2')
                    ),
                    'limitStar_3' => array(
                        'title' => $lang['user_limitstart3'],
                        'description' => $lang['user_limitstard'],
                        'content' => limitNumStar('limitStar_3')
                    ),
                    'limitStar_4' => array(
                        'title' => $lang['user_limitstart4'],
                        'description' => $lang['user_limitstard'],
                        'content' => limitNumStar('limitStar_4')
                    ),
                    'limitStar_5' => array(
                        'title' => $lang['user_limitstart5'],
                        'description' => $lang['user_limitstard'],
                        'content' => limitNumStar('limitStar_5')
                    ),
                    'limitStar_6' => array(
                        'title' => $lang['user_limitstart6'],
                        'description' => $lang['user_limitstard'],
                        'content' => limitNumStar('limitStar_6')
                    ),
                    'limitStar_7' => array(
                        'title' => $lang['user_limitstart7'],
                        'description' => $lang['user_limitstard'],
                        'content' => limitNumStar('limitStar_7')
                    ),
                    'limitStar_8' => array(
                        'title' => $lang['user_limitstart8'],
                        'description' => $lang['user_limitstard'],
                        'content' => limitNumStar('limitStar_8')
                    ),
                    'limitStar_9' => array(
                        'title' => $lang['user_limitstart9'],
                        'description' => $lang['user_limitstard'],
                        'content' => limitNumStar('limitStar_9')
                    ),
                    'limitStar_10' => array(
                        'title' => $lang['user_limitstart10'],
                        'description' => $lang['user_limitstard'],
                        'content' => limitNumStar('limitStar_10')
                    ),
                    'starStyle' => array(
                        'title' => $lang['user_ratings_starstylet'],
                        'description' => $lang['user_ratings_starstyled'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'carma_rate' => array(
                        'title' => $lang['user_ratings_carma_ratet'],
                        'description' => $lang['user_ratings_carma_rated'],
                        'content' => yesNo('user', 'user', 'carma_rate'),
                    ),
                    'carma_newrate' => array(
                        'title' => $lang['user_ratings_carma_newratet'],
                        'description' => $lang['user_ratings_carma_summd'],
                        'content' => yesNo('user', 'user', 'carma_newrate'),
                    ),
                    'carma_summ' => array(
                        'title' => $lang['user_ratings_carma_summt'],
                        'description' => $lang['user_ratings_carma_summd'],
                        'content' => yesNo('user', 'user', 'carma_summ'),
                    ),
                )
            ),
            'other' => array(
                'title' => $lang['user_other'],
                'vars' => array(
                    'isBan' => array(
                        'title' => $lang['user_other_isbant'],
                        'description' => $lang['user_other_isband'],
                        'content' => yesNo('user', 'user', 'isBan'),
                    ),
                    'userWall' => array(
                        'title' => $lang['user_other_userwallt'],
                        'description' => $lang['user_other_userwalld'],
                        'content' => yesNo('user', 'user', 'userWall'),
                    ),
                    'userWallNum' => array(
                        'title' => $lang['user_other_userwallnumt'],
                        'description' => $lang['user_other_userwallnumd'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'userFriends' => array(
                        'title' => $lang['user_other_userfriendst'],
                        'description' => $lang['user_other_userfriendsd'],
                        'content' => yesNo('user', 'user', 'userWall'),
                    ),
                    'userGuests' => array(
                        'title' => $lang['user_other_userguestst'],
                        'description' => $lang['user_other_userguestsd'],
                        'content' => yesNo('user', 'user', 'userWall'),
                    ),
                    'readBlog' => array(
                        'title' => $lang['user_other_readblogt'],
                        'description' => $lang['user_other_readblogd'],
                        'content' => yesNo('user', 'user', 'readBlog'),
                    ),
                )
            ),
        )
    ),
    'log' => array(
        'varName' => 'log_conf',
        'title' => $lang['log'],
        'groups' => array(
            'main' => array(
                'title' => $lang['log_main'],
                'vars' => array(
                    'display_php_errors' => array(
                        'title' => $lang['log_main_phpdebugt'],
                        'description' => $lang['log_main_phpdebugd'],
                        'content' => conf_radio("display_php_errors", $log_conf['display_php_errors']),
                    ),
                    'phpError' => array(
                        'title' => $lang['log_main_phperrort'],
                        'description' => $lang['log_main_phperrord'],
                        'content' => conf_radio("phpError", $log_conf['phpError']),
                    ),
                    'queryError' => array(
                        'title' => $lang['log_main_queryerrort'],
                        'description' => $lang['log_main_queryerrord'],
                        'content' => conf_radio("queryError", $log_conf['queryError']),
                    ),
                    'dbError' => array(
                        'title' => $lang['log_main_dberrort'],
                        'description' => $lang['log_main_dberrord'],
                        'content' => conf_radio("dbError", $log_conf['dbError']),
                    ),
                    'accesError' => array(
                        'title' => $lang['log_main_acceserrort'],
                        'description' => $lang['log_main_acceserrord'],
                        'content' => conf_radio("accesError", $log_conf['accesError']),
                    ),
                    'compressSize' => array(
                        'title' => $lang['log_main_compresssizet'],
                        'description' => $lang['log_main_compresssized'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                )
            ),
        )
    ),
);
function conf_smtp(): string
{
    global $config, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[smtp_helo]">
<option value="ELHO"' . ($config['smtp_helo'] == "ELHO" ? "selected" : "") . '>' . $lang['global_smtphelo_elho'] . '</option>
<option value="HELO"' . ($config['smtp_helo'] == "HELO" ? "selected" : "") . '>' . $lang['global_smtphelo_helo'] . '</option>
</select>';
}

function conf_color(): string
{
    global $admin_conf, $config, $lang;
    colorpickerInit('color_p', $admin_conf['colorPanel']);
    return '<div id="color_p"	class="input-group pull-right">
   <input type="text" name="' . $config['lang'] . '[colorPanel]" class="form-control"	value="' . $admin_conf['colorPanel'] . '">
   <span title="' . $lang['admin_choose_color'] . '" class="input-group-addon colorpicker-component cursor"><i></i></span>
</div>';
}

function conf_smtp_mmd(): string
{
    global $config, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[smtp_php]">
<option value="php"' . ($config['smtp_php'] == "php" ? "selected" : "") . '>' . $lang['global_smtp_php'] . '</option>
<option value="smtp"' . ($config['smtp_php'] == "smtp" ? "selected" : "") . '>' . $lang['global_smtp'] . '</option>
</select>';
}

function conf_smtp_secure(): string
{
    global $config, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[smtp_secure]">
<option value=""' . ($config['smtp_secure'] == "" ? "selected" : "") . '>' . $lang['global_ssl_empty'] . '</option>
<option value="ssl"' . ($config['smtp_secure'] == "ssl" ? "selected" : "") . '>' . $lang['global_ssl'] . '</option>
<option value="tls"' . ($config['smtp_secure'] == "tls" ? "selected" : "") . '>' . $lang['global_tls'] . '</option>
</select>';
}

function conf_editor(): string
{
    global $config, $user, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[editor]">
<option value="bb"' . ($user['editor'] == "bb" ? "selected" : "") . '>' . $lang['bb_editor'] . '</option>
<option value="htmlEditor"' . ($user['editor'] == "htmlEditor" ? "selected" : "") . '>' . $lang['html_editor'] . '</option>
</select>';
}

function conf_auth($global, $var): string
{
    global $$global;
    $conf = $$global;
    $but_1 = ($conf[$var] == 1) ? "checked" : "";
    return '<div class="switch switch-info round switch-inline">
   <input type="hidden" name="{varName}" value="0">
   <input id="ch{varName}" name="{varName}" type="checkbox"' . $but_1 . ' value="1">
   <label for="ch{varName}"></label>
</div>';
}

function conf_radio($name, $val)
{
    $but_1 = ($val) ? 'checked=""' : '';
    return '<div class="switch switch-info round switch-inline">
   <input type="hidden" name="{varName}" value="0">
   <input id="ch{varName}" name="{varName}" type="checkbox"' . $but_1 . ' value="1">
   <label for="ch{varName}"></label>
</div>';
}

function changeuGroup($var)
{
    global $core, $db, $user;
    $content = '<select class="form-control" name="{varName}">';
    $query2 = $core->select_data('groups');
    while ($rows2 = $db->getRow($query2)) {
        $sel = ($user[$var] == $rows2['id']) ? 'selected' : '';
        $content .= '<option value="' . $rows2['id'] . '"' . $sel . '>' . Glang($rows2['name']) . '</option>';
    }
    $content .= '</select>';
    return $content;
}

function changeModule(): string
{
    global $config, $core;
    $exceMods = array('feed', 'pm', 'search', 'poll');
    $content = '<select class="form-control" name="{varName}">';
    foreach ($core->getModList() as $module) {
        if (!in_array($module, $exceMods) && !empty($core->tpl->modules[$module])) {
            $selected = ($module == $config['mainModule']) ? "selected" : "";
            $content .= '<option value="' . $module . '"' . $selected . '>' . Glang(_mName($module)) . '</option>';
        }
    }
    $content .= '</select>';
    return $content;
}

function yesNo($file, $global, $var): string
{
    global $$global;
    $conf = $$global;
    $but_1 = ($conf[$var] == 1) ? "checked" : "";
    return '<div class="switch switch-info round switch-inline">
   <input type="hidden" name="{varName}" value="0">
   <input id="ch{varName}" name="{varName}" type="checkbox"' . $but_1 . ' value="1">
   <label for="ch{varName}"></label>
</div>';
}

function check($global, $var): string
{
    global $$global;
    $conf = $$global;
    $but_1 = ($conf[$var] == 1) ? "checked" : "";
    return '<div class="checkbox-custom mb15 text-right">
   <input type="hidden" name="{varName}" value="0">
   <input id="ch{varName}" name="{varName}" type="checkbox"' . $but_1 . ' value="1">
   <label for="ch{varName}"></label>
</div>';
}

function inline($global, $var): string
{
    global $$global, $lang;
    $conf = $$global;
    $but_1 = ($conf[$var] == 0) ? "checked" : "";
    $but_2 = ($conf[$var] == 1) ? "checked" : "";
    return '<div class="checkbox-custom  mb15">
   <input id="ch{varName}" name="{varName}" type="radio"' . $but_1 . ' value="0">
   <label for="ch{varName}">' . $lang['admin_classic'] . '</label>
   <input id="cn{varName}" name="{varName}" type="radio"' . $but_2 . ' value="1">
   <label for="cn{varName}">' . $lang['admin_material'] . '</label>
</div>';
}

function download_file(): string
{
    global $files_conf, $config, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[download_file]">
<option value="disable_all"' . ($files_conf['download_file'] == "disable_all" ? "selected" : "") . '>' . $lang['files_download_file_disable_all'] . '</option>
<option value="enable_all"' . ($files_conf['download_file'] == "enable_all" ? "selected" : "") . '>' . $lang['files_download_file_enable_all'] . '</option>
<option value="enable_reg"' . ($files_conf['download_file'] == "enable_reg" ? "selected" : "") . '>' . $lang['files_download_file_enable_reg'] . '</option>
</select>';
}

function waterMarkQuality(): string
{
    global $files_conf, $select;
    $content = '<select class="form-control" style="width:100%;max-width:350px;"	name="{varName}">';
    foreach (range(10, 100, 10) as $number) {
        if ($files_conf['quality'] == $number) $select = ' selected';
        $content .= '<option value="' . $number . '"' . $select . '>' . $number . '%</option>';
    }
    $content .= '</select>';
    return $content;
}

function waterMarkVertical(): string
{
    global $files_conf, $config, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[watermark_valign]">
<option value="top"' . ($files_conf['watermark_valign'] == "top" ? "selected" : "") . '>' . $lang['files_watermark_top_valignd'] . '</option>
<option value="middle"' . ($files_conf['watermark_valign'] == "middle" ? "selected" : "") . '>' . $lang['files_watermark_middle_valignd'] . '</option>
<option value="bottom"' . ($files_conf['watermark_valign'] == "bottom" ? "selected" : "") . '>' . $lang['files_watermark_bottom_valignd'] . '</option>
</select>';
}

function waterMarkHorizonts(): string
{
    global $files_conf, $config, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[watermark_halign]">
<option value="left"' . ($files_conf['watermark_halign'] == "left" ? "selected" : "") . '>' . $lang['files_watermark_left_halignt'] . '</option>
<option value="center"' . ($files_conf['watermark_halign'] == "center" ? "selected" : "") . '>' . $lang['files_watermark_center_halignt'] . '</option>
<option value="right"' . ($files_conf['watermark_halign'] == "right" ? "selected" : "") . '>' . $lang['files_watermark_right_halignt'] . '</option>
</select>';
}

function changeLang(): string
{
    global $config, $core;
    $lang_dirs = get_folder('langs');
    $lang_icon = '';
    foreach ($lang_dirs as $key => $value) {
        if (isset($value['icon']) and $value['icon']) $lang_icon .= '<img src="langs/' . $key . '/' . $value['icon'] . '">';
        $content = '<select class="form-control" name="' . $config['lang'] . '[lang]" id="lang" class="form-control">';
        foreach ($core->getLangList(true) as $massa) {
            $selected = ($config['lang'] == $massa[0]) ? "selected" : "";
            $content .= $lang_icon;
            $content .= '<option value="' . $massa[0] . '"' . $selected . '>' . $massa[1] . '</option>';
        }
        $content .= '</select>';
    }
    return $content;
}

function auth_metod(): string
{
    global $config, $user, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[auth_metod]">
<option value="nick"' . ($user['auth_metod'] == "nick" ? "selected" : "") . '>' . $lang['auth_login'] . '</option>
<option value="email"' . ($user['auth_metod'] == "email" ? "selected" : "") . '>' . $lang['auth_email'] . '</option>
</select>';
}

function limitNumStar($num): string
{
    global $user, $config, $lang;
    $langs = array(0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 105, 110, 115, 120, 125, 130, 135, 140, 145, 150);
    $nums = '<input style="width: 350px;" value="' . $user[$num] . '" type="range" name="' . $config['lang'] . '[' . $num . ']" step="1" min="0" max="150" list="NumStarList_' . $num . '" onchange="document . getElementById(\'NumStarValue_' . $num . '\').innerHTML = this.value;">
<datalist id="NumStarList_' . $num . '">';
    for ($i = 0; $i < 31; $i++) {
        $nums .= '<option value="' . $langs[$i] . '" label="' . $langs[$i] . '"' . ($user[$num] == "' . $num . '" ? "range" : "") . '></option>';
    }
    $nums .= '</datalist>
<span id="NumStarValue_' . $num . '">' . $user[$num] == 0 ? $lang['off'] : $user[$num] . '</span>';
    return $nums;
}

function limitStar(): string
{
    global $user, $config;
    $langs = array(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
    $limitStar = '<input style="width: 350px;" value="' . $user['limitStar'] . '" type="range" name="' . $config['lang'] . '[limitStar]" step="1" min="1" max="10" list="limitStarList" onchange="document.getElementById(\'limitStarValue\').innerHTML = this.value;">
<datalist id="limitStarList">';
    for ($i = 0; $i < 10; $i++) {
        $limitStar .= '<option value="' . $langs[$i] . '" label="' . $langs[$i] . '"' . ($user['limitStar'] == "' . $langs[$i] . '" ? "range" : "") . '></option>';
    }
    $limitStar .= '</datalist>
<span id="limitStarValue">' . $user['limitStar'] . '</span>';
    return $limitStar;
}

function captcha_lenght(): string
{
    global $security, $config;
    $langs = array(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
    $captcha_lenght = '<input style="width: 350px;" value="' . $security['captcha_lenght'] . '" type="range" name="' . $config['lang'] . '[captcha_lenght]" step="1" min="1" max="10" list="captcha_lenghtList" onchange="document.getElementById(\'captcha_lenghtValue\').innerHTML = this.value;">
<datalist id="captcha_lenghtList">';
    for ($i = 0; $i < 10; $i++) {
        $captcha_lenght .= '<option value="' . $langs[$i] . '" label="' . $langs[$i] . '"' . ($security['captcha_lenght'] == "' . $langs[$i] . '" ? "range" : "") . '></option>';
    }
    $captcha_lenght .= '</datalist>
<span id="captcha_lenghtValue">' . $security['captcha_lenght'] . '</span>';
    return $captcha_lenght;
}

function alertTimes($alert): string
{
    global $admin_conf, $config, $lang;
    $langs = array(0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60);
    $times = '<input style="width: 350px;" value="' . $admin_conf[$alert] . '" type="range" name="' . $config['lang'] . '[' . $alert . ']" step="1" min="0" max="60" list="alertTimesList_' . $alert . '" onchange="document.getElementById(\'alertTimesValue_' . $alert . '\').innerHTML = this.value;">
<datalist id="alertTimesList_' . $alert . '">';
    for ($i = 0; $i < 13; $i++) {
        $times .= '<option value="' . $langs[$i] . '" label="' . $langs[$i] . '"' . ($admin_conf[$alert] == "' . $langs[$i] . '" ? "range" : "") . '></option>';
    }
    $times .= '</datalist>
<span id="alertTimesValue_' . $alert . '">' . $admin_conf[$alert] == 0 ? $lang['off'] : $admin_conf[$alert] . ' ' . $lang['sec'] . '</span>';
    return $times;
}

function recaptcha_style(): string
{
    global $config, $security, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[recaptcha_style]">
<option value="light"' . ($security['recaptcha_style'] == "light" ? "selected" : "") . '>' . $lang['Light'] . '</option>
<option value="dark"' . ($security['recaptcha_style'] == "dark" ? "selected" : "") . '>' . $lang['Dark'] . '</option>
</select>';
}

function auth_admin_metod(): string
{
    global $config, $security, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[auth_metod]">
<option value="nick"' . ($security['auth_metod'] == "nick" ? "selected" : "") . '>' . $lang['auth_login'] . '</option>
<option value="email"' . ($security['auth_metod'] == "email" ? "selected" : "") . '>' . $lang['auth_email'] . '</option>
</select>';
}

function hide_admin_status(): string
{
    global $admin_conf, $config, $lang;
    $langs = array($lang['panel_hide_not_status'], $lang['panel_sunmenu_always'], $lang['online'], $lang['offline']);
    $status = '<select class="other form-control" name="' . $config['lang'] . '[hide]">';
    for ($i = 0; $i < 4; $i++) {
        $status .= '<option value="' . $i . '"' . ($admin_conf['hide'] == $i ? ' selected' : '') . '>' . $langs[$i] . '</option>';
    }
    $status .= '</select>';
    return $status;
}

function timeZone(): string
{
    global $config, $lang;
    return '<select class="form-control" name="' . $config['lang'] . '[timezone]">
<option value="Default"' . ($config['timezone'] == "Default" ? "selected" : "") . '>' . $lang['By_default'] . '</option>
<option value="Pacific/Kwajalein"' . ($config['timezone'] == "Pacific/Kwajalein" ? "selected" : "") . '>' . $lang['Pacific/Kwajalein'] . '</option>
<option value="Pacific/Samoa"' . ($config['timezone'] == "Pacific/Samoa" ? "selected" : "") . '>' . $lang['Pacific/Samoa'] . '</option>
<option value="US/Hawaii"' . ($config['timezone'] == "US/Hawaii" ? "selected" : "") . '>' . $lang['US/Hawaii'] . '</option>
<option value="US/Alaska"' . ($config['timezone'] == "US/Alaska" ? "selected" : "") . '>' . $lang['US/Alaska'] . '</option>
<option value="Canada/Pacific"' . ($config['timezone'] == "Canada/Pacific" ? "selected" : "") . '>' . $lang['Canada/Pacific'] . '</option>
<option value="Canada/Mountain"' . ($config['timezone'] == "Canada/Mountain" ? "selected" : "") . '>' . $lang['Canada/Mountain'] . '</option>
<option value="Canada/Central"' . ($config['timezone'] == "Canada/Central" ? "selected" : "") . '>' . $lang['Canada/Central'] . '</option>
<option value="Canada/Eastern"' . ($config['timezone'] == "Canada/Eastern" ? "selected" : "") . '>' . $lang['Canada/Eastern'] . '</option>
<option value="Canada/Atlantic"' . ($config['timezone'] == "Canada/Atlantic" ? "selected" : "") . '>' . $lang['Canada/Atlantic'] . '</option>
<option value="Canada/Newfoundland"' . ($config['timezone'] == "Canada/Newfoundland" ? "selected" : "") . '>' . $lang['Canada/Newfoundland'] . '</option>
<option value="Brazil/East"' . ($config['timezone'] == "Brazil/East" ? "selected" : "") . '>' . $lang['Brazil/East'] . '</option>
<option value="Atlantic/Bermuda"' . ($config['timezone'] == "Atlantic/Bermuda" ? "selected" : "") . '>' . $lang['Atlantic/Bermuda'] . '</option>
<option value="Atlantic/Azores"' . ($config['timezone'] == "Atlantic/Azores" ? "selected" : "") . '>' . $lang['Atlantic/Azores'] . '</option>
<option value="Europe/London"' . ($config['timezone'] == "Europe/London" ? "selected" : "") . '>' . $lang['Europe/London'] . '</option>
<option value="Europe/Paris"' . ($config['timezone'] == "Europe/Paris" ? "selected" : "") . '>' . $lang['Europe/Paris'] . '</option>
<option value="Europe/Kaliningrad"' . ($config['timezone'] == "Europe/Kaliningrad" ? "selected" : "") . '>' . $lang['Europe/Kaliningrad'] . '</option>
<option value="Europe/Moscow"' . ($config['timezone'] == "Europe/Moscow" ? "selected" : "") . '>' . $lang['Europe/Moscow'] . '</option>
<option value="Asia/Tehran"' . ($config['timezone'] == "Asia/Tehran" ? "selected" : "") . '>' . $lang['Asia/Tehran'] . '</option>
<option value="Asia/Baku"' . ($config['timezone'] == "Asia/Baku" ? "selected" : "") . '>' . $lang['Asia/Baku'] . '</option>
<option value="Asia/Kabul"' . ($config['timezone'] == "Asia/Kabul" ? "selected" : "") . '>' . $lang['Asia/Kabul'] . '</option>
<option value="Asia/Karachi"' . ($config['timezone'] == "Asia/Karachi" ? "selected" : "") . '>' . $lang['Asia/Karachi'] . '</option>
<option value="Asia/Calcutta"' . ($config['timezone'] == "Asia/Calcutta" ? "selected" : "") . '>' . $lang['Asia/Calcutta'] . '</option>
<option value="Asia/Almaty"' . ($config['timezone'] == "Asia/Almaty" ? "selected" : "") . '>' . $lang['Asia/Almaty'] . '</option>
<option value="Asia/Bangkok"' . ($config['timezone'] == "Asia/Bangkok" ? "selected" : "") . '>' . $lang['Asia/Bangkok'] . '</option>
<option value="Asia/Hong_Kong"' . ($config['timezone'] == "Asia/Yakutsk" ? "selected" : "") . '>' . $lang['Asia/Hong_Kong'] . '</option>
<option value="Asia/Yakutsk"' . ($config['timezone'] == "Asia/Yakutsk" ? "selected" : "") . '>' . $lang['Asia/Yakutsk'] . '</option>
<option value="Australia/Darwin"' . ($config['timezone'] == "Australia/Darwin" ? "selected" : "") . '>' . $lang['Australia/Darwin'] . '</option>
<option value="Asia/Vladivostok"' . ($config['timezone'] == "Asia/Vladivostok" ? "selected" : "") . '>' . $lang['Asia/Vladivostok'] . '</option>
<option value="Asia/Magadan"' . ($config['timezone'] == "Asia/Magadan" ? "selected" : "") . '>' . $lang['Asia/Magadan'] . '</option>
<option value="Asia/Kamchatka"' . ($config['timezone'] == "Asia/Kamchatka" ? "selected" : "") . '>' . $lang['Asia/Kamchatka'] . '</option>
</select>';
}

function changeTpl(): string
{
    global $config;
    $content = '<select class="form-control" name="{varName}">';
    $path = ROOT . 'usr/tpl/';
    $dh = opendir($path);
    while ($file = readdir($dh)) {
        if (is_dir($path . $file) && $file != '.' && $file != '..' && $file != 'admin' && $file != 'default' && $file != 'smartphone') {
            $select = ($file == $config['tpl']) ? ' selected' : '';
            $content .= '<option value="' . $file . '"' . $select . '>' . $file . '</option>';
        }
    }
    closedir($dh);
    $content .= '</select>';
    return $content;
}

function imageEffect(): string
{
    global $config;
    $content = '<select class="other form-control" name="' . $config['lang'] . '[imageEffect]">';
    $path = ROOT . 'media/imageEffects/';
    $dh = opendir($path);
    $c = 0;
    $descr = $descr ?? '';
    $js = $js ?? '';
    $picture = $picture ?? '';
    while ($file = readdir($dh)) {
        if ($file != '.' && $file != '..') {
            if (file_exists($path . $file . '/init.php')) {
                require $path . $file . '/init.php';
                if ($descr && $js && $picture) {
                    $select = ($file == $config['imageEffect']) ? ' selected' : '';
                    $content .= '<option value="' . $file . '"' . $select . '>' . $descr . '</option>';
                }
            }
        }
    }
    closedir($dh);
    $content .= '</select>';
    return $content;
}

function dbType()
{
    global $config;
    $content = '<select class="other form-control" name="' . $config['lang'] . '[dbType]">';
    $path = ROOT . 'boot/db/';
    $dh = opendir($path);
    $c = 0;
    while ($file = readdir($dh)) {
        if (eregStrt('.db.php', $file)) {
            $select = (str_replace('.db.php', '', $file) == $config['dbType']) ? ' selected' : '';
            $file = str_replace('.db.php', '', $file);
            $content .= '<option value="' . $file . '"' . $select . '>' . ucfirst(str_replace('.db.php', '', $file)) . '</option>';
        }
    }
    closedir($dh);
    $content .= '</select>';
    return $content;
}

switch ($url[2] ?? null) {
    default:
        if (isset($url[2]) && isset($configBox[$url[2]])) {
            foreach (glob(ROOT . 'etc/*' . $url[2] . '.config.php') as $file) {
                $flang = str_replace(array(ROOT . 'etc/', '.' . $url[2] . '.config.php'), array('', ''), $file);
                if ($file != ROOT . 'etc/' . $url[2] . '.config.php') {
                    if (isset($core->langsLang[$flang])) {
                        $varName = $configBox[$url[2]]['varName'];
                        unset($$varName);
                        require $file;
                        $langArr[$flang] = $$varName;
                    }
                }
            }
            require(ROOT . 'etc/' . $url[2] . '.config.php');
            $parseConf = $configBox[$url[2]];
            $varName = $configBox[$url[2]]['varName'];
            $confArr = $$varName;
            $adminTpl->admin_head($lang['configuration'] . ' | ' . $parseConf['title']);
            $adminTpl->footIncludes[''] = '<script src="' . PLUGINS . 'js/anchor.js"></script>
<script>
     $(document).ready(function() {
    // Click event for any anchor tag that\'s href starts with #
    $(\'a[href*=#].anchored\').click(function(event) {
        var id = $(this).attr("href");
        var offset = 100;
        var target = $(id).offset().top - offset;
        $(\'html, body\').animate({scrollTop:target}, 500);
        event.preventDefault();
    });
});
</script>';
            $adminTpl->open();
            echo '<section id="content" class="table-layout animated fadeIn">
	<div class="tray tray-center" style="height: 763px;">
		<form action="{ADMIN_LINK}/save" method="post" role="form" class="form-horizontal parsley-form" data-parsley-validate>';
            foreach ($parseConf['groups'] as $group) {
                echo '<div id="' . translit($group['title']) . '" class="panel panel-info panel-border top mb35">
				<div class="panel-heading">
					<span class="panel-title">' . $group['title'] . '</span>
				</div>
				<div class="heading-hr"></div>
				<div class="bg-white">';
                foreach ($group['vars'] as $var => $varArr) {
                    echo '<table class="table table-xs table-striped">
						<tbody>			
        	                 <tr>
								<td class="col-xs-5 col-sm-5 col-md-6 pl20">
									<h6 class="media-heading text-semibold mb5">' . $varArr['title'] . ':</h6>
									<span class="text-muted text-size-small hidden-xs">' . $varArr['description'] . '</span>
								</td>
								<td class="col-xs-7 col-sm-7 col-md-6 pl20">
							<div class="mb-lg-0 w300 mnw430">
           ' . (isset($confArr[$var]) ? str_replace(array('{varName}', '{var}'), array($config['lang'] . '[' . $var . ']', $confArr[$var]), $varArr['content']) : $varArr['content']) . '
                            </div>
                                </td>
							</tr>
						</tbody>
					</table>';
                }
                echo '</div>
' . init_dfoot(true, 'fa-floppy-o', 'save', 'system', false, 'r') . '       
         </div>';
            }
            echo '<input type="hidden" size="20" name="conf_file" class="form-control" value="' . $url[2] . '" maxlength="100" maxsize="100"><input type="hidden" size="20" name="conf_arr_name" class="form-control" value="' . $varName . '" maxlength="100" maxsize="100">
      </form>
   </div>
           <aside data-tray-height="match" class="panel tray-right tray-rescale tray320" style="height: 568px;">
	<div style="padding-right: 1px !important; margin-bottom: 20px; border-width: 0;" class="form-group admin-form">
       <div id="nav-spy">
         <ul data-smoothscroll="-125" data-spy="affix" data-offset-top="200" class="nav tray-nav tray-nav-border affix-top pl15">
   <h4 class="pl20">' . $lang['cats'] . ' </h4>';
            foreach ($parseConf['groups'] as $group) {
                echo '<li class="nav-primary">
               <a class="anchored" href="#' . translit($group['title']) . '"> ' . $group['title'] . '</a>
            </li>';
            }
            echo '</ul>
      </div>
   </aside>
</section>';
        } else {
            $adminTpl->admin_head($lang['configuration']);
            $num_configs = count($configs);
            $count_configs = 0;
            $subcount = 0;
            foreach ($configs as $subname => $subrow) {
                $subcount++;
                $arr[$subcount] = $subname;
            }
            $adminTpl->open();
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-info panel-border top mb35">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['configuration'] . '</span>
         </div>
        <div class="heading-hr"></div>
            <div class="list-bordered">
            <div class="row box-section table-responsive">
            <div class="container">';
            foreach ($configs as $name => $row) {
                if (isset($row['file'])) require ROOT . 'etc/' . $row['file'] . '.config.php';
                $count_configs++;
                $val_name = $name;
                echo '<div class="col-sm-6 media-list media-list-linked">
		<a class="media-link" onclick="document.location.href = \'{ADMIN_LINK}/' . $val_name . '\';">
			<div class="media-left"><img src="' . ($row['icon'] ?? '') . '" class="img-ma section_icon" alt=""></div>
			<div class="media-body">
		        <h6 class="media-heading text-semibold text-left">' . ($row['name'] ?? '') . '</h6>
				<span class="text-muted text-size-small text-left">' . ($row['description'] ?? '') . '</span>
			</div>
		</a>
	  </div>';
            }
            echo '</div>
         <div class="panel-footer-lines"></div>
      </div>
      </div>
      </div>
   </div>
</div>';
        }
        $adminTpl->close();
        $adminTpl->admin_foot();
        break;
    case 'modules':
        $adminTpl->admin_head($lang['configuration']);
        foreach (glob(ROOT . 'usr/modules/*/admin/list.php') as $listed) {
            $file = $listed;
            $file = str_replace(ROOT . 'usr/modules/', '', $file);
            $file = str_replace('/admin/list.php', '', $file);
            $core->loadLangFile('usr/modules/' . $file . '/admin/lang/{lang}.admin.php');
            include($listed);
        }
        $toconfig['_feedback'] = array('name' => $lang['feedback'], 'description' => $lang['feedback_desc'], 'icon' => 'media/cats/help.png', 'link' => 'feedback/config', 'param' => 'feedback');
        $toconfig['_complaint'] = array('name' => $lang['complaint'], 'description' => $lang['complaint_desc'], 'icon' => 'media/cats/Tutorial.png', 'link' => 'complaint/config', 'param' => 'complaint');
        $toconfig['_includ_chart'] = array('name' => $lang['counter_visits'], 'description' => $lang['counter_visits_desc'], 'icon' => 'media/cats/counter.png', 'link' => 'module/includ_chart/config', 'param' => 'includ_chart');
        $toconfig['_smiles'] = array('name' => $lang['smiles'], 'description' => $lang['smiles_desc'], 'icon' => 'media/cats/smiles.png', 'link' => 'smiles', 'param' => 'smiles');
        $toconfig['_blocks'] = array('name' => $lang['block_standart'], 'description' => $lang['block_desc'], 'icon' => 'media/cats/template.png', 'link' => 'blocks/standard', 'param' => 'blocks/standard');
        if (!empty($toconfig)) {
            $adminTpl->open();
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-info panel-border top mb35">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['config_modules'] . '</span>
         </div>
        <div class="heading-hr"></div>
            <div class="list-bordered">
            <div class="row box-section table-responsive">
            <div class="container">';
            foreach ($toconfig as $name => $row) {
                echo '<div class="col-sm-6 media-list media-list-linked">
		<a class="media-link" onclick="document.location.href = \'{ADMIN}/' . $row['link'] . '\';">
			<div class="media-left"><img src="' . ($row['icon'] ?? '') . '" class="img-ma section_icon" alt=""></div>
			<div class="media-body">
				<h6 class="media-heading text-semibold text-left">' . ($row['name'] ?? '') . '</h6>
				<span class="text-muted text-size-small text-left">' . ($row['description'] ?? '') . '</span>
			</div>
		</a>
	  </div>';
            }
            echo '</div>
         <div class="panel-footer-lines"></div>
      </div>
      </div>
      </div>
   </div>
</div>';
            $adminTpl->close();
            $adminTpl->admin_foot();
        }
        break;
    case 'doit':
        $name = $url[3] ?? '';
        $prename = $url[4] ?? '';
        $param = '';
        foreach ($configs as $k => $v) {
            $param .= $k . ',';
        }
        $param = mb_substr($param, 0, -1);
        $newarr = explode(',', $param);
        $namekey = array_search($name, $newarr);
        $prenamekey = array_search($prename, $newarr);
        foreach ($newarr as $key => $val) {
            $last_arr[$key] = $key == $namekey ? $prename : (($key == $prenamekey) ? $name : $val);
        }
        $genarr = '';
        foreach ($last_arr as $val) {
            $genarr .= "\$configs['$val'] = array\n(\n";
            $i = 0;
            foreach ($configs[$val] as $kk => $vv) {
                $i++;
                $genarr .= $i == count($configs[$val]) ? "'$kk' => '$vv'\n" : "'$kk' => '$vv',\n";
            }
            $genarr .= ");\n\n";
            unset($i);
        }
        $content = "global \$configs;\n";
        $content .= $genarr;
        save_conf('etc/configs.config.php', $content);
        location(ADMIN . '/config');
        break;
    case 'save':
        $file = 'etc/{lang}' . $_POST['conf_file'] . '.config.php';
        $conf_arr_name = $_POST['conf_arr_name'];
        $root_conf = array();
        foreach ($_POST as $langs => $arr) {
            if (is_array($arr) && isset($core->langsLang[$langs])) {
                $content = '';
                if ($config['lang'] == $langs) {
                    $content .= "global $$conf_arr_name;\n";
                    $content .= "\$$conf_arr_name = array();\n";
                }
                $html = array('off_text', 'commentSignature', 'commentEditText');
                foreach ($arr as $k => $val) {
                    if ($k != 'conf_arr_name' && $k != 'conf_file') {
                        if (!is_array($val)) {
                            if (!in_array($k, $html)) {
                                if (($config['lang'] != $langs && $root_conf[$k] != $val) || $config['lang'] == $langs) $content .= "\$" . $conf_arr_name . "['" . $k . "'] = \"" . htmlspecialchars(str_replace('"', '\"', stripslashes($val)), ENT_QUOTES) . "\";\n";
                            } else {
                                if (($config['lang'] != $langs && $root_conf[$k] != $val) || $config['lang'] == $langs) $content .= "\$" . $conf_arr_name . "['" . $k . "'] = \"" . str_replace('"', '\"', stripslashes($val)) . "\";\n";
                            }
                            if ($config['lang'] == $langs) $root_conf[$k] = $val;
                        } else {
                            foreach ($val as $karr => $varr) {
                                $content .= "\$" . $conf_arr_name . "['" . $k . "']['" . $karr . "'] = \"" . htmlspecialchars(stripslashes($varr), ENT_QUOTES) . "\";\n";
                            }
                        }
                    }
                }
                if (!empty($content)) {
                    $result = "global $$conf_arr_name;\n" . $content;
                    save_conf(str_replace('{lang}', ($config['lang'] == $langs ? '' : $langs . '.'), $file), $content);
                }
                unset($content);
            }
        }
        location(ADMIN . '/config/' . $_POST['conf_file'] . '/ok');
        break;
    case 'backup':
        $adminTpl->admin_head($lang['backup_name']);
        InitCountLines();
        InitCheck();
        $i = 0;
        $adminTpl->open();
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('config');
        $content = '';
        $errors = 0;
        echo '<div class="panel panel-yellow panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['backup_restore_name'] . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form action="{ADMIN_LINK}/backup" method="post" enctype="multipart/form-data"/>
               <div class="panel-heading">
                  <span class="panel-title">' . $lang['config_restore_inf'] . '</span>
               </div>
               <div class="panel-body admin-form">
                    <div class="form-group">
                         <label class="col-lg-3 col-sm-3 control-label">' . $lang['fm_upload'] . '</label>
                         <div class="col-lg-5 col-md-5 col-sm-8">
                           <label class="field prepend-icon file"><span ' . btn_class('primary button btn-rounded ph30') . '>' . $lang['select_file'] . '</span>
							<input type="file" name="file" onchange="document.getElementById(\'uploader2\').value = this.value;" class="gui-file">
							<input id="uploader2" type="text" placeholder="' . $lang['choose_file_pre'] . '" class="gui-input">
                           <label class="field-icon">' . faI('fa-upload', false, false, true) . '</label>
                           </label>
                           <div class="section mb10 pt15">
                             ' . init_dfoot(true, false, 'upload', 'system button btn-block ph5', 'not') . '
                           </div>
                        </div>
                     </div>
               </div>
            </form>';
        if (isset($_FILES['file']['tmp_name']) && preg_match('#.txt#i', $_FILES['file']['name'])) {
            $fileContent = int_Serialize('uns', file_get_contents($_FILES['file']['tmp_name']));
            $conf_arr_name = array();
            if (!empty($fileContent)) {
                foreach ($fileContent as $k => $val) {
                    $conf_arr_name = $val[0];
                    $content = "global $$conf_arr_name;\n";
                    $content .= "\$$conf_arr_name = array();\n";
                    $html = array('off_text', 'commentSignature', 'commentEditText');
                    if ($k != 'conf_arr_name' && $k != 'conf_file') {
                        if (!is_array($val)) {
                            if (!in_array($k, $html)) {
                                $content .= "\$" . $conf_arr_name . "['" . $k . "'] = \"" . htmlspecialchars(str_replace('"', '\"', stripslashes($val)), ENT_QUOTES) . "\";\n";
                            } else {
                                $content .= "\$" . $conf_arr_name . "['" . $k . "'] = \"" . str_replace('"', '\"', stripslashes($val)) . "\";\n";
                            }
                        } else {
                            foreach ($val as $karr => $varr) {
                                $varr = is_array($varr) ? $varr : array($varr);
                                foreach ($varr as $karsr => $varsr) {
                                    if ($val == $varsr) {
                                        $content .= "\$" . $conf_arr_name . "['" . $k . "']['" . $karsr . "'] = \"" . htmlspecialchars(stripslashes($varsr), ENT_QUOTES) . "\";\n";
                                    } else {
                                        if ($conf_arr_name . "['" . $karsr . "']." <> $conf_arr_name . "['0'].") {
                                            $content .= "\$" . $conf_arr_name . "['" . $karsr . "'] = \"" . htmlspecialchars(stripslashes($varsr), ENT_QUOTES) . "\";\n";
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                $arr_name = str_replace('_conf', '', stripslashes($conf_arr_name));
                $parName = stripslashes($conf_arr_name);
                echo '<div class="panel-heading">
            <span class="panel-title"><b>Просмотр файла конфигурации</b>	- ' . $arr_name . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/restore" onclick="lihtTable(getSource(event))">
              <div class="row">
  <div class="col-xs-12">
             <div class="tab-block mb25">
                     <div class="tab-content_editor">
                      <div class="switcher-content p20">
                  <textarea cols="30" rows="20" class="form-control weswap-current" OnKeyUp="ResizeTextArea(this,2);">' . $content . '</textarea><br/><br/>
               </div>
         </div>
      </div>
   </div>
</div>
</div>
<div class="panel-footer admin-form">
            <input type="hidden" name="arr_name" value="' . $arr_name . '">
            <input type="hidden" name="parname" value="' . $parName . '">
            <input type="hidden" name="config" value="' . htmlspecialchars(stripslashes($content), ENT_QUOTES) . '">
            <button name="submit" type="submit" id="sub" ' . btn_class('primary') . ' value="' . $lang['base_restore'] . '">' . faSpan('fa-retweet', true, $lang['base_restore']) . '</button>
            <button type="button" ' . btn_class('danger') . ' onclick="window.location.href = \'{ADMIN_LINK}/backup\'">' . faSpan('fa-trash-o', true, $lang['clear']) . ' </button >
            </div>
             </form>';
            }
        } else {
            echo '<div class="panel-footer-lines">
            </div>';
        }
        echo '</div>
      </div>';
        echo '<div class="panel panel-dark panel-border top">
            <div class="panel-heading">
               <span class="panel-title">' . $lang['backup_add'] . '</span>
            </div>
            <div class="heading-hr"></div>
            <div class="panel-body pn table-responsive">
               <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
                  <table class="table table-xs table-striped">
                     <thead>
                        <tr>
                           <th><span class="pd-l-sm"></span>#</th>
                           <th class="col-md-7 text-center">' . $lang['backup_appointment'] . '</th>
                           <th class="col-md-4 text-center">' . $lang['backup_location'] . '</th>';
        init_checkbox();
        echo '</tr>
                     </thead>
                     <tbody>';
        foreach ($configs as $name => $row) {
            if (isset($row['file'])) require ROOT . 'etc/' . $row['file'] . '.config.php';
            $val_name = $name;
            $i++;
            echo '<tr>
                           <td><span class="pd-l-sm"></span>' . $i . '</td>
                           <td>
                              <a class="media-link" onclick="document.location.href = \'{ADMIN_LINK}/' . $name . '\';">
                                 <div class="media-left"><img src="' . $row['icon'] . '" class="img-ma section_icon" alt=""></div>
                                 <div class="media-body">
                               		<h6 class="media-heading text-semibold text-left">' . $row['name'] . '</h6>
				                    <span class="text-muted text-size-small text-left">' . $row['description'] . '</span>
                                 </div>
                              </a>
                           </td>
                           <td class="text-center">
                              <input name="name[' . $name . ']" value="etc/' . $name . '.config.php" type="text" style ="height: 32px;" class="event-name form-control text-center">
                           </td>';
            init_checkbox('td', $name, ($row['param'] ?? $name . '_conf'));
            echo '</tr>';
        }
        foreach (glob(ROOT . 'usr/modules/*/admin/list.php') as $listed) {
            include($listed);
        }
        if (!empty($toconfig)) {
            foreach ($toconfig as $name => $row) {
                $i++;
                echo '<tr>
                           <td class="text-center hidden-xs"><span class="pd-l-sm"></span>' . $i . '</td>
                           <td>
                              <a class="media-link" onclick="document.location.href = \'{ADMIN}/module/' . $name . '/config\';">
                                 <div class="media-left"><img src="' . $row['icon'] . '" class="img-ma section_icon" alt=""></div>
                                 <div class="media-body">
                                    <h6 class="media-heading text-semibold text-left">' . $row['name'] . '</h6>
				                    <span class="text-muted text-size-small text-left">' . $row['description'] . '</span>
                                 </div>
                              </a>
                           </td>
                           <td class="text-center">
                              <input name="name[' . $name . ']" value="etc/' . $name . '.config.php" type="text" style ="height: 32px;" class="event-name form-control text-center">
                           </td>';
                init_checkbox('td', $name, ($row['param'] ?? $name . '_conf'));
                echo '</tr>';
            }
        }
        echo '</tbody>
                  </table>
            </div>
            ' . init_dfoot(true, 'fa-files-o', 'backup_make_copy', 'system') . '
            </form>
         </div>
      </div>
   </div>
</div>';
        $adminTpl->close();
        $adminTpl->admin_foot();
        break;
    case 'restore':
        $arr_name = $_POST['arr_name'];
        $arr_name = str_replace(array('config', 'allowCahce'), array('global', 'cache'), stripslashes($_POST['arr_name']));
        $content = str_replace(array('\n', '\n', '&lt;', '&gt;'), array('<br>', '<br/>', '<', '>'), $_POST['config']);
        $file = 'etc/' . $arr_name . '.config.php';
        if (file_exists(ROOT . $file)) {
            save_conf($file, $content);
            action_alert('root', 'success', 'config', 'backup');
        } else {
            action_alert('root', 'danger', 'config', 'backup', 'unknown_error');
        }
        break;
    case 'action':
        $fileName = '';
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            foreach ($_POST['checks'] as $fileName => $paramName) {
                $file = ROOT . 'etc/' . $fileName . '.config.php';
                if (file_exists($file) && !empty($paramName)) {
                    require($file);
                    $confBackup[$fileName] = array($paramName, $$paramName);
                } else {
                    return;
                }
            }
            if (!empty($confBackup)) {
                $backup = int_Serialize('ser', $confBackup);
                header('content-disposition: attachment; filename=config_backup_' . $fileName . '_' . date('d-m-y', time()) . '.txt');
                header('last-modified: ' . time());
                header('accept-ranges: bytes');
                header('content-length: ' . mb_strlen($backup));
                header('content-type: text/plain');
                echo $backup;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'config', 'backup');
        }
        break;
}

