<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $dbdown_conf, $config, $core, $url, $lang;
switch ($url[2] ?? null) {
    default:
        InitCheck();
        init_count_text();
        Scroll('info');
        $i = 0;
        $collation = false;
        require ROOT . 'etc/db.config.php';
        require ROOT . 'etc/global.config.php';
        $charset = str_replace(array('-'), array(''), $config['charset']);
        $query = $db->query("SHOW TABLE STATUS");
        $adminTpl->admin_head($lang['db_db']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('db');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $lang['base_list'] . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/actions" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th class="col-md-4">' . $lang['db_table_name'] . '</th>
                        <th class="col-md-2">' . $lang['db_table_code'] . '</th>
                        <th class="text-center">' . $lang['db_table_numb'] . '</th>
                        <th class="text-center">' . $lang['db_table_size'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($row = $db->getRow($query)) {
                $i++;
                if (eregStrt(DB_PREFIX, $row["Name"])) {
                    if ($row["Collation"] <> $charset . '_general_ci') $collation = true;
                    echo '<tr>
                        <td><span class="pd-l-sm"></span>' . $i . '</td>
                        <td>' . $row["Name"] . '</td>
                        <td>' . $row["Collation"] . '</td>
                        <td class="text-center">' . $row["Rows"] . '</td>
                        <td class="text-center">' . formatfilesize($row["Data_length"] + $row["Index_length"]) . '</td>';
                    init_checkbox('td', $row["Name"], false, '<li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-clear' . $row["Name"] . '\')">' . faSpan('fa-eraser', true, $lang['base_clear']) . '</a></li>
                                 ' . (($row["Collation"] <> $charset . '_general_ci') ? '<li><a href="{ADMIN_LINK}/character/' . $row["Name"] . '" >' . faSpan('fa-terminal', true, $lang['db_fix_encoding']) . '</a></li>' : '') . '
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $row["Name"] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                    echo '</tr>';
                    modal_form_delete('clear' . $row["Name"], $row["Name"], $lang['db_truncate'] . ' - ' . $row["Name"], 'name', $lang['db_clear_text'], '{ADMIN_LINK}/truncate/' . $row["Name"], $lang['base_clear'], 'clear');
                    modal_form_delete($row["Name"], $row["Name"], $lang['db_delete'] . ' - ' . $row["Name"], 'name', $lang['db_delete_text'], '{ADMIN_LINK}/delete/' . $row["Name"]);
                }
            }
            init_tfoot('<option value="truncate">' . $lang['db_truncate'] . '</option>
                              ' . (($collation) ? '<option value="character">' . $lang['db_fix_encoding'] . '</option>' : '') . '
                               <option value="delete">' . $lang['delete'] . '</option>');
            echo '</table>
            </form>
         </div>
      </div>
   </div>
   <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
         <form id="info" role="form" method="POST" action="">';
            info_stat();
            echo '</form>
   </aside>';
        }
        echo '</div>';
        $adminTpl->admin_foot();
        break;
    case 'backup':
        InitCheck();
        init_count_text();
        Scroll('info');
        access_down();
        $i = 0;
        $count = true;
        $dir = ROOT . 'tmp/backup/';
        $adminTpl->admin_head($lang['db_db'] . ' | ' . $lang['db_be_name']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        if (is_dir($dir)) {
            if ($dh1 = opendir($dir)) {
                while (($file1 = readdir($dh1)) !== false) {
                    if (eregStrt('db_backup', $file1)) $yes = true;
                }
                closedir($dh1);
            }
            if ($dh = opendir($dir)) {
                if (empty($yes)) $adminTpl->alert('warning', $lang['info'], $lang['db_be_no']);
                if (empty($yes)) $count = false;
            }
        }
        $result = $db->query("SHOW TABLE STATUS");
        alert_info('db');
        echo '<div class="panel panel-info panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['db_desc'] . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body table-responsive">
         <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/backup_do" role="form" class="form-horizontal parsley-form" data-parsley-validate>
              <div class="form-group">
                      <label class="col-lg-1 col-md-2 col-sm-2 control-label">' . $lang['db_choice'] . '</label>
                    <div class="col-lg-4 col-md-4 col-sm-7">';
        echo '<select class="form-control" name="db_list[]" size="10" multiple>';
        while ($row = $db->getRow($result)) {
            if (eregStrt(DB_PREFIX, $row["Name"])) echo "<option value=\"" . $row["Name"] . "\" selected>" . $row["Name"] . "</option>";
        }
        echo '</select>
                     </div>
                    <div class="col-lg-7 col-md-7 col-sm-11 pn">
                        <table style="width:100%;">
                           <tbody>
                              <tr>
                                 <td style="width:70px;">' . faI('fa-cogs', true, false, true, false, 'font-size:400%') . '</td>
                                 <td style="width:5%;" nowrap="nowrap">
                                    <div style="text-align:left">
                                       <div class="choice legend" style="padding: 0 10px 10px 0;"><span class=""><input style="border:0" type="radio" name="choice" checked="checked" value="optimize" class="option-input radio"></span></div>
                                    </div>
                                 </td>
                                 <td class="active">
                                    <h5 class="text-regular">' . $lang['db_op_name'] . '</h5>
                                    <span class="text-center text-size-small">' . $lang['db_op_text'] . '</span>
                                 </td>
                              </tr>
                              <tr>
                                 <td>' . faI('fa-wrench', true, false, true, false, 'font-size:800%') . '</td>
                                 <td style="width:5%;" nowrap="nowrap">
                                    <div style="text-align:left">
                                       <div class="choice legend" style="padding: 0 10px 10px 0;"><span class="checked"><input style="border:0" type="radio" name="choice" value="repair" class="option-input radio"></span></div>
                                    </div>
                                 </td>
                                 <td class="active">
                                    <h5 class="text-regular">' . $lang['db_re_name'] . '</h5>
                                    <span class="text-center text-size-small">' . $lang['db_re_text'] . '</span>
                                 </td>
                              </tr>
                              <tr>
                                 <td>' . faI('fa-life-ring', true, false, true, false, 'font-size:800%') . '</td>
                                 <td style="width:5%;" nowrap="nowrap">
                                    <div style="text-align:left">
                                       <div class="choice legend" style="padding: 0 10px 10px 0;"><span class="checked"><input style="border:0" type="radio" name="choice" value="backup" class="option-input radio"></span></div>
                                    </div>
                                 </td>
                                 <td class="active">
                                    <h5 class="text-regular">' . $lang['db_back_name'] . '</h5>
                                    <span class="text-center text-size-small">' . $lang['db_be_text'] . '</span>
                                 </td>
                              </tr>
                    </tbody>
                        </table>
                     </div>
                 </div> 
              </div>
   ' . init_dfoot(true, 'fa-retweet', 'db_perform', 'primary') . '
       </div>
      </form>';
        if (is_dir($dir)) {
            if ($dh1 = opendir($dir)) {
                while (($file1 = readdir($dh1)) !== false) {
                    if (eregStrt('db_backup', $file1)) $yes = true;
                    if (eregStrt('.sql', $file1)) $yes = false;
                }
                closedir($dh1);
            }
            if ($dh = opendir($dir)) {
                if (isset($yes)) {
                    $i = 0;
                    if ($count) {
                        echo '<div class="panel panel-success panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['db_be_archive'] . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/backup_actions" role="form" class="form-horizontal parsley-form" data-parsley-validate  onclick="lihtTable(getSource(event))">
               <div class="panel-body no-padding pn">
                  <table class="table table-xs table-striped">
                     <thead>
                        <tr>
                           <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                           <th class="col-md-5 text-center">' . $lang['base_file'] . '</th>
                           <th class="col-md-2 text-center">' . $lang['base_date'] . '</th>
                           <th class="col-md-3 text-center">' . $lang['db_table_size'] . '</th>
                           <th style="width: 60px">&nbsp;</th>';
                        init_checkbox();
                        echo '</tr>
                     </thead>
                     <tbody>';
                        while (($file = readdir($dh)) !== false) {
                            if (eregStrt('db_backup', $file)) {
                                $expansion = str_replace('.sql.gz', '', $file);
                                $filename = ROOT . 'tmp/backup/' . $file;
                                $i++;
                                echo '<tr>
                           <td class="text-center hidden-xs"><span class="pd-l-sm"></span>' . $i . '</td>
                           <td class="text-left">' . $file . '</td>
                           <td class="text-center">' . formatDate(filemtime($filename), true) . '</td>
                           <td class="text-center">' . formatfilesize(filesize($filename)) . '</td>';
                                init_checkbox('td', $expansion, false, '<li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-restore' . $expansion . '\')">' . faSpan('fa-undo', true, $lang['base_restore']) . '</a></li>
                                    <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-mail' . $expansion . '\')">' . faSpan('fa-envelope-o', true, $lang['db_be_mail']) . '</a></li>
                                    <li><a href="/tmp/backup/' . $file . '">' . faSpan('fa-download', true, $lang['db_be_download']) . '</a></li>
                                    <li class="divider"></li>
                                    <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $expansion . '\')">' . faSpan('fa-trash-o  text-danger', true, $lang['delete']) . '</a></li>');
                                echo '</tr>';
                                modal_form_delete($expansion, $expansion, $lang['db_archive_delete_title'], 'db_archive', $lang['db_archive_delete_text'], '{ADMIN_LINK}/delBackup/' . $expansion);
                                modal_form_text('restore' . $expansion, $lang['db_be_res'], 'fa-undo', false, $lang['db_be_resd'], false, '<div class="admin-form"><button type="button"  ' . btn_class('info') . ' onclick="location.href = \'{ADMIN_LINK}/restore/' . $expansion . '\'">' . faSpan('fa-retweet', true, $lang['db_perform']) . '</button></div>');
                                modal_form_text('mail' . $expansion, $lang['db_be_mail'], 'fa-envelope-o', false, str_replace('[email]', $config['support_mail'], $lang['db_be_maild']), false, '<div class="admin-form"><button type="button" ' . btn_class('info') . ' onclick="window.location.href = \'{ADMIN_LINK}/mail/' . $expansion . '\'">' . faSpan('fa-retweet', true, $lang['db_perform']) . '</button></div>');
                            }
                        }
                        echo '</tbody>				
                       ' . init_tfoot(true, 'fa-trash-o', 'delete') . '
                     </table>
        </div>
     </div>
  </div>';
                    }
                    echo '</div>
<aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
         <form id="info" role="form" method="POST" action="">';
                    info_stat();
                    echo '</form>
   </aside>
</div>';
                }
                closedir($dh);
            }
        }
        echo '</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'backup_do':
        init_count_text();
        $tables = '';
        $query = '';
        access_down();
        foreach ($_POST['db_list'] as $table) {
            $tables .= ', `' . $table . '`';
        }
        $tables = mb_substr($tables, 1);
        $choice = filter($_POST['choice']);
        $adminTpl->admin_head($lang['db_db'] . ' | ' . $lang['db_be_name']);
        if ($choice == 'optimize' || $choice == 'repair') {
            if ($choice == 'optimize') {
                $query = 'OPTIMIZE TABLE';
                $name = $lang['db_op_name'];
            } elseif ($choice == 'repair') {
                $query = "REPAIR TABLE";
                $name = $lang['db_re_name'];
            } else {
                $query = '';
                $name = '';
            }
            if ($db->query($query . $tables)) {
                if ($name == $lang['db_op_name']) {
                    action_alert('root', 'success', 'db', 'backup', 'db_op_name_succes');
                } else {
                    action_alert('root', 'success', 'db', 'backup', 'db_op_re_succes');
                }
            }
        } elseif ($choice == 'backup') {
            require_once ROOT . 'boot/sub_classes/backup.class.php';
            $backup_obj = new MySQL_DB_Backup();
            require ROOT . 'etc/db.config.php';
            require ROOT . 'etc/dbdown.config.php';
            require ROOT . 'etc/global.config.php';
            $charset = str_replace(array('-'), array(''), $config['charset']);
            $backup_obj->server = $dbhost;
            $backup_obj->port = 3306;
            $backup_obj->username = $dbuser;
            $backup_obj->password = $dbpass;
            $backup_obj->database = $dbname;
            $backup_obj->characters = $charset;
            $backup_obj->tables = $_POST['db_list'];
            $backup_obj->drop_tables = true;
            $backup_obj->create_tables = true;
            $backup_obj->struct_only = false;
            $backup_obj->locks = true;
            $backup_obj->comments = true;
            $backup_obj->backup_dir = 'tmp/backup/';
            $backup_obj->fname_format = 'm_d_Y';
            $task = MSX_SAVE;
            $use_gzip = true;
            $filename = 'jmy_DB_backup-' . date('d-m-Y_H-i') . '.sql.gz';
            $result_bk = $backup_obj->Execute($task, $filename, $use_gzip);
            $info = '';
            $link = '';
            if (!$result_bk) {
                $output = $backup_obj->error;
                $adminTpl->info($output . '<br>' . $lang['db_be_error'], 'error');
            } else {
                $output = 'Operation Completed Successfully At: <b>' . date('H:i:s ') . '</b><i> ( Local Server Time )</i>';
                if ($task == MSX_STRING) $output .= '\n' . $result_bk;
                $info_dbdown = '';
                foreach ($dbdown_conf as $key) {
                    if (filter($key, 'ip')) {
                        if (filter($key, 'ip') == $_SERVER['REMOTE_ADDR']) {
                            $info = faSpan('fa-download', true, $lang['db_be_download']);
                            $link = '/tmp/backup/' . $filename;
                            $access = true;
                        } else {
                            $info = $lang['db_d_rules'];
                            $link = '{ADMIN_LINK}/config';
                            $access = false;
                        }
                    }
                }
                $adminTpl->info($lang['db_be_com'] . '(tmp/backup/) <br/>' . $lang['db_be_server'] . ' <br/>' . $output, 'empty', null, $lang['info'], $info, $link, 'url', $lang['db_help'], null, null, $lang['db_help_desc'], true);
                header('refresh: 15; url="/' . ADMIN . '/db/backup"');
            }
        } else {
            action_alert('root', 'danger', 'db', 'backup', 'error');
        }
        $adminTpl->admin_foot();
        break;
    case 'backup_actions':
        init_count_text();
        $adminTpl->admin_head($lang['db_db'] . ' | ' . $lang['db_be_name']);
        $type = $_POST['submit'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            if ($type == 'delete') {
                foreach ($_POST['checks'] as $file) {
                    unlink('tmp/backup/' . $file . '.sql.gz');
                    action_alert('root', 'success', 'db', 'backup');
                }
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'db', 'backup', 'db_empty');
        }
        $adminTpl->admin_foot();
        break;
    case 'character':
        global $db, $config;
        require ROOT . 'etc/db.config.php';
        require ROOT . 'etc/global.config.php';
        $charset = str_replace(array('-'), array(''), $config['charset']);
        $table = $url[3];
        if ($table) {
            if (eregStrt(DB_PREFIX, $table)) $db->query("ALTER TABLE" . $table . " CONVERT TO CHARACTER SET" . $charset . " COLLATE" . $charset . "_general_ci;");
            action_alert('root', 'success', 'db');
        } else {
            action_alert('root', 'danger', 'db', false, 'unknown_error');
        }
        break;
    case 'restore':
        global $db;
        $file = $url[3];
        if (file_exists('tmp/backup/' . $file . '.sql.gz')) {
            require ROOT . 'etc/db.config.php';
            require ROOT . 'etc/global.config.php';
            require_once ROOT . 'boot/sub_classes/mysql_restore.class.php';
            $charset = str_replace(array('-'), array(''), $config['charset']);
            $sql = '';
            $resource = mysqli_connect($dbhost, $dbuser, $dbpass, $dbname);
            if (mysqli_connect_errno()) die('Ошибка соединения: ' . mysqli_connect_error());
            if (file_exists('tmp/backup/' . $file . '.sql.gz')) {
                /*  $sql = file_get_contents('tmp/backup/' . $file . '.sql');
                $sql_massiv = explode(";", $sql);
                foreach ($sql_massiv as $query) {
                if (preg_match('#CREATE TABLE#i', $query)) @mysqli_query($resource, $query .";");
                if (preg_match('#INSERT INTO#i', $query)) @mysqli_query($resource, $query);
                }*/
                $lines = gzfile('tmp/backup/' . $file . '.sql.gz');
                foreach ($lines as $line) {
                    if (preg_match('#CREATE#i', $line)) mysqli_query($resource, $line . ";");
                    if (preg_match('#INSERT#i', $line)) mysqli_query($resource, $line);
                }
                $status = true;
            } else {
                if (file_exists('tmp/backup/' . $file . '.sql.gz')) GZunpack('tmp/backup/' . $file . '.sql.gz');
                $status = false;
            }
            if ($status = false) {
                action_alert('root', 'danger', 'db', 'backup', 'db_be_rest_no');
            } else {
//unlink('tmp/backup/' . $file . '.sql');
                action_alert('root', 'success', 'db', 'backup', 'db_be_rest_ok');
            }
        } else {
            action_alert('root', 'danger', 'db', false, 'unknown_error');
        }
        break;
    case 'mail':
        global $config, $lang;
        require_once ROOT . '/etc/email.config.php';
        require_once ROOT . '/boot/mail.class.php';
        $file = $url[3];
        if (file_exists('tmp/backup/' . $file . '.sql.gz')) $email = ($config['support_mail']);
        if (!empty($email)) {
            mailSMTP($email, $file, $lang['db_be_do'] . ' ' . $config['url'], $config['url'] . '/tmp/backup/' . $file . '.sql.gz');
            action_alert('root', 'success', 'db', 'backup', 'db_be_mail_ok');
        } else {
            action_alert('root', 'danger', 'db', 'backup', 'sendfalse');
        }
        break;
    case 'actions':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'truncate':
                    foreach ($_POST['checks'] as $table) {
                        if (eregStrt(DB_PREFIX, $table)) {
                            $db->query("TRUNCATE TABLE `" . $table . "`");
                            action_alert('root', 'success', 'db');
                        }
                    }
                    break;
                case 'character':
                    foreach ($_POST['checks'] as $table) {
                        require ROOT . 'etc/db.config.php';
                        require ROOT . 'etc/global.config.php';
                        $charset = str_replace(array('-'), array(''), $config['charset']);
                        if (eregStrt(DB_PREFIX, $table)) {
                            $db->query("ALTER TABLE" . $table . " CONVERT TO CHARACTER SET" . $charset . " COLLATE" . $charset . "_general_ci;");
                            action_alert('root', 'success', 'db');
                        }
                    }
                    break;
                case 'delete':
                    foreach ($_POST['checks'] as $table) {
                        if (eregStrt(DB_PREFIX, $table)) {
                            $db->query("DROP TABLE `$table`");
                            action_alert('root', 'success', 'db');
                        }
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'db');
        }
        break;
    case 'delete':
        $table = $url[3];
        if ($table) {
            if (eregStrt(DB_PREFIX, $table)) $db->query("DROP TABLE `$table`");
            action_alert('root', 'success', 'db', false, str_replace(array('[name]'), array($table), $lang['db_delete_ok']), true);
        } else {
            action_alert('root', 'danger', 'db', false, 'unknown_error');
        }
        break;
    case 'truncate':
        $table = $url[3];
        if ($table) {
            if (eregStrt(DB_PREFIX, $table)) $db->query("TRUNCATE TABLE `" . $table . "`");
            action_alert('root', 'success', 'db', false, str_replace(array('[name]'), array($table), $lang['db_clear_ok']), true);
        } else {
            action_alert('root', 'danger', 'db', false, 'unknown_error');
        }
        break;
    case 'delBackup':
        $file = $url[3];
        if ($file) {
            unlink('tmp/backup/' . $file . '.sql.gz');
            action_alert('root', 'success', 'db');
        } else {
            action_alert('root', 'danger', 'db', false, 'unknown_error');
        }
        break;
    case 'config':
        init_count_text();
        require(ROOT . 'etc/dbdown.config.php');
        global $dbdown_conf, $lang;
        access_down();
        $configBox = array(
            'dbdown' => array(
                'varName' => 'dbdown_conf',
                'title' => $lang['db_ip_head'],
                'groups' => array(
                    'main_ip1' => array(
                        'title' => $lang['user_ip'] . '  1',
                        'vars' => array(
                            'access1' => array(
                                'title' => $lang['db_down_load'],
                                'description' => $lang['db_down_listd'],
                                'content' => radio("access1", $dbdown_conf['access1']),
                            ),
                            'ip1' => array(
                                'title' => $lang['user_ip'],
                                'description' => $lang['db_ip_descr'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'main_ip2' => array(
                        'title' => $lang['user_ip'] . '  2',
                        'vars' => array(
                            'access2' => array(
                                'title' => $lang['db_down_load'],
                                'description' => $lang['db_down_listd'],
                                'content' => radio("access2", $dbdown_conf['access2']),
                            ),
                            'ip2' => array(
                                'title' => $lang['user_ip'],
                                'description' => $lang['db_ip_descr'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'main_ip3' => array(
                        'title' => $lang['user_ip'] . '  3',
                        'vars' => array(
                            'access3' => array(
                                'title' => $lang['db_down_load'],
                                'description' => $lang['db_down_listd'],
                                'content' => radio("access3", $dbdown_conf['access3']),
                            ),
                            'ip3' => array(
                                'title' => $lang['user_ip'],
                                'description' => $lang['db_ip_descr'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'main_ip4' => array(
                        'title' => $lang['user_ip'] . '  4',
                        'vars' => array(
                            'access4' => array(
                                'title' => $lang['db_down_load'],
                                'description' => $lang['db_down_listd'],
                                'content' => radio("access4", $dbdown_conf['access4']),
                            ),
                            'ip4' => array(
                                'title' => $lang['user_ip'],
                                'description' => $lang['db_ip_descr'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'main_ip5' => array(
                        'title' => $lang['user_ip'] . '  5',
                        'vars' => array(
                            'access5' => array(
                                'title' => $lang['db_down_load'],
                                'description' => $lang['db_down_listd'],
                                'content' => radio("access5", $dbdown_conf['access5']),
                            ),
                            'ip5' => array(
                                'title' => $lang['user_ip'],
                                'description' => $lang['db_ip_descr'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                ),
            ),
        );
        $ok = false;
        if (isset($_POST['conf_file'])) $ok = true;
        generateConfig($configBox, 'dbdown', '{ADMIN_LINK}/config', $ok);
        break;
}
function write111($id, $type): void
{
    $logPath = ROOT . 'tmp/backup/errors.log';
    if (file_exists($logPath)) $data = int_Serialize('uns', @file_get_contents($logPath));
    $data[] = array('type' => $type, 'id' => $id);
    $data = int_Serialize('ser', $data);
    $fp = @fopen($logPath, 'w');
    fwrite($fp, $data);
    fclose($fp);
}

function info_stat(): void
{
    global $lang;
    require ROOT . 'etc/db.config.php';
    $resource = mysqli_connect($dbhost, $dbuser, $dbpass);
    $dbsizes = '';
    if ($resource) {
        if (mysqli_select_db($resource, $dbname)) {
            @mysqli_query($resource, 'SET NAMES utf8');
            $query = 'SELECT ROUND((SUM(DATA_LENGTH)+SUM(INDEX_LENGTH))/1024/1024,2) AS size FROM information_schema.tables WHERE table_schema ="' . $dbname . '"';
            $item = mysqli_fetch_array(mysqli_query($resource, $query));
            $dbsizes = $item['size'] . '-' . $lang['mb'];
            $MySQLVersion = mysqli_fetch_array(mysqli_query($resource, 'SELECT VERSION()'));
        }
    }
    $dbSize = formatfilesize($dbsizes);
    $php = phpversion() < '7.0' ? '#FF0000' : '#009900';
    $mysql = $MySQLVersion[0] < '5.5.3' ? '#FF0000' : '#009900';
    $execution = ini_get('max_execution_time') < '30' ? '#FF0000' : '#009900';
    echo '<div style="padding-right: 1px !important; top: 170px; position: fixed;  margin-bottom: 20px; border-width: 0;" class="form-group admin-form">
   <h4 class="text-left pl20 pt10">' . $lang['stat_server'] . '</h4>
   <hr class="short">
   <div class="section mb5">
      <table class="table table-sm">
         <tr>
            <td class="col-lg-3 col-sm-3">' . $lang['stats_php'] . '</td>
            <td class="col-lg-5 col-md-5 col-sm-8">' . colorSpan($php, phpversion()) . info_modal('stats_php') . '</td>
         </tr>
         ' . modal_form_text('stats_php', $lang['info'], 'fa-info-circle', $lang['info_stats_php'], false, $lang['info_stats_php_desc']) . '
         <tr>
             <td class="col-lg-3 col-sm-3">' . $lang['stats_mysql'] . '</td>
             <td class="col-lg-5 col-md-5 col-sm-8">' . colorSpan($mysql, $MySQLVersion[0]) . info_modal('stats_mysql') . '</td>
         </tr>
         ' . modal_form_text('stats_mysql', $lang['info'], 'fa-info-circle', $lang['info_stats_mysql'], false, $lang['info_stats_mysql_desc']) . '
         <tr>
            <td class="col-lg-3 col-sm-3">' . $lang['stats_bdsize'] . '</td>
            <td class="col-lg-5 col-md-5 col-sm-8">' . colorSpan('#00CC33', $dbSize) . info_modal('stats_bdsize') . '</td>
         </tr>
         ' . modal_form_text('stats_bdsize', $lang['info'], 'fa-info-circle', $lang['info_stats_bdsize'], false, $lang['info_stats_bdsize_desc']) . '
         <tr>
            <td class="col-lg-3 col-sm-3">' . $lang['stats_time'] . '</td>
            <td class="col-lg-5 col-md-5 col-sm-8">' . colorSpan($execution, ini_get('max_execution_time')) . info_modal('stats_time') . '</td>
         </tr>
         ' . modal_form_text('stats_time', $lang['info'], 'fa-info-circle', $lang['info_stats_time'], false, $lang['info_stats_time_desc']) . '
      </table>
   </div>
</div>';
}

function access_down(): void
{
    global $dbdown_conf;
    require ROOT . 'etc/dbdown.config.php';
    $accessTXT = NULL;
    if (access_conf()) {
        $accessTXT .= "Require all granted";
        if ($dbdown_conf['access1'] && $dbdown_conf['ip1']) $accessTXT .= "\r\nRequire ip" . $dbdown_conf['ip1'];
        if ($dbdown_conf['access2'] && $dbdown_conf['ip2']) $accessTXT .= "\r\nRequire ip" . $dbdown_conf['ip2'];
        if ($dbdown_conf['access3'] && $dbdown_conf['ip3']) $accessTXT .= "\r\nRequire ip" . $dbdown_conf['ip3'];
        if ($dbdown_conf['access4'] && $dbdown_conf['ip4']) $accessTXT .= "\r\nRequire ip" . $dbdown_conf['ip4'];
        if ($dbdown_conf['access5'] && $dbdown_conf['ip5']) $accessTXT .= "\r\nRequire ip" . $dbdown_conf['ip5'];
    } else {
        $accessTXT .= "Require all denied";
    }
    $fp = fopen(ROOT . 'tmp/.htaccess', 'w+');
    if (!fwrite($fp, $accessTXT)) fclose($fp);
}

function access_conf(): string
{
    global $dbdown_conf;
    $access = array(null, 'access1', 'access2', 'access3', 'access4', 'access5');
    $rows = '';
    for ($i = 1; $i < 6; $i++) {
        if ($dbdown_conf['access' . $i] <> 0) $rows .= $access[$i];
    }
    return $rows;
}

function truncate(): void
{
    require ROOT . 'etc/db.config.php';
    if (isset($dbhost) && isset($dbuser) && isset($dbname)) {
        $connection = new mysqli($dbhost, $dbuser, $dbpass, $dbname);
        $sql = "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA LIKE '" . $dbname . "'";
        $result = $connection->query($sql);
        $tables = $result->fetch_all(MYSQLI_ASSOC);
        foreach ($tables as $table) {
            $sql = "DROP TABLE `" . $table['TABLE_NAME'] . "`";
            $connection->query($sql);
        }
    }
}