<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $config, $core, $admin_conf, $db, $email_conf, $lang;
switch ($url[2] ?? null) {
    default:
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        list($dist_nums) = $core->fetch_data('users', 'distsend = 1', 'COUNT(*)');
        list($status_nums) = $core->fetch_data('distribution', 'status = 0', 'COUNT(*)');
        $where = 'id !=0';
        $order = '';
        $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
        $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
        $s_nick = isset($_POST['s_nick']) ? filter($_POST['s_nick'], 'a') : '';
        $s_search = isset($_POST['s_search']);
        if ($s_search) $s_search = $_POST['s_search'] == 1;
        if (isset($url[2]) && $url[2] == 'order') {
            switch ($url[3] ?? '') {
                case 'abc':
                    $order .= 'title ASC';
                    break;
                case 'date':
                    $order .= 'date DESC';
                    break;
                case 'id':
                    $order .= 'id ASC';
                    break;
            }
        } else {
            $order .= 'date DESC';
        }
        if ($s_id) {
            $where .= "AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
        } else {
            $s_id = '';
        }
        if ($s_title) $where .= "AND `title` LIKE '%" . $db->safesql($s_title) . "%'";
        if ($s_nick) $where .= "AND `users` LIKE '%" . $db->safesql($s_nick) . "%'";
        $query = $core->select_data('distribution', $where, $order . ' LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['dist_list']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            if ($dist_nums) {
                $adminTpl->alert('info', $lang['info'], $lang['distinfo1']);
            } elseif (!empty($dist_num) && $status_nums) {
                $adminTpl->alert('warning', $lang['warning'], $lang['delayed_recording']);
            } else {
                alert_info('distribution');
            }
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['dist_list'] . ':</span>
            ' . sort_head('root', 3) . '
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
                <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th class="col-md-1 text-center">' . $lang['type'] . '</th>
                        <th class="col-md-7"> ' . $lang['titles'] . ' </th>
                        <th class="text-center">' . faSpan('fa-envelope-o', true, false, false, $lang['remain']) . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($dist = $db->getRow($query)) {
                $where = array();
                if (!empty($limit) && $limit < 1) $limit = 20;
                if (!empty($dist['fromregdate'])) $where[] = "regdate>= '" . $dist['fromregdate'] . "'";
                if (!empty($dist['toregdate'])) $where[] = "regdate <= '" . $dist['toregdate'] . "'";
                if (!empty($dist['fromlastdate'])) $where[] = "last_visit>= '" . $dist['fromlastdate'] . "'";
                if (!empty($dist['tolastdate'])) $where[] = "last_visit <= '" . $dist['tolastdate'] . "'";
                if (!empty($dist['no_mail'])) $where[] = "no_mail = 1";
                if (!empty($dist['id'])) $where[] = "dist_id = '" . $dist['id'] . "'";
                if (!$dist['title'] || !$dist['message']) delete($dist['id']);
                $where = count($where) ? ' WHERE ' . implode(' AND ', $where) : '';
                $rows = $core->row_data('users', $where . ' and distsend = 1 LIMIT ' . $dist['limit']);
                list($dist_num) = $core->fetch_data('users', $where . ' and distsend = 1', 'COUNT(*)');
                $interval = $dist_num == 0 ? 86400 * 1000 : $dist['interval'] * 1000;
                if ($dist['status'] <> 0) InitRefresh($interval);
                if (isset($rows['dist_id']) && isset($dist['id']) && $rows['distsend'] == 1 && $dist['status'] == 1 && $rows['dist_id'] == $dist['id']) {

                    require_once ROOT . '/etc/email.config.php';
                    if ($email_conf['newsletter_mail'] == 1) {
                        $query = $core->select_data('email', false, 'id ASC');
                        $email = $rows['email'];
                        while ($result = $db->getRow($query)) {
                            if (!empty($email) && $dist['type'] == 'email') {
                                $formatemail = str_replace(array('@', '.'), array('@', '.'), $rows['email']);
                                $unsubscribe = $config['url'] . '/email/newsletterunsubscribe/' . $formatemail . '/' . mb_substr(md5($formatemail . 'eduard_laas_loh'), 0, 10);
                                $message = $result['html_newsletter_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%title%}', '{%text%}', '{%date%}', '{%unsubscribe%}', '{%url%}'), array('<', '>', $rows['nick'], $dist['title'], $dist['message'], formatDate(time(), true), $unsubscribe, $config['url']), $result['newsletter_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%title%}', '{%text%}', '{%date%}', '{%unsubscribe%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $rows['nick'], $dist['title'], $dist['message'], formatDate(time(), true), $unsubscribe, $config['url']), $result['newsletter_mail_text']);
                                mailSMTP($email, $result['newsletter_mail_text'], $lang['newsletter_confirm'] . $config['name'], $message);
                            } else {
                                $message = str_replace(array('\p', '\n', '\r', ' <br>', ' <br/>', ' &nbsp;', ' &lt;', ' &gt;'), array('""', '""', '""', '\n', '\n', '\n', '<', '>'), $dist['message']);
                                $core->ins_data('pm', 'id,toid,fromid,topic,message,time,users_delete,users_del_data,status', 'NULL,"' . $rows['id'] . '","' . $core->auth->user_id . '","' . $dist['title'] . '","' . $message . '","' . time() . '", 0, 0, 1');
                            }
                            $core->upd_data('users', '`distsend` = 0', 'email ="' . $rows['email'] . '"');
                        }
                    }
                }
                if ($config['clear_distrib'] == 1 && !$dist_num && !$rows['dist_id'] || !$dist['users']) delete($dist['id']);
                $icon = $dist['method'] == 'groups' ? 'media/cats/frend.png' : 'media/cats/user.png';
                $method = $dist['method'] == 'groups' ? $lang['groups'] : $lang['users'];
                echo '<tr>
                        <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $dist['id'] . '</td>
                        <td>
                           <div class="media media-list text-right"><img src="' . $icon . '" class="img-responsive mw60 ib br4"' . toggle(trimtitle($method, 50)) . ' style="border:0" alt=""/></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto"><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-view' . $dist['id'] . '\')">' . trimtitle($dist['title'], 50) . '</a></ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['date'] . ': ' . formatDate($dist['date'], true) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['mail_recipients'] . ': ' . $dist['users'] . '</ol>
                        </td>
                        <td class="text-center"> ' . (!empty($dist_num) ? $dist_num : 0) . ' </td>
                        <td class="text-center">' . status_icon('distribution', $dist['id'], 'distribution', false, false, $dist_num) . '</td>';
                init_checkbox('td', $dist['id'], false, '<li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-view' . $dist['id'] . '\')">' . faSpan('fa-television', true,  $lang['view']) . '</a></li>
                ' . (!empty($dist_num) ? (($dist['status'] == 0) ? '<li><a href="{ADMIN_LINK}/repeat/' . $dist['id'] . '">' . faSpan('fa-send', false, $lang['send']) . '</a></li>' : '') : '') . '
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $dist['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                modal_form_delete($dist['id'], $dist['title'], $lang['distribution_delete_title'], 'distribution', $lang['distribution_delete_text'], '{ADMIN_LINK}/delete/' . $dist['id']);
                modal_form_text('view' . $dist['id'], $lang['view'], 'fa-television', false, '
                        <p class="text-left">' . $lang['date'] . ':&emsp; ' . formatDate($dist['date'], true) . '</p>
                        <p class="text-left">' . $lang['topic'] . ':&emsp; ' . $dist['title'] . '</p>
                        <p class="short alt text-left">' . $lang['messages'] . '&emsp;<pre><code>' . $dist['message'] . '</code></pre></p>', '<p class="short alt text-left">' . $lang['users'] . ':&emsp;' . ($dist['users'] ?: colorSpan('red', $lang['not_users'])) . '</p>', '<button name="submit" type="submit" id="sub" ' . btn_class('danger') . ' onclick="location.href = \'{ADMIN_LINK}/delete/' . $dist['id'] . '\'">' . faSpan('fa-trash-o', true, $lang['delete']) . '</i></button></div>');
                echo '<div>
         </div>
         </td>
         </tr>';
            }
            echo '</tbody>
         </table>
      </div>
         <div style="text-align:right" class="panel-footer admin-form">
            <button name="submit" type="submit" id="sub" ' . btn_class('danger') . ' value="delete">' . faSpan('fa-trash-o', true, $lang['delete']) . '</button>
         </div>
      </div>
   </div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action="">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
			 <h4 class="pl20">' . $lang['quick_search'] . '</h4>
            <hr class="short">
            <div class="section mb5">
            <label for="s_id" class="field prepend-icon">
            <input id="s_id" type="text" name="s_id" placeholder="' . $lang['id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
            <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
            </label>
         </div>
         <div class="section mb5">
            <label for="s_title" class="field prepend-icon">
            <input id="s_title" type="text" name="s_title" placeholder="' . $lang['topic'] . '" class="form-control" value="' . $s_title . '">
            <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
            </label>
         </div>
         <div class="section mb15">
            <label for="s_nick" class="field prepend-icon">
            <input id="s_nick" type="text" name="s_nick" placeholder="' . $lang['nick'] . '" class="form-control" value="' . $s_nick . '">
            <label for="s_nick" class="field-icon">' . faI('fa-user-o', false, false, true) . '</label>
            </label>
         </div>
        ' . init_sfoot(true, true) . '
      </div>
   </form>
</aside>';
        } else {
            list_empty('root', 'distribution', 'url', $s_search, false, true, $s_search);
        }
        echo '</div>';
        $adminTpl->admin_foot();
        break;
    case 'add':
        init_count_text();
        datetimepickerInit('fromregdate');
        datetimepickerInit('fromlastdate');
        datetimepickerInit('toregdate');
        datetimepickerInit('tolastdate');
        $adminTpl->admin_head($lang['mail_send']);
        echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">';
        alert_info('distribution');
        echo '<div class="panel panel-dark panel-border top">
      <div class="panel-heading">
         <span class="panel-title">' . $lang['mail_pre'] . '</span>
      </div>
      <div class="heading-hr"></div>
      <div class="panel-body pn table-responsive">
         <div class="admin-form p20">
            <form class="form-horizontal parsley-form" role="form" action="{ADMIN_LINK}/arrow" method="post" data-parsley-validate>
               <div class="form-group admin-form">
                  <label class="col-sm-3 control-label">' . $lang['mail_recipients'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label class="field select mb15">
                        <select id="method" name="method" class="form-control" required>
                           <option value="">' . $lang['choose_method'] . '</option>
                           <option value="groups">' . $lang['groups'] . '</option>
                           <option value="users">' . $lang['users'] . '</option>
                        </select>
                        ' . faI('arrow double') . '
                     </label>
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['date_reg'] . '</label>
                  <div class="col-lg-5">
                     <label for="fromregdate" class="field prepend-icon">
                     <input for="fromregdate" type="text" name="fromregdate" id="fromregdate" placeholder="' . $lang['from'] . '" class="form-control" style="width: 170px;height: 45px;" value="">
                     <input for="toregdate" type="text" name="toregdate" id="toregdate" placeholder="' . $lang['to'] . '" class="form-control" style="width: 170px;height: 45px;" value="">
                     <label for="fromregdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
               <div class="form-group admin-form">
                  <label class="col-sm-3 control-label">' . $lang['date_last'] . '</label>
                  <div class="col-lg-5">
                     <label for="fromregdate" class="field prepend-icon">
                     <input for="fromlastdate" type="text" name="fromlastdate" id="fromlastdate" placeholder="' . $lang['from'] . '" class="form-control" style="width: 170px;height: 45px;" value="">
                     <input for="tolastdate" type="text" name="tolastdate" id="tolastdate" placeholder="' . $lang['to'] . '" class="form-control" style="width: 170px;height: 45px;" value="">
                     <label for="fromregdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
               <div class="form-group admin-form">
                  <label class="col-sm-3 control-label">' . $lang['n_su_mail'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     ' . limit_range(20) . '
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['n_s_interval'] . '</label>
                 <div class="col-lg-5 col-md-5 col-sm-8">
                     ' . interval_range(3) . '
                  </div>
               </div>
                      <div class="form-group admin-form">
                  <label class="col-sm-3 control-label">' . $lang['type'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                      <label class="field select mb15">
                        <select id="type" name="type" class="form-control" required>
                           <option value="">' . $lang['choose_type_email'] . '</option>
                           <option value="email">' . $lang['email'] . '</option>
                           <option value="pm">' . $lang['pm'] . '</option>
                        </select>
                        ' . faI('arrow double') . '
                     </label>
                  </div>
               </div>
               <div class="form-group">
                  <div class="col-xs-6">
                     <label class="field option">
                     <input type="checkbox" name="no_mail" value="1" checked><span class="checkbox mr10"></span>' . $lang['no_mail'] . '</label><br>
                     <hr class="alt short mv15">
                  </div>
               </div>
         </div>
      </div>
      <div class="panel-footer admin-form">
      <button name="submit" type="submit" id="sub" ' . btn_class('system') . ' value="' . $lang['next'] . '">' . faSpan('fa-arrow-right', true, $lang['next']) . '</button>
      </div>
   </div>
   </form>
   </section>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'arrow':
        $method = isset($_POST['method']) ? filter($_POST['method']) : '';
        $fromregdate = isset($_POST['fromregdate']) ? intval($_POST['fromregdate']) : 0;
        $toregdate = isset($_POST['toregdate']) ? intval($_POST['toregdate']) : 0;
        $fromlastdate = isset($_POST['fromlastdate']) ? intval($_POST['fromlastdate']) : 0;
        $tolastdate = isset($_POST['tolastdate']) ? intval($_POST['tolastdate']) : 0;
        $toregdate = isset($_POST['status']) ? intval($_POST['status']) : 0;
        if ($fromregdate <> 0 || $toregdate <> 0 || $fromlastdate <> 0 || $tolastdate <> 0) {
            $parseDate = explode(' ', $fromregdate);
            $subDate = explode('.', $parseDate[0]);
            if (isset($parseDate[1])) {
                $subTime = explode(':', $parseDate[1]);
            } else {
                $subTime[0] = 12;
                $subTime[1] = 0;
            }
            $fromregdate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            $toregdate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            $fromlastdate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            $tolastdate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
        }
        $limit = isset($_POST['limit']) ? intval($_POST['limit']) : '';
        $interval = isset($_POST['interval']) ? intval($_POST['interval']) : '';
        $no_mail = isset($_POST['no_mail']) ? intval($_POST['no_mail']) : 0;
        $type = isset($_POST['type']) ? filter($_POST['type']) : '';
        $status = isset($_POST['status']) ? intval($_POST['status']) : 1;
        list($id) = $core->fetch_data('distribution', false, 'max(id)');
        $core->ins_data('distribution', 'id,method,fromregdate,toregdate,fromlastdate,tolastdate,limit,interval,title,message,no_mail,date,users,type,status', 'NULL,"' . $method . '","' . $fromregdate . '","' . $toregdate . '","' . $fromlastdate . '","' . $tolastdate . '","' . $limit . '","' . $interval . '","","","' . $no_mail . '","' . time() . '","","' . $type . '","' . $status . '"');
        if ($method == 'users') {
            location(ADMIN . '/distribution/choice/users/' . $no_mail);
            $insert = true;
        } elseif ($method == 'groups') {
            location(ADMIN . '/distribution/choice/groups/' . $no_mail);
            $insert = true;
        } else {
            action_alert('root', 'danger', 'distribution', false, 'base_error_1');
            $insert = false;
        }
        break;
    case 'choice':
        init_count_text();
        datetimepickerInit('fromregdate');
        datetimepickerInit('fromlastdate');
        datetimepickerInit('toregdate');
        datetimepickerInit('tolastdate');
        list($id) = $core->fetch_data('distribution', false, 'max(id)');
        $choice = isset($url[3]) ? filter($url[3]) : '';
        $dist = $core->row_data('distribution', 'id ="' . $id . '"');
        $fromregdate = isset($dist['fromregdate']) && $dist['fromregdate'] <> 0 ? formatDate($dist['fromregdate'], true) : '';
        $toregdate = isset($dist['toregdate']) && $dist['toregdate'] <> 0 ? formatDate($dist['toregdate'], true) : '';
        $fromlastdate = isset($dist['fromlastdate']) && $dist['fromlastdate'] <> 0 ? formatDate($dist['fromlastdate'], true) : '';
        $tolastdate = isset($dist['tolastdate']) && $dist['tolastdate'] <> 0 ? formatDate($dist['tolastdate'], true) : '';
        $limit = $dist['limit'] ?? 20;
        $interval = $dist['interval'] ?? 3;
        $type = $dist['type'] ?? '';
        $no_mail = $dist['no_mail'] ?? 0;
        $grroups = explode(',', $dist['method']);
        $adminTpl->admin_head($lang['mail_send']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('distribution');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['mail_pre'] . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <div class="admin-form p20">
               <form class="form-horizontal parsley-form" role="form" action="{ADMIN_LINK}/message" method="post" data-parsley-validate>
                  <div class="form-group">
                     <label class="col-sm-3 control-label">' . $lang['mail_recipients'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label class="field select mb15">';
        if ($choice == 'users') {
            echo '<select id="nick" name="nick" class="form-control">
                  <option value="all">' . $lang['users_all'] . '</option>';
            $query_users_list = $core->select_data('users');
            if ($db->numRows($query_users_list) > 0) {
                while ($users_list = $db->getRow($query_users_list)) {
                    $selected = ($users_list['nick'] == $author) ? "selected" : "";
                    echo '<option value="' . $users_list['nick'] . '"' . $selected . '>' . $users_list['nick'] . '</option>';
                }
            }
            echo '</select>';
        } elseif ($choice == 'groups') {
            echo '<select id="groups" name="groups" class="form-control">
                  <option value="all">' . $lang['group_all'] . '</option>';
            $query = $core->select_data('groups', false, 'admin DESC,moderator DESC,user DESC,guest DESC,banned DESC');
            while ($rows = $db->getRow($query)) {
                $selected = in_array($rows['id'], $grroups) ? "selected" : "";
                echo '<option value="' . $rows['id'] . '"' . $selected . '>' . $rows['name'] . '</option>';
            }
            echo '</select>';
        } else {
            action_alert('root', 'danger', 'distribution', false, 'unknown_error');
        }
        echo faI('arrow double') . '
                        </label>
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-sm-3 control-label">' . $lang['date_reg'] . '</label>
                     <div class="col-lg-5">
                        <label for="fromregdate" class="field prepend-icon">
                        <input for="fromregdate"	type="text" name="fromregdate" id="fromregdate"	placeholder="' . $lang['from'] . '" class="form-control" style="width:170px;" value="' . $fromregdate . '">
                        <input for="toregdate"	type="text" name="toregdate" id="toregdate" placeholder="' . $lang['to'] . '" class="form-control" style="width:170px;" value="' . $toregdate . '">
                        <label for="fromregdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                        </label>
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-sm-3 control-label">' . $lang['date_last'] . '</label>
                     <div class="col-lg-5">
                        <label for="fromregdate" class="field prepend-icon">
                        <input for="fromlastdate" type="text" name="fromlastdate" id="fromlastdate"	placeholder="' . $lang['from'] . '" class="form-control" style="width:170px;" value="' . $fromlastdate . '">
                        <input for="tolastdate"	type="text" name="tolastdate" id="tolastdate" placeholder="' . $lang['to'] . '" class="form-control" style="width:170px;" value="' . $tolastdate . '">
                        <label for="fromregdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                        </label>
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-sm-3 control-label">' . $lang['n_su_mail'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        ' . limit_range($limit) . '
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-sm-3 control-label">' . $lang['n_s_interval'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        ' . interval_range($interval) . '
                     </div>
                  </div>
                     <div class="form-group admin-form">
                  <label class="col-sm-3 control-label">' . $lang['type'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label class="field select mb15">
                        <select id="type" name="type" class="form-control" required>
                           <option value=""' . ($type == '' ? ' selected' : '') . '>' . $lang['choose_type_email'] . '</option>
                           <option value="email"' . ($type == 'email' ? ' selected' : '') . '>' . $lang['email'] . '</option>
                           <option value="pm"' . ($type == 'pm' ? ' selected' : '') . '>' . $lang['pm'] . '</option>
                        </select>
                        ' . faI('arrow double') . '
                     </label>
                  </div>
               </div>
                  <div class="form-group">
                     <div class="col-xs-6">
                       ' . scheckbox('no_mail', $no_mail, $lang['no_mail']) . '
                     </div>
                  </div>
            </div>
         </div>
         <tfoot class="footer-menu">
         <tr>
         <td colspan="9">
         <div class="panel-footer admin-form">
         <nav class="text-left">
         <input type="hidden" name="id" value="' . $id . '">
         <button name="submit" type="submit" id="sub"	' . btn_class('system') . ' value="' . $lang['next'] . '">' . faSpan('fa-arrow-right', true, $lang['next']) . '</button>
         <button type="button" ' . btn_class('danger') . 'onclick="javascript:history.go(-1)">' . faSpan('fa-arrow-left', true, $lang['go_back']) . '</button>
         </nav>
         </div>
         </td>
         </tr>
         </tfoot>
         </form>
         </section>
      </div>
   </div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'message':
        init_count_text();
        datetimepickerInit('fromregdate');
        datetimepickerInit('fromlastdate');
        datetimepickerInit('toregdate');
        datetimepickerInit('tolastdate');
        $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
        $dist = $core->row_data('distribution', 'id ="' . $id . '"');
        $groups = isset($_POST['groups']) ? intval($_POST['groups']) : '';
        $nick = isset($_POST['nick']) ? filter($_POST['nick']) : '';
        $email = isset($_POST['email']) ? filter($_POST['email']) : '';
        $fromregdate = formatDate($dist['fromregdate'], true);
        $toregdate = formatDate($dist['toregdate'], true);
        $fromlastdate = formatDate($dist['fromlastdate'], true);
        $tolastdate = formatDate($dist['tolastdate'], true);
        $limit = isset($dist['limit']) ? filter($dist['limit']) : '';
        $interval = isset($dist['interval']) ? filter($dist['interval']) : '';
        $type = isset($dist['type']) ? filter($dist['type']) : '';
        $no_mail = isset($dist['no_mail']) ? intval($dist['no_mail']) : 0;
        $status = isset($dist['status']) ? intval($dist['status']) : 1;
        $where = '';
        if ($no_mail) $where .= ' and u.no_mail ="' . $no_mail . '" ';
        if ($dist['method'] == 'groups' && $groups <> 'all') {
            $rows = $core->row_data('users', 'u.group ="' . $groups . $where . '"', false, 'u.*, g.*', 'as u LEFT JOIN ' . DB_PREFIX . '_groups as g ON(u.group = g.id)');
            $where = isset($rows['nick']) ? 'nick ="' . $rows['nick'] . '"' : '';
            $distsend = 1;
        } elseif ($dist['method'] == 'users' && $nick <> 'all') {
            $where = 'nick ="' . $nick . '"';
            $distsend = 1;
        } elseif (($groups || $nick) == 'all') {
            $where = '';
            $distsend = 1;
        } else {
            $where = '';
            $distsend = 0;
        }
        $where = str_replace(array('u.', 'and'), array('', ''), $where);
        $core->upd_data('users', '`distsend` ="' . $distsend . '", `dist_id` ="' . $id . '"', $where, $limit);
        $users = '';
        $dset = 'distsend = 1 and dist_id = ' . $id;
        $adminTpl->admin_head($lang['mail_send']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('distribution');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title"> ' . $lang['mail_pre'] . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body admin-form">
            <form class="form-horizontal parsley-form" role="form" action="{ADMIN_LINK}/send" method="post" data-parsley-validate>';
        if ($where) $where = ' and ' . $where;
        $query_users_list = $core->select_data('users', $dset . $where);
        if ($db->numRows($query_users_list) > 0) {
            while ($users_list = $db->getRow($query_users_list)) {
                $us = $db->numRows($query_users_list) > 1 ? ', ' : '';
                $users .= '<a href="profile/' . $users_list['nick'] . '">' . $users_list['nick'] . '</a>' . $us;
            }
        }
        $users = array($users);
        $users = implode('', $users);
        $core->upd_data('distribution', '`users` ="' . $db->safesql($users) . '"', 'id ="' . $id . '"');
        echo '<div class="form-group">
                  <label for="users" class="col-sm-3 control-label">' . $lang['users'] . ' (' . $core->sum_data('users', $dset . $where) . ')' . '</label>
                  <div class="col-sm-8">
                     <label for="users" class="field prepend-icon">
                    <pre><code>' . $users . '</pre></code>
                     </label>
                  </div>
               </div>
               <div class="form-group">
                  <label for="title" class="col-sm-3 control-label">' . $lang['title_mail'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="title" class="field prepend-icon">
                     <input id="title" type="text" name="title" placeholder="' . $lang['input_title_mail'] . '" class="event-name form-control" value="" required>
                     <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                     </label>
                  </div>
               </div>';
        initDir('distribution', $dist['id']);
        echo '<div class="col-xs-12">
             <div class="tab-block mb25">
             <div class="form-group admin-form">
                     <div class="tab-content_editor">
                        <div id="message" class="tab-pane active">
                           ' . adminArea('message', ($_POST['message'] ?? ''), 10, 'textarea', 'onchange ="caa(this);"', true) . '
                        </div>
                     </div>
                  </div>
                  <div class="form-group">
                     <div class="col-xs-6">
                     ' . scheckbox('no_mail', $no_mail, $lang['no_mail']) . '
                     </div>
                  </div>
                  <div class="form-group">
                     <div class="col-xs-6">
                     ' . scheckbox('status', $status, $lang['distribution_status']) . '
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="panel-footer">
         <input type ="hidden" name ="id" value ="' . $id . '">
         <input type ="hidden" name ="fromregdate" value ="' . $fromregdate . '">
         <input type ="hidden" name ="toregdate" value ="' . $toregdate . '">
         <input type ="hidden" name ="fromlastdate" value ="' . $fromlastdate . '">
         <input type ="hidden" name ="tolastdate" value ="' . $tolastdate . '">
         <input type ="hidden" name ="limit" value ="' . $limit . '">
         <input type ="hidden" name ="interval" value ="' . $interval . '">
         <input type ="hidden" name ="email" value ="' . $email . '">
         <button name="submit" type="submit" id="sub"	' . btn_class('primary') . 'value="' . $lang['sendingmess'] . '">' . faSpan('fa-send', true, $lang['sendingmess']) . '</button>
         <button type="button" ' . btn_class('danger') . ' onclick="javascript:history.go(-1)">' . faSpan('fa-arrow-left', true, $lang['go_back']) . '</button>
         </div>
      </div>
      </form>
   </div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'send':
        $id = isset($_POST['id']) ? intval($_POST['id']) : '';
        $title = isset($_POST['title']) ? filter($_POST['title'], 'a') : '';
        $message = isset($_POST['message']) ? filter($_POST['message'], 'html') : '';
        $status = isset($_POST['status']) ? intval($_POST['status']) : 1;
        if (!empty($title) && !empty($message)) {
            $core->upd_data('distribution', '`title` ="' . $db->safesql($title) . '", `message` ="' . $db->safesql(parseBB(processText($message))) . '", `status` ="' . $status . '"', 'id ="' . $id . '"');
            action_alert('root', 'success', 'distribution', false, 'sendok');
        } else {
            action_alert('root', 'danger', 'distribution', false, 'sendfalse');
        }
        break;
    case 'repeat':
        $id = isset($url[3]) ? intval($url[3]) : '';
        if (!empty($id)) {
            $rows = $core->row_data('distribution', 'id ="' . $id . '"');
            $active = $rows['status'] == 0 ? 1 : 0;
            $core->upd_data('distribution', 'status ="' . $active . '"', 'id ="' . $id . '"');
            action_alert('root', 'success', 'distribution', false, 'sendok');
        } else {
            action_alert('root', 'danger', 'distribution', false, 'sendfalse');
        }
        break;
    case 'delete':
        $id = isset($url[3]) ? intval($url[3]) : '';
        if ($id) {
            delete($id);
            action_alert('root', 'success', 'distribution');
        } else {
            action_alert('root', 'danger', 'distribution', false, 'unknown_error');
        }
        break;
    case 'action':
        $type = $_POST['submit'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            if ($type == 'delete') {
                foreach ($_POST['checks'] as $id) {
                    delete($id);
                    action_alert('root', 'success', 'distribution');
                }
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'distribution');
        }
        break;
}
function interval_range($interval): string
{
    global $lang;
    $intList = '<input style="width: 170px;" value="' . $interval . '" type="range" name="interval" step="3" min="0" max="30" list="intList" onchange="document.getElementById(\'intValue\').innerHTML = this.value;">
<datalist id="intList">';
    $interval = (string)$interval;
    for ($i = 1; $i < 31; $i++) {
        $intList .= '<option value="' . ($i < 10 ? '0' . $i : $i) . '" label="' . $i . '"' . ($interval[0] == $i ? "range" : "") . '>' . declension($i, array($lang['seconds1'], $lang['seconds2'], $lang['seconds3'])) . '</option>';
    }
    $intList .= '</datalist>
<span id="intValue">' . declension($interval, array($lang['seconds1'], $lang['seconds2'], $lang['seconds3'])) . '</span>';
    return $intList;
}

function limit_range($limit): string
{
    global $lang;
    $limitList = '<input style="width: 170px;" value="' . $limit . '" type="range" name="limit" step="5" min="0" max="50" list="limitList" onchange="document.getElementById(\'limitValue\').innerHTML = this.value;">
<datalist id="limitList">';
    $limit = (string)$limit;
    for ($i = 1; $i < 51; $i++) {
        $limitList .= '<option value="' . ($i < 10 ? '0' . $i : $i) . '" label="' . $i . '"' . ($limit[0] == $i ? "range" : "") . '>' . declension($i, array($lang['mail1'], $lang['mail2'], $lang['mail3'])) . '</option>';
    }
    $limitList .= '</datalist>
<span id="limitValue">' . declension($limit, array($lang['mail1'], $lang['mail2'], $lang['mail3'])) . '</span>';
    return $limitList;
}

function delete($id): void
{
    global $core;
    $core->upd_data('users', '`distsend` = 0, `dist_id` ="' . $id . '"');
    $core->del_data('distribution', 'id ="' . $id . '"');
    full_rmdir(ROOT . initDC('distribution', '', '', $id));
    clearcache();
}