<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
require_once(ROOT . 'etc/feedback.config.php');
global $adminTpl, $url, $core, $db, $config, $feedback_conf, $lang;
switch ($url[2] ?? null) {
    default:
    case 'users':
        feedback_users();
        break;
    case 'delete':
        $id = isset($url[3]) ? intval($url[3]) : '';
        if (!empty($id)) {
            delete($id);
            action_alert('root', 'success', 'feedback');
        } else {
            action_alert('root', 'danger', 'feedback', false, 'unknown_error');
        }
        break;
    case 'restread':
        $id = intval($url[3]);
        if (!empty($id)) {
            $rows = $core->row_data('feedback', 'id ="' . $id . '"');
            $status = $rows['status'] == 0 ? 1 : 0;
            $core->upd_data('feedback', '`status` ="' . $status . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_feedback'], 1, false, false, $rows['title']);
            action_alert('root', 'success', 'feedback');
        } else {
            action_alert('root', 'danger', 'feedback', false, 'unknown_error');
        }
        break;
    case 'restsent':
        $id = intval($url[3]);
        if (!empty($id)) {
            $rows = $core->row_data('feedback', 'id ="' . $id . '"');
            $status = $rows['status'] == 2 ? 3 : 2;
            $core->upd_data('feedback', '`status` ="' . $status . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_feedback'], 1, false, false, $rows['title']);
            action_alert('root', 'success', 'feedback');
        } else {
            action_alert('root', 'danger', 'feedback', false, 'unknown_error');
        }
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'reRestread':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('feedback', 'status = 1', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'feedback');
                    }
                    break;
                case 'reRestnread':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('feedback', 'status = 0', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'feedback');
                    }
                    break;
                case 'reRestsent':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('feedback', 'status = 3', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'feedback');
                    }
                    break;
                case 'reRestunanswered':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('feedback', 'status = 2', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'feedback');
                    }
                    break;
                case 'Delete':
                    foreach ($_POST['checks'] as $id) {
                        delete(intval($id));
                        action_alert('root', 'success', 'feedback');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'feedback');
        }
        break;
    case 'letter':
        $method = $url[3] ?? '';
        method_letter('root', 'feedback', 'feedback', $method);
        break;
    case 'send_letter':
        $method = $url[3] ?? '';
        method_send('root', 'feedback', $method, 'feedback', $feedback_conf['feedback_mail'], 'html_comp_mail', 'comp_mail_text');
        break;
    case 'config':
        init_count_text();
        require(ROOT . 'etc/feedback.config.php');
        global $feedback_conf, $lang;
        $configBox = array(
            'feedback' => array(
                'varName' => 'feedback_conf',
                'title' => $lang['ap_feedback'],
                'groups' => array(
                    'main' => array(
                        'title' => $lang['ap_l_main'],
                        'vars' => array(
                            'ref_on' => array(
                                'title' => $lang['ap_l_main_refresh_listt'],
                                'description' => $lang['ap_l_main_num_secondsd'],
                                'content' => radio("ref_on", $feedback_conf['ref_on']),
                            ),
                            'ref_stat' => array(
                                'title' => $lang['ap_l_main_numt'],
                                'description' => $lang['ap_l_main_num_secondsd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'feedback_pm' => array(
                                'title' => $lang['apsend_main_pm'],
                                'description' => $lang['apsend_main_pm_use'],
                                'content' => radio("feedback_pm", $feedback_conf['feedback_pm']),
                            ),
                            'feedback_mail' => array(
                                'title' => $lang['apsend_main_email'],
                                'description' => $lang['apsend_main_email_use'],
                                'content' => radio("feedback_mail", $feedback_conf['feedback_mail']),
                            ),
                            'html_feedback_mail' => array(
                                'title' => $lang['apsend_main_email_html'],
                                'description' => $lang['apsend_main_email_use_html'],
                                'content' => radio("html_feedback_mail", $feedback_conf['html_feedback_mail']),
                            ),
                            'allow_attach' => array(
                                'title' => $lang['ap_l_main_allow_attacht'],
                                'description' => $lang['ap_l_main_allow_attachd'],
                                'content' => radio("allow_attach", $feedback_conf['allow_attach']),
                            ),
                            'formats' => array(
                                'title' => $lang['ap_l_main_formatst'],
                                'description' => $lang['ap_l_main_formatsd'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                            'file_size' => array(
                                'title' => $lang['ap_l_main_file_sizet'],
                                'description' => $lang['ap_l_main_file_sized'],
                                'content' => int_cong('input', '{varName}', '{var}'),
                            ),
                        )
                    ),
                    'seo' => array(
                        'title' => $lang['seo'],
                        'vars' => array(
                            'keywords' => array(
                                'title' => $lang['seo_keywords'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'keywords'),
                            ),
                            'description' => array(
                                'title' => $lang['seo_description'],
                                'description' => $lang['seo_settings'],
                                'content' => int_cong('textarea', '{varName}', '{var}', 'description'),
                            ),
                        )
                    ),
                ),
            ),
        );
        $ok = false;
        if (isset($_POST['conf_file'])) $ok = true;
        generateConfig($configBox, 'feedback', '{ADMIN_LINK}/config', $ok);
        break;
}
function feedback_users(): void
{
    global $adminTpl, $url, $core, $db, $config, $feedback_conf, $lang;
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    $where = 'id <> 0';
    $order = '';
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
    $s_email = isset($_POST['s_email']) ? filter($_POST['s_email'], 'a') : '';
    $s_nick = isset($_POST['s_nick']) ? filter($_POST['s_nick'], 'a') : '';
    $s_search = isset($_POST['s_search']);
    if (isset($url[2]) && $url[2] == 'order') {
        switch ($url[3] ?? '') {
            case 'abc':
                $order .= 'title ASC';
                break;
            case 'date':
                $order .= 'date DESC';
                break;
            case 'id':
                $order .= 'id ASC';
                break;
        }
    } else {
        $order .= 'date DESC';
    }
    if ($s_id) {
        $where .= "AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
    } else {
        $s_id = '';
    }
    if ($s_title) $where .= "AND `title` LIKE '%" . $db->safesql($s_title) . "%'";
    if ($s_email) $where .= "AND `email` LIKE '%" . $db->safesql($s_email) . "%'";
    if ($s_nick) $where .= "AND `nick` LIKE '%" . $db->safesql($s_nick) . "%'";
    $query = $core->select_data('feedback', $where, $order . ' LIMIT ' . limit_page());
    $adminTpl->admin_head($lang['feedback']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('feedback');
        init_refresh($feedback_conf['ref_on'], $feedback_conf['ref_stat']);
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['feedback'] . '</span>
            ' . sort_head('root', 3) . '
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th><span class="pd-l-sm"></span>#</th>
                        <th>' . $lang['feedback_data'] . '</th>
                        <th>' . $lang['feedback_name'] . '</th>
                        <th>' . $lang['feedback_email'] . '</th>
                        <th>' . $lang['feedback_theme'] . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo '</tr>
                  </thead>
                  <tbody>';
        while ($feedback = $db->getRow($query)) {
            $users = $core->row_data('users', 'email ="' . $feedback['email'] . '"');
            echo '<tr>
                        <td><span class="pd-l-sm"></span>' . $feedback['id'] . '</td>
                        <td>' . formatDate($feedback['date'], true) . '</td>
                        <td>' . $feedback['nick'] . $feedback['name'] . '</td>
                        <td>' . $feedback['email'] . '</td>
                        <td ' . toggle($feedback['title']) . '>' . trimtitle($feedback['title'], 50) . '</td>
                        <td class="text-center">' . status_icon('feedback', $feedback['id'], 'feedback') . '</td>';
            init_checkbox('td', $feedback['id'], false, '<li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-view' . $feedback['id'] . '\')">' . faSpan('fa-television', true, $lang['view']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/restread/' . $feedback['id'] . '">' . (($feedback['status'] == 0) ? faSpan('fa-envelope-open-o', true, $lang['mark_read']) : faSpan('fa-envelope-o', true, $lang['mark_not_read'])) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/restsent/' . $feedback['id'] . '">' . (($feedback['status'] == 2) ? faSpan('fa-plus-circle', true, $lang['mark_response_sent']) : faSpan('fa-minus-circle', true, $lang['mark_notresponse_sent'])) . '</a></li>
            ' . (($feedback_conf['feedback_pm'] && $users['nick']) ? '<li><a href="{ADMIN_LINK}/letter/pm/' . $feedback['id'] . '\">' . faSpan('fa-user-o', true, $lang['pm']) . '</a></li>' : '') . '
            ' . (($feedback_conf['feedback_mail']) ? '<li><a href="{ADMIN_LINK}/letter/mail/' . $feedback['id'] . '\">' . faSpan('fa-envelope-o', true, $lang['mail_write']) . '</a></li>' : '') . '
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $feedback['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            modal_form_delete($feedback['id'], $feedback['title'], $lang['feedback_delete_title'], 'feedback', $lang['feedback_delete_text'], '{ADMIN_LINK}/delete/' . $feedback['id']);
            modal_form_text('view' . $feedback['id'], $lang['view'], 'fa-television', false, '
                        <p class="text-left">' . $lang['feedback_ip'] . ':&emsp; ' . $feedback['ip'] . '</p>
                        <p class="text-left">' . $lang['feedback_name'] . ':&emsp; ' . $feedback['nick'] . $feedback['name'] . '</p>
                        <p class="text-left">' . $lang['feedback_email'] . ':&emsp; ' . $feedback['email'] . '</p>
                        <p class="text-left">' . $lang['feedback_data'] . ':&emsp; ' . formatDate($feedback['date'], true) . '</p>
                        <p class="text-left">' . $lang['feedback_theme'] . ':&emsp; ' . $feedback['title'] . '</p>
                        <p class="short alt text-left">' . $lang['feedback_message'] . '&emsp;
                        <pre><code>' . $feedback['message'] . '</code></pre>
                        </p>', false, (($feedback_conf['feedback_pm'] && $feedback_conf['feedback_mail']) ? '<select id ="dropDownId" ' . btn_class('system') . '>
                           <option value="/{ADMIN_LINK}/letter/mail/' . $feedback['id'] . '\" >' . faSpan('fa-envelope-o', true, $lang['mails']) . '</option>
                           <option value="/{ADMIN_LINK}/letter/pm/' . $feedback['id'] . '\">' . faSpan('fa-user-o', true, $lang['pms']) . '</option>
                        </select>
                        <button name="submit" type="submit" id="sub"  ' . btn_class('system SubmitButton') . '>' . faSpan('fa-trash-o fa-arrow-right', true, $lang['next']) . '</button>' : '') . '
            <button name="submit" type="submit" id="sub" ' . btn_class('danger') . ' onclick="location.href = \'{ADMIN_LINK}/delete/' . $feedback['id'] . '\'">' . faSpan('fa-trash-o', true, $lang['delete']) . '</i></button>
         </div>
         <script src ="//code.jquery.com/jquery-3.0.0.min.js"></script> <!-- add jquery library-->
         <script type ="text/javascript">
            $(\'.SubmitButton\').click(function(){
                var urldata = $(\'#dropDownId :selected\').val();
                window.open("' . $config['url'] . '"+urldata+"")
            });
         </script>');
            echo '<div>
         </div>
         </td>
         </tr>';
        }
        echo '</tbody>';
        init_tfoot('<option value="reRestread">' . $lang['mark_read'] . '</option>
                           <option value="reRestnread">' . $lang['mark_not_read'] . '</option>
                           <option value="reRestsent">' . $lang['mark_response_sent'] . '</option>
                           <option value="reRestunanswered">' . $lang['mark_notresponse_sent'] . '</option>
                           <option value="Delete">' . $lang['delete'] . '</option>');
        echo '</table>
            </form>
         </div>
      </div>';
        page_list('root', 'feedback', 'feedback', $where);
        echo '</div>
<aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
            <label for="s_id" class="field prepend-icon">
            <input id="s_id" type="text" name="s_id" placeholder="' . $lang['id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
            <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
            </label>
         </div>
         <div class="section mb5">
            <label for="s_title" class="field prepend-icon">
            <input id="s_title" type="text" name="s_title" placeholder="' . $lang['feedback_theme'] . '" class="form-control" value="' . $s_title . '">
            <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
            </label>
         </div>
         <div class="section mb5">
            <label for="s_nick" class="field prepend-icon">
            <input id="s_nick" type="text" name="s_nick" placeholder="' . $lang['nick'] . '" class="form-control" value="' . $s_nick . '">
            <label for="s_nick" class="field-icon">' . faI('fa-user-o', false, false, true) . '</label>
            </label>
         </div>
         <div class="section mb15">
            <label for="s_email" class="field prepend-icon">
            <input id="s_email" type="text" name="s_email" placeholder="' . $lang['users_pre_email'] . '" class="form-control" value="' . $s_email . '">
            <label for="s_email" class="field-icon">' . faI('fa-envelope-o', false, false, true) . '</label>
            </label>
         </div>
        ' . init_sfoot(true, true) . '
      </div>
   </form>
</aside>';
    } else {
        if ($s_search) {
            $adminTpl->info($lang['feedback_search_list_empty'], 'info', null, $lang['info']);
            header('refresh: 5; url="{ADMIN_LINK}"');
        } else {
            $adminTpl->info($lang['feedback_list_empty'], 'empty', null, $lang['list'], false, false, 'modal', $lang['feedback_help'], null, null, $lang['feedback_help_desc'], true);
        }
    }
    echo '</div>
</div>
</div>';
    $adminTpl->admin_foot();
}

function delete($id): void
{
    global $core;
    $core->del_data('feedback', 'id ="' . $id . '"');
}