<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $url, $config, $lang;
switch ($url[2] ?? null) {
    default:
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        $where = 'id <> 0';
        $order = '';
        $link = '';
        $links = '';
        $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
        $s_name = isset($_POST['s_name']) ? filter($_POST['s_name'], 'a') : '';
        $s_search = isset($_POST['s_search']);
        if ($s_search) $s_search = $_POST['s_search'] == 1;
        if (isset($url[2]) && $url[2] == 'order') {
            switch ($url[3]) {
                case 'abc':
                    $order .= 'name ASC';
                    break;
                case 'id':
                    $order .= 'id DESC';
                    break;
            }
        } else {
            $order .= 'id ASC';
        }
        if ($s_id) {
            $where .= "AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
        } else {
            $s_id = '';
        }
        if ($s_name) $where .= "AND `name` LIKE '%" . $db->safesql($s_name) . "%'";
        $query = $core->select_data('groups', $where, $order . ' LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['group_users']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('groups');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['groups_list'] . '</span>
            ' . sort_head('root', 3, false) . '  
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th class="col-md-3 text-center hidden-xs hidden-sm text-nowrap">' . $lang['icon'] . '</th>
                        <th class="col-md-2 text-center">' . $lang['title'] . '</th>
                        <th style="width: 60px">&nbsp;</th>
                        <th class="col-md-1 text-center">' . faSpan('fa-users', true, false, false, $lang['panel_stats_user']) . '</th>
                        <th class="col-md-1 text-center">' . faSpan('fa-user-secret', true, false, false, $lang['group_users_special']) . '</th>
                        <th class="col-md-1 text-center">' . faSpan('fa-tachometer', true, false, false, $lang['panel']) . '</th>
                        <th class="col-md-1 text-center">' . faSpan('fa-shield', true, false, false, $lang['group_users_protect']) . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($group = $db->getRow($query)) {
                $icon = $group['icon'] == 'media/groups/' ? 'holder.js/160x45' : $group['icon'];
                $dland = delete_imposible($group['id']) ? $lang['delete_impossible'] : $lang['delete'];
                $durl = delete_imposible($group['id']) ? '' : 'onclick="modal_o(\'#modal-form-' . $group['id'] . '\')"';
                echo '<tr>
                        <td class="text-center hidden-xs"><span class="pd-l-sm"></span>' . $group['id'] . '</td>
                        <td class="w50 text-center hidden-xs hidden-sm text-nowrap"><img  src="' . $icon . '" class="br4" alt=""></td>
                        <td class="text-center">
                           <div class="text-center" id="editTitle_' . $group['id'] . '" onclick="EditTitle(\'editTitle_' . $group['id'] . '\', \'group\', \'' . $group['id'] . '\')"><b><span style="color:' . $group['color'] . '">' . Glang($group['name']) . '</span></b></div>
                        </td>
                        <td></td>
                        <td class="text-center">' . $core->sum_data('users', '`group` = ' . $group['id']) . '</td>
                        <td class="text-center">' . status_icon('groups', $group['id'], 'groups', $group['special']) . '</td>
                        <td class="text-center">' . status_icon('groups', $group['id'], 'groups', $group['admin']) . '</td>
                        <td class="text-center">' . status_icon('groups', $group['id'], 'groups', $group['protect']) . '</td>';
                if ($group['protect']) {
                    modal_form_delete($group['id'], $group['name'], $lang['group_users_protect_title'], 'group', $lang['group_users_protect_text']);
                } else {
                    modal_form_delete($group['id'], $group['name'], $lang['group_users_del_title'], 'group', $lang['group_users_del_text'], '{ADMIN_LINK}/delete/' . $group['id']);
                }
                echo '</td>';
                init_checkbox('td', $group['id'], false, '<li><a href = \'{ADMIN_LINK}/edit/' . $group['id'] . '\'>' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li class="divider"></li>
                <li><a href="' . $core->fullURL() . '#" ' . $durl . '>' . faSpan('fa-trash-o text-danger', true, $dland) . '</a></li>');
                echo '</tr>';
            }
            echo '</tbody>
                  <tfoot class="panel-footer-lines admin-form">
                     <tr>
                        <td colspan="10">
                           <nav class="text-right">
                              <button name="submit" type="submit" id="sub" ' . btn_class('danger') . ' value="delete" ><i class="fa fa-trash-o fa-lg position-left"></i>' . $lang['delete'] . '</button>
                           </nav>
                        </td>
                     </tr>
                  </tfoot>
               </table>
            </form>
         </div>
      </div>';
            page_list('root', 'groups', 'groups');
            echo '</div>
<aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action="">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['group_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_name" class="field prepend-icon">
               <input id="s_name" type="text" name="s_name" placeholder="' . $lang['title'] . '" class="form-control" value="' . $s_name . '">
               <label for="s_name" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
              ' . init_sfoot(true, true) . '
         </div>
      </form>
   </aside>';
        } else {
            list_empty('root', 'groups', 'url', $s_search, false, true, $s_search);
        }
        echo '</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'add':
        groups_add();
        break;
    case 'edit':
        $id = intval($url[3]);
        groups_add($id);
        break;
    case 'save':
        $title = filter(htmlspecialchars_decode($_POST['title']), 'title');
        $guest = isset($_POST['guest']) ? intval($_POST['guest']) : '0';
        $user = isset($_POST['user']) ? intval($_POST['user']) : '0';
        $protect = isset($_POST['protect']) ? intval($_POST['protect']) : '0';
        $moderator = isset($_POST['moderator']) ? intval($_POST['moderator']) : '0';
        $admin = isset($_POST['admin']) ? intval($_POST['admin']) : '0';
        $aFullPerm = isset($_POST['aFullPerm']) ? intval($_POST['aFullPerm']) : '0';
        $banned = isset($_POST['banned']) ? intval($_POST['banned']) : '0';
        $showHide = isset($_POST['showHide']) ? intval($_POST['showHide']) : '0';
        $showAttach = isset($_POST['showAttach']) ? intval($_POST['showAttach']) : '0';
        $loadAttach = isset($_POST['loadAttach']) ? intval($_POST['loadAttach']) : '0';
        $addPost = isset($_POST['addPost']) ? intval($_POST['addPost']) : '0';
        $addComment = isset($_POST['addComment']) ? intval($_POST['addComment']) : '0';
        $allowRating = isset($_POST['allowRating']) ? intval($_POST['allowRating']) : '0';
        $maxWidth = isset($_POST['maxWidth']) ? intval($_POST['maxWidth']) : '0';
        $special = isset($_POST['special']) ? intval($_POST['special']) : '0';
        $points = isset($_POST['points']) ? intval($_POST['points']) : '0';
        $maxPms = isset($_POST['maxPms']) ? intval($_POST['maxPms']) : '0';
        $icon = filter($_POST['icon']);
        $color = filter($_POST['color']);
        $control = isset($_POST['adminAccess']) ? int_Serialize('ser', $_POST['adminAccess']) : '';
        if ($title) {
            if (!isset($_POST['edit'])) {
                $core->ins_data('groups', 'id,name,guest,user,moderator,admin,banned,showHide,showAttach,loadAttach,addPost,addComment,allowRating,maxWidth,maxPms,control,icon,color,points,protect,special', 'NULL,"' . $title . '","' . $guest . '","' . $user . '","' . $moderator . '","' . $admin . '","' . $banned . '","' . $showHide . '","' . $showAttach . '","' . $loadAttach . '","' . $addPost . '","' . $addComment . '","' . $allowRating . '","' . $maxWidth . '","' . $maxPms . '","' . $control . '","' . $icon . '","' . $color . '","' . $points . '","' . $protect . '","' . $special . '"');
                $core->ins_log(false, $lang['logs_add_groups'], 1, false, false, $title, false);
                action_alert('root', 'success', 'groups', false, str_replace(array('[name]'), array($title), $lang['group_users_add_ok']), true);
            } else {
                $core->upd_data('groups', '`name` ="' . $title . '",`guest` ="' . $guest . '",`user` ="' . $user . '",`moderator` ="' . $moderator . '",`admin` ="' . $admin . '", `banned` ="' . $banned . '", `showHide` ="' . $showHide . '", `showAttach` ="' . $showAttach . '", `loadAttach` ="' . $loadAttach . '", `addPost` ="' . $addPost . '", `addComment` ="' . $addComment . '",`allowRating` ="' . $allowRating . '", `maxWidth` ="' . $maxWidth . '", `maxPms` ="' . $maxPms . '", `control` ="' . $control . '", `icon` ="' . $icon . '", `color` ="' . $color . '", `points` ="' . $points . '", `protect` ="' . $protect . '", `special` ="' . $special . '"', 'id ="' . intval($_POST['edit']) . '"');
                $core->ins_log(false, $lang['logs_edit_groups'], 1, false, false, $title, false);
                action_alert('root', 'success', 'groups', false, str_replace(array('[name]'), array($title), $lang['group_users_edit_ok']), true);
            }
        } else {
            action_alert('root', 'danger', 'groups', false, 'unknown_error');
        }
        break;
    case 'delete':
        $id = intval($url[3]);
        delete($id);
        break;
    case 'action':
        global $lang;
        $type = $_POST['submit'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'delete':
                    foreach ($_POST['checks'] as $id) {
                        if (delete_imposible($id)) {
                            action_alert('root', 'danger', 'groups', false, 'group_delete_impossible');
                        } else {
                            delete($id);
                        }
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'groups');
        }
        break;
    case 'points':
        init_count_text();
        require(ROOT . 'etc/points.config.php');
        $configBox = array(
            'points' => array(
                'varName' => 'points_conf',
                'title' => $lang['group_users_config_name'],
                'groups' => array(
                    'main' => array(
                        'title' => $lang['group_users_config_name'],
                        'vars' => array(
                            'add_news' => array(
                                'title' => $lang['group_users_config_addnews'],
                                'description' => $lang['group_users_config_addnews_desc'],
                                'content' => '<input type="text" size="20" name="{varName}" class="form-control" value="{var}">',
                            ),
                            'add_comment' => array(
                                'title' => $lang['group_users_config_addcom'],
                                'description' => $lang['group_users_config_addcom_desc'],
                                'content' => '<input type="text" size="20" name="{varName}" class="form-control" value="{var}">',
                            ),
                            'register' => array(
                                'title' => $lang['group_users_config_reg'],
                                'description' => $lang['group_users_config_reg_desc'],
                                'content' => '<input type="text" size="20" name="{varName}" class="form-control" value="{var}">',
                            ),
                            'carma' => array(
                                'title' => $lang['group_users_config_carma'],
                                'description' => $lang['group_users_config_carma_desc'],
                                'content' => '<input type="text" size="20" name="{varName}" class="form-control" value="{var}">',
                            ),
                            'add_friend' => array(
                                'title' => $lang['group_users_config_friends'],
                                'description' => $lang['group_users_config_friends_desc'],
                                'content' => '<input type="text" size="20" name="{varName}" class="form-control" value="{var}">',
                            ),
                            'rating' => array(
                                'title' => $lang['group_users_config_vote'],
                                'description' => $lang['group_users_config_vote_desc'],
                                'content' => '<input type="text" size="20" name="{varName}" class="form-control" value="{var}">',
                            ),
                        )
                    ),
                ),
            ),
        );
        $ok = false;
        if (isset($_POST['conf_file'])) $ok = true;
        generateConfig($configBox, 'points', '{ADMIN_LINK}/points', $ok);
        break;
}
function groups_add($gid = null)
{
    global $adminTpl, $core, $user, $lang;
    if (isset($gid)) {
        $count = $core->sum_data('groups', 'id ="' . $gid . '"');
        if ($count == 1) {
            $group = $core->row_data('groups', 'id ="' . $gid . '"');
            $control = int_Serialize('uns', $group['control']);
        } else {
            location(ADMIN);
        }
        $admhead = $lang['group_edit'];
    } else {
        $group['name'] = '';
        $group['guest'] = 1;
        $group['user'] = 1;
        $group['moderator'] = 0;
        $group['admin'] = 0;
        $group['banned'] = 0;
        $group['showHide'] = 1;
        $group['showAttach'] = 1;
        $group['loadAttach'] = 0;
        $group['addPost'] = 0;
        $group['addComment'] = 1;
        $group['allowRating'] = 1;
        $group['maxWidth'] = $user['avatar_width'];
        $group['maxPms'] = 50;
        $group['icon'] = 'media/groups/';
        $group['color'] = '';
        $group['points'] = 0;
        $group['special'] = 0;
        $group['color'] = 0;
        $control = '';
        $admhead = $lang['groups_add'];
    }
    $validation_array = array(
        'title' => array(
            'required' => array('true', $lang['group_users_add_title_err']),
            'maxlength' => array(29, str_replace('[count]', '30', $lang['count_text_err_2']))
        ),
        'points' => array(
            'required' => array('true', $lang['group_users_add_points_err_1']),
            'number' => array('true', $lang['group_users_add_points_err_2']),
            'min' => array('0', $lang['group_users_add_points_err_3'])
        ),
        'maxWidth' => array(
            'required' => array('true', $lang['group_users_add_avatar_width_err_1']),
            'number' => array('true', $lang['group_users_add_avatar_width_err_2']),
            'min' => array('0', $lang['group_users_add_avatar_width_err_3'])
        ),
        'maxPms' => array(
            'required' => array('true', $lang['group_users_add_pm_err_1']),
            'number' => array('true', $lang['group_users_add_pm_err_2']),
            'min' => array('0', $lang['group_users_add_pm_err_3'])
        ),
        'icon' => array(
            'required' => array('true', $lang['group_users_add_icon_err'])
        ),
        'color' => array(
            'required' => array('true', $lang['group_users_add_color_err'])
        )
    );
    validationInit($validation_array);
    fancyboxInit();
    colorpickerInit('color_p', $group['color']);
    init_count_text();
    $adminTpl->js_code[] = '$("#points").spinner();';
    $_SESSION["RF"]["fff"] = "media/groups/";
    $adminTpl->admin_head($admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
    alert_info('groups');
    echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $admhead . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body">
            <form id="admin-form" class="form-horizontal parsley-form" enctype="multipart/form-data" role="form" method="POST" action="{ADMIN_LINK}/save" data-parsley-validate>
               <div class="form-group admin-form">
                  <label for="title" class="col-lg-3 col-sm-3 control-label">' . $lang['group_users_add_title'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="title" class="field prepend-icon">
                     <input id="title" type="text" name="title" value="' . $group['name'] . '" onkeyup="count_down(this, \'title\', 30)" maxlength="30" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['group_users_add_title_pre'] . '">
                     <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                     </label>
                      <div style="text-align:right" class="text-right">
                           <span id="char_title"></span>
                        </div>
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['group_users_add_special'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <div class="switch switch-info round switch-inline">
                        <input type="hidden" name="special" value="0">
                        <input id="radio_special" name="special" type="checkbox"  value="1"' . ($group['special'] == 1 ? 'checked' : '') . ' onclick="showhide(\'points_gr\');">
                        <label for="radio_special"></label>                     
                     </div>
                     <div class="admin-form">
                      <span class="input-footer text-left">' . faI('fa-bell') . $lang['group_users_add_special_desc'] . '</span>
                     </div> 
                  </div>
               </div>
               <div class="form-group admin-form" id="points_gr" style="display:none;">
                  <label class="col-sm-3 control-label">' . $lang['group_users_add_points'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <div class="input-group">
                        <input id="points" value="' . $group['points'] . '" type="text" name="points" class="form-control ui-spinner-input">                
                      </div>
                     <div class="admin-form">
                      <span class="input-footer text-left">' . faI('fa-bell') . $lang['group_users_add_points_desc'] . '</span>
                     </div> 
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['group_users_add_right_guest'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     ' . radio("guest", $group['guest']) . '
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['group_users_add_right_user'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     ' . radio("user", $group['user']) . '
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['group_users_add_right_moder'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     ' . radio("moderator", $group['moderator']) . '
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['group_users_add_right_admin'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     ' . radio("admin", $group['admin']) . '
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['group_users_add_right_ban'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     ' . radio("banned", $group['banned']) . '
                  </div>
               </div>
               <div class="form-group">
                  <label class="col-sm-3 control-label">' . $lang['group_users_add_right_full'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <div class="switch switch-info round switch-inline">
                        <input type="hidden" name="aFullPerm" value="0">
                        <input id="aFullPerm" name="aFullPerm" type="checkbox" checked value="1" onclick="showhide(\'aPerm\');">
                        <label for="aFullPerm"></label>
                     </div>
                  </div>
               </div>
               <div class="form-group"' . (!empty($group['control']) ? '' : 'style="display:none;"') . ' id="aPerm">
               <label class="col-sm-3 control-label"></label>
               <div class="panel-body admin-form" style="padding:0;">
                  <div class="option-group field section">';
    require ROOT . 'root/list.php';
    require ROOT . 'etc/global.config.php';
    foreach (glob(ROOT . 'usr/modules/*/admin/list.php') as $listed) {
        include($listed);
    }
    $mods = '';
    $comp = '';
    $serv = '';
    foreach ($module_array as $module => $params) {
        $mods .= '<label class="option block mt10"><input type="checkbox" name="adminAccess[]" value="' . $module . '"' . ((!isset($gid) || empty($group['control'])) ? 'checked' : (in_array($module, $control) ? 'checked' : '')) . '><span class="checkbox"></span>' . $params['name'] . '</label><br/>';
    }
    foreach ($component_array as $component => $params) {
        if ($component == '') $component = 'index';
        $comp .= '<label class="option block mt10"><input type="checkbox" name="adminAccess[]" value="' . $component . '"	' . ((!isset($gid) || empty($group['control'])) ? 'checked' : (in_array($component, $control) ? 'checked' : '')) . '><span class="checkbox"></span>' . $params['name'] . '</label> <br/>';
    }
    foreach ($services_array as $sevices => $params) {
        $serv .= '<label class="option block mt10"><input type="checkbox" name="adminAccess[]" value="' . $sevices . '"	' . ((!isset($gid) || empty($group['control'])) ? 'checked' : (in_array($sevices, $control) ? 'checked' : '')) . '><span class="checkbox"></span> ' . $params['name'] . '</label> <br/>';
    }
    echo '<div class="form-group">
                        <div style="float:left; width:250px;"><strong>' . $lang['components'] . '</strong>
                           <span class="fileupload-new"><i>' . $comp . '</i></span>
                        </div>
                        <div style="float:left; width:250px;"><strong>' . $lang['services'] . '</strong>
                           <span class="fileupload-new"><i>' . $serv . '</i></span>
                        </div>
                        <div style="float:left; width:250px;"><strong>' . $lang['modules'] . '</strong>
                           <span class="fileupload-new"><i>' . $mods . '</i></span>
                        </div>
                     </div>
                  </div>
               </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['group_users_add_hide'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               ' . radio("showHide", $group['showHide']) . '
            </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['group_users_add_view'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               ' . radio("showAttach", $group['showAttach']) . '
            </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['group_users_add_load'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               ' . radio("loadAttach", $group['loadAttach']) . '
            </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['group_users_add_addnews'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               ' . radio("addPost", $group['addPost']) . '
            </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['group_users_add_comment'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               ' . radio("addComment", $group['addComment']) . '
            </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['group_users_add_rating'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               ' . radio("allowRating", $group['allowRating']) . '
            </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['group_users_add_avatar_width'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <input value="' . $group['maxWidth'] . '" type="text" name="maxWidth" class="form-control">
            </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['group_users_add_pm'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <input value="' . $group['maxPms'] . '" type="text" name="maxPms" class="form-control" >
            </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['group_users_add_icon'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <div class="smart-widget sm-right smr-50">
                  <input id="fieldID4" value="' . $group['icon'] . '" type="text" name="icon" class="form-control">
                  <span class="input-group-addon colorpicker-component cursor"><i></i></span>
               </div>
            </div>
         </div>';
    $icon = $group['icon'] == 'media/groups/' ? 'holder.js/160x45' : $group['icon'];
    echo '<div class="form-group">
             <label class="col-sm-3 control-label">' . $lang['group_users_add_icon'] . '</label>
             <div class="col-lg-5 col-md-5 col-sm-8">
                <div data-provides="fileupload" class="fileupload fileupload-new admin-form">
                   <div class="fileupload-preview thumbnail mb15">
                      <img src="' . $icon . '" class="br4" alt="holder">
                   </div>
                   <span ' . btn_class('system button btn-block ph5', true, true) . '>
                       <span class="fileupload-new">' . $lang['group_users_add_icon_again'] . '</span>
                       <input id="fbox" data-fancybox-type="iframe" href="usr/plugins/filemanager/dialog.php?type=images&field_id=fieldID4"></span>
                </div>
             </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['group_users_add_color'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <div id="color_p" class="input-group pull-right">
                  <input type="text" name="color" class="form-control" value="' . $group['color'] . '">
                  <span class="input-group-addon colorpicker-component cursor"><i></i></span>
               </div>
            </div>
         </div>';
    if (isset($gid)) echo '<input name="edit" type="hidden" class="buttons" id="sub" value="' . $gid . '">';
    echo '</div>
              <div class="panel-footer admin-form">
                <button  type="submit" ' . btn_class('system') . '>' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
              </div>
            </form>
        </div>
    </div>
</div>';
    $adminTpl->admin_foot();
}

function delete($id): void
{
    global $core, $lang;
    $groups = $core->row_data('groups', 'id ="' . $id . '"');
    if ($id) {
        $core->del_data('groups', 'id ="' . $id . '"');
        $core->ins_log(false, $lang['logs_delete_groups'], 1, false, false, $groups['name']);
        action_alert('root', 'success', 'groups');
    } else {
        action_alert('root', 'danger', 'groups', false, 'unknown_error');
    }
}

function delete_imposible($id)
{
    $g_ipos = array(null, '1', '2', '3', '4', '5', '6');
    if (isset($id)) {
        if (in_array($id, $g_ipos)) return true;
    }
}