<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $config, $url, $security, $user, $smiles, $lang;
switch ($url[2] ?? null) {
    default:
        init_count_text();
        $adminTpl->admin_head($lang['language_editor']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('language');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">
            <span class="panel-title">' . $lang['language_editor_desc'] . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-heading">
            <span class="panel-title">' . $lang['language_upload_inf'] . '</span>
         </div>
         <div class="switcher-content">
            <form style="text-align:center" method="post" enctype="multipart/form-data" action="{ADMIN_LINK}/upload">
               <div class="panel-body admin-form">
                   <div class="form-group">
                         <label class="col-lg-3 col-sm-3 control-label">' . $lang['fm_upload'] . '</label>
                         <div class="col-lg-5 col-md-5 col-sm-8">
                           <label class="field prepend-icon file"><span ' . btn_class('primary button btn-rounded ph30') . '>' . $lang['select_file'] . '</span>
							<input type="file" name="tpl" onchange="document.getElementById(\'uploader2\').value = this.value;" class="gui-file">
							<input id="uploader2" type="text" placeholder="' . $lang['choose_file_pre'] . '" class="gui-input">
                           <label class="field-icon">' . faI('fa-upload', false, false, true) . '</label>
                           </label>
                           <div class="section mb10 pt15">
                              <input name="submit" type="submit" id="sub" ' . btn_class('system button btn-block ph5', true, true) . ' value="' . $lang['upload'] . '">
                           </div>
                        </div>
                     </div>
               </div>
            </form>
            <hr class="short alt">
         </div>';
        $ni = 0;
        foreach (glob(ROOT . 'langs/*') as $dir) {
            $_name = basename($dir);
            if (is_dir($dir) && $_name != 'admin' && $_name != 'default') {
                $ni++;
                if (($ni % 5 == 0) || ($ni == 1)) echo '<div class="panel-body pn table-responsive">';
                $stand = ($_name <> 'ru') && ($_name <> 'en') ? $lang['language_out'] : $lang['language_in'];
                echo '<div class="col-xs-12 col-sm-6 col-md-3">
               <div class="panel panel-' . ($config['lang'] == $_name ? 'yellow' : 'success') . ' pricing-table-2 pn">
                  <div class="panel-heading text-center pn">' . $_name . '&nbsp;&nbsp;' . flags_langs($_name) . '</div>
                  <div class="panel-body">
                     <div class="plan-price text-center">
                        <p>' . $stand . '</p>
                        <small>' . $lang['jmy_cms'] . '</small>
                     </div>
                     <ul class="plan-features text-center">
                        <li><a href="{ADMIN_LINK}/download/' . $_name . '">' . $lang['language_load'] . '</a></li>
                        <li><a href="{ADMIN_LINK}/delete/' . $_name . '">' . $lang['language_del'] . '</a></li>
                     </ul>
                  </div>
                  <div class="panel-footer text-center">
                     <button ' . ($config['lang'] == $_name ? btn_class('yellow button btn-block ph5', false, true) . '>' . $lang['choosed'] : btn_class('success button btn-block ph5', false, true) . ' onclick="location.href=\'{ADMIN}/language/choose/' . $_name . '\';">' . $lang['choose']) . '</button>
                  </div>
               </div>
            </div>';
                if (($ni % 4 == 0)) echo '</div>';
            }
        }
        if (($ni % 4 != 0) && ($ni != 0)) {
            echo '</div>
      <div class="panel-footer-lines"></div>
   </div>';
        }
        $adminTpl->admin_foot();
        break;
    case 'edit_lang':
        init_count_text();
        $adminTpl->admin_head($lang['ap_edit_language']);
        echo '<div id="content" class="table-layout animated fadeIn">
      <div class="tray tray-center">';
        if (isset($url[2]) && $url[2] == 'edit_lang') $adminTpl->alert('info', $lang['info'], $lang['hot_keys']);
        alert_info('language/edit_lang');
        foreach (glob(ROOT . 'langs/' . $config['lang'] . '/*/*') as $inFile) {
            $name = explode('langs/' . $config['lang'] . '/', $inFile);
            $name = $name[1] ?? '';
            $subDir = explode('/', $name);
            $inDirs[$subDir[0]][] = $inFile;
        }
        foreach (glob(ROOT . 'langs/' . $config['lang'] . '/*/*/*') as $inFile) {
            $name = explode('langs/' . $config['lang'] . '/', $inFile);
            $name = $name[1] ?? '';
            $modsubDir = explode('/*', $name);
            $modinDirs[$modsubDir[0]][] = $inFile;
        }
        $zeroDirs = glob(ROOT . 'langs/' . $config['lang'] . '/' . $config['lang'] . '.*.lng');
        $codem = 'CodeMirror.fromTextArea("_code", {height:"dynamic",parserfile: ["parsexml.js","parsecss.js","tokenizejavascript.js","parsejavascript.js","parsehtmlmixed.js"],stylesheet: ["' . PLUGINS . 'highlight_code/xmlcolors.css","' . PLUGINS . 'highlight_code/jscolors.css","' . PLUGINS . 'highlight_code/csscolors.css"], path:"' . PLUGINS . 'highlight_code/", lineNumbers: false});';
        $file = $url[2];
        $adminTpl->footIncludes[] = '<script src="' . PLUGINS . '/highlight_code/codemirror.js" type="text/javascript"></script>
         <script type="text/javascript">ajaxGetJS(\'' . ADMIN . '/language/ajax/loadlang/' . $file . '\', \'' . $codem . '\', \'_div\');</script>';
        $adminTpl->headerIncludes[] = '<link rel="stylesheet" type="text/css" href="' . $adminTpl->file_dir . 'assets/css/ui.fancytree.min.css">';
        $adminTpl->js_code[] = '$("#tree5").fancytree({
         click: function(event, data)
         { // allow re-loads
         var node = data.node,
         orgEvent = data.originalEvent;
         if(node.data.href){
         ajaxGetJS(\'' . ADMIN . '/language/ajax/loadlang/\'+node.data.href, \'' . $codem . '\', \'_div\');
         }
         }
         });';
        echo '<div id="_div"></div>
      </div>
       <aside data-tray-height="match" class="panel tray-right tray-rescale tray320">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['ap_choose_language'] . '</h4>
             <hr class="alt short">
         <div id="tree5" class="fancytree-radio">
            <ul id="treeData" style="display: none;">';
        $count_folder = 0;
        if (isset($inDirs)) {
            foreach ($inDirs as $catalog => $files) {
                $count_folder++;
                $count_files = 0;
                $_fold[$catalog] = $lang['tpl_fold_' . $catalog] ?? $catalog;
                $catalog = $catalog <> 'modules' ? $catalog : '';
                if ($catalog) {
                    echo '<li id="' . $count_folder . '" class="text-left folder">' . ($_fold[$catalog] ?? $catalog) . '<ul>';
                    foreach ($files as $file) {
                        $count_files++;
                        $name = explode('/', $file);
                        $name = end($name);
                        $_a = explode('langs/' . $config['lang'] . '/', $file);
                        $absolute = str_replace(array('/', '.lng', '.js'), array('=', '_lng', '_js'), end($_a));
                        if (isset($url[3]) && $url[3] == $absolute) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("' . $count_folder . '.' . $count_files . '");';
                        echo '<li id="' . $count_folder . '.' . $count_files . '" class="text-left"><a href="' . $absolute . '">' . ($_names[$absolute] ?? $name) . '</a></li>';
                    }
                    echo '</ul>';
                }
            }
        }
        $count_modfolder = 0;
        if (isset($modinDirs)) {
            foreach ($modinDirs as $catalog => $files) {
                $count_modfolder++;
                $count_files = 0;
                $_fold[$catalog] = $lang['tpl_fold_' . $catalog] ?? $catalog;
                echo '<li id="' . $count_modfolder . '" class="text-left folder">' . ($_fold[$catalog] ?? $catalog) . '<ul>';
                foreach ($files as $file) {
                    $count_files++;
                    $name = explode('/', $file);
                    $name = end($name);
                    $_a = explode('langs/' . $config['lang'] . '/', $file);
                    $absolute = str_replace(array('/', '.lng', '.js'), array('=', '_lng', '_js'), end($_a));
                    if (isset($url[3]) && $url[3] == $absolute) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("' . $count_modfolder . '.' . $count_files . '");';
                    echo '<li id="' . $count_modfolder . '.' . $count_files . '" class="text-left"><a href="' . $absolute . '">' . ($_names[$absolute] ?? $name) . '</a></li>';
                }
                echo '</ul>';
            }
        }
        $count_files = 0;
        foreach ($zeroDirs as $file) {
            $count_files++;
            $name = explode('langs/' . $config['lang'] . '/', $file);
            $name = $name[1];
            $abs = str_replace(array('.lng', '.js'), array('', ''), ($name));
            $_names[$name] = $lang['tpl_name_' . $abs] ?? $name;
            if (isset($url[3]) && $url[3] == $name) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("0.' . $count_files . '");';
            echo '<li id="0.' . $count_files . '" class="text-left"><a href="' . $name . '">' . ($_names[$name] ?? $name) . '</a></li>';
        }
        echo '</ul>
      </aside>
      </div>
   </div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'save_lang':
        $langs = $url[3] ?? '';
        if (isset($langs)) {
            $path_to_file = ROOT . 'etc/global.config.php';
            $file_contents = file_get_contents($path_to_file);
            $file_contents = str_replace('$config[\'description\'] = "' . $config['description'] . '";', '$config[\'description\'] = "' . htmlspecialchars(str_replace('"', '\"', stripslashes(Gtranslate($config['description'], $config['lang'], $langs))), ENT_QUOTES) . '";', $file_contents);
            $file_contents = str_replace('$config[\'slogan\'] = "' . $config['slogan'] . '";', '$config[\'slogan\'] = "' . htmlspecialchars(str_replace('"', '\"', stripslashes(Gtranslate($config['slogan'], $config['lang'], $langs))), ENT_QUOTES) . '";', $file_contents);
            $file_contents = str_replace('$config[\'off_text\'] = "' . $config['off_text'] . '";', '$config[\'off_text\'] = "' . htmlspecialchars(str_replace('"', '\"', stripslashes(Gtranslate($config['off_text'], $config['lang'], $langs))), ENT_QUOTES) . '";', $file_contents);
            $file_contents = str_replace('$config[\'keywords\'] = "' . $config['keywords'] . '";', '$config[\'keywords\'] = "' . htmlspecialchars(str_replace('"', '\"', stripslashes(Gtranslate($config['keywords'], $config['lang'], $langs))), ENT_QUOTES) . '";', $file_contents);
            $file_contents = str_replace('$config[\'lang\'] = "' . $config['lang'] . '";', '$config[\'lang\'] = "' . htmlspecialchars(str_replace('"', '\"', stripslashes($langs)), ENT_QUOTES) . '";', $file_contents);
            file_put_contents($path_to_file, $file_contents);
            $path_to_file = ROOT . 'etc/security.config.php';
            $file_contents = file_get_contents($path_to_file);
            $file_contents = str_replace('$security[\'stopWords\'] = "' . $security['stopWords'] . '";', '$security[\'stopWords\'] = "' . htmlspecialchars(str_replace('"', '\"', stripslashes(Gtranslate($security['stopWords'], $config['lang'], $langs))), ENT_QUOTES) . '";', $file_contents);
            $file_contents = str_replace('$security[\'stopReplace\'] = "' . $security['stopReplace'] . '";', '$security[\'stopReplace\'] = "' . htmlspecialchars(str_replace('"', '\"', stripslashes(Gtranslate($security['stopReplace'], $config['lang'], $langs))), ENT_QUOTES) . '";', $file_contents);
            $file_contents = str_replace('$security[\'banIpMessage\'] = "' . $security['banIpMessage'] . '";', '$security[\'banIpMessage\'] = "' . htmlspecialchars(str_replace('"', '\"', stripslashes(Gtranslate($security['banIpMessage'], $config['lang'], $langs))), ENT_QUOTES) . '";', $file_contents);
            file_put_contents($path_to_file, $file_contents);
            $path_to_file = ROOT . 'etc/user.config.php';
            $file_contents = file_get_contents($path_to_file);
            $file_contents = str_replace('$user[\'commentEditText\'] = "' . $user['commentEditText'] . '";', '$user[\'commentEditText\'] = "' . htmlspecialchars(str_replace('"', '\"', stripslashes(Gtranslate($user['commentEditText'], $config['lang'], $langs))), ENT_QUOTES) . '";', $file_contents);
            file_put_contents($path_to_file, $file_contents);
            location($_SERVER['HTTP_REFERER']);
        } else {
            location(ADMIN);
        }
        break;
    case 'save':
        foreach ($_POST as $path => $html) {
            if ($path != false) {
                if (eregStrt('langs/ru/', $path)) {
                    $file = str_replace(array($config['lang'] . '_', '=', '_lng', '_js'), array($config['lang'] . '.', '/', '.lng', '.js'), $path);
                    if (is_writable($file)) {
                        $fp = @fopen($file, 'w');
                        $html = mb_convert_encoding($html, "UTF-8");
                        fwrite($fp, stripslashes($html));
                        fclose($fp);
                        $save_is = true;
                    }
                }
                action_alert('root', 'success', 'language', 'edit_lang', 'tpl_info_5');
            } else {
                action_alert('root', 'danger', 'language', 'edit_lang', 'tpl_info_9');
            }
        }
        break;
    case 'download':
        $urll = $url[3] ?? '';
        $lang_dir = ROOT . 'langs/' . $urll;
        if (is_dir($lang_dir)) {
            require_once(ROOT . 'boot/sub_classes/pclzip.lib.php');
            $archive = new PclZip('_temp_archive.zip');
            $v_list = $archive->create($lang_dir, PCLZIP_OPT_REMOVE_PATH, ROOT . 'langs/');
            if ($v_list == 0) die("Error :" . $archive->errorInfo(true));
            header('Content-type: application/zip');
            header('Content-Disposition: attachment; filename="' . $urll . '(JMY_CMS_LANGUAGE).zip"');
            print file_get_contents('_temp_archive.zip');
            @unlink('_temp_archive.zip');
            exit();
        }
        break;
    case 'upload':
        if (isset($_FILES['tpl'])) {
            require_once(ROOT . 'boot/sub_classes/pclzip.lib.php');
            $archive = new PclZip($_FILES['tpl']['tmp_name']);
            if (($v_result_list = $archive->extract(PCLZIP_OPT_PATH, ROOT . 'langs')) != 0) {
                $dir_root = explode('/', $v_result_list[0]['stored_filename']);
                if ($dir_root[0] != 'langs' && file_exists(ROOT . 'langs/' . $dir_root[0])) {
                    action_alert('root', 'success', 'language', false, 'language_info_3');
                } else {
                    full_rmdir(ROOT . 'langs/' . $dir_root[0]);
                    action_alert('root', 'danger', 'language', false, 'language_info_4');
                }
            } else {
                action_alert('root', 'danger', 'language', false, 'language_info_4');
            }
        } else {
            action_alert('root', 'danger', 'language', false, 'language_info_4');
        }
        break;
    case 'delete':
        $urll = $url[3] ?? '';
        $lang_dir = ROOT . 'langs/' . $urll;
        if ($config['lang'] != $urll) {
            full_rmdir($lang_dir);
            action_alert('root', 'success', 'language', false, 'language_info_0');
        } else {
            action_alert('root', 'danger', 'language', false, 'language_info_1');
        }
        break;
    case 'choose':
        $urll = $url[3] ?? '';
        $lang_choose = $urll;
        if (is_dir(ROOT . 'langs/' . $lang_choose)) {
            $file = ROOT . 'etc/global.config.php';
            $content = file_get_contents($file);
            $content = str_replace('$config[\'lang\'] ="' . $config['lang'] . '";', '$config[\'lang\'] ="' . $lang_choose . '";', $content);
            $fp = fopen($file, "wb");
            fwrite($fp, $content);
            fclose($fp);
            setcookie('language', $lang_choose, time(), '/');
            action_alert('root', 'success', 'language', false, 'language_info_2');
        } else {
            action_alert('root', 'danger', 'language', false, 'unknown_error');
        }
        break;
    case 'ajax':
        global $adminTpl, $db, $lang;
        ajaxInit();
        $type = $url[3] ?? '';
        if ($type == 'loadlang') {
            $file = (isset($url[4]) && file_exists('langs/' . $config['lang'] . '/' . str_replace(array('=', '_lng', '_js'), array('/', '.lng', '.js'), $url[4]))) ? str_replace(array('=', '_lng', '_js'), array('/', '.lng', '.js'), $url[4]) : $config['lang'] . '.tpl.lng';
            $text = htmlspecialchars(file_get_contents(ROOT . 'langs/' . $config['lang'] . '/' . $file), ENT_QUOTES);
            $count_rows = count(explode("\n", $text)) * 20;
            if (mb_detect_encoding($text) <> 'utf-8') convertEncoding($text);
            echo '<style>
   .va {
   border-left: 4px solid lightgrey;
   height: 100000px;
   position: absolute;
   left: 6%;
   margin-left: -3px;
   top: 0;
   }
   .vb {
   border-left: 4px solid greenyellow;
   height: 100000px;
   position: absolute;
   left: 7%;
   margin-left: -3px;
   top: 0;
   }.vba {
   border-left: 4px solid greenyellow;
   height: 100000px;
   position: absolute;
   left: 8%;
   margin-left: -3px;
   top: 0;
   }
   .vbb {
   border-left: 4px solid greenyellow;
   height: 100000px;
   position: absolute;
   left: 9%;
   margin-left: -3px;
   top: 0;
   }
   .vc {
   border-left: 4px solid orangered;
   height: 100000px;
   position: absolute;
   left: 42%;
   margin-left: -3px;
   top: 0;
   }
</style>
<form action="' . ADMIN . '/language/save/' . str_replace(array('/', '.lng', '.js'), array('=', '_lng', '_js'), $file) . '"	method="post" id="form" class="form" name="form">
   <div class="panel panel-dark panel-border top">
      <div class="panel-heading">
         <span class="panel-title"><b>' . $lang['ap_file_language'] . ' (' . $file . ')</b></span>
      </div>
      <div class="va"></div>
      <div class="vb"></div>
      <div class="vbb"></div>
      <div class="vc"></div>
      <div class="heading-hr"></div>
      <div class="panel-body">
         <div class="_code">
            <textarea name="langs/' . $config['lang'] . '/' . $file . '" class="textarea" id="_code">' . $text . '</textarea>
         </div>
      </div>
      <div class="panel-footer text-right">
         <button name="submit" type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
      </div>
   </div>
</form>';
        }
        break;
}
