<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $config, $url, $core, $configs, $clear, $lang;
switch ($url[2] ?? null) {
    default:
        $id = $url[2] ?? '';
        log_list($id);
        break;
    case 'clear':
        $id = isset($url[3]) ? filter($url[3]) : '';
        clear_log($id);
        action_alert('root', 'success', 'log', false, 'log_ok_clear');
        break;
}
function log_list($id = "*"): void
{
    global $adminTpl, $url, $lang;
    InitCountLines();
    init_count_text();
    Scroll('search');
    Clearform('search');
    $content = '';
    $errors = 0;
    $id = $id == 'all' ? '*' : $id;
    $logFiles = glob(ROOT . 'tmp/' . $id . '.log');
    $info = '';
    $adminTpl->admin_head($lang['log_log']);
    if (!empty($logFiles)) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        foreach ($logFiles as $file) {
            $data = int_Serialize('uns', @file_get_contents($file));
            if (!$data) {
                $content .= @file_get_contents($file);
                $count = $errors++;
                $errors = counts_error('phpError') + counts_error('db_query') + counts_error('dbError') + counts_error('accesError');
            } elseif (is_iterable($data)) {
                foreach ($data as $dat) {
                    $errors++;
                    $content .= $lang['messages'] . "\n----\n" . $dat['msg'] . "\n----\n" . $lang['ips'] . $dat['ip'] . "\n" . $lang['address'] . $dat['url'] . "\n" . $lang['browser'] . $dat['agent'] . "\n" . $lang['dates'] . formatDate($dat['time'], true) . "\n" . "\n" . "\n";
                }
            }
            if ($id == '*') {
                foreach (glob(ROOT . 'tmp/' . $id . '.log') as $files) {
                    $id = basename(str_replace('.log', '', $files));
                    $info = $lang['total'] . ' - ';
                }
            }
            if ($errors == 0) clear_log($id);
            alert_info('log');

        }
        $id = $url[2] == 'all' ? 'all' : $id;
        if ($errors > 0) $adminTpl->alert('info', $lang['info'], $lang['hot_logs']);
        echo '<div class="panel panel-danger panel-border top">
         <div class="panel-heading">
            <span class="panel-title"><b>' . $lang['log_name'] . '</b>	- ' . colorSpan('red', '[' . $info . $lang['log_error'] . ' : ' . $errors . ']') . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
              <div class="row">
  <div class="col-xs-12">
             <div class="tab-block mb25">
                     <div class="tab-content_editor">
                     <div class="switcher-content p20">
                  <textarea cols="30" rows="20" class="form-control weswap-current" OnKeyUp="ResizeTextArea(this,2);">' . $content . '</textarea><br/><br/>
               </div>
            </form>
         </div>
      </div>
   </div>
</div>
   </div>';
if ($errors > 0 && $id == $url[2]) init_dfoot(true, 'fa-trash-o', 'log_clear');
        echo '<div class="panel-footer admin-form">
         <button name="submit" type="submit" id="sub" value="' . $lang['log_clear'] . '" onclick="location.href = \'{ADMIN_LINK}/clear/' . $id . '\'" ' . btn_class('danger') . '>' . faSpan('fa-trash-o', true, $lang['log_clear']) . '</button>
   </div>
      </div>';
    } else {
        $adminTpl->info($lang['log_empty_error'], 'empty', null, $lang['info']);
    }
    echo '</div>
</div>';
    $adminTpl->admin_foot();
}

function clear_log_all()
{
    if (counts_error('phpError') >= 0) clear_log('phpError');
    if (counts_error('db_query') >= 0) clear_log('db_query');
    if (counts_error('dbError') >= 0) clear_log('dbError');
    if (counts_error('accesError') >= 0) clear_log('accesError');
}

function clear_log($id): void
{
    if ($id == 'all') clear_log_all();
    foreach (glob(ROOT . 'tmp/' . $id . '.log') as $file) {
        unlink($file);
    }
}

