<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

global $adminTpl, $admin_conf, $core, $db, $lang;
switch ($url[2] ?? null) {
    default:
        InitCheck();
        init_count_text();
        Scroll('search');
        UniClass('selectList');
        $news = $core->sum_data('news', 'active=2');
        $content = $core->sum_data('content', 'active=2');
        $comments = $core->sum_data('comments', 'status=2');
        $guestbook = $core->sum_data('guestbook', 'active=2');
        $adminTpl->admin_head($lang['moder']);
        if (($news || $content || $comments || $guestbook) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('moderation');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['moder'] . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th><span class="pd-l-sm"></span>#</th>
                        <th>' . $lang['date'] . '</th>
                        <th>' . $lang['module'] . '</th>
                        <th>' . $lang['content'] . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            moderation('news', 'active');
            moderation('content', 'active');
            moderation('comments', 'status');
            moderation('guestbook', 'active');
            echo '</tbody>';
            init_tfoot('<option value="activate">' . $lang['do_active'] . '</option>
                        <option value="delete">' . $lang['delete'] . '</option>');
            echo '</table>
            </form>
         </div>
      </div>
   </div>
   <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form">
            <h4 class="text-left p15 pt10">Статистика</h4>
            <hr class="short">          
            <div class="section mb5">
           <table class="table table-xs table-striped">
           <table class="table table-xs table-striped">
                  <thead>
                     <tr>                       
                        <th>' . $lang['module'] . '</th>
                        <th class="text-center">' . $lang['on_moder'] . '</th>
                        <th class="text-center">' . $lang['active'] . '</th>
                        </tr>
                  </thead>
                  <tbody>         
                       <tr>
                        <td>Новости</td>
                        <td class="text-center">' . $core->sum_data('news', 'active=2') . '</td>
                        <td class="text-center">' . $core->sum_data('news', 'active=1') . '</td>                   
                     </tr>
                      <tr>
                        <td>Страницы</td>
                        <td class="text-center">' . $core->sum_data('content', 'active=2') . '</td>
                        <td class="text-center">' . $core->sum_data('comments', 'status=2') . '</td>
                     </tr>
                     <tr>
                        <td>Комментарии</td>
                        <td class="text-center">' . $core->sum_data('comments', 'status=2') . '</td>
                        <td class="text-center">' . $core->sum_data('comments') . '</td>
                     </tr>
                       <tr>
                        <td>Отзывы</td>
                        <td class="text-center">' . $core->sum_data('guestbook', 'active=2') . '</td>
                        <td class="text-center">' . $core->sum_data('guestbook') . '</td>
                     </tr>
                    </tbody>
                </table>
              </div>               
            </div>
         </div>
      </form>
   </aside>
</div>';
        } else {
            $adminTpl->info($lang['moder_list_empty'], 'empty', null, $lang['moder'], false, false, 'url', $lang['moder_help'], null, null, $lang['moder_help_desc'], true);
        }
        $adminTpl->admin_foot();
        break;
    case 'mod':
        $mod = $url[3] ?? '';
        if (!empty($mod) && file_exists(ROOT . 'usr/modules/' . $mod . '/admin/moderation.php')) {
            if (file_exists(ROOT . 'langs/' . $core->lang . '/modules/' . $mod . '/' . $core->lang . '.admin.lng')) include(ROOT . 'langs/' . $core->lang . '/modules/' . $mod . '/' . $core->lang . '.admin.lng');
            require_once(ROOT . 'usr/modules/' . $mod . '/admin/moderation.php');
        }
        break;
    case 'com':
        $com = $url[3] ?? '';
        if (!empty($com) && file_exists(ROOT . 'root/components/moderation/' . $com . '.moderation.php')) require_once(ROOT . 'root/components/moderation/' . $com . '.moderation.php');
        break;
    case 'action':
        $mods = '';
        $stat = '';
        $type = $_POST['act'];
        foreach ($_POST['module'] as $module) {
            $mods = $module;
        }
        foreach ($_POST['status'] as $status) {
            $stat = $status;
        }
        if (is_array($_POST['status'])) {
            switch ($type) {
                case 'activate':
                    foreach ($_POST['checks'] as $id) {
                        $content = $core->sum_data($mods, $stat . '=2');
                        if ($content > 0) $core->upd_data($mods, $stat . ' = 1', 'id ="' . intval($id) . '"');
                    }
                    action_alert('root', 'success', 'moderation');
                    break;
                case 'delete':
                    foreach ($_POST['checks'] as $id) {
                        $content = $core->sum_data($mods, $stat . '=2');
                        if ($content > 0) {
                            if ($mods == 'news' || $mods == 'content') {
                                $row = $core->row_data('langs', 'postid ="' . $id . '"');
                                $news = $core->row_data($mods, 'id ="' . $id . '"');
                                $core->del_data('langs', '`postId` ="' . $id . '" AND `module` ="' . $mods . '"');
                                $core->del_data($mods, 'id ="' . $id . '"');
                                $core->upd_data('users', 'user_news=user_news-1', 'nick ="' . $news['author'] . '"');
                                $core->ins_log(false, $lang['logs_delete_news'], 1, false, false, $row['title']);
                                workTags($id, $news['tags'], 'delete');
                                full_rmdir(ROOT . initDC($mods, '', '', $id));
                                deleteComments($id, $mods);
                                clearcache();
                            } else {
                                $core->del_data($mods, 'id ="' . intval($id) . '"');
                            }
                        }
                    }
                    action_alert('root', 'success', 'moderation');
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'moderation');
        }
}
function modActivate($module = false, $status = false, $id = false): void
{
    global $core;
    $content = $core->sum_data($module, $status . '=1');
    if ($content > 0) $core->upd_data($module, $status . ' = 1', 'id ="' . intval($id) . '"');
}

function modDelete($module = false, $status = false, $id = false): void
{
    global $core;
    $content = $core->sum_data($module, $status . '=2');
    if ($content > 0) $core->del_data($module, 'id ="' . intval($id) . '"');
}

function modAlert($module = false, $status = false): void
{
    global $adminTpl, $core, $lang;
    $content = $core->sum_data($module, $status . '=2');
    if ($content > 0) $adminTpl->alert('warning', $lang['info'], $lang[$module . '_moder']);
}

function moderation($module = false, $status = false): void
{
    global $core, $db, $lang;
    $i = 0;
    $where = $status . ' = 2';
    $order = 'id DESC';
    $query = $core->select_data($module, $where, $order . ' LIMIT ' . limit_page());
    if ($db->numRows($query) > 0) {
        while ($modules = $db->getRow($query)) {
            $i++;
            $rows = $core->row_data('langs', 'module ="' . $module . '"');
            $text = $modules['text'] ?? (isset($modules['translate']) ? $rows['title'] : (isset($modules['altname']) ? $rows['title'] : $modules['comment']));
            $mod = array('news', 'content', 'guestbook');
            $mods = array('news', 'guestbook');
            $link = in_array($module, $mod) ? 'moderation/mod' : 'moderation/com';
            $edit_link = in_array($module, $mod) ? '/' . 'module' : '';
            $activate = in_array($module, $mods) ? '/moder_moderation' : '/retivate';
            $mame_mod = $module == 'content' ? $lang['static'] : $lang[$module];
            $url = '<a href="' . ADMIN . '/' . $link . '/' . $module . '" target="_blank"' . toggle($mame_mod) . '>' . trimtitle($mame_mod, 50) . '</a>';
            echo '<td><span class="pd-l-sm"></span>' . $modules['id'] . '</td>
                  <td> ' . formatDate($modules['date'], true) . ' </td>
                  <td> ' . $url . ' </td>
                  <td> ' . $text . '</td>
                  <td class="text-center"> ' . status_icon($module, $modules['id'], $module) . ' </td>';
            init_checkbox('td', $modules['id'], false, '<input type="hidden" name="status[]" value="' . $status . '">
         <input type="hidden" name="module[]" value="' . $module . '"><li><a href="' . ADMIN . '/' . $link . '/' . $module . '" target="_blank">' . faSpan('fa-desktop', true, $lang['view']) . '</a></li>
         <li><a href="' . ADMIN . '/' . $edit_link . '/' . $module . '/edit/' . $modules['id'] . '" target="_blank">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
         <li><a href="' . ADMIN . $edit_link . '/' . $module . $activate . '/' . $modules['id'] . '">' . faSpan('fa-power-off', true, $lang['do_active']) . '</a></li>
         <li class="divider"></li>
         <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $modules['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            modal_form_delete($modules['id'], $text, $lang['' . $module . '_delete_title'], $module, $lang['' . $module . '_delete_text'], ADMIN . '/' . $link . '/' . $module . '/delete/' . $modules['id']);
            echo '</td>
</tr>';
        }
    }
}