<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $lang;
$modArr[] = '';
$query = $core->select_data('plugins', 'service ="modules"');
while ($_mod = $db->getRow($query)) {
    $modArr[] = $_mod['title'];
    if (!file_exists(ROOT . 'usr/modules/' . $_mod['title'] . '/index.php')) delete($_mod['id']);
}
$path = ROOT . 'usr/modules/';
$dh = opendir($path);
while ($file = readdir($dh)) {
    if (!in_array($file, $modArr) && file_exists($path . $file . '/index.php')) {
        $core->ins_data('plugins', 'id,title,content,file,priority,type,service,showin,unshow,groups,free,template,categories,xfields,menu,active', 'NULL,"' . $file . '","' . ucfirst($file) . '","",0,"","modules","","","",0,"",0,0,0,1');
        $core->ins_log(false, $lang['logs_add_modules'], 1, false, false, $file, false);
    }
    delcache('plugins');
}
closedir($dh);
switch ($url[2] ?? null) {
    default:
        InitCheck();
        init_count_text();
        $query = $core->select_data('plugins', 'service ="modules"', 'id ASC LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['module_module']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('modules');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $lang['module_list_install'] . ' (' . $core->sum_data('plugins', 'service ="modules"') . '):</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th>' . $lang['title'] . '</th>
                        <th>' . $lang['description'] . '</th>
                        <th class="text-center">' . faSpan('fa-tachometer', true, false, false, $lang['apanel']) . '</th>
                        <th class="text-center">' . faSpan('fa-users', true, false, false, $lang['group']) . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($mod = $db->getRow($query)) {
                foreach (glob(ROOT . 'usr/modules/*/admin/list.php') as $listed) {
                    $file = $listed;
                    $file = str_replace(ROOT . 'usr/modules/', '', $file);
                    $file = str_replace('/admin/list.php', '', $file);
                    include($listed);
                }
                $link = file_exists(ROOT . 'usr/modules/' . $mod['title'] . '/admin/list.php') ? ADMIN . '/module' : ADMIN;
                if (isset($component_array[$mod['title']])) {
                    $mod_icon = $component_array[$mod['title']]['icon'];
                    $name = $component_array[$mod['title']]['name'];
                } elseif (isset($module_array[$mod['title']])) {
                    $mod_icon = $module_array[$mod['title']]['icon'];
                    $name = $module_array[$mod['title']]['name'];
                } elseif (isset($services_array[$mod['title']])) {
                    $mod_icon = $services_array[$mod['title']]['icon'];
                    $name = $services_array[$mod['title']]['name'];
                } else {
                    $mod_icon = 'fa fa-times';
                    $name = '';
                }
                $name = $name ? $name : $_names[$mod['title']] = $lang['users_' . $mod['title']];
                $icon = $mod_icon == 'fa fa-times' ? '<span class="' . $mod_icon . ' text-muted position-left"></span>' : '<a href = \'' . $link . '/' . $mod['title'] . '\'" target="_blank"><span class="' . $mod_icon . ' text-muted position-left"></span></a>';
                $groups_id = str_replace(array(','), array(''), $mod['groups']);
                $groups = $core->row_data('groups', 'id  ="' . $groups_id . '"');
                $module_ap = (file_exists(ROOT . 'usr/modules/' . $mod['title'] . '/admin/index.php') || file_exists(ROOT . 'root/modules/' . $mod['title'] . '.admin.php') ? colorSpan('green', faSpan('fa-cogs', true, false, false, $lang['yes'])) : colorSpan('red', faSpan('fa-cogs', true, false, false, $lang['no'])));
                $grroups = explode(',', $mod['groups']);
                $groups_icon = in_array('0', $grroups) ? colorSpan('grey', faSpan('fa-user-plus', true, false, false, $lang['all1'])) : colorSpan($groups['color'], faSpan('fa-user-secret', true, false, false, $groups['name']));
                echo '<tr>
                        <td><span class="pd-l-sm"></span>' . $mod['id'] . '</td>
                        <td>
                           <div class="media media-list hidden-xs">' . $icon . '</div>
                        </td>
                        <td>' . (isset($_names[$mod['title']]) ? $_names[$mod['title']] : $name) . '&nbsp;(' . $mod['title'] . ')</td>
                        <td>' . $mod['content'] . '</td>
                        <td class="text-center">' . $module_ap . '</td>
                        <td class="text-center">' . $groups_icon . '</td>
                        <td class="text-center">' . status_icon('plugins', $mod['id']);
                modal_form_delete($mod['id'], $mod['content'], $lang['module_delete_title'], 'mod', $lang['module_delete_text'], '{ADMIN_LINK}/delete/' . $mod['id'] . '/' . $mod['title']);
                echo '</td>';
                $mod_groups = (($mod['groups'] != false) ? '<option value="{ADMIN_LINK}/group/' . $mod['id'] . '/0">' . $lang['group_all'] . '</option>' : '');
                $querys = $core->select_data('groups', false, 'id ASC');
                while ($rows = $db->getRow($querys)) {
                    $selected = isset($mod['group']) && ($rows['id'] == $mod['group']) ? "selected" : "";
                    $mod_groups .= '<option value="{ADMIN_LINK}/group/' . $mod['id'] . '/' . $rows['id'] . '"' . $selected . '>' . $rows['name'] . '</option>';
                }
                modal_form_delete($mod['id'], $mod['content'], $lang['module_delete_title'], 'mod', $lang['module_delete_text'], '{ADMIN_LINK}/delete/' . $mod['id'] . '/' . $mod['title']);
                echo '</td>';
                init_checkbox('td', $mod['id'], false, '<li><a href="{ADMIN_LINK}/edit/' . $mod['id'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/retivate/' . $mod['id'] . '">' . faSpan('fa-power-off', true, (($mod['active'] == 0) ? $lang['activate'] : $lang['deactivate'])) . '</a></li>
                                 <li>
                                    <a>
                                          ' . faSpan('fa-user', false) . '
                                       <select onChange="if(this.options&#91;this.selectedIndex&#93;.value!=\'\'){window.location=this.options&#91;this.selectedIndex&#93;.value}else{this.options&#91;selectedIndex=0&#93;;}">
                                       <option value="">' . $lang['group_choose'] . '</option>
                                           ' . $mod_groups . '
                                       </select>
                                    </a>
                                 </li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $mod['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                echo '</tr>';
            }
            echo '</tbody>';
            init_tfoot('<option value="Activate">' . $lang['mod_activation'] . '</option>
                        <option value="deActivate">' . $lang['mod_deactivation'] . '</option>
                        <option value="reActivate">' . $lang['do_reactivation'] . '</option>');
            echo '</table>
            </form>
         </div>
      </div>';
            page_list('root', 'modules', 'plugins');
            echo '</div>';
        } else {
            $adminTpl->info($lang['module_list_empty'], 'error', null, $lang['module_list_install'], $lang['module_list_empty_help'], 'http://jmy.su/');
        }
        echo '</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'server':
        init_count_text();
        $chmod_files = array('usr/modules', 'usr/blocks', 'usr/plugins');
        foreach ($chmod_files as $dir) {
            if (!is_writable(ROOT . $dir)) $write_error[] = str_replace('[dir]', $dir, $lang['module_dirw']);
        }
        $adminTpl->admin_head($lang['module_module'] . ' |' . $lang['module_server']);
        if (!empty($write_error)) $adminTpl->alert('danger', $lang['attetion'], implode($write_error, '<br/>'));
        $query_search = '';
        if ($file_content = @file_get_contents($lang['server_jmy'] . 'modules.php?cat_list')) {
            $cat_list = explode('|', $file_content);
            if (!empty($cat_list)) {
                echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
  <div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['module_catalog'] . ':</span>
         </div>
             <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
<form enctype="multipart/form-data" class="navbar-form navbar-right KeYdomen-search alt" role="form" style="text-align:right"	onsubmit="ajaxGet(\'' . ADMIN . '/modules/ajax/search/\'+gid(\'querys\').value, \'_div\'); return false;">
                  <span class="hide visible-md-inline-block visible-lg-inline-block fa fa-search fs18"></span>
                  <div class="form-group">
                     <input id="querys" type="text" name="query" placeholder="' . $lang['search'] . '" class="form-control mr10" style="width: 280px; height: 40px; margin: 0px; font-size: 14px;"  value="' . $query_search . '"">
                  </div>
                  <button type="submit" class="btn btn-system  btn-sm btn-raised legitRipple">' . $lang['search'] . '</button>
                  <div id="_divi"></div>
               </form>
                     <div style="padding-right: 1px !important; margin-top: 20px; border-width: 0;" class="form-group admin-form pl25">';
                foreach ($cat_list as $li) {
                    $cl = '';
                    $cat_li = explode('-', $li);
                    switch ($cat_li[1]) {
                        case 'block':
                            $cl = "primary";
                            break;
                        case 'modules':
                            $cl = "success";
                            break;
                        case 'plagin':
                            $cl = "warning";
                            break;
                    }
                    echo '<button id="' . $cat_li[1] . '" type="button" onclick="ajaxGet(\'' . ADMIN . '/modules/ajax/cat/' . $cat_li[1] . '\', \'_div\'); setbold(\'' . $cat_li[1] . '\');" class="btn btn-' . $cl . ' btn-sm btn-raised legitRipple">' . Glang($cat_li[0]) . '</button> ';
                }
                echo ' </div></br></br>
            <div id="_div">
               <div class="panel-heading" >' . $lang['ajax_load'] . '</div>
               <script type="text/javascript">ajaxGet(\'' . ADMIN . '/modules/ajax/main\', \'_div\');</script>
            </div>
         </div>';
            }
        } else {
            $adminTpl->info($lang['module_no_connection'], 'error', null, $lang['module_catalog'], $lang['module_list_empty_help'], 'http://jmy.su/');
        }
        echo '<div class="panel-footer-lines"></div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'upload':
        init_count_text();
        $chmod_files = array('usr/modules', 'usr/blocks', 'usr/plugins');
        foreach ($chmod_files as $dir) {
            if (!is_writable(ROOT . $dir)) $write_error[] = str_replace('[dir]', $dir, $lang['module_dirw']);
        }
        if (!empty($write_error)) $adminTpl->alert('danger', $lang['attetion'], implode($write_error, '<br/>'));
        $adminTpl->admin_head($lang['module_module'] . ' | ' . $lang['module_upload']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
    <div id="_div"></div>';
        alert_info('modules');
        echo '<div class="panel panel-info panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['module_upload'] . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive p20">
            <form onsubmit="ajaxGet(\'' . ADMIN . '/modules/ajax/install/&in=\'+fixedEncodeURIComponent(gid(\'_url\').value), \'_div\'); return false;">
               <b>' . $lang['module_upload_url'] . '</b><br><br>
               <div class="form-group">
                  <input type="text" id="_url" name="_url" class="form-control" size=40" value="http://">
               </div>
               ' . colorSpan('red', $lang['module_upload_attation']) . '
         </div>
         <div class="panel-footer">
         <button type="submit" class="btn btn-info btn-sm btn-raised legitRipple">' . $lang['module_install'] . '</button>
         </form>
         </div>
      </div>
   </div>
</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'group':
        $rows = $core->row_data('plugins', 'id ="' . $url[3] . '"');
        $core->ins_log(false, $lang['logs_approve_groups_all'], 1, false, false, $rows['content'], false);
        if (isset($url[3]) && isset($url[4])) {
            $core->upd_data('plugins', '`groups` ="' . $url[4] . '"', 'id ="' . $url[3] . '"');
            action_alert('root', 'success', 'modules');
        } elseif (isset($url[3])) {
            $core->upd_data('plugins', '`groups` ="' . false . '"', 'id ="' . $url[3] . '"');
            action_alert('root', 'success', 'modules');
        } else {
            action_alert('root', 'danger', 'modules', false, 'unknown_error');
        }
        break;
    case 'ajax':
        $versions[1] = VERSION_ID;
        $i = 0;
        switch (isset($url[3]) ? $url[3] : '') {
            default:
                $response = gzinflate(@file_get_contents($lang['server_jmy'] . 'modules.php?main'));
                $cat_list = explode('|', @file_get_contents($lang['server_jmy'] . 'modules.php?cat_list'));
                if (!empty($cat_list)) {
                    foreach ($cat_list as $li) {
                        $cat_li = explode('-', $li);
                        $min[$cat_li[1]] = $cat_li[0];
                    }
                }
                echo '<table class="table table-striped">
   <thead>
      <tr>
         <th><span class="pd-l-sm"></span>&emsp;</th>
         <th>' . $lang['title'] . '</th>
         <th>' . $lang['description'] . '</th>
         <th class="text-center">' . $lang['author'] . '</th>
         <th class="text-center">' . $lang['type'] . '</th>
         <th class="text-center">' . $lang['base_version'] . '</th>
         <th class="text-center">' . $lang['base_version'] . ' JMY CMS</th>';
                init_checkbox();
                echo '</tr>
   </thead>
   <tbody>';
                $modules = unserialize($response);
                foreach ($modules as $mod => $info) {
                    $i++;
                    $ajax_url = '{ADMIN_LINK}/modules/ajax/install/&in="+fixedEncodeURIComponent("' . $info['url'] . '"),"_divi"';
                    echo '<tr>
         <td class="text-center">' . $i . '</td>
         <td>' . Glang($info['title']) . '</td>
         <td>' . Glang($info['description']) . '</td>
         <td class="text-center">' . $info['author'] . '</td>
         <td class="text-center">' . $info['cat'] . '</td>
         <td class="text-center">' . $info['version'] . '</td>
         <td class="text-center">' . Glang($info['version_jmy']) . '</td>
         <td class="text-center">' . (isset($core->tpl->modules[$mod]) ? '<button onclick="ajaxGet(\'{ADMIN_LINK}/ajax/delete/' . $mod . '/' . $core->tpl->modules[$mod]['id'] . '\', \'_divi\');" type="button" class="btn  btn-danger  btn-sm btn-raised legitRipple"  title="' . $lang['delete'] . '">' . faSpan('fa-trash-o', true) . '</button>' : '<button onclick="ajaxGet(' . $ajax_url . ');" type="button" class="btn btn-success btn-sm btn-raised legitRipple" title="' . $lang['base_install'] . '">' . faSpan('fa-plug', true) . '</button>') . '
         </td>
      </tr>';
                }
                echo '</tbody>
</table>';
                break;
            case 'cat':
                if (isset($url[4])) {
                    $response = '';
                    if (file_get_contents($lang['server_jmy'] . 'modules.php?cat_' . $url[4]) != 'empty') $response = gzinflate(@file_get_contents($lang['server_jmy'] . 'modules.php?cat_' . $url[4]));
                    if (empty($response)) {
                        echo '<div id="alert" class="p20 pt20 pb15">
    <div class="alert alert-default alert-styled-left alert-arrow-left alert-dismissible show">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
        <h5 class="alert-heading"><strong>' . $lang['error'] . '</strong></h5>
        <p class="mb-0">' . $lang['not_exist'] . '</p>
    </div>
</div>';
                    } else {
                        $cat_list = explode('|', @file_get_contents($lang['server_jmy'] . 'modules.php?cat_list'));
                        if (!empty($cat_list)) {
                            foreach ($cat_list as $li) {
                                $cat_li = explode('-', $li);
                                $min[$cat_li[1]] = $cat_li[0];
                            }
                        }
                        $i++;
                        echo '<table class="table table-striped">
<thead>
   <tr>
      <th><span class="pd-l-sm"></span>&emsp;</th>
      <th>' . $lang['title'] . '</th>
      <th>' . $lang['description'] . '</th>
      <th class="text-center">' . $lang['author'] . '</th>
      <th class="text-center">' . $lang['type'] . '</th>
      <th class="text-center">' . $lang['base_version'] . '</th>
      <th class="text-center">' . $lang['base_version'] . ' JMY CMS</th>';
                        init_checkbox();
                        echo '</tr>
</thead>
<tbody>';
                        $modules = unserialize($response);
                        foreach ($modules as $mod => $info) {
                            $ajax_url = '{ADMIN_LINK}/ajax/install/&in="+fixedEncodeURIComponent("' . $info['url'] . '"),"_divi"';
                            echo '<tr>
      <td class="text-center">' . $i . '</td>
      <td>' . $info['title'] . '</td>
      <td>' . $info['description'] . '</td>
      <td class="text-center">' . $info['author'] . '</td>
      <td class="text-center">' . $info['cat'] . '</td>
      <td class="text-center">' . $info['version'] . '</td>
      <td class="text-center">' . $info['version_jmy'] . '</td>
      <td class="text-center">' . (isset($core->tpl->modules[$mod]) ? '<button onclick="ajaxGet(\'' . ADMIN . '/modules/ajax/delete/' . $mod . '/' . $core->tpl->modules[$mod]['id'] . '\', \'_divi\');" type="button" class="btn  btn-danger  btn-sm btn-raised legitRipple"  title="' . $lang['delete'] . '">' . faSpan('fa-trash-o', true) . '</button>' : '<button onclick="ajaxGet(' . $ajax_url . ');" type="button" class="btn btn-success btn-sm btn-raised legitRipple" title="' . $lang['base_install'] . '">' . faSpan('fa-plug', true) . '</button>') . '
   </tr>';
                        }
                        echo '<script type="text/javascript">var bold = \'\'; function setbold(id) { if(bold != \'\') {gid(bold).style.fontWeight=\'normal\'; }	gid(id).style.fontWeight=\'bold\'; } </script>';
                    }
                } else {
                    echo '<div class="panel-heading">' . $lang['not_exist'] . '</div>';
                }
                break;
            case 'search':
                if (isset($url[4])) {
                    if (!empty($url[4])) {
                        $compressed = gzdeflate(@file_get_contents($lang['server_jmy'] . 'server.php?search=' . urlencode($url[4])));
                        $response = gzinflate($compressed);
                        $search = unserialize($response);
                        if (empty($search)) {
                            mod_alert('warning', 'Поиск по запросу"' . $url[4] . '"', $lang['search_complete'] . '<br/>' . $lang['records_no_found']);
                        } else {
                            $cat_list = explode('|', @file_get_contents($lang['server_jmy'] . 'module_categories.text'));
                            if (!empty($cat_list)) {
                                foreach ($cat_list as $li) {
                                    $cat_li = explode('-', $li);
                                    $min[$cat_li[1]] = $cat_li[0];
                                }
                            }
                            foreach ($search as $mod => $info) {
                                echo '<div class="_module_boxes">
      <div class="_buts">' . (isset($core->tpl->modules[$mod]) ? '<div class="_but _butdel"><a href="javascript:void(0)" onclick="ajaxGet(\'' . ADMIN . '/modules/ajax/delete/' . $mod . '/' . $core->tpl->modules[$mod]['id'] . '\', \'_div\');">' . $lang['delete'] . '</a></div>' : '<div class="_but"><a href="javascript:void(0)" onclick="gid(\'_div\').innerHTML = \'' . $lang['install_module'] . '\'; ajaxGet(\'' . ADMIN . '/modules/ajax/install/' . $mod . '\', \'_div\');">Установить</a></div>') . '<div class="_version ' . (!empty($info['for_toogle']) && $info['for_toogle'] != VERSION_ID ? (VERSION_ID > $info['for_toogle'] ? '_version2' : '_butdel') : (!empty($info['for_toogle']) ? '' : '_version3')) . '">' . (isset($info['for_toogle']) && isset($versions[$info['for_toogle']]) ? $versions[$info['for_toogle']] : 'N/A') . '</div>
      </div>
      <div class="_module_title">' . $info['title'] . ' (' . $mod . ')</div>
      <p>' . $info['description'] . '</p>
      <b>' . $lang['version_module'] . '</b> ' . $info['version'] . ($url[4] == 'all' ? '<br/><b>' . $lang['section'] . '</b> <a href="javascript:void(0)" onclick="ajaxGet(\'' . ADMIN . '/modules/ajax/cat/' . $info['cat'] . '\', \'_div\'); setbold(\'' . $info['cat'] . '\'); bold = \'' . $info['cat'] . '\';">' . $min[$info['cat']] . '</a>' : '') . '
   </div>';
                            }
                            echo '<script type="text/javascript">var bold = \'\'; function setbold(id) { if(bold != \'\') {gid(bold).style.fontWeight=\'normal\'; }	gid(id).style.fontWeight=\'bold\'; } </script>';
                        }
                    } else {
                        echo '<div class="_module_cat">' . $lang['search_module'] . '</div>
                        <div class="_inff _redinf" style="margin:0;">
                        <span style="font-size:14px; font-weight:bold;">' . $lang['errors'] . '</span>
                        <br/>' . $lang['search_not_empty'] . '</div>';
                    }
                }
                break;
            case 'install':
                global $config, $adminTpl;
                if (!empty($_REQUEST['in'])) {
                    $load_url = $_REQUEST['in'];
                    $load_url = str_replace('|', '/', $load_url);
                    if (eregStrt('.zip', $load_url)) {
                        $zip = $load_url;
                        $arr[1] = basename($zip);
                        $arr[2] = basename($zip, ".zip");
                    }
                    $adminTpl->admin_head();
                    if (!empty($arr[1]) && !isset($core->tpl->modules[$arr[2]]) && ($file_content = @file_get_contents($zip))) {
                        $file = fopen(ROOT . "tmp/temp_install.zip", "w");
                        fputs($file, $file_content);
                        fclose($file);
                        require_once(ROOT . 'boot/sub_classes/pclzip.lib.php');
                        $archive = new PclZip(ROOT . "tmp/temp_install.zip");
                        if ($v_result_list = $archive->extract(PCLZIP_OPT_PATH, ROOT) == 0) {
                            $adminTpl->admin_head();
                            $adminTpl->alert('warning', $lang['error'], $lang['module_no_archive']);
                        } else {
                            if (file_exists(ROOT . 'usr/modules/' . $arr[2] . '/sql.sql')) {
                                $sql = @file_get_contents(ROOT . 'usr/modules/' . $arr[2] . '/sql.sql');
                                if (!empty($sql)) {
                                    $sql_create_massiv = explode(";", $sql);
                                    foreach ($sql_create_massiv as $query) {
                                        preg_match('#`\[prefix\](.*)`#i', $query, $name);
                                        if (preg_match('#CREATE#i', $query)) {
                                            if (!eregStrt('[prefix]_users', $sql)) $db->query(str_replace('[prefix]', DB_PREFIX, $query));
                                            $sql = true;
                                        }
                                    }
                                }
                            }
                            if (file_exists(ROOT . 'usr/modules/' . $arr[2] . '/')) {
                                $file = fopen(ROOT . "usr/modules/" . $arr[2] . "/report.txt", "w");
                                fputs($file, serialize($v_result_list));
                                fclose($file);
                            }
                            if (file_exists(ROOT . 'usr/tpl/temp_tpl')) {
                                copydir(ROOT . 'usr/tpl/temp_tpl', ROOT . 'usr/tpl/' . $config['tpl']);
                                rmdir_rf(ROOT . 'usr/tpl/temp_tpl');
                            }
                            $core->ins_data('plugins', 'id,title,content,file,priority,type,service,showin,unshow,groups,free,template,categories,xfields,menu,active', 'NULL,"' . $db->safesql($arr[2]) . '","' . $db->safesql($arr[2]) . '","",0,"","modules","","","",0,"",0,0,1,1');
                            delcache('plugins');
                            $adminTpl->alert('success', $lang['base_info'], $lang['module_install_compl'] . (isset($sql) ? '<br>' . $lang['module_install_bd'] : ''));
                        }
                        @unlink(ROOT . "tmp/temp_install.zip");
                    } else {
                        $adminTpl->alert('danger', $lang['error'], $lang['module_install_error']);
                    }
                }
                break;
            case 'delete':
                if (isset($url[4]) && isset($url[5])) delete(intval($url[5]), $url[4]);
                break;
        }
        break;
    case 'edit':
        if (isset($url[3])) {
            $id = intval($url[3]);
            $module = $core->row_data('plugins', 'id = ' . $id);
            $title = $module['content'];
            $groups = $module['groups'];
            $grroups = explode(',', $groups);
            $unshow = explode(',', $module['unshow']);
        } else {
            $title = false;
            $groups = false;
            $grroups = array();
            $unshow = array();
            location();
        }
        UniClass('selectList');
        $adminTpl->admin_head($lang['edit_module']);
        $validation_array = array(
            'title' => array(
                'required' => array('true', $lang['add_descr_err']),
                'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
            ),
        );
        validationInit($validation_array);
        init_count_text();
        echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">';
        alert_info('modules');
        echo '<div class="panel panel-dark panel-border top">
      <div class="panel-heading"><span class="panel-title">' . $lang['edit_modules'] . $title . '</span>
      </div>
      <div class="heading-hr"></div>
      <div class="panel-body admin-form">
         <form id="admin-form" class="form-horizontal parsley-form" role="form" action="{ADMIN_LINK}/save" method="post" data-parsley-validate>
            <div class="form-group">
                  <label class="col-lg-3 col-sm-3 control-label">' . $lang['edit_modules_desc'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="title" class="field prepend-icon">
                     <textarea id="title" name="title" onkeyup="count_down(this, \'title\', 200)" maxlength="200" placeholder="' . $lang['banners_desc_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $title . '</textarea>
                     <label for="title" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                     </label>
                  <div style="text-align:right" class="text-right">
                      <span id="char_title"></span>
                  </div>
               </div>
            </div>
            <div class="form-group">
               <label class="col-sm-3 control-label">' . $lang['group_access'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label class="field select">
                        <select name="groups[]" class="select2-single form-control" data-parsley-required="true" data-parsley-trigger="change" multiple>
                           <option value="" ' . (in_array('0', $grroups) ? 'selected' : '') . '>' . $lang['group_all'] . '</option>';
        $query = $core->select_data('groups', false, 'admin DESC,moderator DESC,user DESC,guest DESC,banned DESC');
        while ($rows = $db->getRow($query)) {
            $selected = in_array($rows['id'], $grroups) ? "selected" : "";
            echo '<option value="' . $rows['id'] . '"' . $selected . '>' . $rows['name'] . '</option>';
        }
        echo '</select>
                  ' . faI('arrow double') . '
                  </label>
               </div>
            </div>';
        if (blocks($id) > 0) {
            echo '<div class="form-group">
               <label class="col-sm-3 control-label">' . $lang['not_reflect'] . '</label>
               <div class="col-sm-6">
                   ' . blocks($id) . '
                  ' . faI('arrow double') . '
               </div>
            </div>';
        }
        echo ' </div>
      <div class="panel-footer">
            ' . ((isset($id)) ? '<input type="hidden" name="id" value="' . $id . '">' : '') . '
    <button  name="submit" type="submit"  id="sub" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
      </div>
        </form>
   </div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'save':
        $id = isset($_POST['id']) ? intval($_POST['id']) : '';
        $title = isset($_POST['title']) ? filter($_POST['title'], 'title') : '';
        $type = isset($_POST['type']) ? $_POST['type'] : '';
        $groups = isset($_POST['groups']) ? $_POST['groups'] : false;
        $groupss = false;
        if (is_array($groups)) {
            foreach ($groups as $gid) {
                $groupss .= intval($gid) . ",";
            }
        } else {
            $groupss = $groups . ',';
        }
        $groupss = ',' . $groupss;
        $d = 0;
        $deList = '';
        if (!empty($type)) {
            foreach ($type as $typ) {
                if (trim($typ) !== '') {
                    $d++;
                    $deList = $d == 1 ? $typ : $deList . ',' . $typ;
                }
            }
        }
        $adminTpl->admin_head($lang['modules_system'] . ' | ' . $lang['edit']);
        if (!empty($title)) {
            $core->upd_data('plugins', '`content` ="' . $title . '",`unshow` ="' . $deList . '",`groups` ="' . $groupss . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_edit_modules'], 1, false, false, $title, false);
            delcache('plugins');
            action_alert('root', 'success', 'modules', false, 'modules_up_ok');
        } else {
            action_alert('root', 'danger', 'modules', false, 'unknown_error');
            delcache('plugins');
        }
        $adminTpl->admin_foot();
        break;
    case 'delete':
        $id = intval($url[3]);
        if ($id) {
            $path = filter($url[4]);
            delete($id, $path);
            delcache('plugins');
            action_alert('root', 'success', 'modules');
        } else {
            action_alert('root', 'danger', 'modules', false, 'unknown_error');
        }
        break;
    case 'retivate':
        $id = intval($url[3]);
        retivate($id);
        delcache('plugins');
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'Activate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('plugins', '`active` = 1', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'modules');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('plugins', '`active` = 0', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'modules');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('plugins', '`active` = NOT `active`', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'modules');
                    }
                    break;
            }
            delcache('plugins');
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'modules');
        }
        break;
}
function delete($id, $path = '')
{
    global $core, $lang;
    $plugins = $core->row_data('plugins', 'id ="' . $id . '"');
    if (!empty($id)) {
        $core->del_data('plugins', 'id ="' . intval($id) . '"');
        if ($path != '') full_rmdir(ROOT . 'usr/modules/' . $path . '/');
        $core->ins_log(false, $lang['logs_delete_modules'], 1, false, false, $plugins['title'], false);
    } else {
        action_alert('root', 'danger', 'modules', false, 'unknown_error');
    }
}

function retivate($id)
{
    global $core, $lang;
    $plugins = $core->row_data('plugins', 'id ="' . $id . '"');
    if (!empty($id)) {
        $core->upd_data('plugins', 'active = NOT `active`', 'id ="' . intval($id) . '"');
        action_alert('root', 'success', 'modules');
        $core->ins_log(false, $lang['logs_change_status_modules'], 1, false, false, $plugins['content'], false);
    } else {
        action_alert('root', 'danger', 'modules', false, 'unknown_error');
    }
}

function blocks($id)
{
    global $core, $db;
    if ($id) {
        $module = $core->row_data('plugins', 'id = ' . $id);
        $unshow = explode(',', $module['unshow']);
        $content = '<div class="form-group">';
        $query = $core->select_data('blocks_types', false, 'type DESC');
        while ($rows = $db->getRow($query)) {
            $check = in_array($rows['type'], $unshow) ? 'checked' : '';
            $content .= '<div class="col-xs-6">
      <label class="field option">
      <input id="checkbox' . $rows['type'] . '" type="checkbox" name="type[]"' . $check . ' value="' . $rows['type'] . '">
      <span class="checkbox mr10"></span>' . $rows['title'] . '</label><br>
      <hr class="alt short mv15">
   </div>';
        }
        $content .= '</div>';
        return $content;
    }
}

function mod_alert($tupe, $title, $text)
{
    global $admin_conf;
    echo '<style type="text/css">
    #message {
        padding: 10px;
        margin-bottom: 10px;
        background-color: #f8e896;
        font: 400 16px \'Open Sans\', sans-serif;
        border: 1px solid #dfd087;
        border-radius: 10px;
    }
</style>
<script src="https://snipp.ru/cdn/jquery/2.1.1/jquery.min.js"></script>
<script language="javascript">
    $(function () {
        $("#alert").delay(' . $admin_conf['alert_' . $tupe] . ').slideUp(300);
    });
</script>
<div id="alert" style ="padding-bottom:50px;">
    <div class="alert alert-' . $tupe . ' alert-styled-left alert-arrow-left alert-dismissible show">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
        <h5 class="alert-heading"><strong>' . $title . '</strong></h5>
        <p class="mb-0">' . $text . '</p>
    </div>
</div>';
}