<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $config, $url, $admin_conf, $smiles, $lang;
switch ($url[2] ?? null) {
    default:
        InitCheck();
        init_count_text();
        $i = 0;
        $adminTpl->admin_head($lang['smiles_control']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-border top">
         <div class="pl30 pr30">';
        init_Ajax_count('root', 'smiles', 'smiles_list', false, false, 'smiles_list');
        echo '</div>
      </div>';
        $k = 0;
        foreach ($smiles as $tag => $param) {
            $k = $k + 1;
        }
        if ($k <> 0) {
            alert_info('smiles');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['smiles_list'] . ' (' . $k . '):</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN}/smiles/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                       <th class="hidden-xs"><span class="pd-l-sm"></span>#</th>
                       <th></th>
                       <th class="col-md-7">' . $lang['titles'] . '</th>
                       <th class="text-center">' . $lang['url'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            foreach ($smiles as $tag => $param) {
                $saurl = str_replace($config['url'] . '/', '', $param['url']);
                $swurl = str_replace(array($config['url'], '/', 'media', 'smiles', $param['cat'], '.png'), array('', '', '', '', '', ''), $param['url']);
                $abridged = $param['abridged'] ? ' ( ' . $param['abridged'] . ' )' : '';
                $i++;
                echo '<tr>
                        <td class="hidden-xs"><span class="pd-l-sm"></span>' . smile_id($i, $param['title']) . '</td>
                        <td>
                           <div class="media media-list"><a href="' . $param['url'] . '" target="_blank"><img  src="' . $param['url'] . '" width="36" height="36"' . toggle($param['title']) . '  style="border:0" alt="" onmouseover="this.width=50;this.height=50" onmouseout="this.width=36;this.height=36"/></a></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['tag'] . ': ' . trimtitle($tag, 20) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['cats'] . ': ' . $param['cat'] . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['icon_desc'] . ': ' . $param['title'] . '</ol>
                        </td>
                        <td class="text-center"><a href="' . $param['url'] . '" target="_blank"' . toggle($saurl) . '>' . trimtitle($param['url'], 30) . '</a></td>';
                init_checkbox('td', $param['id'], false, '<li><a href="{ADMIN_LINK}/edit/' . $param['cat'] . '/' . $swurl . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $param['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                echo '</tr>';
                modal_form_delete($param['id'], $param['title'], $lang['smile_delete_title'], 'smiles', $lang['smile_delete_text'], '{ADMIN_LINK}/delete/' . $param['id']);
            }
            echo '</tbody>';
            init_tfoot('<option value="Delete">' . $lang['delete'] . '</option>');
            echo '</table>
            </form>
      </div>
   </div>
 </div>';
        } else {
            $adminTpl->info($lang['list_empty'], 'empty', null, $lang['smiles_list'], $lang['smiles_add'], ADMIN . '/smiles/add');
        }
        echo '</div>';
        $adminTpl->admin_foot();
        break;
    case 'smile_info':
        $cat = $url[3] ?? false;
        smile_cats_icon($cat, $lang['smile_' . $cat]);
        break;

    case 'delete':
        $id = isset($url[3]) ? intval($url[3]) : false;
        if ($id) {
            foreach ($smiles as $key => $value) {
                $smiles[$key] = array('cat' => $value['cat'], 'title' => $value['title'], 'abridged' => $value['abridged'], 'url' => $value['url']);
                if ($id == $key) unset($smiles[$key]);
            }
            $content = "global\$smiles;\n";
            $content .= '$smiles = ' . arr2str($smiles) . ';';
            save_conf(ROOT . 'etc/smiles.config.php', $content);
            action_alert('root', 'success', 'smiles');
        } else {
            action_alert('root', 'danger', 'smiles', false, 'unknown_error');
        }
        break;

    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            if ($type == 'delete') {
                foreach ($_POST['checks'] as $id) {
                    foreach ($smiles as $key => $value) {
                        $smiles[$key] = array('cat' => $value['cat'], 'title' => $value['title'], 'abridged' => $value['abridged'], 'url' => $value['url']);
                        if ($id == $key) unset($smiles[$key]);
                    }
                    $content = "global\$smiles;\n";
                    $content .= '$smiles = ' . arr2str($smiles) . ';';
                    save_conf(ROOT . 'etc/smiles.config.php', $content);
                    action_alert('root', 'success', 'smiles');
                }
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'success');
        }
        break;
    case 'add':
        smiles_add();
        break;
    case 'edit':
        $sid = $url[4] ?? 0;
        smiles_add($sid);
        break;
    case 'save':
        $tags = !empty($_POST['tag']) ? filter($_POST['tag'], 'a') : '';
        $title = !empty($_POST['title']) ? filter($_POST['title'], 'a') : '';
        $cat = !empty($_POST['cat']) ? filter($_POST['cat'], 'cat') : '';
        $abridged = !empty($_POST['abridged']) ? filter($_POST['abridged'], 'a') : '';
        $tag = $lang['s_begin'] . $tags . $lang['s_end'];
        $url = str_replace($config['url'] . '/', '', $_POST['url']);
        if (isset($_POST['edit']) == 1) {
            $success = 'smile_info_6';
            $danger = 'smile_info_7';
        } else {
            $success = 'smile_info_2';
            $danger = 'smile_info_3';
        }
        if ($url && $tag && $cat && $title) {
            $smiles[$tag] = array('cat' => $cat, 'title' => $title, 'abridged' => $abridged, 'url' => $url);
            $content = "global\$smiles;\n";
            $content .= '$smiles = ' . arr2str($smiles) . ';';
            save_conf(ROOT . 'etc/smiles.config.php', $content);
            action_alert('root', 'success', 'smiles', false, $success);
        } else {
            action_alert('root', 'danger', 'smiles', false, $danger);
        }
        break;
    case 'ajax':
        ajaxInit();
        $type = $url[3];
        if ($type == 'smiles_list') {
            $k = 0;
            $i_s = 0;
            $i_p = 0;
            $i_a = 0;
            $i_fo = 0;
            $i_ac = 0;
            $i_at = 0;
            $i_ob = 0;
            $i_sy = 0;
            $i_fl = 0;
            $s = 0;
            $p = 0;
            $an = 0;
            $fo = 0;
            $ac = 0;
            $tr = 0;
            $ob = 0;
            $sy = 0;
            $fl = 0;
            $csmile = 0;
            $cpeople = 0;
            $canimals = 0;
            $cfood = 0;
            $cactivities = 0;
            $ctravel = 0;
            $cobjects = 0;
            $csymbols = 0;
            $cflags = 0;
            foreach ($smiles as $tag => $param) {
                $k = $k + 1;
                if ($param['cat'] <> 'smile') {
                    $i_s++;
                    $csmile = $k - $i_s;
                } else {
                    $csmile = 0;
                }
                $s = $csmile < 100 ? 0 : '';
                if ($param['cat'] <> 'people') {
                    $i_p++;
                    $cpeople = $k - $i_p;
                } else {
                    $cpeople = 0;
                }
                $p = $cpeople < 100 ? 0 : '';
                if ($param['cat'] <> 'animals') {
                    $i_a++;
                    $canimals = $k - $i_a;
                } else {
                    $canimals = 0;
                }
                $an = $canimals < 100 ? 0 : '';
                if ($param['cat'] <> 'food') {
                    $i_fo++;
                    $cfood = $k - $i_fo;
                } else {
                    $cfood = 0;
                }
                $fo = $cfood < 100 ? 0 : '';
                if ($param['cat'] <> 'activities') {
                    $i_ac++;
                    $cactivities = $k - $i_ac;
                } else {
                    $cactivities = 0;
                }
                $ac = $cactivities < 100 ? 0 : '';
                if ($param['cat'] <> 'travel') {
                    $i_at++;
                    $ctravel = $k - $i_at;
                } else {
                    $ctravel = 0;
                }
                $tr = $ctravel < 100 ? 0 : '';
                if ($param['cat'] <> 'objects') {
                    $i_ob++;
                    $cobjects = $k - $i_ob;
                } else {
                    $cobjects = 0;
                }
                $ob = $cobjects < 100 ? 0 : '';
                if ($param['cat'] <> 'symbols') {
                    $i_sy++;
                    $csymbols = $k - $i_sy;
                } else {
                    $csymbols = 0;
                }
                $sy = $csymbols < 100 ? 0 : '';
                if ($param['cat'] == 'flags') {
                    $i_fl++;
                    $cflags = $i_fl;
                } else {
                    $cflags = 0;
                }
                $fl = $cflags < 100 ? 0 : '';
            }
            echo '<div class="panel-body pn table-responsive">
   <div class="widget-menu pull-left mr5 text-center" style="margin: 8px;width: 100%;height: 100%;top: 0;left: 0;z-index: 2;">
      <div class="btn btn-sm dropdown-toggle">
         <a href ="' . ADMIN . '/smiles/smile_info/smile\" title="' . $lang['smile_smile'] . '"><img src="/media/smiles/smile/1f6031.png" style="width:36px; height: 36px;" alt="' . $lang['smile_smile'] . '"></a>
         <span class="badge badge-warning" style="padding: 5px 1px;">' . $s . $csmile . '</span>
      </div>
      <div class="btn btn-sm dropdown-toggle">
         <a href ="' . ADMIN . '/smiles/smile_info/people\" title="' . $lang['smile_people'] . '"><img src="/media/smiles/people/270c.png" style="width:36px; height: 36px;" alt="' . $lang['smile_people'] . '"></a>
         <span class="badge badge-warning" style="padding: 5px 1px;">' . $p . $cpeople . '</span>
      </div>
      <div class="btn btn-sm dropdown-toggle">
         <a href ="' . ADMIN . '/smiles/smile_info/animals\" title="' . $lang['smile_animals'] . '"><img src="/media/smiles/animals/1f43f.png" style="width:36px; height: 36px;" alt="' . $lang['smile_animals'] . '"></a>
         <span class="badge badge-warning" style="padding: 5px 1px;">' . $an . $canimals . '</span>
      </div>
      <div class="btn btn-sm dropdown-toggle">
         <a href ="' . ADMIN . '/smiles/smile_info/food\" title="' . $lang['smile_food'] . '"><img src="/media/smiles/food/1f32d.png" style="width:36px; height: 36px;" alt="' . $lang['smile_food'] . '"></a>
         <span class="badge badge-warning" style="padding: 5px 1px;">' . $fo . $cfood . '</span>
      </div>
      <div class="btn btn-sm dropdown-toggle">
         <a href ="' . ADMIN . '/smiles/smile_info/activities\" title="' . $lang['smile_activities'] . '"><img src="/media/smiles/activities/26bd.png" style="width:36px; height: 36px;" alt="' . $lang['smile_activities'] . '"></a>
         <span class="badge badge-warning" style="padding: 5px 1px;">' . $ac . $cactivities . '</span>
      </div>
      <div class="btn btn-sm dropdown-toggle">
         <a href ="' . ADMIN . '/smiles/smile_info/travel\" title="' . $lang['smile_travel'] . '"><img src="/media/smiles/travel/2708.png" style="width:36px; height: 36px;" alt="' . $lang['smile_travel'] . '"></a>
         <span class="badge badge-warning" style="padding: 5px 1px;">' . $tr . $ctravel . '</span>
      </div>
      <div class="btn btn-sm dropdown-toggle">
         <a href ="' . ADMIN . '/smiles/smile_info/objects\" title="' . $lang['smile_objects'] . '"><img src="/media/smiles/objects/1f380.png" style="width:36px; height: 36px;" alt="' . $lang['smile_objects'] . '"></a>
         <span class="badge badge-warning" style="padding: 5px 1px;">' . $ob . $cobjects . '</span>
      </div>
      <div class="btn btn-sm dropdown-toggle">
         <a href ="' . ADMIN . '/smiles/smile_info/symbols\" title="' . $lang['smile_symbols'] . '"><img src="/media/smiles/symbols/1f4b1.png" style="width:36px; height: 36px;" alt="' . $lang['smile_symbols'] . '"></a>
         <span class="badge badge-warning" style="padding: 5px 1px;">' . $sy . $csymbols . '</span>
      </div>
      <div class="btn btn-sm dropdown-toggle">
         <a href ="' . ADMIN . '/smiles/smile_info/flags\" title="' . $lang['smile_flags'] . '"><img src="/media/smiles/flags/1f3f3.png" style="width:36px; height: 36px;" alt="' . $lang['smile_flags'] . '"></a>
         <span class="badge badge-warning" style="padding: 5px 1px;">' . $fl . $cflags . '</span>
      </div>
   </div>
</div>';
        }
        break;
}
function smiles_add($sid = null): void
{
    global $adminTpl, $config, $smiles, $lang;
    fancyboxInit();
    $cats_smile = array('smile', 'people', 'animals', 'food', 'activities', 'travel', 'objects', 'symbols', 'flags');
    if (!isset($sid)) {
        $tags = '';
        $titles = '';
        $cats = '';
        $urls = '';
        $abridged = '';
        $file = '';
        $swurl = '';
        $_SESSION["RF"]["fff"] = 'media/smiles/';
        $admhead = $lang['smiles_add'];
        echo '<head>
   <script src=\'http://code.jquery.com/jquery-latest.js\'></script>
   <script src="https://code.angularjs.org/1.3.9/angular.min.js"></script>
   <script src="https://code.angularjs.org/1.3.9/angular-route.js"></script>
   <style type=\'text/css\'>
      #flags {
      display: none;
      }
   </style>
   <script type=\'text/javascript\'>
      $(function (){
      	$("#cat").change(function(){
      		var o=$("#flags");
      		if (this.value=="flags") {
      			o.show();
      		} else {
      			o.hide();
      		};
      	});
      });
   </script>
</head>';
    } else {
        foreach ($smiles as $tag => $param) {
            $swurl = str_replace(array($config['url'], '/', 'media', 'smiles', $param['cat'], '.png'), array('', '', '', '', '', ''), $param['url']);
            if ($sid == $swurl) {
                $tags = $tag;
                $titles = $param['title'];
                $cats = $param['cat'];
                $urls = $param['url'];
                $abridged = $param['abridged'];

            }
        }
        if (in_array($cats, $cats_smile)) $file = $cats;
        $_SESSION["RF"]["fff"] = 'media/smiles/' . $file . '/';
        $admhead = $lang['smiles_edit'];
    }
    $validation_array = array(
        'title' => array(
            'required' => array('true', $lang['add_descr_err']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
    );
    validationInit($validation_array);
    init_count_text();
    $adminTpl->admin_head($admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">';
    alert_info('smiles');
    echo '<div class="panel panel-dark panel-border top">
   <div class="panel-heading"><span class="panel-title">' . $admhead . '</span>
   </div>
   <div class="heading-hr"></div>
   <div class="panel-body admin-form">
      <form id="admin-form" class="form-horizontal parsley-form" role="form" action="{ADMIN}/smiles/save" method="post"	data-parsley-validate>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['smile_tag'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <label for="0" class="field prepend-icon">
               <input id="tag" name="tag" type="text" value="' . $tags . '" placeholder="' . $lang['smile_name_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
               <label for="tag" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
         </div>
         <div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['smile_cat'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <label class="field select mb15">
               <select id="cat" name="cat" class="form-control"  onchange="getSmileIcon(gid(\'cat\').value, \'url_smiles\');">
               <option value="" ' . ($cats == '' ? ' selected' : '') . '>' . $lang['choose_smile_cat'] . '</option>
               <option value="smile" ' . ($cats == 'smile' ? ' selected' : '') . '>' . $lang['smile_smile'] . '</option>
               <option value="people" ' . ($cats == 'people' ? ' selected' : '') . '>' . $lang['smile_people'] . '</option>
               <option value="animals" ' . ($cats == 'animals' ? ' selected' : '') . '>' . $lang['smile_animals'] . '</option>
               <option value="food" ' . ($cats == 'food' ? ' selected' : '') . '>' . $lang['smile_food'] . '</option>
               <option value="activities" ' . ($cats == 'activities' ? ' selected' : '') . '>' . $lang['smile_activities'] . '</option>
               <option value="travel" ' . ($cats == 'travel' ? ' selected' : '') . '>' . $lang['smile_travel'] . '</option>
               <option value="objects" ' . ($cats == 'objects' ? ' selected' : '') . '>' . $lang['smile_objects'] . '</option>
               <option value="symbols" ' . ($cats == 'symbols' ? ' selected' : '') . '>' . $lang['smile_symbols'] . '</option>
               <option value="flags" ' . ($cats == 'flags' ? ' selected' : '') . '>' . $lang['smile_flags'] . '</option>
               </select>
               ' . faI('arrow double') . '
               </label>
            </div>
         </div>
           <div class="form-group">
              <label class="col-lg-3 col-sm-3 control-label">' . $lang['smile_desc'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="title" class="field prepend-icon">
                     <textarea id="title" name="title" onkeyup="count_down(this, \'title\', 200)" maxlength="200" placeholder="' . $lang['smile_descr_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $titles . '</textarea>
                     <label for="title" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                     </label>
                  <div style="text-align:right" class="text-right">
                      <span id="char_title"></span>
                  </div>
              </div>
           </div>
         <div class="form-group">
            <label for="url" class="col-lg-3 col-sm-3 control-label">' . $lang['smile_url'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <label for="url" class="field prepend-icon">
               <input id="url" type="text" name="url" value="' . $urls . '" placeholder="' . $lang['smile_url_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change" >
               <label for="url" class="field-icon">' . faI('fa-link', false, false, true) . '</label>
               </label>
            </div>
         </div>';
    if ($cats == 'flags') {
        echo '<div id="flags" class="form-group">
            <label for="abridged" class="col-lg-3 col-sm-3 control-label">' . $lang['smile_abridged'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <label for="abridged" class="field prepend-icon">
               <input id="abridged" name="abridged" type="text" value="' . $abridged . '"  placeholder="' . $lang['smile_abridged_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
               <label for="abridged" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
         </div>';
    }
    $icon = !$file ? 'holder.js/160x45' : $urls;
    echo '<div class="form-group">
            <label class="col-sm-3 control-label">' . $lang['smile_folder'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <div data-provides="fileupload" class="fileupload fileupload-new admin-form">
                  <div class="fileupload-preview thumbnail mb15">
                     <img src="' . $icon . '" class="br3" alt="holder" style="width:56px; height: 56px;" style="border:0" alt=""/>
                  </div>
                  <span class="button btn-system btn-file btn-block ph5 btn-sm btn-raised legitRipple">
                  <span class="fileupload-new">' . $lang['selected_file'] . '</span>
                  <input id="fbox" data-fancybox-type="iframe" href="usr/plugins/filemanager/dialog.php?type=images&field_id=url"></span>
               </div>
            </div>
         </div>
   </div>';
    echo '<div class="panel-footer">';
    if (isset($sid)) echo '<input type="hidden" name="edit" value="1"/>';
    echo '<button name="submit" type="submit" id="sub" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
   </div>
   </form>
</div>';
    $adminTpl->admin_foot();
}

function smile_cats_icon($cats, $lang_head): void
{
    global $adminTpl, $config, $smiles, $lang;
    init_count_text();
    $i = 0;
    $adminTpl->admin_head($lang_head);
    echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">
<div class="panel panel-border top">
   <div class="pl30 pr30">';
    init_Ajax_count('root', 'smiles', 'smiles_list', false, false, 'smiles_list');
    echo '</div>
</div>';
    $k = 0;
    foreach ($smiles as $tag => $param) {
        if ($param['cat'] == $cats) $k = $k + 1;
    }
    if ($k <> 0) {
        if ((isset($tag['cat']) <> $cats) > 0) {
            echo '<div class="tray tray-center">
<div class="panel panel-dark panel-border top">
   <div class="panel-heading">
      <span class="panel-title">' . $lang['smiles_list'] . ' (' . $k . '):</span>
   </div>
   <div class="heading-hr"></div>
   <div class="panel-body pn table-responsive">
      <form id="tablesForm" style="margin:0; padding:0" method="POST">
         <table class="table table-xs table-striped">
            <thead>
               <tr>
                  <th class="hidden-xs"><span class="pd-l-sm"></span>#</th>
                  <th></th>
                  <th class="col-md-7">' . $lang['titles'] . '</th>
                  <th class="col-md-3 text-center">' . $lang['url'] . '</th>
                  <th style="width: 60px">&nbsp;</th>
                  <th style="width: 60px">&nbsp;</th>
               </tr>
            </thead>
            <tbody>';
            foreach ($smiles as $tag => $param) {
                if ($param['cat'] == $cats) {
                    $saurl = str_replace($config['url'] . '/', '', $param['url']);
                    $abridged = $param['abridged'] ? ' ( ' . $param['abridged'] . ' )' : '';
                    $i++;
                    echo '<tr>
                          <td class="hidden-xs"><span class="pd-l-sm"></span>' . smile_id($i, $param['title']) . '</td>
                  <td>
                     <div class="media media-list"><a href="' . $param['url'] . '" target="_blank"><img  src="' . $param['url'] . '" width="36" height="36"' . toggle($param['title']) . ' style="border:0" alt="" onmouseover="this.width=50;this.height=50" onmouseout="this.width=36;this.height=36"/></a></div>
                  </td>
                  <td>
                     <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['tag'] . ': ' . trimtitle($tag, 20) . '</ol>
                     <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['cats'] . ': ' . $param['cat'] . '</ol>
                     <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['icon_desc'] . ': ' . $param['title'] . '</ol>
                  </td>
                  <td class="text-center"><a href="' . $param['url'] . '" target="_blank"' . toggle($saurl) . '>' . trimtitle($param['url'], 30) . '</a></td>
                  <td></td>
                  <td></td>
               </tr>';
                }
            }
            echo '</tbody>
         </table>
      </form>
      <div class="panel-footer-lines">
      </div>
   </div>
</div>
<div class="widget-menu pull-left mr5">';
        } else {
            $adminTpl->info($lang['list_empty'], 'empty', null, $lang['smiles_list'], $lang['smiles_add'], ADMIN . '/smiles/add');
        }
    } else {
        $adminTpl->info($lang['list_empty'], 'empty', null, $lang['smiles_list'], $lang['smiles_add'], ADMIN . '/smiles/add');
    }
    echo '</div>';
    $adminTpl->admin_foot();
}
