<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $admin_conf, $user, $lang;
switch ($url[2] ?? null) {
    default:
        global $adminTpl, $core, $db, $config, $lang;
        init_count_text();
        Scroll('panel_menu_user');
        require ROOT . 'etc/db.config.php';
        $resource = mysqli_connect($dbhost, $dbuser, $dbpass);
        if ($resource) {
            if (mysqli_select_db($resource, $dbname)) {
                @mysqli_query($resource, 'SET NAMES utf8');
                $query = 'SELECT ROUND((SUM(DATA_LENGTH)+SUM(INDEX_LENGTH))/1024/1024,2) AS size FROM information_schema.tables WHERE table_schema="' . $dbname . '"';
                $item = mysqli_fetch_array(mysqli_query($resource, $query));
                $dbsizes = $item['size'] . '-' . $lang['mb'];
                $MySQLVersion = mysqli_fetch_array(mysqli_query($resource, 'SELECT VERSION()'));
            }
        }
        $filesSize = formatfilesize(dirsize(ROOT . 'files/'));
        $dbSize = formatfilesize($dbsizes);
        $status = conColor($config['off'] == 1, $config['off'] == 0 ? $lang['online'] : $lang['offline']);
        $php = conColor(phpversion() < '7.0', phpversion());
        $mysql = conColor($MySQLVersion[0] < '5.5.3', $MySQLVersion[0]);
        $post_size = conColor(SubStr(ini_get('post_max_size'), 0, -1) < '8', SubStr(ini_get('post_max_size'), 0, -1));
        $filesize = conColor(SubStr(ini_get('upload_max_filesize'), 0, -1) < '8', SubStr(ini_get('upload_max_filesize'), 0, -1));
        $memory_size = conColor(SubStr(ini_get('memory_limit'), 0, -1) < '8', SubStr(ini_get('memory_limit'), 0, -1));
        $execution = conColor(ini_get('max_execution_time') < '30', ini_get('max_execution_time'));
        $register = conColor(ini_get('register_globals') == true, ini_get('register_globals') ? $lang['status_on'] : $lang['status_off']);
        $safe_mode = conColor(ini_get('safe_mode') == false, ini_get('safe_mode') ? $lang['status_on'] : $lang['status_off']);
        $mod_rewrite = function_exists('apache_get_modules') ? (array_search('mod_rewrite', apache_get_modules()) == false ? $lang['status_off'] : $lang['status_on']) : $lang['panel_not_status'];
        $mod_rew = conColor($mod_rewrite == false, $mod_rewrite);
        $magic_quotes = conColor(ini_get('magic_quotes_gpc') == false, ini_get('magic_quotes_gpc') ? $lang['status_on'] : $lang['status_off']);
        $size_post = ini_get('post_max_size');
        $max_filesize = ini_get('upload_max_filesize');
        $size_memory = ini_get('memory_limit');
        $ip = getRealIpAddr();
        $br = strtok($_SERVER['HTTP_USER_AGENT'], ' ');
        $os_version = @php_uname('s') . @php_uname('r');
        $adminTpl->admin_head($lang['system_statistic']);
        if (function_exists('gd_info')) {
            $array = gd_info();
            $gdinfo = '<div class="accordion-heading">
                             <span class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#more_gd" style="text-decoration: underline;">' . colorSpan('#009900', $lang['base_more']) . '</span>' . info_modal('more_gd') . '
                           </div>
                           <div id="more_gd" class="accordion-body collapse">
                                 <div class="panel-body">
                                    <div class="col-lg-9 col-md-9 col-sm-12">';
            foreach ($array as $key => $val) {
                $val = $val === true ? colorSpan('#009900', $lang['status_on']) : colorSpan('#FF0000', $lang['status_off']);
                $a_keys = array_keys($array);
                $index_key = array_search($key, $a_keys);
                $formatkey = mb_strtolower(strtr("" . (strtr("" . $key . "", "", "_")) . "", "-", "_"));
                $gdinfo .= '<br/>' . $key . ':&nbsp;' . $val . '&nbsp;' . info_modal('stats_' . $index_key) . '</a>';
                modal_form_text('stats_' . $index_key, $lang['info'], 'fa-info-circle', $lang['info_' . $formatkey], false, $lang['info_stats_' . $formatkey], false);
            }
            $gdinfo .= '</div>
                        </div>
                     </div>';
            modal_form_text('more_gd', $lang['info'], 'fa-info-circle', $lang['info_gd'], false, $lang['info_gd_desc'], false);
        } else {
            $gdinfo = $lang['info_not_defined'];
        }
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-info panel-border top">
         <div class="panel-heading">
            <span class="panel-title hidden-xs">' . $lang['stats_all'] . @date("d.m.y H:i") . '</span>
            <div class="widget-menu pull-right">
               <div class="btn-group btn-group-xs mt5 d-sm-flex">
                  <a href="#tab3" data-toggle="tab" aria-expanded="false" class="btn btn-gray btn-sm btn-raised legitRipple">' . $lang['system_statistic'] . '</a>
                  <a href="#tab2" data-toggle="tab" aria-expanded="false" class="btn btn-gray btn-sm btn-raised legitRipple">' . $lang['stat_server'] . '</a>
                  <a href="#tab1" data-toggle="tab" aria-expanded="true" class="btn btn-gray btn-sm btn-raised legitRipple">' . $lang['stat_for_you'] . '</a>
               </div>
            </div>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <div class="tab-content_editor">
               <div id="tab1" class="tab-pane pn table-responsive">
                  <table class="table table-sm">
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['for_ip'] . '</td>
                        <td class="col-lg-3 col-sm-3"> ' . $ip . ' </td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['browser'] . '</td>
                        <td class="col-lg-3 col-sm-3"> ' . $br . ' </td>
                     </tr>
                     <script>
                        var height=0; var width=0;
                        if (self.screen) {
                        width=screen.width
                        height=screen.height
                        }
                        else if (self.java) {
                        var jkit=java.awt.Toolkit.getDefaultToolkit();
                        var scrsize=jkit.getScreenSize();
                        width=scrsize.width;
                        height=scrsize.height;
                        }                        
                        if (width > 0 && height > 0) {
                        document.writeln(\'<tr><td>' . $lang['screen_resolution'] . '</td><td> \',width,\'x\',height)
                        } else {
                        document.writeln(\'' . $lang['unknown'] . '</tr>\')
                        }
                     </script>
                  </table>
               </div>
               <div id="tab2" class="tab-pane pn table-responsive">
                  <table class="table table-sm">
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['version'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . VERSION_ID . '<br/></td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_opsist'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . colorSpan('#00CC33', $os_version) . '<br/></td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_php'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $php . info_modal('stats_php') . '</td>
                     </tr>
                     ' . modal_form_text('stats_php', $lang['info'], 'fa-info-circle', $lang['info_stats_php'], false, $lang['info_stats_php_desc'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_mysql'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $mysql . info_modal('stats_mysql') . '</td>
                     </tr>
                     ' . modal_form_text('stats_mysql', $lang['info'], 'fa-info-circle', $lang['info_stats_mysql'], false, $lang['info_stats_mysql_desc'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_bdsize'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . colorSpan('#00CC33', $dbSize) . info_modal('stats_bdsize') . '</td>
                     </tr>
                     ' . modal_form_text('stats_bdsize', $lang['info'], 'fa-info-circle', $lang['info_stats_bdsize'], false, $lang['info_stats_bdsize_desc'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_time'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $execution . info_modal('stats_time') . '</td>
                     </tr>
                     ' . modal_form_text('stats_time', $lang['info'], 'fa-info-circle', $lang['info_stats_time'], false, $lang['info_stats_time_desc'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_reg_glob'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $register . info_modal('stats_reg_glob') . '</td>
                     ' . modal_form_text('stats_reg_glob', $lang['info'], 'fa-info-circle', $lang['info_fmust_on'], false, $lang['info_stats_reg_glob'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_mode'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $safe_mode . info_modal('stats_mode') . '</td>
                     </tr>
                     ' . modal_form_text('stats_mode', $lang['info'], 'fa-info-circle', $lang['info_fmust_off'], false, $lang['info_stats_mode'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_magic'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $magic_quotes . info_modal('stats_magic') . '</td>
                     </tr>
                     ' . modal_form_text('stats_magic', $lang['info'], 'fa-info-circle', $lang['info_fmust_off'], false, $lang['info_stats_magic'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">Module mod_rewrite</td>
                        <td class="col-lg-3 col-sm-3">' . $mod_rew . info_modal('stats_mode') . '</td>
                        </td>
                     </tr>
                     ' . modal_form_text('stats_mode', $lang['info'], 'fa-info-circle', $lang['info_fmust_off'], false, $lang['info_stats_mode'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stat_gd'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $gdinfo . ' </td>
                     </tr>
                  </table>
               </div>
               <div id="tab3" class="tab-pane pn table-responsive active">
                  <table class="table table-sm">
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_alladmin'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . cInfo('counter') . info_modal('stats_alladmin') . '
                        </td>
                     </tr>
                     ' . modal_form_delete('stats_alladmin', $lang['main_last_action'], $lang['stats_alladmin'], false, '<div id="last_action" class="scroll panel-scroller scroller-sm scroller-thick scroller-blue scroller-pn pn mt30"><div class="panel-heading">' . $lang['ajax_load'] . '<img src="usr/tpl/admin/images/loading.gif" style="border:0" width="75" height="50"/></div><script type="text/javascript">ajaxGet(\'' . ADMIN . '/ajax/last_action\', \'last_action\');</script></div>', false, '<button name="submit" type="submit" id="sub" onclick="ajaxSimple(\'index.php?url={ADMIN}/do/clearlogs\', \'clearlogs\')" class="btn bg-danger btn-sm btn-raised legitRipple">' . faSpan('fa-eraser', true, $lang['clear']) . '</button>') . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['site_status'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $status . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_allforums'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $core->sum_data('board_forums') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_allfposts'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $core->sum_data('board_posts') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_allnews'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $core->sum_data('news', 'active=1') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_mod'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $core->sum_data('news', 'active=2') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['publ_autor_deleted'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . colorSpan('red', $core->sum_data('news', 'active=3')) . '&emsp;<a href="{ADMIN}/module/news/users_news_delete">[' . $lang['last_publ_autor_deleted'] . ']</a>
                        </td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_allcats'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $core->sum_data('categories') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_allcontents'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $core->sum_data('content') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_complaint'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $core->sum_data('complaint') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_feedsend'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $core->sum_data('feedback') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_comments'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $core->sum_data('comments') . '&emsp;<a href="{ADMIN}/comments">[' . $lang['last_comment'] . ']</a>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_cmod'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $core->sum_data('comments', 'status=2') . '&emsp;<a href="{ADMIN}/moderation/com/comments">[' . $lang['mod_comment'] . ']</a>
                        </td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['cache_size'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . cInfo('cache_size') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_maxpost'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $size_post . info_modal('size_post') . '</td>
                     </tr>
                     ' . modal_form_text('size_post', $lang['info'], 'fa-info-circle', $lang['info_size_post'], false, $lang['info_size_post_desc'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_maxfile'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $max_filesize . info_modal('max_filesize') . '</td>
                     </tr>
                     ' . modal_form_text('max_filesize', $lang['info'], 'fa-info-circle', $lang['info_max_filesize'], false, $lang['info_max_filesize_desc'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_maxmemory'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . $size_memory . info_modal('size_memory') . '</td>
                     </tr>
                     ' . modal_form_text('size_memory', $lang['info'], 'fa-info-circle', $lang['info_size_memory'], false, $lang['info_size_memory_desc'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['stats_bild'] . '</td>
                        <td class="col-lg-3 col-sm-3">' . cInfo('files_size') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['free_size'] . '</td>
                           <td class="col-lg-3 col-sm-3">' . cInfo('dfs_size') . '</td>
                     </tr>
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['sqi'] . '</td>
                        <td class="col-lg-3 col-sm-3">
                           <div id="sqi">
                              <a href="javascript:void(0)" onclick="ajaxSimple(\'index.php?url={ADMIN}/do/sqi\', \'sqi\')">[ получить ]</a>' . info_modal('sqi') . '</td>
                        </div>
                     </tr>
                     ' . modal_form_text('sqi', $lang['info'], 'fa-info-circle', $lang['info_sqi'], false, $lang['info_sqi_desc'], false) . '
                     <tr>
                        <td class="col-lg-3 col-sm-3">' . $lang['alexa'] . '</td>
                        <td class="col-lg-3 col-sm-3">
                           <div id="alexrang">
                              <a href="javascript:void(0)" onclick="ajaxSimple(\'index.php?url={ADMIN}/do/alexrang\', \'alexrang\')">[ получить ]</a>' . info_modal('alexa') . ' </td>
                        </div>
                     </tr>
    ' . modal_form_text('alexa', $lang['info'], 'fa-info-circle', $lang['info_alexa'], false, $lang['info_alexa_desc'], false) . '
    </table>
               </div>
            </div>
         </div>
         <div class="panel-footer-lines"> ' . getServerCheck() . '</div>
      </div>
   </div>
     <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
         <form id="panel_menu_user" role="form" method="POST" action="">';
        init_Ajax_count('root', 'statistic', 'statistic', false, false, 'panel_menu_user');
        echo '</form>
   </aside>
</div>';
        $adminTpl->admin_foot();
        break;

    case 'ajax':
        global $adminTpl, $core, $url, $db;
        ajaxInit();
        $status = $url[1] == 'module' ? true : false;
        $type = $status ? $url[4] : $url[3];
        switch ($type) {
            case 'counter':
                echo $core->sum_data('logs');
                if ($core->sum_data('logs') > 0) echo '&emsp;<e id="clearlogs">
                          <a href="javascript:void(0)" onclick="ajaxSimple(\'index.php?url=' . ADMIN . '/do/clearlogs\', \'clearlogs\')">[' . $lang['clear'] . ' ]</a>
                        </e>';
                break;
            case 'cache_size':
                $cacheSize = formatfilesize(dirsize(ROOT . 'tmp/mysql') + dirsize(ROOT . 'tmp/cache'));
                echo $cacheSize;
                if ($cacheSize > 50) echo '&emsp; <e id="clearCache">
                          <a href="javascript:void(0)" onclick="ajaxSimple(\'index.php?url=' . ADMIN . '/do/clearCache\', \'clearCache\')">[' . $lang['cache_clear'] . ' ]</a>
                        </e>';
                break;
            case 'files_size':
                $filesSize = formatfilesize(dirsize(ROOT . 'files/'));
                echo $filesSize;
                break;
            case 'dfs_size':
                $dfs = @disk_free_space("/");
                $size_dfs = formatfilesize($dfs);
                echo $size_dfs;
                break;
            case 'panel_menu_user':
                $query = $core->select_data('counter_stat');
                if ($db->numRows($query) > 0) {
                    echo '<div style="padding-right: 1px !important; top: 170px; position: fixed; margin-bottom: 20px; border-width: 0;" class="form-group admin-form">
   <h4 class="text-left pl20 pt10">' . $lang['panel_menu_user'] . '</h4>
   <hr class="short">
   <div class="section mb5">
      <table class="table table-sm">
      <tr>
         <td class="col-lg-3 col-sm-3"> ' . $lang['reg_users'] . $core->sum_data('users') . ' </td>
      </tr>
      <tr>
         <td class="col-lg-3 col-sm-3"> ' . $lang['stats_banned'] . colorSpan('red', $core->sum_data('users', '`group`=5')) . '</td>
      </tr>';
                    foreach ($core->auth->groups_array as $gid => $groups) {
                        $color[$gid] = $groups['color'];
                        $gname[$gid] = $groups['name'];
                    }
                    $on = $core->select_data('online', false, false, 'o .*, p . nick', 'AS o LEFT JOIN ' . DB_PREFIX . '_users AS p ON(o . uid=p . id)');
                    while ($online = $db->getRow($on)) {
                        $onn[] = array($online['nick'], $online['ip'], $online['url'], $online['uid'], $online['group']);
                    }
                    if (!empty($onn)) {
                        $guests = 0;
                        foreach ($onn as $info) {
                            $group = $info[4];
                            if ($group == $user['guestGroup']) {
                                $guests++;
                            } elseif ($group != $user['botGroup']) {
                                $users[] = $info;
                            } elseif ($group == $user['botGroup']) {
                                $bots[] = $info;
                            }
                        }
                        if (!empty($users)) {
                            $nUs = count($users);
                            $perColU = ceil($nUs / 2);
                            echo '<table class="table table-sm">
      <tr>
         <td class="col-lg-3 col-sm-3"> ' . $lang['online_users_on'] . $perColU . ' </td>
      </tr>
      <table style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate;"
         <tr style="text-align:left">
            <td>';
                            $n = 0;
                            foreach ($users as $uInfo) {
                                $n++;
                                echo '<li class="text-left pl20"><a href="profile/' . $uInfo[0] . '" title="' . $uInfo[0] . '-' . $gname[$uInfo[4]] . '"> ' . colorSpan($color[$uInfo[4]], $uInfo[0]) . '</a></li>';
                                if ($n == $perColU) echo '</td><td>';
                            }
                            echo '</td>
         </tr>
      </table>';
                        } else {
                            echo $lang['online_user_empty'] . ' <br>';
                        }
                        if (!empty($bots)) {
                            $perColB = ceil(count($bots) / 2);
                            $b = 0;
                            echo '<table class="table table-sm">
      <tr>
         <td class="col-lg-3 col-sm-3"> ' . $lang['online_bot'] . $perColB . '</td>
      </tr>
      <table style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate;"
         <tr style="text-align:left">
            <td style="vertical-align: top;">';
                            foreach ($bots as $bInfo) {
                                $b++;
                                echo '<tr>
            <td class="col-lg-3 col-sm-3"><li class="text-left">' . SpiderDetect(false, $info[3]) . '</li></td>
         </tr>';
                                if ($b == $perColB) echo '</td><td style="vertical-align: top;">';
                            }
                            echo '</td>
         </tr>
      </table>';
                        }
                        echo '<table class="table table-sm">
         <tr>
            <td class="col-lg-3 col-sm-3"><li class="text-left">' . $lang['online_guest_on'] . $guests . ' </li></td>
         </tr>
      </table>';
                    }
                    $usr = $core->select_data('users', 'last_visit >= ' . (time() - 86400), 'last_visit DESC LIMIT 30');
                    if ($db->numRows($usr) > 0) {
                        echo '<table class="table table-sm">
         <tr>
            <td class="col-lg-3 col-sm-3"> ' . $lang['online_top_on'] . ' </td>
            <table style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate;"
               <tr style="text-align:left">
                  <td style="vertical-align: top;">';
                        $y = 0;
                        $perColY = ceil($db->numRows($usr) / 2);
                        while ($rows = $db->getRow($usr)) {
                            $y++;
                            echo '<li class="text-left pl20"><a href="profile/' . $rows['nick'] . '" title="' . $rows['nick'] . '-' . $gname[$rows['group']] . '"> ' . colorSpan($color[$rows['group']], $rows['nick']) . ' </a></li><br/>';
                            if ($y == $perColY) echo '</td><td style="vertical-align: top;">';
                        }
                        echo '</td>
               </tr>
            </table>';
                    }
                    echo '</table>
   </div>';
                } else {
                    $adminTpl->info($lang['counter_empty'], 'empty', null, $lang['counter_visits']);
                }
                break;
        }
        break;
}
function sums_data($db, $where)
{
    global $core;
    echo $core->sum_data($db, $where);
    return;
}

function cInfo($ajax_type, $choice = false)
{
    return '<script type="text/javascript">setInterval(function(){
                             $("#' . $ajax_type . '_").load(\'' . ADMIN . '/statistic/ajax/' . $ajax_type . '/' . $choice . '\', \'' . $ajax_type . '_\');
                              }, 5000);
                        </script>
                        <e id="' . $ajax_type . '_">
                           <script type="text/javascript">ajaxGet(\'' . ADMIN . '/statistic/ajax/' . $ajax_type . '/' . $choice . '\', \'' . $ajax_type . '_\');</script>
                        </e>';
}