<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $core, $db, $config, $url, $support_conf, $lang;
switch ($url[2] ?? null) {
    default:
        init_refresh(true, 60);
        init_count_text();
        Scroll('search');
        Clearform('search');
        $where = 'id <> 0';
        $order = '';
        $link = '';
        $links = '';
        $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
        $s_place = isset($_POST['s_place']) ? filter($_POST['s_place'], 'a') : '';
        $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
        $s_active = isset($_POST['s_active']);
        $s_search = isset($_POST['s_search']);
        if ($s_search) $s_search = $_POST['s_search'] == 1;
        if ($s_active) {
            if ($_POST['s_active'] == 1) {
                $where = 'status = 1';
            } else {
                $s_active = false;
                $where = 'status = 0';
            }
        } else {
            $s_active = true;
        }
        if (isset($url[2]) && $url[2] == 'order') {
            switch ($url[3]) {
                case 'abc':
                    $order .= 'place ASC';
                    break;
                case 'last':
                    $order .= 'date DESC';
                    break;
                case 'id':
                    $order .= 'id ASC';
                    break;
            }
        } else {
            $order .= 'date DESC';
        }
        if ($s_id) {
            $where .= "AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
        } else {
            $s_id = '';
        }
        if ($s_place) $where .= "AND `place` LIKE '%" . $db->safesql($s_place) . "%'";
        if ($s_title) $where .= "AND `title` LIKE '%" . $db->safesql($s_title) . "%'";
        $query = $core->select_data('support', $where, $order . ' LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['support_history']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('support');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['support_exp'] . '</span>
          ' . sort_head('root', 3, 'last') . ' 
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th class="col-md-2 text-center">' . $lang['support_date'] . '</th>
                        <th class="col-md-3 text-center">' . $lang['support_place'] . '</th>
                        <th class="col-md-4 text-center">' . $lang['support_title'] . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($support = $db->getRow($query)) {
                $status = jmycmsck('support_stats', false, '&date=' . $support['date'] . '&id=' . $support['id'] . '&title=' . htmlentities(urlencode($support['title'])));
                $answer = jmycmsck('support_answer', false, '&date=' . $support['date'] . '&&id=' . $support['id'] . '&title=' . htmlentities(urlencode($support['title'])));
                if ($status == 0) {
                    $core->upd_data('support', '`status` = 0 ,`answer` ="' . $answer . '"', 'id ="' . $support['id'] . '"');
                } elseif ($status == 1) {
                    $core->upd_data('support', '`status` = 1 ,`answer` ="' . $answer . '"', 'id ="' . $support['id'] . '"');
                    $link = '{ADMIN_LINK}/read/' . $support['id'];
                    $links = '<a href="{ADMIN_LINK}/read/' . $support['id'] . '">' . $lang['support_processed1'] . '</a>';
                } elseif ($status == 2) {
                    $core->upd_data('support', '`status` = 2 ,`answer` ="' . $answer . '"', 'id ="' . $support['id'] . '"');
                } elseif ($status == 3) {
                    $core->upd_data('support', 'status = 3', 'id ="' . $support['id'] . '"');
                }
                $title = $support['title'] ? trimtitle($support['title'], '30') : $lang['support_not_topic'];
                $place = $support['place'] ? trimtitle($support['place'], '50') : $lang['support_not_place'];
                $message = decoder('d', isset($support['message']) ? stripslashes($core->bbDecode(html2bb(parseBB($support['message'])))) : '');
                $message = str_replace(array('*-*', '*--*'), array('{%', '%}'), $message);
                $message = str_replace(array('tpl_root_folder'), array($lang['tpl_root_folder']), $message);
                $answers = decoder('d', isset($support['answer']) ? stripslashes($core->bbDecode(html2bb(parseBB($support['answer'])))) : '');
                $message = !str_contains($title, $lang['not_documentation']) ? str_replace(array($lang['support_places'], $lang['support_id_tag'], $lang['support_tags'], $lang['support_templ']), array('', '', '', ''), $message) : $message;
                if ($answers || $answers <> '') {
                    $answers = str_replace(array('[p]', '[/p]'), array('<p>', '</p>'), $answers);
                    $answer_info = '<p class="text-left">' . $lang['support_answer'] . '&emsp;
                        <pre><code>' . $answers . '</code></pre>
                        </p>';
                } else {
                    $answer_info = '';
                }
                echo '<td class="text-center hidden-xs"><span class="pd-l-sm"></span>' . $support['id'] . '</td>';
                init_Ajax_count('root', 'support', $support['id'], 'date', 'id=' . $support['id'], 'date');
                echo '<td class="text-center" data-toggle="tooltip" data-original-title="' . $support['place'] . '">' . $place . '</td>
                     <td class="text-center" data-toggle="tooltip" data-original-title="' . (($title != '') ? $title : $lang['no_topic']) . '">' . (($title != '') ? $title : colorSpan('red', $lang['no_topic'])) . '</td>
                     <td class="text-center" style="font-size: 14px">' . status_icon('support', $support['id'], 'support', false, $link) . '</td>';
                modal_form_delete($support['id'], $support['title'], $lang['support_delete_title'], 'support', $lang['support_delete_text'], '{ADMIN_LINK}/delete/' . $support['id']);
                modal_form_text('view' . $support['id'], $lang['info'], 'fa-desktop', $support['title'], '
                        <p class="text-left">' . $lang['support_date'] . ':&emsp; ' . formatDate($support['date'], true) . '</p>
                        <p class="text-left">' . $lang['support_place'] . ':&emsp; ' . $support['place'] . '</p>
                        <p class="text-left">' . $lang['support_title'] . ':&emsp; ' . $support['title'] . '</p>
                        <p class="text-left">' . $lang['support_message'] . ':&emsp;
                        <pre><code>' . $message . '</code></pre>
                        </p>
                        <p class="text-left">' . $lang['status'] . ':&emsp;' . status_icon('support', $support['id'], 'support', false, $link) . '</p>' . $answer_info, false, '<button name="submit" type="submit" id="sub" onclick="location.href = \'{ADMIN_LINK}/delete/' . $support['id'] . '\'" class="btn bg-danger btn-sm btn-raised legitRipple"><i class="fa fa-trash-o position-left fa-lg"></i>' . $lang['base_delete'] . '</button>');
                echo '</td>';
                init_checkbox('td', $support['id'], false, '<li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-view' . $support['id'] . '\')">' . faSpan('fa-television', true, $lang['view']) . '</a></li>
                              ' . (isset($support['reads']) ? '<li><a href="{ADMIN_LINK}/reads/' . $support['id'] . '" >' . faSpan('fa-envelope-o', true, $lang['support_reply']) . '</a></li>' : '') . '
                              ' . ($support['status'] == 0 ? ' <li><a href="{ADMIN_LINK}/again_send/' . $support['id'] . '" >' . faSpan('fa-envelope-o', true, $lang['support_again_send']) . '</a></li>' : '') . '
                              <li class="divider"></li>
                              <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $support['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                echo '</tr>';
            }
            echo '</tbody>';
            init_tfoot('<option value="Again_send">' . $lang['support_again_send'] . '</option>
                                 <option value="Delete">' . $lang['delete'] . '</option>');
            echo '</table>
            </form>
         </div>
      </div>';
            page_list('root', 'support', 'support');
            echo '</div>
<aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
			 <h4 class="pl20"> ' . $lang['quick_search'] . '</h4>
            <hr class="short">
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id ="s_id" type ="text" name ="s_id" placeholder ="' . $lang['support_id'] . '" class="form-control" value ="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon"> ' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label class="field select">
            <select id ="s_place" name ="s_place" class="form-control">
            <option value =""' . ($s_place == '' ? ' selected' : '') . ' > ' . $lang['support_location_pre'] . '</option>
            <option value ="' . $lang['support_admin_panel'] . '"' . ($s_place == 'admin_panel' ? ' selected' : '') . ' > ' . $lang['support_admin_panel'] . '</option>
            <option value ="' . $lang['support_users_part'] . '"' . ($s_place == 'users_part' ? ' selected' : '') . ' > ' . $lang['support_users_part'] . '</option>
            <option value ="' . $lang['support_templates'] . '"' . ($s_place == 'templates' ? ' selected' : '') . ' > ' . $lang['support_templates'] . '</option>
            </select>
                  ' . faI('arrow double') . '
                  </label>
               </div>
            <div class="section mb5">
               <label for="s_title" class="field prepend-icon">
               <input id ="s_title" type ="text" name ="s_title" placeholder ="' . $lang['support_title'] . '" class="form-control" value ="' . $s_title . '">
               <label for="s_title" class="field-icon"> ' . faI('fa - keyboard - o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10 m10">
               <label class="field option">
               <input type ="hidden" name ="s_active" value ="0">
               <input type ="checkbox" name ="s_active"' . ($s_active ? 'checked' : '') . ' value ="1"><span class="checkbox"></span> ' . $lang['response_received'] . '</label>
            </div>
             ' . init_sfoot(true, true) . '
         </div>
      </form>
   </aside>';
        } else {
            list_empty('root', 'support', 'url', $s_search, false, true, $s_search, true);
            $paths = ROOT . 'files/support/';
            $idir = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($paths, FilesystemIterator::SKIP_DOTS), RecursiveIteratorIterator::CHILD_FIRST);
            foreach ($idir as $v) {
                if ($v->isDir() and $v->isWritable()) {
                    $f = glob($idir->key() . '/*.*');
                    if (!isset($f)) rmdir($idir->key());
                }
            }
        }
        echo '</div>
</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'question':
        question_add();
        break;
    case 'reads':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        question_add($id);
        break;
    case 'again_send':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if ($id) {
            again_send($id);
            action_alert('root', 'success', 'support', false, 'sendok');
        } else {
            action_alert('root', 'danger', 'support', 'question', 'not_field');
        }
        break;
    case 'send':
        $id = intval($url[2]);
        $place = $url[3] ?? filter($_POST['place'], 'place');
        $title = isset($url[4]) ? $lang['not_documentation'] : filter($_POST['title'], 'title');
        $message = isset($url[5]) ? '' : filter($_POST['message'], 'message');
        $templates = $url[5] ?? '';
        $tid = $url[6] ?? '';
        $tag = $url[7] ?? '';
        $tags = str_replace(array('*-*', '*--*'), array('{%', '%}'), $tag);
        $splace = $url[4] ?? '';
        $message .= 'Расположение: ' . $splace . '<br/>';
        $message .= 'ИД тега: ' . $tid . '<br/>';
        $message .= 'Шаблон: ' . $templates . '<br/>';
        $message .= 'Тег: ' . $tags . '<br/>';
        $place = ($place == 'templates') ? $lang['support_templates'] : $place;
        $rows = $core->row_data('support', 'id ="' . $id . '"');
        list($sid) = $core->fetch_data('support', false, 'max(id)');
        if (!$sid) {
            $row = $core->row_data('support_num');
            $num = ($row['num'] + 1);
            if ($num) $core->upd_data('support_num', '`num` ="' . $num . '"');
            $id = $row['num'];
        } else {
            $id = $sid + 1;
            $core->upd_data('support_num', '`num` ="' . $id . '"');
        }
        if (isset($title) && !empty($message)) {
            jmycmsck('support', false, '&place=' . htmlentities(urlencode($place)) . '&title=' . htmlentities(urlencode($title)) . '&message=' . htmlentities(urlencode($message)) . '&uid=' . $id . '&sid=0');
            $core->ins_data('support', 'id,dir,version,place,title,message,answer,status,date,uid,sid,user_delete', 'NULL,"' . $_SERVER['HTTP_HOST'] . '","' . VERSION_ID . '","' . $place . '","' . $title . '","' . $message . '","",0,"' . time() . '","' . $core->auth->user_id . '",0,0');
            action_alert('root', 'success', 'support', false, 'sendok');
        } else {
            action_alert('root', 'danger', 'support', 'question', 'not_field');
        }
        break;

    case 'delete':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if ($id) {
            delete($id);
            action_alert('root', 'success', 'support');
        } else {
            action_alert('root', 'danger', 'support', false, 'unknown_error');
        }
        break;

    case 'read':
        init_count_text();
        $id = intval($url[3]);
        $query = $core->select_data('support', 'id ="' . $id . '"', 'id ="' . $id . '" LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['support_history']);
        if ($db->numRows($query) > 0) {
            while ($support = $db->getRow($query)) {
                $status = jmycmsck('support_stats', false, '&date=' . $support['date'] . '&id=' . $support['id'] . '&title=' . htmlentities(urlencode($support['title'])));
                $answer = jmycmsck('support_answer', false, '&date=' . $support['date'] . '&&id=' . $support['id'] . '&title=' . htmlentities(urlencode($support['title'])));
                $core->upd_data('support', '`status` ="' . $status . '" ,`answer` ="' . $answer . '"', 'id ="' . $support['id'] . '"');
                $title = $support['title'] ? trimtitle($support['title'], '30') : $lang['support_not_topic'];
                $place = $support['place'] ? trimtitle($support['place'], '50') : $lang['support_not_place'];
                $answers = decoder('d', isset($support['answer']) ? stripslashes($core->bbDecode(html2bb(parseBB($support['answer'])))) : '');
                $answers = str_replace(array('[p]', '[/p]'), array('<p>', '</p>'), $answers);
                echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-yellow panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['support_in_answer'] . '</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body">
            <p class="text-left">&emsp;' . $lang['support_place'] . ':&emsp; ' . $place . '</p>
            </br>
            <p class="text-left">&emsp;' . $lang['support_title'] . ':&emsp; ' . $title . '</p>
            <div class="panel-body">
               <hr class="short alt">
               <pre><code>' . $answers . '</code></pre>
            </div>
         </div>
         <div class="panel-footer">
            <button name="submit" type="submit" id="sub" onclick="location.href = \'{ADMIN_LINK}/reads/' . $support['id'] . '\'" class="btn bg-success btn-sm btn-raised legitRipple"><i class="fa fa-share-square-o position-left fa-lg"></i>' . $lang['support_reply'] . '</button>
            <button name="submit" type="submit" id="sub" onclick="location.href = \'{ADMIN_LINK}/delete/' . $support['id'] . '\'" class="btn bg-danger btn-sm btn-raised legitRipple"><i class="fa fa-trash-o position-left fa-lg"></i>' . $lang['delete'] . '</button>
         </div>
      </div>';
            }
            echo '</div>
</div>';
        } else {
            $adminTpl->info($lang['list_empty'], 'info', null, $lang['info']);
        }
        $adminTpl->admin_foot();
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'Again_send':
                    foreach ($_POST['checks'] as $id) {
                        again_send($id);
                        action_alert('root', 'success', 'support');
                    }
                    break;
                case 'Delete':
                    foreach ($_POST['checks'] as $id) {
                        delete($id);
                        action_alert('root', 'success', 'support');
                    }
                    break;

            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'support');
        }
        break;

    case 'ajax':
        case_ajax('support');
        break;
}
function question_add($id = null): void
{
    global $adminTpl, $core, $url, $lang;
    if (isset($id)) {
        $support = $core->row_data('support', 'id ="' . $id . '"');
        $title = $support['title'] ? trimtitle($support['title'], '30') : $lang['support_not_topic'];
        $place = '<option value="' . $support['place'] . '">' . $support['place'] . '</option>';
        $answers = $support['answer'] == '' ? $support['message'] : $support['answer'];
        $answers = decoder('d', isset($answers) ? stripslashes($core->bbDecode(html2bb(parseBB($answers)))) : '');
        $answers = str_replace(array('tpl_root_folder'), array($lang['tpl_root_folder']), $answers);
        $answers = !str_contains($title, $lang['not_documentation']) ? str_replace(array($lang['support_places'], $lang['support_id_tag'], $lang['support_tags'], $lang['support_templ']), array('', '', '', ''), $answers) : $answers;
        $answers = str_replace(array('[p]', '[/p]'), array('<p>', '</p>'), $answers);
        $dosubmit = $lang['support_reply'];
        $messages = '';
        $admhead = $lang['banners_add'];
    } else {
        $title = isset($url[3]) ? 'Отсутствует документация' : false;
        $splace = $url[3] ?? false;
        $place = '<option value=""' . ($splace == '' ? ' selected' : '') . '>' . $lang['support_location_pre'] . '</option>
                  <option value="' . $lang['support_admin_panel'] . '"' . ($splace == 'admin_panel' ? ' selected' : '') . '>' . $lang['support_admin_panel'] . '</option>
                  <option value="' . $lang['support_users_part'] . '"' . ($splace == 'users_part' ? ' selected' : '') . '>' . $lang['support_users_part'] . '</option>
                  <option value="' . $lang['support_templates'] . '"' . ($splace == 'templates' ? ' selected' : '') . '>' . $lang['support_templates'] . '</option>';
        $answers = '';
        $dosubmit = $lang['sendingmess'];
        $messages = $url[4] ?? false;
        $messages = str_replace(array('.', '*-*', '*--*'), array('/', '{%', '%}'), $messages);
        $admhead = $lang['support_exp'];
    }
    $validation_array = array(
        'title' => array(
            'required' => array('true', $lang['add_title_err']),
            'maxlength' => array(49, str_replace('[count]', '50', $lang['count_text_err_2']))
        ),
    );
    validationInit($validation_array);
    init_count_text();
    datetimepickerInit('startdate', 'date');
    datetimepickerInit('enddate', 'date');
    $adminTpl->js_code[] = '$("#max_views").spinner();$("#max_clicks").spinner();';
    $adminTpl->admin_head($admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
         <div class="panel panel-dark panel-border top">
            <div class="panel-heading">
              <span class="panel-title">' . $admhead . '</span>
            </div>
   <div class="heading-hr"></div>
     <div class="panel-body admin-form">
      <form id="admin-form" class="form-horizontal parsley-form" role="form" action="{ADMIN_LINK}/send" method="post">
         <div class="form-group">
               <label for="place" class="col-lg-3 col-sm-3 control-label">' . $lang['support_place'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                   <label for="place" class="field select mb15">
                   <select id="place" name="place" class="form-control select2-single">
                   ' . $place . '
                   </select>
                   ' . faI('arrow double') . '
               </label>
               </div>
            </div>
            <div class="form-group">
               <label for="title" class="col-lg-3 col-sm-3 control-label">' . $lang['support_title'] . '</label>
               <div class="col-lg-5 col-md-5 col-sm-8">
                  <label for="title" class="field prepend-icon">
                  <input id="title" type="text" name="title" value="' . $title . '" onkeyup="count_down(this, \'title\', 50)" maxlength="100" placeholder="' . $lang['support_titles'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                  <label for="title" class="field-icon"><i class="fa1 fa-pencil"></i></label>
                  </label>
                    <div style="text-align:right" class="text-right">
                       <span id="char_title"></span>
                    </div>
               </div>
            </div>';
    list($sid) = $core->fetch_data('support', false, 'max(id)');
    if (!$sid) {
        $rows = $core->row_data('support_num');
        $num = isset($rows['num']) ? $rows['num'] + 1 : false;
        if ($num) $core->upd_data('support_num', 'num ="' . $num . '"');
        $id = $rows['num'] ?? false;
    } else {
        $id = $sid + 1;
        $core->upd_data('support_num', 'num ="' . intval($id) . '"');
    }
    initDir('support', $id);
    echo '<div class="row">
  <div class="col-xs-12">
             <div class="tab-block mb25">
               <div class="panel-body">
                  <hr class="short alt">
                  <pre><code>' . $answers . '</code></pre>
               </div>
               <div class="tab-content_editor">
                  <div class="tab-pane active">
                     ' . adminArea('message', $messages, 5, 'textarea', 'onchange="caa(this);"', true) . '
                  </div>
               </div>
            </div>
            <span class="input-footer text-left">' . faI('fa-bell', false, $lang['support_no_answer'], true) . '</span>
         </div>
      </div>
       </div>
          </div>
   ' . init_dfoot(true, 'fa-floppy-o', 'save', 'system');
    if (isset($id)) {
        echo '<input type = "hidden" name = "edit" value = "1">
            <input type="hidden" name="edit_id" value="' . $id . '">';
    }
    echo '</form>
   </div>
</div>';
    $adminTpl->admin_foot();
}

function again_send($id): void
{
    global $core;
    $support = $core->row_data('support', 'id = "' . $id . '"');
    echo jmycmsck('support', false, ' & place = ' . htmlentities(urlencode($support['place'])) . ' & title = ' . htmlentities(urlencode($support['title'])) . ' & message = ' . htmlentities(urlencode($support['message'])) . ' & uid = ' . $id . ' & sid = 0');
}

function delete($id): void
{
    global $core;
    $rows = $core->row_data('support', 'id = "' . $id . '"');
    jmycmsck('support', false, ' & place = ' . htmlentities(urlencode($rows['place'])) . ' & title = ' . htmlentities(urlencode($rows['title'])) . ' & message = ' . htmlentities(urlencode($rows['message'])) . ' & uid = ' . $id . ' & status = 3 & uid = ' . $id . ' & sid = 1 & user_delete = ' . time());
    $core->del_data('support', 'id = "' . $id . '"');
    full_rmdir(ROOT . initDC('support', "", "", $id));
}