<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $url, $page, $admin_conf, $lang;
switch ($url[2] ?? null) {
    default:
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        $where = '';
        $order = '';
        $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
        $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
        $s_desc = isset($_POST['s_desc']) ? filter($_POST['s_desc'], 'a') : '';
        $s_active = isset($_POST['s_active']);
        $s_search = isset($_POST['s_search']);
        if ($s_search) $s_search = $_POST['s_search'] == 1;
        if ($s_active) {
            if ($_POST['s_active'] == 1) {
                $where = 'active = 1';
            } else {
                $s_active = false;
                $where = 'active = 0';
            }
        } else {
            $s_active = true;
        }
        if (isset($url[2]) && $url[2] == 'order') {
            switch ($url[3]) {
                case 'abc':
                    $order .= 'title ASC';
                    break;
                case 'date':
                    $order .= 'date DESC';
                    break;
                case 'id':
                    $order .= 'id ASC';
                    break;
            }
        } else {
            $order .= 'id DESC';
        }
        if ($s_id) {
            $where .= "AND `id` LIKE '%" . $db->safesql($s_id) . "%'";
        } else {
            $s_id = '';
        }
        if ($s_title) $where .= "AND `title` LIKE '%" . $db->safesql($s_title) . "%'";
        if ($s_desc) $where .= "AND `desc` LIKE '%" . $db->safesql($s_desc) . "%'";
        $query = $core->select_data('tagcode', $where, $order . ' LIMIT ' . limit_page());
        $adminTpl->admin_head($lang['tagcode']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('tagcode');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $lang['tagcode_list'] . ':</span>
         ' . sort_head('root', 3) . '             
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-8">' . $lang['titles'] . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($row = $db->getRow($query)) {
                $tags = str_replace(array('<br>', '<br/>', '\p', '\n', '<', '>'), array('\n', '\n', '""', '""', '&lt;', '&gt;'), '[' . $row['tag'] . '] {%' . $row['tag'] . '%} [/' . $row['tag'] . ']');
                $command = 'document.querySelector(\'#copy_' . $row['id'] . '\').select(); document.execCommand(\'copy\'); notif(\'primary\', \'' . $lang['info'] . '\', \'' . $lang['copy_success'] . '\');';
                echo '<tr>
                        <td class="hidden-xs"><span class="pd-l-sm"></span>' . $row['id'] . '</td>
                        <td>
                           <div class="media media-list text-right"></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $row['title'] . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto">' . $lang['tagcode_desc'] . ': ' . trimtitle($row['desc'], 50) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['date'] . ': ' . formatDate($row['date'], true) . ' </ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto"><p class="text-left" href="' . $row['id'] . '#copy" onclick="' . $command . '" title="' . $lang['tagcode_copy'] . $tags . '">
                           <textarea id="copy_' . $row['id'] . '" style="width: 400px; height: 40px; margin: 0; font-size: 14px;" class="form-control input-sm text-center" data-parsley-required="true" data-parsley-trigger="change">' . $tags . '</textarea>
                           </p></ol>
                        </td>
                        <td class="text-center">' . status_icon('tagcode', $row['id']) . '</td>';


                init_checkbox('td', $row['id'], false, '<li><a href="{ADMIN_LINK}/edit/' . $row['id'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#copy" onclick="' . $command . '">' . faSpan('fa-files-o', false, $lang['tagcode_copy']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/retivate/' . $row['id'] . '">' . faSpan('fa-power-off', true, (($row['active'] == 0) ? $lang['do_activation'] : $lang['do_deactivation'])) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $row['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                echo '</tr>';
                modal_form_delete($row['id'], $row['tag'], $lang['tagcode_del_desc'], 'tagcode', $lang['tagcode_del_text'], '{ADMIN_LINK}/delete/' . $row['id']);
            }
            echo '</tbody>';
            init_tfoot('<option value="Activate">' . $lang['do_activation'] . '</option>
                       <option value="deActivate">' . $lang['do_deactivation'] . '</option>
                       <option value="reActivate">' . $lang['do_reactivation'] . '</option>
                       <option value="Delete">' . $lang['delete'] . '</option>');
            echo '</table>            
            </form>
         </div>
      </div>';
            page_list('root', 'tagcode', 'tagcode');
            echo '</div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
            <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['tagcode_pre_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['titles'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['tagcode_pre_desc'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
          </div>
            <div class="section mb10 m10">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active"' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['tagcode_active'] . '</label>
            </div>
             ' . init_sfoot(true, true) . '
         </div>
      </form>
   </aside>';
        } else {
            list_empty('root', 'tagcode', 'url', $s_search, false, true, $s_search);
        }
        echo '</div>';
        $adminTpl->admin_foot();
        break;
    case 'save':
        $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
        $title = isset($_POST['title']) ? filter($_POST['title']) : '';
        $desc = isset($_POST['desc']) ? filter($_POST['desc']) : '';
        $find = array("<", ">");
        $replace = array("&lt;", "&gt;");
        $tag = $db->safesql(str_replace($find, $replace, $_POST['translit']));
        $active = isset($_POST['active']) ? 1 : 0;
        if ($title && $desc) {
            if (isset($_POST['edit'])) {
                $core->upd_data('tagcode', '`title` ="' . $db->safesql(processText($title)) . '", `desc` ="' . $db->safesql(processText($desc)) . '", `tag` ="' . $db->safesql(processText($tag)) . '", `active` ="' . $active . '", `date` ="' . time() . '"', 'id ="' . $id . '"');
                action_alert('root', 'success', 'tagcode', false, 'tagcode_edit_ok');
            } else {
                $core->ins_data('tagcode', 'id,uid,desc,title,active,tag,date', 'NULL,0,"' . $db->safesql(processText($desc)) . '","' . $db->safesql(processText($title)) . '","' . $active . '","' . $db->safesql(processText($tag)) . '","' . time() . '"');
                action_alert('root', 'success', 'tagcode', false, 'tagcode_add_ok');
            }
        } else {
            action_alert('root', 'danger', 'tagcode', 'add', 'not_field');
        }
        break;
    case 'add':
        add();
        break;
    case 'edit':
        $id = intval($url[3]);
        add($id);
        break;
    case 'delete':
        $id = intval($url[3]);
        if ($id) {
            deltagcode($id);
            action_alert('root', 'success', 'tagcode');
        } else {
            action_alert('root', 'danger', 'tagcode', false, 'unknown_error');
        }
        break;
    case 'retivate':
        $id = intval($url[3]);
        if (!empty($id)) {
            $rows = $core->row_data('tagcode', 'id ="' . $id . '"');
            $active = $rows['active'] == 0 ? 1 : 0;
            $core->upd_data('tagcode', 'active ="' . $active . '"', 'id ="' . $id . '"');
            action_alert('root', 'success', 'tagcode');
        } else {
            action_alert('root', 'danger', 'tagcode', false, 'unknown_error');
        }
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'Activate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('tagcode', 'active = 1', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'tagcode');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('tagcode', 'active = 0', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'tagcode');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('tagcode', 'active = NOT `active`', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'tagcode');
                    }
                    break;
                case 'Delete':
                    foreach ($_POST['checks'] as $id) {
                        deltagcode(intval($id));
                        action_alert('root', 'success', 'tagcode');
                    }
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'tagcode');
        }
}
function add($id = null): void
{
    global $adminTpl, $core, $lang;
    $rows = $core->row_data('tagcode', 'id ="' . $id . '"');
    if (isset($id)) {
        $admhead = $lang['tagcode_edit'];
        $title = $rows['title'];
        $tag = $rows['tag'];
        $tags = '<div class="form-group">
   <label class="col-sm-3 control-label">' . $lang['tagcode_tag'] . '</label>
   <div class="col-lg-5 col-md-5 col-sm-8">
      <label for="vars" class="field prepend-icon">
         <pre><code>[' . $rows['tag'] . '] {%' . $rows['tag'] . '%} [/' . $rows['tag'] . ']</code></pre>
      </label>
   </div>
</div>';
        $desc = $rows['desc'];
    } else {
        $admhead = $lang['tagcode_add'];
        $title = false;
        $tag = false;
        $tags = false;
        $desc = false;
    }
    $validation_array = array(
        'translit' => array(
            'required' => array('true', $lang['add_title_err']),
            'maxlength' => array(49, str_replace('[count]', '50', $lang['count_text_err_2']))
        ),
        'descr' => array(
            'required' => array('true', $lang['add_descr_err']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
    );
    validationInit($validation_array);
    init_count_text();
    $adminTpl->admin_head($admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">';
    alert_info('tagcode');
    echo '<div class="panel panel-dark panel-border top">
   <div class="panel-heading"><span class="panel-title">' . $admhead . '</span>
   </div>
   <div class="heading-hr"></div>
      <form class="form-horizontal parsley-form" role="form" action="{ADMIN_LINK}/save" method="post" data-parsley-validate>
               <div class="panel-body pn table-responsive">
            <div class="panel-body admin-form">
                     <div class="form-group">
                        <label for="title" class="col-lg-3 col-sm-3 control-label">' . $lang['title'] . '</label>
                        <div class="col-lg-5 col-md-5 col-sm-8">
                           <label for="title" class="field prepend-icon">
                           <input id="title" type="text" name="title" value="' . $title . '" onkeyup="getTranslit(gid(\'title\').value, \'translit\'),getTagcode(gid(\'title\').value, \'related_tag\'),count_down(this, \'title\', 50)" maxlength="50" placeholder="' . $lang['tagcode_title_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                           <input id="translit" type="hidden" name="translit" class="event-name form-control"  ' . (isset($id) ? '' : 'onchange="getTagcode(gid(\'title\').value, \'related_tag\');"') . '   value="' . $tag . '">
                           <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                           </label>
                           <div style="text-align:right" class="text-right">
                              <span id="char_title"></span>
                           </div>
                           <span id="related_tag"></span>
                           <span class="input-footer text-left">' . faI('fa-bell') . $lang['tagcode_title_alert'] . '</span>
                        </div>
                     </div>
         ' . $tags . '
        <div class="form-group">
                  <label for="desc" class="col-lg-3 col-sm-3 control-label">' . $lang['description'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="desc" class="field prepend-icon">
                     <textarea id="desc" name="desc" onkeyup="count_down(this, \'desc\', 200)" maxlength="200" placeholder="' . $lang['tagcode_desc_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $desc . '</textarea>
                     <label for="desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                     </label>
                  <div style="text-align:right" class="text-right">
                      <span id="char_desc"></span>
                  </div>
                   <span class="input-footer text-left">' . faI('fa-bell') . $lang['tagcode_desc_alert'] . '</span>
                  </div>
                  </div>
           <div class="form-group">
                  <div class="col-xs-6">
                  ' . scheckbox('active', (isset($rows['active']) && $rows['active'] == 1 ? 1 : ''), $lang['tagcode_on']) . '
                  </div>
               </div>
   </div>
   <div class="panel-footer">
   <button name="submit" type="submit" id="sub" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
   </div>';
    if (isset($id)) {
        echo '<input type="hidden" name="edit" value="1">
        <input type="hidden" name="id" value="' . $id . '">';
    }
    echo '</form>
</div>';
    $adminTpl->admin_foot();
}

function deltagcode($id): void
{
    global $core;
    $tagcode = $core->row_data('tagcode', 'id ="' . $id . '"');
    $core->del_data('tagcode', 'id ="' . $tagcode['id'] . '"');
}