<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $config, $url, $lang;
switch ($url[2] ?? null) {
    default:
        init_count_text();
        $adminTpl->admin_head($lang['tpl_tpls']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('templates');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">
            <span class="panel-title">' . $lang['tpl_upload_tpl'] . '</span>
         </div>
         <div class="heading-hr"></div>
         <br/>
         <div class="panel-heading">
            <span class="panel-title">' . $lang['tpl_upload_inf'] . '</span>
         </div>
         <div class="switcher-content">
            <form style="text-align:center" method="post" enctype="multipart/form-data" action="{ADMIN_LINK}/upload">
              <div class="panel-body admin-form">
                   <div class="form-group">
                         <label class="col-lg-3 col-sm-3 control-label">' . $lang['fm_upload'] . '</label>
                         <div class="col-lg-5 col-md-5 col-sm-8">
                           <label class="field prepend-icon file"><span ' . btn_class('primary button btn-rounded ph30') . '>' . $lang['select_file'] . '</span>
							<input type="file" name="tpl" onchange="document.getElementById(\'uploader2\').value = this.value;" class="gui-file">
							<input id="uploader2" type="text" placeholder="' . $lang['choose_file_pre'] . '" class="gui-input">
                           <label class="field-icon">' . faI('fa-upload', false, false, true) . '</label>
                           </label>
                           <div class="section mb10 pt15">
                              <input name="submit" type="submit" id="sub" ' . btn_class('system button btn-block ph5', true, true) . ' value="' . $lang['upload'] . '">
                           </div>
                        </div>
                     </div>
               </div>
            </form>
            <hr class="short alt">
         </div>';
        $ni = 0;
        foreach (glob(ROOT . 'usr/tpl/*') as $dir) {
            $_name = basename($dir);
            if (is_dir($dir) && $_name != 'admin' && $_name != 'default' && $_name != 'smartphone') {
                $ni++;
                if (($ni % 5 == 0) || ($ni == 1)) echo '<div class="panel-body pn table-responsive">';
                $stand = ($_name <> 'JMY_yellow') && ($_name <> 'JMY_white') && ($_name <> 'JMY_blue') && ($_name <> 'JMY_green') ? $lang['tpl_out'] : $lang['tpl_in'];
                $preview = file_exists('usr/tpl/' . $_name . '/preview.png') ? 'usr/tpl/' . $_name . '/preview.png' : 'usr/tpl/no_preview.png';
                echo '<div class="col-xs-12 col-sm-6 col-md-3">
               <div class="panel panel-' . ($config['tpl'] == $_name ? 'yellow' : 'success') . ' pricing-table-2 top">
                  <div class="panel-heading text-center">
                   <span class="panel-title">' . $_name . '</span>
                   </div>
               <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive pt20">
                     <div class="plan-price text-center">
                        <img src="' . $preview . '" alt="' . $_name . '"/><br><br>
                        <p>' . $stand . '</p>
                        <small>' . $lang['jmy_cms'] . '</small>
                     </div>
                     <ul class="plan-features text-center">
                        <li><a href="{ADMIN_LINK}/download/' . $_name . '">' . $lang['tpl_load'] . '</a></li>
                        <li><a href="{ADMIN_LINK}/delete/' . $_name . '">' . $lang['tpl_del'] . '</a></li>
                     </ul>
                  </div>
                  <div class="panel-footer text-center">
                     <button ' . ($config['tpl'] == $_name ? 'class="button btn btn-yellow btn-block ph40 btn-raised legitRipple" >' . $lang['choosed'] : 'class="button btn btn-success btn-block ph40 btn-raised legitRipple" onclick="location.href=\'{ADMIN}/templates/choose/' . $_name . '\';">' . $lang['choose']) . '</button>
                  </div>
               </div>
            </div>';
                if (($ni % 4 == 0)) echo '</div>';
            }
        }
        if (($ni % 4 != 0) && ($ni != 0)) {
            echo '</div>
      <div class="panel-footer-lines"></div>
   </div>';
        }
        $adminTpl->admin_foot();
        break;

    case 'edit_tpl':
        init_count_text();
        $adminTpl->admin_head($lang['tpl_edit']);
        echo '<div id="content" class="table-layout animated fadeIn">
      <div class="tray tray-center">';
        if (isset($url[2]) && $url[2] == 'edit_tpl') $adminTpl->alert('info', $lang['info'], $lang['hot_keys']);
        alert_info('templates/edit_tpl');
        foreach (glob(ROOT . 'usr/tpl/' . $config['tpl'] . '/*/*.tpl') as $inFile) {
            $name = explode('usr/tpl/' . $config['tpl'] . '/', $inFile);
            $name = $name[1];
            $subDir = explode('/', $name);
            $inDirs[$subDir[0]][] = $inFile;
        }
        $zeroDirs = glob(ROOT . 'usr/tpl/' . $config['tpl'] . '/*.tpl');
        $codem = 'CodeMirror.fromTextArea("_code", {height:"dynamic",parserfile: ["parsexml.js","parsecss.js","tokenizejavascript.js","parsejavascript.js","parsehtmlmixed.js"],stylesheet: ["' . PLUGINS . 'highlight_code/xmlcolors.css","' . PLUGINS . 'highlight_code/jscolors.css","' . PLUGINS . 'highlight_code/csscolors.css"], path:"' . PLUGINS . 'highlight_code/", lineNumbers: false});';
        $file = $url[2];
        $adminTpl->footIncludes[] = '<script src="' . PLUGINS . '/highlight_code/codemirror.js" type="text/javascript"></script>
         <script type="text/javascript">ajaxGetJS(\'' . ADMIN . '/templates/ajax/loadtpl/' . $file . '\', \'' . $codem . '\', \'_div\');</script>';
        $adminTpl->headerIncludes[] = '<link rel="stylesheet" type="text/css" href="' . $adminTpl->file_dir . 'assets/css/ui.fancytree.min.css">';
        $adminTpl->js_code[] = ' $("#tree5").fancytree({
         click: function(event, data)
         { // allow re-loads
         var node = data.node,
         orgEvent = data.originalEvent;
         if(node.data.href){
         ajaxGetJS(\'' . ADMIN . '/templates/ajax/loadtpl/\'+node.data.href, \'' . $codem . '\', \'_div\');
         }
         }
         });';
        echo '<div id="_div"></div>
      </div>
       <aside data-tray-height="match" class="panel tray-right tray-rescale tray320">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['cats'] . '</h4>
            <hr class="short">
         <div id="tree5" class="fancytree-radio">
            <ul id="treeData" style="display: none;">';
        $count_folder = 0;
        if (isset($inDirs)) {
            foreach ($inDirs as $catalog => $files) {
                $count_folder++;
                $count_files = 0;
                $_fold[$catalog] = $lang['tpl_fold_' . $catalog] ?? $catalog . '.tpl';
                echo '<li id="' . $count_folder . '" class="text-left folder">' . ($_fold[$catalog] ?? $catalog) . '<ul>';
                foreach ($files as $file) {
                    $count_files++;
                    $name = explode('/', $file);
                    $name = end($name);
                    $_a = explode('usr/tpl/' . $config['tpl'] . '/', $file);
                    $absolute = str_replace('/', '=', end($_a));
                    $abs = str_replace(array('.tpl'), array(''), ($name));
                    $absol = str_replace(array($name, '='), array('', ''), ($absolute));
                    $_names[$absolute] = $lang['tpl_name_' . $absol . '_' . $abs] ?? $name;
                    if (isset($url[3]) && ($url[3] == $absolute)) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("' . $count_folder . '.' . $count_files . '");';
                    echo '<li id="' . $count_folder . '.' . $count_files . '"class="text-left"><a href="' . $absolute . '">' . ($_names[$absolute] ?? $name) . '</a></li>';
                }
                echo '</ul>';
            }
        }
        $count_files = 0;
        foreach ($zeroDirs as $file) {
            $count_files++;
            $name = explode('usr/tpl/' . $config['tpl'] . '/', $file);
            $name = $name[1];
            $abs = str_replace(array('.tpl'), array(''), ($name));
            $_names[$name] = $lang['tpl_name_' . $abs] ?? $name;
            if (isset($url[3]) && ($url[3] == $name)) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("0.' . $count_files . '");';
            echo '<li id="0.' . $count_files . '"class="text-left"><a href="' . $name . '">' . ($_names[$name] ?? $name) . '</a></li>';
        }
        echo '</ul>
      </aside>
      </div>
   </div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'edit_css':
        init_count_text();
        $adminTpl->admin_head($lang['tpl_edit_css']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        if (isset($url[2]) && $url[2] == 'edit_css') $adminTpl->alert('info', $lang['info'], $lang['hot_keys']);
        alert_info('templates/edit_css');
        foreach (glob(ROOT . 'usr/tpl/' . $config['tpl'] . '/*/*/*.css') as $inFile) {
            $name = explode('usr/tpl/' . $config['tpl'] . '/', $inFile);
            $name = $name[1];
            $subDir = explode('/', $name);
            $inDirs[$subDir[0]][] = $inFile;
        }
        $zeroDirs = glob(ROOT . 'usr/tpl/' . $config['tpl'] . '/*.css');
        $codem = 'CodeMirror.fromTextArea("_code", {height:"dynamic",parserfile: ["parsexml.js","parsecss.js","tokenizejavascript.js","parsejavascript.js","parsehtmlmixed.js"],stylesheet: ["' . PLUGINS . 'highlight_code/xmlcolors.css","' . PLUGINS . 'highlight_code/jscolors.css","' . PLUGINS . 'highlight_code/csscolors.css"], path:"' . PLUGINS . 'highlight_code/", lineNumbers: false});';
        $file = $url[2] ?? '';
        $adminTpl->footIncludes[] = '<script src="' . PLUGINS . '/highlight_code/codemirror.js" type="text/javascript"></script>
      <script type="text/javascript">ajaxGetJS(\'' . ADMIN . '/templates/ajax/loadcss/' . $file . '\', \'' . $codem . '\', \'_div\');</script>';
        $adminTpl->headerIncludes[] = '<link rel="stylesheet" type="text/css" href="' . $adminTpl->file_dir . 'assets/css/ui.fancytree.min.css">';
        $adminTpl->js_code[] = ' $("#tree5").fancytree({
      click: function(event, data)
      { // allow re-loads
      var node = data.node,
      orgEvent = data.originalEvent;
      if(node.data.href){
      ajaxGetJS(\'' . ADMIN . '/templates/ajax/loadcss/\'+node.data.href, \'' . $codem . '\', \'_div\');
      }
      }
      });';
        echo '<div id="_div"></div>
   </div>
   <aside data-tray-height="match" class="panel tray-right tray-rescale tray320">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10";>' . $lang['tpl_no_css'] . '</h4>
            <hr class="short">
      <div id="tree5" class="fancytree-radio">
         <ul id="treeData" style="display: none;">';
        $count_folder = 0;
        if (isset($inDirs)) {
            foreach ($inDirs as $catalog => $files) {
                $count_folder++;
                $count_files = 0;
                $_fold[$catalog] = $lang['tpl_fold_' . $catalog] ?? $catalog;
                echo '<li id="' . $count_folder . '" class="text-left folder">' . ($_fold[$catalog] ?? $catalog) . '<ul>';
                foreach ($files as $file) {
                    $count_files++;
                    $name = explode('/', $file);
                    $name = end($name);
                    $_a = explode('usr/tpl/' . $config['tpl'] . '/', $file);
                    $absolute = str_replace(array('/', '.css'), array('=', '_css'), end($_a));
                    if (isset($url[3]) && ($url[3] == $absolute)) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("' . $count_folder . '.' . $count_files . '");';
                    echo '<li id="' . $count_folder . '.' . $count_files . '" class="text-left"><a href="' . $absolute . '">' . ($_names[$absolute] ?? $name) . '</a></li>';
                }
                echo '</ul>';
            }
        }
        $count_files = 0;
        foreach ($zeroDirs as $file) {
            $count_files++;
            $name = explode('usr/tpl/' . $config['tpl'] . '/', $file);
            $name = $name[1];
            $abs = str_replace(array('.tpl'), array(''), ($name));
            $_names[$name] = $lang['tpl_name_' . $abs] ?? $name;
            if (isset($url[3]) && ($url[3] == $name)) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("0.' . $count_files . '");';
            echo '<li id="0.' . $count_files . '" class="text-left"><a href="' . $name . '">' . ($_names[$name] ?? $name) . '</a></li>';
        }
        echo '</ul>
   </aside>
   </div>
</div>
</div>';
        $adminTpl->admin_foot();
        break;

    case 'edit_js':
        init_count_text();
        $adminTpl->admin_head($lang['tpl_edit_js']);
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        if (isset($url[2]) && $url[2] == 'edit_js') $adminTpl->alert('info', $lang['info'], $lang['hot_keys']);
        alert_info('templates/edit_js');
        foreach (glob(ROOT . 'usr/tpl/' . $config['tpl'] . '/*/*/*.js') as $inFile) {
            $name = explode('usr/tpl/' . $config['tpl'] . '/', $inFile);
            $name = $name[1];
            $subDir = explode('/', $name);
            $inDirs[$subDir[0]][] = $inFile;
        }
        $zeroDirs = glob(ROOT . 'usr/tpl/' . $config['tpl'] . '/*.js');
        $codem = 'CodeMirror.fromTextArea("_code", {height:"dynamic",parserfile: ["parsexml.js","parsecss.js","tokenizejavascript.js","parsejavascript.js","parsehtmlmixed.js"],stylesheet: ["' . PLUGINS . 'highlight_code/xmlcolors.css","' . PLUGINS . 'highlight_code/jscolors.css","' . PLUGINS . 'highlight_code/csscolors.css"], path:"' . PLUGINS . 'highlight_code/", lineNumbers: false});';
        $file = $url[2];
        $adminTpl->footIncludes[] = '<script src="' . PLUGINS . '/highlight_code/codemirror.js" type="text/javascript"></script>
      <script type="text/javascript">ajaxGetJS(\'' . ADMIN . '/templates/ajax/loadjs/' . $file . '\', \'' . $codem . '\', \'_div\');</script>';
        $adminTpl->headerIncludes[] = '<link rel="stylesheet" type="text/css" href="' . $adminTpl->file_dir . 'assets/css/ui.fancytree.min.css">';
        $adminTpl->js_code[] = ' $("#tree5").fancytree({
      click: function(event, data)
      { // allow re-loads
      var node = data.node,
      orgEvent = data.originalEvent;
      if(node.data.href){
      ajaxGetJS(\'' . ADMIN . '/templates/ajax/loadjs/\'+node.data.href, \'' . $codem . '\', \'_div\');
      }
      }
      });';
        echo '<div id="_div"></div>
   </div>
   <aside data-tray-height="match" class="panel tray-right tray-rescale tray320">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10";>' . $lang['tpl_no_js'] . '</h4>
            <hr class="short">
      <div id="tree5" class="fancytree-radio">
         <ul id="treeData" style="display: none;">';
        $count_folder = 0;
        if (isset($inDirs)) {
            foreach ($inDirs as $catalog => $files) {
                $count_folder++;
                $count_files = 0;
                $_fold[$catalog] = $lang['tpl_fold_' . $catalog] ?? $catalog . '.tpl';
                echo '<li id="' . $count_folder . '" class="text-left folder">' . ($_fold[$catalog] ?? $catalog) . '<ul>';
                foreach ($files as $file) {
                    $count_files++;
                    $name = explode('/', $file);
                    $name = end($name);
                    $_a = explode('usr/tpl/' . $config['tpl'] . '/', $file);
                    $absolute = str_replace(array('/', '.js'), array('=', '_js'), end($_a));
                    $abs = str_replace(array('.tpl'), array(''), ($name));
                    $_names[$name] = $lang['tpl_name_' . $abs] ?? $name;
                    if (isset($url[3]) && ($url[3] == $absolute)) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("' . $count_folder . '.' . $count_files . '");';
                    echo '<li id="' . $count_folder . '.' . $count_files . '" class="text-left"><a href="' . $absolute . '">' . ($_names[$absolute] ?? $name) . '</a></li>';
                }
                echo '</ul>';
            }
        }
        $count_files = 0;
        foreach ($zeroDirs as $file) {
            $count_files++;
            $name = explode('usr/tpl/' . $config['tpl'] . '/', $file);
            $name = $name[1];
            if (isset($url[3]) && ($url[3] == $name)) $adminTpl->js_code[] = '$("#tree5").fancytree("getTree").activateKey("0.' . $count_files . '");';
            echo '<li id="0.' . $count_files . '" class="text-left"><a href="' . $name . '">' . ($_names[$name] ?? $name) . '</a></li>';
        }
        echo '</ul>
   </aside>
   </div>
</div>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'save':
        foreach ($_POST as $path => $html) {
            if ($path) {
                if (eregStrt('usr/tpl/' . $config['tpl'], $path)) {
                    $file = str_replace('usr/tpl/' . $config['tpl'], '', $path);
                    if (is_writable(str_replace('_tpl', '.tpl', $path))) {
                        $fp = @fopen(str_replace('_tpl', '.tpl', $path), 'w');
                        fwrite($fp, stripslashes($html));
                        fclose($fp);
                        $save_is = true;
                    } elseif (is_writable('usr/tpl/' . $config['tpl'] . str_replace('_', '.', $file))) {
                        $fp = @fopen('usr/tpl/' . $config['tpl'] . str_replace('_', '.', $file), 'w');
                        fwrite($fp, stripslashes($html));
                        fclose($fp);
                        $save_is = true;
                    }
                }
                action_alert('root', 'success', 'templates', 'edit_tpl', 'tpl_info_5');
            } else {
                action_alert('root', 'danger', 'templates', 'edit_tpl', 'tpl_info_9');
            }
        }
        break;
    case 'savecss':
        foreach ($_POST as $path => $html) {
            if ($path) {
                if (eregStrt('usr/tpl/' . $config['tpl'], $path)) {
                    $file = str_replace(array('_css',), array('.css'), $path);
                    if (is_writable($file)) {
                        $fp = @fopen($file, 'w');
                        fwrite($fp, stripslashes($html));
                        fclose($fp);
                        $save_is = true;
                    }
                }
                action_alert('root', 'success', 'templates', 'edit_css', 'tpl_info_5');
            } else {
                action_alert('root', 'danger', 'templates', 'edit_css', 'tpl_info_9');
            }
        }
        break;
    case 'savejs':
        foreach ($_POST as $path => $html) {
            if ($path) {
                if (eregStrt('usr/tpl/' . $config['tpl'], $path)) {
                    $file = str_replace(array('_js',), array('.js'), $path);
                    if (is_writable($file)) {
                        $fp = @fopen($file, 'w');
                        fwrite($fp, stripslashes($html));
                        fclose($fp);
                        $save_is = true;
                    }
                }
                action_alert('root', 'success', 'templates', 'edit_js', 'tpl_info_5');
            } else {
                action_alert('root', 'danger', 'templates', 'edit_js', 'tpl_info_9');
            }
        }
        break;
    case 'download':
        $urll = $url[3] ?? '';
        $tpl_dir = ROOT . 'usr/tpl/' . $urll;
        if (is_dir($tpl_dir)) {
            require_once(ROOT . 'boot/sub_classes/pclzip.lib.php');
            $archive = new PclZip('_temp_archive.zip');
            $v_list = $archive->create($tpl_dir, PCLZIP_OPT_REMOVE_PATH, ROOT . 'usr/tpl/');
            if ($v_list == 0) die("Error :" . $archive->errorInfo(true));
            header('Content-type: application/zip');
            header('Content-Disposition: attachment; filename="' . $urll . '(JMY_CMS_TEMPLATES).zip"');
            print file_get_contents('_temp_archive.zip');
            @unlink('_temp_archive.zip');
            exit();
        }
        break;
    case 'upload':
        if (isset($_FILES['tpl'])) {
            require_once(ROOT . 'boot/sub_classes/pclzip.lib.php');
            $archive = new PclZip($_FILES['tpl']['tmp_name']);
            if (($v_result_list = $archive->extract(PCLZIP_OPT_PATH, ROOT . 'usr/tpl')) != 0) {
                $dir_root = explode('/', $v_result_list[0]['stored_filename']);
                if ($dir_root[0] != 'usr' && $dir_root[0] != 'tpl' && file_exists(ROOT . 'usr/tpl/' . $dir_root[0] . '/index.tpl')) {
                    action_alert('root', 'success', 'templates', false, 'tpl_info_3');
                } else {
                    full_rmdir(ROOT . 'usr/tpl/' . $dir_root[0]);
                    action_alert('root', 'danger', 'templates', false, 'tpl_info_4');
                }
            } else {
                action_alert('root', 'danger', 'templates', false, 'tpl_info_4');
            }
        } else {
            action_alert('root', 'danger', 'templates', false, 'tpl_info_4');
        }
        break;
    case 'delete':
        $tpl_dir = ROOT . 'usr/tpl/' . $url[3];
        if ($config['tpl'] != $url[3]) {
            full_rmdir($tpl_dir);
            action_alert('root', 'success', 'templates', false, 'tpl_info_0');
        } else {
            action_alert('root', 'danger', 'templates', false, 'tpl_info_1');
        }
        break;
    case 'choose':
        $urll = $url[3] ?? '';
        $tpl_dir = ROOT . 'usr/tpl/' . $urll;
        if (is_dir($tpl_dir)) {
            $file = ROOT . 'etc/global.config.php';
            $content = file_get_contents($file);
            $content = str_replace('$config[\'tpl\'] = "' . $config['tpl'] . '";', '$config[\'tpl\'] = "' . $urll . '";', $content);
            $fp = fopen($file, "wb");
            fwrite($fp, $content);
            fclose($fp);
            setcookie('theme', $urll, time(), '/');
            action_alert('root', 'success', 'templates', false, 'tpl_info_2');
        } else {
            action_alert('root', 'danger', 'templates', false, 'unknown_error');
        }
        break;
    case 'ajax':
        global $adminTpl, $db, $lang;
        ajaxInit();
        $type = $url[3];
        switch ($type) {
            case 'loadtpl':
                $file = (isset($url[4]) && file_exists('usr/tpl/' . $config['tpl'] . '/' . str_replace('=', '/', $url[4]))) ? str_replace('=', '/', $url[4]) : 'index.tpl';
                $text = htmlspecialchars(file_get_contents(ROOT . 'usr/tpl/' . $config['tpl'] . '/' . $file), ENT_QUOTES);
                $count_rows = count(explode("\n", $text)) * 20;
                echo '<form action="' . ADMIN . '/templates/save/' . str_replace('/', '=', $file) . '"	method="post" id="form" class="form" name="form">
   <div class="panel panel-dark panel-border top">
      <div class="panel-heading">
         <span class="panel-title">' . $lang['tpl_edit'] . ' (' . $file . ')</span>
      </div>
      <div class="heading-hr"></div>
      <div class="panel-body">
         <div class="_code">
            <textarea name="usr/tpl/' . $config['tpl'] . '/' . $file . '" class="textarea" id="_code">' . $text . '</textarea>
         </div>
      </div>
      <div class="panel-footer text-right">
         <button name="submit" type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
      </div>
   </div>
</form>';
                break;
            case 'loadcss':
                $file = (isset($url[4]) && file_exists('usr/tpl/' . $config['tpl'] . '/' . str_replace(array('=', '_css'), array('/', '.css'), $url[4]))) ? str_replace(array('=', '_css'), array('/', '.css'), $url[4]) : 'assest/css/engine.css';
                $text = htmlspecialchars(file_get_contents(ROOT . 'usr/tpl/' . $config['tpl'] . '/' . $file), ENT_QUOTES);
                $count_rows = count(explode("\n", $text)) * 20;
                echo '<form action="' . ADMIN . '/templates/savecss/' . str_replace(array('/', '.css'), array('=', '_css'), $file) . '"	method="post" id="form" class="form" name="form">
   <div class="panel panel-dark panel-border top">
      <div class="panel-heading">
         <span class="panel-title"><b>' . $lang['tpl_edit_css'] . ' (' . $file . ')</b></span>
      </div>
      <div class="heading-hr"></div>
      <div class="panel-body">
         <div class="_code">
            <textarea name="usr/tpl/' . $config['tpl'] . '/' . $file . '" class="textarea" id="_code">' . $text . '</textarea>
         </div>
      </div>
      <div class="panel-footer text-right">
         <button name="submit" type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
      </div>
   </div>
</form>';
                break;
            case 'loadjs':
                $file = (isset($url[4]) && file_exists('usr/tpl/' . $config['tpl'] . '/' . str_replace(array('=', '_js'), array('/', '.js'), $url[4]))) ? str_replace(array('=', '_js'), array('/', '.js'), $url[4]) : 'assest/js/jquery.js';
                $text = htmlspecialchars(file_get_contents(ROOT . 'usr/tpl/' . $config['tpl'] . '/' . $file), ENT_QUOTES);
                $count_rows = count(explode("\n", $text)) * 20;
                echo '<form action="' . ADMIN . '/templates/savejs/' . str_replace(array('/', '.js'), array('=', '_js'), $file) . '"	method="post" id="form" class="form" name="form">
   <div class="panel panel-dark panel-border top">
      <div class="panel-heading">
         <span class="panel-title"><b>Редактировать язык (' . $file . ')</b></span>
      </div>
      <div class="heading-hr"></div>
      <div class="panel-body">
         <div class="_code">
            <textarea name="usr/tpl/' . $config['tpl'] . '/' . $file . '" class="textarea" id="_code">' . $text . '</textarea>
         </div>
      </div>
      <div class="panel-footer text-right">
         <button name="submit" type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
      </div>
   </div>
</form>';
                break;

        }
}
