<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $config, $core, $url, $configs, $clear, $lang;
$flag = true;
$allfiles = array();
switch ($url[2] ?? null) {
    default:
        init_count_text();
        $version = VERSION_ID;
        $what_new = jmycmsck('what');
        $available = jmycmsck('index');
        $whatlink = jmycmsck('whatlink');
        $history = jmycmsck('history');
        $nextversion = jmycmsck('nextversion');
        $nowversion = jmycmsck('version');
        $what_link = jmycmsck('arrow', $lang['download_last_source']);
        $updates_whatnew = '<a href="' . $core->fullURL() . '#" class="active" onclick="modal_o(\'#modal-form-wn\')">' . $lang['updates_whatnew'] . '</a>';
        $version_history = '<a href="' . $core->fullURL() . '#" class="active" onclick="modal_o(\'#modal-form-wnv\')">' . $lang['history'] . '</a>';
        $license_agreement = '<a href="' . $core->fullURL() . '#" class="active" onclick="modal_o(\'#modal-form-l_t\')">' . $lang['license_agreement'] . '</a>';
        $url_agreement = file_get_contents_utf8($lang['jmycms'] . 'check/license.php?langs=_' . $config['lang']);
        $version_historys = jmycmsck('version_history');
        $demo = jmycmsck('demo');
        $straight = '<span class="ph5">|</span>';
        $nversion = $nowversion ?? '';
        $nnext = $nowversion ? $nextversion : '';
        $what_news = $nowversion ? $history : '';
        $wlink = $nowversion ? $whatlink : '';
        $wlinks = $nowversion ? $what_link : '';
        $link = $nowversion ? $lang['jmycms'] : '';
        $down_link = bbut($wlink, 'refresh', 'download_last_source');
        $udown_link = bbut($link, 'link', 'updates_manufacturer_site');
        $what_link = $nowversion ? '<a href="' . $wlink . '">' . $lang['download_last_source'] . '</a>' : $what_link;
        $ofsite = $lang['jmycms'];
        $adminTpl->admin_head($lang['updates']);
        init_Ajax_count('root', 'update', 'update', false, false, 'time_dat');
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        if (file_exists(ROOT . 'tmp/update/lock.update') && ($version <> $nextversion)) {
            if ($config['key'] == $demo) {
                $nversion = $version;
                $ln1 = $straight;
                $ln2 = $license_agreement;
                $ln3 = '';
                $title_lang = $lang['updates_demo'];
                $text_lang = $lang['updates_demo_text'];
                $what_link = '';
                $url_link = bbut($lang['jmycms'] . 'feedback', 'refresh', 'request_serial_number');
            } elseif ($nnext <> 'NULL') {
                if ($version > $nnext) {
                    $nversion = $version;
                    $ln1 = '';
                    $ln2 = '';
                    $ln3 = '';
                    $title_lang = $lang['errors'];
                    $text_lang = $lang['pirate_error'];
                    $what_link = '';
                    $url_link = bbut($lang['jmycms'] . 'feedback', 'key', 'request_serial_number');
                } else {
                    $nversion = $nnext;
                    $ln1 = $straight;
                    $ln2 = $updates_whatnew;
                    $ln3 = $version_history;
                    $title_lang = $lang['updates_avalible'];
                    $text_lang = $lang['updates_avalible_text'];
                    $url_link = bbut(ADMIN . '/update/process_backup', 'refresh', 'updates_start');
                }
            } else {
                $adminTpl->info($lang['updates_error_0'], 'error', null, $lang['error'], $lang['support'], ADMIN . '/support');
            }
        } else {
            $decoder = decoder('c', $version_historys);
            $encode = decoder('d', $decoder);
            $nversion = $version;
            $ln1 = $straight;
            $ln2 = $updates_whatnew;
            $ln3 = '<br/>' . $version_history;
            $title_lang = $lang['updates_no'];
            $text_lang = $lang['updates_no_text'];
            $what_link = '';
            $url_link = bbut(ADMIN . '/update/refresh', 'refresh', 'updates_refresh');
        }
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
   <div class="row box-section">
<div style="max-width: 625px" class="center-block mt70">
        <div class="panel-body pn table-responsive">
            <div class="col-xs-7 pln">
               <h2 class="text-dark mbn confirmation-header">
                  ' . faSpan('fa-check text-success', true, $lang['sversion'] . $nversion) . '
               </h2>
            </div>
            <div class="col-xs-5 text-right va-b">
               <div class="meta-links alt">
                  <a target="_blank" href="' . $ofsite . '">' . $lang['official'] . '</a>
                  ' . $ln1 . $ln2 . $ln3 . '
               </div>
               ' . $what_link . '
            </div>
         </div>
         <div class="panel mt15">
            <div class="panel panel-yellow panel-border top">
               <div class="panel-body pt30 p25 pb15">
                  <p class="lead">' . $title_lang . '</p>
                  <hr class="alt short mv25">
                  <p class="text-left mt20">' . $text_lang . '</p>
               </div>
               <div class="panel-footer">
                     ' . $url_link . '
                  </div>
            </div>
         </div>
      </div>';
        modal_form_delete('wn', false, $lang['updates_whatnew'], false, $what_news, false, $udown_link, false, 'fa-check', $lang['sversion'] . $nnext);
        modal_form_text('wnv', $lang['vhistory'], 'fa-history', false, $version_historys, false, $down_link);
        modal_form_text('l_t', $lang['license_agreement'], 'fa-id-card-o', false, $url_agreement, false, ($ln2 == $license_agreement ? '' : $license_agreement));
        echo '</div>
</div></div>';
        $adminTpl->admin_foot();
        break;
    case 'process_backup':
        init_count_text();
        $version = VERSION_ID;
        $nextversion = jmycmsck('nextversion');
        if ($version <> $nextversion) {
            $adminTpl->admin_head($lang['updates']);
            if (true) {
                if (makebackup()) $adminTpl->info($lang['updates_backup'], 'info', null, $lang['info']);
                echo jmycmsck('stats');
            } else {
                $adminTpl->info($lang['updates_error_1'], 'error', null, $lang['error'], $lang['updates_again'], ADMIN . '/update');
            }
            $adminTpl->admin_foot();
        } else {
            header('Location: /' . ADMIN . '/update');
        }
        break;
    case 'process_run':
        init_count_text();
        $version = VERSION_ID;
        echo jmycmsck('stats');
        $nowversion = jmycmsck('version');
        $nextversion = jmycmsck('nextversion');
        $nnow = $nowversion ? $nextversion : '';
        $adminTpl->admin_head($lang['updates']);
        if ($version <> $nnow) {
            process_run($version);
            if ($flag) {
                $adminTpl->info($lang['updates_compl'], 'info', null, $lang['info']);
                echo '<script type="text/javascript">
   let i = 5;
   function time(){
       if (i >= 0) document.getElementById("time").innerHTML = i;
           i--;
       if (i === -1) location.href ="/' . ADMIN . '/update";
   }
   time();
   setInterval(time, 1000);
</script>';
                $file = file_get_contents_utf8(ROOT . '/define.php');
                $file = str_replace('define(\'MODE\', \'normal\');', 'define(\'CRMMODE\', \'' . ADMIN_TPL . '\');', $file);
                $file = str_replace('define(\'ADMIN_TPL\', \'usr/tpl/admin/\');', 'define(\'ADMIN_TPL\', \'' . ADMIN_TPL . '\');', $file);
//file_put_contents(ROOT . 'define.php', $file);
            } else {
                $adminTpl->info($lang['updates_error_0'], 'error', null, $lang['error'], $lang['support'], ADMIN . '/support');
            }
        } else {
            header('Location: /' . ADMIN . '/update');
        }
        $adminTpl->admin_foot();
        break;
    case 'refresh':
        time_dat();
        echo jmycmsck('what');
        header('Location: /' . ADMIN . '/update');
        break;
    case 'd_install':
        $file = 'install.php';
        $d_install = file_exists($file) ? unlink(ROOT . 'install.php') : '';
        header('Location: /' . ADMIN);
        return $d_install;
        break;
    case 'error':
        init_count_text();
        $adminTpl->admin_head($lang['updates']);
        $adminTpl->info($lang['updates_error_2'], 'error', null, $lang['error'], $lang['updates_again'], ADMIN . '/update');
        $adminTpl->admin_foot();
        break;
    case 'errorp':
        init_count_text();
        $adminTpl->admin_head($lang['updates']);
        $adminTpl->info($lang['updates_error_3'], 'error', null, $lang['error'], $lang['updates_again'], ADMIN . '/update');
        $adminTpl->admin_foot();
        break;
    case 'errord':
        init_count_text();
        $adminTpl->admin_head($lang['updates']);
        $adminTpl->info($lang['updates_error_4'], 'error', null, $lang['error'], $lang['updates_again'], ADMIN . '/update');
        $adminTpl->admin_foot();
        break;
    case 'ajax':
        global $adminTpl, $db, $config, $core, $configs, $clear, $lang;
        ajaxInit();
        $status = $url[1] == 'module';
        $type = $status ? $url[4] : $url[3];
        if ($type == 'time_dat') time_dat();
        break;
}
function process_run($version): void
{
    global $flag;
    $nextversion = jmycmsck('nextversion');
    $next_sl = str_replace('.', '_', $nextversion);
    $ntnext_url = jmycmsck('download_update');
    if ($version <> $nextversion) {
        set_time_limit(0);
        $curl = curl_init($ntnext_url);
        $fp = fopen('tmp/update/update_' . $next_sl . '.zip', 'w');
        curl_setopt($curl, CURLOPT_FILE, $fp);
        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_exec($curl);
        curl_close($curl);
        fflush($fp);
        fclose($fp);
        $file = ROOT . 'tmp/update/update_' . $next_sl . '.zip';
        $done = unzip_file($file, $_SERVER['DOCUMENT_ROOT'] . '/');
        if (is_string($done)) {
            $flag = false;
        } else {
            if (file_exists(ROOT . 'install/update.php')) {
                include(ROOT . 'install/update.php');
                unlink(ROOT . 'install/update.php');
            }
            unlink(ROOT . 'tmp/update/update_' . $next_sl . '.zip');
            unlink(ROOT . 'tmp/update/lock.update');
        }
    }
}

function makebackup()
{
    global $allfiles;
    require(ROOT . 'etc/db.config.php');
    set_time_limit(0);
    $db_names = array();
    $db_names[] = $dbname;
    $source_dirs = array();
    $source_dirs[] = $_SERVER['DOCUMENT_ROOT'];
    $url_var = explode('/', $_SERVER['DOCUMENT_ROOT']);
    $last_folder = end($url_var);
    $offset_dirs = strlen($last_folder);
    $dump_dir = ROOT . "tmp/backup/";
    $delay_delete = 35 * 24 * 3600;
    $filezip = "backup_" . date("Y-m-d") . ".zip";
    $db_files = array();
    for ($i = 0; $i < count($db_names); $i++) {
        $filename = $db_names[$i] . ".sql";
        $db_files[] = $dump_dir . "/" . $filename;
        $fp = fopen($dump_dir . "/" . $filename, "a");
        $db = new mysqli($dbhost, $dbuser, $dbpass, $db_names[$i]);
        $db->query("SET NAMES 'utf-8'");
        $result_set = $db->query("SHOW TABLES");
        while (($table = $result_set->fetch_assoc()) != false) {
            $table = array_values($table);
            if ($fp) {
                $result_set_table = $db->query("SHOW CREATE TABLE `" . $table[0] . "`");
                $query = $result_set_table->fetch_assoc();
                $query = array_values($query);
                fwrite($fp, "\n" . $query[1] . ";\n");
                $rows = "SELECT * FROM `" . $table[0] . "`";
                $result_set_rows = $db->query($rows);
                while (($row = $result_set_rows->fetch_assoc()) != false) {
                    $query = "";
                    foreach ($row as $field) {
                        if (is_null($field)) $field = "NULL";
                        else $field = "'" . $db->real_escape_string($field) . "'";
                        if ($query == "") $query = $field;
                        else $query .= "," . $field;
                    }
                    $query = "INSERT INTO `" . $table[0] . "` VALUES (" . $query . ");";
                    fwrite($fp, $query);
                }
            }
        }
        fclose($fp);
        $db->close();
    }
    $zip = new ZipArchive();
    if ($zip->open($dump_dir . "/" . $filezip, ZipArchive::CREATE) === true) {
        for ($i = 0; $i < count($source_dirs); $i++) {
            if (is_dir($source_dirs[$i])) recoursiveDir($source_dirs[$i]);
            else $allfiles[] = $source_dirs[$i];
            foreach ($allfiles as $val) {
                $local = substr($val, $offset_dirs);
                $zip->addFile($val, $local);
            }
        }
        for ($i = 0; $i < count($db_files); $i++) {
            $local = substr($db_files[$i], strlen($dump_dir) + 1);
            $zip->addFile($db_files[$i], $local);
        }
        $zip->close();
        return true;
    }
    for ($i = 0; $i < count($db_files); $i++) unlink($db_files[$i]);
}

function recoursiveDir($dir): void
{
    global $allfiles;
    if ($files = glob($dir . "/{,.}*", GLOB_BRACE)) {
        foreach ($files as $file) {
            $b_name = basename($file);
            if (($b_name == ".") || ($b_name == "..")) continue;
            if (is_dir($file)) recoursiveDir($file);
            else $allfiles[] = $file;
        }
    }
}

function bbut($link, $fa, $text): string
{
    global $lang;
    return isset($link) ? '<div class="text-center"><button type="button" ' . btn_class('system', 'block', true) . ' onclick="location.href=\'' . $link . '\';">' . faI('fa-' . $fa, true, $lang[$text]) . '</button></div>' : '';
}