<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
loadConfig('user');
global $adminTpl, $admin_conf, $db, $core, $user, $config, $url, $smiles, $files_conf, $lang;
if ($config['plugin']) $plugin = new plugin;
$nav_page = $url[2] ?? '';
switch ($url[2] ?? null) {
    default:
        user_list();
        break;
    case 'user_activated':
    case 'user':
        user_list('activated');
        break;
    case 'user_not_activated':
        user_list('not_activated');
        break;
    case 'user_ban':
        user_list('ban_list');
        break;
    case 'action':
        $type = $_POST['act'];
        $nav_page = !empty($url[2]) ? $url[2] : '';
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'Activate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('users', 'active = 1', 'id ="' . $id . '"');
                        action_alert('root', 'success', 'user', 'activated');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id)
                        if (!empty($id)) {
                            $rows = $core->row_data('users', 'id = ' . $id);
                            $group = $rows['group'] == 5 ? 2 : 5;
                            delcache('userInfo_' . $id);
                            $core->upd_data('users', '`group` ="' . $group . '"', 'id ="' . $id . '"');
                            $core->ins_log(false, $lang['logs_change_status_users'], 1, false, false, $rows['nick']);
                        }
                    action_alert('root', 'success', 'user', 'activated');
                    break;
                case 'delete':
                    foreach ($_POST['checks'] as $id)
                        delete($id);
                    action_alert('root', 'success', 'user', 'activated');
                    break;
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'user', 'activated');
        }
        break;
    case 'edit':
        global $adminTpl, $db, $core, $lang;
        $usrConf = $user;
        $uid = intval($url[3]);
        $user_row = $core->row_data('users', 'id = ' . $uid);
        $forum = $core->row_data('board_users', 'uid = ' . $uid);
        Scroll('user_info');
        UniClass('selectList');
        init_count_text();
        $_groups = array();
        $adminTpl->admin_head($lang['users_edit']);
        echo '<div id="content" class="table-layout animated fadeIn">
  <div class="tray tray-center">';
        alert_info('users');
        echo '<div class="panel panel-dark panel-border top">
            <div class="panel-heading">
              <span class="panel-title">' . $lang['users_edit'] . '</span>
            </div>
         <div class="heading-hr"></div>
     <div class="panel-body admin-form">
               <form enctype="multipart/form-data" role="form" method="POST" id="admin-form" class="form-horizontal parsley-form" role="form" action="{ADMIN_LINK}/save" method="post">
                   ' . input_text('input', 'nick', $user_row['nick'], 'fa-pencil', 'users_edit_nick', 'users_edit_nick_pre') . '
                   ' . input_text('input', 'forumStatus', $forum['specStatus'], 'fa-comment-o', 'users_edit_forum', 'users_edit_forum_pre') . '
                   ' . input_text('input', 'surname', $user_row['surname'], 'fa-user', 'surname', 'users_edit_surname_pre', 40) . '
                   ' . input_text('input', 'name', $user_row['name'], 'fa-user', 'base_name', 'users_edit_name_pre', 40) . '
                   ' . input_text('input', 'ochestvo', $user_row['ochestvo'], 'fa-user', 'ochestvo', 'users_edit_ochestvo_pre', 40) . '
                    <div class="form-group mt15 mb15">
					 <label class="col-lg-3 col-sm-3 control-label">' . $lang['group'] . '</label>
						<div class="col-xs-7">
						 <label class="field select">';
        echo '<select class="form-control" name="group" id="group">';
        $query = $core->select_data('groups', false, 'admin DESC,moderator DESC,user DESC,guest DESC,banned DESC');
        while ($rows = $db->getRow($query)) {
            $_groups[$rows['special']][] = $rows;
        }
        foreach ($_groups[0] as $r) {
            $selected = ($r['id'] == $user_row['group']) ? "selected" : "";
            echo '<option value="' . $r['id'] . '"' . $selected . '>' . Glang($r['name']) . '</option>';
        }
        echo '</select>
                       ' . faI('arrow double') . '
                           </label>
                        </div>
					</div>
                    <div class="form-group mt15 mb15">
					<label class="col-lg-3 col-sm-3 control-label">' . $lang['group_users_add_special'] . '</label>
						<div class="col-xs-7">
						<label class="field select">';
        echo '<select class="form-control" name="exgroup" id="exgroup"' . (empty($_groups[1]) ? 'disabled' : '') . '>' . (empty($_groups[1]) ? '<option value>' . $lang['users_edit_exgroup_empty'] . '</option>' : '<option value="0">' . $lang['no'] . '</option>');
        $_groups[1] = $_groups[1] ?? false;
        if (is_array($_groups[1]) || is_object($_groups[1])) {
            foreach ($_groups[1] as $g) {
                $selected2 = ($g['id'] == $user_row['exgroup']) ? "selected" : "";
                echo '<option value="' . $g['id'] . '"' . $selected2 . '>' . Glang($g['name']) . '</option>';
            }
        }
        echo '</select>
                       ' . faI('arrow double') . '
                           </label>
                        </div>
					</div>
					' . input_text('select', false, $user_row['birthday'], false, 'users_edit_birthday') . '
					' . input_text('textarea', 'hobby', $user_row['hobby'], 'fa-futbol-o', 'users_edit_hobby', 'users_edit_hobby_pre', 200) . '
					' . input_text('input', 'place', $user_row['place'], 'fa-map-marker', 'users_edit_place', 'users_edit_place_pre') . '
					' . input_text('select', 'gender', Gender($user_row['sex']), false, 'gender') . '
                    <div class="form-group mt15 mb15">
					 <label class="col-lg-3 col-sm-3 control-label"></label>
						<div class="col-lg-6 col-md-6 col-sm-9">
							<div data-provides="fileupload" class="fileupload fileupload-new admin-form">
								<div class="fileupload-preview thumbnail mb15">
								<img src="' . avatar($user_row['id']) . '" class="br4" alt="holder">
								</div>
								<span class="button btn-system btn-file btn-block ph5 btn-sm btn-raised legitRipple">
                                <span class="fileupload-new">' . $lang['users_add_avatar'] . '</span>
                                <span class="fileupload-exists">' . $lang['users_add_avatar_again'] . '</span>
                                <input type="file" name="avatar"></span>
							</div>
						</div>
					</div>
					' . input_text('checkbox', 'deleteAvatar', $user_row['deleteAvatar'], false, false, 'users_delete_avatar') . '
					' . input_text('input', 'avatar_link', $user_row['avatar_link'], 'fa-link', 'users_avatar_url', 'users_avatar_url_pre', 100) . '
                    <div class="form-group mt15 mb15">
					 <label class="col-lg-3 col-sm-3 control-label"></label>
						<div class="col-lg-6 col-md-6 col-sm-9">
							<div data-provides="fileupload" class="fileupload fileupload-new admin-form">
								<div class="fileupload-preview thumbnail mb15">
								<img src="' . pimage($user_row['id']) . '" class="br4" alt="holder"> </div> <span class="button btn-system btn-file btn-block ph5 btn-sm btn-raised legitRipple">
                                <span class="fileupload-new">' . $lang['users_add_pimage'] . '</span>
                                <span class="fileupload-exists">' . $lang['users_add_pimage_again'] . '</span>
                                <input type="file" name="pimage"></span>
							</div>
						</div>
					</div>
					' . input_text('checkbox', 'deletePimage', $user_row['deletePimage'], false, false, 'users_delete_pimage') . '
					' . input_text('input', 'pimage_link', $user_row['pimage_link'], 'fa-link', 'users_pimage_url', 'users_pimage_url_pre', 100) . '
					' . input_text('textarea', 'signature', $user_row['signature'], 'fa-comments', 'users_about', 'users_signature', 200, 'users_signature_tt') . '
					' . input_text('input', 'mail', $user_row['email'], 'fa-commenting-o', 'email', 'users_email_pre') . '
					' . input_text('input', 'icq', $user_row['icq'], 'fa-commenting-o', 'icq', 'users_icq_pre') . '
					' . input_text('input', 'skype', $user_row['skype'], 'fa-skype', 'skype', 'users_skype_pre') . '
					' . input_text('input', 'phone', $user_row['phone'], 'fa-phone', 'phone', 'users_phone_pre') . '
					' . input_text('input', 'newpass', false, 'fa-lock', 'new_password', 'users_newpass_pre', 100) . '
					' . input_text('checkbox', 'active', $user_row['active'], false, false, 'users_activated', false) . '
					' . input_text('checkbox', 'no_mail', $user_row['no_mail'], false, false, 'n_mail', false) . '
					' . input_text('checkbox', 'audio_alert', $user_row['audio_alert'], false, false, 'audio_alert', false) . '
					 <input name="uid" value="' . $uid . '" type="hidden">';
        $queryF = $core->select_data('xfields', 'module="profile" and to_user=1');
        if ($db->numRows($queryF) > 0) {
            $fields = unserialize($user_row['fields']);
            $xfileds = '<table style="width=:100%; border: 0; border-spacing: 1px; border-collapse: separate; margin-bottom:5px;" class="pad_table">
						<tr style="background-color : #ffffff;">
							<th colspan="3" class="in_conf_title">' . $lang['xfields'] . '</th>
						</tr>';
            while ($xfield = $db->getRow($queryF)) {
                if ($xfield['type'] == 3) {
                    $dxfield = array_map('trim', explode("\n", $xfield['content']));
                    $xfieldChange = '<select class="textinput" name="xfield[' . $xfield['id'] . ']">';
                    foreach ($dxfield as $xfiled_content) {
                        $xfieldChange .= '<option value="' . $xfiled_content . '"' . (isset($fields[$xfield['id']][1]) && $fields[$xfield['id']][1] == $xfiled_content ? 'selected' : '') . '>' . (!empty($fields[$xfield['id']][1]) ? $fields[$xfield['id']][1] : $xfield['content']) . '</option>';
                    }
                    $xfieldChange .= '</select>';
                } elseif ($xfield['type'] == 2) {
                    $xfieldChange = '<textarea class="textarea" name="xfield[' . $xfield['id'] . ']">' . (!empty($fields[$xfield['id']][1]) ? $fields[$xfield['id']][1] : $xfield['content']) . '</textarea>';
                } else {
                    $xfieldChange = '<input type="text" class="textinput" name="xfield[' . $xfield['id'] . ']" value="' . (!empty($fields[$xfield['id']][1]) ? $fields[$xfield['id']][1] : $xfield['content']) . '">';
                }
                $xfileds .= '<tr style="background-color : #ffffff;">
							<td class="in_conf_input" style="text-align:center">' . $xfield['title'] . '</td>
							<td class="in_conf_input"><input type="hidden" name="xfieldT[' . $xfield['id'] . ']" value="' . $xfield['title'] . '">' . $xfieldChange . '</select>
							</td>
						</tr>';
            }
            $xfileds .= '</table>';
            echo $xfileds;
        }
        echo '</div>
			<div class="form-group">
			<label class="col-lg-3 col-sm-3 control-label"></label>
				<div class="panel-footer">
				<button type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button> </div>
				</form>
			</div>
		</div>
	</div>
	<aside data-tray-height="match" class="panel tray tray-right tray350">
		<form id="user_info" role="form" method="POST" action="">
			<div class="admin-form">';
        UserCardInfo($user_row['id']);
        echo '</div>
          </div>
        </div>
     </form>
 </aside>
</div>';
        $adminTpl->admin_foot();
        break;
    case 'save':
        require ROOT . 'etc/user.config.php';
        $surname = !empty($_POST['surname']) ? filter($_POST['surname'], 'a') : '';
        $name = !empty($_POST['name']) ? filter($_POST['name'], 'a') : '';
        $nick = !empty($_POST['nick']) ? filter($_POST['nick'], 'nick') : '';
        $timezones = !empty($_POST['timezones']) ? filter($_POST['timezones'], 'timezones') : '';
        $ochestvo = !empty($_POST['ochestvo']) ? filter($_POST['ochestvo'], 'a') : '';
        $forumStatus = !empty($_POST['forumStatus']) ? filter($_POST['forumStatus'], 'a') : '';
        $birthDay = !empty($_POST['birthDay']) ? intval($_POST['birthDay']) : 0;
        $birthMonth = !empty($_POST['birthMonth']) ? intval($_POST['birthMonth']) : 0;
        $birthYear = !empty($_POST['birthYear']) ? intval($_POST['birthYear']) : 0;
        $bday_visibility = !empty($_POST['bday_visibility']) ? intval($_POST['bday_visibility']) : 0;
        $gender = !empty($_POST['gender']) ? intval($_POST['gender']) : 0;
        $active = (!empty($_POST['active']) && $_POST['active'] == 'on') ? 1 : 0;
        $no_mail = (!empty($_POST['no_mail']) && $_POST['no_mail'] == 'on') ? 1 : 0;
        $audio_alert = (!empty($_POST['audio_alert']) && $_POST['audio_alert'] == 'on') ? 1 : 0;
        $avatar_link = !empty($_POST['avatar_link']) ? filter($_POST['avatar_link'], 'url') : '';
        $signature = !empty($_POST['signature']) ? parseBB(processText(filter($_POST['signature'], 'bb'))) : '';
        $mail = !empty($_POST['mail']) ? filter($_POST['mail'], 'mail') : '';
        $hobby = !empty($_POST['hobby']) ? filter($_POST['hobby'], 'a') : '';
        $icq = !empty($_POST['icq']) ? filter($_POST['icq'], 'a') : '';
        $skype = !empty($_POST['skype']) ? filter($_POST['skype'], 'a') : '';
        $phone = !empty($_POST['phone']) ? filter($_POST['phone'], 'a') : '';
        $place = !empty($_POST['place']) ? filter($_POST['place'], 'a') : '';
        $newpass = !empty($_POST['newpass']) ? $_POST['newpass'] : '';
        $uid = !empty($_POST['uid']) ? intval($_POST['uid']) : 0;
        $group = !empty($_POST['group']) ? intval($_POST['group']) : 2;
        $exgroup = !empty($_POST['exgroup']) ? intval($_POST['exgroup']) : 0;
        $twofactor = !empty($_POST['twofactor']) ? intval($_POST['twofactor']) : 0;
        $key_pin = !empty($_POST['key_pin']) ? intval($_POST['key_pin']) : 0;
        $attempt = !empty($_POST['attempt']) ? intval($_POST['attempt']) : 0;
        $banned_time = !empty($_POST['banned_time']) ? intval($_POST['banned_time']) : 0;
        if ($birthDay && $birthMonth && $birthYear) {
            $birthDate = $birthDay . '.' . $birthMonth . '.' . $birthYear;
            $unixBirth = gmmktime(0, 0, 0, $birthMonth, $birthDay, $birthYear);
            $age = mb_substr((time() - $unixBirth) / 31536000, 0, 2);
        } else {
            $birthDate = '';
            $age = '';
        }
        if ($newpass) {
            $core->auth->updatePassword($newpass, $uid);
            if ($config['plugin']) $plugin->updatePassword($newpass, $uid);
        }
        $uid_nick = $core->sum_data('board_users', 'uid ="' . $uid . '"');
        if (!$uid_nick) $core->ins_data('board_users', 'uid,thanks,messages,specStatus,lastUpdate', '"' . $uid . '",0,0,0,0');
        $specStatus = !empty($forumStatus) ? $forumStatus : '';
        $core->upd_data('board_users', 'specStatus ="' . $specStatus . '"', 'uid ="' . $uid . '"');
        if ($mail && (!preg_match('/[a-zA-Z0-9_\.\-]+@[a-zA-Z0-9_\-]+\.[a-zA-Z0-9_\-\.]+$/i', $mail))) $mail = '';
        if (!empty($nick) && !empty($mail)) {
            $core->auth->updateProfile($mail, $timezones, $icq, $skype, $phone, $surname, $name, $no_mail, $audio_alert, $ochestvo, $place, $age, $gender, $birthDate, $hobby, $signature, '', $bday_visibility, $twofactor, $key_pin, $attempt, $banned_time, $uid, $group, $exgroup);
            if ($config['plugin']) $plugin->updateProfile($mail, $timezones, $icq, $skype, $phone, $surname, $name, $no_mail, $audio_alert, $ochestvo, $place, $age, $gender, $birthDate, $hobby, $signature, '', $bday_visibility, $twofactor, $key_pin, $attempt, $banned_time, $uid, $group, $exgroup);
            $core->ins_log(false, $lang['logs_edit_users'], 1, false, false, $nick);
            if ($_FILES['avatar']['size'] > 0) {
                deleteAvatar($uid);
                if ($foo = new Upload($_FILES['avatar'])) {
                    $foo->file_new_name_body = 'av' . $uid;
                    $foo->image_resize = true;
                    $foo->image_x = $user['avatar_width'];
                    $foo->image_ratio_y = true;
                    $foo->file_overwrite = true;
                    $foo->file_auto_rename = false;
                    $foo->Process(ROOT . 'files/avatars/users/');
                    $foo->allowed = array("image/*");
                    if ($foo->processed) $foo->Clean();
                }
            } elseif (!empty($avatar_link)) {
                deleteAvatar($uid);
                $format = explode(".", $avatar_link);
                $path = 'files/avatars/' . gencode(10) . '.' . array_pop($format);
                copy($avatar_link, $path);
                if ($foo = new Upload($path)) {
                    $foo->file_new_name_body = 'av' . $uid;
                    $foo->image_resize = true;
                    $foo->image_x = $user['avatar_width'];
                    $foo->image_ratio_y = true;
                    $foo->file_overwrite = true;
                    $foo->file_auto_rename = false;
                    $foo->Process(ROOT . 'files/avatars/users/');
                    $foo->allowed = array("image/*");
                    if ($foo->processed) $foo->Clean();
                }
            }
            if ($_FILES['pimage']['size'] > 0) {
                deletePimage($uid);
                if ($foo = new Upload($_FILES['pimage'])) {
                    $foo->file_new_name_body = 'pi' . $uid;
                    $foo->image_resize = true;
                    $foo->image_x = $user['pimage_width'];
                    $foo->image_ratio_y = true;
                    $foo->file_overwrite = true;
                    $foo->file_auto_rename = false;
                    $foo->Process(ROOT . 'files/avatars/profile_image/');
                    $foo->allowed = array("image/*");
                    if ($foo->processed) $foo->Clean();
                }
            } elseif (!empty($pimage_link)) {
                deletePimage($uid);
                $format = explode(".", $pimage_link);
                $path = 'files/avatars/profile_image/' . gencode(10) . '.' . array_pop($format);
                copy($pimage_link, $path);
                if ($foo = new Upload($path)) {
                    $foo->file_new_name_body = 'pi' . $uid;
                    $foo->image_resize = true;
                    $foo->image_x = $user['pimage_width'];
                    $foo->image_ratio_y = true;
                    $foo->file_overwrite = true;
                    $foo->file_auto_rename = false;
                    $foo->Process(ROOT . 'files/avatars/profile_image/');
                    $foo->allowed = array("image/*");
                    if ($foo->processed) $foo->Clean();
                }
            }
            if (isset($_POST['deleteAvatar'])) deleteAvatar($uid);
            if (isset($_POST['deletePimage'])) deletePimage($uid);
            action_alert('root', 'success', 'user', 'edit/' . $uid);
        } else {
            action_alert('root', 'danger', 'user', 'edit/' . $uid);
        }
        break;
    case 'letter':
        method_letter('root', 'users', 'user', $url[3]);
        break;
    case 'send_letter':
        method_send('root', 'users', $url[3], 'user', $admin_conf['user_mail'], '2', $_POST['message']);
        break;
    case 'regroup':
        global $lang;
        $id = intval($url[3]);
        list($name) = $core->fetch_data('users', 'id ="' . $id . '"', 'nick');
        delcache('userInfo_' . $id);
        $user = $core->row_data('users', 'id ="' . $id . '"');
        windowOpen();
        if (!isset($_POST['group'])) {
            echo '<form action="" method="post" enctype="multipart/form-data">';
            echo '<div style="text-align:center;"><select name="group" id="group" class="textinput">';
            $query = $core->select_data('groups', 'special=0', 'admin DESC,moderator DESC,user DESC,guest DESC,banned DESC');
            while ($rows = $db->getRow($query)) {
                $selected = ($rows['id'] == $user['group']) ? "selected" : "";
                if ($rows['id'] != 5) echo '<option value="' . $rows['id'] . '"' . $selected . '>' . Glang($rows['name']) . '</option>';
            }
            echo '</select><input value="Сменить группу" type="submit" size="11" maxlength="20" class="b">
                                       	   </div>
                                       	</form>';
        } else {
            $group = !empty($_POST['group']) ? intval($_POST['group']) : '';
            if ($id) {
                $core->upd_data('users', '`group` ="' . $group . '"', 'id ="' . $id . '"');
                $core->ins_log(false, $lang['logs_edit_users_regroup'], 1, false, false, $name['nick']);
                echo '<div style="text-align:center">' . colorSpan('green', $lang['group_successfully']) . '</div><script type="text/javascript">setTimeout(\'window.close()\', 3000)</script>';
            }
        }
        break;
    case 'repass':
        $id = intval($url[3]);
        $name = $core->sum_data('users', 'id ="' . $id . '"');
        $user = $core->row_data('users', 'id ="' . $id . '"');
        windowOpen();
        if (!isset($_POST['newpass'])) {
            echo '<form action="" method="post" enctype="multipart/form-data">';
            echo '<div style="text-align:center"> <input name="newpass" value="" class="textinput" type="text" size="11" maxlength="20"> <input value="Изменить пароль" type="submit" size="11" maxlength="20" class="b"></div></form>';
        } else {
            $newpass = !empty($_POST['newpass']) ? intval($_POST['newpass']) : '';
            if ($id) {
                $core->auth->updatePassword($newpass, $id);
                if ($config['plugin']) $plugin->updatePassword($newpass, $id);
                echo '<div style="text-align:center"><span style="color: green;"><b>' . $lang['password_successfully'] . '</b></span></div><script type="text/javascript">setTimeout(\'window.close()\', 3000)</script>';
            }
        }
        break;
    case 'delete':
        $id = intval($url[3]);
        delete($id);
        break;
    case 'retivate':
        $id = intval($url[3]);
        if (!empty($id)) {
            $rows = $core->row_data('users', 'id ="' . $id . '"');
            $active = $rows['active'] == 0 ? 1 : 0;
            $core->upd_data('users', 'active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_users'], 1, false, false, $rows['nick']);
        }
        location(ADMIN . '/user/activated');
        break;
    case 'ban':
        $id = intval($url[3]);
        if (!empty($id)) {
            $rows = $core->row_data('users', 'id ="' . $id . '"');
            $group = $rows['group'] == 5 ? 2 : 5;
            delcache('userInfo_' . $id);
            $core->upd_data('users', '`group` ="' . $group . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_add_users_ban'], 1, false, false, $rows['nick']);
        }
        location(ADMIN . '/user/activated');
        break;
    case 'addUsr':
        require ROOT . 'etc/user.config.php';
        $surname = !empty($_POST['surname']) ? filter($_POST['surname'], 'a') : '';
        $name = !empty($_POST['name']) ? filter($_POST['name'], 'a') : '';
        $nick = !empty($_POST['nick']) ? filter($_POST['nick'], 'nick') : '';
        $ochestvo = !empty($_POST['ochestvo']) ? filter($_POST['ochestvo'], 'a') : '';
        $pass = !empty($_POST['pass']) ? filter($_POST['pass'], 'a') : '';
        $mail = filter($_POST['mail'], 'mail');
        $phone = !empty($_POST['phone']) ? $_POST['phone'] : '';
        $group = intval($_POST['group']);
        $signature = !empty($_POST['signature']) ? filter($_POST['signature'], 'a') : '';
        $formatemail = str_replace(array('@', '.'), array('@', '.'), $mail);
        $validationlink = $config['url'] . '/profile/activate/' . $formatemail . '/' . mb_substr(md5($formatemail . 'eduard_laas_loh'), 0, 10);
        $check = $core->sum_data('users', 'nick ="' . $db->safesql($nick) . '" OR email ="' . $db->safesql($mail) . '"');
        if ($check > 0 && !empty($nick) && !empty($pass)) {
            action_alert('root', 'danger', 'user', 'activated', 'user_add_info_1');
        } else {
            $active = isset($_POST['activate']) ? 1 : 0;
            $mailsend = isset($_POST['mailsend']) ? 1 : 0;
            $tail = gencode(rand(6, 11));
            $core->auth->register($nick, $pass, $tail, $mail, "", "", $phone, $surname, $name, $ochestvo, "", "", "", "", $signature, '2', $active, '127.0.0.1');
            if ($config['plugin']) $plugin->registration($nick, $pass, $tail, $mail, "", "", $phone, $surname, $name, $ochestvo, "", "", "", "", $signature, '2', $active, '127.0.0.1');
            list($uid) = $core->fetch_data('users', 'nick ="' . $db->safesql($nick) . '"', 'id');
            $core->ins_data('board_users', 'uid,thanks,messages,specStatus,lastUpdate', '"' . $uid . '",0,0,0,0');
            $core->ins_log(false, $lang['logs_add_users'], 1, false, false, $nick);
            if ($mailsend == 1) {
                $query = $core->select_data('email', false, 'id ASC');
                while ($result = $db->getRow($query)) {
                    $message = $result['html_reg_mail'] > 0 ? str_replace(array('&lt;', '&gt;', '{%username%}', '{%date%}', '{%password%}', '{%validationlink%}', '{%url%}'), array('<', '>', $nick, formatDate(time(), true), $pass, $validationlink, $config['url']), $result['reg_mail_text']) : str_replace(array('\p', '\n', '\r', '<br>', '<br/>', '&nbsp;', '{%username%}', '{%date%}', '{%password%}', '{%validationlink%}', '{%url%}'), array('""', '""', '""', '\n', '\n', '\n', $nick, formatDate(time(), true), $pass, $validationlink, $config['url']), $result['reg_mail_text']);
                    if (!empty($mail)) {
                        mailSMTP($mail, $result['html_reg_mail'], $lang['reg_confirm'] . $config['name'], $message);
                    } else {
                        action_alert('root', 'danger', 'user', 'activated', 'user_add_info_3');
                    }
                }
                $mailsend = 0;
            }
            $UUID = $core->row_data('users', 'nick ="' . $db->safesql($nick) . '"');
            if ($_FILES['avatar']['size'] > 0) {
                if ($foo = new Upload($_FILES['avatar'])) {
                    $foo->file_new_name_body = 'av' . $UUID['id'];
                    $foo->image_resize = true;
                    $foo->image_x = $user['avatar_width'];
                    $foo->image_ratio_y = true;
                    $foo->file_overwrite = true;
                    $foo->file_auto_rename = false;
                    $foo->Process(ROOT . 'files/avatars/users/');
                    $foo->allowed = array("image/*");
                    if ($foo->processed) $foo->Clean();

                }
            }
            action_alert('root', 'success', 'user', 'activated', 'user_add_info_2');
        }
        break;
    case 'userexport':
        require ROOT . 'etc/global.config.php';
        $nick = isset($_POST['nick']) ? intval($_POST['nick']) : '';
        $name = isset($_POST['name']) ? intval($_POST['name']) : '';
        $mail = isset($_POST['mail']) ? intval($_POST['mail']) : '';
        $groups = isset($_POST['groups']) ? intval($_POST['groups']) : '';
        $reg_date = isset($_POST['reg_date']) ? intval($_POST['reg_date']) : '';
        $last_date = isset($_POST['last_date']) ? intval($_POST['last_date']) : '';
        $group = isset($_POST['group']) ? intval($_POST['group']) : '';
        $ttime = 'UNIX_TIMESTAMP(NOW())';
        $where = 'WHERE u.id != 0';
        if ($group && $group != 0) $where .= "AND u.`group` = '" . intval($group) . "'";
        if ($_POST['regstartdate']) {
            $regstartdate = isset($_POST['regstartdate']) ? filter($_POST['regstartdate'], 'regstartdate') : $ttime;
            if ($regstartdate != $ttime) {
                $parseDate = explode(' ', $regstartdate);
                $subDate = explode('.', $parseDate[0]);
                if (isset($parseDate[1])) {
                    $subTime = explode(':', $parseDate[1]);
                } else {
                    $subTime[0] = 12;
                    $subTime[1] = 0;
                }
                $regstartdate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            }
            $where .= "AND regdate>=' u.`" . $regstartdate . "`'";
        } else {
            $regstartdate = '';
        }
        if ($_POST['regenddate']) {
            $regenddate = isset($_POST['regenddate']) ? filter($_POST['regenddate'], 'regenddate') : $ttime;
            if ($regenddate != $ttime) {
                $parseDate = explode(' ', $regenddate);
                $subDate = explode('.', $parseDate[0]);
                if (isset($parseDate[1])) {
                    $subTime = explode(':', $parseDate[1]);
                } else {
                    $subTime[0] = 12;
                    $subTime[1] = 0;
                }
                $regenddate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            }
            $where .= "AND regdate>=' u.`" . $regenddate . "`'";
        } else {
            $regenddate = '';
        }
        if ($_POST['laststartdate']) {
            $laststartdate = isset($_POST['laststartdate']) ? filter($_POST['laststartdate'], 'laststartdate') : $ttime;
            if ($laststartdate != $ttime) {
                $parseDate = explode(' ', $laststartdate);
                $subDate = explode('.', $parseDate[0]);
                if (isset($parseDate[1])) {
                    $subTime = explode(':', $parseDate[1]);
                } else {
                    $subTime[0] = 12;
                    $subTime[1] = 0;
                }
                $laststartdate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            }
            $where .= "AND last_visit>=' u.`" . $laststartdate . "`'";
        } else {
            $laststartdate = '';
        }
        if ($_POST['lastenddate']) {
            $lastenddate = isset($_POST['lastenddate']) ? filter($_POST['lastenddate'], 'lastenddate') : $ttime;
            if ($lastenddate != $ttime) {
                $parseDate = explode(' ', $lastenddate);
                $subDate = explode('.', $parseDate[0]);
                if (isset($parseDate[1])) {
                    $subTime = explode(':', $parseDate[1]);
                } else {
                    $subTime[0] = 12;
                    $subTime[1] = 0;
                }
                $lastenddate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            }
            $where .= "AND last_visit>=' u.`" . $lastenddate . "`'";
        } else {
            $lastenddate = '';
        }
        $query = $core->select_data('users', $where, 'u.id DESC', 'u.*, g.name, (SELECT uid FROM ' . DB_PREFIX . '_online WHERE u.id=uid LIMIT 1) as online', 'as u LEFT JOIN ' . DB_PREFIX . '_groups as g on(u.group = g.id)');
        if ($_POST['format'] == "exel") {
            $output = '<Table><Row>';
            if ($nick) $output .= '<Cell ss:StyleID="bold"><Data ss:Type="String">' . $lang['user_nick'] . '</Data></Cell>';
            if ($name) $output .= '<Cell ss:StyleID="bold"><Data ss:Type="String">' . $lang['user_full_name'] . '</Data></Cell>';
            if ($mail) $output .= '<Cell ss:StyleID="bold"><Data ss:Type="String">' . $lang['user_email'] . '</Data></Cell>';
            if ($groups) $output .= '<Cell ss:StyleID="bold"><Data ss:Type="String">' . $lang['user_group'] . '</Data></Cell>';
            if ($reg_date) $output .= '<Cell ss:StyleID="bold"><Data ss:Type="String">' . $lang['users_date_reg'] . '</Data></Cell>';
            if ($last_date) $output .= '<Cell ss:StyleID="bold"><Data ss:Type="String">' . $lang['users_date_last'] . '</Data></Cell>';
            $output .= '</Row>';
            while ($rows = $db->getRow($query)) {
                $cells = '';
                $name = $core->row_data('users', 'id ="' . $rows['id'] . '"');
                $sname = !$name['surname'] && !$name['name'] && !$name['ochestvo'] ? $lang['unspecif'] : ($name['surname'] ? $name['surname'] : '') . '&nbsp;' . ($name['name'] ? $name['name'] : '') . '&nbsp;' . ($name['ochestvo'] ? $name['ochestvo'] : '');
                if ($nick) $cells .= '<Cell><Data ss:Type="String">' . $rows['nick'] . '</Data></Cell>';
                if ($name) $cells .= '<Cell><Data ss:Type="String">' . $sname . '</Data></Cell>';
                if ($mail) $cells .= '<Cell><Data ss:Type="String">' . $rows['email'] . '</Data></Cell>';
                if ($groups) $cells .= '<Cell><Data ss:Type="String">' . $rows['name'] . '</Data></Cell>';
                if ($reg_date) $cells .= '<Cell><Data ss:Type="String">' . decoder('d', formatDate($rows['regdate'], true)) . '</Data></Cell>';
                if ($last_date) $cells .= '<Cell><Data ss:Type="String">' . decoder('d', formatDate($rows['last_visit'], true)) . '</Data></Cell>';
                $output .= '<Row>' . $cells . '</Row>';
            }
            $output .= '</Table>';
            $output = '<?xml version="1.0" encoding="' . $config['charset'] . '"?>
<?mso-application progid="Excel.Sheet"?>
<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet" xmlns:html="http://www.w3.org/TR/REC-html40">
   <Styles>
      <Style ss:ID="bold">
         <Font ss:Bold="1"/>
      </Style>
   </Styles>
   <Worksheet ss:Name="users">
      ' . $output . '
   </Worksheet>
</Workbook>';
            header('Pragma: public');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Cache-Control: private', false);
            header('Content-Type: application/x-msexcel; charset=' . $config['charset']);
            header('Content - Disposition: attachment; filename ="users.xls"');
            header('Content-Transfer-Encoding: binary');
            header('Connection: close');
            print ($output);
        } elseif ($_POST['format'] == "txt") {
            header('Pragma: public');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Cache-Control: private', false);
            header('Content-Type: text/csv; charset=' . $config['charset']);
            header('Content-Disposition: attachment; filename="users.txt"');
            $output = fopen('php://output', 'w');
            fputs($output, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
            while ($rows = $db->getRow($query)) {
                $cells = array();
                $name = $core->row_data('users', 'id ="' . $rows['id'] . '"');
                $sname = !$name['surname'] && !$name['name'] && !$name['ochestvo'] ? $lang['unspecif'] : ($name['surname'] ?? '') . '&nbsp;' . ($name['name'] ?? '') . '&nbsp;' . ($name['ochestvo'] ?? '');
                if ($nick) $cells[] = $lang['user_nick'] . ' => ' . $rows['nick'];
                if ($name) $cells[] = $lang['user_full_name'] . ' => ' . $sname;
                if ($mail) $cells[] = $lang['user_email'] . ' => ' . $rows['email'];
                if ($groups) $cells[] = $lang['user_group'] . ' => ' . $rows['name'];
                if ($reg_date) $cells[] = $lang['users_date_reg'] . ' => ' . decoder('d', formatDate($rows['regdate'], true));
                if ($last_date) $cells[] = $lang['users_date_last'] . ' => ' . decoder('d', formatDate($rows['last_visit'], true));
                $cells[] = '';
                fputcsv($output, $cells, "\n");
            }
        } else {
            header('Pragma: public');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Cache-Control: private', false);
            header('Content-Type: text/csv; charset=' . $config['charset']);
            header('Content-Disposition: attachment; filename="users.csv"');
            $output = fopen('php://output', 'w');
            fputs($output, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
            $header_column = array();
            if ($nick) $header_column[] = $lang['user_nick'];
            if ($name) $header_column[] = $lang['user_full_name'];
            if ($mail) $header_column[] = $lang['user_email'];
            if ($groups) $header_column[] = $lang['user_group'];
            if ($reg_date) $header_column[] = $lang['users_date_reg'];
            if ($last_date) $header_column[] = $lang['users_date_last'];
            fputcsv($output, $header_column, ";");
            while ($rows = $db->getRow($query)) {
                $cells = array();
                $name = $core->row_data('users', 'id ="' . $rows['id'] . '"');
                $sname = !$name['surname'] && !$name['name'] && !$name['ochestvo'] ? $lang['unspecif'] : ($name['surname'] ?? '') . '&nbsp;' . ($name['name'] ?? '') . '&nbsp;' . ($name['ochestvo'] ?? '');
                if ($nick) $cells[] = $rows['nick'];
                if ($name) $cells[] = $sname;
                if ($mail) $cells[] = $rows['email'];
                if ($groups) $cells[] = $rows['name'];
                if ($reg_date) $cells[] = decoder('d', formatDate($rows['regdate'], true));
                if ($last_date) $cells[] = decoder('d', formatDate($rows['last_visit'], true));
                fputcsv($output, $cells, ";");
            }
        }
        break;
    case 'ajax':
        case_ajax('users');
        break;
}
function maxlength($id, $num): array
{
    global $lang;
    return array(
        $id => array(
            'maxlength' => array($num - 1, str_replace('[count]', $num, $lang['count_text_err_2']))
        ),
    );
}

function user_list($status = null): void
{
    global $adminTpl, $admin_conf, $db, $core, $config, $smiles, $url, $lang;
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    datetimepickerInit('s_regdate', 'date');
    datetimepickerInit('s_birthday', 'date');
    init_complexity_pass();
    $where = 'u.id != 0';
    $order = '';
    $sort = '';
    $titles = '';
    $nav_page = '';
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_nick = isset($_POST['s_nick']) ? filter($_POST['s_nick'], 'a') : '';
    $s_email = $_POST['s_email'] ?? '';
    $s_group = isset($_POST['s_group']) ? intval($_POST['s_group']) : '';
    $s_active = isset($_POST['s_active']) ? intval($_POST['s_active']) : '';
    $s_day = isset($_POST['s_day']) ? intval($_POST['s_day']) : '';
    $s_regdate = isset($_POST['s_regdate']) ? filter($_POST['s_regdate']) : '';
    $s_birthday = isset($_POST['s_birthday']) ? filter($_POST['s_birthday']) : '';
    $s_search = isset($_POST['s_search']);
    if ($s_search) $s_search = $_POST['s_search'] == 1;
    if (isset($status)) {
        switch ($status) {
            case 'activated':
                $where .= 'AND u.`active` = 1 AND u.`group` <> 5';
                $sort .= 'AND u.`active` = 1 ';
                $titles = $lang['users_list'];
                $nav_page = 'activated';
                break;
            case 'not_activated':
                $where .= 'AND u.`active` = 0 ';
                $sort .= 'AND u.`active` = 0 ';
                $titles = $lang['users_not_activated_list'];
                $nav_page = 'not_activated';
                break;
            case 'ban_list':
                $where .= 'AND u.`group` = 5';
                $sort .= 'AND u.`group` = 5';
                $titles = $lang['users_ban_list'];
                $nav_page = 'ban_list';
                break;
        }
    } else {
        $where .= 'AND u.`active` = 1 ';
        $sort .= 'AND u.`active` = 1 ';
        $titles = $lang['users_list'];
        $nav_page = 'activated';
    }
    if ($s_active) {
        if ($_POST['s_active'] == 1) {
            $where .= 'AND u.`active` = 1 ';
        } else {
            $s_active = false;
            $where .= 'AND u.`active` = 0 ';
        }
    } else {
        $s_active = true;
    }
    if ($s_id) {
        $where .= "AND u.`id` LIKE '%" . $db->safesql($s_id) . "%'";
    } else {
        $s_id = '';
    }
    if ($s_day) $where .= "AND u.`last_visit`>='" . mktime(0, 0, 0, date("m") - 1, date("d"), date("Y")) . "'";
    if ($s_nick) $where .= "AND u.`nick` LIKE '%" . $db->safesql($s_nick) . "%'";
    if ($s_email) $where .= "AND u.`email` LIKE '%" . $db->safesql($s_email) . "%'";
    if ($s_group) if ($s_group != 0) $where .= "AND u.`group` = '" . intval($s_group) . "'";
    if ($s_regdate) $where .= "AND u.`regdate`>='" . strtotime($s_regdate) . "'";
    if ($s_birthday) $where .= "AND u.`birthday`>='" . $s_birthday . "'";
    $whereC = str_replace(array('u.'), array(''), $where);
    init_count_text();
    $adminTpl->admin_head($lang['users_manager']);
    echo '<section id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
   <div class="panel-footer-lines">
    <div class="heading-elements text-right">
                  <ul class="icons-list">
                     <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-formu-useradd\')">' . faSpan('fa-user-plus', true, $lang['users_add']) . '</a></li>
                     <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-formu-userexport\')">' . faSpan('fa-upload', true, $lang['user_export']) . '</a></li>
                  </ul>
               </div>
                 </div>
  <div id="modal-formu-useradd" class="modal-dialog popup-lg mfp-with-anim mfp-hide" style="width: auto;max-width: 670px;">
         <form enctype="multipart/form-data" role="form" method="POST" action="{ADMIN_LINK}/addUsr">
        <div class="panel">';
    mhColor($lang['users_add']);
    echo '<div class="panel panel-border top">
            <div class="panel-heading br-b-ddd">
               <ul class="nav panel-tabs-border panel-tabs">
                  <li class="active"><a href="#tab1_1" data-toggle="tab">' . $lang['general'] . '</a></li>
                  <li><a href="#tab1_2" data-toggle="tab">' . $lang['settings'] . '</a></li>
                  <li><a href="#tab1_3" data-toggle="tab">' . $lang['extra'] . '</a></li>
               </ul>
            </div>
            <div class="heading-hr"></div>
            <div class="panel-body p20 pb10">
               <div class="tab-content pn br-n admin-form">
                  <div id="tab1_1" class="tab-pane active">
                     <div class="section row mbn">
                        <div class="col-md-9 pl15">
                           <div class="section row mb15">
                              <div class="col-xs-6">
                                 <label for="nick" class="field prepend-icon">
                                 <input id="nick" type="text" name="nick" class="form-control" onkeyup="return getUserRelates(gid(\'nick\').value, \'check_result\'),count_down(this, \'nick\', 40);" maxlength="40" data-parsley-required="true" data-parsley-trigger="change" required placeholder="' . $lang['login'] . '">
                                 <label for="nick" class="field-icon">' . faI('fa-user', false, false, true) . '</label>
                               <div style="text-align:right" class="text-right">
                                  <span id="char_nick"></span>
                              </div>
                                 </label>
                                 <span id="check_result"></span>
                              </div>
                              <div class="col-xs-6">
                                 <label for="pass" class="field prepend-icon">
                                 <input id="password" type="text" name="password" class="form-control" onkeyup="return passwordChanged(),count_down(this, \'password\', 70);" maxlength="70" data-parsley-required="true" data-parsley-trigger="change" required placeholder="' . $lang['password'] . '">
                                 <label for="pass" class="field-icon">' . faI('fa-lock', false, false, true) . '</label>
                                      <div style="text-align:right" class="text-right">
                                  <span id="char_password"></span>
                              </div>
                                   <div class="passwordChanged">
                                      <span id="strength" style="text-align:center"></span>
                                    </div>
                                 </label>
                                  <span id="check_password"></span>
                              </div>
                           </div>
                           <div class="section mb15">
                              <label for="mail" class="field prepend-icon">
                              <input id="mail" type="text" name="mail" class="form-control" onkeyup="return getEmailRelates(gid(\'mail\').value, \'check_email\'),count_down(this, \'mail\', 50);" maxlength="50" data-parsley-required="true" data-parsley-trigger="change" required placeholder="' . $lang['email'] . '">
                              <label for="mail" class="field-icon">' . faI('fa-envelope-o', false, false, true) . '</label>
                                <div style="text-align:right" class="text-right">
                                  <span id="char_mail"></span>
                              </div>
                              </label>
                              <span id="check_email"></span>
                           </div>
                           <div class="section mb10">
                              <input name="submit" type="submit" class="button btn-system btn-file btn-block ph5 btn-sm btn-raised legitRipple" id="sub" value="' . $lang['users_add'] . '">
                           </div>
                        </div>
                        <div class="col-md-3">
                           <div data-provides="fileupload" class="fileupload fileupload-new admin-form">
                              <div class="fileupload-preview thumbnail mb15">
                                 <img src="' . avatar(false) . '" data-src="holder.js/100%x147" alt="holder">
                              </div>
                              <span class="button btn-system btn-file btn-block ph5 btn-sm btn-raised legitRipple">
                              <span class="fileupload-new">' . $lang['users_add_avatar'] . '</span>
                              <span class="fileupload-exists">' . $lang['users_add_avatar_again'] . '</span>
                              <input type="file" name="avatar"></span>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div id="tab1_2" class="tab-pane">
                     <div class="section row mbn">
                        <div class="col-xs-6 pr15">
                           <div class="section mb10">
                              <label for="phone" class="field prepend-icon">
                              <input id="phone" type="text" name="phone" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['users_phone'] . '">
                              <label for="phone" class="field-icon">' . faI('fa-phone', false, false, true) . '</label>
                              </label>
                           </div>
                           <div class="section">
                              <label for="group" class="field select">
                              <select class="form-control" id="group" name="group">';
    $query2 = $core->select_data('groups', 'special = 0', 'user ASC');
    while ($rows2 = $db->getRow($query2)) {
        echo '<option value="' . $rows2['id'] . '"' . (($rows2['id'] == '2') ? 'selected' : '') . '>' . Glang($rows2['name']) . '</option>';
    }
    echo '</select>
                              ' . faI('arrow double') . '
                              </label>
                           </div>
                        </div>
                        <div class="col-xs-6">
                           <label class="field option">
                           <input type="checkbox" name="activate" checked><span class="checkbox mr10"></span>' . $lang['users_activate'] . '</label><br>
                           <label class="field option mt15">
                           <input type="checkbox" name="mailsend"><span class="checkbox mr10"></span>' . $lang['users_mailsend'] . '</label>
                           <hr class="alt short mv15">
                           <p class="text-muted">' . faSpan('fa-exclamation-circle text-warning fs15 pr5', true, $lang['users_activate_text']) . '</p>
                        </div>
                     </div>
                     <hr class="short alt mtn">
                     <div class="section mb15">
                        <label class="field prepend-icon">
                        <textarea id="signature" name="signature" placeholder="' . $lang['users_signature'] . '" class="form-control br-light bg-light" onkeyup="return count_down(this, \'signature\', 200);" maxlength="200" style="height: 124px; margin: 0 auto"></textarea>
                        <label for="signature" class="field-icon">' . faI('fa-edit', false, false, true) . '</label>
                        </label>
                        <div style="text-align:right" class="text-right">
                            <span id="char_signature"></span>
                        </div>
                     </div>
                  </div>
                  <div id="tab1_3" class="tab-pane">
                    <div class="section row">
                      <div class="col-md-4">
                        <label for="name" class="field prepend-icon">
                           <input id="name" type="text" name="name" onkeyup="return getValText(gid(\'name\').value, \'check_name\'),count_down(this, \'name\', 40);"  maxlength="40" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['user_name'] . '">
                           <label for="name" class="field-icon">' . faI('fa-user', false, false, true) . '</label>
                        </label>
                         <div style="text-align:right" class="text-right">
                             <span id="char_name"></span>
                         </div>
                      </div>
                      <div class="col-md-4">
                        <label for="surname" class="field prepend-icon">
                           <input id="surname" type="text" name="surname" onkeyup="return getValText(gid(\'surname\').value, \'check_surname\'),count_down(this, \'surname\', 40);" maxlength="40" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['surname'] . '">
                           <label for="surname" class="field-icon">' . faI('fa-user', false, false, true) . '</label>
                        </label>
                        <div style="text-align:right" class="text-right">
                           <span id="char_surname"></span>
                        </div>
                      </div>
                      <div class="col-md-4">
                       <label for="ochestvo" class="field prepend-icon">
                           <input id="ochestvo" type="text" name="ochestvo" onkeyup="return getValText(gid(\'ochestvo\').value, \'check_ochestvo\'),count_down(this, \'ochestvo\', 40);" maxlength="40" class="form-control" data-parsley-required="true" data-parsley-trigger="change" placeholder="' . $lang['ochestvo'] . '">
                           <label for="ochestvo" class="field-icon">' . faI('fa-user', false, false, true) . '</label>
                       </label>
                       <div style="text-align:right" class="text-right">
                          <span id="char_ochestvo"></span>
                       </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            <div class="panel-footer-lines"></div>
         </div>
      </form>
      </div>
       </div>';
    $exceAlert = array('danger', 'success', 'info', 'system', 'alert', 'primary', 'default', 'dark');
    $wherelink = (isset($url[0]) && in_array($url[0], $exceAlert) ? 0 : '') . (isset($url[1]) && in_array($url[1], $exceAlert) ? 1 : '') . (isset($url[2]) && in_array($url[2], $exceAlert) ? 2 : '') . (isset($url[3]) && in_array($url[3], $exceAlert) ? 3 : '') . (isset($url[4]) && in_array($url[4], $exceAlert) ? 4 : '') . (isset($url[5]) && in_array($url[5], $exceAlert) ? 5 : '') . (isset($url[6]) && in_array($url[6], $exceAlert) ? 6 : '') . (isset($url[7]) && in_array($url[7], $exceAlert) ? 7 : '') . (isset($url[8]) && in_array($url[8], $exceAlert) ? 8 : '') . (isset($url[9]) && in_array($url[9], $exceAlert) ? 9 : '') . (isset($url[10]) && in_array($url[10], $exceAlert) ? 10 : '');
    $sort = $wherelink ? 'AND u.`active` = 1 ' : $sort;
    $titles = $wherelink ? $lang['users_list'] : $titles;
    $nav_page = $wherelink ? 'activated' : $nav_page;
    if (isset($url[3]) && $url[3] == 'order') {
        $where .= 'AND u.active < 10 ' . $sort;
        switch ($url[4]) {
            case 'abc':
                $order .= 'nick ASC';
                break;
            case 'last':
                $order .= 'last_visit DESC';
                break;
            case 'uid':
                $order .= 'id ASC';
                break;
        }
    } else {
        $order .= 'regdate DESC';
    }
    $query = $core->select_data('users', $where, $order . ' LIMIT ' . limit_page(), 'u.*, g.name, (SELECT uid FROM ' . DB_PREFIX . '_online WHERE u.id=uid LIMIT 1) as online', 'as u LEFT JOIN ' . DB_PREFIX . '_groups as g on(u.group = g.id)');
    $swhere = str_replace(array('u.', 'WHERE'), array('', '',), $where);
    if ($db->numRows($query) > 0) {
        alert_info('user');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $titles . ' (' . $core->sum_data('users', $swhere) . '):</span>
           ' . sort_head('root', 4, 'last', 'uid', $nav_page) . '          
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-6">' . $lang['nick'] . '</th>
                        <th class="text-center">' . faSpan('fa-comments-o', true, false, false, $lang['commentes']) . '</th>
                        <th class="text-center">' . faSpan('fa-newspaper-o', true, false, false, $lang['news_num']) . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
        init_checkbox('th', false, false, true);
        echo '</tr>
                  </thead>
                  <tbody>';
        while ($adminUser = $db->getRow($query)) {
            $geoip = geo_ip::getInstance(ROOT . 'media/geo_ip.dat');
            $flag = $geoip->lookupCountryCode(!empty($adminUser['ip']) ? $adminUser['ip'] : '127.0.0.1');
            $rows = $core->row_data('users', 'id ="' . $adminUser['id'] . '"');
            $icon = $core->row_data('groups', 'name ="' . $adminUser['name'] . '"');
            $count_news = $core->sum_data('news', 'author ="' . $adminUser['nick'] . '"');
            $count_comments = $core->sum_data('comments', 'uid ="' . $adminUser['id'] . '"');
            if ($count_news > 0) $core->upd_data('users', 'user_news ="' . $count_news . '",user_comments ="' . $count_comments . '"', 'nick ="' . $adminUser['nick'] . '"');
            foreach ($smiles as $tag => $param) {
                if ($param['cat'] == 'flags') {
                    $saurl = str_replace($config['url'] . '/', '', $param['url']);
                    $surl = $param['url'] > 30 ? $param['url'] : internoetics_mb_strimwidthd($saurl, 0, 36);
                    $abridged = isset($param['abridged']) ? ' ( ' . $param['abridged'] . ' )' : '';
                    $url_flags = $flag == $param['abridged'] ? '<img src="' . $param['url'] . '" title="' . $param['title'] . $abridged . '" class="img-responsive mw30 ib br4" style="border:0" alt=""/>' : '';
                }
            }
            $uflag = ($flag != 'UN') ? $url_flags : '<img src="media/smiles/flags/UN.png" style="border:0" class="img-responsive mw30 ib br4"  title="' . $lang['undefined'] . '" alt="">';
            $banned = ($adminUser['group'] == 5 ? $lang['users_unlock'] : $lang['users_ban']);
            $sname = !$rows['surname'] && !$rows['name'] && !$rows['ochestvo'] ? $lang['unspecif'] : ($rows['surname'] ?? '') . '&nbsp;' . ($rows['name'] ?? '') . '&nbsp;' . ($rows['ochestvo'] ?? '');
            echo '<tr>
                        <td class ="text-center hidden-xs"><span class="pd-l-sm"></span>' . $adminUser['id'] . '</td>
                        <td>
                           <div class="media media-list"><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-formu-' . $adminUser['id'] . '\')">
                           <img src="' . avatar($adminUser['id']) . '" class="img-responsive mw60 ib br4"' . toggle($sname) . ' alt=""></a></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 14px;font-family: verdana; margin: 0 auto"><a href="profile/' . $adminUser['nick'] . '"> ' . trimtitle($adminUser['nick']) . ' </a></ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['group'] . ':  <span style="color:' . (is_array($icon) ? $icon['color'] : 'grey') . '">' . Glang($adminUser['name']) . '</span></ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['users_date_reg'] . ': ' . formatDate($adminUser['regdate'], true) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['users_date_last'] . ': ' . formatDate($adminUser['last_visit'], true) . '</ol>
                        </td>';
            init_Ajax_count('root', 'user', $adminUser['id'], 'user_comments', 'id=' . $adminUser['id']);
            init_Ajax_count('root', 'user', $adminUser['id'], 'user_news', 'id=' . $adminUser['id']);
            echo '<td class="text-center">' . status_icon('users', $adminUser['id'], 'users') . '
                           <div id="modal-formu-' . $adminUser['id'] . '" class="popup-basic bg-none mfp-with-anim mfp-hide">
                              <div class="panel">';
            mhColor($lang['profile_history'] . $adminUser['nick']);
            UserCardInfo($adminUser['id'], true, true);
            echo '</div>
                           </div>
                        </td>';
            init_checkbox('td', $adminUser['id'], false, '<li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-formu-' . $adminUser['id'] . '\')">' . faSpan('fa-television', true, $lang['view']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/edit/' . $adminUser['id'] . '\">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/retivate/' . $adminUser['id'] . '\">' . faSpan('fa-power-off', true, (($adminUser['active'] == 0) ? $lang['activate'] : $lang['do_deactivation'])) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/ban/' . $adminUser['id'] . '\">' . faSpan('fa-ban', true, $banned) . '</a></li>
                                 ' . (($admin_conf['user_pm'] && $adminUser['nick']) ? '<li><a href="{ADMIN_LINK}/letter/pm/' . $adminUser['id'] . '\">' . faSpan('fa-user-o', true, $lang['pm_write']) . '</a></li>' : '') . '
                                 ' . (($admin_conf['user_mail']) ? '<li><a href="{ADMIN_LINK}/letter/mail/' . $adminUser['id'] . '\">' . faSpan('fa-envelope-o', true, $lang['mail_write']) . '</a></li>' : '') . '
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $adminUser['id'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
            echo '</tr>';
            modal_form_delete($adminUser['id'], $adminUser['nick'], $lang['users_del_title'], 'user', $lang['users_del_text'], '{ADMIN_LINK}/delete/' . $adminUser['id']);
        }
        echo '</tbody>';
        init_tfoot('<option value="reActivate">' . $lang['do_reactivation'] . '</option>
                    <option value="delete">' . $lang['delete'] . '</option>');
        echo '</table>
            </form>
         </div>
      </div>';
        page_list('root', 'user/' . $nav_page, 'users', $whereC);
    } else {
        if ($s_search == 1) {
            $adminTpl->info($lang['users_search_list_empty'], 'info', null, $lang['info']);
            header('refresh: 5; url="/' . ADMIN . '/user/"');
        } else {
            $adminTpl->info($lang['users_empty'], 'empty', null, $lang['users_list']);
        }
    }
    echo '<div id="modal-formu-userexport" class="modal-dialog popup-lg mfp-with-anim mfp-hide" style="width: auto;max-width: 900px;">
         <form enctype="multipart/form-data" role="form" method="POST" action="{ADMIN_LINK}/userexport">
            <div class="panel">';
    mhColor($lang['user_export']);
    echo '<div class="panel-body admin-form">
                  <div class="form-group">
                     <div class="col-sm-12">' . $lang['user_fields_export'] . '</div>
                  </div>
                  <br/>
                  <div class="form-group">
                     <div class="col-lg-4 col-md-4 col-sm-7">
                      ' . scheckbox('nick', true, $lang['user_nick'], true, false, true) . '
                     </div>
                     <div class="col-lg-4 col-md-4 col-sm-7">
                      ' . scheckbox('name', true, $lang['user_full_name'], true, false, true) . '
                     </div>
                     <div class="col-lg-4 col-md-4 col-sm-7">
                       ' . scheckbox('mail', true, $lang['user_email'], true, false, true) . '
                     </div>
                  </div>
                  <div class="form-group">
                     <div class="col-lg-4 col-md-4 col-sm-7">
                      ' . scheckbox('groups', true, $lang['user_group'], true, false, true) . '
                     </div>
                     <div class="col-lg-4 col-md-4 col-sm-7">
                      ' . scheckbox('reg_date', true, $lang['users_date_reg'], true, false, true) . '
                     </div>
                     <div class="col-lg-4 col-md-4 col-sm-7">
                      ' . scheckbox('last_date', true, $lang['users_date_last'], true, false, true) . '
                     </div>
                  </div>
                   <div class="form-group">
                      <label class="col-lg-3 col-sm-3 control-label">' . $lang['group'] . ':</label>
                      <div class="col-lg-5 col-md-5 col-sm-8">
                      <label for="group" class="field select">
                         <select id="group" name="group" class="form-control" select>
                                  <option value="0">' . $lang['all'] . '</option>';
    $query2 = $core->select_data('groups', 'special=0', 'user ASC');
    while ($rows2 = $db->getRow($query2)) {
        echo '<option value="' . $rows2['id'] . '"' . (($rows2['id'] == '2') ? 'selected' : '') . '>' . Glang($rows2['name']) . '</option>';
    }
    echo '</select>
                              ' . faI('arrow double') . '
                           </label>
                        </div>
                     </div>
                     <div class="col-sm-12">&nbsp;</div>
                  <div class="form-group">
                     <label class="col-lg-3 col-sm-3 control-label">' . $lang['users_date_reg'] . ':</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label for="regstartdate" class="field prepend-icon">
                        <input for="regstartdate" type="text" name="regstartdate" id="regstartdate" placeholder="От 01.01.14" class="form-control" style="width:166px;height: 45px;" value="">
                        <input for="regenddate" type="text" name="regenddate" id="regenddate" placeholder="До 06.01.15" class="form-control" style="width:166px;height: 45px;" value="">
                        <label for="regstartdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                        </label>
                     </div>
                  </div>
                     <div class="col-sm-12">&nbsp;</div>
                  <div class="form-group">
                     <label class="col-lg-3 col-sm-3 control-label">' . $lang['users_date_last'] . ':</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label for="laststartdate" class="field prepend-icon">
                        <input for="laststartdate" type="text" name="laststartdate" id="laststartdate" placeholder="От 01.01.14" class="form-control" style="width:166px;height: 45px;" value="">
                        <input for="lastenddate" type="text" name="lastenddate" id="lastenddate" placeholder="До 06.01.15" class="form-control" style="width:166px;height: 45px;" value="">
                        <label for="laststartdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                        </label>
                     </div>
                  </div>
                     <div class="col-sm-12">&nbsp;</div>
                  <div class="form-group">
                     <div class="col-lg-4 col-md-4 col-sm-7">
                        <label class="field option">
                        <input type="radio" name="format" value="csv" checked><span class="radio mr10"></span>' . $lang['user_export_form_csv'] . '</label><br>
                        <hr class="alt short mv15">
                     </div>
                     <div class="col-lg-4 col-md-4 col-sm-7">
                        <label class="field option">
                        <input type="radio" name="format" value="exel"><span class="radio mr10"></span>' . $lang['user_export_form_excel'] . '</label><br>
                        <hr class="alt short mv15">
                     </div>
                     <div class="col-lg-4 col-md-4 col-sm-7">
                        <label class="field option">
                        <input type="radio" name="format" value="txt"><span class="radio mr10"></span>' . $lang['user_export_form_txt'] . '</label><br>
                        <hr class="alt short mv15">
                     </div>
                  </div>
               </div>
               <div class="panel-footer admin-form">
                  <button type="submit" class="btn btn-system btn-file btn-sm btn-raised legitRipple">' . faSpan('fa-upload', true, $lang['user_export_run']) . '</button>
               </div>
            </div>
         </form>
      </div>
   </div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action="">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['users_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_nick" class="field prepend-icon">
               <input id="s_nick" type="text" name="s_nick" placeholder="' . $lang['nick'] . '" class="form-control" value="' . $s_nick . '">
               <label for="s_nick" class="field-icon">' . faI('fa-user', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_email" class="field prepend-icon">
               <input id="s_email" type="text" name="s_email" placeholder="' . $lang['users_pre_email'] . '" class="form-control" value="' . $s_email . '">
               <label for="s_email" class="field-icon">' . faI('fa-envelope-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_group" class="col-lg-3 col-sm-3 control-label pn">
                  <h5><small>' . $lang['group'] . '</small></h5>
               </label>
               <div class="col-lg-9 col-md-9 col-sm-12 section mb10 pn">
                  <label for="s_group" class="field select">
                     <select class="form-control" id="s_group" name="s_group">
                         <option value="0">' . $lang['users_all_group'] . '</option>';
    $query = $core->select_data('groups', 'special=0', 'admin DESC,moderator DESC,user DESC,guest DESC,banned DESC');
    while ($rows = $db->getRow($query)) {
        $selected = ($rows['id'] == $s_group) ? "selected" : "";
        echo '<option value="' . $rows['id'] . '"' . $selected . '>' . Glang($rows['name']) . '</option>';
    }
    echo '</select>
                     ' . faI('arrow double') . '
                  </label>
               </div>
            </div>
           <div class="section mb5">
               <h5><small>' . $lang['users_search_date'] . '</small></h5>
               <div class="section row">
                   <div class="col-lg-6 col-md-6 col-sm-9">
                     <label for="s_regdate" class="field prepend-icon">
                     <input id="s_regdate" type="text" name="s_regdate" placeholder="01.01.2014" class="form-control">
                     <label for="s_regdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
                  <div class="col-lg-6 col-md-6 col-sm-9">
                     <label for="s_birthday" class="field prepend-icon">
                     <input id="s_birthday" type="text" name="s_birthday" placeholder="06.01.2015" class="form-control">
                     <label for="s_birthday" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
                     </label>
                  </div>
               </div>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_day" value="0">
               <input type="checkbox" name="s_day"' . ($s_day ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['users_day'] . '</label>
            </div>
            <div class="section mb15">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active"' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['users_active'] . '</label>
            </div>
             ' . init_sfoot(true, true) . '
         </div>
      </form>
   </aside>
   </div>
</section>';
    $adminTpl->admin_foot();
}

function delete($uid): void
{
    global $config, $core, $files_conf, $lang;
    $name = $core->sum_data('users', 'id ="' . $uid . '"');
    delcache('userInfo_' . $uid);
    $core->del_data('users', 'id ="' . $uid . '"');
    $core->del_data('board_users', 'uid ="' . $uid . '"');
    $core->ins_log(false, $lang['logs_delete_users'], 1, false, false, $name);
    $filelist = glob("*.'" . $files_conf['imgFormats'] . "'");
    $alinks = str_replace(array($config['url'] . '/files/avatars/users/av' . $uid . '/' . isset($filelist)), array(isset($filelist)), avatar($uid));
    $avatars = str_replace(array($config['url'] . '/files/avatars/users/av' . $uid . '/' . $alinks), array($config['url'] . '/files/avatars/users/av' . $uid . '/' . isset($flinks)), avatar($uid));
    $plinks = str_replace(array($config['url'] . '/files/avatars/profile_image/av' . $uid . '/' . isset($filelist)), array(isset($filelist)), pimage($uid));
    $pimage = str_replace(array($config['url'] . '/files/avatars/profile_image/av' . $uid . '/' . $plinks), array($config['url'] . '/files/avatars/profile_image/ av' . $uid . '/' . isset($flinks)), pimage($uid));
    @unlink($avatars);
    @unlink($pimage);
    location(ADMIN . ' /user/activated/');
}