<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $config, $admin_conf, $url, $lang;
switch ($url[2] ?? null) {
    default:
        InitCheck();
        init_count_text();
        Scroll('search');
        Clearform('search');
        $where = 'WHERE `id` != 0 ';
        $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
        $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
        $s_active = isset($_POST['s_active']);
        if ($s_active) {
            if ($_POST['s_active'] == 1) {
                $where .= 'AND `active` = 1 ';
            } else {
                $s_active = false;
                $where .= 'AND `active` = 0 ';
            }
        } else {
            $s_active = true;
        }
        if ($s_id) {
            $where .= 'AND `id` LIKE"%' . $db->safesql($s_id) . '%"';
        } else {
            $s_id = '';
        }
        if ($s_title) $where .= 'AND `title` LIKE"%' . $db->safesql($s_title) . '%"';
        $query = $core->select_data('polls', $where, 'title LIMIT ' . limit_page(), 'id as ppid, title, votes, max, active, date, startdate, enddate, (SELECT COUNT(id) FROM ' . DB_PREFIX . '_poll_questions WHERE ppid = pid) as variants');
        $adminTpl->admin_head($lang['polls']);
        if ($db->numRows($query) > 0) {
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
            alert_info('voting');
            echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $lang['polls_list'] . ':</span>
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th class="col-md-4 text-center">' . $lang['polls_name'] . '</th>
                        <th class="col-md-2 text-center hidden-xs hidden-sm text-nowrap">' . $lang['polls_list_start'] . '</th>
                        <th class="col-md-2 text-center hidden-xs hidden-sm text-nowrap">' . $lang['polls_list_end'] . '</th>
                        <th class="text-center">' . $lang['polls_list_votes'] . '</th>
                        <th class="text-center">' . $lang['status'] . '</th>';
            init_checkbox('th', false, false, true);
            echo '</tr>
                  </thead>
                  <tbody>';
            while ($poll = $db->getRow($query)) {
                $rows = $core->row_data('polls', 'id ="' . $poll['ppid'] . '"');
                if ($rows['startdate'] > time() || $rows['startdate'] > time() && $rows['enddate'] < time() && $rows['active']) {
                    $core->upd_data('polls', 'active = 2', 'id ="' . $rows['id'] . '"');
                } elseif ($rows['startdate'] < time() && !$rows['enddate'] && $rows['active'] || $rows['startdate'] < time() && $rows['enddate'] > time() && $rows['active']) {
                    $core->upd_data('polls', 'active = 1', 'id ="' . $rows['id'] . '"');
                } else {
                    $core->upd_data('polls', 'active = 0', 'id ="' . $rows['id'] . '"');
                }
                $no_time_limit = faI('fa-window-minimize', false, false, false, $lang['no_time_limit']);
                $startdate = !$poll['startdate'] ? $no_time_limit : date('d-m-y', $poll['startdate']);
                $enddate = !$poll['enddate'] ? $no_time_limit : date('d-m-y', $poll['enddate']);
                $date = !$poll['date'] ? '' : date('d-m-y', $poll['date']) . '-';
                echo '<tr>
                        <td class="text-center hidden-xs"><span class="pd-l-sm"></span>' . $poll['ppid'] . '</td>
                        <td class="text-center" data-toggle="tooltip"' . toggle($poll['title']) . '>' . trimtitle($poll['title'], 30) . '</td>
                        <td class="text-center hidden-xs hidden-sm text-nowrap">' . $startdate . '</td>
                        <td class="text-center hidden-xs hidden-sm text-nowrap">' . $enddate . '</td>';
                init_Ajax_count('root', 'voting', $rows['id'], 'votes', 'id=' . $rows['id']);
                echo '<td class="text-center">' . status_icon('polls', $poll['ppid'], 'polls') . '</td>';
                init_checkbox('td', $poll['ppid'], false, '<li><a href="{ADMIN_LINK}/view/' . $poll['ppid'] . '">' . faSpan('fa-television', true, $lang['poll_view']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/edit/' . $poll['ppid'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a href="{ADMIN_LINK}/retivate/' . $poll['ppid'] . '">' . faSpan('fa-power-off', true, (($poll['active'] == 0) ? $lang['do_activation'] : $lang['do_deactivation'])) . '</a></li>
                                 ' . (($rows['startdate'] < time()) ? '' : '<li><a href="{ADMIN_LINK}/restime/' . $poll['ppid'] . '">' . faSpan('fa-calendar-o', true, $lang['do_current_views_date']) . '</a></li>') . '
                                 ' . (!$poll['enddate'] ? '' : '<li><a href="{ADMIN_LINK}/restrictions/' . $poll['ppid'] . '">' . faSpan('fa-stop-circle-o', true, $lang['do_restrictions'] . $lang['do_time']) . '</a></li>') . '
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-clearpools-' . $poll['ppid'] . '\')">' . faSpan('fa-eraser', true, $lang['clear_pools']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $poll['ppid'] . '\')">' . faSpan('fa-trash-o text-danger', true, $lang['delete']) . '</a></li>');
                echo '</tr>';
                modal_form_delete('clearpools-' . $poll['ppid'], $poll['title'], $lang['polls_clearpools_title'], 'poll', $lang['polls_clearpools_text'], '{ADMIN_LINK}/clearpools/' . $poll['ppid'], false, true);
                modal_form_delete($poll['ppid'], $poll['title'], $lang['polls_del_title'], 'poll', $lang['polls_del_text'], '{ADMIN_LINK}/delete/' . $poll['ppid']);
            }
            init_tfoot('<option value="Activate">' . $lang['do_activation'] . '</option>
                        <option value="deActivate">' . $lang['do_deactivation'] . '</option>
                        <option value="reActivate">' . $lang['do_reactivation'] . '</option>
                        <option value="reRestime">' . $lang['do_current_views_date'] . '</option>
                        <option value="reRestrictions">' . $lang['do_restrictions'] . $lang['do_time'] . '</option>
                        <option value="clearPools">' . $lang['clear_pools'] . '</option>
                        <option value="Delete">' . $lang['delete'] . '</option>');
            echo '</table>                            
               </table>
            </form>
         </div>
      </div>';
            page_list('root', 'voting', 'polls');
            echo '</div>
 <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action=""> 
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['xfields_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['title'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb10">
               <label class="field option">
               <input type="hidden" name="s_active" value="0">
               <input type="checkbox" name="s_active"' . ($s_active ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['poll_active'] . '</label>
            </div>
             ' . init_sfoot(true, true) . '
         </div>
      </form>
   </aside>';
        } else {
            $adminTpl->info($lang['polls_empty'], 'empty', null, $lang['polls_list'], $lang['polls_add'], ADMIN . '/voting/add');
        }
        echo '</div>';
        $adminTpl->admin_foot();
        break;
    case 'add':
        add();
        break;
    case 'save':
        $id = isset($_POST['id']) ? intval($_POST['id']) : false;
        $title = filter($_POST['title'], 'title');
        $ttime = 'UNIX_TIMESTAMP(NOW())';
        if ($_POST['startdate']) {
            $startdate = filter($_POST['startdate'], 'startdate');
            if ($startdate != $ttime) {
                $parseDate = explode(' ', $startdate);
                $subDate = explode('.', $parseDate[0]);
                if (isset($parseDate[1])) {
                    $subTime = explode(':', $parseDate[1]);
                } else {
                    $subTime[0] = 12;
                    $subTime[1] = 0;
                }
                $startdate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            }
        } else {
            $startdate = '0';
        }
        if ($_POST['enddate']) {
            $enddate = filter($_POST['enddate'], 'enddate');
            if ($enddate != $ttime) {
                $parseDate = explode(' ', $enddate);
                $subDate = explode('.', $parseDate[0]);
                if (isset($parseDate[1])) {
                    $subTime = explode(':', $parseDate[1]);
                } else {
                    $subTime[0] = 12;
                    $subTime[1] = 0;
                }
                $enddate = gmmktime($subTime[0], $subTime[1], 0, $subDate[1], $subDate[0], $subDate[2]);
            }
        } else {
            $enddate = '0';
        }
        $vars = filter($_POST['vars'], 'html');
        $max = intval($_POST['max']);
        $variants = explode("\n", $vars);
        if ($title && $vars) {
            if (isset($_POST['edit'])) {
                $core->del_data('poll_questions', 'pid ="' . intval($id) . '"');
                $core->del_data('poll_voting', 'pid ="' . intval($id) . '"');
                $allVote = 0;
                foreach ($variants as $var) {
                    if ($var !== '') {
                        $lo = explode('|', $var);
                        $core->ins_data('poll_questions', 'id,pid,variant,position,vote', 'NULL,"' . $id . '","' . str_replace(',', '||', trim($db->safesql($lo[0]))) . '", 0,"' . $lo[1] . '"');
                        $allVote = $allVote + (int)$lo[1];
                    }
                }
                $core->upd_data('polls', 'title ="' . $title . '", votes ="' . $allVote . '", max ="' . $max . '", startdate ="' . $startdate . '", enddate ="' . $enddate . '"', 'id ="' . intval($id) . '"');
                $core->ins_log(false, $lang['logs_edit_voting'], 1, false, false, $title);
                action_alert('root', 'success', 'voting', false, 'polls_edit_ok');
            } else {
                $core->ins_data('polls', 'id,title,votes,max,active,date,startdate,enddate', 'NULL,"' . $db->safesql(processText($title)) . '", 0,"' . $max . '", 1,"' . time() . '","' . $startdate . '","' . $enddate . '"');
                $core->ins_log(false, $lang['logs_add_voting'], 1, false, false, $title);
                list($id) = $core->fetch_data('polls', 'title="' . $db->safesql(processText($title)) . '" AND max ="' . $max . '"');
                foreach ($variants as $var) {
                    if ($var !== '') $core->ins_data('poll_questions', 'id,pid,variant,position,vote', 'NULL,"' . $id . '","' . str_replace(',', '||', trim($db->safesql($var))) . '", 0, 0');
                }
                action_alert('root', 'success', 'voting', false, 'polls_add_ok');
            }
        } else {
            action_alert('root', 'danger', 'voting', 'add', 'not_field');
        }
        break;
    case 'edit':
        $id = intval($url[3]);
        add($id);
        break;
    case 'view':
        init_count_text();
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $query = $core->select_data('poll_questions', 'pid ="' . $id . '"');
            $varinat = '';
            $numb = '';
            while ($rowsq = $db->getRow($query)) {
                $text = rtrim($rowsq['variant'], "\n\r");
                $varinat .= '"' . $text . '", ';
                $numb .= $rowsq['vote'] . ', ';
            }
            $varinat = substr($varinat, 0, -2);
            $numb = substr($numb, 0, -2);
            $adminTpl->admin_head($lang['polls_view']);
            echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">
      <div class="panel panel-info panel-border top">
         <div class="panel-heading"><span class="panel-title">' . $lang['polls_view'] . '</span>			
         </div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <p class="p2">
            <div id="result" style="min-width: 310px; max-width: 800px; height: 200px; margin: 0 auto"></div>';
            poolHighCharts('result', $varinat, $lang['polls_people'], $lang['polls_user'], $numb);
            echo '</p>
         </div>
         <div class="panel-footer-lines"></div>
      </div>
   </div>
</div>';
            $adminTpl->admin_foot();
        } else {
            location(ADMIN . '/voting');
        }
        break;
    case 'delete':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            deleteVot($id);
            action_alert('root', 'success', 'voting');
        } else {
            action_alert('root', 'danger', 'voting', false, 'unknown_error');
        }
        break;
    case 'retivate':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('polls', 'id ="' . $id . '"');
            $active = $rows['active'] == 0 ? 1 : 0;
            $core->upd_data('polls', 'active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_polls'], 1, false, false, $rows['title']);
            action_alert('root', 'success', 'voting');
        } else {
            action_alert('root', 'danger', 'voting', false, 'unknown_error');
        }
        break;
    case 'restrictions':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('polls', 'id ="' . $id . '"');
            $enddate = $rows['enddate'] ? 0 : $rows['enddate'];
            $active = $rows['enddate'] ? 1 : 0;
            $core->upd_data('polls', 'enddate ="' . $enddate . '", active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_polls'], 1, false, false, $rows['title']);
            action_alert('root', 'success', 'voting');
        } else {
            action_alert('root', 'danger', 'voting', false, 'unknown_error');
        }
        break;
    case 'restime':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('polls', 'id ="' . $id . '"');
            $startdate = $rows['startdate'] > time() ? time() - 1 : $rows['startdate'];
            $active = $rows['startdate'] > time() ? 1 : 0;
            $core->upd_data('polls', 'startdate ="' . $startdate . '", active ="' . $active . '"', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_change_status_polls'], 1, false, false, $rows['title']);
            action_alert('root', 'success', 'voting');
        } else {
            action_alert('root', 'danger', 'voting', false, 'unknown_error');
        }
        break;
    case 'clearpools':
        $id = isset($url[3]) ? intval($url[3]) : 0;
        if (!empty($id)) {
            $rows = $core->row_data('polls', 'id ="' . $id . '"');
            $votes = $rows['votes'] ? 0 : $rows['votes'];
            $core->upd_data('polls', 'votes ="' . $votes . '"', 'id ="' . $id . '"');
            $core->upd_data('poll_questions', 'vote ="' . $votes . '"', 'pid ="' . $id . '"');
            $core->del_data('poll_voting', 'pid ="' . $id . '"');
            action_alert('root', 'success', 'voting');
        } else {
            action_alert('root', 'danger', 'voting', false, 'unknown_error');
        }
        break;
    case 'ajax':
        case_ajax('polls');
        break;
    case 'action':
        $type = $_POST['act'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            switch ($type) {
                case 'Activate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('polls', 'active = 1', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'voting');
                    }
                    break;
                case 'deActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('polls', 'active = 0', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'voting');
                    }
                    break;
                case 'reActivate':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('polls', 'active = NOT `active`', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'voting');
                    }
                    break;
                case 'reRestrictions':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('polls', 'enddate = 0, active = 1', 'id ="' . intval($id) . '"');
                        action_alert('root', 'success', 'voting');
                    }
                    break;
                case 'reResttime':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('polls', 'startdate ="' . time() . '", active = 1', 'id ="' . $id . '"');
                        action_alert('root', 'success', 'voting');
                    }
                    break;
                case 'clearPools':
                    foreach ($_POST['checks'] as $id) {
                        $core->upd_data('polls', 'votes = 0', 'id ="' . intval($id) . '"');
                        $core->upd_data('poll_questions', 'vote = 0', 'pid ="' . intval($id) . '"');
                        $core->del_data('poll_voting', 'pid ="' . intval($id) . '"');
                        action_alert('root', 'success', 'voting');
                    }
                    break;
                case 'Delete':
                    foreach ($_POST['checks'] as $id) {
                        deleteVot($id);
                        action_alert('root', 'success', 'voting');
                    }
                    break;
            }
        }
        if (empty($_POST['checks'])) action_alert('root', 'danger', 'voting');
}
function add($id = null): void
{
    global $adminTpl, $core, $lang, $db;
    if (isset($id)) {
        $rows = $core->row_data('polls', 'id ="' . intval($id) . '"');
        $query = $core->select_data('poll_questions', 'pid ="' . intval($id) . '"');
        $title = prepareTitle($rows['title']);
        $max = $rows['max'];
        $startdate = !empty($rows['startdate']) ? gmdate('d.m.Y H:i', intval($rows['startdate'])) : '';
        $enddate = !empty($rows['enddate']) ? gmdate('d.m.Y H:i', intval($rows['enddate'])) : '';
        $admhead = $lang['polls_edit'];
        $variant = '';
        while ($rowsq = $db->getRow($query)) {
            $text = $rowsq['variant'];
            $text = rtrim($text, "\n\r");
            $variant .= $text . "|" . $rowsq['vote'] . "\n";
        }
    } else {
        $title = isset($_POST['title']) ? filter($_POST['title']) : '';
        $startdate = isset($_POST['startdate']) ? filter($_POST['startdate']) : '';
        $enddate = isset($_POST['enddate']) ? filter($_POST['enddate']) : '';
        $variant = isset($_POST['vars']) ? filter($_POST['vars']) : '';
        $max = isset($_POST['max']) ? intval($_POST['max']) : '0';
        $admhead = $lang['polls_add'];
    }
    $validation_array = array(
        'title' => array(
            'required' => array('true', $lang['polls_name_err']),
            'maxlength' => array(99, str_replace('[count]', '100', $lang['count_text_err_2']))
        ),
        'vars' => array(
            'required' => array('true', $lang['polls_variant_err'])
        ),
        'max' => array(
            'required' => array('true', $lang['polls_max_err'])
        )
    );
    $adminTpl->js_code[] = '$("#max").spinner();';
    validationInit($validation_array);
    datetimepickerInit('startdate');
    datetimepickerInit('enddate');
    UniClass('selectList');
    init_count_text();
    $adminTpl->admin_head($admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">';
    alert_info('voting');
    echo '<div class="panel panel-dark panel-border top">
   <div class="panel-heading"><span class="panel-title">' . $admhead . '</span>
   </div>
   <div class="heading-hr"></div>
   <div class="panel-body admin-form">
      <form id="admin-form" class="form-horizontal parsley-form" role="form" action="{ADMIN_LINK}/save' . '" method="post">
         <div class="form-group">
            <label for="title" class="col-lg-3 col-sm-3 control-label">' . $lang['polls_name'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <label for="title" class="field prepend-icon">
               <input id="title" type="text" name="title" value="' . $title . '" onkeyup="count_down(this, \'title\', 100)" maxlength="100" placeholder="' . $lang['polls_name_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
               <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
                 <div style="text-align:right" class="text-right">
                    <span id="char_title"></span>
                 </div>
            </div>
         </div>
          <div class="form-group">
            <label for="vars" class="col-lg-3 col-sm-3 control-label">' . $lang['polls_variant'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <label for="vars" class="field prepend-icon">
               <textarea id="vars" name="vars" placeholder="' . $lang['polls_variant_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $variant . '</textarea>
               <label for="vars" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
                 <span class="input-footer text-left">' . faI('fa-bell') . $lang['polls_variant_tt'] . '</span>
            </div>
          </div>
         <div class="form-group">
             <label for="startdate" class="col-lg-3 col-sm-3 control-label">' . $lang['polls_date_views'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <label for="startdate" class="field prepend-icon">
               <input for="startdate" type="text" name="startdate" id="startdate" placeholder="' . $lang['polls_list_start_view'] . '" class="form-control" style="width:160px;" value="' . $startdate . '">
               <input for="enddate" type="text" name="enddate" id="enddate" placeholder="' . $lang['polls_list_end_view'] . '" class="form-control" style="width:160px;" value="' . $enddate . '">
               <label for="startdate" class="field-icon">' . faI('fa-calendar', false, false, true) . '</label>
               </label>
                  <span class="input-footer text-left">' . faI('fa-bell') . $lang['polls_empty_date'] . '</span>
            </div>
         </div>
         <div class="form-group">
            <label for="max" class="col-lg-3 col-sm-3 control-label">' . $lang['polls_max'] . '</label>
            <div class="col-lg-5 col-md-5 col-sm-8">
               <div class="input-group">
                  <input id="max" name="max" value="' . $max . '" class="form-control ui-spinner-input">
               </div>
                 <span class="input-footer text-left">' . faI('fa-bell') . $lang['polls_max_tt'] . '</span>
            </div>
         </div>
   </div>
   <div class="panel-footer">
   <button type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
   </div>';
    if (isset($id)) {
        echo '<input type="hidden" name="edit" value="1">';
        echo '<input type="hidden" name="id" value="' . $id . '">';
    }
    echo '</form>
</div>';
    $adminTpl->admin_foot();
}

function deleteVot($id): void
{
    global $core, $lang;
    $polls = $core->row_data('polls', 'id ="' . intval($id) . '"');
    $core->del_data('poll_questions', 'pid ="' . intval($id) . '"');
    $core->del_data('poll_voting', 'pid ="' . intval($id) . '"');
    $core->del_data('polls', 'id ="' . intval($id) . '"');
    $core->ins_log(false, $lang['logs_delete_voting'], 1, false, false, $polls['title']);
}