<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $adminTpl, $db, $core, $url, $lang;
switch ($url[2] ?? null) {
    default:
        main();
        break;
    case 'add':
        xfields_add();
        break;
    case 'save':
        xfields_save();
        break;
    case 'delete':
        $id = intval($url[3]);
        $rows = $core->row_data('xfields', 'id = ' . $id);
        if ($id) {
            $core->del_data('xfields', 'id ="' . $id . '"');
            $core->ins_log(false, $lang['logs_delete_xfields'], 1, false, false, $rows['title']);
            action_alert('root', 'success', 'xfields');
        } else {
            action_alert('root', 'danger', 'xfields', false, 'unknown_error');
        }
        break;
    case 'edit':
        $id = intval($url[3]);
        xfields_add($id);
        break;
    case 'action':
        global $core, $lang;
        $type = $_POST['submit'];
        if (isset($_POST['checks']) && is_array($_POST['checks'])) {
            if ($type == 'delete') {
                foreach ($_POST['checks'] as $id) {
                    $core->del_data('xfields', 'id ="' . intval($id) . '"');
                    action_alert('root', 'success', 'xfields');
                }
            }
        } else {
            if (empty($_POST['checks'])) action_alert('root', 'danger', 'xfields');
        }
        break;
}
function main(): void
{
    global $adminTpl, $core, $db, $lang;
    InitCheck();
    init_count_text();
    Scroll('search');
    Clearform('search');
    $where = 'WHERE `type` != 0 ';
    $order = 'id DESC';
    $s_id = isset($_POST['s_id']) ? intval($_POST['s_id']) : '';
    $s_title = isset($_POST['s_title']) ? filter($_POST['s_title'], 'a') : '';
    $s_desc = $_POST['s_desc'] ?? '';
    $s_news = isset($_POST['s_news']) ? intval($_POST['s_news']) : '';
    $s_profile = isset($_POST['s_profile']) ? intval($_POST['s_profile']) : '';
    $s_search = isset($_POST['s_search']);
    if ($s_search) $s_search = $_POST['s_search'] == 1;
    if ($s_id) {
        $where .= 'AND `id` LIKE"%' . $db->safesql($s_id) . '%"';
    } else {
        $s_id = '';
    }
    if ($s_title) $where .= 'AND `title` LIKE"%' . $db->safesql($s_title) . '%"';
    if ($s_desc) $where .= 'AND `description` LIKE"%' . $db->safesql($s_desc) . '%"';
    if ($s_news) $where .= 'AND `module`="news"';
    if ($s_profile) $where .= 'AND `module`="profile"';
    $query = $core->select_data('xfields', $where, $order . ' LIMIT ' . limit_page());
    $adminTpl->admin_head($lang['xfields']);
    if ($db->numRows($query) > 0) {
        echo '<div id="content" class="table-layout animated fadeIn">
   <div class="tray tray-center">';
        alert_info('xfields');
        echo '<div class="panel panel-dark panel-border top">
         <div class="panel-heading">
            <span class="panel-title">' . $lang['xfields_list'] . '</span>';
        modal_form_text('help', $lang['info'], 'fa-info-circle', $lang['xfields'], $lang['xfields_help_1'], $lang['xfields_help_2'], false, true);
        echo '</div>
         <div class="heading-hr"></div>
         <div class="panel-body pn table-responsive">
            <form id="tablesForm" style="margin:0; padding:0" method="POST" action="{ADMIN_LINK}/action" onclick="lihtTable(getSource(event))">
               <table class="table table-xs table-striped">
                  <thead>
                     <tr>
                        <th class="text-center hidden-xs"><span class="pd-l-sm"></span>#</th>
                        <th></th>
                        <th class="col-md-4">' . $lang['titles'] . '</th>
                        <th>' . $lang['xfields_temp'] . '</th>
                        <th class="hidden-xs">' . $lang['module'] . '</th>';
        init_checkbox('th', false, false, true);
        echo '</tr>
                  </thead>
                  <tbody>';
        while ($xfield = $db->getRow($query)) {
            $command = 'document.querySelector(\'#copy_' . $xfield['id'] . '\').select(); document.execCommand(\'copy\'); notif(\'primary\', \'' . $lang['info'] . '\', \'' . $lang['copy_success'] . '\');';
            echo '<tr>
                        <td class="text-center hidden-xs"><span class="pd-l-sm"></span>' . $xfield['id'] . '</td>
                        <td>
                           <div class="media media-list"></div>
                        </td>
                        <td>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['title'] . ': ' . trimtitle($xfield['title'], 50) . '</ol>
                           <ol class="timeline-list" style=" padding:0;font-size: 12px;font-family: verdana; margin: 0 auto">' . $lang['description'] . ':' . $xfield['description'] . '</ol>
                        </td>
                        <td><p class="text-left" href="' . $xfield['id'] . '#copy" onclick="' . $command . '" title="' . $lang['tagcode_copy'] . ' [xfield:' . $xfield['id'] . '][xfield_value:' . $xfield['id'] . '][/xfield:' . $xfield['id'] . ']">
                           <textarea id="copy_' . $xfield['id'] . '" style="height: 40px; margin: 0; font-size: 12px;" class="form-control input-sm text-center" data-parsley-required="true" data-parsley-trigger="change">[xfield:' . $xfield['id'] . '][xfield_value:' . $xfield['id'] . '][/xfield:' . $xfield['id'] . ']</textarea>
                           </p></td>
                        <td class="hidden-xs">' . _mName($xfield['module']) . '</td>';
            init_checkbox('td', $xfield['id'], false, '<li><a href="{ADMIN_LINK}/edit/' . $xfield['id'] . '">' . faSpan('fa-external-link', true, $lang['edit']) . '</a></li>
                                 <li><a href="' . $core->fullURL() . '#copy" onclick="' . $command . '">' . faSpan('fa-files-o', false, $lang['xfields_copy']) . '</a></li>
                                 <li class="divider"></li>
                                 <li><a href="' . $core->fullURL() . '#" onclick="modal_o(\'#modal-form-' . $xfield['id'] . '\')" onClick="return getConfirm(\'' . $lang['delete'] . ' - ' . $xfield['id'] . '?\')">' . faSpan('fa-trash-o text-danger', true, $lang['base_delete']) . '</a></li>');
            echo '</tr>';
            modal_form_delete($xfield['id'], $xfield['title'], $lang['xfields_delete_title'], 'title', $lang['xfields_delete_text'], '{ADMIN}/xfields/delete/' . $xfield['id']);
        }
        echo '</tbody>
                  <tfoot class="footer-menu">
                     <tr>
                        <td colspan="9">
                           <nav class="text-right">
                              <button name="submit" type="submit" id="sub" value="delete" class="btn bg-danger btn-sm btn-raised legitRipple">' . faSpan('fa-trash-o', true, $lang['delete']) . '</button>
                           </nav>
                        </td>
                     </tr>
                  </tfoot>
               </table>
            </form>
         </div>
      </div>';
        page_list('root', 'xfields', 'xfields', $where);
        echo '</div>
   <aside data-tray-height="match" class="panel tray-right tray-rescale tray290">
      <form id="search" name="search" role="form" method="POST" action="">
         <div style="margin-bottom: 20px; border-width: 0;" class="form-group admin-form p15">
            <h4 class="text-left pt10">' . $lang['quick_search'] . '</h4>
            <hr class="short">
             <div class="section mb5">
               <label for="s_id" class="field prepend-icon">
               <input id="s_id" type="text" name="s_id" placeholder="' . $lang['xfields_id'] . '" class="form-control" value="' . $s_id . '" onkeydown="return checkIdKey(event.key)">
               <label for="s_id" class="field-icon">' . faI(false, false, '#', true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label for="s_title" class="field prepend-icon">
               <input id="s_title" type="text" name="s_title" placeholder="' . $lang['title'] . '" class="form-control" value="' . $s_title . '">
               <label for="s_title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
               </label>
            </div>
             <div class="section mb5">
               <label for="s_desc" class="field prepend-icon">
               <input id="s_desc" type="text" name="s_desc" placeholder="' . $lang['description'] . '" class="form-control" value="' . $s_desc . '">
               <label for="s_desc" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
               </label>
            </div>
            <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_news" value="0">
               <input type="checkbox" name="s_news"' . ($s_news ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['news'] . '</label>
            </div>
             <div class="section mb5">
               <label class="field option">
               <input type="hidden" name="s_profile" value="0">
               <input type="checkbox" name="s_profile"' . ($s_profile ? 'checked' : '') . ' value="1"><span class="checkbox"></span>' . $lang['profile'] . '</label>
            </div>
             ' . init_sfoot(true, true) . '
         </div>
      </form>
   </aside>';
    } else {
        list_empty('root', 'xfields', false, $s_search, false, true);
    }
    echo '</div>';
    $adminTpl->admin_foot();
}

function xfields_add($id = null): void
{
    global $adminTpl, $core, $lang;
    if (isset($id)) {
        $xfield = $core->row_data('xfields', 'id ="' . $id . '"');
        $title = prepareTitle($xfield['title']);
        $description = $xfield['description'];
        $default = $xfield['content'];
        $type = $xfield['type'];
        $to_user = $xfield['to_user'];
        $mod = $xfield['module'];
        $admhead = $lang['xfields_edit'];
    } else {
        $title = '';
        $description = '';
        $default = '';
        $to_user = 1;
        $mod = 'news';
        $type = 0;
        $admhead = $lang['xfields_add'];
    }
    $validation_array = array(
        'title' => array(
            'required' => array('true', $lang['xfields_add_title_err']),
            'maxlength' => array(29, str_replace('[count]', '30', $lang['count_text_err_2']))
        ),
        'description' => array(
            'required' => array('true', $lang['xfields_add_desc_err_1']),
            'maxlength' => array(199, str_replace('[count]', '200', $lang['count_text_err_2']))
        ),
        'type' => array(
            'required' => array('true', $lang['xfields_add_type_err'])
        )
    );
    validationInit($validation_array);
    init_count_text();
    $adminTpl->admin_head($admhead);
    echo '<div id="content" class="table-layout animated fadeIn">
<div class="tray tray-center">';
    alert_info('xfields');
    echo '<div class="panel panel-dark panel-border top">
      <div class="panel-heading">
         <span class="panel-title">' . $admhead . '</span>
      </div>
      <div class="heading-hr"></div>
      <div class="panel-body pn table-responsive">
         <script type="text/javascript">
            function xfieldType(val)
            {
            	if(val === \'\'){
            		gid("typeExp").innerHTML = \'\';
            	} else if(val === 1) {
            		gid("typeExp").innerHTML = \'<div class="form-group admin-form"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label><div class="col-lg-5 col-md-5 col-sm-8"><label for="default" class="field"><input id="default" type="text" name="default" value="' . $default . '" placeholder="' . $lang['xfields_type_1_pre'] . '" class="form-control pl10"></label></div>\';
            	} else if(val === 2) {
            		gid("typeExp").innerHTML = \'<div class="form-group admin-form"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label><div class="col-lg-5 col-md-5 col-sm-8"><label for="default" class="field"><textarea name="default" id="full" placeholder="' . $lang['xfields_type_2_pre'] . '" class="form-control br-light bg-light pl10" style="height: 124px; margin: 0 auto">' . $default . '</textarea></label></div>\';
            	} else if(val === 3) {
            		gid("typeExp").innerHTML = \'<div class="form-group admin-form"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label><div class="col-lg-5 col-md-5 col-sm-8"><label for="default" class="field"><textarea name="default" id="full" placeholder="' . $lang['xfields_type_3_pre'] . '" class="form-control br-light bg-light pl10" style="height: 124px; margin: 0 auto">' . $default . '</textarea><span class="input-footer text-left">' . faI('fa-bell') . $lang['xfields_type_3_tt'] . '</span></label></div>\';
            	} else if(val === 4) {
            		gid("typeExp").innerHTML = \'<div class="form-group admin-form"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label><div class="col-lg-5 col-md-5 col-sm-8"><label for="default" class="field"><textarea name="default" id="full" placeholder="' . $lang['xfields_type_2_pre'] . '" class="form-control br-light bg-light pl10" style="height: 124px; margin: 0 auto">' . $default . '</textarea><span class="input-footer text-left">' . faI('fa-bell') . $lang['xfields_type_4_tt'] . '</span></label></div>\';
            	} else if(val === 5) {
            		gid("typeExp").innerHTML = \'<div class="form-group admin-form"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label><div class="col-lg-5 col-md-4  checkbox-custom mb15"><input id="default" type="checkbox" name="default" value=""><label for="default"></label></div>\';
            	} else if(val === 6) {
                	gid("typeExp").innerHTML = \'<div class="form-group"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label><div class="col-lg-5 col-md-4  switch switch-info round switch-inline"><input id="default" type="checkbox" name="default" value=""><label for="default"></label></div>\';
            	}
            }
         </script>
         <div class="panel-body">
            <form id="admin-form" action="{ADMIN_LINK}/save" method="post" name="xfields" role="form" class="form-horizontal parsley-form" data-parsley-validate>
               <div class="form-group admin-form">
                  <label for="title" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_title'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="title" class="field prepend-icon">
                     <input id="title" type="text" name="title" value="' . $title . '" onkeyup="count_down(this, \'title\', 30)" maxlength="30" placeholder="' . $lang['xfields_add_title_pre'] . '" class="form-control" data-parsley-required="true" data-parsley-trigger="change">
                     <label for="title" class="field-icon">' . faI('fa-pencil', false, false, true) . '</label>
                     </label>
                     <div style="text-align:right" class="text-right">
                        <span id="char_title"></span>
                     </div>
                  </div>
               </div>
               <div class="form-group admin-form">
                  <label for="description" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_desc'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label for="description" class="field prepend-icon">
                     <textarea id="description" name="description" onkeyup="count_down(this, \'description\', 200)" maxlength="200" placeholder="' . $lang['xfields_add_desc_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $description . '</textarea>
                     <label for="description" class="field-icon">' . faI('fa-keyboard-o', false, false, true) . '</label>
                     </label>
                  <div style="text-align:right" class="text-right">
                      <span id="char_description"></span>
                  </div>
                  </div>
               </div>
               <div class="form-group admin-form">
                  <label class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_module'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label class="field select">';
    echo '<select class="form-control" select name="module" id="module" onchange="updateCatList(this.value, \'category\');" >';
    foreach ($core->getModList() as $module) {
        if (in_array($module, exceMods('xfields'))) {
            $selected = ($module == $mod) ? "selected" : "";
            echo '<option value="' . $module . '"' . $selected . '>' . _mName($module) . '</option>';
        }
    }
    echo '</select>
                     ' . faI('arrow double') . '
                     </label>
                  </div>
               </div>
               <div class="form-group admin-form">
                  <label class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_cat'] . '</label>
                  <div class="col-lg-5 col-md-5 col-sm-8">
                     <label class="field select">
                        <select class="form-control" select name="category" id="category">
                           <option value="">' . $lang['xfields_add_cat_all'] . '</option>';
    $cats_arr = $core->aCatList();
    foreach ($cats_arr as $cid => $name) {
        $selected = $cid ? "selected" : "";
        echo '<option value="' . $cid . '"' . $selected . '>' . $name . '</option>';
    }
    echo '</select>
                        ' . faI('arrow double') . '
                     </label>
                  </div>
               </div>
               <div class="form-group admin-form">
                     <label class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_type'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8">
                        <label class="field select">
                           <select class="form-control" select class="form-control" name="type" id="type" onchange="xfieldType(this.value); caa(this);">
                              <option value="">' . $lang['xfields_type_0'] . '</option>
                              <option value="1" ' . ($type == 1 ? 'selected' : '') . '>' . $lang['xfields_type_1'] . '</option>
                              <option value="2" ' . ($type == 2 ? 'selected' : '') . '>' . $lang['xfields_type_2'] . '</option>
                              <option value="3" ' . ($type == 3 ? 'selected' : '') . '>' . $lang['xfields_type_3'] . '</option>
                              <option value="4" ' . ($type == 4 ? 'selected' : '') . '>' . $lang['xfields_type_4'] . '</option>
                              <option value="5" ' . ($type == 5 ? 'selected' : '') . '>' . $lang['xfields_type_5'] . '</option>
                              <option value="6" ' . ($type == 6 ? 'selected' : '') . '>' . $lang['xfields_type_6'] . '</option>
                           </select>
                              ' . faI('arrow double') . '
                           </label>
                     </div>
                  </div>';
    if (empty($id)) {
        $typeExp = '';
    } else {
        switch ($type) {
            case 1:
                $typeExp = '<div class="form-group admin-form"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8"><label for="default" class="field"><input id="default" type="text" name="default" value="' . $default . '" placeholder="' . $lang['xfields_type_1_pre'] . '" class="form-control"></label></div></div>';
                break;
            case 2:
                $typeExp = '<div class="form-group admin-form"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8"><label for="default" class="field"><textarea name="default" id="full" placeholder="' . $lang['xfields_type_2_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $default . '</textarea></label></div></div>';
                break;
            case 3:
                $typeExp = '<div class="form-group admin-form"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8"><label for="default" class="field"><textarea name="default" id="full" placeholder="' . $lang['xfields_type_3_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $default . '</textarea><span class="input-footer text-left">' . faI('fa-bell') . $lang['xfields_type_3_tt'] . '</span></label></div></div>';
                break;
            case 4:
                $typeExp = '<div class="form-group admin-form"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8"><label for="default" class="field"><textarea name="default" id="full" placeholder="' . $lang['xfields_type_3_pre'] . '" class="form-control br-light bg-light" style="height: 124px; margin: 0 auto">' . $default . '</textarea><span class="input-footer text-left">' . faI('fa-bell') . $lang['xfields_type_4_tt'] . '</span></label></div></div>';
                break;
            case 5:
                $typeExp = '<div class="form-group admin-form"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8"><label for="default"><input id="default" type="hidden" name="default" value="' . $default . '">' . scheckbox('default', $default) . '</label></div></div>';
                break;
            case 6:
                $typeExp = '<div class="form-group"><label for="default" class="col-lg-3 col-sm-3 control-label">' . $lang['xfields_add_def'] . '</label>
                     <div class="col-lg-5 col-md-5 col-sm-8"><label for="default"><input id="default" type="hidden" name="default" value="' . $default . '">' . radio('default', $default) . '</label></div></div></div>';
                break;
        }
    }
    echo '<div id="typeExp">' . $typeExp . ' </div>
   <div class="form-group admin-form">
                  <div class="col-xs-6">
                     ' . scheckbox('to_user', $to_user, $lang['xfields_add_user']) . '
                  </div>
               </div>
         </div>
         <div class="panel-footer">
         <button  type="submit" class="btn bg-success btn-sm btn-raised legitRipple">' . faSpan('fa-floppy-o', true, $lang['save']) . '</button>
         </div>';
    if (isset($id)) {
        echo '<input type="hidden" name="edit" value="1">
         <input type="hidden" name="fid" value="' . $id . '">';
    }
    echo '</form>
      </div>
   </div>
</div>';
    $adminTpl->admin_foot();
}

function xfields_save(): void
{
    global $core, $db, $lang;
    $fid = isset($_POST['fid']) ? intval($_POST['fid']) : 0;
    $title = filter($_POST['title'], 'title');
    $description = filter($_POST['description'], 'a');
    $type = intval($_POST['type']);
    $to_user = isset($_POST['to_user']) ? 1 : 0;
    $default = filter($_POST['default']);
    $module = filter($_POST['module'], 'module');
    if (!empty($title) && !empty($description) && !empty($type)) {
        if (isset($_POST['edit'])) {
            $core->upd_data('xfields', 'title ="' . $title . '", description ="' . $description . '", type ="' . $type . '", content ="' . $default . '", to_user ="' . $to_user . '", module ="' . $module . '"', 'id ="' . $fid . '"');
            $core->ins_log(false, $lang['logs_edit_xfields'], 1, false, false, $title);
            action_alert('root', 'success', 'xfields', false, 'xfields_info_1');
        } else {
            $core->ins_data('xfields', 'title,description,type,content,to_user,module', '"' . $db->safesql(processText($title)) . '","' . $db->safesql(processText($description)) . '","' . $type . '","' . $default . '","' . $to_user . '","' . $module . '"');
            $core->ins_log(false, $lang['logs_add_xfields'], 1, false, false, $title);
            action_alert('root', 'success', 'xfields', false, 'xfields_info_2');
        }
    } else {
        action_alert('root', 'danger', 'xfields', 'add', 'not_field');
    }
}

function xfType($type): void
{
    global $lang;
    $langs = array('xfields_type_0', 'xfields_type_1', 'xfields_type_2', 'xfields_type_3', 'xfields_type_4', 'xfields_type_5', 'xfields_type_6');
    $types = $type ? explode('.', $type) : explode('.', '0.0.0');
    $xfields = '<select class="form-control" name="type" id="type" onchange="xfieldType(this.value); caa(this);">';
    for ($i = 0; $i < 7; $i++) {
        $xfields .= '<option value="' . $i . '"' . ($types[0] == $i ? ' selected' : '') . '>' . $lang[$langs[$i]] . '</option>';
    }
    $xfields .= '</select>';
    echo $xfields ?: '';
}