<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfigBLOCK('auth');
global $core, $db, $config, $user, $lang, $smiles, $auth_conf;
$core->loadblockLang('auth');
$abridged = '';
$metod = ($user['auth_metod'] == 'email') ? $lang['auth_email'] : $lang['auth_login'];
list($bookmarks) = isset($core->auth->user_info['id']) ? $core->fetch_data('bookmarks', 'uid = "' . $core->auth->user_id . '"', 'COUNT(*)') : null;
if ($auth_conf['on']) {
    if ($auth_conf['old']) {
        if ($core->auth->isUser) {
            echo '<div class="l-link">
   <div class="login-line">
      <div style="text-align:center">' . $lang['auth_hello'] . '<b>' . $core->auth->user_info['nick'] . '</b>!<br/><br/><img src="' . avatar($core->auth->user_info['id']) . '" style="border:0" alt="" /><br/><br/></div>';
            if ($core->auth->isAdmin) {
                echo '<hr/>
      <a href="' . ADMIN . '">' . $lang['auth_panel'] . ' <i class="flaticon-shield"></i></a><br/>';
            }
            echo '<a href="/news/addPost" class="profile-link">Добавить на сайт <i class="flaticon-edit"></i></a><br/>
      <a href="/profile" class="profile-link">Профиль <i class="flaticon-user-1"></i></a><br/>
      <a href="/pm" class="pm-link">Сообщения (' . $core->auth->newPmsNumb . ') <i class="flaticon-message-1"></i></a><br/>
      <a href="/news/bookmarks" class="pm-link">Закладки (' . $bookmarks . ') <i class="flaticon-favorites"></i></a><br/>
      <a href="/profile/logout" class="lu-link">' . $lang['auth_exit'] . ' <i class="flaticon-power-button"></i></a>
   </div>
</div>';
        } else {
            echo '<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.13/css/all.css" integrity="sha384-DNOHZ68U8hZfKXOrtjWvjxusGo9WQnrNx2sqG0tfsghAvtVlRW3tvkXWZh58N9jp" crossorigin="anonymous">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" />
<script type="text/javascript">
   $(document).on(\'click\', \'.toggle-passw\', function() {
       $(this).toggleClass("fa-eye fa-eye-slash");
           var input = $("#passw");
       input.attr(\'type\') === \'password\' ? input.attr(\'type\',\'text\') : input.attr(\'type\',\'password\')
   });
</script>
<form action="profile/login" method="post" onkeypress="ctrlEnter(event, this);">
   <div class="login-line">
      <input name="nick" type="text" class="login-input-text" placeholder="' . $metod . $lang['auth_on_website'] . '" title="' . $metod . $lang['auth_on_website'] . '"/>
   </div>
   <div class="login-line">        
      <input name="password" type="password" id="passw" class="login-input-text" placeholder="' . $lang['auth_your_password'] . '" title="' . $lang['auth_your_password'] . '"/><span toggle="#repass-field" class="fa fa-fw fa-eye field_icon toggle-passw login-passw form-line-tt-right"></span>
   </div>
   <div class="login-line">
      <input onclick="submit();" type="submit" class="enter" value="ВОЙТИ"/>
      <input name="login" type="hidden" id="login" value="submit"/>
   </div>
   <div class="reg-link">
      <a href="/profile/register" title="' . $lang['auth_regs'] . '">' . $lang['auth_register'] . '</a> /
      <a href="/profile/forgot_pass" title="' . $lang['auth_lost_pas'] . '">' . $lang['auth_forget_everything'] . '</a>
   </div>
   <div style="clear: both;height: 20px;"></div>
</form>';
        }
    } else {
        list($friends) = isset($core->auth->user_info['id']) ? $core->fetch_data('users', '(f.who_invite = "' . $core->auth->user_info['id'] . '" OR f.whom_invite = "' . $core->auth->user_info['id'] . '") AND u.id != "' . $core->auth->user_info['id'] . '" AND f.confirmed = 1', 'COUNT(*)', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on (u.id = f.who_invite OR u.id = f.whom_invite)') : null;
        list($onfriends) = isset($core->auth->user_info['id']) ? $core->fetch_data('online', '(f.who_invite = "' . $core->auth->user_info['id'] . '" OR f.whom_invite = "' . $core->auth->user_info['id'] . '") AND u.uid != "' . $core->auth->user_info['id'] . '"	AND f.confirmed = 1', 'COUNT(*)', 'as u LEFT JOIN ' . DB_PREFIX . '_user_friends as f on (u.uid = f.who_invite OR u.uid = f.whom_invite)') : null;
        if ($core->auth->isUser) {
            $geoip = geo_ip::getInstance(ROOT . 'media/geo_ip.dat');
            $flag = $geoip->lookupCountryCode(!empty($core->auth->user_info['ip']) ? $core->auth->user_info['ip'] : '127.0.0.1');
            foreach ($smiles as $tag => $param) {
                if ($param['cat'] == 'flags') {
                    $saurl = str_replace($config['url'] . '/', '', $param['url']);
                    $surl = $param['url'] > 30 ? $param['url'] : internoetics_mb_strimwidthd($saurl, 0, 36, $trimmarker = '...');
                    $abridged = isset($param['abridged']) ? ' ( ' . $param['abridged'] . ' )' : '';
                    if ($flag == $param['abridged']) $url_flags = '<img src="' . $param['url'] . '" title="' . $param['title'] . $abridged . ' " class="img-responsive mw30 ib br4" style="border:0" alt=""/>';
                } else {
                    $url_flags = '';
                }
            }
            $uflag = ($flag != 'UN') ? $url_flags : '<img src="media/smiles/flags/UN.png" style="border:0" class="img-responsive mw30 ib br4"  title="' . $lang['undefined'] . '" alt="" />';
            $core->tpl->loadFile('blocks/auth');
            $core->tpl->setVar('AVATAR', avatar($core->auth->user_info['id']));
            $core->tpl->setVar('NICK', $core->auth->user_info['nick']);
            if ($core->auth->isAdmin) $core->tpl->setVar('URL_ADMIN', ADMIN);
            $core->tpl->setVar('URL_ADD', '/news/addPost');
            $core->tpl->setVar('URL_PROFIL', 'profile');
            $core->tpl->setVar('URL_PM', 'pm');
            $core->tpl->setVar('URL_BOOKMARKS', 'news/bookmarks');
            $core->tpl->setVar('URL_COMMENTS', 'news/user_comments');
            $core->tpl->setVar('URL_UNEWS', 'news/user_news');
            $core->tpl->setVar('URL_FLIST', ($friends > 0) ? 'profile/friends_list' : '');
            $core->tpl->setVar('URL_ONFLIST', ($onfriends > 0) ? 'profile/online_friends_list' : '');
            $core->tpl->setVar('USER_IP', (!empty($core->auth->user_info['ip']) ? $core->auth->user_info['ip'] : '127.0.0.1'));
            $core->tpl->setVar('COUNTRICON', $uflag);
            $core->tpl->setVar('URL_LOGOUT', 'profile/logout');
        } else {
            $core->tpl->loadFile('blocks/auth');
            $core->tpl->setVar('AVATAR', avatar($core->auth->user_info['id'] ?? null));
            $core->tpl->setVar('NICK', isset($core->auth->user_info['id']) ? $core->auth->user_info['nick'] : '');
            $core->tpl->setVar('URL_LOGIN', 'profile/login');
            $core->tpl->setVar('URL_REG', 'profile/register');
            $core->tpl->setVar('URL_FORGOT', 'profile/forgot_pass');
            $core->tpl->setVar('URL_PDA', 'index.php?phone_change');
        }
        $core->tpl->end();
    }
} else {
    if ($auth_conf['info_off']) $core->tpl->info($lang['auth_off']);
}