<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfigBLOCK('bookmarks');
global $db, $core, $url, $lang, $news_conf, $bookmarks_conf;
$core->loadblockLang('bookmarks');
require_once ROOT . '/etc/news.config.php';
$i = 0;
$where = 'uid = "' . $core->auth->user_id . '"';
$order = 'id DESC';
$query = $core->select_data('bookmarks', $where, $order . ' LIMIT ' . $bookmarks_conf['num']);
if ($bookmarks_conf['on']) {
    if ($db->numRows($query) > 0) {
        while ($rows = $db->getRow($query)) {
            if ($rows['uid'] == $core->auth->user_id) {
                if (mb_strlen($rows['title'], 'utf-8') > 80)
                    $rows['title'] = mb_substr($rows['title'], 0, 80, 'utf-8') . '..';
                if ($news_conf['bookmarks_block'] == 1) {
                    $title = $rows['title'];
                    $id = $rows['id'];
                    $nid = $rows['nid'];
                    $url = $rows['url'];
                    $date = formatDate($rows['date'], true);
                    $news = $core->row_data('news', 'id="' . $nid . '"', false, false, 'as n LEFT JOIN ' . DB_PREFIX . '_langs as c on(c.postId=n.id and c.module="news")');
                    $cid = str_replace(array('/' . $core->auth->user_id), array(''), $rows['nid']);
                    $content = $core->row_data('content', 'id="' . $cid . '"', false, false, 'as c LEFT JOIN ' . DB_PREFIX . '_langs as l on(l.postId=c.id and l.module="content")');
                    $folder = strripos($url, 'news/') === false ? 'content' : 'news';
                    $cid = $content['id'] ?? '';
                    $nid = $news['id'] ?? '';
                    $mod_id = strripos($url, 'news/') === false ? $cid : $nid;
                    $patch = !$news_conf['related_news_img_thumbs'] ? 'files/' . $folder . '/' . $mod_id . '/' : 'files/thumbs/files/' . $folder . '/' . $mod_id . '/';
                    $dir = news_image($patch);
                    $images = array();
                    $all_files = !empty($dir) ? scandir($dir) : null;
                    $all_files_array = is_array($all_files) ? count($all_files) : '';
                    for ($i = 0; $i < $all_files_array; $i++) {
                        if (!str_contains($all_files[$i], ".png") and !str_contains($all_files[$i], ".jpg") and
                            !str_contains($all_files[$i], ".gif")
                        ) continue;
                        $images[] = $all_files[$i];
                    }
                    $img_random = (!empty($images) ? $images[rand(0, sizeof($images) - 1)] : '');
                    $img_src = $dir . $img_random;
                    $img_src = (!empty($dir) && filesize($img_src) > 0) ? $img_src : '/media/cats/no_image.png';
                    $count = (is_array($img_src)) ? count($img_src) : 0;
                    if ($count) {
                        $width = '';
                        $height = '';
                        $type = '';
                        $attr = '';
                    } else {
                        list($width, $height, $type, $attr) = getimagesize(ROOT . $img_src);
                    }
                    if ($news_conf['bookmarks_news_img_height'] && $news_conf['bookmarks_news_img_widtht']) {
                        $style = 'style="width:' . $news_conf['bookmarks_news_img_widtht'] . 'px; height:' . $news_conf['bookmarks_news_img_height'] . 'px;"';
                    } elseif ($news_conf['bookmarks_news_img_height'] == 0 && $news_conf['bookmarks_news_img_widtht']) {
                        $style = 'style="width:' . $news_conf['bookmarks_news_img_widtht'] . 'px; height:' . $height . 'px;"';
                    } elseif ($news_conf['bookmarks_news_img_height'] && $news_conf['bookmarks_news_img_widtht'] == 0) {
                        $style = 'style="width:' . $width . 'px; height:' . $news_conf['bookmarks_news_img_height'] . 'px;"';
                    } else {
                        $style = 'style="width:' . $width . 'px; height:' . $height . 'px;"';
                    }
                    if (!$dir) @mkdir(ROOT . $patch, 0777);
                    $core->tpl->loadFile('blocks/bookmarks');
                    $core->tpl->setVar('TITLE', $title);
                    $core->tpl->setVar('IMG', '<li><div class="post-media"><a href="' . $url . '"><img src="' . $img_src . '"  ' . $style . ' alt=""></a></div></li>');
                    $core->tpl->setVar('ID', $id);
                    $core->tpl->setVar('URL_IMG', $img_src);
                    $core->tpl->setVar('NID', $nid);
                    $core->tpl->setVar('URL', $url);
                    $core->tpl->setVar('DATE', $date);
                    $core->tpl->setVar('DELETE', '<a href="news/del_bookmarks/' . $rows['id'] . '">' . $lang['delete'] . '</a>');
                    $core->tpl->setVar('URL_DEL', '<a href="' . $folder . '/del_bookmarks/' . $rows['id'] . '">');
                    $core->tpl->end();
                } else {
                    echo '<div class="infoTitl"><a href="' . $rows['url'] . '">' . $rows['title'] . '<div class="dt">' . formatDate($rows['date'], true) . '</div></div></a><br/>';
                }
            }
        }
    } else {
        $core->tpl->info($lang['bookmarks_list_empty']);
    }
} else {
    if ($bookmarks_conf['info_off']) $core->tpl->info($lang['bookmarks_off']);
}