<?php
/*
 * @name            JMY CORE
 * @link            https://jmy.su/
 * @copyright       Copyright (C) 2012-2019 JMY LTD
 * @license         LICENSE.txt (see attached file)
 * @version         VERSION.txt (see attached file)
 * @author          Orlov Alexsey
 */
if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $auth_conf, $lang;
$name = 'auth';
$configBox = array(
    'auth' => array(
        'varName' => 'auth_conf',
        'title' => $lang['block_auth'],
        'groups' => array(
            'main' => array(
                'title' => $lang['block_auth'],
                'vars' => array(
                    'on' => array(
                        'title' => $lang['block_auth_user'],
                        'description' => $lang['block_auth_user_desc'],
                        'content' => radio("on", $auth_conf['on']),
                    ),
                    'old' => array(
                        'title' => $lang['block_old_off'],
                        'description' => $lang['block_old_off_desc'],
                        'content' => radio("old", $auth_conf['old']),
                    ),
                    'info_off' => array(
                        'title' => $lang['block_info_off'],
                        'description' => str_replace(array('[name_bloks]', '{%BLOCKS:FILE:name%}', '[/name_bloks]'), array('[' . $name . '_bloks]', '{%BLOCKS:FILE:' . $name . '%}', '[/' . $name . '_bloks]'), $lang['block_info_off_desc']),
                        'content' => radio("info_off", $auth_conf['info_off']),
                    ),
                )
            ),
        ),
    ),
);