<?php
/*
 * @name            JMY CORE
 * @link            https://jmy.su/
 * @copyright       Copyright (C) 2012-2019 JMY LTD
 * @license         LICENSE.txt (see attached file)
 * @version         VERSION.txt (see attached file)
 * @author          Komarov Ivan
 */
if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $cats_conf, $lang;
$name = 'cats';
$configBox = array(
    'cats' => array(
        'varName' => 'cats_conf',
        'title' => $lang['block_cats'],
        'groups' => array(
            'main' => array(
                'title' => $lang['block_cats'],
                'vars' => array(
                    'on' => array(
                        'title' => $lang['block_cats_user'],
                        'description' => $lang['block_cats_user_desc'],
                        'content' => radio("on", $cats_conf['on']),
                    ),
                    'module' => array(
                        'title' => $lang['modules'],
                        'description' => $lang['block_cats_module_desc'],
                        'content' => changeModule(),
                    ),
                    'old' => array(
                        'title' => $lang['block_old_off'],
                        'description' => $lang['block_old_off_desc'],
                        'content' => radio("old", $cats_conf['old']),
                    ),
                    'info_off' => array(
                        'title' => $lang['block_info_off'],
                        'description' => str_replace(array('[name_bloks]', '{%BLOCKS:FILE:name%}', '[/name_bloks]'), array('[' . $name . '_bloks]', '{%BLOCKS:FILE:' . $name . '%}', '[/' . $name . '_bloks]'), $lang['block_info_off_desc']),
                        'content' => radio("info_off", $cats_conf['info_off']),
                    ),
                )
            ),
        ),
    ),
);
function changeModule()
{
    global $core, $cats_conf, $lang;
    $exceMods = array('blog', 'board', 'feed', 'sitemap', 'feedback', 'gallery', 'pm', 'profile', 'search', 'poll', 'mainpage', 'guestbook');
    $content = '<select class="form-control" data-parsley-required="true" data-parsley-trigger="change" name="{varName}">
<div class="form-group">
      <label class="col-sm-3 control-label">' . $lang['title'] . '</label>
      <div class="col-sm-4">
                <option value="all">' . $lang['xfields_add_cat_all'] . '</option>';
    foreach ($core->getModList() as $module) {
        if (!in_array($module, $exceMods) && !empty($core->tpl->modules[$module])) {
            $selected = ($module == $cats_conf['module']) ? "selected" : "";
            $content .= '<option value="' . $module . '" ' . $selected . '>' . _mName($module) . '</option>';
        }
    }
    $content .= '</div>
   </div></select>';
    return $content;
}