<?php
/*
 * @name        JMY CMS
 * @link        http://jmy.su/
 * @copyright   Copyright (C) 2012-2023 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 */
if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $online_conf, $lang;
$name = 'online';
$configBox = array(
    'online' => array(
        'varName' => 'online_conf',
        'title' => $lang['block_online'],
        'groups' => array(
            'main' => array(
                'title' => $lang['block_online'],
                'vars' => array(
                    'on' => array(
                        'title' => $lang['block_online_on'],
                        'description' => $lang['block_online_on_desc'],
                        'content' => radio("on", $online_conf['on']),
                    ),
                    'guest' => array(
                        'title' => $lang['block_online_guest'],
                        'description' => $lang['block_online_guest_desc'],
                        'content' => radio("guest", $online_conf['guest']),
                    ),
                    'user' => array(
                        'title' => $lang['block_online_user'],
                        'description' => $lang['block_online_user_desc'],
                        'content' => radio("user", $online_conf['user']),
                    ),
                    'bot' => array(
                        'title' => $lang['block_online_bot'],
                        'description' => $lang['block_online_bot_desc'],
                        'content' => radio("bot", $online_conf['bot']),
                    ),
                    'top' => array(
                        'title' => $lang['block_online_top'],
                        'description' => $lang['block_online_top_desc'],
                        'content' => radio("top", $online_conf['top']),
                    ),
                    'top_numb' => array(
                        'title' => $lang['block_online_top_numb'],
                        'description' => $lang['block_online_top_numb_desc'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'old' => array(
                        'title' => $lang['block_old_off'],
                        'description' => $lang['block_old_off_desc'],
                        'content' => radio("old", $online_conf['old']),
                    ),
                    'info_off' => array(
                        'title' => $lang['block_info_off'],
                        'description' => str_replace(array('[name_bloks]', '{%BLOCKS:FILE:name%}', '[/name_bloks]'), array('[' . $name . '_bloks]', '{%BLOCKS:FILE:' . $name . '%}', '[/' . $name . '_bloks]'), $lang['block_info_off_desc']),
                        'content' => radio("info_off", $online_conf['info_off']),
                    ),
                )
            ),
        ),
    ),
);