<?php
/*
 * @name            JMY CORE
 * @link            https://jmy.su/
 * @copyright       Copyright (C) 2012-2023 JMY LTD
 * @license         LICENSE.txt (see attached file)
 * @version         VERSION.txt (see attached file)
 * @author          Orlov Alexsey
 */
if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $onlinfriends_conf, $lang;
$name = 'onlinfriends';
$configBox = array(
    'onlinfriends' => array(
        'varName' => 'onlinfriends_conf',
        'title' => $lang['block_onlinfriends'],
        'groups' => array(
            'main' => array(
                'title' => $lang['block_onlinfriends'],
                'vars' => array(
                    'on' => array(
                        'title' => $lang['block_onlinfriends_user'],
                        'description' => $lang['block_onlinfriends_user_desc'],
                        'content' => radio("on", $onlinfriends_conf['on']),
                    ),
                    'num' => array(
                        'title' => $lang['block_onlinfriends_numb'],
                        'description' => $lang['block_onlinfriends_numb_desc'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'old' => array(
                        'title' => $lang['block_old_off'],
                        'description' => $lang['block_old_off_desc'],
                        'content' => radio("old", $onlinfriends_conf['old']),
                    ),
                    'info_off' => array(
                        'title' => $lang['block_info_off'],
                        'description' => str_replace(array('[name_bloks]', '{%BLOCKS:FILE:name%}', '[/name_bloks]'), array('[' . $name . '_bloks]', '{%BLOCKS:FILE:' . $name . '%}', '[/' . $name . '_bloks]'), $lang['block_info_off_desc']),
                        'content' => radio("info_off", $onlinfriends_conf['info_off']),
                    ),
                )
            ),
        ),
    ),
);