<?php
/*
 * @name            JMY CORE
 * @link            https://jmy.su/
 * @copyright       Copyright (C) 2012-2022 JMY LTD
 * @license         LICENSE.txt (see attached file)
 * @version         VERSION.txt (see attached file)
 * @author          Komarov Ivan
 */
if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $poll_conf, $lang;
$name = 'poll';
$configBox = array(
    'poll' => array(
        'varName' => 'poll_conf',
        'title' => $lang['block_poll'],
        'groups' => array(
            'main' => array(
                'title' => $lang['block_poll'],
                'vars' => array(
                    'on' => array(
                        'title' => $lang['block_poll_on'],
                        'description' => $lang['block_poll_on_desc'],
                        'content' => radio("on", $poll_conf['on']),
                    ),
                    'poll_id' => array(
                        'title' => $lang['block_poll_id'],
                        'description' => $lang['block_poll_id_desc'],
                        'content' => changePoll(),
                    ),
                    'poll_rand' => array(
                        'title' => $lang['block_poll_random'],
                        'description' => $lang['block_poll_random_desc'],
                        'content' => radio("poll_rand", $poll_conf['poll_rand']),
                    ),
                    'info_off' => array(
                        'title' => $lang['block_info_off'],
                        'description' => str_replace(array('[name_bloks]', '{%BLOCKS:FILE:name%}', '[/name_bloks]'), array('[' . $name . '_bloks]', '{%BLOCKS:FILE:' . $name . '%}', '[/' . $name . '_bloks]'), $lang['block_info_off_desc']),
                        'content' => radio("info_off", $poll_conf['info_off']),
                    ),
                )
            ),
        ),
    ),
);
function changePoll()
{
    global $db, $core, $poll_conf, $lang;
    $content = '<select  class="form-control" data-parsley-required="true" data-parsley-trigger="change" name="{varName}">';
    $query2 = $core->select_data('polls');
    if ($db->numRows($query2) > 0) {
        while ($rows2 = $db->getRow($query2)) {
            $sel = ($poll_conf['poll_id'] == $rows2['id']) ? 'selected' : '';
            $content .= '<option value="' . $rows2['id'] . '" ' . $sel . '>' . $rows2['title'] . '</option>';
        }
    } else {
        $content .= '<option value="0">' . '' . $lang['block_polls_empty'] . '' . '</option>';
    }
    $content .= '</select>';
    return $content;
}