<?php
/*
 * @name            JMY CORE
 * @link            https://jmy.su/
 * @copyright       Copyright (C) 2012-2023 JMY LTD
 * @license         LICENSE.txt (see attached file)
 * @version         VERSION.txt (see attached file)
 * @author          Orlov Alexsey
 */
if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $tags_conf, $lang;
$name = 'tags';
$configBox = array(
    'tags' => array(
        'varName' => 'tags_conf',
        'title' => $lang['block_tags'],
        'groups' => array(
            'main' => array(
                'title' => $lang['block_tags'],
                'vars' => array(
                    'on' => array(
                        'title' => $lang['block_tags_user'],
                        'description' => $lang['block_tags_user_desc'],
                        'content' => radio("on", $tags_conf['on']),
                    ),
                    'num' => array(
                        'title' => $lang['block_tags_numb'],
                        'description' => $lang['block_tags_numb_desc'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'old' => array(
                        'title' => $lang['block_old_off'],
                        'description' => $lang['block_old_off_desc'],
                        'content' => radio("old", $tags_conf['old']),
                    ),
                    'info_off' => array(
                        'title' => $lang['block_info_off'],
                        'description' => str_replace(array('[name_bloks]', '{%BLOCKS:FILE:name%}', '[/name_bloks]'), array('[' . $name . '_bloks]', '{%BLOCKS:FILE:' . $name . '%}', '[/' . $name . '_bloks]'), $lang['block_info_off_desc']),
                        'content' => radio("info_off", $tags_conf['info_off']),
                    ),
                )
            ),
        ),
    ),
);