<?php
/*
 * @name            JMY CORE
 * @link            https://jmy.su/
 * @copyright       Copyright (C) 2012-2023 JMY LTD
 * @license         LICENSE.txt (see attached file)
 * @version         VERSION.txt (see attached file)
 * @author          Orlov Alexsey
 */
if (!defined('ADMIN_ACCESS')) {
    header('Location: /');
    exit;
}
global $topnews_conf, $lang;
$name = 'topnews';
$configBox = array(
    'topnews' => array(
        'varName' => 'topnews_conf',
        'title' => $lang['block_topnews'],
        'groups' => array(
            'main' => array(
                'title' => $lang['block_topnews'],
                'vars' => array(
                    'on' => array(
                        'title' => $lang['block_topnews_user'],
                        'description' => $lang['block_topnews_user_desc'],
                        'content' => radio("on", $topnews_conf['on']),
                    ),
                    'num' => array(
                        'title' => $lang['block_topnews_numb'],
                        'description' => $lang['block_topnews_numb_desc'],
                        'content' => int_cong('input', '{varName}', '{var}'),
                    ),
                    'choice' => array(
                        'title' => $lang['block_topnews_choice'],
                        'description' => $lang['block_topnews_choice_desc'],
                        'content' => select_choice(),
                    ),
                    'sort' => array(
                        'title' => $lang['block_topnews_sort'],
                        'description' => $lang['block_topnews_sort_desc'],
                        'content' => select_sort(),
                    ),
                    'old' => array(
                        'title' => $lang['block_old_off'],
                        'description' => $lang['block_old_off_desc'],
                        'content' => radio("old", $topnews_conf['old']),
                    ),
                    'info_off' => array(
                        'title' => $lang['block_info_off'],
                        'description' => str_replace(array('[name_bloks]', '{%BLOCKS:FILE:name%}', '[/name_bloks]'), array('[' . $name . '_bloks]', '{%BLOCKS:FILE:' . $name . '%}', '[/' . $name . '_bloks]'), $lang['block_info_off_desc']),
                        'content' => radio("info_off", $topnews_conf['info_off']),
                    ),
                )
            ),
        ),
    ),
);
function select_choice()
{
    global $topnews_conf, $lang;
    return '<select class="form-control" name="choice">
<option value="id" ' . ($topnews_conf['choice'] == "id" ? "selected" : "") . '>' . $lang['id'] . '</option>
<option value="views" ' . ($topnews_conf['choice'] == "views" ? "selected" : "") . '>' . $lang['view_s'] . '</option>
<option value="votes" ' . ($topnews_conf['choice'] == "votes" ? "selected" : "") . '>' . $lang['rating_s'] . '</option>
</select>';
}

function select_sort()
{
    global $topnews_conf, $lang;
    return '<select class="form-control" name="sort">
<option value="ASC" ' . ($topnews_conf['sort'] == "ASC" ? "selected" : "") . '>' . $lang['sort_asc'] . '</option>
<option value="DESC" ' . ($topnews_conf['sort'] == "DESC" ? "selected" : "") . '>' . $lang['sort_desc'] . '</option>
</select>';
}