<?php

/*
  * @name        JMY CMS
  * @link        https://jmy.su/
  * @copyright   Copyright (C) 2012-2025 JMY LTD
  * @license     LICENSE.txt (see attached file)
  * @version     VERSION.txt (see attached file)
  * @author      Orlov Alexsey
  */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfigBLOCK('friends');
global $db, $core, $config, $user, $lang, $smiles, $friends_conf;
$core->loadblockLang('friends');
$abridged = '';
$query = $db->query("SELECT * FROM `" . USER_DB . "`.`" . USER_PREFIX . "_users` as u LEFT JOIN `" . USER_DB . "`.`" . USER_PREFIX . "_user_friends` as f on(u.id = f.who_invite OR u.id = f.whom_invite) WHERE (f.who_invite = '" . $core->auth->user_id . "' OR f.whom_invite = '" . $core->auth->user_id . "') AND u.id != '" . $core->auth->user_id . "' AND f.confirmed = '1' LIMIT " . $friends_conf['num'] . "");
if ($friends_conf['on']) {
    if ($db->numRows($query) > 0) {
        while ($rows = $db->getRow($query)) {
            if (!empty($core->auth->user_id) && $user['userFriends'] == 1) {
                if ($friends_conf['old']) {
                    echo '<div class="main-friends-top">
   <div class="main-friends-image">
      <img src="' . avatar($rows['id']) . '" alt="">
      <div class="main-friends-author">
         <a href="profile/' . $rows['nick'] . '" title="' . $lang['friends_friends_page'] . $rows['nick'] . '">' . $rows['nick'] . '</a>
      </div>
   </div>
</div>
<br/>';
                } else {
                    $geoip = geo_ip::getInstance(ROOT . 'media/geo_ip.dat');
                    $flag = $geoip->lookupCountryCode(!empty($rows['ip']) ? $rows['ip'] : '127.0.0.1');
                    foreach ($smiles as $tag => $param) {
                        if ($param['cat'] == 'flags') {
                            $saurl = str_replace($config['url'] . '/', '', $param['url']);
                            $surl = $param['url'] > 30 ? $param['url'] . '' : internoetics_mb_strimwidthd($saurl, 0, 36, $trimmarker = '...') . '';
                            $abridged = isset($param['abridged']) ? ' ( ' . $param['abridged'] . ' )' : '';
                            if ($flag == $param['abridged']) $url_flags = '<img src="' . $param['url'] . '" title="' . $param['title'] . $abridged . ' " class="img-responsive mw30 ib br4" style="border:0" alt=""/>';
                        } else {
                            $url_flags = '';
                        }
                    }
                    $uflag = ($flag != 'UN') ? $url_flags : '<img src="media/smiles/flags/UN.png" style="border:0" class="img-responsive mw30 ib br4"  title="' . $lang['undefined'] . '" alt="" />';
                    $core->tpl->loadFile('blocks/friends');
                    $core->tpl->setVar('UID', $rows['id']);
                    $core->tpl->setVar('AVATAR', avatar($rows['id']));
                    $core->tpl->setVar('NICK', $rows['nick']);
                    $core->tpl->setVar('SURNAME', $rows['surname']);
                    $core->tpl->setVar('CARMA', ($rows['carma'] > 0) ? '+' . $rows['carma'] : $rows['carma']);
                    $core->tpl->setVar('NAME', $rows['name']);
                    $core->tpl->setVar('USER_URL', 'profile/' . $rows['nick'] . '"');
                    $core->tpl->setVar('USER_IP', (!empty($rows['ip']) ? $rows['ip'] : '127.0.0.1'));
                    $core->tpl->setVar('POINTS', $rows['points']);
                    $core->tpl->setVar('COUNTRICON', $uflag);
                    $core->tpl->setVar('COUNTRY', $rows['place']);
                    $core->tpl->setVar('ICQ', $rows['icq'] ?? $lang['unspecif']);
                    $core->tpl->setVar('SKYPE', $rows['skype'] ?? $lang['unspecif']);
                    $core->tpl->setVar('HOBBY', $rows['hobby'] ?? $lang['unspecif']);
                    $core->tpl->setVar('SIGNATURE', $rows['signature'] ? stripslashes($core->bbDecode(html2bb(parseBB($rows['signature'])))) : $lang['unspecif']);
                    $core->tpl->setVar('SEX', $rows['sex'] ? ($rows['sex'] == 1 ? $lang['male'] : $lang['female']) : $lang['unspecified']);
                    $core->tpl->setVar('LASTVIZIT', formatDate($rows['last_visit'], true));
                    $core->tpl->setVar('OTCH', $rows['ochestvo'] ?? '');
                    $core->tpl->setVar('AGE', $rows['age'] ?? $lang['unspecif']);
                    $core->tpl->setVar('BLOG_READ', $user['readBlog'] == 1 ? ($core->checkModule('blog') ? $readBlog : '') : '');
                    $core->tpl->setVar('REGDATE', formatDate($rows['regdate'], true));
                    $core->tpl->setVar('TIMEZONES', $rows['timezones'] ?? $lang['unspecified']);
                    $core->tpl->setVar('URL_INBOX', '<a href="profile/friends_inbox">');
                    $core->tpl->setVar('URL_OUTBOX', '<a href="profile/friends_outbox">');
                    $core->tpl->end();
                }
            }
        }
    } else {
        $core->tpl->info($lang['friends_list_empty']);
    }
} else {
    if ($friends_conf['info_off']) $core->tpl->info($lang['friends_off']);
}
