<?php

/*
 * @name        JMY CMS
 * @link        https://jmy.su/
 * @copyright   Copyright (C) 2012-2025 JMY LTD
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      Komarov Ivan
 * @edited      Orlov Alexsey
 */

if (!defined('ACCESS')) {
    header('Location: /');
    exit;
}
loadConfigBLOCK('guest');
global $db, $core, $lang, $guest_conf;
$core->loadblockLang('guest');
if ($guest_conf['on']) {
    $query = $core->select_data('guestbook', 'active = 1', 'id DESC LIMIT ' . $guest_conf['num']);
    $i = 0;
    if ($db->numRows($query) > 0) {
        while ($row = $db->getRow($query)) {
            $rows = $core->row_data('users', 'email = "' . $row['email'] . '"');
            $i++;
            if (!empty($rows['nick'])) $onn[] = '<a href="profile/' . $rows['nick'] . '" >' . $rows['nick'] . '</a>';
            if ($guest_conf['old']) {
                echo '<img src="' . avatar($rows['id']) . '"><br/>
<a href="/guestbook/"><strong>' . $row['name'] . ' ' . $lang['writes'] . '</strong> ' . $row['comment'] . '</a>
<div class="date-like-comment">
   <span class="date"><time datetime="2014-02-17">' . formatDate($row['date'], true) . '</time></span></br>
   <a class="comments" href="/guestbook/"><i class="fa fa-check"></i> ' . (!empty($row['reply']) ? $lang['reply_1'] : $lang['reply_0']) . '</a></br>
   <a class="like" href="mailto:' . $row['email'] . '"><i class="fa fa-envelope"></i> ' . $lang['author_email'] . '</a></br>
   <a class="like" href="' . $row['website'] . '" target="blank"><i class="fa fa-globe"></i> ' . $lang['author_website'] . (!empty($guestbook['website']) ? $row['website'] : $lang['guestbook_not_website']) . ' </a></br></br>
</div>';
            } else {
                $core->tpl->loadFile('blocks/guestbook');
                $core->tpl->setVar('ID', $row['id']);
                $core->tpl->setVar('AVATAR', avatar($rows['id']));
                $core->tpl->setVar('AUTHOR', $row['name']);
                $core->tpl->setVar('COMMENT', $row['comment']);
                $core->tpl->setVar('DATE', formatDate($row['date'], true));
                $core->tpl->setVar('REPLY_FLAG', (!empty($guestbook['reply']) ? $lang['reply_1'] : $lang['reply_0']));
                $core->tpl->setVar('WEBSITE', (!empty($guestbook['website']) ? $row['website'] : $lang['guestbook_not_website']));
                $core->tpl->setVar('NUMB_ONLINE', ($i == 0 ? ($core->auth->isUser ? 1 : 0) : $i));
                $core->tpl->setVar('ONLINE_USER', (empty($onn) ? ($core->auth->isUser ? '<a href="profile/' . $rows['nick'] . '" title="' . $rows['nick'] . '">' . $rows['nick'] . '</a>' : '...') : implode(', ', $onn)));
                $core->tpl->setVar('USER_URL', 'profile/' . $rows['nick'] . '"');
                $core->tpl->setVar('REPLY_URL', $core->auth->isAdmin ? ADMIN . '/module/guestbook/reply/' . $row['id'] . '/' : '');
                $core->tpl->setVar('EMAIL', $row['email']);
                $core->tpl->setVar('ONLINE', ($core->isOnline($rows['id']) ? $lang['online'] : formatDate($rows['last_visit'], true)));
                $core->tpl->setVar('OFFLINE', ($core->isOffline($rows['id']) ? $lang['offline'] : formatDate($rows['last_visit'], true)));
                $core->tpl->sources = preg_replace_callback("#\\[online\\](.*?)\\[/online\\]#is", function ($matches) use ($rows) {
                    if ($rows['last_visit'] + 500 >= time()) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[offline\\](.*?)\\[/offline\\]#is", function ($matches) use ($core, $rows) {
                    if ($core->isOffline($rows['id'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[reply\\](.*?)\\[/reply\\]#is", function ($matches) use ($row) {
                    if (!empty($row['reply'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->sources = preg_replace_callback("#\\[not_reply\\](.*?)\\[/not_reply\\]#is", function ($matches) use ($row) {
                    if (empty($row['reply'])) return $matches[1];
                }, $core->tpl->sources);
                $core->tpl->end();
            }
        }
    } else {
        $core->tpl->info($lang['guestbook_list_empty']);
    }
} else {
    if ($guest_conf['info_off']) $core->tpl->info($lang['guestbook_off']);
}